<?php

//////////////////////////////////////////////////////////////////////////////////////////////////////
function connectDB()
{    
    $db = parse_ini_file("../../lib/datasource.ini");
    $conexion = mysqli_connect($db['ServidorBD'],$db['UsuarioBD'],$db['ClaveBD'],$db['NombreBD']);
    if(!$conexion){
        echo 'Ha sucedido un error inesperado en la conexión de la base de datos';
    }   
    return $conexion;
}

////////////////////////////////////////////////////////////////////////////////////////////////////
function disconnectDB($conexion){
    $close = mysqli_close($conexion);
    if(!$close){
        echo 'Ha sucedido un error inesperado en la desconexión de la base de datos';
    }   
    return $close;
}

////////////////////////////////////////////////////////////////////////////////////////////////////
//// Funciones para Gestionar la Conexion - SELECT
////////////////////////////////////////////////////////////////////////////////////////////////////
function getArraySQL($sql){
    //Creamos la conexión con la función anterior
    $conexion = connectDB();
    //generamos la consulta
    mysqli_set_charset($conexion, "utf8"); //formato de datos utf8
    if(!$result = mysqli_query($conexion, $sql)) die(); //si la conexión cancelar programa
    $rawdata = array(); //creamos un array
    //guardamos en un array multidimensional todos los datos de la consulta
    $i=0;
    while($row = mysqli_fetch_array($result))
    {
        $rawdata[$i] = $row;
        $i++;
    }
    disconnectDB($conexion); //desconectamos la base de datos
    return $rawdata; //devolvemos el array
}


////////////////////////////////////////////////////////////////////////////////////////////////////
//// Funciones para Gestionar la Conexion - SELECCIONAR UNO
////////////////////////////////////////////////////////////////////////////////////////////////////
function SeleccionarUno($sql)
{
    //Creamos la conexión con la función anterior
    $conexion = connectDB();
    //generamos la consulta
    mysqli_set_charset($conexion, "utf8"); //formato de datos utf8
    if(!$result = mysqli_query($conexion, $sql)) die(); //si la conexión cancelar programa
    $rawdata = array(); //creamos un array
    //guardamos en un array multidimensional todos los datos de la consulta
    $i=0;
    $retorno = "";
    if($row = mysqli_fetch_array($result))
    {
        $retorno = $row[0];
        $i++;
    }
    return $retorno; //devolvemos el array
    disconnectDB($conexion); //desconectamos la base de datos    
}

////////////////////////////////////////////////////////////////////////////////////////////////////
//// Funciones para Gestionar la Conexion - INSERT UPDATE DELETE
///////////////////////////////////////////////////////////////////////////////////////////////////
function EjecutarSQL($sql)
{
    //Creamos la conexión con la función anterior
    $conexion = connectDB();
    //generamos la consulta
    mysqli_set_charset($conexion, "utf8"); //formato de datos utf8
    $retorno = mysqli_query($conexion, $sql); //si la conexión cancelar programa
    if(strtoupper(substr($sql,0,6)) == "INSERT")
        $retorno = mysqli_insert_id($conexion);
    disconnectDB($conexion); //desconectamos la base de datos
    return($retorno);
}

//////////////////////////////////////////////////////////////////////////////////////////////////
////  Muestro la DATA en Pantalla
//////////////////////////////////////////////////////////////////////////////////////////////////

try{

    $array = json_decode(file_get_contents('php://input'), true);
 
    $i=0;
    $detalles = "";
    $code = 0;
    $message = "";
    $diaoperativo = ""; $codsucursal = "";

    /// Mensaje de Respuesta 
    $code = 200;
    $message = "Factura Recibida con Exito.";    

    foreach($array as $registros)
    {
        foreach($registros as $producto)
        {
            if($i == 0)
            {
                $docuid       = $producto['docuid'];
                $tipodoc      = $producto['tipodoc'];
                $prefijo      = $producto['prefijo'];
                $numero       = $producto['numero'];
                
                $nomcliente   = strtoupper(trim($producto['nombres']." ".$producto['apellidos']));
                $mailcliente  = strtolower(trim($producto['email']));
                $usuenvia     = strtoupper(trim($producto['usuenvia']));
                $dnicliente   = strtoupper(trim($producto['dni']));

                //// Primero Valido que no esté la Factura POS en la Tabla
                $existe = SeleccionarUno("SELECT estadoactual FROM docuelectronico WHERE tipodocori = '".$tipodoc."' AND prefijoori = '".$prefijo."' AND numeroori = '".$numero."'");

                if($existe == "")
                {
                    $vsql = "INSERT INTO docuelectronico(docuidori,tipodoc,tipodocori,prefijoori,numeroori,nomcliente,mailcliente,usuenvia,estadoactual,jsonfactura,dnicliente) 
                             VALUES('".$docuid."','".$tipodoc."','".$tipodoc."','".$prefijo."','".$numero."','".$nomcliente."','".$mailcliente."','".$usuenvia."','CREA','".json_encode($array)."','".$dnicliente."')";
                    EjecutarSQL($vsql);                  
                }
                else
                {
                    if($existe == "CREA")
                    {
                        $vsql = "UPDATE docuelectronico SET docuidori = '".$docuid."' , tipodocori = '".$tipodoc."', prefijoori = '".$prefijo."', 
                                 numeroori = '".$numero."' , nomcliente = '".$nomcliente."' , dnicliente = '".$dnicliente."', mailcliente = '".$mailcliente."', 
                                 usuenvia  = '".$usuenvia."' , jsonfactura = '".json_encode($array)."' 
                                 WHERE tipodocori = '".$tipodoc."' AND prefijoori = '".$prefijo."' AND numeroori = '".$numero."'";
                        EjecutarSQL($vsql);         
                    }
                    else
                    {
                        /// Mensaje de Respuesta 
                        $code = 400;
                        $message = "Factura ya enviada a la DIAN - No se puede Reemplazar";       
                    }
                }

                //// Next
                $i++;
            }
        }       
    }    

    /// Retorno la respuesta correspondiente
    $response = array("code" => $code , "Mensaje" => $message );
    header('Content-type: application/json; charset=utf-8');
    echo json_encode($response);

} catch (Exception $e) {
    echo 'Excepción capturada: ',  $e->getMessage(), "\n";
}

?>