<?php

include("../../lib/Sistema.php");

/**
 * Clase API del WebService
 * Permite hacer las 4 Actividades Básicas CRUD a la Tabla Productos
 * Desde WebService
 * @author Said Rodriguez
 * @version 2017-01-28
 */

class api
{
	private $db;

	/**
	 * Constructor - Abre una conexion a la Base de Datos
	 *
	 * @param Vacío
	 * @return Conexion a la Base de Datos
	 */
	
	function __construct()
	{
		$clase = new Sistema();
		$this->db = new mysqli($clase->ServidorBD,$clase->UsuarioBD,$clase->ClaveBD,$clase->NombreBD);
	}

	/**
	 * Destructor - close DB connection
	 *
	 * @param Vacío
	 * @return Vacío
	 */

	function __destruct()
	{
		$this->db->close();
	}

	/**
	 * Obtiene un Listado de Productos (Los Primeros 100)
	 *
	 * @param Vacio	 
	 * @return Lista de Productos en Formato JSON
	 */
	function getCatalogoProductos( $urlBase )
	{
		$query = "SELECT 
					productos.productoid AS idproducto,	
					productos.descripcion AS nomproducto,
					FU_Existencia_Producto_Suc( productos.productoid, '50') AS exis,
					(select productosredimir.puntos from productosredimir where productosredimir.productoid =  productos.productoid order by productosredimir.dinero desc limit 1) as puntos,
					(select productosredimir.dinero from productosredimir where productosredimir.productoid =  productos.productoid order by productosredimir.dinero desc limit 1) AS efectivo
				FROM  
					productos
					INNER JOIN productopuntos ON (productos.productoid = productopuntos.productoid)
					INNER JOIN productosxatributo ON (productos.productoid = productosxatributo.productoid)
					INNER JOIN atributosprod ON (productosxatributo.atributoid = atributosprod.atributoid)
				WHERE 
				productosxatributo.atributoid = 19 AND
				productopuntos.puntosredencion IS NOT NULL AND
				productopuntos.efectivoredencion IS NOT NULL 
				GROUP BY
					productos.codigo
				HAVING exis > 0 ORDER BY 2 ASC";

		$list = array();
		$result = $this->db->query($query);
		

		while ( $row = $result->fetch_assoc() )
		{
			$list[] = $row;
		}
		return $list;
	}

	/**
	 * Obtiene los datos completos de un Productp
	 *
	 * @param Id del Producto	 
	 * @return Lista de Datos del Producto en Formato JSON
	 */
    function getDetalleProducto($id)
	{
		sleep(2);//B-) visaje para el spinner de la pagina
		$query = "SELECT 
					productos.productoid AS idproducto,	
					productos.descripcion AS nomproducto,
					productopuntos.efectivoredencion AS efectivo,
					productopuntos.puntosredencion AS puntos,
					FU_Existencia_Producto_Suc( productos.productoid, '50') AS exis,
					productopuntos.descripcion AS detalleprod,
					productosredimir.puntos,
					productosredimir.dinero
				FROM  
					productos
					INNER JOIN productopuntos ON (productos.productoid = productopuntos.productoid)
					INNER JOIN productosxatributo ON (productos.productoid = productosxatributo.productoid)
					INNER JOIN atributosprod ON (productosxatributo.atributoid = atributosprod.atributoid)
					INNER JOIN productosredimir ON ( productos.productoid  =  productosredimir.productoid)
				WHERE 
				productosxatributo.atributoid = 19 AND
				productos.productoid = $id
				ORDER BY 2 ASC";

		$list = array();
		$result = $this->db->query($query);

		while ( $row = $result->fetch_assoc() )
		{
			$list[] = $row;
		}
		return $list;
	}

} /// Fin de la Clase API
