<?php

//////////////////////////////////////////////////////////////////////////////////////////////////////
function connectDB()
{
    $db = parse_ini_file("../../lib/datasource.ini");
    $conexion = mysqli_connect($db['ServidorBD'],$db['UsuarioBD'],$db['ClaveBD'],$db['NombreBD']);
    if(!$conexion){
        echo 'Ha sucedido un error inesperado en la conexión de la base de datos';
    }   
    return $conexion;
}

////////////////////////////////////////////////////////////////////////////////////////////////////
function disconnectDB($conexion){
    $close = mysqli_close($conexion);
    if(!$close){
        echo 'Ha sucedido un error inesperado en la desconexión de la base de datos';
    }   
    return $close;
}

////////////////////////////////////////////////////////////////////////////////////////////////////
//// Funciones para Gestionar la Conexion - SELECT
////////////////////////////////////////////////////////////////////////////////////////////////////
function getArraySQL($sql){
    //Creamos la conexión con la función anterior
    $conexion = connectDB();
    //generamos la consulta
    mysqli_set_charset($conexion, "utf8"); //formato de datos utf8
    if(!$result = mysqli_query($conexion, $sql)) die(); //si la conexión cancelar programa
    $rawdata = array(); //creamos un array
    //guardamos en un array multidimensional todos los datos de la consulta
    $i=0;
    while($row = mysqli_fetch_array($result))
    {
        $rawdata[$i] = $row;
        $i++;
    }
    disconnectDB($conexion); //desconectamos la base de datos
    return $rawdata; //devolvemos el array
}


////////////////////////////////////////////////////////////////////////////////////////////////////
//// Funciones para Gestionar la Conexion - SELECCIONAR UNO
////////////////////////////////////////////////////////////////////////////////////////////////////
function SeleccionarUno($sql)
{
    //Creamos la conexión con la función anterior
    $conexion = connectDB();
    //generamos la consulta
    mysqli_set_charset($conexion, "utf8"); //formato de datos utf8
    if(!$result = mysqli_query($conexion, $sql)) die(); //si la conexión cancelar programa
    $rawdata = array(); //creamos un array
    //guardamos en un array multidimensional todos los datos de la consulta
    $i=0;
    if($row = mysqli_fetch_array($result))
       $retorno = $row[0];
    return $retorno; //devolvemos el array
    disconnectDB($conexion); //desconectamos la base de datos    
}

////////////////////////////////////////////////////////////////////////////////////////////////////
//// Funciones para Gestionar la Conexion - INSERT UPDATE DELETE
///////////////////////////////////////////////////////////////////////////////////////////////////
function EjecutarSQL($sql)
{
    //Creamos la conexión con la función anterior
    $conexion = connectDB();
    //generamos la consulta
    mysqli_set_charset($conexion, "utf8"); //formato de datos utf8
    $retorno = mysqli_query($conexion, $sql); //si la conexión cancelar programa
    if(strtoupper(substr($sql,0,6)) == "INSERT")
        $retorno = mysqli_insert_id($conexion);
    disconnectDB($conexion); //desconectamos la base de datos
    return($retorno);
}

//////////////////////////////////////////////////////////////////////////////////////////////////
////  Muestro la DATA en Pantalla
//////////////////////////////////////////////////////////////////////////////////////////////////
$bodidorigen = $_GET['origen'];

///// Primero elimino lo viejo
//$sql = "DELETE FROM pedidocruce WHERE docuidservidor IS NULL AND fechadoc <= (curdate()-interval 5 day)";
//EjecutarSQL($sql);

//// Retorno las autorizaciones pendientes
$vsql = "SELECT B2.bodegaid , B.nomcorto bodorigen , B2.codbodega , B2.nombodega , PC.* , 
         (SELECT CONCAT(nombres,' ',apellidos) FROM terceros WHERE codvende = PC.codvende OR coddomi = PC.codvende LIMIT 0,1) empleado 
         FROM pedidocruce PC 
         INNER JOIN bodegas B ON (B.bodegaid = PC.bodegaorigen)
         INNER JOIN bodegas B2 ON (B2.bodegaid = PC.bodegadestino)
         WHERE PC.eliminado IS NULL AND PC.documentofinal IS NULL AND B.bodegaid = '".$bodidorigen."' AND docuidservidor IS NULL AND PC.fechadoc > (curdate()-interval 5 day)
         ORDER BY PC.fechadoc DESC LIMIT 0,300";      

$data = getArraySQL($vsql);
if($data)
{
    $code = 200;
    $message = "Datos del Usuario Exitosos";    
}
else
{
    $code = 400;
    $message = "No existen datos de la Persona";
}

header('Content-type: application/json; charset=utf-8');
echo json_encode($data);
?>