<?php

include("../../lib/Sistema.php");

/**
 * Clase API del WebService
 * Permite hacer las 4 Actividades Básicas CRUD a la Tabla Transferencias
 * Desde WebService
 * @author Said Rodriguez
 * @version 2017-02-14
 */

class api
{
	private $db;

	/**
	 * Constructor - Abre una conexion a la Base de Datos
	 *
	 * @param Vacío
	 * @return Conexion a la Base de Datos
	 */
	
	function __construct()
	{
		$clase = new Sistema();
		$this->db = new mysqli($clase->ServidorBD,$clase->UsuarioBD,$clase->ClaveBD,$clase->NombreBD);
	}

	/**
	 * Destructor - close DB connection
	 *
	 * @param Vacío
	 * @return Vacío
	 */

	function __destruct()
	{
		$this->db->close();
	}

	/**
	 * Obtiene un Listado de Transferencias (Las Ultimas 200)
	 *
	 * @param Vacio	 
	 * @return Lista de Transferencias en Formato JSON
	 */
	function getVentaActual()
	{
		$diaoperativo = date("d/m/Y");
		$query="SELECT DV.diaoperativo , CONCAT(T2.nombres,' ',T2.apellidos) vendedor , SUM( total ) vtageneral ,
               (
                SELECT SUM(DD2.valtotal) FROM documentos D2 INNER JOIN docuventa DV2 ON (D2.docuid = DV2.docuid) INNER JOIN dedocumentos DD2 ON (D2.docuid = DD2.docuid)                
                INNER JOIN productos P2 ON (P2.productoid = DD2.productoid) 
                WHERE D2.fecanulado = '0000-00-00' AND D2.terid2 = T2.terid AND P2.porcenboni > 0 AND DV2.diaoperativo = DV.diaoperativo
               ) vtaespecial ,
               (
                  SELECT SUM(DD3.cantidad) FROM dedocumentos DD3 INNER JOIN productos P3 ON (P3.productoid = DD3.productoid)
                  INNER JOIN docuventa DV3 ON (DD3.docuid = DV3.docuid)
                  INNER JOIN documentos D3 ON (DD3.docuid = D3.docuid)
                  WHERE P3.descripcion LIKE 'SURE%ZINC%' AND T2.terid = D3.terid2 AND DV3.diaoperativo = '".$diaoperativo."'
               ) surezinc            
               FROM documentos D INNER JOIN docuventa DV ON ( D.docuid = DV.docuid ) INNER JOIN terceros T2 ON (T2.terid = D.terid2) 
               WHERE D.tipodoc =  'FVE' AND D.fecasentado <>  '0000-00-00' AND D.fecanulado =  '0000-00-00' AND DV.diaoperativo = '".$diaoperativo."' GROUP BY 1,2 ORDER BY 2 DESC";

		$list = array();
		$result = $this->db->query($query);
		while ($row = $result->fetch_assoc())
		{
			$list[] = $row;
		}
		return $list;
	}

	
} /// Fin de la Clase API
