<?php

include("../../lib/Sistema.php");

/**
 * Clase API del WebService
 * Permite hacer las 4 Actividades Básicas CRUD a la Tabla Transferencias
 * Desde WebService
 * @author Said Rodriguez
 * @version 2017-01-30
 */

class api
{
	private $db;

	/**
	 * Constructor - Abre una conexion a la Base de Datos
	 *
	 * @param Vacío
	 * @return Conexion a la Base de Datos
	 */
	
	function __construct()
	{
		$clase = new Sistema();
		$this->db = new mysqli($clase->ServidorBD,$clase->UsuarioBD,$clase->ClaveBD,$clase->NombreBD);
	}

	/**
	 * Destructor - close DB connection
	 *
	 * @param Vacío
	 * @return Vacío
	 */

	function __destruct()
	{
		$this->db->close();
	}

	/**
	 * Obtiene un Listado de Transferencias (Las Ultimas 200)
	 *
	 * @param Vacio	 
	 * @return Lista de Transferencias en Formato JSON
	 */
	function getListaMensajeros()
	{
		$query = "SELECT * FROM terceros WHERE (codvende <> '' OR coddomi <> '') AND CAST(codvende AS INTEGER) > 4500 ORDER BY ultcambio DESC LIMIT 0,300";
		$list = array();
		$result = $this->db->query($query);
		while ($row = $result->fetch_assoc())
		{
			$list[] = $row;
		}
		
		return $list;
	}

	

} /// Fin de la Clase API
