<?php

error_reporting(E_ALL);
ini_set('display_errors', FALSE);
ini_set('display_startup_errors', FALSE);

//////////////////////////////////////////////////////////////////////////////////////////////////////
function connectDB()
{
    $db = parse_ini_file("../../../lib/datasource.ini");
    //echo $db['ServidorBD'];
    $conexion = mysqli_connect($db['ServidorBD'],$db['UsuarioBD'],$db['ClaveBD'],$db['NombreBD']);
    if(!$conexion){
        echo 'Ha sucedido un error inesperado en la conexión de la base de datos';
    }   
    return $conexion;
}

////////////////////////////////////////////////////////////////////////////////////////////////////
function disconnectDB($conexion){
    $close = mysqli_close($conexion);
    if(!$close){
        echo 'Ha sucedido un error inesperado en la desconexión de la base de datos';
    }   
    return $close;
}

////////////////////////////////////////////////////////////////////////////////////////////////////
//// Funciones para Gestionar la Conexion - SELECT
////////////////////////////////////////////////////////////////////////////////////////////////////
function getArraySQL($sql){
    //Creamos la conexión con la función anterior
    $conexion = connectDB();
    //generamos la consulta
    mysqli_set_charset($conexion, "utf8"); //formato de datos utf8
    if(!$result = mysqli_query($conexion, $sql)) die(); //si la conexión cancelar programa
    $rawdata = array(); //creamos un array
    //guardamos en un array multidimensional todos los datos de la consulta
    $i=0;
    while($row = mysqli_fetch_array($result))
    {
        $rawdata[$i] = $row;
        $i++;
    }
    disconnectDB($conexion); //desconectamos la base de datos
    return $rawdata; //devolvemos el array
}


////////////////////////////////////////////////////////////////////////////////////////////////////
//// Funciones para Gestionar la Conexion - SELECCIONAR UNO
////////////////////////////////////////////////////////////////////////////////////////////////////
function SeleccionarUno($sql)
{
    //Creamos la conexión con la función anterior
    $conexion = connectDB();
    //generamos la consulta
    mysqli_set_charset($conexion, "utf8"); //formato de datos utf8
    if(!$result = mysqli_query($conexion, $sql)) die(); //si la conexión cancelar programa
    $rawdata = array(); //creamos un array
    //guardamos en un array multidimensional todos los datos de la consulta
    $i=0;
    if($row = mysqli_fetch_array($result))
       $retorno = $row[0];
    return $retorno; //devolvemos el array
    disconnectDB($conexion); //desconectamos la base de datos    
}

////////////////////////////////////////////////////////////////////////////////////////////////////
//// Funciones para Gestionar la Conexion - INSERT UPDATE DELETE
///////////////////////////////////////////////////////////////////////////////////////////////////
function EjecutarSQL($sql)
{
    //Creamos la conexión con la función anterior
    $conexion = connectDB();
    //generamos la consulta
    mysqli_set_charset($conexion, "utf8"); //formato de datos utf8
    $retorno = mysqli_query($conexion, $sql); //si la conexión cancelar programa
    if(strtoupper(substr($sql,0,6)) == "INSERT")
        $retorno = mysqli_insert_id($conexion);
    disconnectDB($conexion); //desconectamos la base de datos
    return($retorno);
}

//////////////////////////////////////////////////////////////////////////////////////////////////
////  Muestro la DATA en Pantalla
//////////////////////////////////////////////////////////////////////////////////////////////////
$data = "";

///// Registro el Uso de la API
$urlapi = $_SERVER['PHP_SELF'];
$vsql = "INSERT INTO estadisticasconsumosapi(urlapi,momento) VALUES('".$urlapi."',CURRENT_TIMESTAMP)";
EjecutarSQL($vsql);

/// Capturo el Periodo
$periodo = $_GET['periodo'];

//// Busco la DATA
if($periodo != "")
{
     $codbodega  = SeleccionarUno("SELECT contenido FROM configuraciones WHERE variab = 'G_BODEGAPREDETPOS'"); 
     $bodegaid   = SeleccionarUno("SELECT bodegaid FROM bodegas WHERE codbodega = '".$codbodega."'");
	 $sucursalid = SeleccionarUno("SELECT sucursalid FROM bodegas WHERE bodegaid = ".$bodegaid);

	 $vsql =  "SELECT DISTINCT D.id , P.precio1m , P.porcenboni , E.cantidad exireal , D.productoid , D.codigo , D.descripcion , D.laboratorio , D.r150 , D.devolver ,
    					(SELECT DATEDIFF(CURRENT_DATE,MAX(fechadoc)) FROM kardex WHERE tipodoc = 'TRB' AND productoid = P.productoid AND bodegaid = ".$bodegaid." AND cantidad > 0 HAVING MAX(fechadoc) ORDER BY fechadoc DESC) ultimoingreso , 
						(SELECT ABS( ROUND( SUM( cantidad ) ) ) FROM kardex WHERE tipodoc = 'TRB' AND productoid = P.productoid AND bodegaid = ".$bodegaid." AND cantidad > 0 AND DATE_SUB( NOW( ) , INTERVAL 90 DAY ) <= fechadoc) entradaultimos90dias , 
						(SELECT minimo FROM minimospersonalizados WHERE tipo = 'todas' AND productoid = P.productoid AND fechahasta > CURRENT_DATE LIMIT 0,1) tieneminimo1 ,  							
		                (SELECT minimo FROM minimospersonalizados WHERE (tipo = 'por drogueria' OR tipo = 'exhibicion') AND sucursalid = ".$sucursalid." AND productoid = P.productoid AND fechahasta > CURRENT_DATE LIMIT 0,1) tieneminimo2 
                         FROM devolucionexcesos D 
						INNER JOIN productos P ON (D.productoid = P.productoid)
						INNER JOIN gruposprod GP ON (GP.gruposprodid = P.gruposprodid)			
						INNER JOIN existencias E ON (E.productoid = P.productoid) 
						INNER JOIN bodegas B ON (B.bodegaid = E.bodegaid AND B.bodegaid = ".$bodegaid.")
						WHERE D.periodo = '".$periodo."' AND devolver > 0 AND COALESCE(GP.nodevolverexceso,'') = '' AND P.productoid NOT IN (SELECT productoid FROM excluirexcesos) 
						AND GP.gruposprodid NOT IN (SELECT gruposprodid FROM excluirexcesos) 
						ORDER BY D.laboratorio , D.descripcion";
     // echo $vsql; exit;
     $data = getArraySQL($vsql);
}
else
{
    $code = 400;
    $data = "Periodo es un campo requerido";
}


header('Content-type: application/json; charset=utf-8');
echo json_encode($data);
?>