<?php
include("../../../lib/Sistema.php");

//////////////////////////////////////////////////////////////////////////////////////////////////////
function connectDB(){
    $clase = new Sistema();
    $conexion = mysqli_connect($clase->ServidorBD,$clase->UsuarioBD,$clase->ClaveBD,$clase->NombreBD);
    if(!$conexion){
        echo 'Ha sucedido un error inesperado en la conexión de la base de datos';
    }   
    return $conexion;
}

////////////////////////////////////////////////////////////////////////////////////////////////////
function disconnectDB($conexion){
    $close = mysqli_close($conexion);
    if(!$close){
        echo 'Ha sucedido un error inesperado en la desconexión de la base de datos';
    }   
    return $close;
}

////////////////////////////////////////////////////////////////////////////////////////////////////
//// Funciones para Gestionar la Conexion
////////////////////////////////////////////////////////////////////////////////////////////////////o
function getArraySQL($sql){
    //Creamos la conexión con la función anterior
    $conexion = connectDB();
    //generamos la consulta
    mysqli_set_charset($conexion, "utf8"); //formato de datos utf8
    if(!$result = mysqli_query($conexion, $sql)) die(); //si la conexión cancelar programa
    $rawdata = array(); //creamos un array
    //guardamos en un array multidimensional todos los datos de la consulta
    $i=0;
    while($row = mysqli_fetch_array($result))
    {
        $rawdata[$i] = $row;
        $i++;
    }
    disconnectDB($conexion); //desconectamos la base de datos
    return $rawdata; //devolvemos el array
}

$limit = (isset($_GET['limit']) && $_GET['limit']) ? $_GET['limit'] : '';

$fecha_actual = date("Y-m-d");
$fecha15diasantes = date("Y-m-d",strtotime($fecha_actual."- 15 days"));

$sql = "SELECT OC.*, (DD.cantidad + DDO.obsequio) cantidad , P.productoid , P.codigo, OC.sucursalid  
        FROM documentos OC 
        INNER JOIN dedocumentos DD ON (OC.docuid = DD.docuid)				
        INNER JOIN productos P ON (P.productoid = DD.productoid) 
		LEFT JOIN dedocuorden DDO ON (DD.dedocumid = DDO.dedocumid) 
        WHERE OC.tipodoc = 'PCO' AND OC.fechadoc >=  '".$fecha15diasantes."'  AND OC.fecasentado <> '0000-00-00' AND OC.docuid NOT IN (SELECT docuid2 FROM docuself)  
        UNION
        SELECT OC.*, (DD.cantidad + DDO.obsequio) cantidad , P.productoid , P.codigo, OC.sucursalid 
        FROM documentos OC 
        INNER JOIN docuself DS ON (OC.docuid = DS.docuid2)
        INNER JOIN documentos COM ON (COM.docuid = DS.docuid AND COM.observacion2 <> 'KARDEX')  
        INNER JOIN dedocumentos DD ON (OC.docuid = DD.docuid)
		LEFT JOIN dedocuorden DDO ON (DD.dedocumid = DDO.dedocumid) 
        INNER JOIN productos P ON (P.productoid = DD.productoid) 
        WHERE OC.tipodoc = 'PCO' AND COM.tipodoc = 'FCO' AND OC.fechadoc >= '".$fecha15diasantes."' AND OC.fecasentado <> '0000-00-00' 
        AND (COM.fecasentado = '0000-00-00' AND COM.observacion2 <> 'KARDEX')
        LIMIT ".$limit;
$myArray = getArraySQL($sql);

//echo $sql; exit;
/// Salida al Navegador
header('Content-type: application/json; charset=utf-8');
echo json_encode($myArray);
?>