<?php
include("../../lib/Sistema.php");

//////////////////////////////////////////////////////////////////////////////////////////////////////
function connectDB(){
    $clase = new Sistema();
    $conexion = mysqli_connect($clase->ServidorBD,$clase->UsuarioBD,$clase->ClaveBD,$clase->NombreBD);
    if(!$conexion){
        echo 'Ha sucedido un error inesperado en la conexión de la base de datos';
    }   
    return $conexion;
}

////////////////////////////////////////////////////////////////////////////////////////////////////
function disconnectDB($conexion){
    $close = mysqli_close($conexion);
    if(!$close){
        echo 'Ha sucedido un error inesperado en la desconexión de la base de datos';
    }   
    return $close;
}

////////////////////////////////////////////////////////////////////////////////////////////////////
//// Funciones para Gestionar la Conexion
////////////////////////////////////////////////////////////////////////////////////////////////////o
function getArraySQL($sql){
    //Creamos la conexión con la función anterior
    $conexion = connectDB();
    //generamos la consulta
    mysqli_set_charset($conexion, "utf8"); //formato de datos utf8
    if(!$result = mysqli_query($conexion, $sql)) die(); //si la conexión cancelar programa
    $rawdata = array(); //creamos un array
    //guardamos en un array multidimensional todos los datos de la consulta
    $i=0;
    while($row = mysqli_fetch_array($result))
    {
        $rawdata[$i] = $row;
        $i++;
    }
    disconnectDB($conexion); //desconectamos la base de datos
    return $rawdata; //devolvemos el array
}

////////////////////////////////////////////////////////////////////////////////////////////////////
//// Funciones para Gestionar la Conexion - INSERT UPDATE DELETE
///////////////////////////////////////////////////////////////////////////////////////////////////
function EjecutarSQL($sql)
{
    //Creamos la conexión con la función anterior
    $conexion = connectDB();
    //generamos la consulta
    mysqli_set_charset($conexion, "utf8"); //formato de datos utf8
    $retorno = mysqli_query($conexion, $sql); //si la conexión cancelar programa
    if(strtoupper(substr($sql,0,6)) == "INSERT")
        $retorno = mysqli_insert_id($conexion);
    disconnectDB($conexion); //desconectamos la base de datos
    return($retorno);
}

////////////////////////////////////////////////////////////////////////////////////////////////////
//// Funciones para Gestionar la Conexion - SELECCIONAR UNO
////////////////////////////////////////////////////////////////////////////////////////////////////
function SeleccionarUno($sql)
{
    //Creamos la conexión con la función anterior
    $conexion = connectDB();
    //generamos la consulta
    mysqli_set_charset($conexion, "utf8"); //formato de datos utf8
    if(!$result = mysqli_query($conexion, $sql)) die(); //si la conexión cancelar programa
    $rawdata = array(); //creamos un array
    //guardamos en un array multidimensional todos los datos de la consulta
    $i=0;
    $retorno = "";
    if($row = mysqli_fetch_array($result))
    {
        $retorno = $row[0];
        $i++;
    }
    return $retorno; //devolvemos el array
    disconnectDB($conexion); //desconectamos la base de datos    
}

    //////////////////////////////////////////////////////////////////////////////////////////////////
    ////  Muestro la DATA en Pantalla
    //////////////////////////////////////////////////////////////////////////////////////////////////
    $sucursal  =  $_GET['sucursal'];

    if($sucursal == "")
    {
        /// Salida al Navegador
        header('Access-Control-Allow-Origin: *');
        header('Content-type: application/json; charset=utf-8');
        echo json_encode("El Parametro Sucursal es Obligatorio");
    }
    else
    {
        $regionsuc = SeleccionarUno("SELECT Z.codregion FROM zonas Z INNER JOIN sucursales S ON (S.zona = Z.codzona) WHERE S.codigo = '".$sucursal."'");
    
        if($regionsuc == "01")  $prefijo = 'NOR';
        if($regionsuc == "02")  $prefijo = 'ATL';
        if($regionsuc == "03")  $prefijo = 'SAN';
        if($regionsuc == "04")  $prefijo = 'ANT';
    
        if($prefijo == "")
        {
            $retorno = "Prefijo NO configurado o Sucursal no Tiene una Regional Valida";  
    
            /// Salida al Navegador
            header('Access-Control-Allow-Origin: *');
            header('Content-type: application/json; charset=utf-8');
            echo json_encode($retorno);
        }
        else
        {
            /// Busco el Consecutivo Actual
            $consecutivo = SeleccionarUno("SELECT numero FROM consecutivos WHERE tipodoc = 'PVE' AND prefijo = '".$prefijo."'");
    
            /// Preparo la Consulta de retorno
            $sql = "SELECT prefijo , numero FROM consecutivos WHERE tipodoc = 'PVE' AND prefijo = '".$prefijo."'";
            $myArray = getArraySQL($sql);
    
            /// Paso al Siguiente
            $consecutivo = $consecutivo+1;
            $consecutivo = str_pad($consecutivo, 5 , "0", STR_PAD_LEFT);
            EjecutarSQL("UPDATE consecutivos SET numero = '".$consecutivo."' WHERE tipodoc = 'PVE' AND prefijo = '".$prefijo."'");
        
            /// Salida al Navegador
            header('Access-Control-Allow-Origin: *');
            header('Content-type: application/json; charset=utf-8');
            echo json_encode($myArray);
        }
    }
?>