<?php

//////////////////////////////////////////////////////////////////////////////////////////////////////
function connectDB()
{
    $db = parse_ini_file("../../lib/datasource.ini");
    $conexion = mysqli_connect($db['ServidorBD'],$db['UsuarioBD'],$db['ClaveBD'],$db['NombreBD']);
    if(!$conexion){
        echo 'Ha sucedido un error inesperado en la conexión de la base de datos';
    }   
    return $conexion;
}

////////////////////////////////////////////////////////////////////////////////////////////////////
function disconnectDB($conexion){
    $close = mysqli_close($conexion);
    if(!$close){
        echo 'Ha sucedido un error inesperado en la desconexión de la base de datos';
    }   
    return $close;
}

////////////////////////////////////////////////////////////////////////////////////////////////////
//// Funciones para Gestionar la Conexion - SELECT
////////////////////////////////////////////////////////////////////////////////////////////////////
function getArraySQL($sql){
    //Creamos la conexión con la función anterior
    $conexion = connectDB();
    //generamos la consulta
    mysqli_set_charset($conexion, "utf8"); //formato de datos utf8
    if(!$result = mysqli_query($conexion, $sql)) die(); //si la conexión cancelar programa
    $rawdata = array(); //creamos un array
    //guardamos en un array multidimensional todos los datos de la consulta
    $i=0;
    while($row = mysqli_fetch_array($result))
    {
        $rawdata[$i] = $row;
        $i++;
    }
    disconnectDB($conexion); //desconectamos la base de datos
    return $rawdata; //devolvemos el array
}


////////////////////////////////////////////////////////////////////////////////////////////////////
//// Funciones para Gestionar la Conexion - SELECCIONAR UNO
////////////////////////////////////////////////////////////////////////////////////////////////////
function SeleccionarUno($sql)
{
    //Creamos la conexión con la función anterior
    $conexion = connectDB();
    //generamos la consulta
    mysqli_set_charset($conexion, "utf8"); //formato de datos utf8
    if(!$result = mysqli_query($conexion, $sql)) die(); //si la conexión cancelar programa
    $rawdata = array(); //creamos un array
    //guardamos en un array multidimensional todos los datos de la consulta
    $i=0;
    if($row = mysqli_fetch_array($result))
       $retorno = $row[0];
    return $retorno; //devolvemos el array
    disconnectDB($conexion); //desconectamos la base de datos    
}

////////////////////////////////////////////////////////////////////////////////////////////////////
//// Funciones para Gestionar la Conexion - INSERT UPDATE DELETE
///////////////////////////////////////////////////////////////////////////////////////////////////
function EjecutarSQL($sql)
{
    //Creamos la conexión con la función anterior
    $conexion = connectDB();
    //generamos la consulta
    mysqli_set_charset($conexion, "utf8"); //formato de datos utf8
    $retorno = mysqli_query($conexion, $sql); //si la conexión cancelar programa
    if(strtoupper(substr($sql,0,6)) == "INSERT")
        $retorno = mysqli_insert_id($conexion);
    disconnectDB($conexion); //desconectamos la base de datos
    return($retorno);
}

//////////////////////////////////////////////////////////////////////////////////////////////////
////  Muestro la DATA en Pantalla
//////////////////////////////////////////////////////////////////////////////////////////////////
$sucursal = $_GET['sucursal'];
$vsql = "SELECT S.descripcion nomsucursal , CA.descripcion nomconcepto , CA.tipogasto , A.* , 
        (SELECT CONCAT(nombres,' ',apellidos) FROM terceros WHERE dni = A.proveedor) nomproveedor ,  
        (SELECT filename FROM archivodigital WHERE archivoid = A.archivoid) archivo ,      
        (SELECT CONCAT(nombres,' ',apellidos) FROM terceros WHERE A.codfuncionario <> '0' AND ( codvende = A.codfuncionario OR coddomi = A.codfuncionario ) LIMIT 0,1) funcionario    
        FROM autorizacionesgastos A
        INNER JOIN sucursales S ON (A.codsucursal = S.codigo)
        LEFT JOIN conceptosgastos CA ON (A.codconcepto = CA.codigo)
        WHERE A.codsucursal = '".$sucursal."' AND A.momento > '2020-09-28 00:00:00' AND A.autorizado = 'CHECKED' AND (A.diaoperativo = '' OR A.diaoperativo IS NULL) ORDER BY A.autorizaid DESC LIMIT 0,100";      
$data = getArraySQL($vsql);
if($data)
{
    $code = 200;
    $message = "Datos del Usuario Exitosos";    
}
else
{
    $code = 400;
    $message = "No existen datos de la Persona";
}

header('Content-type: application/json; charset=utf-8');
echo json_encode($data);
?>