<?PHP
 include("libgeneral.php");
 include("FirebirdLib.php");
 session_start();
 
 class Sistema
 {
	 /*
	 *  Copyright (C) 2015
	 *  Ing. Said Rodriguez (http://www.swebcolombia.com)
	 *  Changes to Version 0.8.1 copyright (C) 2015
	 *	
	 *  This program is free software: you can redistribute it and/or modify
	 *  it under the terms of the GNU General Public License as published by
	 *  the Free Software Foundation, either version 3 of the License, or
	 *  (at your option) any later version.
	 *
	 *  This program is distributed in the hope that it will be useful,
	 * 	but WITHOUT ANY WARRANTY; without even the implied warranty of
	 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
	 *  GNU General Public License for more details.
	 *	
	 *  You should have received a copy of the GNU General Public License
	 *  along with this program.  If not, see <http://www.gnu.org/licenses/>.
	*/
	// MySQL Class v0.8.1 del 15 Abril 2015

    public $UsuarioBD;
    public $ClaveBD;
	  public $ServidorBD;
    public $NombreBD;		
    public $URLSitio;		
	
	  private $Conex;             // Database Connection Link
	  public  $lastError;         // Holds the last error
	  public  $lastQuery;         // Ultimo Query
  	public  $result;            // Holds the MySQL query result
  	public  $records;           // Holds the total number of records returned
	  public  $affected;          // Holds the total number of records affected
	  public  $rawResults;        // Holds raw 'arrayed' results
	  public  $arrayedResult;     // Holds an array of the result	

	////////////////////////////////////////////////
	//  * Class Constructor *
	////////////////////////////////////////////////
	function __construct($hostname='localhost', $port=3306, $persistant = false)
	{
     $this->UsuarioBD  = "root";
	   $this->ClaveBD    = "d2218aa6664195";

	   $archivo  = "C:\\appserv\\www\\nombredb.txt"; 
	   $archivo1 = "C:\\xampp\\htdocs\\nombredb.txt"; 
	   $archivo2 = "C:\\appserv\\www\\dropos\\lib\\nombredb.txt"; 
	   $archivo3 = "C:\\xampp\\htdocs\\dropos\\lib\\nombredb.txt"; 
	   
	   if(file_exists($archivo)||file_exists($archivo1)||file_exists($archivo2)||file_exists($archivo3))
	   {
         if(file_exists($archivo))
		 {
		   $fch= fopen($archivo, "r"); // Abres el archivo para escribir en él
           $this->NombreBD = fread($fch, 1024);
		   fclose($fch); // Cierras el archivo
	     }

		 if($this->NombreBD == "")
	     {
           $fch= fopen($archivo1, "r"); // Abres el archivo para escribir en él
           $this->NombreBD = fread($fch, 1024);	   
		   fclose($fch); // Cierras el archivo
	     }	     
		 
		 if($this->NombreBD == "")
	     {
           $fch= fopen($archivo2, "r"); // Abres el archivo para escribir en él
           $this->NombreBD = fread($fch, 1024);	   
		   fclose($fch); // Cierras el archivo
	     }	     

		 if($this->NombreBD == "")
	     {
           $fch= fopen($archivo3, "r"); // Abres el archivo para escribir en él
           $this->NombreBD = fread($fch, 1024);	   
		   fclose($fch); // Cierras el archivo
	     }	     
	   }	   
	 
	   if((strtoupper($this->NombreBD) == "SERVIDORDB")&&(file_exists("C:/appserv/www/dropos/lib/servidorprincipal.txt")))
        $this->ServidorBD = "192.168.14.252";
	   else
	      $this->ServidorBD = "127.0.0.1";	   	 

     $this->ServidorBD = "192.168.14.252";       
     $this->NombreBD   = "droposservidordb";       
     $this->UsuarioBD  = "root";       
     $this->ClaveBD    = "d2218aa6664195";       

     ///// Ya completados los datos me conecto
	   $this->Conectar();
	}
	
	/* *******************
	 * Class Destructor  *
	 * *******************/
	function __destruct(){
		$this->closeConnection();
	}	

    ////////////////////////////////////////////////////////////////////////////
    // *****************************************************//////	
    // FUNCIONES DE CONEXION A LA BASE DE DATOS             //////
    // *****************************************************
	// Establece una Conexion a la Base de Datos Activa
	// Devuelve : El Enlace a la conexion
    ///////////////////////////////////////////////////////////////////////////    
	function Conectar($persistant = false)
	{
	   $this->closeConnection();
		
	   if($persistant){
			$this->Conex = @mysql_pconnect($this->ServidorBD,$this->UsuarioBD,$this->ClaveBD);
		}else{
			$this->Conex = @mysql_connect($this->ServidorBD,$this->UsuarioBD,$this->ClaveBD);
		} 	
		
	   if(!$this->Conex){
   		    $this->lastError = 'ERROR al conectar al Servidor !  <br>ERROR No. <b>' .@mysql_errno($this->Conex) . "</b><br>Detalle del Problema : <b>" .@mysql_error($this->Conex);
			return false;
	   }  
	   
	   if(!$this->UseDB()){
   		    $this->lastError = 'ERROR al conectar al Servidor !  <br>ERROR No. <b>' .@mysql_errno($this->Conex) . "</b><br>Detalle del Problema : <b>" .mysql_error($this->Conex);
			return false;
	   }
	   
	   $this->setCharset(); // TODO: remove forced charset find out a specific management
	   return($this->Conex);	   
	}

    /////////////////////////////////////////////////
	////// Desconectar
    public function closeConnection(){
        if(@$this->Conex){
			// Commit before closing just in case :)
			@$this->commit();
            @mysql_close($this->Conex);
        }
    }

    ///////////////////////////////////////////////////
	// Performs a 'mysql_real_escape_string' on the entire array/string
	private function SecureData($data, $types=array()){
		if(is_array($data)){
            $i = 0;
			foreach($data as $key=>$val){
				if(!is_array($data[$key])){
                    $data[$key] = $this->CleanData($data[$key], $types[$i]);
					$data[$key] = mysql_real_escape_string($data[$key], $this->Conex);
                    $i++;
				}
			}
		}else{
            $data = $this->CleanData($data, $types);
			$data = @mysql_real_escape_string($data, $this->Conex);
		}
		return $data;
	}

    // clean the variable with given types
    // possible types: none, str, int, float, bool, datetime, ts2dt (given timestamp convert to mysql datetime)
    // bonus types: hexcolor, email
    private function CleanData($data, $type = ''){
        switch($type) {
            case 'none':
				// useless do not reaffect just do nothing
                //$data = $data;
                break;
            case 'str':
            case 'string':
                settype( $data, 'string');
                break;
            case 'int':
            case 'integer':
                settype( $data, 'integer');
                break;
            case 'float':
                settype( $data, 'float');
                break;
            case 'bool':
            case 'boolean':
                settype( $data, 'boolean');
                break;
            // Y-m-d H:i:s
            // 2014-01-01 12:30:30
            case 'datetime':
                $data = trim( $data );
                $data = preg_replace('/[^\d\-: ]/i', '', $data);
                preg_match( '/^([\d]{4}-[\d]{2}-[\d]{2} [\d]{2}:[\d]{2}:[\d]{2})$/', $data, $matches );
                $data = $matches[1];
                break;
            case 'ts2dt':
                settype( $data, 'integer');
                $data = date('Y-m-d H:i:s', $data);
                break;
            // bonus types
            case 'hexcolor':
                preg_match( '/(#[0-9abcdef]{6})/i', $data, $matches );
                $data = $matches[1];
                break;
            case 'email':
                $data = filter_var($data, FILTER_VALIDATE_EMAIL);
                break;
            default:
                break;
        }
        return $data;
    }
		
    // Select database to use
	private function UseDB(){
		if(!mysql_select_db($this->NombreBD,$this->Conex)){
			$this->lastError = 'ERROR al Seleccionar la Base de Datos : ' . mysql_error($this->Conex);
			return false;
		}else{
			return true;
		}
	}
	
    public function commit(){
		return @mysql_query("COMMIT", $this->Conex);
	}
  
	public function rollback(){
		return @mysql_query("ROLLBACK", $this->Conex);
	}
	public function setCharset( $charset = 'UTF8' ) {
		return @mysql_set_charset( $this->SecureData($charset,'string'), $this->Conex);
	}

    // Returns last insert ID
    public function lastInsertID(){
        return @mysql_insert_id($this->Conex);
    }
    
	// Return number of rows
    public function countRows($from, $where=''){
        $result = $this->select($from, $where, '', '', false, 'AND','count(*)');
        return $result["count(*)"];
    }
    
	//////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
	// Gets a single row from $from where $where is true
    public function select($from, $where='', $orderBy='', $limit='', $like=false, $operand='AND',$cols='*', $wheretypes=array()){
        // Catch Exceptions
        if(trim($from) == ''){
            return false;
        }
        $query = "SELECT {$cols} FROM `{$from}` WHERE ";
        if(is_array($where) && $where != ''){
            // Prepare Variables
            $where = $this->SecureData($where, $wheretypes);
            foreach($where as $key=>$value){
                if($like){
                    $query .= "`{$key}` LIKE '%{$value}%' {$operand} ";
                }else{
                    $query .= "`{$key}` = '{$value}' {$operand} ";
                }
            }
            $query = substr($query, 0, -(strlen($operand)+2));
        }else{
            $query = substr($query, 0, -6);
        }
        if($orderBy != ''){
            $query .= ' ORDER BY ' . $orderBy;
        }
        if($limit != ''){
            $query .= ' LIMIT ' . $limit;
        }
        $result = $this->executeSQL($query);
        if(is_array($result)) return $result;
        return array();
    }
			
	// ************************************************************
	// Ejecuta una consulta SQL DE ACCION (INSERT - UPDATE - DELETE)
    // Recibe : La Consulta SQL a Ejecutar	
	function EjecutarSQL($SQL)
	{
	   $this->lastQuery = $SQL;
	   $this->Conectar();
       if($this->result = @mysql_query($SQL, $this->Conex))
	   {
            if (gettype($this->result) === 'resource') {
                $this->records  = @mysql_num_rows($this->result);
            } else {
               $this->records  = 0;
            }
            $this->affected = @mysql_affected_rows($this->Conex);
            if($this->records > 0){
                $this->arrayResults();
                return $this->arrayedResult;
            }else{
                return true;
            }
        }else{
            $this->lastError = @mysql_error($this->Conex);
            return false;
       }
	   $this->closeConnection();
	}
	
	// ************************************************************
	// Busca el Campo RETORNO en la tabla TABLA por el campo CAMPO 
	// segun un CRITERIO
    // Recibe : CRITERIO - TABLA - CAMPO A BUSCAR - CAMPO A RETORNAR
	function BDLockup($criterio,$tabla,$campo,$retorno)
	{
	   $campoEnc = "";
	   $conex    = $this->Conectar();
	   $consulta = "SELECT " . $retorno . " AS RET FROM " . $tabla . " WHERE " . $campo . " ='" . $criterio . "'";
	   $this->lastQuery = $consulta;
	   $result = @mysql_query($consulta,$conex);
	   if($row = @mysql_fetch_array($result)) 
	     $campoEnc = $row['RET'];
		 
	   @mysql_free_result($result); 
       $this->closeConnection();
	   return($campoEnc);	  
	}
	
	// ************************************************************
	// Ejecuta una consulta SQL y Devuelve el UNICO CAMPO econtrado
	// Si la consulta genera mas campos solo devuelve el 1,1
    // Recibe : La Consulta SQL a Ejecutar
	// Devuelve : El Campo encontrado	
	function SeleccionarUno($SQL)
	{
	   $campoEnc = "";
	   $conex  = $this->Conectar();
	   $result = @mysql_query($SQL,$this->Conex);
	   if($row = @mysql_fetch_array($result)) 
	     $campoEnc = $row[0];
	
	   @mysql_free_result($result); 
       $this->closeConnection();
	   return($campoEnc);	   
	}		

    ////////////////////////////////////////////////////////////////
    ////////////////////////////////////////////////////////////////	
    // $vermenu :    S -> Si ver menu    N-> No ver menu
    // $tipomenu :   W -> menu Web       D-> Menu Documentos     T-> menu Tablet    N -> Sin Entorno
    ////////////////////////////////////////////////////////////////    
    function Header($vermenu,$tipomenu)
    {
      
      //// INSERTO la Session Actual
      if($_SESSION['G_MODOTRABAJO'] == "SERVIDOR")
      {	
     	  $url      = "http://".$_SERVER['HTTP_HOST'].$_SERVER['REQUEST_URI'];
     	  $fechahoy = date("Y-n-d")." 00:00:00";
/*      	
      	if($_SESSION['PAG-ACTUAL'] == "")
      	{		
           $_SESSION['PAG-ACTUAL'] = $url;	
       	   $vsql = "DELETE FROM sesionesactivas WHERE momlogin < '".$fechahoy."' OR username = '".$_SESSION['USERNAME']."'";
           $this->EjecutarSQL($vsql);
       	   $vsql = "INSERT INTO sesionesactivas(username,momlogin,momupdate,urlactual,idsession) values
                    ('".$_SESSION['USERNAME']."',CURRENT_TIMESTAMP,CURRENT_TIMESTAMP,'".$url."','".$_SESSION['ID-SESSION']."')";
           $this->EjecutarSQL($vsql);
        }else{
           $_SESSION['PAG-ACTUAL'] = $url;	
           $vsql = "UPDATE sesionesactivas SET momupdate = CURRENT_TIMESTAMP , urlactual = '".$url."' WHERE idsession = '".$_SESSION['ID-SESSION']."'";
           $this->EjecutarSQL($vsql);
        }
      
        //// Valido si hay alguien metido en el mismo sitio que yo  
        $ultimos2dig = substr($url,(strlen($url)-4),strlen($url));
        if(is_numeric ($ultimos2dig))
        {
           $vsql2 = "SELECT COUNT(*) FROM sesionesactivas WHERE urlactual='".$url."'";
           $cant  = $this->SeleccionarUno($vsql2);
           //echo $vsql2;
           if($cant>=2)
           {
           	  echo"<center><br><br> <h1>HAY 2 O MAS usuarios en el mismo documento</h1>  <br><br><br><br><br>
                   <center> <a href=\"JavaScript:history.go(-1);\"> Volver Atras </a>
           	       <br>";  
           	  exit();     
           }
        }
*/        
      }
      

        //// Genero las Impresiones Automaticas
        $suc = $_SESSION["G_SUCURSALPOS"];   
        if(($suc != '00')&&($suc != '50'))
        {
           if(file_exists("../Dropbox/".$suc."/autoprint/autoprint.txt"))
             rename("../Dropbox/".$suc."/autoprint/autoprint.txt", "print/autoprint.txt");	
        }
      
        //// Controlo que el tiempo de Vida de la Sesion NO APLIQUE en la sesion de Administradores y Vendedores
        if(($_SESSION['ROL'] != "SAD")&&($_SESSION['ROL'] != "SUP"))
        {
           ini_set("session.cookie_lifetime",0);
      	   ini_set("session.gc_maxlifetime",0);
       }

      //// Controlo que si se esta haciendo el cierre saque a todas las demas ventanas
      if(file_exists("tmpcierre.txt")&&($_SESSION['ROL'] != "SAD")&&($_SESSION['ROL'] != "SUP"))
	  {	  
	    header("Location: index_error.php");
	    exit();
      }
      else
      {
      	 /// Elimino el Archivo temporal
	     @unlink("tmpcierre.txt");
	  }
       
	  $nombre="";
      $bloqueado = $this->BDLockup("G_SISTEMABLOQ","configuraciones","variab","contenido");

      if(($_SESSION['ULTIMOACCESO'] ==""))
      {
         $_SESSION["ESTADO"] = "OUT";
	     session_unset();
	     session_destroy();
	     header("Location: index.php");
	     exit();
      }
  
      if(($_SESSION['ESTADO'] == "OUT")||($_SESSION['ESTADO'] == ""))
      {
        $_SESSION["ESTADO"] = "OUT";
	    session_unset();
	    session_destroy();
	    header("Location: index.php");
	    exit();
      }
      else{
	
	  $this->Automatico();
	  $rol = $this->SeleccionarUno("SELECT R.descripcion FROM roles R INNER JOIN usuarios U ON (U.rol = R.rolid) WHERE U.username='".$_SESSION["USERNAME"]."'");
    $hojacss = $this->SeleccionarUno("SELECT R.hojacss FROM roles R INNER JOIN usuarios U ON (U.rol = R.rolid) WHERE U.username='".$_SESSION["USERNAME"]."'");
    $nomsucursal = $this->BDLockup($_SESSION['G_SUCURSALPOS'],'sucursales','codigo','descripcion');
	 
	  $dias = array("Domingo","Lunes","Martes","Miercoles","Jueves","Viernes","Sabado");
    $meses = array("Enero","Febrero","Marzo","Abril","Mayo","Junio","Julio","Agosto","Septiembre","Octubre","Noviembre","Diciembre");

    $fechahoy = $dias[date('w')].", ".date('d')." de ".$meses[date('n')-1]. " del ".date('Y') ;
    
	/// TItulo de la Barra
	$abreviado = strtoupper(substr($_SERVER['PHP_SELF'],8,(strlen($_SERVER['PHP_SELF'])-12)));

	switch ($abreviado) {
      case "PEDIDOPRO":           $nombre = "Orden de Compra";           break;
      case "PEDIDO2":             $nombre = "Pedidos Sucursales";        break;
	  case "VENTAS":              $nombre = "Fact Venta";                break;
	  case "COMPRAS":             $nombre = "Fact Compra";               break;
	  case "PEDIDOPRO":           $nombre = "Orden de Compra";           break;	
	  case "TRANSFERENCIAS":      $nombre = "Transferenc. Salida";       break;	
	  case "TRANSFERENCIAS2":     $nombre = "Transferenc. Entrada";      break;		  
	  case "REMISIONESI":         $nombre = "Remisiones Entrada";        break;		  
      case "REMISIONESS":         $nombre = "Remisiones Salida";         break;		  	  
      case "DESCARGARREMI":       $nombre = "Cargar Remisiones";         break;		  	  	  
      case "DESCARGARPED":        $nombre = "Cargar Pedidos";            break;		  	  	  	  
	}
	
	if($nombre == "") $nombre = strtoupper(substr($_SERVER['PHP_SELF'],8,1)).strtolower(substr($_SERVER['PHP_SELF'],9,(strlen($_SERVER['PHP_SELF'])-13)));
	$cont='
	<html>
	<head>
	<meta http-equiv="Content-type" content="text/html; charset=utf-8" />
	<link rel="stylesheet" href="css/'.$hojacss.'" type="text/css">	
	<link rel="stylesheet" href="css/estilocalendario.css" type="text/css">';

	//// Hoja de estilos para el nuevo menu
	if($_SESSION['ROL'] == "SAD" )
	{
	   $cont.='<link rel="stylesheet" href="css/estilosmenu.css" type="text/css">';	   
	}
	else{
	   if($_SESSION['ROL'] == "SUP" ) 
	     $cont.='<link rel="stylesheet" href="css/estilosmenusup.css" type="text/css">';
	}
	
	$cont.='      	
    <link rel="shortcut icon" type="image/x-icon" href="images/basicas/favicon.ico" />
	<title>'.$_SESSION['G_SUCURSALPOS'].' '.$nombre.' - DroPos v1 </title>
    <script src="popcalendar.js" type="text/javascript"></script>	
	<link href="facebox/src/facebox.css" media="screen" rel="stylesheet" type="text/css" />

    <script src="mootools.js" type="text/javascript"></script>   
    <link rel="stylesheet" href="sexyalertbox.css" type="text/css" media="all" />
    <script src="sexyalertbox.packed.js" type="text/javascript"></script>

    <script type="text/javascript">
      window.addEvent(\'domready\', function() {
      Sexy = new SexyAlertBox();
    });
    </script>
	
	<script type="text/JavaScript">
	<!--
	function AutoRefresh( t ) {
	   setTimeout("location.reload(true);", t);
	}
	//   -->
	</script>
	
	<script src="facebox/lib/jquery.js" type="text/javascript"></script>
	<script src="facebox/src/facebox.js" type="text/javascript"></script>
	<script type="text/javascript">
	    jQuery(document).ready(function($) {
	    $(\'a[rel*=facebox]\').facebox({
        loadingImage : \'facebox/src/loading.gif\',
	    closeImage   : \'facebox/src/closelabel.png\'
		      })
	    })
	</script>		
	<script src="lib/jscal/js/jscal2.js"></script>
	<script src="lib/jscal/js/lang/en.js"></script>
	<link rel="stylesheet" type="text/css" href="lib/jscal/css/jscal2.css" />
	<link rel="stylesheet" type="text/css" href="lib/jscal/css/border-radius.css" />
	<link rel="stylesheet" type="text/css" href="lib/jscal/css/steel/steel.css" />
	<link rel="stylesheet" type="text/stylesheet" href="css/estilocargando.css" />
	<script type="text/javascript" src="lib/jquery-1.11.0.min.js"></script>
	<script type="text/javascript">
	 $(window).load(function () {
     $(\'#cargando\').hide();
    });
    </script>
	</head>
	';
	
	/// Autorefrescar la Pagina para el Automatico
	$diractual = substr($_SERVER['PHP_SELF'],8,50);
	if($diractual == 'principal.php')
 	   $cont.='<body onload="JavaScript:AutoRefresh(60000);">';
	else
	{
	   if(($diractual == 'consignaciones.php')||($diractual == 'recogidas.php?opcion=nueva')||($diractual == 'misremisiones.php'))
      	 $cont.='<body onload="JavaScript:AutoRefresh(60000);">';	
	   else
	     $cont.='<body leftmargin="0" topmargin="0" rightmargin="0" bottonmargin="0" OnLoad="document.x.default.focus();">';
	}      
	
    $cont.='
	 <style>
     img.Grafico {
         border: 0px solid #000;
         background: url("images/basicas/cargando.gif") no-repeat center center;
	    }
    </style><center><div id="cargando"></div></center>
    <a name="arriba"></a>
<!-- Encabezado Logo y Datos de Session -->
<table align="center">
 <tr class="Barra1">
   <td class="Barra1"> 
    <table width="100%">
	  <tr class="Barra1">
	    <td width="15"> </td>
		<td width="25"> <a href="principal.php" title="Menu Principal"> <img src="images/basicas/home.png" border="0"> </td>
		<td width="30"> <a href="ayuda.php" title="Ayuda del Sistema" target="_blank"> <img src="images/basicas/ayuda.png" border="0"> </td>
		<td width="25"> <a href="mensajes.php" title="Mensajes"> <img src="images/basicas/sinmensajes.png" border="0"> </td>
		<td width="30"> <a href="notificaciones.php" title="Notificaciones"> <img src="images/basicas/sinnotificaciones.png" border="0"> </td>
		<td width="180" align="left"> <b><font color="yellow">SUC : '.$nomsucursal.'</font></b><br>D.Operat : '.$_SESSION['G_DIAOPERATIVO'];
  
  $cont.='</td>		
	    <td width="230" align="center"> '.$fechahoy.'</td>
	    <td width="250" align="right"> Usuario del Sistema<br><a href="miusuario.php?opcion=perfil&usuario='.$_SESSION["USERNAME"].'" title="Mi Perfil" rel="facebox"> 
		                               <b><font color="white">'.$_SESSION["NOMBREUSUARIO"].'</b></a> </td>
	    <td width="5"> </td>';

  if($_SESSION['USERNAME'] != "VENDEDOR")				
      $cont.='<td width="20"> <a href="usuarios.php?opcion=cambiarmiclave" title="Cambiar Mi Clave"> <img src="images/basicas/cambiar.png" border="0"> </a> </td>';
  
  if($_SESSION['G_MODOTRABAJO'] == "SERVIDOR")	
      $cont.='<td width="20"> <a href="#" OnClick="window.open(\'usuarios.php?opcion=versesionesactivas\',\'SesAct\',\'width=900,height=650\');" title="Ver Sesiones Activas" target="blank"> <img src="images/basicas/porvendedor.png" border="0"> </a> </td>';
  
  $cont.='<td width="20"> <a href="usuarios.php?opcion=salir" title="Cerrar Session"> <img src="images/basicas/salir.png" border="0"> </a> </td>				
	    <td width="10"> </td>		
	  </tr>
	 </table> 			   
   </td>
 </tr>
 <tr class="Barra2">
   <td class="Barra2"> </td>
 </tr>
 <tr class="Barra3">
   <td> 
   <!-- Menu desplegable -->';
  
 if(($_SESSION["ROL"] == "SAD")||($_SESSION["ROL"] == "SUP"))
   $cont.= $this->MenuUsuario();

 }

$cont.='
   <!-- Menu Desplegable --> 
  </td>
 </tr>
</table>

<!-- Contenido Central del Sistema -->
<table class="Contenido" align="center" width="100%">
<tr>
  <td valign="top">';
	
$cont.='</td>
<td valign="top">';

   /// Muestro los avisos del Sistema	
   $avisos = $_SESSION["SYSAVISO"];

   if($avisos != ""){
     $cont.= '<center>'.$avisos.'</center>';
     $_SESSION["SYSAVISO"]="";
   }  
  return($cont);

} // Fin de la Funcion


////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////
function HeaderBlanco($titulo)
{
  //// Controlo que si se esta haciendo el cierre saque a todas las demas ventanas
  if(file_exists("tmpcierre.txt"))
  {	  
	 header("Location: index_error.php");
     exit();
  }
	  
  if(($_SESSION['ULTIMOACCESO'] ==""))
  {
     $_SESSION["ESTADO"] = "OUT";
	 session_unset();
	 session_destroy();
	 header("Location: index.php");
	 exit();
  }
  
  if(($_SESSION['ESTADO'] == "OUT")||($_SESSION['ESTADO'] == ""))
  {
     $_SESSION["ESTADO"] = "OUT";
	 session_unset();
	 session_destroy();
	 header("Location: index.php");
	 exit();
  }
  else
  {
	$rol = $this->SeleccionarUno("SELECT R.descripcion FROM roles R INNER JOIN usuarios U ON (U.rol = R.rolid) WHERE U.username='".$_SESSION["USERNAME"]."'");
    $hojacss = $this->SeleccionarUno("SELECT R.hojacss FROM roles R INNER JOIN usuarios U ON (U.rol = R.rolid) WHERE U.username='".$_SESSION["USERNAME"]."'");
	$dias = array("Domingo","Lunes","Martes","Miercoles","Jueves","Viernes","Sabado");
    $meses = array("Enero","Febrero","Marzo","Abril","Mayo","Junio","Julio","Agosto","Septiembre","Octubre","Noviembre","Diciembre");

    $fechahoy = $dias[date('w')].", ".date('d')." de ".$meses[date('n')-1]. " del ".date('Y') ;

	$cont='
    <!DOCTYPE>
    <html>	
	<head>
	<meta http-equiv="Content-type" content="text/html; charset=utf-8" />
    <meta name="robots" content="noindex,nofollow">
	<title> '.$titulo.' </title>
	<link rel="stylesheet" href="css/'.$hojacss.'" type="text/css">
	<link rel="stylesheet" href="css/estilocalendario.css" type="text/css">
    <link rel="stylesheet" type="text/stylesheet" href="css/estilocargando.css" />	
    <link rel="shortcut icon" type="image/x-icon" href="images/basicas/favicon.ico" />	
    <link href="facebox/src/facebox.css" media="screen" rel="stylesheet" type="text/css" />
	<script src="facebox/lib/jquery.js" type="text/javascript"></script>
	<script src="facebox/src/facebox.js" type="text/javascript"></script>
	<script type="text/javascript">
	    jQuery(document).ready(function($) {
	    $(\'a[rel*=facebox]\').facebox({
        loadingImage : \'facebox/src/loading.gif\',
	    closeImage   : \'facebox/src/closelabel.png\'
		      })
	    })
	</script>				   
	<script type="text/javascript">
     $(window).load(function () {
     $(\'#cargando\').hide();
     });
    </script>
	<script src="lib/jscal/js/jscal2.js"></script>
	<script src="lib/jscal/js/lang/en.js"></script>
	<link rel="stylesheet" type="text/css" href="lib/jscal/css/jscal2.css" />
	<link rel="stylesheet" type="text/css" href="lib/jscal/css/border-radius.css" />
	<link rel="stylesheet" type="text/css" href="lib/jscal/css/steel/steel.css" />
	</head>
	<body leftmargin="0" topmargin="0" rightmargin="0" bottonmargin="0" OnLoad="analizarfoco();"> 
	<style>
     img.Grafico {
         border: 0px solid #000;
         background: url("images/basicas/cargando.gif") no-repeat center center;
	    }
    </style>
	<a name="arriba"></a>
	<table class="ContenidoFV" align="center"><tr><td valign="top">';
  }
  return($cont);
}  	


////////////////////////////////////////////////////////////////////
function SoloCSS()
{
  return('<link rel="stylesheet" href="css/estilo.css" type="text/css">');
}  

////////////////////////////////////////////////////////////////////
function HeaderImpresion()
{
  $cont='<html>
           <head>
             <meta http-equiv="Content-Type" content="text/html; charset=iso-8859-1">
             <link rel="stylesheet" href="css/imprimir.css" type="text/css">
             <link rel="stylesheet" href="css/imprimir.css" type="text/css" media="print">			 
             <link rel="shortcut icon" type="image/x-icon" href="images/basicas/favicon.ico" />			 
             <title>Dropos</title>
             <script src="popcalendar.js" type="text/javascript"></script>			 
		   </head> 
           <body leftmargin="0" topmargin="0" rightmargin="0" bottonmargin="0">
		   <div id="contenedor">';
  return($cont);
}

	
////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////	
	function PiePagina()
	{
	 $cont='</td>  
 </tr>
</table>
</td>
</tr>
</table>
<!-- Pie de pagina -->
<table class="Pie" align="center">
 <tr>
   <td align="center"> 
     <a href="http://dromedicas.com.co/soporte/manualdropos.pdf" title="Documentacion En Linea" target="_blank">Documentaci&oacute;n OnLine</a> | 
	 <a href="http://dromedicas.com.co/soporte/open.php?" target="_blank" title="Crear un Ticket de Soporte">Tickets de Soporte</a> | 
	 <a href="http://dromedicas.com.co/soporte/knowledgebase.php?category=2" target="_blank" title="Base de Preguntas Frecuentes">Preguntas Frecuentes</a> | 
	 <a href="http://dromedicas.com.co/soporte/dropos.php" target="_blank">Acerca de</a> | 
	 <a href="">Terminos y Privacidad</a> 
   </td>
 </tr>
</table>
</body>
</html>';
return($cont);
	}


   /////////////////////////////////////////////////////////////////////////
   function NombreMes($mes)
   {
      if(($mes == 1)||($mes == "01")) 
	   return("ENERO");
      if(($mes == 2)||($mes == "02")) 
	   return("FEBRERO");
      if(($mes == 3)||($mes == "03")) 
	   return("MARZO");
      if(($mes == 4)||($mes == "04")) 
	   return("ABRIL");
      if(($mes == 5)||($mes == "05")) 
	   return("MAYO");
      if(($mes == 6)||($mes == "06")) 
	   return("JUNIO");
      if(($mes == 7)||($mes == "07")) 
	   return("JULIO");
      if(($mes == 8)||($mes == "08")) 
	   return("AGOSTO");
      if(($mes == 9)||($mes == "09")) 
	   return("SEPTIEMBRE");
      if(($mes == 10)||($mes == "10")) 
	   return("OCTUBRE");
      if(($mes == 11)||($mes == "11")) 
	   return("NOVIEMBRE");
      if(($mes == 12)||($mes == "12")) 
	   return("DICIEMBRE");
	}
	
	/////////////////////////////////////////////////////////////////////
	function FormatoFecha($fecha)
	{
	   $ano  = substr($fecha,0,4);
	   $mes  = substr($fecha,5,2);
	   $dia  = substr($fecha,8,2);
	   $hora = substr($fecha,11,2);
	   $min  = substr($fecha,14,2);
	   
	   $nombreMes = substr($this->NombreMes($mes),0,3);
	   
	   if($hora <= 12){
	     $jornada = "AM";
	   }else{
	     $hora = $hora-12;
		 $jornada = "PM";
	   }   
	   
	   return($nombreMes." ".$dia." de ".$ano." a las ".$hora.":".$min." ".$jornada);
	}
	
	///////////////////////////////////////////////////////////////////////////
	function Aviso($tipo,$contenido)
	{
	  if($tipo == 1)
	    $_SESSION["SYSAVISO"] ='<table> <tr height="36"> <td width="1050" align="center" style="vertical-align:middle; background-color:#BBFFB6; font-size:12px; border-color:#1FDF00; border-width:medium;"> '.$contenido.'</td> </tr> </table>';			   
	  if($tipo == 2)
	    $_SESSION["SYSAVISO"] ='<table> <tr height="36"> <td width="1050" align="center" style="vertical-align:middle; background-color:#FFFFCC; font-size:12px; border-color:#FFCD67; border-width:medium;"> '.$contenido.'</td> </tr> </table>';			   
	  if($tipo == 3)
	    $_SESSION["SYSAVISO"] ='<table> <tr height="36"> <td width="1050" align="center" style="vertical-align:middle; background-color:#FFDDDD; font-size:12px; border-color:#FFBBBB; border-width:medium;"> '.$contenido.'</td> </tr> </table>';			   
	}   

	///////////////////////////////////////////////////////////////////////////
	///////////////////////////////////////////////////////////////////////////
	///////////////////////////////////////////////////////////////////////////
	
	function CrearCombo($nombrecombo,$tabla,$caption,$valor,$valordefecto,$incluirblanco)
	{  
	   $vsql="SELECT ".$caption." caption ,".$valor." valor FROM ".$tabla." ORDER BY ".$valor." ASC";
	   $conex = $this->Conectar();
       $result = @mysql_query($vsql,$conex); 
       $cont = '<SELECT name="'.$nombrecombo.'" onkeypress="return TabulaEnter(this, event)" class="Texto11">';
      
	   if($incluirblanco == "S")
	     $cont.='<option value=""> </option>';
	     
	   while($row = @mysql_fetch_array($result)){
		 if($row['caption'] != "")
		 {
	       if($valordefecto == $row['valor'])
 	          $cont.='<option value="'.$row['valor'].'" selected> '.$row['caption'].'</option>';
	       else
              $cont.='<option value="'.$row['valor'].'"> '.$row['caption'].'</option>';		 		
		 }	 
	   }
   	   $cont.='</SELECT>';	   
	   return($cont);
	}

   //////////////////////////////////////////////////////////////////////////////////////////
   function CrearComboEsp($nombrecombo,$vsql,$caption,$valor,$valordefecto,$incluirblanco,$otros)
	 {  
	   $conex = $this->Conectar();
       $result = @mysql_query($vsql,$conex); 
       $cont = '<SELECT name="'.$nombrecombo.'" onkeypress="return TabulaEnter(this, event)" '.$otros.' >';
      
	   if($incluirblanco == "S")
	     $cont.='<option value=""> </option>';
	     
	   while($row = @mysql_fetch_row($result)){
		 if($row[0] != "")
		 {
	       if($valordefecto == $row[0])
 	          $cont.='<option value="'.$row[0].'" selected> '.$row[1].'</option>';
	       else
              $cont.='<option value="'.$row[0].'"> '.$row[1].'</option>';		 		
		 }	 
	   }
   	   $cont.='</SELECT>';	   
	   return($cont);
	}
	
	///////////////////////////////////////////////////////////////////////////
	/// Select campo1 as Valor , Campo 2 as Caption FROM tabla WHERE condicion
	function CrearComboFiltro($nombrecombo,$sql,$pordefecto)
	{  
	   $vsql=$sql;
	   $conex = $this->Conectar();
       $result = @mysql_query($vsql,$conex); 
       $cont = '<SELECT name="'.$nombrecombo.'" class="Texto15">';
      
	   if($incluirblanco == "S")
	     $cont.='<option value=""> </option>';
	     
	   while($row = @mysql_fetch_array($result)){
		 if($row['caption'] != "")
		 {
	       if($valordefecto == $row['valor'])
 	          $cont.='<option value="'.$row['valor'].'" selected> '.$row['caption'].'</option>';
	       else
              $cont.='<option value="'.$row['valor'].'"> '.$row['caption'].'</option>';		 		
		 }	 
	   }
   	   $cont.='</SELECT>';	   
	   return($cont);
	}


	///////////////////////////////////////////////////////////////////////////	
	function CrearLista($nombrecombo,$tabla,$caption,$valor)
	{  
	   $vsql="SELECT ".$caption." caption ,".$valor." valor FROM ".$tabla." ORDER BY ".$valor." ASC";
	   $conex = $this->Conectar();
       $result = mysql_query($vsql,$conex); 
       $cont = '<SELECT name="'.$nombrecombo.'" multiple>';
      
	   if($incluirblanco == "S")
	     $cont.='<option value=""> </option>';
	     
	   while($row = mysql_fetch_array($result)){
		 if($row['caption'] != "")
		 {
	       if($valordefecto == $row['valor'])
 	          $cont.='<option value="'.$row['valor'].'" selected> '.$row['caption'].'</option>';
	       else
              $cont.='<option value="'.$row['valor'].'"> '.$row['caption'].'</option>';		 		
		 }	 
	   }
   	   $cont.='</SELECT>';	   
	   return($cont);
	}

  ///////////////////////////////////////////////////////////////////////////////////////////
  ///////                     FUNCIONES DEL MENU INTELIGENTE                            /////
  ///////////////////////////////////////////////////////////////////////////////////////////

  function MenuUsuario()
  {
    $cont = '<nav><ul>'; 
	$cont.= '<li><center><a href=""><img src="images/nuevomenu/mods.png" border="0"></a></li>'; 
    $conex  = $this->Conectar();   
	$vsql = 'SELECT * FROM menu M INNER JOIN menuxusuario MU ON (M.id = MU.menuid) INNER JOIN usuarios U ON (U.usuid = MU.usuarioid) 
             WHERE MU.permitido = "S" AND U.username="'.$_SESSION["USERNAME"].'" ORDER BY M.orden ASC';
	$result  = @mysql_query($vsql,$conex); 	
	$nummenu =0;         $essubmenu="N";    $i=0;   $enmenu = "N";    $ensub = "N";   $ordencolor=1;
	while($row = @mysql_fetch_array($result)) 
	{
	   //////////////////////////////////
	   ///// 1. Nuevo Menu 
	   if(strlen($row['orden']) == 2)       //// Es titulo de Menu
	   {
		  /// Si viene de otro Menu  -  Cierro Todo lo otro
		  if($ensub == 'S')
		  {
	 	    $cont.= '</ul></div></li>';			
			$ensub = 'N';
		  }
		  
	      $cont.='<li> '.$this->CrearEnlaceMenu($row['orden'],$row['descripcion'],$row['link'],$row['tipolink']);
		  $enmenu = "S";            		$ensub  = "N"; 
			         
	   } //// Esas son las 2 Unicas posibilidades	   
	   else
	   {
		  if($row['tipolink'] == 5)
          {
			$color = $this->ColorMenu($ordencolor);
			$ordencolor++; 
 	        if($ordencolor >= 7)      $ordencolor = 1;
			
			if($ensub == 'N')
			{
			  $cont.= '<div> <ul>  <li class="'.$color.'"> <a href=""> '.$row['descripcion'].'</a></li>'; 
			  $enmenu = 'S';   $ensub = 'S';
			}  
			else
			{
			  $cont.= '</ul> <ul> <li class="'.$color.'"> <a href=""> '.$row['descripcion'].'</a></li>';  
			}
	      }
		  else
		  {
		  $cont.='<li>'.$this->CrearEnlaceMenu($row['orden'],$row['descripcion'],$row['link'],$row['tipolink']).'</li>';
		  }
	   }
	  $i++; 
    } // Fin While
	
    $cont.=' </ul> </nav> ';
//    echo $cont;  
//    exit();
	return($cont);
  }


  ///////////////////////////////////////////////////
  function CrearEnlaceMenu($orden,$descripcion,$link,$tipolink)
  {
    if(strlen($orden) == 2)
	   $iconito = $orden;
	else
	   $iconito = "xx";   
	
	if($tipolink == 0) //// Link a Nada
      return('<a href="#"> <img src="images/nuevomenu/'.$iconito.'.png" border="0" width="15" height="13">&nbsp;'.$descripcion.' </a>');
    if($tipolink == 1) //// Link Normal
      return('<a href="'.$link.'"><img src="images/nuevomenu/'.$iconito.'.png" border="0" height="13">&nbsp;'.$descripcion.'</a>');
    if($tipolink == 2) //// Link en Pagina Blank
      return('<a href="'.$link.'" target="_blank"> <img src="images/nuevomenu/'.$iconito.'.png" border="0" width="14" height="14">&nbsp;'.$descripcion.' </a>');
    if($tipolink == 3) //// Link en Pagina Window Open
      return('<a href="#" OnClick="window.open(\''.$link.'\',\'Ventana\',\'\'left=100\'\')"> <img src="images/nuevomenu/'.$iconito.'.png" border="0" width="14" height="14">&nbsp;'.$descripcion.' </a>');
    if($tipolink == 4) //// Link Normal
      return('<a href="'.$link.'" rel="facebox"><img src="images/nuevomenu/'.$iconito.'.png" border="0" height="13">&nbsp;'.$descripcion.'</a>');
  }

  ///////////////////////////////////////////////////
  function ColorMenu($id)
  {
	 if($id == 1)	   return("titulo verde");
     if($id == 2)	   return("titulo rojo");
     if($id == 3)	   return("titulo naranja");
     if($id == 4)	   return("titulo azul");
     if($id == 5)	   return("titulo negro");	 	 	 	 
     if($id == 6)	   return("titulo morado");	 	 	 	 	 
  }
  
  function MenuUsuario2()
  {
    $menu = '<ul id="navmenu-h">'; 
    $conex  = $this->Conectar();   
	//$result = mysql_query('SELECT * FROM v_menu_usuario WHERE permitido = "S" AND username="'.$_SESSION["USERNAME"].'"',$conex); 
	$result = mysql_query('SELECT * FROM menu M INNER JOIN menuxusuario MU ON (M.id = MU.menuid) INNER JOIN usuarios U ON (U.usuid = MU.usuarioid) WHERE MU.permitido = "S" AND U.username="'.$_SESSION["USERNAME"].'" ORDER BY M.orden ASC',$conex); 	
	$nummenu=0;
	while($row = mysql_fetch_array($result)) 
	{
	   if(substr_count($row['orden'],".") == 0)
	   {
	      if($nummenu == 0){
		    $menu.= '<li> '.$this->CrearEnlaceMenu($row['descripcion'],$row['link'],$row['tipolink']).' <ul> ';
			$nummenu = 1;
		  }
		  else{
		    $menu.= '  </ul> <li>  '.$this->CrearEnlaceMenu($row['descripcion'],$row['link'],$row['tipolink']).' <ul> ';				 
		  }
	   }
	   else
	     $menu.='<li>  '.$this->CrearEnlaceMenu($row['descripcion'],$row['link'],$row['tipolink']).' </li>';
       }         
    
	$menu.= '</ul></li>';
	$menu.= '</li></ul>';
    return($menu);
  }


  ///////////////////////////////////////////////////
  function CrearEnlaceMenu2($descripcion,$link,$tipolink)
  {
    if($tipolink == 0) 
      return('<a href="#"> '.$descripcion.' </a>');
    if($tipolink == 1) 
      return('<a href="'.$link.'"> '.$descripcion.' </a>');
    if($tipolink == 2) 
      return('<a href="'.$link.'" target="_blank"> '.$descripcion.' </a>');
    if($tipolink == 3) 
      return('<a href="#" OnClick="window.open(\''.$link.'\',\'Ventana\',\'\'left=100\'\')"> '.$descripcion.' </a>');
   }


  ///////////////////////////////////////////////////////////////////////////////////////////
  //////   FUNCIONES DEL LOG DE AUDITORIA    /////
  ///////////////////////////////////////////////////////////////////////////////////////////
  
    function CrearLOG($evento,$descripcion,$usuario,$sentencia,$docuid=0)
	{  
	   $sentencialista2="";
	   if($sentencia != "")
	   {
	      $sentencialista  = str_replace("'"," ",$sentencia);
		  $sentencialista2 = str_replace("\""," ",$sentencialista);
	   }
	   
	   $vsql="INSERT INTO logauditoria(evento,equipo,direccionip,sentencia,descripcion,usuario,docuid,momento) 
	          values('".$evento."','".gethostbyaddr($_SERVER['REMOTE_ADDR'])."','".$this->getRealIP()."','".$sentencialista2.
			  "','".strtoupper($descripcion)."','".$usuario."',".$docuid.",CURRENT_TIMESTAMP)";	
	   $this->EjecutarSQL($vsql);	  
	}
    
	
	/////////////////////////////////////////////////
	function getRealIP() 
	{
      if (!empty($_SERVER['HTTP_CLIENT_IP']))
        return $_SERVER['HTTP_CLIENT_IP'];
       
      if (!empty($_SERVER['HTTP_X_FORWARDED_FOR']))
        return $_SERVER['HTTP_X_FORWARDED_FOR'];
   
      return $_SERVER['REMOTE_ADDR'];
	}
	
	
	//////////////////////////////////////////////////////
    /// Funciones Varias
	//////////////////////////////////////////////////////
	function ConteoSesion()
	{
	  $fecha = date('m/d/Y');
	  $hora  = date('h');	  
	  $minx  = date('i');
	  $am    = date('A');
	  
	  if(($minx+10)>=60)
	  {
	    $hora++;
		$min = ($minx+10) - 60;
	  }
	  else
	    $min = $minx+10;
	  
	  $cont= '<center>
	            <font size="1">
	              <script language="JavaScript">
				    TargetDate = "'.$fecha.' '.$hora.':'.$min.' '.$am.'";
					BackColor = "";
					ForeColor = "White";
					CountActive = true;
					CountStepper = -1;
					LeadingZero = true;
					DisplayFormat = "%%M%%:%%S%%";
					FinishMessage = "Fin de la Sesion";
				  </script>
				<script language="JavaScript" src="lib/countdown.js"></script>
				</label>';
	return($cont);			
   }
   
   /////////////////////////////////////////////////////////////////////////////////////////
   ////   FUNCIONES DE PERMISOS DEL SISTEMA                                            /////
   /////////////////////////////////////////////////////////////////////////////////////////
   function GetPermiso($nomtabla,$username,$nompermiso)
   { 
     $tablaid = $this->BDLockup($nomtabla,'tablaspermiso','nomtabla','tablaid');  
     $usuid   = $this->BDLockup($username,'usuarios','username','usuid');  	 
	 $vsql = "SELECT ".$nompermiso." FROM permisotabla WHERE tablaid=".$tablaid." AND usuid=".$usuid;
	 $permiso = $this->SeleccionarUno($vsql);
	 return($permiso);
   }  

   /////////////////////////////////////////////////////////////////////////////////////////
   function GetPermiso2($tablaid,$username,$nompermiso)
   { 
     $usuid   = $this->BDLockup($username,'usuarios','username','usuid');  	 
	 $vsql = "SELECT ".$nompermiso." FROM permisotabla WHERE tablaid=".$tablaid." AND usuid=".$usuid;
	 $permiso = $this->SeleccionarUno($vsql);
	 return($permiso);
   }  
   
   //////////////////////////////////////////////////////////////////////////////////////
   function ValidarPermiso($nomtabla,$username,$nompermiso,$ruta)
   {
     if($_SESSION['USERNAME'] != 'ADMIN')
	 {
	   $permiso = $this->GetPermiso($nomtabla,$username,$nompermiso);
	   if($permiso == "")
	   {
	      $this->Aviso(2,'El usuario <b>'.$_SESSION['USERNAME'].'</b> No tiene permisos para realizar esta tarea'); 
	      echo'<html><head>
				<script type="text/javascript">
				function redireccionar(){
				  window.location="'.$ruta.'";
				} 
				setTimeout ("redireccionar()", 1); //tiempo expresado en milisegundos
				</script>
				</head><body></body></html>';	   
          exit();
	   }
	 }  
   }

   //////////////////////////////////////////////////////////////////////////////////////
   function ValidarPermiso2($tablaid,$username,$nompermiso,$ruta)
   {
     if($_SESSION['USERNAME'] != 'ADMIN')
	 {
	   $permiso = $this->GetPermiso2($tablaid,$username,$nompermiso);
	   if($permiso == "")
	   {
	      $this->Aviso(2,'El usuario <b>'.$_SESSION['USERNAME'].'</b> No tiene permisos para realizar esta tarea'); 
	      echo'<html><head>
				<script type="text/javascript">
				function redireccionar(){
				  window.location="'.$ruta.'";
				} 
				setTimeout ("redireccionar()", 1); //tiempo expresado en milisegundos
				</script>
				</head><body></body></html>';	   
          exit();
	   }
	 }  
   }

   ///////////////////////////////////////////////////////////////////////////////////
   // Permisos Especiales
   ////////////////////////////////////////////////////////////
   function GetPermisoEspecial($codpermi,$username)
   { 
      $vsql = "SELECT valor FROM depermisos WHERE codpermi='".$codpermi."' AND username = '".$username."'";
      $permiso = $this->SeleccionarUno($vsql);
      return($permiso);
   }  

  ////////////////////////////////////////////////////////////////////
  ////////////////////////////////////////////////////////////////////
  function Automatico()
  {
     /////////////////////////////////////////////////////////     
	 ///Cargar Globales Generadas cada Hora
	 $horaactual = date("H");
	 $ultima     = $_SESSION['G_ULTRECGLOBALES'];	 
	 if($_SESSION['G_MODOTRABAJO'] == "PUNTODEVENTA")
	 {
	   if(($horaactual-$ultima) != "0")
   	   {

		 // Recibo los Globales
	     if($_SESSION['G_RECIBIRGLOBALES'] == "CHECKED")
		 {
		    $archivo = "SYNC-RES-General.bat";
	        $instruccion = "C:\Appserv\Mysql\Bin\mysql.exe -uroot -p123 --one-database ".$_SESSION['G_LOCALDBNAME']."< ../Dropbox/TODOS/GENERAL-UPDATE.sql";
	        $fp = fopen($archivo,"w"); 
            fwrite($fp,$instruccion);  
            fclose($fp);
	        $salida = exec($archivo);
	     
		    /// Muestro el Aviso
	        $this->Aviso(2,"Recibiendo informacion del Servidor ... ");
	        $_SESSION['G_ULTRECGLOBALES'] = $horaactual;	   
	        $this->EjecutarSQL("UPDATE configuraciones SET contenido='".$horaactual."' WHERE variab='G_ULTRECGLOBALES'");
	     }		
	   }	 
	 }

	 //// Solo Aplica para Punto de Venta
	 if($_SESSION['G_MODOTRABAJO'] == "PUNTODEVENTA")
	 {
	  ini_set("memory_limit","100M");
	 
	  $directorio = "../Dropbox/".$_SESSION['G_BODEGAPREDETPOS']."/automatico/";
	  if ($gestor = @opendir($directorio)) 
	  { 
        while(false !== ($entrada = readdir($gestor))) 
	    {
          if ($entrada != "." && $entrada != "..") 
		  {
	 		
	 		if(substr($entrada,0,3) == "TRB")
			{
               $numremision = substr($entrada,0,strlen($entrada)-4);               
               $existe = $this->SeleccionarUno("SELECT COUNT(*) FROM documentos WHERE CONCAT(tipodoc,prefijo,numero) ='".$numremision."'");               
               
               if($existe == 0)
                  CargarRemisionAutomatica($entrada);
               else 
			      unlink($directorio.$entrada);

			   break;
			}  
			
          }
        }
	    closedir($gestor);
	  } 
    }
	 	 	 
	 /////////////////////////////////////////////////////////
     /// Copiar archivos de Actualizacion Masiva
     $directorio = "../Dropbox/".$_SESSION['G_BODEGAPREDETPOS']."/actualizacionfiles/";
     $fileupdate = '../Dropbox/Aplicacion/actual/version.zip';

	 if ($gestor = @opendir($directorio)) 
	 { 
         while(false !== ($entrada = readdir($gestor))) 
	     {
		   if ($entrada != "." && $entrada != "..") 
		   {
	 		  //Incluimos la libreria
			  include('lib/pclzip/pclzip.lib.php');
 
              if(file_exists($fileupdate))
			  {
				// Actualizo la version a la Actual
			    $this->EjecutarSQL("UPDATE configuraciones SET contenido='3.0.0' WHERE variab='G_VERSIONAPP'");
			  			  
			    //forma de llamar la clase
			    $archive = new PclZip($fileupdate);
              			   
			    //Ejecutamos la funcion extract
			    if ($archive->extract(PCLZIP_OPT_PATH, '../',
                                    PCLZIP_OPT_REMOVE_PATH, 'temp_install') == 0) {
			     die("Error : ".$archive->errorInfo(true));
                }
	 		  
                /// Elimino el Archivo
			    unlink($directorio.$entrada);
			  			  
			    ///////////////////////////////////////////////////
			    //// Muestro el Aviso
			    $this->Aviso(1,'Se ha actualizado el Sistema con Exito ...'); 
			    header("Location: actualizardb.php?opcion=actualizar");
			 }			 
		   } 
         }
	     closedir($gestor);
     }
	 //////////////////////////////////////////////////////// 	 	      
   } /// Fin del Procedimiento Automatico   	
 } // Fin de la Clase
?>