<?PHP
    @session_start(); 
    include("lib/Sistema.php");  
    
    $clase = new Sistema();
    $clase->Nombredb = $_SESSION['DBNOMBRE'];  
    $avisos = ""; 
    $opcion = "";
    $opcion = $_GET["opcion"];

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: ventanadatos
    // Creación: 06/12/2021		última modificación: 10/03/2022
    // Creador: Luis Flórez		modificado por: Luis Flórez
    // Descripción: Opción que pinta la ventana principal del informe
    // Última modificación: Inclusión del combo del tipo de respuesta
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "ventanadatos")
    {
        $params = ' class="Texto11" ';
        $vsqlcomboperiodo  = "SELECT codperiodo, desperiodo FROM periodos WHERE anoperiodo >= 2021 AND orden >= 94 ORDER BY orden";
    
        $cont = $clase->Header("S","W");
        $cont.='<table width="100%">
                 <tr class="CabezoteTabla"> 
                  <td width="10"> &nbsp; </td>
                  <td width="37"> <img src="images/iconos/servicios.png" width="32" height="32" border="0"> </td>
                  <td width="840"> <b> Reportados por periodo </b> </td>
                  <td> &nbsp; </td>
                  <td width="8"> &nbsp; </td>
                 </tr>           
                </table>';
        
        $cont.='<form action="reportadosxperiodo.php?opcion=infrepoxper" method="POST" name="x" target="_blank">
                <center>
                <table width="100%">
                 <tr class="BarraDocumentos">
                  <td align="center"><br><b> Datos del informe <br><br> </td>
                 </tr>
                </table>  
                <table width="100%">
                 <tr class="BarraDocumentos"> 
                  <td width="220"> &nbsp; </td>
                  <td width="20"> Periodo: </td>
                  <td width="120"> '.$clase->CrearComboBuscar("codperiodo",$vsqlcomboperiodo,"desperiodo","codperiodo","","N",$params,400).' </td> 
                  <td width="220"> &nbsp; </td>
                 </tr>
                 <tr class="BarraDocumentos"> 
                  <td width="220"> &nbsp; </td>
                  <td width="20"> <br>Respuestas: </td>
                  <td width="120"><br>
                   <SELECT name="respuestas" id="respuestas" style="width:120px;height:25px">
                    <option value="todos" SELECTED> todas </option>               
                    <option value="correctas"> correctas </option>               
                    <option value="incorrectas"> incorrectas </option>
                   </SELECT>
                  </td> 
                  <td width="220"> &nbsp; </td>
                 </tr>
                </table>                   
                <table width="100%">                     
                 <tr class="BarraDocumentos"> 
                  <td width="371" height="50" align="center"> &nbsp; </td>      
                  <td width="164" height="50" align="center"> <br><input type="submit" value="vista" class="button blue" name="tiposalida"> </td>
                  <td width="131" height="50" align="center"> <br><input type="submit" value="pdf" class="button red" name="tiposalida"> </td>
                  <td width="185" height="50" align="center"> <br><input type="submit" value="excel" class="button blue" name="tiposalida"> </td> 
                  <td width="380" height="50" align="center"> &nbsp; </td>
                 </tr>
                </table> 
                </form>';

        $cont.='<table width="100%"> 
                 <tr class="BarraDocumentos"> <td align="center">&nbsp;</td> </tr>
                 <tr class="BarraDocumentos"> <td align="center">&nbsp;</td> </tr>
                 <tr class="BarraDocumentos"> <td align="center">&nbsp;</td> </tr>
                 <tr class="BarraDocumentos"> <td align="center">&nbsp;</td> </tr>
                 <tr class="BarraDocumentos"> <td align="center">&nbsp;</td> </tr>
                 <tr class="BarraDocumentos"> <td align="center">&nbsp;</td> </tr>
                 <tr class="BarraDocumentos"> <td align="center">&nbsp;</td> </tr>
                 <tr class="BarraDocumentos"> <td align="center">&nbsp;</td> </tr>
                 <tr class="BarraDocumentos"> <td align="center">&nbsp;</td> </tr>
                 <tr class="BarraDocumentos"> <td align="center">&nbsp;</td> </tr>
                </table>';
        echo $cont;
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: infrepoxper
    // Creación: 06/12/2021		última modificación: 11/04/2022
    // Creador: Luis Flórez		modificado por: Luis Flórez
    // Descripción: Opción que imprime el informe de acuerdo a la opción seleccionada
    // Última modificación: Desarrollo de la salida en pdf (09/12/2021)
    //                      Desarrollo de la salida a Excel (10/12/2021)
    //                      Se cambió el criterio para cuantificar las respuestas correctas 
    //                      e incorrectas por el cune (13/01/2022)
    //                      Modificación de la consulta con el filtro del tipo de respuesta 
    //                      y su especificación en el encabezado del informe (10/03/2022)
    //                      Se corrigió el encabezado del informe
    //                      Corrección de la impresión del nombre en la salida en pdf y 
    //                      ajuste de nombre de la salida a Excel especificando el tipo de 
    //                      repuestas
    ////////////////////////////////////////////////////////////////////////////////////////    
    if($opcion=="infrepoxper")
    {
        $codperiodo  = $_POST['codperiodo'];    // Variable para filtrar el periodo        
        $tiposalida = $_POST["tiposalida"];     // Variable que indica qué tipo de informe se mostrará
        $respuestas = $_POST["respuestas"];     // Variable que indica el tipo de respuesta

        if(strlen($codperiodo) == 0)
            $codperiodo  = $_GET['codperiodo'];

        if(strlen($tiposalida) == 0)
            $tiposalida  = $_GET['tiposalida'];

        if(strlen($respuestas) == 0)
            $respuestas  = $_GET['respuestas'];

        // Variable para el nombre del periodo
        $desperiodo = $clase->BDLockup($codperiodo,'periodos','codperiodo','desperiodo');

        // Valido que el periodo tenga datos para emitir el reporte
        $vsqldatos = "SELECT COUNT(*) AS numreg FROM periododian WHERE periodonomina = '".$codperiodo."'";
        $numreg = $clase->SeleccionarUno($vsqldatos);

        if($numreg==0)
        {
            $clase->Aviso(3,"Este periodo no posee información");
            header("Location: reportadosxperiodo.php?opcion=ventanadatos");            
        }
        else
        {
            // Consulta del informe
            $vsql = "SELECT t.dni, CONCAT(t.primernombre,' ',t.segundonombre,' ',t.primerapellido,' ',t.segundoapellido) AS nombreemp,
                            d.cune, d.respuesta 
                       FROM terceros t
                            INNER JOIN dianterceros d ON (t.terid = d.terid)
                            INNER JOIN periododian p ON (d.periodonomina = p.periododiamid)
                      WHERE p.periodonomina = '".$codperiodo."'";
            
            if($respuestas=="correctas")
            {
                $vsql.= " AND d.cune <> '' ";
                $tiporespuesta = "Respuestas correctas";
            }

            if($respuestas=="incorrectas")
            {
                $vsql.= " AND d.cune = '' ";
                $tiporespuesta = "Respuestas incorrectas";
            }
                   
            $vsql.= " ORDER BY nombreemp";

            if($respuestas=="todos")        $tiporespuesta = "Todas las respuestas";

            // Salida en vista html
            if($tiposalida=="vista")
            {
                // pintamos la ventana
                $cont.= $clase->HeaderBlanco("Reportados por periodo");
                $cont.='<table width="1300">
                         <tr class="CabezoteTabla"> 
                          <td width="10"> </td>
                          <td width="37"> <img src="images/iconos/servicios.png" width="32" height="32" border="0"> </td>
                          <td width="900"><b>Reportados del periodo <font color="blue"> '.$desperiodo.' </font> <br>'.$tiporespuesta.'</b> </td>
                          <td width="50"> &nbsp; </td>    				 				 				 				
                          <td width="30" align="center"> &nbsp; </td> 
                          <td width="30" align="center"> &nbsp; </td>
                          <td width="30" align="center">
                           <a href="?opcion=infrepoxper&codperiodo='.$codperiodo.'&tiposalida='.$tiposalida.'&respuestas='.$respuestas.'" title="refrescar el formulario"> 
                            <img src="images/iconos/refrescar.png" border="0" width="32" height="32">  
                           </a>                           
                          </td>				
                          <td width="10">&nbsp;</td>
                         </tr>
                        </table>';

                $cont.='<script type="text/javascript" src="lib/sorttable.js"></script>
                        <table width="1250" class="sortable">
                         <thead> 
                          <tr class="TituloTabla" style="display:block;padding-top:5px;height:20px;">
                           <td width="20">&nbsp;</td>
                           <td width="120" align="left"> Documento </td>				 				 
                           <td width="320" align="left"><p>Nombre</p></td>				 				                  
                           <td width="750" align="left">Cune</td>			
                           <td width="50" align="left">Respuesta</B></td>			
                           <td width="20">&nbsp;</td>					
                          </tr>
                          </thead>
                          <tbody style="display:block; width:1300px; height:740px; overflow-Y:scroll">';

                // inicializamos las variables
                $i = 0;
                $totalrespuestas = 0;
                $totrescorrectas = 0;
                $totresincorrectas = 0;
                $conex  = $clase->Conectar();
                $result = mysql_query($vsql,$conex);
                while($row = mysql_fetch_array($result))
                {
                    $i++;
                    $totalrespuestas++;
                    if($i%2 == 0)
                        $cont.='<tr class="TablaDocsPar">';
                    else
                        $cont.='<tr class="TablaDocsImPar">';

                    $cont.=' <td width="20">&nbsp;</td>
                             <td width="120" align="left"> '.$row['dni'].' </td>				 				 
                             <td width="320" align="left">'.$row['nombreemp'].'</td>				 				                  
                             <td width="750" align="left">'.$row['cune'].'</td>	';

                    if($row['cune']!="")
                    {
                        $cont.='<td width="50" align="right"><font color="Green">'.$row['respuesta'].'</font></td>';
                        $totrescorrectas++;
                    }
                    else
                    {
                        $cont.='<td width="50" align="right"><font color="Red">'.$row['respuesta'].'</font></td>';
                        $totresincorrectas++;
                    }

                    $cont.=' <td width="20">&nbsp;</td>					
                            </tr>';
                }

                $cont.=' </tbody> 
                        </table>';

                // impresión de los totales
                $cont.='<table width="100%">
                         <tr class="TituloTabla"> 
                          <td width="261"> &nbsp; </td>
                          <td width="375" align="right"> <font color="WHITE"> <b> Total respuestas: </b> '.number_format($totalrespuestas).' </font> </td>
                          <td width="375" align="right"> <font color="WHITE"> <b> Total correctas: </b> '.number_format($totrescorrectas).' </font> </td>
                          <td width="375" align="right"> <font color="WHITE"> <b> Total incorrectas: </b> '.number_format($totresincorrectas).' </font> </td>
                          <td width="222"> &nbsp; </td>
                         </tr>
                        </table>';
                echo $cont;
            }

            // vista en formato pdf
            if($tiposalida=="pdf")
            {
                // Traducción al español del mes que devuelve la función date()
                $mesimp = date('F');
                if($mesimp=="January")       $mesimp = "Enero";
                if($mesimp=="February")      $mesimp = "Febrero";
                if($mesimp=="March")         $mesimp = "Marzo";
                if($mesimp=="April")         $mesimp = "Abril";
                if($mesimp=="May")           $mesimp = "Mayo";
                if($mesimp=="June")          $mesimp = "Junio";
                if($mesimp=="July")          $mesimp = "Julio";
                if($mesimp=="August")        $mesimp = "Agosto";
                if($mesimp=="September")     $mesimp = "Septiembre";
                if($mesimp=="October")       $mesimp = "Octubre";
                if($mesimp=="November")      $mesimp = "Noviembre";
                if($mesimp=="December")      $mesimp = "Diciembre";

                $clase = new Sistema();
                ini_set("memory_limit","200M");
                require('lib/fpdf/fpdf.php');
                $pdf = new FPDF('L','mm','legal');

                $pdf->AddPage("");

                // Logo Dromedicas
                $pdf->Image('images/empresa/logo-dromedicas-en-azul.png',10,10,20,25,'PNG','');

                $x = 35;
                $y = 15;
                $pagina = 1;

                $pdf->SetFont('Arial','B',10);
                $enc= "DROMEDICAS DEL ORIENTE SAS - NIT: 900265730-0";                  $pdf->Text($x,$y,$enc);

                // Fecha y hora de impresión
                $fechoraimp = $mesimp." ".date('d')." de ".date('Y g:i a')."    Pagina: ".$pagina;

                $pdf->SetFont('Arial','',8);
                $pdf->Text($x+250,$y,$fechoraimp);

                $pdf->SetFont('Arial','B',10);                
                $enc= "REPORTADOS DEL PERIODO ".$desperiodo;                            $pdf->Text($x,$y+7,$enc);                
                $pdf->Text($x,$y+14,strtoupper($tiporespuesta));

                $pdf->SetFillColor(220,220,220);
                $pdf->Rect(7,$y+28,340,8,'F');

                $enc= "DOCUMENTO";                                                      $pdf->Text(12,$y+33,$enc);
                $enc= "NOMBRE";                                                         $pdf->Text(48,$y+33,$enc);
                $enc= "CUNE";                                                           $pdf->Text(130,$y+33,$enc);
                $enc= "RESPUESTA";                                                      $pdf->Text(320,$y+33,$enc);

                $x = 10;
                $y = 56;
                $totalrespuestas = 0;
                $totrescorrectas = 0;
                $totresincorrectas = 0;                

                $conex  = $clase->Conectar();
                $result = mysql_query($vsql,$conex);
                while($row = mysql_fetch_array($result))
                {
                    // Imprimo los datos de los empleados
                    $i++;
                    $totalrespuestas++;
                    $pdf->SetFont('Arial','',9);
                    
                    $pdf->Text($x+2,$y,$row['dni']);
                    $pdf->Text($x+38,$y,substr($row['nombreemp'],0,40));
                    $pdf->Text($x+120,$y,$row['cune']);
                    $pdf->Text($x+318,$y,$row['respuesta']);

                    // if($row['respuesta']=="200")

                    if($row['cune']!="")
                        $totrescorrectas++;
                    else
                        $totresincorrectas++;

                    $y+=6;

                    if($i%25 == 0)
                    {
                        $pdf->AddPage("");

                        // Logo Dromedicas
                        $pdf->Image('images/empresa/logo-dromedicas-en-azul.png',10,10,20,25,'PNG','');
        
                        $x = 35;
                        $y = 15;
                        $pagina++;
        
                        $pdf->SetFont('Arial','B',10);
                        $enc= "DROMEDICAS DEL ORIENTE SAS - NIT: 900265730-0";              $pdf->Text($x,$y,$enc);
        
                        // Fecha y hora de impresión
                        $fechoraimp = $mesimp." ".date('d')." de ".date('Y g:i a')."    Pagina: ".$pagina;
        
                        $pdf->SetFont('Arial','',8);
                        $pdf->Text($x+250,$y,$fechoraimp);

                        $enc= "REPORTADOS DEL PERIODO ".$desperiodo;
                        
                        $pdf->SetFont('Arial','B',10);                        
                        $pdf->Text($x,$y+7,$enc);
                        $pdf->Text($x,$y+14,strtoupper($tiporespuesta));
        
                        $pdf->SetFillColor(220,220,220);
                        $pdf->Rect(7,$y+28,340,8,'F');
        
                        $enc= "DOCUMENTO";                                                  $pdf->Text(12,$y+33,$enc);        
                        $enc= "NOMBRE";                                                     $pdf->Text(48,$y+33,$enc);        
                        $enc= "CUNE";                                                       $pdf->Text(130,$y+33,$enc);        
                        $enc= "RESPUESTA";                                                  $pdf->Text(320,$y+33,$enc);
        
                        $x = 10;
                        $y = 56;
                    }
                }

                // Impresión de los totales
                $pdf->SetFillColor(180,180,180);
                $pdf->Rect(7,$y-3,340,8,'F');

                $enc= "RESPUESTAS: ";                                           $pdf->Text($x+2,$y+2,$enc);
                $pdf->Text($x+26,$y+2,number_format($totalrespuestas));

                $enc= "CORRECTAS: ";                                            $pdf->Text($x+50,$y+2,$enc);
                $pdf->Text($x+74,$y+2,number_format($totrescorrectas));

                $enc= "INCORRECTAS: ";                                          $pdf->Text($x+100,$y+2,$enc);
                $pdf->Text($x+128,$y+2,number_format($totresincorrectas));                
                
                $pdf->Output();
            }

            // salida a excel
            if($tiposalida=="excel")
            {
                require_once 'lib/PHPExcel.php';
                $clase = new Sistema();
                $clase->Conectar();
                ini_set("memory_limit","100M");

                // Preparación del entorno para la salida a Excel
                $clase = new Sistema();
                $clase->Nombredb = $_SESSION['DBNOMBRE'];
                error_reporting(E_ALL);
                ini_set('display_errors', TRUE);
                ini_set('display_startup_errors', TRUE);
                date_default_timezone_set('Europe/London');
            
                if (PHP_SAPI == 'cli')
                    die('This example should only be run from a Web Browser');
            
                // Create new PHPExcel object
                $objPHPExcel = new PHPExcel();
            
                // Set document properties
                $objPHPExcel->getProperties()->setCreator("Sistemas y Soluciones Web de Colombia")
                                             ->setLastModifiedBy("Sistemas y Soluciones Web de Colombia")
                                             ->setTitle("Reportados por periodo - DROPOS")
                                             ->setSubject("Reportados por periodo - DROPOS")
                                             ->setDescription("Reportados por periodo - DROPOS")
                                             ->setKeywords("Reportados por periodo - DROPOS")
                                             ->setCategory("Categoria General");

                // encabezado
                 $objPHPExcel->setActiveSheetIndex(0)
                             ->setCellValue('A1', 'REPORTADOS POR PERIODO')
                             ->setCellValue('A2', 'PERIODO: '.$desperiodo)
                             ->setCellValue('A3', strtoupper($tiporespuesta))
                             ->setCellValue('A4', 'DOCUMENTO')
                             ->setCellValue('B4', 'NOMBRE')
                             ->setCellValue('C4', 'CUNE')
                             ->setCellValue('D4', 'RESPUESTA');

                $objPHPExcel->getActiveSheet()->getColumnDimension('A')->setAutoSize(true);                     $objPHPExcel->getActiveSheet()->getColumnDimension('B')->setAutoSize(true);
                $objPHPExcel->getActiveSheet()->getColumnDimension('C')->setAutoSize(true);                     $objPHPExcel->getActiveSheet()->getColumnDimension('D')->setAutoSize(true);

                
                // Inicialización de variables
                $totalrespuestas = 0;                   $totrescorrectas = 0;                       $totresincorrectas = 0;                   $i=5;
                
                $conex  = $clase->Conectar();
                $result = mysql_query($vsql,$conex);
                $cant   = mysql_num_rows($result);
                // Detalle del informe
                while($row = mysql_fetch_array($result))
                {
                    $objPHPExcel->setActiveSheetIndex(0)
                                ->setCellValue('A'.$i, $row['dni'])
                                ->setCellValue('B'.$i, $row['nombreemp'])
                                ->setCellValue('C'.$i, $row['cune'])
                                ->setCellValue('D'.$i, $row['respuesta']);
                    $i++;
                    $totalrespuestas++;

                    if($row['cune']!="")
                        $totrescorrectas++;
                    else
                        $totresincorrectas++;                    
                }

                $lt = $i+1;
                $tr = $i+2;
                $rc = $i+3;
                $ri = $i+4;

                // Impresión de los totales
                $objPHPExcel->setActiveSheetIndex(0)
                            ->setCellValue('A'.$lt, "TOTALES:")
                            ->setCellValue('A'.$tr, "RESPUESTAS:")
                            ->setCellValue('B'.$tr, number_format($totalrespuestas))
                            ->setCellValue('A'.$rc, "CORRECTAS:")
                            ->setCellValue('B'.$rc, number_format($totrescorrectas))
                            ->setCellValue('A'.$ri, "INCORRECTAS:")
                            ->setCellValue('B'.$ri, number_format($totresincorrectas));

                $rangoEncabezado = 'A4:D4';
                $rangoCeldas     = 'A4:D'.($i-1);
                // ----------------------------------------------------------------------------------------------------------------------------------------------------------- //
                
                // Formato de Encabezado y Celdas
                $objPHPExcel->getActiveSheet()->getRowDimension('1')->setRowHeight(15);
                
                $EstiloCeldas = array(
                'borders' => array(
                    'allborders' => array(
                        'style' => PHPExcel_Style_Border::BORDER_THIN,
                        'color' => array('argb' => '00000000'),
                    ),
                    ),
                );
                // $objPHPExcel->getActiveSheet()->getStyle($rangoCeldas)->applyFromArray($EstiloCeldas);
                /// Formato de Encabezados 
                $EstiloEncabezado = array(
                'font' => array(
                    'bold' => true,
                ),
                'alignment' => array(
                    'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,
                    'vertical' => PHPExcel_Style_Alignment::VERTICAL_CENTER,		
                ),
                'borders' => array(
                    'allborders' => array(
                        'style' => PHPExcel_Style_Border::BORDER_THIN,
                        'color' => array('argb' => '00000000'),
                    ),
                ),
                'fill' => array(
                    'type' => PHPExcel_Style_Fill::FILL_SOLID,
                    'rotation' => 90,
                    'startcolor' => array(
                        'argb' => '00FFFFCC',
                    ),
                    'endcolor' => array(
                        'argb' => 'FFFFFF',
                    ),
                    ),
                );
                // $objPHPExcel->getActiveSheet()->getStyle($rangoEncabezado)->applyFromArray($EstiloEncabezado);
                // Rename worksheet
                $objPHPExcel->getActiveSheet()->setTitle('Reportados por periodo');
                // Set active sheet index to the first sheet, so Excel opens this as the first sheet
                $objPHPExcel->setActiveSheetIndex(0);
                // Redirect output to a client’s web browser (Excel5)
                header('Content-Type: application/vnd.ms-excel');
                // --------------------------------------------------------------------- //
                // header('Content-Disposition: attachment;filename="planillanom.xls"');
                $nombrearcexcel = "reportados del periodo ".strtolower($desperiodo)." ".strtolower($respuestas).".xls";
                header('Content-Disposition: attachment;filename='.$nombrearcexcel.'');
                // --------------------------------------------------------------------- //
                header('Cache-Control: max-age=0');
                /// Genero la Salida
                $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');
                $objWriter->save('php://output');
                exit;
            }
        }
    }
?>