<?PHP
    @session_start(); 
    include("lib/Sistema.php");    
    
    $clase = new Sistema();
    $clase->Nombredb = $_SESSION['DBNOMBRE'];  
    $avisos = ""; 
    $opcion = "";
    $opcion = $_GET["opcion"];

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: ventanadatos
    // Creación: 07/11/2020		última modificación: 14/05/2024
    // Creador: Luis Flórez		modificado por: Luis Florez
    // Descripción: Opción que pinta la ventana para la captación de datos del informe de 
    //              conceptos por periodo
    // Última modificación: Inclusión del filtro para el tipo de nómina de empleados o 
    //                      extralegal (27/11/2020)
    //                      Inclusión de la opción todos en el tipo de nómina (16/12/2020)
    //                      Optimización del combo de periodos filtrando los periodos 
    //                      cerrados y el actual (19/03/2021)
    //                      Se eliminó el filtro del tipo de empleado (09/08/2022)
    //                      Casilla de verificación para los registros de las liquidaciones
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "ventanadatos")
    {
        // combos de periodo y concepto
        $params = ' class="Texto11" ';
        $vsqlcomboconcepto = "SELECT codconcepto, CONCAT(codconcepto,' - ',nomconcepto) FROM conceptosnomina ORDER BY codconcepto ASC";
        $vsqlcomboperiodo  = "SELECT codigo, CONCAT(codigo,' - ',descripcion) 
                                FROM periodosnomina 
                               WHERE cerrado ='CHECKED' OR 
                                     periodoid = (SELECT MIN(periodoid) FROM periodosnomina WHERE cerrado ='')                                    
                            ORDER BY periodoid ASC";

        // incluir los registros de las liquidaciones
        $chkincluirliq = "";
    
        // Pinto la ventana
        $cont = $clase->Header("S","W");    
        $cont.='<table width="100%">
                 <tr class="CabezoteTabla"> 
                  <td width="10"> &nbsp; </td>
                  <td width="37"> <img src="images/iconos/informes.png" width="32" height="32" border="0"> </td>
                  <td width="840"> <b> Informe de conceptos por periodo </b></td>
                  <td> &nbsp; </td>
                  <td width="8"> &nbsp; </td>
                 </tr>           
                </table>';

        // filtros
        $cont.='<form action="repconceptoporperiodo.php?opcion=listadoconcepto" method="POST" name="x" target="_blank">
                <center>                                
                <table width="100%">                 
                 <tr class="BarraDocumentos" style="height:50px;Important!"> 
                  <td width="220"> &nbsp;<br> </td>
                  <td width="20"> Periodo: </td>
                  <td width="120"> '.$clase->CrearComboBuscar("codigo",$vsqlcomboperiodo,"descripcion","codigo","","N",$params,400).' </td> 
                  <td width="220"> &nbsp; </td>
                 </tr>  
                 <tr class="BarraDocumentos" style="height:50px;Important!"> 
                  <td width="220"> &nbsp; </td>
                  <td width="20"> Concepto: </td>
                  <td width="120"> '.$clase->CrearComboBuscar("codconcepto",$vsqlcomboconcepto,"nomconcepto","codconcepto","","N",$params,300).' </td>
                  <td width="220"> &nbsp; </td>
                  <tr class="BarraDocumentos" style="height:50px;Important!"> 
                   <td width="220"> &nbsp; </td>
                   <td width="20"> &nbsp; </td>
                   <td width="120"> <br> <input type="checkbox" value="CHECKED" name="incluirliq" class="Texto11" '.$chkincluirliq.' style="width:15px;height:15px;"> Incluir liquidaciones <br><br> </td> 
                   <td width="220"> &nbsp; </td>
                  </tr>
                  <!--
                  <tr class="BarraDocumentos" style="height:50px;Important!"> 
                   <td width="220"> &nbsp; </td>
                   <td width="20"> Tipo: </td>
                   <td width="120"> 
                    <SELECT name="tiponomina" id="tiponomina" style="width:120px;height:20px">
                     <option value="todos" SELECTED> Todos </option>               
                     <option value="empleados"> Empleados </option>               
                     <option value="extralegal"> Extralegal </option>
                    </SELECT>
                   </td> 
                   <td width="220"> &nbsp; </td>
                  </tr>
                  -->
                </table>                   
                <table width="100%">                     
                 <tr class="BarraDocumentos" style="height:50px;Important!"> 
                  <td width="371" height="50" align="center">&nbsp;  </td>      
                  <td width="164" height="50" align="center"> <input type="submit" value="vista" class="button blue" name="tiposalida"></td>
                  <td width="131" height="50" align="center"> <input type="submit" value="pdf" class="button red" name="tiposalida"></td>
                  <td width="185" height="50" align="center"> <input type="submit" value="excel" class="button blue" name="tiposalida"></td>
                  <td width="380" height="50" align="center">&nbsp;  </td>
                 </tr>
                </table> 
                </form>';

        // pie de página
        $cont.='<table width="100%"> 
                 <tr class="BarraDocumentos" style="height:50px;Important!"> <td align="center">&nbsp;</td> </tr>
                 <tr class="BarraDocumentos" style="height:50px;Important!"> <td align="center">&nbsp;</td> </tr>
                 <tr class="BarraDocumentos" style="height:50px;Important!"> <td align="center">&nbsp;</td> </tr>
                 <tr class="BarraDocumentos" style="height:50px;Important!"> <td align="center">&nbsp;</td> </tr>
                 <tr class="BarraDocumentos" style="height:50px;Important!"> <td align="center">&nbsp;</td> </tr>
                 <tr class="BarraDocumentos" style="height:50px;Important!"> <td align="center">&nbsp;</td> </tr>
                 <tr class="BarraDocumentos" style="height:50px;Important!"> <td align="center">&nbsp;</td> </tr>
                </table>';

        echo $cont.$clase->PiePagina();
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: listadoconcepto
    // Creación: 09/11/2020		última modificación: 19/06/2024
    // Creador: Luis Flórez		modificado por: Luis Florez
    // Descripción: Opción que imprime el informe de conceptos por periodo de acuerdo al 
    //              tipo de salida que se seleccione en la opción “ventanadatos” 
    //              (vista, PDF o Excel)
    // Última modificación: Inclusión del filtro para el tipo de nómina de empleados o 
    //                      extralegal (27/11/2020)
    //                      Inclusión de páginas adicionales después de la uno y numeración 
    //                      de las mismas en el tipo de salida PDF (11/12/2020)
    //                      Inclusión de la opción todos en el tipo de nómina (16/12/2020)
    //                      Optimización de la consulta e inclusión de la columna del código 
    //                      del empleado (05/04/2021)
    //                      Se incorporó el campo de empleado activo en la nómina 
    //                      (11/08/2021)
    //                      En la salida a Excel se incorporó al nombre de archivo el 
    //                      concepto y el periodo 18/08/2021
    //                      Se incorporaron los botones para eliminar y editar un concepto y 
    //                      se modificó la consulta para no incluir el tipo de empleado
    //                      (09/08/2022)
    //                      Validación de que el periodo esté calculado y modificación de la 
    //                      consulta tomando en cuenta la nueva tabla tercerosactual e 
    //                      impresión de los días en caso de ser una licencia (20/09/2022)
    //                      Inclusión de los números de línea en la salida a Excel 
    //                      (02/11/2022)
    //                      Inclusión de los números de línea en las salidas html y dpf
    //                      (18/11/2022)
    //                      Validación para editar y eliminar un concepto si el periodo está 
    //                      cerrado (02/05/2023)
    //                      Inmovilización de los paneles superiores para hacer siempre 
    //                      visible el encabezado de la hoja y optimización de la impresión 
    //                      de los códigos de vendedor (16/05/2023)
    //                      Modificación de la consulta para incluir los registros de las 
    //                      liquidaciones y mensajes correspondientes en cada tipo de salida
    //                      (14/05/2024)
    //                      Adaptación para el informe de recargos nocturnos (01/06/2024)
    //                      Se marcaron en color azul los registros que de liquidaciones
    //                      en la salida html
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion=="listadoconcepto")
    {
        $codigo  = $_POST['codigo'];            // Variable para filtrar el periodo
        $codconcepto = $_POST['codconcepto'];   // Variable para filtrar el concepto
        $tiposalida = $_POST["tiposalida"];     // Variable que indica qué tipo de informe se mostrará
        $tiponomina = $_POST["tiponomina"];     // Variable para el tipo de nómina
        $incluirliq = $_POST["incluirliq"];     // Variable para determinar si se incluyen las liquidaciones

        // Variables para los nombres del periodo y concepto
        $descripcion = $clase->BDLockup($codigo,'periodosnomina','codigo','descripcion');
        $nomconcepto = $clase->BDLockup($codconcepto,'conceptosnomina','codconcepto','nomconcepto');

        // Variables para los respectivos ID
        $periodoid  = $clase->BDLockup($codigo,'periodosnomina','codigo','periodoid');
        $conceptoid = $clase->BDLockup($codconcepto,'conceptosnomina','codconcepto','conceptoid');
        $eslibranza = $clase->BDLockup($conceptoid,'conceptosnomina','conceptoid','eslibranza');
        $montopermanente = $clase->BDLockup($conceptoid,'conceptosnomina','conceptoid','montopermanente');
        $montoocasional = $clase->BDLockup($conceptoid,'conceptosnomina','conceptoid','montoocasional');
        $eslicencia = $clase->BDLockup($conceptoid,'conceptosnomina','conceptoid','eslicencia');
        $recargo = $clase->BDLockup($conceptoid,'conceptosnomina','conceptoid','recargo');

        // ------------------------------------------------------------------------------------------------------------------------------------------ //
        $calculado = $clase->BDLockup($periodoid,'periodosnomina','periodoid','calculado');

        if($calculado!="CHECKED")
        {
            // Mensaje correspondiente
            $clase->Aviso(3,"No se puede emitir el reporte porque el periodo $descripcion no está calculado");

            // Redirecciona el formulario
            header("Location: repconceptoporperiodo.php?opcion=ventanadatos");            
        }
        else
        {
            // Variable para determinar si el periodo está abierto o cerrado
            $cerrado = $clase->BDLockup($periodoid,'periodosnomina','periodoid','cerrado');

            if($cerrado=="CHECKED")
            {
                $tabla = "periodoterceros";
                $nomnreemp = "t.nombre AS nombreemp ";
            }
            else
            {
                $tabla = "tercerosactual";
                $nomnreemp = "CONCAT(t.primernombre,' ',t.segundonombre,' ',t.primerapellido,' ',t.segundoapellido) AS nombreemp ";
            }

            // ------------------------------------------------------------------------------------------------------------------------------------------ //
            // Consulta del informe de acuerda a la selección realizada
            $vsql = "SELECT t.codvende, t.dni, ".$nomnreemp.", c.nomconcepto, d.saldo, c.tipodc, d.devengados, 
                            d.descuentos, d.terid, d.pernominaid, d.valor, 0 liquidacion  
                       FROM detallenomina d
                            INNER JOIN ".$tabla." t ON (d.terid = t.terid AND d.pernominaid = t.pernominaid)
                            INNER JOIN conceptosnomina c ON (d.conceptoid = c.conceptoid)
                      WHERE d.pernominaid = ".$periodoid." 
                            AND d.conceptoid = ".$conceptoid." ";

            if($incluirliq == "CHECKED")
                $vsql.= "UNION ALL
                         SELECT t.codvende, t.dni, CONCAT(t.primernombre,' ',t.segundonombre,' ',t.primerapellido,' ',t.segundoapellido) AS nombreemp, 
                                c.nomconcepto, d.saldo, c.tipodc, d.devengados, d.descuentos, d.terid, d.pernominaid, d.valor, 1 liquidacion 
                           FROM detalleliquidacion d 
                                INNER JOIN terceros t ON (d.terid = t.terid) 
                                INNER JOIN conceptosnomina c ON (d.conceptoid = c.conceptoid)
                          WHERE d.pernominaid = ".$periodoid." 
                                AND d.conceptoid = ".$conceptoid;            
    
            // switch($tiponomina)
            // {
            //     case 'empleados':
            //         $vsql.= " AND (t.esempleadoactivo='CHECKED' AND (t.extralegal = '' OR t.extralegal IS NULL)) ";
            //         break;
            //     case 'extralegal':
            //         $vsql.= " AND t.extralegal = 'CHECKED' ";
            //         break;
            //     case 'todos':
            //         $vsql.= " AND t.esempleadoactivo='CHECKED' ";
            //         break;
            //     default:
            //         break;
            // }

            // $vsql.= " ORDER BY t.codvende";

            $vsql.= " ORDER BY 1";
    
            // ------------------------------------------------------------------------------------------------------------------------------------------ //
            // $vsql = "SELECT t.codvende, t.dni, CONCAT(t.primernombre,' ',t.segundonombre,' ',t.primerapellido,' ',t.segundoapellido) AS nombreemp, 
            //                 c.nomconcepto, d.saldo, c.tipodc, d.devengados,
            //                 d.descuentos  
            //            FROM detallenomina d
            //                 INNER JOIN terceros t ON (d.terid = t.terid)
            //                 INNER JOIN conceptosnomina c ON (d.conceptoid = c.conceptoid)
            //           WHERE d.pernominaid = ".$periodoid." 
            //                 AND d.conceptoid=".$conceptoid." ";
    
            // switch($tiponomina)
            // {
            //     case 'empleados':
            //         $vsql.= " AND (t.esempleadoactivo='CHECKED' AND (t.extralegal = '' OR t.extralegal IS NULL)) ";
            //         break;
            //     case 'extralegal':
            //         $vsql.= " AND t.extralegal = 'CHECKED' ";
            //         break;
            //     case 'todos':
            //         $vsql.= " AND t.esempleadoactivo='CHECKED' ";
            //         break;
            //     default:
            //         break;
            // }
    
            // $vsql.="UNION
            //         SELECT t.codvende, t.dni, CONCAT(t.primernombre,' ',t.segundonombre,' ',t.primerapellido,' ',t.segundoapellido) AS nombreemp, 
            //                c.nomconcepto, d.saldo, c.tipodc, d.devengados,
            //                d.descuentos  
            //           FROM detalleliquidacion d
            //                INNER JOIN terceros t ON (d.terid = t.terid)
            //                INNER JOIN conceptosnomina c ON (d.conceptoid = c.conceptoid)
            //          WHERE d.pernominaid = ".$periodoid." 
            //                AND d.conceptoid=".$conceptoid."";
    
            // switch($tiponomina)
            // {
            //     case 'empleados':
            //         $vsql.= " AND (t.esempleadoactivo='CHECKED' AND (t.extralegal = '' OR t.extralegal IS NULL)) ";
            //         break;
            //     case 'extralegal':
            //         $vsql.= " AND t.extralegal = 'CHECKED' ";
            //         break;
            //     case 'todos':
            //         $vsql.= " AND t.esempleadoactivo='CHECKED' ";
            //         break;
            //     default:
            //         break;
            // }
    
            // $vsql.= " ORDER BY codvende";
    
            // ------------------------------------------------------------------------------------------------------------------------------------------ //
            // Muestra el informe en una vista del sistema
            if($tiposalida=="vista")
            {
                // Inicializo las variables
                $monto = 0;            
    
                $cont = $clase->Header("S","W");
                $cont.='<table width="100%">
                         <tr class="CabezoteTabla"> 
                          <td width="10"> &nbsp; </td>
                          <td width="37"> <img src="images/iconos/informes.png" width="32" height="32" border="0"> </td>
                          <td width="840"> <b> Informe de conceptos por periodo </b> </td>
                          <td> &nbsp; </td>
                          <td width="8"> &nbsp; </td>
                         </tr>           
                        </table>';

                if($incluirliq == "CHECKED")
                    $htmlmsg = '<font color="blue"> SE INCLUYEN LIQUIDACIONES </font>';
                else
                    $htmlmsg = '';
    
                $cont.='<table width="100%">
                         <tr class="CabezoteTabla"> 
                          <td width="10"> &nbsp; </td>
                          <td width="37"> &nbsp; </td>
                          <!-- <td width="840"> <b> Periodo: </b> '.$descripcion.' <b>Concepto: </b> '.$nomconcepto.' <b>tipo:</b> '.strtoupper($tiponomina).'</td> -->
                          <td width="840"> <b> Periodo: </b> '.$descripcion.' <b>Concepto: </b> '.$nomconcepto.' '.$htmlmsg.' </td>
                          <td> &nbsp; </td>
                          <td width="8"> &nbsp; </td>
                         </tr>           
                        </table>';

                $cont.='<script type="text/javascript" src="lib/sorttable.js"></script>
                         <table width="100%" class="sortable">
                          <thead> 
                           <tr class="TituloTabla" style="display:block;padding-top:5px;height:20px;">
                            <td width="19"> &nbsp; </td>
                            <td width="45"> Nro </td>
                            <td width="66"> C&oacute;digo </td>
                            <td width="105"> C&eacute;dula </td>			
                            <td width="574"> Nombre </td>
                            <td width="60"> &nbsp; </td>
                            <td width="47"> &nbsp; </td>';                

                if(($eslicencia == "CHECKED") || ($recargo == "CHECKED"))
                    $cont.='<td width="100"> D&iacute;as </td>';
                else
                    $cont.='<td width="100"> &nbsp; </td>';
                
                $cont.='    <td width="20"> &nbsp; </td>
                            <td width="33"> &nbsp; </td>
                            <td width="213" align="right"> Monto </td>
                            <td width="30"> &nbsp; </td>
                           </tr>
                          </thead>
                          <tbody style="display:block; width:1050px; height:400px; overflow-Y:scroll">';

    
                // Impresión del detalle del informe
                $conex  = $clase->Conectar();
                $result = mysql_query($vsql,$conex);
                $total = 0;
                $i = 0;
                $linea = 0;
                while($row = mysql_fetch_array($result))
                {
                    $tipodc = $row['tipodc'];
                    if($tipodc=="C")
                        $monto = $row['devengados'];
                    else
                        $monto = $row['descuentos'];
                    
                    $terid = $row['terid'];
                    $pernominaid = $row['pernominaid'];                    

                    // determino si el periodo está cerrado
                    $cerrado = $clase->BDLockup($pernominaid,'periodosnomina','periodoid','cerrado');

                    $liquidacion = $row['liquidacion'];

                    if($liquidacion == 1)
                    {
                        $colorini = '<font color="blue">';
                        $colorfin = '</font>';
                    }
                    else
                    {
                        $colorini = '';
                        $colorfin = '';
                    }                    
    
                    $i++;
                    if($i%2 == 0)
                        $cont.='<tr class="TablaDocsPar">';
                    else
                        $cont.='<tr class="TablaDocsImPar">';

                    $linea++;

                    $cont.=' <td width="19"> &nbsp; </td>
                             <td width="45" align="center"> '.$colorini.' '.$linea.' '.$colorfin.' </td>
                             <td width="66"> '.$colorini.' '.$row['codvende'].' '.$colorfin.' </td>
                             <td width="95"> '.$colorini.' '.$row['dni'].' '.$colorfin.'</td>
                             <td width="584"> '.$colorini.' '.$row['nombreemp'].' '.$colorfin.' </td>
                             <td width="31"> &nbsp; </td>                         
                             <td width="73"> &nbsp; </td>';                    

                    if(($eslicencia == "CHECKED") || ($recargo == "CHECKED"))
                        $cont.='<td width="87"> '.$colorini.' '.number_format($row['valor']).' '.$colorfin.' </td>';
                    else
                        $cont.='<td width="87"> &nbsp; </td>';

                    $cont.=' <td width="112" align="center"> &nbsp; </td>';
    
                    if((($eslibranza=="CHECKED")||($montopermanente=="CHECKED")||($montoocasional=="CHECKED"))&&(($_SESSION['USERNAME'] == "LFLOREZ")||($_SESSION['USERNAME'] == "SAIDRODRIGUEZ")||($_SESSION["SUPERUSUARIO"] == "CHECKED"))&&($cerrado!="CHECKED"))
                        $cont.=' <td width="30" align="center"> 
                                  <a href="?opcion=editarconcepto&terid='.$terid.'&pernominaid='.$pernominaid.'&conceptoid='.$conceptoid.'" title="editar concepto" rel="facebox">
                                   <img src="images/basicas/iconobuscar.png" border="0">
                                  </a>
                                 </td> 
                                 <td width="30" align="center"> 
                                  <a href="?opcion=valborrarconcepto&terid='.$terid.'&pernominaid='.$pernominaid.'&conceptoid='.$conceptoid.'" rel="facebox" title="eliminar concepto">
                                   <img src="images/basicas/iconoborrar.png" border="0">
                                  </a>                             
                                 </td>';
                    else
                        $cont.=' <td width="30"> &nbsp; </td> 
                                 <td width="30"> &nbsp; </td>';
    
                    $cont.='  <td width="80" align="right"> '.$colorini.' '.number_format($monto).' '.$colorfin.' </td>
                              <td width="10"> &nbsp; </td>';
    
                    $cont.='</tr>';
    
                    // Incremento la variable del total
                    $total += $monto;
                }
    
                $cont.=' </tbody>
                        </table>';
    
                // Impresión del total
                $cont.='<table width="100%">
                         <tr class="TituloTabla"> 
                          <td width="10"> &nbsp; </td>
                          <td width="37"> &nbsp; </td>
                          <td width="160"> &nbsp; </td>
                          <td width="690" align="right"> <font color="WHITE"> <b> Total: </b> '.number_format($total).' </font> </td>
                          <td width="20"> &nbsp; </td>
                         </tr>
                        </table>';
    
                echo $cont.$clase->PiePagina();
            }
    
            // ------------------------------------------------------------------------------------------------------------------------------------------ //
            // Muestra el informe en formato PDF
            if($tiposalida=="pdf")
            {
                // Inicializo las variables
                $longitud = 0;
                $lineatotales = 0;
                $mesimp = "";
                $fechoraimp = "";
                $monto = 0;
                $tipodc = "";
                $enc = "";
                $pie = "";
    
                // Traducción al español del mes que devuelve la función date()
                $mesimp = date('F');
                if($mesimp=="January")       $mesimp = "Enero";
                if($mesimp=="February")      $mesimp = "Febrero";
                if($mesimp=="March")         $mesimp = "Marzo";
                if($mesimp=="April")         $mesimp = "Abril";
                if($mesimp=="May")           $mesimp = "Mayo";
                if($mesimp=="June")          $mesimp = "Junio";
                if($mesimp=="July")          $mesimp = "Julio";
                if($mesimp=="August")        $mesimp = "Agosto";
                if($mesimp=="September")     $mesimp = "Septiembre";
                if($mesimp=="October")       $mesimp = "Octubre";
                if($mesimp=="November")      $mesimp = "Noviembre";
                if($mesimp=="December")      $mesimp = "Diciembre";
    
                // Procedo a construir el encabezado del recibo
                ini_set("memory_limit","200M");
                require('lib/fpdf/fpdf.php');
                $pdf=new FPDF();
            
                // Página nueva
                $pdf->AddPage("");
                $pagina = 1;
    
                // Logo Dromedicas
                $pdf->Image('images/empresa/logo-dromedicas-en-azul.png',10,10,12,15,'PNG','');
    
                // Imprimo el encabezado del informe
                $x = 25;
                $y = 13;
                $pdf->SetFont('Arial','B',10);
                $enc= "DROMEDICAS DEL ORIENTE SAS - NIT: 900265730-0";
                $pdf->Text($x,$y,$enc);
    
                // Fecha y hora de impresión
                $fechoraimp = $mesimp." ".date('d')." de ".date('Y g:i a')."    Pagina: ".$pagina;
    
                $pdf->SetFont('Arial','',8);
                $pdf->Text($x+124,$y,$fechoraimp);
    
                $pdf->SetFont('Arial','B',10);
                $enc= "INFORME DE CONCEPTOS POR PERIODO";                   $pdf->Text($x,$y+5,$enc);
                $enc= "PERIODO: ";                                          $pdf->Text($x,$y+10,$enc);
                
                $pdf->SetFont('Arial','',10);
                $enc=strtoupper($descripcion);                              $pdf->Text($x+19,$y+10,$enc);
                
                $pdf->SetFont('Arial','B',10);
                $enc= "CONCEPTOS: ";                                        $pdf->Text($x,$y+15,$enc);

                $pdf->SetFont('Arial','',10);
                $enc=strtoupper($nomconcepto);                              $pdf->Text($x+25,$y+15,$enc);
    
                // $pdf->SetFont('Arial','B',10);
                // $enc= "TIPO: ";
                // $pdf->Text($x,$y+20,$enc);
                // $pdf->SetFont('Arial','',10);
                // $enc=strtoupper($tiponomina);
                // $pdf->Text($x+12,$y+20,$enc);

                // mensaje para informar si se incluyen liquidaciones
                if($incluirliq == "CHECKED")
                {
                    $enc = "SE INCLUYEN LIQUIDACIONES";
                    $pdf->Text($x,$y+20,$enc);
                }
    
                $pdf->SetFillColor(220,220,220);
                $pdf->Rect(5,38,200,8,'F');
                $pdf->SetFont('Arial','B',9);

                $enc= "NRO";                                                $pdf->Text($x-17,$y+30,$enc);
                $enc= "CODIGO";                                             $pdf->Text($x-7,$y+30,$enc);
                $enc= "DOCUMENTO";                                          $pdf->Text($x+8,$y+30,$enc);
                $enc= "EMPLEADO";                                           $pdf->Text($x+32,$y+30,$enc);

                if(($eslicencia == "CHECKED") || ($recargo == "CHECKED"))
                {
                    $enc= "DIAS";                                           $pdf->Text($x+120,$y+30,$enc);
                }

                $enc= "MONTO";                                              $pdf->Text($x+165,$y+30,$enc);
    
                // Impresión del detalle del informe
                $conex  = $clase->Conectar();
                $result = mysql_query($vsql,$conex);
                $total = 0;                 $x = 8;                 $y = 51;                    $i = 0;
                $linea = 0;
                while($row = mysql_fetch_array($result))
                {
                    $linea++;
                    $i++;                    
                    if($i%38==0)
                    {
                        $pdf->AddPage("");
                        $pagina++;
    
                        // Logo Dromedicas
                        $pdf->Image('images/empresa/logo-dromedicas-en-azul.png',10,10,12,15,'PNG','');
    
                        // Imprimo el encabezado del informe
                        $x = 25;
                        $y = 13;
                        $pdf->SetFont('Arial','B',10);
                        $enc= "DROMEDICAS DEL ORIENTE SAS - NIT: 900265730-0";                          $pdf->Text($x,$y,$enc);
    
                        // Fecha y hora de impresión
                        $fechoraimp = $mesimp." ".date('d')." de ".date('Y g:i a')."    Pagina: ".$pagina;
    
                        $pdf->SetFont('Arial','',8);
                        $pdf->Text($x+124,$y+10,$fechoraimp);
    
                        $pdf->SetFont('Arial','B',10);
    
                        $enc= "INFORME DE CONCEPTOS POR PERIODO";               $pdf->Text($x,$y+5,$enc);
    
                        $enc= "PERIODO: ";                                      $pdf->Text($x,$y+10,$enc);
                        $pdf->SetFont('Arial','',10);
                        $enc=strtoupper($descripcion);                          $pdf->Text($x+19,$y+10,$enc);
    
                        $pdf->SetFont('Arial','B',10);
                        $enc= "CONCEPTOS: ";                                    $pdf->Text($x,$y+15,$enc);
                        $pdf->SetFont('Arial','',10);
                        $enc=strtoupper($nomconcepto);                          $pdf->Text($x+25,$y+15,$enc);
    
                        // $pdf->SetFont('Arial','B',10);
                        // $enc= "TIPO: ";
                        // $pdf->Text($x,$y+20,$enc);
                        // $pdf->SetFont('Arial','',10);
                        // $enc=strtoupper($tiponomina);
                        // $pdf->Text($x+12,$y+20,$enc);
    
                        $pdf->SetFillColor(220,220,220);
                        $pdf->Rect(5,38,200,8,'F');
                        $pdf->SetFont('Arial','B',9);
                        $enc= "NRO";                                                $pdf->Text($x-17,$y+30,$enc);
                        $enc= "CODIGO";                                             $pdf->Text($x-7,$y+30,$enc);
                        $enc= "DOCUMENTO";                                          $pdf->Text($x+8,$y+30,$enc);
                        $enc= "EMPLEADO";                                           $pdf->Text($x+32,$y+30,$enc);                        

                        if(($eslicencia == "CHECKED") || ($recargo == "CHECKED"))
                        {
                            $enc= "DIAS";                                       $pdf->Text($x+120,$y+30,$enc);
                        }

                        $enc= "MONTO";                                          $pdf->Text($x+165,$y+30,$enc);
    
                        $x = 8;
                        $y = 51;
                    }
    
                    $pdf->SetFont('Arial','',8);

                    $longitud = strlen($linea);
                    if($longitud==1)                $pdf->Text($x+3,$y,$linea);
                    if($longitud==2)                $pdf->Text($x+2,$y,$linea);
                    if($longitud==3)                $pdf->Text($x+1,$y,$linea);
                    if($longitud==4)                $pdf->Text($x,$y,$linea);
                    
                    $pdf->Text($x+10,$y,$row['codvende']);
                    $pdf->Text($x+25,$y,$row['dni']);
                    $pdf->Text($x+49,$y,$row['nombreemp']);

                    // Impresión de los días en caso de ser una licencia
                    if(($eslicencia == "CHECKED") || ($recargo == "CHECKED"))
                    {
                        // Alineación de los montos correspondientes
                        $longitud = strlen($row['valor']);
                        
                        if($longitud==1)                $pdf->Text($x+142,$y,number_format($row['valor']));
                        if($longitud==2)                $pdf->Text($x+140,$y,number_format($row['valor']));
                        if($longitud==3)                $pdf->Text($x+138,$y,number_format($row['valor']));
                    }                    

                    $tipodc = $row['tipodc'];
    
                    if($tipodc=="C")
                        $monto = $row['devengados'];
                    else
                        $monto = $row['descuentos'];
    
                    // Alineación de los montos correspondientes
                    $longitud = strlen($monto);
    
                    if($longitud==4)            $pdf->Text($x+187,$y,number_format($monto,0));
                    if($longitud==5)            $pdf->Text($x+186,$y,number_format($monto,0));
                    if($longitud==6)            $pdf->Text($x+184,$y,number_format($monto,0));
                    if($longitud==7)            $pdf->Text($x+182,$y,number_format($monto,0));
    
                    $total += $monto;
                    $y+=6;
                }
    
                // Impresión del pie de página del informe
    
                // Totales
                $lineatotales = $y-2;
                $pdf->SetFillColor(220,220,220);
                $pdf->Rect(5,$lineatotales,200,8,'F');
    
                $pdf->SetFont('Arial','B',10);
                $pie= "TOTAL: ";                $pdf->Text($x+130,$y+3,$pie);
    
                // Alineación de los montos correspondientes
                $longitud = strlen($total);

                // echo $longitud; exit();
    
                if($longitud==5)            $pdf->Text($x+184,$y+3,number_format($total));
                if($longitud==6)            $pdf->Text($x+182,$y+3,number_format($total));
                if($longitud==7)            $pdf->Text($x+178,$y+3,number_format($total));
                if($longitud==8)            $pdf->Text($x+174,$y+3,number_format($total));
                if($longitud==9)            $pdf->Text($x+170,$y+3,number_format($total));
                // if($longitud==9)            $pdf->Text($x+166,$y+3,number_format($total));
                
                $pdf->Output();
            }
            
            // ------------------------------------------------------------------------------------------------------------------------------------------ //
            // El informe es mostrado en una salida a Excel
            if($tiposalida=="excel")
            {
                // mensaje para informar si se incluyen liquidaciones
                if($incluirliq == "CHECKED")
                    $xlsmsg = 'SE INCLUYEN LIQUIDACIONES';
                else
                    $xlsmsg = '';

                require_once 'lib/PHPExcel.php';
                $clase = new Sistema();
                $clase->Conectar();
                ini_set("memory_limit","100M");
                
                // Preparación del entorno para la salida a Excel
                $clase = new Sistema();
                $clase->Nombredb = $_SESSION['DBNOMBRE'];
                error_reporting(E_ALL);
                ini_set('display_errors', TRUE);
                ini_set('display_startup_errors', TRUE);
                date_default_timezone_set('Europe/London');
            
                if (PHP_SAPI == 'cli')
                    die('This example should only be run from a Web Browser');
            
                // Create new PHPExcel object
                $objPHPExcel = new PHPExcel();
            
                // Set document properties
                $objPHPExcel->getProperties()->setCreator("Sistemas y Soluciones Web de Colombia")
                                             ->setLastModifiedBy("Sistemas y Soluciones Web de Colombia")
                                             ->setTitle("Periodo por concepto - DROPOS")
                                             ->setSubject("Periodo por concepto - DROPOS")
                                             ->setDescription("Periodo por concepto - DROPOS")
                                             ->setKeywords("Periodo por concepto - DROPOS")
                                             ->setCategory("Categoria General");

                if(($eslicencia != "CHECKED") && ($recargo != "CHECKED"))
                {
                    $objPHPExcel->setActiveSheetIndex(0)
                                ->setCellValue('A1', 'INFORME DE CONCEPTOS POR PERIODO')
                                ->setCellValue('A2', 'PERIODO: '.$descripcion)				
                                ->setCellValue('A3', 'CONCEPTO: '.$nomconcepto)
                                ->setCellValue('A4', $xlsmsg)
                                ->setCellValue('A5', 'NRO')
                                ->setCellValue('B5', 'CODIGO')
                                ->setCellValue('C5', 'CEDULA')
                                ->setCellValue('D5', 'NOMBRE')
                                ->setCellValue('E5', 'MONTO');

                    $objPHPExcel->getActiveSheet()->getColumnDimension('A')->setAutoSize(true);         $objPHPExcel->getActiveSheet()->getColumnDimension('B')->setAutoSize(true);
                    $objPHPExcel->getActiveSheet()->getColumnDimension('C')->setAutoSize(true);         $objPHPExcel->getActiveSheet()->getColumnDimension('D')->setAutoSize(true);
                    $objPHPExcel->getActiveSheet()->getColumnDimension('E')->setAutoSize(true);
                }
                else
                {
                    $objPHPExcel->setActiveSheetIndex(0)
                                ->setCellValue('A1', 'INFORME DE CONCEPTOS POR PERIODO')
                                ->setCellValue('A2', 'PERIODO: '.$descripcion)				
                                ->setCellValue('A3', 'CONCEPTO: '.$nomconcepto)                        
                                ->setCellValue('A5', 'NRO')
                                ->setCellValue('B5', 'CODIGO')
                                ->setCellValue('C5', 'CEDULA')
                                ->setCellValue('D5', 'NOMBRE')
                                ->setCellValue('E5', 'DIAS')
                                ->setCellValue('F5', 'MONTO');

                    $objPHPExcel->getActiveSheet()->getColumnDimension('A')->setAutoSize(true);         $objPHPExcel->getActiveSheet()->getColumnDimension('B')->setAutoSize(true);
                    $objPHPExcel->getActiveSheet()->getColumnDimension('C')->setAutoSize(true);         $objPHPExcel->getActiveSheet()->getColumnDimension('D')->setAutoSize(true);
                    $objPHPExcel->getActiveSheet()->getColumnDimension('E')->setAutoSize(true);         $objPHPExcel->getActiveSheet()->getColumnDimension('F')->setAutoSize(true);
                }

                $objPHPExcel->getActiveSheet(0)->freezePaneByColumnAndRow(0,6);
                
                $conex  = $clase->Conectar();
                $result = mysql_query($vsql,$conex);
                $cant   = mysql_num_rows($result);
                $total = 0;
                $i = 6;
                $linea = 0;
                while($row = mysql_fetch_array($result))
                {
                    $tipodc = $row['tipodc'];
                    if($tipodc=="C")
                        $monto = $row['devengados'];
                    else
                        $monto = $row['descuentos'];

                    // formateo el código
                    $codvende = $row['codvende'];
                    if(substr($codvende,0,1) == "0")            $codvende="'".$codvende;


                    $linea++;

                    if(($eslicencia != "CHECKED") && ($recargo != "CHECKED"))
                        $objPHPExcel->setActiveSheetIndex(0)
                                    ->setCellValue('A'.$i, number_format($linea))
                                    ->setCellValue('B'.$i, $codvende)
                                    ->setCellValue('C'.$i, $row['dni'])
                                    ->setCellValue('D'.$i, $row['nombreemp'])
                                    ->setCellValue('E'.$i, number_format($monto));
                    else
                        $objPHPExcel->setActiveSheetIndex(0)
                                    ->setCellValue('A'.$i, number_format($linea))
                                    ->setCellValue('B'.$i, $codvende)
                                    ->setCellValue('C'.$i, $row['dni'])
                                    ->setCellValue('D'.$i, $row['nombreemp'])
                                    ->setCellValue('E'.$i, number_format($row['valor']))
                                    ->setCellValue('F'.$i, number_format($monto));

                    $i++;
                    $total += $monto;
                }

                if(($eslicencia != "CHECKED") && ($recargo != "CHECKED"))
                    $objPHPExcel->setActiveSheetIndex(0)
                                ->setCellValue('A'.$i, '')
                                ->setCellValue('B'.$i, '')
                                ->setCellValue('C'.$i, '')
                                ->setCellValue('D'.$i, 'TOTAL:')
                                ->setCellValue('E'.$i, number_format($total));
                else
                    $objPHPExcel->setActiveSheetIndex(0)
                                ->setCellValue('A'.$i, '')
                                ->setCellValue('B'.$i, '')
                                ->setCellValue('C'.$i, '')
                                ->setCellValue('D'.$i, '')
                                ->setCellValue('E'.$i, 'TOTAL:')
                                ->setCellValue('F'.$i, number_format($total));                
                $i--;

                if(($eslicencia != "CHECKED") && ($recargo != "CHECKED"))
                {
                    $rangoEncabezado = 'A5:E5';
                    $rangoCeldas     = 'A5:E'.($i);
                }
                else
                {
                    $rangoEncabezado = 'A5:F5';
                    $rangoCeldas     = 'A5:F'.($i);                    
                }
                
                // Formato de Encabezado y Celdas
                $objPHPExcel->getActiveSheet()->getRowDimension('1')->setRowHeight(15);
                
                $EstiloCeldas = array(
                'borders' => array(
                    'allborders' => array(
                        'style' => PHPExcel_Style_Border::BORDER_THIN,
                        'color' => array('argb' => '00000000'),
                    ),
                    ),
                );
                $objPHPExcel->getActiveSheet()->getStyle($rangoCeldas)->applyFromArray($EstiloCeldas);
                /// Formato de Encabezados 
                $EstiloEncabezado = array(
                'font' => array(
                    'bold' => true,
                ),
                'alignment' => array(
                    'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,
                    'vertical' => PHPExcel_Style_Alignment::VERTICAL_CENTER,		
                ),
                'borders' => array(
                    'allborders' => array(
                        'style' => PHPExcel_Style_Border::BORDER_THIN,
                        'color' => array('argb' => '00000000'),
                    ),
                ),
                'fill' => array(
                    'type' => PHPExcel_Style_Fill::FILL_SOLID,
                    'rotation' => 90,
                    'startcolor' => array(
                        'argb' => '00FFFFCC',
                    ),
                    'endcolor' => array(
                        'argb' => 'FFFFFF',
                    ),
                    ),
                );
                $objPHPExcel->getActiveSheet()->getStyle($rangoEncabezado)->applyFromArray($EstiloEncabezado);
                // Rename worksheet
                $objPHPExcel->getActiveSheet()->setTitle('Periodo por concepto');
                // Set active sheet index to the first sheet, so Excel opens this as the first sheet
                $objPHPExcel->setActiveSheetIndex(0);
                // Redirect output to a client’s web browser (Excel5)
                header('Content-Type: application/vnd.ms-excel');
                // ------------------------------------------------------------------------------------------------------ //
                // header('Content-Disposition: attachment;filename="conceptoxperiodo.xls"');
                $nombrearcexcel = "concepto por periodo ".strtolower($nomconcepto)." ".strtolower($descripcion).".xls";
                header('Content-Disposition: attachment;filename='.$nombrearcexcel.'');            
                // ------------------------------------------------------------------------------------------------------ //
                header('Cache-Control: max-age=0');
                /// Genero la Salida
                $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');
                $objWriter->save('php://output');
                exit;
            }
        }
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opciones: editarconcepto
    // Creación: 08/08/2022		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción para editar los datos del concepto
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion=="editarconcepto")
    {
        $terid = $_GET['terid'];
        $pernominaid = $_GET['pernominaid'];
        $conceptoid = $_GET['conceptoid'];

        // nombre del empleado        
        $vsql2 = "SELECT CONCAT(primernombre,' ',segundonombre,' ',primerapellido,' ',segundoapellido) AS nombreemp FROM tercerosactual WHERE terid = ".$terid." AND pernominaid = ".$pernominaid;
        $nombreemp = $clase->SeleccionarUno($vsql2);

        // ids
        $vsql3 = "SELECT detalleid FROM detallenomina WHERE terid = ".$terid." AND pernominaid = ".$pernominaid." AND conceptoid = ".$conceptoid;
        $detalleid = $clase->SeleccionarUno($vsql3);

        $cerrado = $clase->BDLockup($pernominaid,'periodosnomina','periodoid','cerrado');

        if($cerrado=='CHECKED')
        {
            $vsql4 = "SELECT detalleid FROM hisdetallenomina WHERE terid = ".$terid." AND pernominaid = ".$pernominaid." AND conceptoid = ".$conceptoid;
            $detalleid2 = $clase->SeleccionarUno($vsql4);
        }
        else
            $detalleid2 = 0;

        $tipodc = $clase->BDLockup($conceptoid,'conceptosnomina','conceptoid','tipodc');

        if($tipodc=="C")
            $vsql5 = "SELECT devengados FROM detallenomina WHERE terid = ".$terid." AND pernominaid = ".$pernominaid." AND conceptoid = ".$conceptoid;
        else
            $vsql5 = "SELECT descuentos FROM detallenomina WHERE terid = ".$terid." AND pernominaid = ".$pernominaid." AND conceptoid = ".$conceptoid;
            
        $monto = $clase->SeleccionarUno($vsql5);

        $nomconcepto = $clase->BDLockup($conceptoid,'conceptosnomina','conceptoid','nomconcepto');

        // pinto la ventana
        $cont= '<table width="400">
                 <tr class="CabezoteTabla"> 
                  <td align="center"> <b>Editar concepto</b> </td>                  
                 </tr>
                 <tr class="CabezoteTabla"> 
                  <td align="center"> Empleado(a): <br><b>'.$nombreemp.'</b> </td>                  
                 </tr>
                 <tr class="CabezoteTabla"> 
                  <td align="center"> Concepto: <br><b>'.$nomconcepto.'</b> </td>                  
                 </tr>
                </table>
                <form action="repconceptoporperiodo.php?opcion=almconcepto" method="POST" name="x">                
                <input type="hidden" name="detalleid" value="'.$detalleid.'">
                <input type="hidden" name="detalleid2" value="'.$detalleid2.'">
                <input type="hidden" name="conceptoid" value="'.$conceptoid.'">
                <table width="400">
                 <center>
                 <tr class="TablaDocsImPar">				
                  <td width="150" align="right"> &Uacute;ltimo sueldo: &nbsp;</td> 			  
                  <td width="250"> <input type="number" name="monto" class="Texto12New" size="4" min="1" maxlength="4" autocomplete="off" value="'.$monto.'"></td>
                 </tr>
                </table>
                <br>
                <center>
                <input type="submit" value="aceptar" class="button blue">
                </form><br>';
        echo $cont;
        exit();        
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opciones: almconcepto
    // Creación: 08/08/2022		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción para guardar los datos del concepto
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////    
    if($opcion=="almconcepto")
    {
        $detalleid = $_POST['detalleid'];
        $detalleid2 = $_POST['detalleid2'];
        $monto = $_POST['monto'];
        $conceptoid = $_POST['conceptoid'];

        $tipodc = $clase->BDLockup($conceptoid,'conceptosnomina','conceptoid','tipodc');        

        // Modifico el monto en la tabla detallenomina
        if($tipodc=="C")
            $vsql = "UPDATE detallenomina SET 
                            devengados = ".$monto."
                      WHERE detalleid = ".$detalleid;
        else
            $vsql = "UPDATE detallenomina SET 
                            descuentos = ".$monto."
                      WHERE detalleid = ".$detalleid;

        $clase->EjecutarSQL($vsql);
        
        if(mysql_affected_rows() >= 1)
            $grabo = true;
        else
            $grabo = false;

        // Modifico el monto en la tabla hisdetallenomina
        if($detalleid2!=0)
        {
            if($tipodc=="C")
                $vsql2 = "UPDATE hisdetallenomina SET 
                                 devengados = ".$monto."
                           WHERE detalleid = ".$detalleid2;
            else
                $vsql2 = "UPDATE hisdetallenomina SET 
                                 descuentos = ".$monto."
                           WHERE detalleid = ".$detalleid2;

            $clase->EjecutarSQL($vsql2);

            if(mysql_affected_rows() >= 1)
                $grabo2 = true;
            else
                $grabo2 = false;
        }

        // Emito el mensaje correspondiente
        if($grabo||$grabo2)
            $clase->Aviso(1,"Concepto editado satisfactoriamente");
        else
            $clase->Aviso(3,"No se editó el concepto");

        // Redirecciono el formulario
        header("Location: repconceptoporperiodo.php?opcion=ventanadatos");
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opciones: valborrarconcepto
    // Creación: 08/08/2022		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: opción para confirmar la eliminación de un concepto 
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "valborrarconcepto")
    {
        $terid = $_GET['terid'];
        $pernominaid = $_GET['pernominaid'];
        $conceptoid = $_GET['conceptoid'];
        
        // nombre del empleado
        $vsql2 = "SELECT CONCAT(primernombre,' ',segundonombre,' ',primerapellido,' ',segundoapellido) AS nombreemp FROM tercerosactual WHERE terid = ".$terid." AND pernominaid = ".$pernominaid;
        $nombreemp = $clase->SeleccionarUno($vsql2);
        
        // ids
        $vsql3 = "SELECT detalleid FROM detallenomina WHERE terid = ".$terid." AND pernominaid = ".$pernominaid." AND conceptoid = ".$conceptoid;
        $detalleid = $clase->SeleccionarUno($vsql3);

        $cerrado = $clase->BDLockup($pernominaid,'periodosnomina','periodoid','cerrado');

        if($cerrado=='CHECKED')
        {
            $vsql4 = "SELECT detalleid FROM hisdetallenomina WHERE terid = ".$terid." AND pernominaid = ".$pernominaid." AND conceptoid = ".$conceptoid;
            $detalleid2 = $clase->SeleccionarUno($vsql4);
        }
        else
            $detalleid2 = 0;        

        $tipodc = $clase->BDLockup($conceptoid,'conceptosnomina','conceptoid','tipodc');

        if($tipodc=="C")
            $vsql5 = "SELECT devengados FROM detallenomina WHERE terid = ".$terid." AND pernominaid = ".$pernominaid." AND conceptoid = ".$conceptoid;
        else
            $vsql5 = "SELECT descuentos FROM detallenomina WHERE terid = ".$terid." AND pernominaid = ".$pernominaid." AND conceptoid = ".$conceptoid;
            
        $monto = $clase->SeleccionarUno($vsql5);

        $nomconcepto = $clase->BDLockup($conceptoid,'conceptosnomina','conceptoid','nomconcepto');        

        // pinto la ventana
        $cont='<table width="500">
                <tr class="CabezoteTabla"> 
                 <td align="center"><br><b>Eliminar concepto</b><br><br><td> 
                </tr> 
               </table>
               <table width="500">
                <tr class="TablaDocsImPar">       
                <td width="400" align="center">¿Confirma que desea eliminar el concepto <br><b>'.$nomconcepto.'</b> <br> por un monto de <b>'.number_format($monto).'</b> pesos <br> al empleado(a) <br><b>'.trim($nombreemp).'</b>?</td>
                </tr>
                <tr class="TablaDocsImPar">       
                 <td width="400" align="center"><br><br>                  
                  <form action="?opcion=elimconcepto&id='.$id.'" method="POST">
                   <input type="hidden" name="detalleid" value="'.$detalleid.'">
                   <input type="hidden" name="detalleid2" value="'.$detalleid2.'">                   
                   <input type="submit" value="ACEPTAR" class="button red">
                  </form>
                  <br>
                 </td>        
                </tr>
               </table><br>';
        echo $cont;
        exit();
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opciones: elimconcepto
    // Creación: 08/08/2022		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: opción que elimina un concepto
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////    
    if($opcion == "elimconcepto")
    {
        $detalleid = $_POST['detalleid'];
        $detalleid2 = $_POST['detalleid2'];        

        // Elimino el concepto
        $vsql = "DELETE FROM detallenomina WHERE detalleid = ".$detalleid;
        $clase->EjecutarSQL($vsql);
        
        if(mysql_affected_rows() >= 1)
            $elimino = true;
        else
            $elimino = false;

        if($detalleid2!=0)
        {
            // Elimino el concepto
            $vsql = "DELETE FROM hisdetallenomina WHERE detalleid = ".$detalleid2;
            $clase->EjecutarSQL($vsql);
            
            if(mysql_affected_rows() >= 1)
                $elimino2 = true;
            else
                $elimino2 = false;
        }

        // Emito el mensaje correspondiente
        if($elimino||$elimino2)
            $clase->Aviso(1,"Concepto eliminado satisfactoriamente");
        else
            $clase->Aviso(3,"No se eliminó el concepto");

        // Redirecciono el formulario
        header("Location: repconceptoporperiodo.php?opcion=ventanadatos");        
    }
?>