<?PHP
    @session_start(); 

    require_once("classes/class_validaciones.php");
    $io_fecha=new class_validaciones();

    include("lib/Sistema.php");  
    
    $clase = new Sistema();
    $clase->Nombredb = $_SESSION['DBNOMBRE'];  
    $avisos = ""; 
    $opcion = "";
    $opcion = $_GET["opcion"];

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opciones: valprenomina
    // Creación: 19/07/2021		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que valida si el usuario actual puede procesar pre novedades    
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "valprenomina")
    {
        $username = $_SESSION['USERNAME'];
        $vsqldatos = "SELECT terid AS teridlider FROM usuarios WHERE username = '".$username."'";
        $teridlider = $clase->SeleccionarUno($vsqldatos);

        if($teridlider == 0)
        {
            $clase->Aviso(3,"El usuario $username no está asociado a ningún tercero");
            header("Location: periodosnomina.php");
        }
        else
        {            
            $vsqldatos = "SELECT idlider FROM seccion WHERE idlider = ".$teridlider;
            $idlider = $clase->SeleccionarUno($vsqldatos);

            if($idlider == 0)
            {
                $clase->Aviso(3,"El usuario $username no es líder de ninguna sección");
                header("Location: principal.php");
            }
            else
                header("Location: prenovedades.php?opcion=ventanadatos&idlider=$idlider");      // Redirecciono a la ventana de las pre novedades
        }
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: guardarprenovedad
    // Creación: 21/07/2021		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción para almacenar la pre novedad
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "guardarprenovedad")
    {
        $periodoid = $_POST['periodoid'];
        $terid = $_POST['terid'];
        $dias = $_POST['dias'];
        $conceptoid = $_POST['conceptoid'];
        $fecdesde = $_POST['fecdesde'];
        $idlider = $_POST['idlider'];

        // Validación de la fecha de inicio de la novedad
        if(strlen($fecdesde) == 0)
            $clase->Aviso(3,"Debe incluir todos los datos");
        else
        {
            // Obtengo el nuevo id de la pre novedad
            $vsql = "SELECT MAX(idnovedad) FROM prenovedades";
            $numreg = $clase->SeleccionarUno($vsql);
            $numreg++;

            $estatus = "PENDIENTE";

            $vsql = "INSERT INTO prenovedades VALUES ($numreg,".$terid.",".$conceptoid.",".$periodoid.",'".$fecdesde."','".$dias."','".$estatus."')";
            $clase->EjecutarSQL($vsql);

            // Envío el mensaje correspondiente
            if(mysql_affected_rows() < 1)
                $clase->Aviso(3,"No se incluyó la pre novedad");
            else
                $clase->Aviso(1,"Pre novedad incluida satisfactoriamente");
        }

        // Redirecciono a la ventana de las pre novedades
        header("Location: prenovedades.php?opcion=ventanadatos&idlider=$idlider");
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: confirmacion
    // Creación: 22/07/2021		última modificación: 07/03/2023
    // Creador: Luis Flórez		modificado por: Luis Flórez
    // Descripción: Opción para confirmar la eliminación de una pre novedad
    // Última modificación: Validación del estatus de la pre novedad (16/02/2023)
    //                      Validación de la eliminación de la pre novedad
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "confirmacion")
    {
        $idnovedad  = $_GET['idnovedad'];
        $idlider  = $_GET['idlider'];

        $estatus = $clase->BDLockup($idnovedad,'prenovedades','idnovedad','estatus');
        
        if($estatus == "")
        {
            $cont ='<table width="500">
                     <tr class="CabezoteTabla"> 
                      <td width="10" align="left"><img src="images/iconos/alerta.png" width="32" height="32" border="0"></td> 
                      <td width="490" align="center"><label class="Texto12"><font color="red"><b>Esta pre novedad ha sido eliminada <br> por n&oacute;mina</b></font></label><br></td> 
                     </tr> 
                    </table>
                    <table width="500">
                     <tr class="TablaDocsImPar">       
                      <td width="500" align="center"><br><br>
                       <form action="?opcion=ventanadatos" method="POST"> 
                       <input type="hidden" name="idlider" value="'.$idlider.'">
                       <input type="submit" value="ACEPTAR" class="button red"> 
                       </form>
                      </td>
                     </tr>
                    </table>';
            echo $cont;
            exit();
        }
        else
        {
            if($estatus == "PROCESADA")
            {
                $cont ='<table width="500">
                         <tr class="CabezoteTabla"> 
                          <td width="10" align="left"><img src="images/iconos/alerta.png" width="32" height="32" border="0"></td> 
                          <td width="490" align="center"><label class="Texto12"><font color="red"><b>Esta pre novedad ya ha sido procesada</b></font></label><br></td> 
                         </tr> 
                        </table>
                        <table width="500">
                         <tr class="TablaDocsImPar">       
                          <td width="500" align="center"><br><br>
                           <form action="?opcion=ventanadatos" method="POST"> 
                           <input type="hidden" name="idlider" value="'.$idlider.'">
                           <input type="submit" value="ACEPTAR" class="button red"> 
                           </form>
                          </td>
                         </tr>
                        </table>';
                echo $cont;
                exit();
            }
            else
            {
                // Nombre del empleado
                $terid = $clase->BDLockup($idnovedad,'prenovedades','idnovedad','terid');
                $vsql = "SELECT CONCAT(primernombre,' ',segundonombre,' ',primerapellido,' ',segundoapellido) AS nombreemp FROM terceros WHERE terid = ".$terid."";
                $nombreemp = $clase->SeleccionarUno($vsql);
        
                $cont ='<table width="500">
                         <tr class="CabezoteTabla"> 
                          <td align="center"><br><label class="Texto12"><b>Eliminar una pre novedad</b></label><br><br></td> 
                         </tr> 
                        </table>
                        <table width="500">
                         <tr class="TablaDocsImPar">       
                          <td width="400" align="center">
                           <label class="Texto12">¿Confirma que desea eliminar la licencia a <br><b> '.$nombreemp.'</b>?</label>
                           <br>
                          </td>       
                         </tr>
                         <tr class="TablaDocsImPar">       
                          <td width="400" align="center"><br><br>
                           <form action="?opcion=eliminar" method="POST">
                           <input type="hidden" name="idnovedad" value="'.$idnovedad.'">
                           <input type="hidden" name="idlider" value="'.$idlider.'">
                           <input type="submit" value="ACEPTAR" class="button red">
                           <a href="prenovedades.php?opcion=ventanadatos&idlider='.$idlider.'" ><input type="button" value="CANCELAR" class="button blue"></a>
                           </form>
                           <br>
                          </td>        
                         </tr>
                        </table><br>';
                echo $cont;
                exit();
            }
        }
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: eliminar
    // Creación: 22/07/2021		última modificación: 15/02/2023
    // Creador: Luis Flórez		modificado por: Luis Flórez
    // Descripción: Opción que elimina físicamente una pre novedad
    // Última modificación: Validación del estatus de la novedad
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "eliminar")
    {
        $idnovedad = $_POST['idnovedad'];
        $idlider = $_POST['idlider'];

        $estatus = $clase->BDLockup($idnovedad,'prenovedades','idnovedad','estatus');

        if($estatus == "PROCESADA")
            $clase->Aviso(3,"No se puede eliminar esta novedad porque ya ha sido procesada");
        else
        {
            $vsql = "DELETE FROM prenovedades WHERE idnovedad = ".$idnovedad;
            $clase->EjecutarSQL($vsql);
    
            // valido que se almacenen los datos para emitir el mensaje correspondiente
            if(mysql_affected_rows() < 1)
                $clase->Aviso(3,"No se eliminó pre novedad");
            else
                $clase->Aviso(1,"Pre novedad eliminada exitosamente");
        }

        header("Location: prenovedades.php?opcion=ventanadatos&idlider=$idlider");
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opciones: ventanadatos
    // Creación: 19/07/2021		última modificación: 29/01/2024
    // Creador: Luis Flórez		modificado por: Luis Flórez
    // Descripción: Opción que pinta la ventana donde se procesarán las pre novedades
    // Última modificación: Adaptación para ver una o varias secciones al mismo líder
    //                      (29/07/2021)
    //                      Fecha del movimiento de acuerdo a la configuración establecida
    //                      (17/05/2023)
    //                      Fecha del movimiento en el encabezado y en el detalle de las 
    //                      licencias guardadas de acuerdo la configuración establecida
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "ventanadatos")
    {
        $idlider = $_GET['idlider'];        // id del lider de la sección
        
        if(strlen($idlider) == 0)          $idlider = $_POST['idlider'];

        // Nombre del periodo
        $vsql = "SELECT periodoid
                   FROM periodosnomina 
                  WHERE periodoid = (SELECT MIN(periodoid) FROM periodosnomina WHERE cerrado ='')";
        $periodoid = $clase->SeleccionarUno($vsql);

        $descripcion = $clase->BDLockup($periodoid,'periodosnomina','periodoid','descripcion');

        // Nombre e id de la sección o de las secciones
        $vsqldatos = "SELECT COUNT(*) AS nrosecciones
                        FROM seccion
                       WHERE idlider = ".$idlider;
        $nrosecciones = $clase->SeleccionarUno($vsqldatos);

        if($nrosecciones==1)
        {
            $descripcionsec = $clase->BDLockup($idlider,'seccion','idlider','descripcionsec');
            $seccionid = $clase->BDLockup($idlider,'seccion','idlider','seccionid');
        }
        else
        {
            // Si son varias secciones asignadas aquí obtengo los id y los nombres
            $listaidsec = "";
            $listanbsec = "";

            $vsqldatos = "SELECT seccionid, descripcionsec
                            FROM seccion
                           WHERE idlider = ".$idlider;
            $conex  = $clase->Conectar();
            $result = mysql_query($vsqldatos,$conex);
            while($row = mysql_fetch_array($result))  
            {
                $listaidsec.= $row['seccionid'].",";
                $listanbsec.= $row['descripcionsec']." - ";
            }
            $listaidsec = substr($listaidsec, 0, -1);
            $listanbsec = substr($listanbsec, 0, -2);
            $descripcionsec = $listanbsec;
        }

        // Nombre del lider
        $vsqldatos = "SELECT CONCAT(primernombre,' ',segundonombre,' ',primerapellido,' ',segundoapellido) AS nombrelider FROM terceros WHERE terid = ".$idlider;
        $nombrelider = $clase->SeleccionarUno($vsqldatos);

        // Combo de empleados
        if($nrosecciones == 1)
            $vsqlcomboemp = "SELECT t.terid, CONCAT(t.dni,' - ',t.primernombre,' ',t.segundonombre,' ',t.primerapellido,' ',t.segundoapellido) AS nombreemp 
                               FROM seccionterceros st
                                    INNER JOIN terceros t ON (st.terid = t.terid)
                              WHERE st.seccionid = ".$seccionid." 
                           ORDER BY t.nombres";
        else
            $vsqlcomboemp = "SELECT t.terid, CONCAT(t.dni,' - ',t.primernombre,' ',t.segundonombre,' ',t.primerapellido,' ',t.segundoapellido,' - ',s.descripcionsec) AS nombreemp 
                               FROM seccionterceros st 
                                    INNER JOIN terceros t ON (st.terid = t.terid) 
                                    INNER JOIN seccion s ON (s.seccionid = st.seccionid) 
                              WHERE st.seccionid IN ($listaidsec) 
                           ORDER BY t.nombres";

        // Combo de licencias
        $vsqlcombolic = "SELECT conceptoid, CONCAT(codconcepto,' - ',nomconcepto) FROM conceptosnomina WHERE eslicencia = 'CHECKED' ORDER BY conceptoid";

        // Variables para las fechas y los días
        $fecdesde = $clase->BDLockup($periodoid,'periodosnomina','periodoid','fecdesde');
        $fechasta = $clase->BDLockup($periodoid,'periodosnomina','periodoid','fechasta');
        $dias = 1;

        // Pinto la ventana
        $cont = $clase->Header("S","W");
        $cont.='<table width="100%">
                 <tr class="CabezoteTabla"> 
                  <td width="10"> &nbsp; </td>
                  <td width="37"> <img src="images/iconos/terceros.png" width="32" height="32" border="0"> </td>
                  <td width="880"> <b>Pre novedades del periodo <font color="BLUE">'.$descripcion.'</font></b> </td>
                  <td width="10" align="center"> 
                   <a href="?opcion=importarexcel&idlider='.$idlider.'" title="importar novedades desde una hoja de Excel " rel="facebox"> 
                    <img src="images/iconos/importarexcel.png" border="0" width="32" height="32"> 
                   </a> 
                  </td>
                  <td width="10"> &nbsp; </td>
                  <td width="10" align="center"> 
                   <a href="?opcion=ventanadatos&idlider='.$idlider.'" title="refrescar la ventana">
                    <img src="images/iconos/refrescar.png" border="0" width="32" height="32"> 
                   </a> 
                  </td>
                  <td width="20"> &nbsp; </td>
                 </tr>
                </table>';
        
        $cont.='<form action="?opcion=guardarprenovedad" name="y" method="POST">
                <input type="hidden" name="idlider" value="'.$idlider.'">
                <input type="hidden" name="periodoid" value="'.$periodoid.'">
                <input type="hidden" name="fecdesde" value="'.$fecdesde.'">
                <table width="100%">
                 <tr class="CabezoteTabla"> 
                  <td width="10"> &nbsp; </td>
                  <td width="57"> &nbsp; </td>
                  <td width="999"><label class="Texto12">Secci&oacute;n:</label> '.$descripcionsec.' </td>
                  <td width="319">&nbsp; </td>
                 </tr>
                 <tr class="CabezoteTabla"> 
                  <td width="10"> &nbsp; </td>
                  <td width="57"> &nbsp; </td>
                  <td width="999"><label class="Texto12">L&iacute;der:</label> '.$nombrelider.'</td>
                  <td width="319"> &nbsp; </td>
                 </tr>
                 <tr class="CabezoteTabla"> 
                  <td width="10"> &nbsp; </td>
                  <td width="57"> &nbsp; </td>
                  <td width="313">
                   <label class="Texto12"> Empleado:&nbsp;</label>'.$clase->CrearComboBuscar("terid",$vsqlcomboemp,"nombres","terid","","N",$params,500).'
                  </td>
                  <td width="319"> &nbsp; </td>
                 </tr>
                 <tr class="CabezoteTabla"> 
                  <td width="10"> &nbsp; </td>
                  <td width="57"> &nbsp; </td>
                  <td width="313">
                   <label class="Texto12"> Licencia:&nbsp;&nbsp;&nbsp;&nbsp;</label>'.$clase->CrearComboBuscar("conceptoid",$vsqlcombolic,"nombres","conceptoid","","N",$params,420).'
                  </td>
                  <td width="319"> &nbsp; </td>
                 </tr>';

        // Validación de la fecha del movimiento
        $variab = 'G_NOFECHALIC';
        $nofechalic = $clase->BDLockup($variab,'configuraciones','variab','contenido');

        if($nofechalic != "CHECKED")
            $cont.=' <tr class="CabezoteTabla"> 
                      <td width="10"> &nbsp; </td>
                      <td width="57"> &nbsp; </td>
                      <td width="313"> 
                       <label class="Texto12">Fecha desde:&nbsp;&nbsp;</label>
                       <input type="date" name="fecdesde" class="Texto12New" autocomplete="off" min="'.$fecdesde.'" max ="'.$fechasta.'">
                      </td>
                      <td width="319"> &nbsp; </td>
                     </tr>';
        
        $cont.=' <tr class="CabezoteTabla"> 
                  <td width="10"> &nbsp; </td>
                  <td width="57"> &nbsp; </td>
                  <td width="313"> 
                   <label class="Texto12">D&iacute;as:&nbsp;&nbsp;</label>
                   <input type="number" name="dias" min="1" max="180" class="Texto12New" size="12" style="width:60px;height:25px;" autocomplete="off" title="días de la licencia" value="'.$dias.'"> 
                  </td> 
                  <td width="319" align="left"> &nbsp; </td>
                 </tr>
                </table>';

        // botón de guardar
        $cont.='<table width="100%">
                 <tr class="CabezoteTabla"> 
                  <td align="center">
                   <input type="submit" value="guardar" class="button blue">
                   </form>
                   <br><br>
                  </td>
                 </tr>
                </table>';

        // Impresión de las pre novedades cargadas
        if($nofechalic != "CHECKED")
            $cont.='<script type="text/javascript" src="lib/sorttable.js"></script>
                    <table width="100%" class="sortable">
                     <thead> 
                      <tr class="TituloTabla" style="display:block;padding-top:5px;height:20px;">
                       <td width="30"> &nbsp; </td>
                       <td width="430" align="left"> Nombre </td>
                       <td width="423" align="left"> Concepto </td>
                       <td width="102" align="left"> Fecha </td>
                       <td width="40" align="right"> D&iacute;as </td>
                       <td width="30"> &nbsp; </td>
                       <td width="30"> &nbsp; </td>
                      </tr>
                     </thead>
                     <tbody style="display:block; width:1050px; height:250px; overflow-Y:scroll">';
        else
            $cont.='<script type="text/javascript" src="lib/sorttable.js"></script>
                    <table width="100%" class="sortable">
                     <thead> 
                      <tr class="TituloTabla" style="display:block;padding-top:5px;height:20px;">
                       <td width="30"> &nbsp; </td>
                       <td width="430" align="left"> Nombre </td>
                       <td width="525" align="left"> Concepto </td>
                       <td width="40" align="right"> D&iacute;as </td>
                       <td width="30"> &nbsp; </td>
                       <td width="30"> &nbsp; </td>
                      </tr>
                     </thead>
                     <tbody style="display:block; width:1050px; height:250px; overflow-Y:scroll">';


        // Consulta para obtener los empleados asociados a un líder
        $vsql = "SELECT CONCAT(t.primernombre,' ',t.segundonombre,' ',t.primerapellido,' ',t.segundoapellido) AS nombre, 
                        c.nomconcepto AS concepto, p.fechanov AS fecha, p.dias, p.idnovedad, p.estatus 
                   FROM prenovedades p 
                        INNER JOIN conceptosnomina c ON (p.conceptoid = c.conceptoid) 
                        INNER JOIN terceros t ON (p.terid = t.terid) 
                        INNER JOIN seccionterceros s ON (t.terid = s.terid)	
                  WHERE p.pernominaid = ".$periodoid." ";

        if($nrosecciones==1)
            $vsql.=" AND s.seccionid = ".$seccionid." ";
        else
            $vsql.=" AND s.seccionid IN ($listaidsec) ";
            
        $vsql.=" ORDER BY p.idnovedad";

        $i = 0;
        $conex  = $clase->Conectar();
        $result = @mysql_query($vsql,$conex);
        while($row = mysql_fetch_array($result))
        {
            $i++;
            if($i%2 == 0)
                $cont.='<tr class="TablaDocsPar">';
            else
                $cont.='<tr class="TablaDocsImPar">';

            $dias = number_format($row['dias']);
            $fecha = substr($row['fecha'],8,2)."/".substr($row['fecha'],5,2)."/".substr($row['fecha'],0,4);
            $estatus = $row['estatus'];

            if($nofechalic != "CHECKED")
                $cont.=' <td width="30"> &nbsp; </td>
                         <td width="440" align="left"> '.$row['nombre'].' </td>
                         <td width="430" align="left"> '.$row['concepto'].' </td>
                         <td width="90" align="left"> '.$fecha.' </td>
                         <td width="35" align="right"> '.$dias.' </td>     
                         <td width="30" align="right"> &nbsp; </td>';
            else
                $cont.=' <td width="30"> &nbsp; </td>
                         <td width="440" align="left"> '.$row['nombre'].' </td>
                         <td width="520" align="left"> '.$row['concepto'].' </td>                         
                         <td width="35" align="right"> '.$dias.' </td>     
                         <td width="30" align="right"> &nbsp; </td>';

            if($estatus == "PENDIENTE")
                $cont.='  <td width="30" align="center"> 
                           <a href="?opcion=confirmacion&idnovedad='.$row['idnovedad'].'&idlider='.$idlider.'" rel="facebox">
                            <img src="images/basicas/iconoborrar.png" title="eliminar pre novedad" border="0">
                           </a> 
                          </td>
                         </tr>';
            else
                $cont.='  <td width="30" align="center"> 
                           <img src="images/basicas/bloqueado.png" title="pre novedad procesada" border="0"> 
                          </td>
                         </tr>';
        }

        $cont.=' </tbody>
                </table>';

        $cont.='<table width="100%">
                 <tr class="TituloTabla"> 
                  <td width="30"> &nbsp; </td>
                  <td width="441"> &nbsp; </td>
                  <td width="255" align="right"> &nbsp; </td>
                  <td width="255" align="right"> &nbsp; </td>
                  <td width="255" align="right"> &nbsp; </td>
                  <td width="402"> &nbsp; </td>
                 </tr>
                </table>';
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opciones: importarexcel
    // Creación: 24/02/2023		última modificación: 29/01/2024
    // Creador: Luis Flórez		modificado por: Luis Flórez
    // Descripción: Opción que pinta la ventana para captar la hoja de Excel donde se 
    //              cargaran las novedades
    // Última modificación: Inclusión del mensaje para la incapacidad superior a 180 días
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "importarexcel")
    {
        $idlider = $_GET['idlider'];

        $cont = '';
        $servidor = $_SERVER['SERVER_NAME'].":".$_SERVER['SERVER_PORT'];

        // Validación del servidor
        if(($servidor!="dromedicas.sytes.net:9996")&&($servidor!="192.168.14.248:9999"))
            $cont.='<table width="400">
                     <tr class="CabezoteTabla"> 
                      <td align="center"> <b> Servidor incorrecto </b> </td>
                     </tr> 
                     <tr class="CabezoteTabla"> 
                      <td align="center"> 
                       <font color=red> Este servidor est&aacute; inhabilitado para hacer este <br> 
                       proceso, por favor diríjase al servidor </font> <br> 
                       <font color=blue> 192.168.14.248:9999 </font> <br>
                       <font color=red>o al servidor </font> <br> 
                       <font color=blue> dromedicas.sytes.net:9996 </font> <br>
                       <font color=red> para poder importar estos datos </font> <br><br>
                      </td> 
                     </tr>
                     <tr class="TablaDocsPar">        
                      <td width="100%" align="center"> 
                       <form name="importa" method="post" action="prenovedades.php?opcion=ventanadatos&idlider='.$idlider.'" id="theform" enctype="multipart/form-data">
                        <input type="submit" name="enviar" id="enviarr"  value="aceptar" class="button blue" />                       
                       </form> 
                      </td>    
                     </tr>
                    </table>';
        else
        {
            // Nombre del periodo
            $vsql = "SELECT periodoid
                       FROM periodosnomina 
                      WHERE periodoid = (SELECT MIN(periodoid) FROM periodosnomina WHERE cerrado ='')";
            $periodoid = $clase->SeleccionarUno($vsql);

            $descripcion = $clase->BDLockup($periodoid,'periodosnomina','periodoid','descripcion');

            // valido la configuración de las fechas
            $variab = 'G_NOFECHALIC';
            $nofechalic = $clase->BDLockup($variab,'configuraciones','variab','contenido');

            if($nofechalic == "CHECKED")
                $formguardar = '<form name="importa" method="post" action="?opcion=importarexcel3" id="theform" enctype="multipart/form-data">';
            else
                $formguardar = '<form name="importa" method="post" action="?opcion=importarexcel2" id="theform" enctype="multipart/form-data">';

            // pinto la ventana
            $cont.='<script type="text/javascript" src="lib/jquery-2.1.3.min.js"></script>
                    <script>
                     $(function()
                      {
                       $("#enviarr").on("click",function()
                       {
                        $(this).val("Espere por favor ...")
                        .attr("disabled","disabled");
                        $("#theform").submit();
                       });
                      });
                    </script>
                    <table width="400">
                     <tr class="CabezoteTabla"> 
                      <td align="center"> <b>Importar novedades<br> <font color="blue">'.strtolower($descripcion).'</font></b><br><br></td> 
                     </tr> 
                    </table>
                    <table width="400">
                     <tr class="TablaDocsPar">        
                      <td width="100%" align="center"> 
                       '.$formguardar.'
                        <input type="hidden" name="periodoid" value="'.$periodoid.'">        
                        <input type="hidden" name="idlider" value="'.$idlider.'">
                        <input type="file" name="excel" /><br><br>                            
                        <input type="submit" name="enviar" id="enviarr"  value="Importar archivo" class="button blue" />
                        <input type="hidden" value="upload" name="action" />
                       </form> 
                      </td>    
                     </tr>
                    </table>';

            // valido la configuración de las fechas
            if($nofechalic == "CHECKED")
            {
                $cont.='<table width="400">
                         <tr class="TablaDocsPar"> <td align="left"> &nbsp; La hoja de Excel debe tener la siguiente estructura: </td> </tr>
                         <tr class="TablaDocsPar"> <td align="left"> &nbsp; Columna <b>A</b>: C&eacute;dula </td> </tr>
                         <tr class="TablaDocsPar"> <td align="left"> &nbsp; Columna <b>B</b>: D&iacute;as </b> </td> </tr>                 
                         <tr class="TablaDocsPar"> <td align="left"> &nbsp; Columna <b>C</b>: Tipo de licencia: </td> </tr>';

                $imagen = '<img src="images/iconos/ejemplolicencias22.png" width="300" height="300" border="0">';
            }
            else
            {
                $cont.='<table width="400">
                         <tr class="TablaDocsPar"> <td align="left"> &nbsp; La hoja de Excel debe tener la siguiente estructura: </td> </tr>
                         <tr class="TablaDocsPar"> <td align="left"> &nbsp; Columna <b>A</b>: C&eacute;dula </td> </tr>
                         <tr class="TablaDocsPar"> <td align="left"> &nbsp; Columna <b>B</b>: Fecha <b>(formato texto)</b> </td> </tr>                 
                         <tr class="TablaDocsPar"> <td align="left"> &nbsp; Columna <b>C</b>: D&iacute;as </td> </tr>
                         <tr class="TablaDocsPar"> <td align="left"> &nbsp; Columna <b>D</b>: Tipo de licencia: </td> </tr>';

                $imagen = '<img src="images/iconos/ejemplolicencias2.png" width="300" height="200" border="0">';
            }

            // Descripción de las licencias
            $cont.=' <tr class="TablaDocsPar"> 
                      <td align="left"> 
                       &nbsp; <font color="blue"><b>6</b></font> LICENCIA NO REMUNERADA <font color="blue"><b>9</b></font> SUSPENCION <font color="blue"><b>10</b></font> INCAPACIDAD
                      </td> 
                     </tr>
                     <tr class="TablaDocsPar"> 
                      <td align="left"> 
                       &nbsp; <font color="blue"><b>11</b></font> LICENCIA POR MATERNIDAD <font color="blue"><b>12</b></font> LICENCIA POR PATERNIDAD
                      </td>
                     </tr>
                     <tr class="TablaDocsPar"> 
                      <td align="left"> 
                       &nbsp; <font color="blue"><b>13</b></font> LICENCIA REMUNERADA <font color="blue"><b>23</b></font> LICENCIA POR CUMPLEAñOS 
                      </td> 
                     </tr>
                     <tr class="TablaDocsPar"> 
                      <td align="left"> 
                       &nbsp; <font color="blue"><b>31</b></font> MATRIMONIO <font color="blue"><b>40</b></font> INCAPACIDAD ARL 
                      </td> 
                     </tr>
                     <tr class="TablaDocsPar"> 
                      <td align="left"> 
                       &nbsp; <font color="blue"><b>43</b></font> INC SUPERIOR A 180 D&Iacute;AS 
                      </td> 
                     </tr>
                    </table>';

            // Imagen y botón de aceptar
            $cont.='<table width="400">
                     <tr class="TablaDocsPar"> 
                      <td align="center"> 
                       '.$imagen.'
                      </td> 
                     </tr>
                     <tr class="TablaDocsPar"> 
                      <td width="100%" align="center"> 
                       <font color="blue"> Importante: Se debe utilizar un archivo de Excel con extensión .xlsx </font>
                      </td> 
                     </tr>
                    </table>';
        }

        echo $cont;
        exit();
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opciones: importarexcel2
    // Creación: 24/02/2023		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que carga masivamente las novedades provenientes de una hoja 
    //              de Excel
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "importarexcel2")
    {
		set_time_limit(0);
		extract($_POST);
        $periodoid = $_POST["periodoid"];
        $idlider = $_POST["idlider"];
		$archivo = $_FILES['excel']['name'];
		$tipo = $_FILES['excel']['type'];
		$destino = "recursos/xls/bak_".$archivo;

        // Valido que la extensión del archivo sea xlsx
        $extension = pathinfo($destino, PATHINFO_EXTENSION);

        if($extension!="xlsx")
        {
            $clase->Aviso(3,"El archivo debe tener extensión .xlsx");
            header("Location: prenovedades.php?opcion=ventanadatos&idlider=$idlider");
        }
        else
        {
            /// Valido si se cargó el archivo o no
            if (!copy($_FILES['excel']['tmp_name'],$destino))
                echo "Error Al Cargar el Archivo";
        
            if (file_exists ("recursos/xls/bak_".$archivo))
            {
                require_once('lib/PHPExcel.php');
                require_once('lib/PHPExcel/Reader/Excel2007.php');
                
                $objReader = new PHPExcel_Reader_Excel2007();
                $objPHPExcel = $objReader->load("recursos/xls/bak_".$archivo);
                $objFecha = new PHPExcel_Shared_Date();
                $objPHPExcel->setActiveSheetIndex(0);
                $conex = $clase->Conectar();
                $recorrer = true;  $i = 1;
                while($recorrer)
                {
                    $_DATOS_EXCEL[$i]['dni'] = $objPHPExcel->getActiveSheet()->getCell('A'.$i)->getCalculatedValue();
                    $_DATOS_EXCEL[$i]['fecdesde'] = $objPHPExcel->getActiveSheet()->getCell('B'.$i);
                    $_DATOS_EXCEL[$i]['dias'] = $objPHPExcel->getActiveSheet()->getCell('C'.$i)->getCalculatedValue();
                    $_DATOS_EXCEL[$i]['conceptoid'] = $objPHPExcel->getActiveSheet()->getCell('D'.$i)->getCalculatedValue();
                
                    if((strlen($_DATOS_EXCEL[$i]['dni']) == 0)||(strlen($_DATOS_EXCEL[$i]['fecdesde']) == 0)||(strlen($_DATOS_EXCEL[$i]['dias']) == 0)||(strlen($_DATOS_EXCEL[$i]['conceptoid']) == 0)) 
                        $recorrer = false;
                    
                    $i++;
                } /// Fin del While
            }
            else
            { echo "Necesitas primero importar el archivo";  }  /// Si NO Cargó el archivo
            
            $errores = 0;
            $grabados = 0;

            $calculado = $clase->BDLockup($periodoid,'periodosnomina','periodoid','calculado');

            if($calculado=="CHECKED")
                $tabla = "tercerosactual";
            else
                $tabla = "terceros";            
            
            for($j=1; $j < $i; $j++)
            {
                // Validación de la existencia del empleado
                $dni = $_DATOS_EXCEL[$j]['dni'];
                $terid = $clase->BDLockup($dni,$tabla,"dni","terid");

                if($terid != "")
                {                    
                    // valido que el empleado pertenezca a la sección
                    $seccionid = $clase->BDLockup($terid,'terceros','terid','seccionid');

                    $vsql = "SELECT COUNT(*) numseccion FROM seccion WHERE idlider = ".$idlider." AND seccionid = ".$seccionid;
                    $numseccion = $clase->SeleccionarUno($vsql);

                    if($numseccion > 0)
                    {                        
                        $lb_valido = false;
                        $lb_valido2 = false;
                        $lb_valida3 = false;

                        $fecdesde = $_DATOS_EXCEL[$j]['fecdesde'];
                        $dias = $_DATOS_EXCEL[$j]['dias'];
                        $conceptoid = $_DATOS_EXCEL[$j]['conceptoid'];
                        
                        // Valido la entrada de los datos de la hoja de Excel
                        $lb_valido = $io_fecha->uf_solo_numeros($dias);         // Valido la columna de los días
                        $lb_valido2 = validar_fecha_espanol($fecdesde);         // Valido la columna de la fecha

                        // Valido que el concepto sea una licencia
                        $vsql = "SELECT eslicencia
                                   FROM conceptosnomina 
                                  WHERE conceptoid = ".$conceptoid;
                        $eslicencia = $clase->SeleccionarUno($vsql);

                        // validación de los días, formato de fecha y licencia
                        if(($lb_valido)&&($lb_valido2)&&($eslicencia == "CHECKED"))
                        {                            
                            // Valido que la fecha esté dentro del periodo
                            $fechasta = $clase->BDLockup($periodoid,'periodosnomina','periodoid','fechasta');
                            $fecdesde2 = $clase->BDLockup($periodoid,'periodosnomina','periodoid','fecdesde');
                            $fecdesde3 = substr($fecdesde,6,4)."-".substr($fecdesde,3,2)."-".substr($fecdesde,0,2);
    
                            $lb_valida3 = verifica_rango($fecdesde2,$fechasta,$fecdesde3);
    
                            if($lb_valida3)
                            {
                                // Obtengo el nuevo id de la pre novedad
                                $vsql = "SELECT MAX(idnovedad) FROM prenovedades";
                                $numreg = $clase->SeleccionarUno($vsql);
                                $numreg++;

                                $estatus = "PENDIENTE";

                                // almaceno la información
                                $vsql = "INSERT INTO prenovedades (terid, conceptoid, pernominaid, fechanov, dias, estatus) 
                                              VALUE (".$terid.",".$conceptoid.",".$periodoid.",'".$fecdesde3."',".$dias.",'".$estatus."')";
                                $clase->EjecutarSQL($vsql);

                                if(mysql_affected_rows() > 0)
                                    $grabados++;
                            }                            
                        }
                    }
                }
            }

            // Elimino el Archivo
            unlink($destino);

            $descripcion = $clase->BDLockup($periodoid,'periodosnomina','periodoid','descripcion');
    
            // Emito el mensaje correspondiente
            if($grabados == 0)
                $clase->Aviso(3,"No se cargaron las licencias para el periodo $descripcion");
            else
                $clase->Aviso(1,"Se cargaron $grabados licencias para el periodo $descripcion");
    
            // Redirecciona el formulario
            header("Location: prenovedades.php?opcion=ventanadatos&idlider=$idlider");
        }
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opciones: importarexcel3
    // Creación: 29/01/2024		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que carga masivamente las novedades provenientes de una hoja 
    //              de Excel sin tomar en cuenta la fecha
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////    
    if($opcion == "importarexcel3")
    {
		set_time_limit(0);
		extract($_POST);
        $periodoid = $_POST["periodoid"];
        $idlider = $_POST["idlider"];
		$archivo = $_FILES['excel']['name'];
		$tipo = $_FILES['excel']['type'];
		$destino = "recursos/xls/bak_".$archivo;

        // Valido que la extensión del archivo sea xlsx
        $extension = pathinfo($destino, PATHINFO_EXTENSION);

        if($extension!="xlsx")
        {
            $clase->Aviso(3,"El archivo debe tener extensión .xlsx");
            header("Location: prenovedades.php?opcion=ventanadatos&idlider=$idlider");
        }
        else
        {
            /// Valido si se cargó el archivo o no
            if (!copy($_FILES['excel']['tmp_name'],$destino))
                echo "Error Al Cargar el Archivo";
        
            if (file_exists ("recursos/xls/bak_".$archivo))
            {
                require_once('lib/PHPExcel.php');
                require_once('lib/PHPExcel/Reader/Excel2007.php');
                
                $objReader = new PHPExcel_Reader_Excel2007();
                $objPHPExcel = $objReader->load("recursos/xls/bak_".$archivo);
                $objFecha = new PHPExcel_Shared_Date();
                $objPHPExcel->setActiveSheetIndex(0);
                $conex = $clase->Conectar();
                $recorrer = true;  $i = 1;
                while($recorrer)
                {
                    $_DATOS_EXCEL[$i]['dni'] = $objPHPExcel->getActiveSheet()->getCell('A'.$i)->getCalculatedValue();                    
                    $_DATOS_EXCEL[$i]['dias'] = $objPHPExcel->getActiveSheet()->getCell('B'.$i)->getCalculatedValue();
                    $_DATOS_EXCEL[$i]['conceptoid'] = $objPHPExcel->getActiveSheet()->getCell('C'.$i)->getCalculatedValue();
                
                    if((strlen($_DATOS_EXCEL[$i]['dni']) == 0)||(strlen($_DATOS_EXCEL[$i]['dias']) == 0)||(strlen($_DATOS_EXCEL[$i]['conceptoid']) == 0)) 
                        $recorrer = false;
                    
                    $i++;
                } /// Fin del While
            }
            else
            { echo "Necesitas primero importar el archivo";  }  /// Si NO Cargó el archivo
            
            $errores = 0;
            $grabados = 0;

            // determino si el periodo está calculado
            $calculado = $clase->BDLockup($periodoid,'periodosnomina','periodoid','calculado');

            if($calculado=="CHECKED")
                $tabla = "tercerosactual";
            else
                $tabla = "terceros"; 
            
            // inicializo las variables
            $fechanov = $clase->BDLockup($periodoid,'periodosnomina','periodoid','fecdesde');
            $esempleadoactivo = "";
            
            for($j=1; $j < $i; $j++)
            {
                // Validación de la existencia del empleado
                $dni = $_DATOS_EXCEL[$j]['dni'];
                $terid = $clase->BDLockup($dni,$tabla,"dni","terid");

                if($terid != "")
                {                    
                    // valido que el empleado pertenezca a la sección
                    $seccionid = $clase->BDLockup($terid,'terceros','terid','seccionid');

                    $vsql = "SELECT COUNT(*) numseccion FROM seccion WHERE idlider = ".$idlider." AND seccionid = ".$seccionid;
                    $numseccion = $clase->SeleccionarUno($vsql);

                    if($calculado == "CHECKED")
                        $vsql32 = "SELECT esempleadoactivo FROM tercerosactual WHERE terid = ".$terid." AND pernominaid = ".$periodoid;
                    else
                        $vsql32 = "SELECT esempleadoactivo FROM terceros WHERE terid = ".$terid;
                    
                    $esempleadoactivo = $clase->SeleccionarUno($vsql32);

                    if(($numseccion > 0) && ($esempleadoactivo =="CHECKED"))
                    {
                        $lb_valido = false;
                        $dias = $_DATOS_EXCEL[$j]['dias'];
                        $conceptoid = $_DATOS_EXCEL[$j]['conceptoid'];
                        
                        // Valido la entrada de los datos de la hoja de Excel
                        $lb_valido = $io_fecha->uf_solo_numeros($dias);         // Valido la columna de los días

                        // Valido que el concepto sea una licencia
                        $vsql = "SELECT eslicencia 
                                   FROM conceptosnomina 
                                  WHERE conceptoid = ".$conceptoid;
                        $eslicencia = $clase->SeleccionarUno($vsql);

                        // validación de los días y licencia
                        if(($lb_valido) && ($eslicencia == "CHECKED"))
                        {
                            $estatus = "PENDIENTE";

                            // almaceno la información
                            $vsql = "INSERT INTO prenovedades (terid, conceptoid, pernominaid, fechanov, dias, estatus) VALUE (".$terid.",".$conceptoid.",".$periodoid.",'".$fechanov."',".$dias.",'".$estatus."')";
                            $clase->EjecutarSQL($vsql);

                            if(mysql_affected_rows() > 0)
                                $grabados++;
                        }
                    }
                }
            }

            // Elimino el Archivo
            unlink($destino);

            $descripcion = $clase->BDLockup($periodoid,'periodosnomina','periodoid','descripcion');
    
            // Emito el mensaje correspondiente
            if($grabados == 0)
                $clase->Aviso(3,"No se cargaron las licencias para el periodo $descripcion");
            else
                $clase->Aviso(1,"Se cargaron $grabados licencias para el periodo $descripcion");
    
            // Redirecciona el formulario
            header("Location: prenovedades.php?opcion=ventanadatos&idlider=$idlider");
        }
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Función validar_fecha_espanol
    // Parámetro de entrada:    $fecha --> Fecha que se va a evaluar
    // Valor de retorno:        true o false
    // Descripción: Función que valida el formato de fecha dd/mm/aaaa
    ////////////////////////////////////////////////////////////////////////////////////////
    function validar_fecha_espanol($fecha)
    {
        $valores = explode('/', $fecha);
        if(count($valores) == 3 && checkdate($valores[1], $valores[0], $valores[2]))
        {
            return true;
        }
        return false;
    }    

    ////////////////////////////////////////////////////////////////////////////////////////
    // Función verifica_rango
    // Parámetro de entrada:    $date_inicio --> Fecha de inicio del periodo
    //                          $date_fin    --> Fecha fin del periodo
    //                          $date_nueva  --> Fecha que se va a evaluar
    // Valor de retorno:        true o false
    // Descripción: Función que valida si una fecha está en un rango especifico
    ////////////////////////////////////////////////////////////////////////////////////////    
    function verifica_rango($date_inicio, $date_fin, $date_nueva) 
    {
        $date_inicio = strtotime($date_inicio);
        $date_fin = strtotime($date_fin);
        $date_nueva = strtotime($date_nueva);

        if (($date_nueva >= $date_inicio) && ($date_nueva <= $date_fin))
            return true;
        else
            return false;
    }    

    ////////////////////////////////
    echo $cont.$clase->PiePagina();    
?>