<?PHP
    @session_start(); 
    include("lib/Sistema.php");  
  
    $clase = new Sistema();
    $clase->Nombredb = $_SESSION['DBNOMBRE'];  
    $avisos = ""; 
    $opcion = "";
    $opcion = $_GET["opcion"];

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: ""
    // Creación: 27/08/2024		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que pinta la ventana para captar el nuevo movimiento de una 
    //              sucursal
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "")
    {
        // Configuración de combos
        $params = ' class="Texto11" ';		
        $vsqlcombosucursal = "SELECT sucursalid , descripcion FROM sucursales WHERE descripcion NOT LIKE '%DEPOSITO%'";
        $combosucursal = $clase->CrearComboBuscar("sucursalid",$vsqlcombosucursal,"descripcion","sucursalid","","N",$params,250);

        // inicializo variables
        $filtros = "";
        $cwhere = "";

        // pinto la ventana
        $cont = $clase->Header("S","W");

        // encabezado
        $cont.='<table width="100%">
                 <tr class="CabezoteTabla"> 
                  <td width="10"> &nbsp; </td>
                  <td width="37"> <img src="images/iconos/sucursales.png" width="32" height="32" border="0"> </td>
                  <td width="810"> <b> Movimiento de sucursales </b> </td>
                  <td width="20">
                   <a href="?opcion=informemovsuc&filtros='.$filtros.'&cwhere='.$cwhere.'" target="_blank"> 
                    <img src="images/iconos/informe2.png" border="0" width="32" height="32" title="informe de movimientos de sucursales"> 
                   </a>                   
                  </td>
                  <td width="10"> &nbsp; </td>
                  <td width="50" align="center"> <input type="button" class="button blue" value="<<" OnClick="document.location=\'principal.php\'"> </td>
                  <td width="8"> &nbsp; </td>
                 </tr>
                </table>';

        // títulos
        $cont.='<form action="?opcion=actualizarsucursal" method="POST" name="x">
                <center>
                <table width="100%">
                 <tr class="BarraDocumentos" style="height:50px;Important!">  
                  <td width="220"> &nbsp; </td>
                  <td width="20"> <label class="Texto12"> Sucursal: </label> </td>
                  <td width="120"> '.$combosucursal.' </td> 
                  <td width="220"> &nbsp; </td>
                 </tr>
                 <tr class="BarraDocumentos" style="height:50px;Important!">  
                  <td width="220"> &nbsp; </td>
                  <td width="20"> <label class="Texto12"> Tipo: </label> </td>
                  <td width="120"> 
                   <select name="tipo" style="width:120px;height:25px">  
                    <option value="apertura"> apertura </option>
                    <option value="reapertura"> reapertura </option>
                    <option value="cierre"> cierre </option>
                   </select>
                  </td> 
                  <td width="220"> &nbsp; </td>
                 </tr>
                </table>';

        // bóton de aceptar
        $cont.='<table width="100%">
                 <tr class="BarraDocumentos" style="height:50px;Important!"> 
                  <td align="center">
                   <input type="submit" value="aceptar" class="button blue">
                   </form>
                  </td>
                 </tr>
                </table>';

        // Pie de página
        $cont.='<table width="100%"> 
                 <tr class="BarraDocumentos" style="height:50px;Important!"> <td align="center"> &nbsp; </td> </tr>
                 <tr class="BarraDocumentos" style="height:50px;Important!"> <td align="center"> &nbsp; </td> </tr>
                 <tr class="BarraDocumentos" style="height:50px;Important!"> <td align="center"> &nbsp; </td> </tr>
                 <tr class="BarraDocumentos" style="height:50px;Important!"> <td align="center"> &nbsp; </td> </tr>
                 <tr class="BarraDocumentos" style="height:50px;Important!"> <td align="center"> &nbsp; </td> </tr>
                 <tr class="BarraDocumentos" style="height:50px;Important!"> <td align="center"> &nbsp; </td> </tr>
                 <tr class="BarraDocumentos" style="height:50px;Important!"> <td align="center"> &nbsp; </td> </tr>
                </table>';

        echo $cont.$clase->PiePagina();
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: actualizarsucursal
    // Creación: 27/08/2024		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción para incluir el movimiento de la sucursal y actualizar su estado
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "actualizarsucursal")
    {
        $sucursalid = $_POST['sucursalid'];
        $tipo = $_POST['tipo'];

        // actualizar el movimiento
        $vsql = "INSERT INTO movimientosucursal (sucursalid,tipo,usuario,momento) VALUE (".$sucursalid.",'".$tipo."','".$_SESSION['USERNAME']."',CURRENT_TIMESTAMP)";
        $clase->EjecutarSQL($vsql);

        // actualizo el estado
        if(($tipo == "apertura") || ($tipo == "reapertura"))
            $vsql = "UPDATE sucursales SET 
                            activa = 'CHECKED' 
                      WHERE sucursalid = ".$sucursalid;

        if($tipo == "cierre")
            $vsql = "UPDATE sucursales SET
                            activa = Null 
                      WHERE sucursalid = ".$sucursalid;

        // actualizo el registro
        $clase->EjecutarSQL($vsql);

        // Emito el mensaje correspondiente
        $clase->Aviso(1,"Datos almacenados satisfactoriamente");

        // Redirecciono el formulario
        header("Location: movimientosucursal.php");
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: informemovsuc
    // Creación: 27/08/2024		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que emite el informe de movimientos de sucursales en salida html
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "informemovsuc")
    {
        $filtros = $_GET['filtros'];
        $cwhere = $_GET['cwhere'];

        // botón para reversar la última búsqueda
        if($filtros == "")
            $botonreversar = '&nbsp;';
        else
            $botonreversar = '<a href="?opcion=nofiltro"> <img src="images/iconos/devoluciones.png" width="32" height="32" border="0" title="anular &uacute;ltima b&uacute;squeda"> </a>';

        // consulta del informe
        $vsql = "  SELECT s.descripcion, ms.tipo, ms.usuario, ms.momento
                     FROM movimientosucursal ms
                          INNER JOIN sucursales s ON (ms.sucursalid = s.sucursalid)
                    ".$cwhere." 
                 ORDER BY 1";

        // variable de sesión para la salida a Excel
        $_SESSION['SQL_MOVSUCXLS'] = $vsql;

        // construyo el detalle
        $i = 0;         $det = '';
        $conex  = $clase->Conectar();
        $result = mysql_query($vsql,$conex);
        while($row = mysql_fetch_array($result))
        {
            $i++;
            if($i%2 == 0)
                $det.='<tr class="TablaDocsPar">';
            else
                $det.='<tr class="TablaDocsImPar">';

            $fecmomento = substr($row['momento'],8,2)."/".substr($row['momento'],5,2)."/".substr($row['momento'],0,4);
            $horamomento = substr($row['momento'],11,strlen($row['momento']));
            
            // imprimo el detalle
            $det.=' <td width="20"> &nbsp; </td>
                    <td width="320" align="left"> '.$row['descripcion'].' </td>
                    <td width="270" align="left"> '.$row['tipo'].' </td>                        
                    <td width="200" align="left"> '.$row['usuario'].' </td>
                    <td width="190" align="right"> '.$fecmomento.' <br> '.$horamomento.' </td>
                    <td width="260" align="left"> &nbsp; </td>                        
                    <td width="50" align="center"> &nbsp; </td> 
                   </tr>';
        }

        $det.=' </tbody>
               </table>';

        // pie de página
        $pie = '<table width="100%"> <tr class="TituloTabla"> <td width="1608"> &nbsp; </td> </tr> </table>';

        // validación del botón para la salida a Excel
        if($i > 0)
            $htmlsalidaxls = '<a href="?opcion=movimientosucxls&filtros='.$filtros.'" target="_blank"> 
                               <img src="images/iconos/exportarexcel2.png" border="0" width="32" height="32" title="exportar a una hoja de Excel"> 
                              </a>';        
        else
            $htmlsalidaxls = '&nbsp;';        

        // pinto la ventana
        $enc = $clase->Header("S","W");

        // encabezado
        $enc.= '<table width="100%">
                 <tr class="CabezoteTabla"> 
                  <td width="10"> &nbsp; </td>
                  <td width="37"> <img src="images/iconos/sucursales.png" width="32" height="32" border="0"> </td>
                  <td width="750"> <b> Informe movimiento de sucursales </b> <br> '.$filtros.' </td>
                  <td width="20"> '.$botonreversar.' </td>
                  <td width="10"> &nbsp; </td>
                  <td width="20"> '.$htmlsalidaxls.' </td>
                  <td width="10"> &nbsp; </td>
                  <td width="20">
                   <a href="?opcion=filtromov" rel="facebox"> 
                    <img src="images/iconos/vistaprevia.png" border="0" width="32" height="32" title="informe de movimientos de sucursales"> 
                   </a>                   
                  </td>
                  <td width="10"> &nbsp; </td>
                  <td width="50" align="center"> <input type="button" class="button blue" value="<<" OnClick="document.location=\'movimientosucursal.php\'"> </td>
                  <td width="8"> &nbsp; </td>
                 </tr>
                </table>';
                
        // títulos
        $enc.= '<script type="text/javascript" src="lib/sorttable.js"></script>
                <table width="100%" class="sortable">
                 <thead> 
                  <tr class="TituloTabla" style="display:block;padding-top:5px;height:23px;">
                   <th width="20"> &nbsp; </th>
                   <th width="340" align="left"> Sucursal </th>
                   <th width="290" align="left"> Tipo </th>                        
                   <th width="290" align="left"> Usuario </th>
                   <th width="140" align="right"> Fecha </th>
                   <th width="350" align="left"> &nbsp; </th>                   
                  </tr>
                 </thead>
                 <tbody style="display:block; width:1050px; height:550px; overflow-Y:scroll">';

        // Construyo el contenido del formulario
        $cont = $enc.$det.$pie;

        echo $cont.$clase->PiePagina();  
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: filtromov
    // Creación: 27/08/2024		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que pinta la venta para captar los filtros del informe de 
    //              movimiento de sucursales
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "filtromov")
    {
        // Configuración de combos
        $params = ' class="Texto11" ';		
        $vsqlcombosucursal = "SELECT sucursalid , descripcion FROM sucursales WHERE descripcion NOT LIKE '%DEPOSITO%'";
        $combosucursal = $clase->CrearComboBuscar("sucursalid",$vsqlcombosucursal,"descripcion","sucursalid","","S",$params,250);

        // inicilaización de variuables
        $fecha  = date("Y-m-");
        $fecha2 = date("Y-m-");
        
        $filtros = "";
        $cwhere2 = "";
        
        // pinto la ventana
        $cont= '<form action="?opcion=filtrar" method="POST" name="x">
                <table width="400">
                 <tr class="CabezoteTabla"> 
                  <td width="50" align="center"> <img src="images/iconos/vistaprevia.png" width="32" height="32" border="0"> </b> <td> 
                  <td width="350" align="center"> <b> B&uacute;squeda de movimientos </b> <td> 
                 </tr> 
                </table>';

        // filtros
        $cont.='<table width="400">
                 <tr class="TablaDocsImPar">				
                  <td width="100" align="right"> Sucursal: &nbsp; </td> 			  
                  <td width="300"> '.$combosucursal.' </td>
                 </tr>
                 <tr class="TablaDocsImPar">				
                  <td width="100" align="right"> Tipo: &nbsp; </td> 			  
                  <td width="300"> 
                   <select name="tipo" style="width:120px;height:25px">  
                    <option value="todos"> todos </option>
                    <option value="apertura"> apertura </option>
                    <option value="reapertura"> reapertura </option>
                    <option value="cierre"> cierre </option>
                   </select>
                  </td>
                 </tr>
                 <tr class="TablaDocsImPar">				
                  <td width="100" align="right"> Usuario: &nbsp; </td> 			  
                  <td width="300"> <input type="text" class="Texto11" name="usuario" style="width:170px;height:25px;" size="20" maxlenght="20" value="" style="text-transform:uppercase!Important;" autocomplete="off"> </td>
                 </tr>
                 <tr class="TablaDocsImPar">				
                  <td width="100" align="right"> Desde: &nbsp; </td> 			  
                  <td width="300"> <input type="date" class="Texto11" name="fechadesde" style="width:120px;height:25px;" size="12" maxlenght="10" value="'.$fecha.'01"> </td>
                 </tr>
                 <tr class="TablaDocsImPar">				
                  <td width="100" align="right"> Hasta: &nbsp; </td>';

        // Determino el último día del mes de acuerdo al número de días que este tiene
        if(date("t") == 28)
            $cont.='<td width="300"> <input type="date" class="Texto11" style="width:120px;height:25px;" name="fechahasta" size="12" maxlenght="10" value="'.$fecha2.'28"> </td>';

        if(date("t") == 29)
            $cont.='<td width="300"> <input type="date" class="Texto11" style="width:120px;height:25px;" name="fechahasta" size="12" maxlenght="10" value="'.$fecha2.'29"> </td>';

        if(date("t") == 30)
            $cont.='<td width="300"> <input type="date" class="Texto11" style="width:120px;height:25px;" name="fechahasta" size="12" maxlenght="10" value="'.$fecha2.'30"> </td>';

        if(date("t") == 31)
            $cont.='<td width="300"> <input type="date" class="Texto11" style="width:120px;height:25px;" name="fechahasta" size="12" maxlenght="10" value="'.$fecha2.'31"> </td> ';

        $cont.=' </tr>
                </table>
                <center>
                <br> 
                <input type="submit" value="aceptar" class="button blue">
                <a href="movimientosucursal.php?opcion=informemovsuc&filtros='.$filtros.'&cwhere='.$cwhere2.'" > <input type="button" value="CANCELAR" class="button red"> </a>
                </form> <br>';

        echo $cont;
        exit();
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: filtrar
    // Creación: 27/08/2024		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que aplica el filtro previamente seleccionado
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "filtrar")
    {
        $sucursalid = $_POST['sucursalid'];
        $tipo = $_POST['tipo'];
        $usuario = strtoupper($_POST['usuario']);
        $fechadesde = $_POST['fechadesde'];
        $fechahasta = $_POST['fechahasta'];

        // inicializo las variables
        $cwhere = " WHERE ms.movimientoid > 0";
        $filtros = "";

        // filtro de sucursal
        if(strlen($sucursalid)>0)
        {
            $cwhere.= " AND s.sucursalid = ".$sucursalid." ";
            $descripcionsuc = $clase->BDLockup($sucursalid,'sucursales','sucursalid','descripcion');
            $filtros.= "SUCURSAL: ".$descripcionsuc." ";
        }

        // filtro de tipo
        if((strlen($tipo)>0) && ($tipo != "todos"))
        {
            $cwhere.= " AND ms.tipo = '".$tipo."' ";
            $filtros.= "TIPO: ".strtoupper($tipo)." ";
        }

        // filtro del usuario
        if(strlen($usuario)>0)
        {
            $cwhere.= " AND ms.usuario = '".$usuario."' ";
            $filtros.= "USUARIO: ".$usuario." ";
        }

        // filtro de la fecha desde
        if(strlen($fechadesde)>0)
        {
            $cwhere.= " AND ms.momento >= '".$fechadesde." 00:00:00' ";
            $fecdesde  = substr($fechadesde,8,2)."/".substr($fechadesde,5,2)."/".substr($fechadesde,0,4);
            $filtros.= "DESDE: ".$fecdesde." ";
        }

        // filtro de la fechas hasta
        if(strlen($fechahasta)>0)
        {
            $cwhere.= " AND ms.momento <= '".$fechahasta." 23:59:59' ";
            $fechasta  = substr($fechahasta,8,2)."/".substr($fechahasta,5,2)."/".substr($fechahasta,0,4);
            $filtros.= "HASTA: ".$fechasta." ";
        }

        // redirecciono el formulario
        header("Location: movimientosucursal.php?opcion=informemovsuc&filtros=$filtros&cwhere=$cwhere");
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: nofiltro
    // Creación: 27/08/2024		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que reversa el filtro previamente seleccionado
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "nofiltro")
    {
        $filtros = "";
        $cwhere = "";

        header("Location: movimientosucursal.php?opcion=informemovsuc&filtros=$filtros&cwhere=$cwhere");
    }    

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: movimientosucxls
    // Creación: 27/08/2024		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que emite el informe de movimientos de sucursales en una hoja de 
    //              Excel
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "movimientosucxls")
    {
        $filtros = $_GET['filtros'];

        $vsql = $_SESSION['SQL_MOVSUCXLS'];

        // preparo el entorno
        require_once 'lib/PHPExcel.php';
        $clase = new Sistema();
        $clase->Conectar();
        ini_set("memory_limit","100M");

        // Preparación del entorno para la salida a Excel
        $clase = new Sistema();
        $clase->Nombredb = $_SESSION['DBNOMBRE'];
        error_reporting(E_ALL);
        ini_set('display_errors', TRUE);
        ini_set('display_startup_errors', TRUE);
        date_default_timezone_set('Europe/London');

        if (PHP_SAPI == 'cli')
            die('This example should only be run from a Web Browser');

        // Create new PHPExcel object
        $objPHPExcel = new PHPExcel();

        // Set document properties
        $objPHPExcel->getProperties()->setCreator("Sistemas y Soluciones Web de Colombia")
                                     ->setLastModifiedBy("Sistemas y Soluciones Web de Colombia")
                                     ->setTitle("movimiento de sucursales - DROPOS")
                                     ->setSubject("movimiento de sucursales - DROPOS")
                                     ->setDescription("movimiento de sucursales - DROPOS")
                                     ->setKeywords("movimiento de sucursales - DROPOS")
                                     ->setCategory("movimiento de sucursales");        

        $objPHPExcel->setActiveSheetIndex(0)
                    ->setCellValue('A1', 'INFORME MOVIMIENTO DE SUCURSALES')
                    ->setCellValue('A2', $filtros)
                    ->setCellValue('A3', 'SUCURSAL')
                    ->setCellValue('B3', 'TIPO')
                    ->setCellValue('C3', 'USUARIO')
                    ->setCellValue('D3', 'FECHA');

        $objPHPExcel->getActiveSheet()->getColumnDimension('A')->setAutoSize(true);                 $objPHPExcel->getActiveSheet()->getColumnDimension('B')->setAutoSize(true);
        $objPHPExcel->getActiveSheet()->getColumnDimension('C')->setAutoSize(true);                 $objPHPExcel->getActiveSheet()->getColumnDimension('D')->setAutoSize(true);

        // Inmovilizar paneles
        $objPHPExcel->getActiveSheet(0)->freezePaneByColumnAndRow(0,4);

        // Detalle del informe
        $i = 4;
        $conex  = $clase->Conectar();
        $result = mysql_query($vsql,$conex);
        while($row = mysql_fetch_array($result))
        {
            $fecmomento = substr($row['momento'],8,2)."/".substr($row['momento'],5,2)."/".substr($row['momento'],0,4);
            $horamomento = substr($row['momento'],11,strlen($row['momento']));

            $objPHPExcel->setActiveSheetIndex(0)
                        ->setCellValue('A'.$i, $row['descripcion'])
                        ->setCellValue('B'.$i, $row['tipo'])
                        ->setCellValue('C'.$i, $row['usuario'])
                        ->setCellValue('D'.$i, $fecmomento." ". $horamomento);
            $i++;
        }

        $rangoEncabezado = 'A3:D3';
        $rangoCeldas     = 'A3:D'.($i-1);
                                     
        // ----------------------------------------------------------------------------------------------------------------------------------------------------------- //
        // Formato de Encabezado y Celdas
        $objPHPExcel->getActiveSheet()->getRowDimension('1')->setRowHeight(15);
        
        $EstiloCeldas = array(
        'borders' => array(
            'allborders' => array(
                'style' => PHPExcel_Style_Border::BORDER_THIN,
                'color' => array('argb' => '00000000'),
            ),
            ),
        );
        $objPHPExcel->getActiveSheet()->getStyle($rangoCeldas)->applyFromArray($EstiloCeldas);
        /// Formato de Encabezados 
        $EstiloEncabezado = array(
        'font' => array(
            'bold' => true,
        ),
        'alignment' => array(
            'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,
            'vertical' => PHPExcel_Style_Alignment::VERTICAL_CENTER,		
        ),
        'borders' => array(
            'allborders' => array(
                'style' => PHPExcel_Style_Border::BORDER_THIN,
                'color' => array('argb' => '00000000'),
            ),
        ),
        'fill' => array(
            'type' => PHPExcel_Style_Fill::FILL_SOLID,
            'rotation' => 90,
            'startcolor' => array(
                'argb' => '00FFFFCC',
            ),
            'endcolor' => array(
                'argb' => 'FFFFFF',
            ),
            ),
        );
        $objPHPExcel->getActiveSheet()->getStyle($rangoEncabezado)->applyFromArray($EstiloEncabezado);
        // Rename worksheet
        $objPHPExcel->getActiveSheet()->setTitle('movimiento de sucursales');
        // Set active sheet index to the first sheet, so Excel opens this as the first sheet
        $objPHPExcel->setActiveSheetIndex(0);
        // Redirect output to a client’s web browser (Excel5)
        header('Content-Type: application/vnd.ms-excel');
        // -------------------------------------------------------------------------------------------- //
        $nombrearcexcel = "movimiento de sucursales.xls";
        header('Content-Disposition: attachment;filename='.$nombrearcexcel.'');
        // -------------------------------------------------------------------------------------------- //
        header('Cache-Control: max-age=0');
        /// Genero la Salida
        $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');
        $objWriter->save('php://output');
        exit;
    }
?>