<?PHP
    @session_start(); 
    include("lib/Sistema.php");
    
    $clase = new Sistema();
    $clase->Nombredb = $_SESSION['DBNOMBRE'];
    $avisos = "";
    $opcion = "";
    $opcion = $_GET["opcion"];

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: ventanadatos
    // Creación: 13/12/2021		última modificación: 04/09/2024
    // Creador: Luis Flórez		modificado por: Luis Flórez
    // Descripción: Opción que pinta la ventana principal del informe
    // Última modificación: Vistas tipo html y pdf (16/12/2021)
    //                      Cambio del formato de las filas y botón de atrás
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "ventanadatos")
    {
        // combo de periodos
        $params = ' class="Texto11" ';
        $vsqlcomboperiodo  = "SELECT codperiodo, desperiodo FROM periodos WHERE anoperiodo >= 2021 AND orden >= 94 ORDER BY orden";
    
        // pínto la ventana
        $cont = $clase->Header("S","W");
        $cont.='<table width="100%">
                 <tr class="CabezoteTabla"> 
                  <td width="10"> &nbsp; </td>
                  <td width="37"> <img src="images/iconos/docxpagar.png" width="32" height="32" border="0"> </td>
                  <td width="840"> <b> Liquidados por periodo </b> </td>
                  <td> &nbsp; </td>
                  <td width="30" align="center"> <input type="button" class="button blue" value="<<" OnClick="document.location=\'principal.php\'"> </td>
                  <td width="10"> &nbsp; </td>
                 </tr>           
                </table>';
        
        // títulos y botones para el tipo de informe
        $cont.='<form action="liquidadosxperiodo.php?opcion=infliqxper" method="POST" name="x" target="_blank">                
                <center>
                <table width="100%">
                 <tr class="BarraDocumentos" style="height:50px;Important!">
                  <td align="center"> <br><br> <b> Datos del informe </b> <br><br> </td>
                 </tr>
                </table>  
                <table width="100%">
                 <tr class="BarraDocumentos" style="height:50px;Important!"> 
                  <td width="220"> &nbsp; </td>
                  <td width="20"> Periodo: </td>
                  <td width="120"> '.$clase->CrearComboBuscar("codperiodo",$vsqlcomboperiodo,"desperiodo","codperiodo","","N",$params,400).' </td> 
                  <td width="220"> &nbsp; </td>
                 </tr>
                </table>                   
                <table width="100%">                     
                 <tr class="BarraDocumentos" style="height:50px;Important!"> 
                  <td width="371" height="50" align="center"> &nbsp; </td>      
                  <td width="164" height="50" align="center"> <input type="submit" value="vista" class="button blue" name="tiposalida"> </td>
                  <td width="131" height="50" align="center"> <input type="submit" value="pdf" class="button red" name="tiposalida"> </td>
                  <td width="185" height="50" align="center"> <input type="submit" value="excel" class="button blue" name="tiposalida"> </td> 
                  <td width="380" height="50" align="center"> &nbsp; </td>
                 </tr>
                </table> 
                </form>';

        // pie de página
        $cont.='<table width="100%"> 
                 <tr class="BarraDocumentos" style="height:50px;Important!"> <td align="center"> &nbsp; </td> </tr>
                 <tr class="BarraDocumentos" style="height:50px;Important!"> <td align="center"> &nbsp; </td> </tr>
                 <tr class="BarraDocumentos" style="height:50px;Important!"> <td align="center"> &nbsp; </td> </tr>
                 <tr class="BarraDocumentos" style="height:50px;Important!"> <td align="center"> &nbsp; </td> </tr>
                 <tr class="BarraDocumentos" style="height:50px;Important!"> <td align="center"> &nbsp; </td> </tr>
                 <tr class="BarraDocumentos" style="height:50px;Important!"> <td align="center"> &nbsp; </td> </tr>
                 <tr class="BarraDocumentos" style="height:50px;Important!"> <td align="center"> &nbsp; </td> </tr>
                </table>';

        echo $cont.$clase->PiePagina();
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: infliqxper
    // Creación: 13/12/2021		última modificación: 04/09/2024
    // Creador: Luis Flórez		modificado por: Luis Flórez
    // Descripción: Opción que imprime el informe de acuerdo a la opción seleccionada
    // Última modificación: Inclusión del campo numreg para determinar si el empleado tiene 
    //                      los tres conceptos necesarios para considerarlo liquidado en un 
    //                      periodo (primas, vacaciones y cesantías) (27/12/2021)
    //                      Exclusión de los decimales para enmarcar las cantidades
    //                      (13/05/2022)
    //                      Reformulación de la consulta para excluir los registros pre 
    //                      configurados en la tabla noliquida (21/07/2022)
    //                      Corrección de los descuentos excluyendo las licencias no 
    //                      remuneradas, suspensiones e incapacidades a 180 días 
    //                      (16/02/2024)
    //                      Adaptación para emitir el informe con la nueva tabla para tales 
    //                      fines y sus salidas en html, pdf y Excel
    ////////////////////////////////////////////////////////////////////////////////////////        
    if($opcion=="infliqxper")
    {
        $codperiodo = $_POST['codperiodo'];     // Variable para filtrar el periodo
        $tiposalida = $_POST["tiposalida"];     // Variable que indica qué tipo de informe se mostrará

        // Variable para el nombre del periodo
        $desperiodo = $clase->BDLockup($codperiodo,'periodos','codperiodo','desperiodo');

        // Valido que el periodo tenga datos para emitir el reporte
        $vsqldatos = "SELECT COUNT(*) AS numreg 
                        FROM liquidacion 
                       WHERE periodonomina = '".$codperiodo."' 
                             AND ((tipo = 'vacaciones' AND pago > 0) OR (tipo = 'primas' AND pago > 0) 
                                   OR (tipo = 'cesantias' AND pago > 0) OR (tipo = 'indemnizacion' AND pago > 0))";
        $numreg = $clase->SeleccionarUno($vsqldatos);

        if($numreg==0)
        {
            $clase->Aviso(3,"No existen liquidados en el periodo $desperiodo");
            header("Location: liquidadosxperiodo.php?opcion=ventanadatos");
        }
        else
        {
            // ---------------------------------------------------------------------------------------------- //
            // Valido qué tipo de informe se emitirá, en antiguo con la consulta o el nuevo con la tabla            
            $orden = $clase->BDLockup($codperiodo,'periodos','codperiodo','orden');

            if($orden <= 128)
            {
                // Periodos en detalle liquidación
                $desperiodo = $clase->BDLockup($codperiodo,'periodos','codperiodo','desperiodo');
                $mesperiodo = substr($desperiodo,0,-5);
                $yeartoday = date("Y");
    
                // ------------------------------------------------------------- //
                $monthtoday = date("m");
                $daytoday = date("j");
                if(($monthtoday=="01")&&($daytoday<=16))   $yeartoday--;
                // ------------------------------------------------------------- //
        
                // fechas del periodo
                $fecinicio = substr($desperiodo,-4)."-".substr($codperiodo,0,2)."-01";
                $fecfinal = date("Y-m-t", strtotime($fecinicio));
        
                // Consulta de los periodos de nómina que se van a consultar
                $vsql = "SELECT periodoid 
                           FROM periodosnomina 
                          WHERE descripcion LIKE '%".$mesperiodo."%' 
                                AND descripcion LIKE '%".$yeartoday."%'";
                $conex  = $clase->Conectar();
                $result = mysql_query($vsql,$conex);
                $periodosreportar = mysql_num_rows($result);
        
                // Periodos a procesar
                if($periodosreportar>0)
                {
                    $j = 0;
                    while($row = mysql_fetch_array($result))
                    {
                        $listaperiodos.= $row['periodoid'].",";
                    }
                    $listaperiodos = substr($listaperiodos, 0, -1);
                }
    
                // Consulta del informe
                $vsql = "SELECT t.dni, CONCAT(t.primernombre,' ',t.segundonombre,' ',t.primerapellido,' ',t.segundoapellido) AS nombreemp, 
                                (SELECT SUM(IF(conceptoid=1,valor,0))
                                   FROM detalleliquidacion
                                  WHERE terid = t.terid
                                        AND pernominaid IN ($listaperiodos) LIMIT 0,1) AS diastrab, 
                                t.basico, 
                                (SELECT SUM(IF(conceptoid=1,devengados,0)) 
                                   FROM detalleliquidacion
                                  WHERE terid = t.terid
                                        AND pernominaid IN ($listaperiodos) LIMIT 0,1) AS salario, 
                                (SELECT SUM(IF(conceptoid=3,devengados,0)) 
                                   FROM detalleliquidacion
                                  WHERE terid = t.terid
                                        AND pernominaid IN ($listaperiodos) LIMIT 0,1) AS transporte,
                                (SELECT SUM(IF(conceptoid=4,descuentos,0)) 
                                  FROM detalleliquidacion
                                 WHERE terid = t.terid
                                       AND pernominaid IN ($listaperiodos) LIMIT 0,1) AS pension, 
                                (SELECT SUM(IF(conceptoid=5,descuentos,0)) 
                                   FROM detalleliquidacion
                                  WHERE terid = t.terid
                                        AND pernominaid IN ($listaperiodos) LIMIT 0,1) AS salud,
                                (SELECT cantidad
                                  FROM liquidacion
                                 WHERE terid = t.terid
                                       AND periodonomina = '".$codperiodo."'
                                       AND tipo='vacaciones' LIMIT 0,1) AS diasvaca, 
                                (SELECT pago
                                   FROM liquidacion
                                  WHERE terid = t.terid
                                        AND periodonomina = '".$codperiodo."'
                                        AND tipo='vacaciones' LIMIT 0,1) AS pagovaca, 
                                (SELECT IFNULL(cantidad,0)
                                   FROM liquidacion
                                  WHERE terid = t.terid
                                        AND periodonomina = '".$codperiodo."'
                                        AND tipo='primas'
                                        AND terid NOT IN (SELECT terid
                                                            FROM noliquida
                                                           WHERE noliquida.periodonomina = '".$codperiodo."'
                                                                 AND noliquida.terid = t.terid
                                                                 AND noliquida.tipo = 'primas')
                                        LIMIT 0,1) AS diasprima,
                                (SELECT IFNULL(pago,0)
                                   FROM liquidacion
                                  WHERE terid = t.terid
                                        AND periodonomina = '".$codperiodo."'
                                        AND tipo='primas'
                                        AND terid NOT IN (SELECT terid
                                                            FROM noliquida
                                                           WHERE noliquida.periodonomina = '".$codperiodo."'
                                                                 AND noliquida.terid = t.terid
                                                                 AND noliquida.tipo = 'primas')
                                        LIMIT 0,1) AS pagoprimas,
                                (SELECT pago
                                   FROM liquidacion
                                  WHERE terid = t.terid
                                        AND periodonomina = '".$codperiodo."'
                                        AND tipo='cesantias' LIMIT 0,1) AS pagocesantia, 
                                (SELECT pagointereses
                                   FROM liquidacion
                                  WHERE terid = t.terid
                                        AND periodonomina = '".$codperiodo."'
                                        AND tipo='cesantias' LIMIT 0,1) AS pagointereses, 
                                (SELECT pago
                                   FROM liquidacion
                                  WHERE terid = t.terid
                                        AND periodonomina = '".$codperiodo."'
                                        AND tipo='indemnizacion' LIMIT 0,1) AS indemnizacion,	
                                (SELECT SUM(IF(devengados>0,devengados,0)) 
                                   FROM detalleliquidacion 
                                  WHERE terid = t.terid
                                        AND pernominaid IN ($listaperiodos)
                                        AND conceptoid NOT IN (1,3) LIMIT 0,1) AS otrosdev, 
                                (SELECT SUM(IF(descuentos>0,descuentos,0)) 
                                   FROM detalleliquidacion 
                                  WHERE terid = t.terid
                                        AND pernominaid IN ($listaperiodos)
                                        AND conceptoid NOT IN (4,5,6,9,43,58) LIMIT 0,1) AS otrosdesc,
                                (SELECT COUNT(*) 
                                   FROM liquidacion 
                                  WHERE liquidacion.terid = l.terid 
                                        AND liquidacion.periodonomina = '".$codperiodo."' LIMIT 0,1) AS numreg 
                           FROM terceros t
                                INNER JOIN liquidacion l ON (t.terid = l.terid)
                          WHERE l.periodonomina = '".$codperiodo."'		
                       GROUP BY t.terid 
                         HAVING numreg >= 3";
    
                // Salida en vista html
                if($tiposalida=="vista")
                {
                    // pintamos la ventana
                    $cont.= $clase->HeaderBlanco("Liquidados por periodo");
                    $cont.='<table width="1300">
                             <tr class="CabezoteTabla"> 
                              <td width="10"> &nbsp; </td>
                              <td width="37"> <img src="images/iconos/docxpagar.png" width="32" height="32" border="0"> </td>
                              <td width="900"> <b> Liquidados del periodo '.$desperiodo.' </b> </td>
                              <td width="50"> &nbsp; </td>    				 				 				 				
                              <td width="30" align="center"> &nbsp; </td> 
                              <td width="30" align="center"> &nbsp; </td>
                              <td width="30" align="center"> &nbsp; </td>
                              <td width="10">&nbsp;</td>    				 				 				 				 
                             </tr>	 			   
                            </table>';
    
                    $cont.='<script type="text/javascript" src="lib/sorttable.js"></script>
                            <table width="1300" class="sortable">
                             <thead> 
                              <tr class="TituloTabla" style="display:block;padding-top:5px;height:25px;">
                               <td width="13">&nbsp;</td>                           
                               <td width="112" align="left"> <p>Nombre</p> </td>
                               <td width="26" align="right"> D&iacute;as </td>
                               <td width="78" align="right"> B&aacute;sico </td>
                               <td width="66" align="right"> Salario </td>
                               <td width="64" align="right"> Trans. </td>
                               <td width="71" align="right"> Pensi&oacute;n </td>
                               <td width="72" align="right"> Salud </td>
                               <td width="62" align="right"> D&iacute;as V. </td>
                               <td width="94" align="right"> Vacacion. </td>
                               <td width="60" align="right"> D&iacute;asP </td>
                               <td width="82" align="right"> Prima </td>
                               <td width="83" align="right"> Cesant&iacute;a </td>
                               <td width="78" align="right"> Intereses </td>
                               <td width="81" align="right"> Indem. </td>
                               <td width="99" align="right"> Devgds. </td>
                               <td width="96" align="right"> Descts. </td>
                               <td width="102" align="right"> T.devegs </td>
                               <td width="102" align="right"> T.desct </td>
                               <td width="93" align="right"> Neto </td>
                               <td width="25"> &nbsp; </td>
                              </tr>
                             </thead>
                             <tbody style="display:block; width:1300px; height:490px; overflow-Y:scroll">';
    
                    $i = 0;
                    $conex  = $clase->Conectar();
                    $result = mysql_query($vsql,$conex);
                    while($row = mysql_fetch_array($result))
                    {
                        // cálculo de los totales
                        $totaldevengado = $row['salario'] + $row['transporte'] + $row['pagovaca'] + $row['pagoprimas'] + $row['pagocesantia'] + $row['pagointereses'] + $row['indemnizacion'] + $row['otrosdev'];
                        $totaldescuento = $row['pension'] + $row['salud'] + $row['otrosdesc'];
                        $netoapagar = $totaldevengado - $totaldescuento;
    
                        $i++;
                        if($i%2 == 0)
                            $cont.='<tr class="TablaDocsPar">';
                        else
                            $cont.='<tr class="TablaDocsImPar">';
    
                        $cont.=' <td width="13">&nbsp;</td>
                                 <td width="112" align="left"> '.$row['nombreemp'].' </td>
                                 <td width="26" align="right"> '.$row['diastrab'].' </td>
                                 <td width="78" align="right"> '.number_format($row['basico']).' </td>
                                 <td width="66" align="right"> '.number_format($row['salario']).' </td>
                                 <td width="64" align="right"> '.number_format($row['transporte']).' </td>
                                 <td width="71" align="right"> '.number_format($row['pension']).' </td>
                                 <td width="72" align="right"> '.number_format($row['salud']).' </td>
                                 <td width="62" align="right"> '.number_format($row['diasvaca']).' </td>
                                 <td width="94" align="right"> '.number_format($row['pagovaca']).' </td>
                                 <td width="60" align="right"> '.number_format($row['diasprima']).' </td>
                                 <td width="82" align="right"> '.number_format($row['pagoprimas']).' </td>
                                 <td width="83" align="right"> '.number_format($row['pagocesantia']).' </td>
                                 <td width="78" align="right"> '.number_format($row['pagointereses']).' </td>
                                 <td width="81" align="right"> '.number_format($row['indemnizacion']).' </td>
                                 <td width="99" align="right"> '.number_format($row['otrosdev']).' </td>
                                 <td width="96" align="right"> '.number_format($row['otrosdesc']).' </td>
                                 <td width="102" align="right"> '.number_format($totaldevengado).' </td>
                                 <td width="102" align="right"> '.number_format($totaldescuento).' </td>
                                 <td width="93" align="right"> '.number_format($netoapagar).' </td>
                                </tr>';
                    }
    
                    $cont.=' </tbody> 
                            </table>';
                    echo $cont;
                }
    
                // vista en formato pdf
                if($tiposalida=="pdf")
                {
                    // Traducción al español del mes que devuelve la función date()
                    $mesimp = date('F');
                    if($mesimp=="January")       $mesimp = "Enero";
                    if($mesimp=="February")      $mesimp = "Febrero";
                    if($mesimp=="March")         $mesimp = "Marzo";
                    if($mesimp=="April")         $mesimp = "Abril";
                    if($mesimp=="May")           $mesimp = "Mayo";
                    if($mesimp=="June")          $mesimp = "Junio";
                    if($mesimp=="July")          $mesimp = "Julio";
                    if($mesimp=="August")        $mesimp = "Agosto";
                    if($mesimp=="September")     $mesimp = "Septiembre";
                    if($mesimp=="October")       $mesimp = "Octubre";
                    if($mesimp=="November")      $mesimp = "Noviembre";
                    if($mesimp=="December")      $mesimp = "Diciembre";
    
                    $clase = new Sistema();
                    ini_set("memory_limit","200M");
                    require('lib/fpdf/fpdf.php');
                    $pdf = new FPDF('L','mm','a3');
    
                    $pdf->AddPage("");
    
                    // Logo Dromedicas
                    $pdf->Image('images/empresa/logo-dromedicas-en-azul.png',10,10,20,25,'PNG','');
    
                    $x = 35;
                    $y = 15;
                    $pagina = 1;
    
                    $pdf->SetFont('Arial','B',10);      $enc= "DROMEDICAS DEL ORIENTE SAS - NIT: 900265730-0";      $pdf->Text($x,$y,$enc);
    
                    // Fecha y hora de impresión
                    $fechoraimp = $mesimp." ".date('d')." de ".date('Y g:i a')."    Pagina: ".$pagina;
    
                    // impresión del encabezado
                    $pdf->SetFont('Arial','',8);        $pdf->Text($x+320,$y,$fechoraimp);
                    $pdf->SetFont('Arial','B',10);      $enc= "LIQUIDADOS DEL PERIODO ".$desperiodo;                $pdf->Text($x,$y+7,$enc);
                    $pdf->SetFillColor(220,220,220);    $pdf->Rect(7,$y+28,405,8,'F');
                    $enc= "DOCUMENTO";                  $pdf->Text(9,$y+33,$enc);
                    $enc= "NOMBRE";                     $pdf->Text(34,$y+33,$enc);
                    $enc= "DIAS";                       $pdf->Text(90,$y+33,$enc);
                    $enc= "BASICO";                     $pdf->Text(101,$y+33,$enc);
                    $enc= "SALARIO";                    $pdf->Text(116,$y+33,$enc);
                    $enc= "TRANS";                      $pdf->Text(134,$y+33,$enc);
                    $enc= "PENSION";                    $pdf->Text(149,$y+33,$enc);
                    $enc= "SALUD";                      $pdf->Text(168,$y+33,$enc);
                    $enc= "DIAS V.";                    $pdf->Text(183,$y+33,$enc);
                    $enc= "VACACION";                   $pdf->Text(197,$y+33,$enc);
                    $enc= "DIAS P.";                    $pdf->Text(217,$y+33,$enc);
                    $enc= "PRIMA";                      $pdf->Text(234,$y+33,$enc);
                    $enc= "CESANTIAS";                  $pdf->Text(248,$y+33,$enc);
                    $enc= "INTERESES";                  $pdf->Text(272,$y+33,$enc);
                    $enc= "INDEMN";                     $pdf->Text(294,$y+33,$enc);
                    $enc= "DEVGDS";                     $pdf->Text(313,$y+33,$enc);
                    $enc= "DESCTS";                     $pdf->Text(333,$y+33,$enc);
                    $enc= "T. DEVGS";                   $pdf->Text(352,$y+33,$enc);
                    $enc= "T. DESCT";                   $pdf->Text(373,$y+33,$enc);
                    $enc= "NETO";                       $pdf->Text(400,$y+33,$enc);
                    $pdf->SetFont('Arial','',8);
                    
                    // inicialización de variables
                    $x = 9;
                    $y = 56;
                    $totaldevengado = 0;
                    $totaldescuento = 0;
                    $netoapagar = 0;
    
                    $conex = $clase->Conectar();
                    $result = mysql_query($vsql,$conex);
                    while($row = mysql_fetch_array($result))
                    {
                        $i++;
    
                        // Impresión de documento y nombre
                        $pdf->Text($x,$y,$row['dni']);
                        $pdf->Text($x+25,$y,substr($row['nombreemp'],0,30));
    
                        // Días trabajados
                        $longitud = strlen($row['diastrab']);
                        if($longitud==1)        $pdf->Text($x+88,$y,number_format($row['diastrab']));
                        if($longitud==2)        $pdf->Text($x+86,$y,number_format($row['diastrab']));
    
                        // Sueldo básico
                        $longitud = strlen($row['basico']);
                        if($longitud==7)        $pdf->Text($x+93,$y,number_format($row['basico']));
                        if($longitud==6)        $pdf->Text($x+96,$y,number_format($row['basico']));
    
                        // Salario devengado
                        $salario = $row['salario'];
    
                        if($salario==NULL)
                            $salario=0;
    
                        $longitud = strlen($salario);
    
                        if($longitud==7)        $pdf->Text($x+109,$y,number_format($salario));
                        if($longitud==6)        $pdf->Text($x+112,$y,number_format($salario));
                        if($longitud==5)        $pdf->Text($x+114,$y,number_format($salario));
                        if($longitud==4)        $pdf->Text($x+118,$y,number_format($salario));
                        if($longitud==3)        $pdf->Text($x+121,$y,number_format($salario));
                        if($longitud==2)        $pdf->Text($x+124,$y,number_format($salario));
                        if($longitud==1)        $pdf->Text($x+123,$y,number_format($salario));
                        if($longitud==0)        $pdf->Text($x+94,$y,number_format($salario));                    
    
                        // Subsidio de transporte
                        $transporte = $row['transporte'];
                        $longitud = strlen($transporte);
    
                        if($longitud==5)        $pdf->Text($x+128,$y,number_format($transporte));
                        if($longitud==4)        $pdf->Text($x+130,$y,number_format($transporte));
                        if($longitud==3)        $pdf->Text($x+132,$y,number_format($transporte));
                        if($longitud==2)        $pdf->Text($x+134,$y,number_format($transporte));
                        if($longitud==1)        $pdf->Text($x+137,$y,number_format($transporte));
    
                        // Pensión
                        $pension = $row['pension'];
                        $longitud = strlen($pension);
    
                        if($longitud==5)        $pdf->Text($x+147,$y,number_format($pension));
                        if($longitud==4)        $pdf->Text($x+149,$y,number_format($pension));
                        if($longitud==3)        $pdf->Text($x+151,$y,number_format($pension));
                        if($longitud==2)        $pdf->Text($x+153,$y,number_format($pension));
                        if($longitud==1)        $pdf->Text($x+155,$y,number_format($pension));                    
    
                        // Salud
                        $salud = $row['salud'];
                        $longitud = strlen($salud);
    
                        if($longitud==5)        $pdf->Text($x+162,$y,number_format($salud));
                        if($longitud==4)        $pdf->Text($x+164,$y,number_format($salud));
                        if($longitud==3)        $pdf->Text($x+166,$y,number_format($salud));
                        if($longitud==2)        $pdf->Text($x+168,$y,number_format($salud));
                        if($longitud==1)        $pdf->Text($x+170,$y,number_format($salud));
    
                        // Días de vacaciones
                        $diasvaca = $row['diasvaca'];
                        $longitud = strlen($diasvaca);
    
                        if($longitud==3)        $pdf->Text($x+180,$y,number_format($diasvaca));
                        if($longitud==2)        $pdf->Text($x+182,$y,number_format($diasvaca));
                        if($longitud==1)        $pdf->Text($x+184,$y,number_format($diasvaca));                    
    
                        // Pago de vacaciones
                        $pagovaca = $row['pagovaca'];
                        $longitud = strlen(intval($pagovaca));
    
                        if($longitud==9)        $pdf->Text($x+196,$y,number_format($pagovaca));
                        if($longitud==8)        $pdf->Text($x+196,$y,number_format($pagovaca));
                        if($longitud==7)        $pdf->Text($x+196,$y,number_format($pagovaca));
                        if($longitud==6)        $pdf->Text($x+196,$y,number_format($pagovaca));
                        if($longitud==5)        $pdf->Text($x+199,$y,number_format($pagovaca));
                        if($longitud==4)        $pdf->Text($x+201,$y,number_format($pagovaca));
                        if($longitud==3)        $pdf->Text($x+202,$y,number_format($pagovaca));
                        if($longitud==2)        $pdf->Text($x+206,$y,number_format($pagovaca));
                        if($longitud==1)        $pdf->Text($x+207,$y,number_format($pagovaca));
    
                        // Días de prima
                        $diasprima = $row['diasprima'];
                        if($diasprima==NULL)        $diasprima=0;
                        $longitud = strlen($diasprima);
    
                        if($longitud==3)        $pdf->Text($x+214,$y,number_format($diasprima));
                        if($longitud==2)        $pdf->Text($x+216,$y,number_format($diasprima));
                        if($longitud==1)        $pdf->Text($x+218,$y,number_format($diasprima));
    
                        // Pago de la prima
                        $pagoprimas = $row['pagoprimas'];
                        $longitud = strlen(intval($pagoprimas));
    
                        if($longitud==9)        $pdf->Text($x+226,$y,number_format($pagoprimas));
                        if($longitud==8)        $pdf->Text($x+226,$y,number_format($pagoprimas));
                        if($longitud==7)        $pdf->Text($x+226,$y,number_format($pagoprimas));
                        if($longitud==6)        $pdf->Text($x+226,$y,number_format($pagoprimas));
                        if($longitud==5)        $pdf->Text($x+228,$y,number_format($pagoprimas));
                        if($longitud==4)        $pdf->Text($x+230,$y,number_format($pagoprimas));
                        if($longitud==3)        $pdf->Text($x+232,$y,number_format($pagoprimas));
                        if($longitud==2)        $pdf->Text($x+234,$y,number_format($pagoprimas));
                        if($longitud==1)        $pdf->Text($x+236,$y,number_format($pagoprimas));
    
                        // Pago de cesantías
                        $pagocesantia = $row['pagocesantia'];
                        $longitud = strlen(intval($pagocesantia));
    
                        if($longitud==9)        $pdf->Text($x+249,$y,number_format($pagocesantia));
                        if($longitud==7)        $pdf->Text($x+246,$y,number_format($pagocesantia));
                        if($longitud==6)        $pdf->Text($x+249,$y,number_format($pagocesantia));
                        if($longitud==5)        $pdf->Text($x+251,$y,number_format($pagocesantia));
                        if($longitud==4)        $pdf->Text($x+254,$y,number_format($pagocesantia));
                        if($longitud==3)        $pdf->Text($x+256,$y,number_format($pagocesantia));
                        if($longitud==2)        $pdf->Text($x+258,$y,number_format($pagocesantia));
                        if($longitud==1)        $pdf->Text($x+260,$y,number_format($pagocesantia));
    
                        // Intereses de las cesantías
                        $pagointereses = $row['pagointereses'];
                        $longitud = strlen(intval($pagointereses));
    
                        if($longitud==6)        $pdf->Text($x+272,$y,number_format($pagointereses));
                        if($longitud==5)        $pdf->Text($x+274,$y,number_format($pagointereses));
                        if($longitud==4)        $pdf->Text($x+276,$y,number_format($pagointereses));
                        if($longitud==3)        $pdf->Text($x+278,$y,number_format($pagointereses));
                        if($longitud==2)        $pdf->Text($x+280,$y,number_format($pagointereses));
                        if($longitud==1)        $pdf->Text($x+282,$y,number_format($pagointereses));
    
                        // Indemnización
                        $indemnizacion = $row['indemnizacion'];
                        $longitud = strlen($indemnizacion);
    
                        // if($indemnizacion==NULL)        $indemnizacion=0;
    
                        // if($longitud==6)
                            $pdf->Text($x+297,$y,number_format($indemnizacion));
    
                        // if($longitud==5)
                        //     $pdf->Text($x+288,$y,number_format($indemnizacion));
    
                        // if($longitud==4)
                        //     $pdf->Text($x+290,$y,number_format($indemnizacion));
    
                        // if($longitud==3)
                        //     $pdf->Text($x+292,$y,number_format($indemnizacion));
    
                        // if($longitud==2)
                        //     $pdf->Text($x+294,$y,number_format($indemnizacion));
    
                        // if($longitud==1)
                        //     $pdf->Text($x+286,$y,number_format($indemnizacion));
    
                        // Otros devengados
                        $otrosdev = $row['otrosdev'];
                        $longitud = strlen($otrosdev);
    
                        $pdf->Text($x+309,$y,number_format($otrosdev));
    
                        // Otros descuentos
                        $otrosdesc = $row['otrosdesc'];
                        $longitud = strlen(intval($otrosdesc));
    
                        if($longitud==6)        $pdf->Text($x+328,$y,number_format($otrosdesc));
                        if($longitud==5)        $pdf->Text($x+330,$y,number_format($otrosdesc));
                        if($longitud==4)        $pdf->Text($x+332,$y,number_format($otrosdesc));
                        if($longitud==3)        $pdf->Text($x+334,$y,number_format($otrosdesc));
                        if($longitud==2)        $pdf->Text($x+336,$y,number_format($otrosdesc));
                        if($longitud==1)        $pdf->Text($x+336,$y,number_format($otrosdesc));
    
                        // cálculo de los totales
                        $totaldevengado = $salario + $transporte + $pagovaca + $pagoprimas + $pagocesantia + $pagointereses + $indemnizacion + $otrosdev;
                        $totaldescuento = $pension + $salud + $otrosdesc;
                        $netoapagar = $totaldevengado - $totaldescuento;
    
                        // total devengados                    
                        $longitud = strlen(intval($totaldevengado));
    
                        if($longitud==7)        $pdf->Text($x+347,$y,number_format($totaldevengado));
                        if($longitud==6)        $pdf->Text($x+349,$y,number_format($totaldevengado));
                        if($longitud==5)        $pdf->Text($x+351,$y,number_format($totaldevengado));
                        if($longitud==4)        $pdf->Text($x+353,$y,number_format($totaldevengado));
                        if($longitud==3)        $pdf->Text($x+355,$y,number_format($totaldevengado));
                        if($longitud==2)        $pdf->Text($x+357,$y,number_format($totaldevengado));
                        if($longitud==1)        $pdf->Text($x+359,$y,number_format($totaldevengado));
    
                        // total descuentos
                        $longitud = strlen($totaldescuento);
    
                        if($longitud==6)        $pdf->Text($x+369,$y,number_format($totaldescuento));
                        if($longitud==5)        $pdf->Text($x+371,$y,number_format($totaldescuento));
                        if($longitud==4)        $pdf->Text($x+373,$y,number_format($totaldescuento));
                        if($longitud==3)        $pdf->Text($x+375,$y,number_format($totaldescuento));
                        if($longitud==2)        $pdf->Text($x+377,$y,number_format($totaldescuento));
                        if($longitud==1)        $pdf->Text($x+379,$y,number_format($totaldescuento));
    
                        // neto a pagar
                        $longitud = strlen(intval($netoapagar));
    
                        if($longitud==15)       $pdf->Text($x+371,$y,number_format($netoapagar));
                        if($longitud==14)       $pdf->Text($x+373,$y,number_format($netoapagar));
                        if($longitud==13)       $pdf->Text($x+375,$y,number_format($netoapagar));
                        if($longitud==12)       $pdf->Text($x+377,$y,number_format($netoapagar));
                        if($longitud==11)       $pdf->Text($x+379,$y,number_format($netoapagar));
                        if($longitud==10)       $pdf->Text($x+383,$y,number_format($netoapagar));
                        if($longitud==9)        $pdf->Text($x+383,$y,number_format($netoapagar));
                        if($longitud==8)        $pdf->Text($x+385,$y,number_format($netoapagar));
                        if($longitud==7)        $pdf->Text($x+388,$y,number_format($netoapagar));
                        if($longitud==6)        $pdf->Text($x+391,$y,number_format($netoapagar));
                        if($longitud==5)        $pdf->Text($x+391,$y,number_format($netoapagar));
                        if($longitud==4)        $pdf->Text($x+393,$y,number_format($netoapagar));
                        if($longitud==3)        $pdf->Text($x+395,$y,number_format($netoapagar));
                        if($longitud==2)        $pdf->Text($x+397,$y,number_format($netoapagar));
                        if($longitud==1)        $pdf->Text($x+399,$y,number_format($netoapagar));
                        // ------------------------------------------------------------------- //
                        $y+=6;
    
                        if($i%36 == 0)
                        {
                            $pdf->AddPage("");
    
                            // Logo Dromedicas
                            $pdf->Image('images/empresa/logo-dromedicas-en-azul.png',10,10,20,25,'PNG','');
    
                            $x = 35;
                            $y = 15;
                            $pagina++;
    
                            $pdf->SetFont('Arial','B',10);      $enc= "DROMEDICAS DEL ORIENTE SAS - NIT: 900265730-0";      $pdf->Text($x,$y,$enc);
            
                            // Fecha y hora de impresión
                            $fechoraimp = $mesimp." ".date('d')." de ".date('Y g:i a')."    Pagina: ".$pagina;
    
                            $pdf->SetFont('Arial','',8);        $pdf->Text($x+320,$y,$fechoraimp);
                            $pdf->SetFont('Arial','B',10);      $enc= "LIQUIDADOS DEL PERIODO ".$desperiodo;                $pdf->Text($x,$y+7,$enc);
                            $pdf->SetFillColor(220,220,220);    $pdf->Rect(7,$y+28,405,8,'F');
                            $enc= "DOCUMENTO";                  $pdf->Text(9,$y+33,$enc);
                            $enc= "NOMBRE";                     $pdf->Text(34,$y+33,$enc);
                            $enc= "DIAS";                       $pdf->Text(90,$y+33,$enc);
                            $enc= "BASICO";                     $pdf->Text(101,$y+33,$enc);
                            $enc= "SALARIO";                    $pdf->Text(116,$y+33,$enc);
                            $enc= "TRANS";                      $pdf->Text(134,$y+33,$enc);
                            $enc= "PENSION";                    $pdf->Text(149,$y+33,$enc);
                            $enc= "SALUD";                      $pdf->Text(168,$y+33,$enc);
                            $enc= "DIAS V.";                    $pdf->Text(183,$y+33,$enc);
                            $enc= "VACACION";                   $pdf->Text(197,$y+33,$enc);
                            $enc= "DIAS P.";                    $pdf->Text(217,$y+33,$enc);
                            $enc= "PRIMA";                      $pdf->Text(234,$y+33,$enc);
                            $enc= "CESANTIAS";                  $pdf->Text(248,$y+33,$enc);
                            $enc= "INTERESES";                  $pdf->Text(272,$y+33,$enc);
                            $enc= "INDEMN";                     $pdf->Text(294,$y+33,$enc);
                            $enc= "DEVGDS";                     $pdf->Text(313,$y+33,$enc);
                            $enc= "DESCTS";                     $pdf->Text(333,$y+33,$enc);
                            $enc= "T. DEVGS";                   $pdf->Text(352,$y+33,$enc);
                            $enc= "T. DESCT";                   $pdf->Text(373,$y+33,$enc);
                            $enc= "NETO";                       $pdf->Text(400,$y+33,$enc);
                            $pdf->SetFont('Arial','',8);
    
                            $x = 9;
                            $y = 56;
                        }
                        
                    }
                    $pdf->Output();
                }
    
                // salida a excel
                if($tiposalida=="excel")
                {
                    require_once 'lib/PHPExcel.php';
                    $clase = new Sistema();
                    $clase->Conectar();
                    ini_set("memory_limit","100M");
    
                    // Preparación del entorno para la salida a Excel
                    $clase = new Sistema();
                    $clase->Nombredb = $_SESSION['DBNOMBRE'];
                    error_reporting(E_ALL);
                    ini_set('display_errors', TRUE);
                    ini_set('display_startup_errors', TRUE);
                    date_default_timezone_set('Europe/London');
                
                    if (PHP_SAPI == 'cli')
                        die('This example should only be run from a Web Browser');
                
                    // Create new PHPExcel object
                    $objPHPExcel = new PHPExcel();
                
                    // Set document properties
                    $objPHPExcel->getProperties()->setCreator("Sistemas y Soluciones Web de Colombia")
                                                 ->setLastModifiedBy("Sistemas y Soluciones Web de Colombia")
                                                 ->setTitle("Liquidados por periodo - DROPOS")
                                                 ->setSubject("Liquidados por periodo - DROPOS")
                                                 ->setDescription("Liquidados por periodo - DROPOS")
                                                 ->setKeywords("Liquidados por periodo - DROPOS")
                                                 ->setCategory("Categoria General");
    
                    // encabezado
                    $objPHPExcel->setActiveSheetIndex(0)
                                ->setCellValue('A1', 'LIQUIDADOS POR PERIODO')
                                ->setCellValue('A2', 'PERIODO: '.$desperiodo)                            
                                ->setCellValue('A4', 'DOCUMENTO')
                                ->setCellValue('B4', 'NOMBRE')
                                ->setCellValue('C4', 'DIAS TRAB.')
                                ->setCellValue('D4', 'BASICO')
                                ->setCellValue('E4', 'SALARIO')
                                ->setCellValue('F4', 'TRANSPORTE')
                                ->setCellValue('G4', 'PENSION')
                                ->setCellValue('H4', 'SALUD')
                                ->setCellValue('I4', 'DIAS VACA.')
                                ->setCellValue('J4', 'PAGO VACA.')
                                ->setCellValue('K4', 'DIAS PRIMA')
                                ->setCellValue('L4', 'PAGO PRIMA')
                                ->setCellValue('M4', 'PAGO CESAN.')
                                ->setCellValue('N4', 'PAGO INTERS.')
                                ->setCellValue('O4', 'INDEMNIZACION')
                                ->setCellValue('P4', 'OTROS DEVGS.')
                                ->setCellValue('Q4', 'OTROS DESC.')
                                ->setCellValue('R4', 'TOTAL DEVENG.')
                                ->setCellValue('S4', 'TOTAL DESCTS.')
                                ->setCellValue('T4', 'NETO A PAGAR');
    
                    $objPHPExcel->getActiveSheet()->getColumnDimension('A')->setAutoSize(true);         $objPHPExcel->getActiveSheet()->getColumnDimension('B')->setAutoSize(true);
                    $objPHPExcel->getActiveSheet()->getColumnDimension('C')->setAutoSize(true);         $objPHPExcel->getActiveSheet()->getColumnDimension('D')->setAutoSize(true);
                    $objPHPExcel->getActiveSheet()->getColumnDimension('E')->setAutoSize(true);         $objPHPExcel->getActiveSheet()->getColumnDimension('F')->setAutoSize(true);
                    $objPHPExcel->getActiveSheet()->getColumnDimension('G')->setAutoSize(true);         $objPHPExcel->getActiveSheet()->getColumnDimension('H')->setAutoSize(true);
                    $objPHPExcel->getActiveSheet()->getColumnDimension('I')->setAutoSize(true);         $objPHPExcel->getActiveSheet()->getColumnDimension('J')->setAutoSize(true);
                    $objPHPExcel->getActiveSheet()->getColumnDimension('K')->setAutoSize(true);         $objPHPExcel->getActiveSheet()->getColumnDimension('L')->setAutoSize(true);
                    $objPHPExcel->getActiveSheet()->getColumnDimension('M')->setAutoSize(true);         $objPHPExcel->getActiveSheet()->getColumnDimension('N')->setAutoSize(true);
                    $objPHPExcel->getActiveSheet()->getColumnDimension('O')->setAutoSize(true);         $objPHPExcel->getActiveSheet()->getColumnDimension('P')->setAutoSize(true);
                    $objPHPExcel->getActiveSheet()->getColumnDimension('Q')->setAutoSize(true);         $objPHPExcel->getActiveSheet()->getColumnDimension('R')->setAutoSize(true);
                    $objPHPExcel->getActiveSheet()->getColumnDimension('S')->setAutoSize(true);         $objPHPExcel->getActiveSheet()->getColumnDimension('T')->setAutoSize(true);
    
                    $conex  = $clase->Conectar();
                    $result = mysql_query($vsql,$conex);
                    $cant   = mysql_num_rows($result);
                    $i = 5;
                    $totaldevengado = 0;
                    $totaldescuento = 0;
                    $netoapagar = 0;
    
                    // Detalle del informe
                    while($row = mysql_fetch_array($result))
                    {
                        $totaldevengado = $row['salario'] + $row['transporte'] + $row['pagovaca'] + $row['pagoprimas'] + $row['pagocesantia'] + $row['pagointereses'] + $row['indemnizacion'] + $row['otrosdev'];
                        $totaldescuento = $row['pension'] + $row['salud'] + $row['otrosdesc'];
                        $netoapagar = $totaldevengado - $totaldescuento;
    
                        $objPHPExcel->setActiveSheetIndex(0)
                                    ->setCellValue('A'.$i, $row['dni'])
                                    ->setCellValue('B'.$i, $row['nombreemp'])
                                    ->setCellValue('C'.$i, number_format($row['diastrab']))
                                    ->setCellValue('D'.$i, number_format($row['basico']))
                                    ->setCellValue('E'.$i, number_format($row['salario']))
                                    ->setCellValue('F'.$i, number_format($row['transporte']))
                                    ->setCellValue('G'.$i, number_format($row['pension']))
                                    ->setCellValue('H'.$i, number_format($row['salud']))
                                    ->setCellValue('I'.$i, number_format($row['diasvaca']))
                                    ->setCellValue('J'.$i, number_format($row['pagovaca']))
                                    ->setCellValue('K'.$i, number_format($row['diasprima']))
                                    ->setCellValue('L'.$i, number_format($row['pagoprimas']))
                                    ->setCellValue('M'.$i, number_format($row['pagocesantia']))
                                    ->setCellValue('N'.$i, number_format($row['pagointereses']))
                                    ->setCellValue('O'.$i, number_format($row['indemnizacion']))
                                    ->setCellValue('P'.$i, number_format($row['otrosdev']))
                                    ->setCellValue('Q'.$i, number_format($row['otrosdesc']))
                                    ->setCellValue('R'.$i, number_format($totaldevengado))
                                    ->setCellValue('S'.$i, number_format($totaldescuento))
                                    ->setCellValue('T'.$i, number_format($netoapagar));
                        $i++;
                    }
    
                    $rangoEncabezado = 'A4:T4';
                    $rangoCeldas     = 'A4:T'.($i-1);
                    // ----------------------------------------------------------------------------------------------------------------------------------------------------------- //
                    
                    // Formato de Encabezado y Celdas
                    $objPHPExcel->getActiveSheet()->getRowDimension('1')->setRowHeight(15);
                    
                    $EstiloCeldas = array(
                    'borders' => array(
                        'allborders' => array(
                            'style' => PHPExcel_Style_Border::BORDER_THIN,
                            'color' => array('argb' => '00000000'),
                        ),
                        ),
                    );
                    $objPHPExcel->getActiveSheet()->getStyle($rangoCeldas)->applyFromArray($EstiloCeldas);
                    /// Formato de Encabezados 
                    $EstiloEncabezado = array(
                    'font' => array(
                        'bold' => true,
                    ),
                    'alignment' => array(
                        'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,
                        'vertical' => PHPExcel_Style_Alignment::VERTICAL_CENTER,		
                    ),
                    'borders' => array(
                        'allborders' => array(
                            'style' => PHPExcel_Style_Border::BORDER_THIN,
                            'color' => array('argb' => '00000000'),
                        ),
                    ),
                    'fill' => array(
                        'type' => PHPExcel_Style_Fill::FILL_SOLID,
                        'rotation' => 90,
                        'startcolor' => array(
                            'argb' => '00FFFFCC',
                        ),
                        'endcolor' => array(
                            'argb' => 'FFFFFF',
                        ),
                        ),
                    );
                    $objPHPExcel->getActiveSheet()->getStyle($rangoEncabezado)->applyFromArray($EstiloEncabezado);
                    // Rename worksheet
                    $objPHPExcel->getActiveSheet()->setTitle('rotación de producto');
                    // Set active sheet index to the first sheet, so Excel opens this as the first sheet
                    $objPHPExcel->setActiveSheetIndex(0);
                    // Redirect output to a client’s web browser (Excel5)
                    header('Content-Type: application/vnd.ms-excel');
                    // --------------------------------------------------------------------- //                
                    $nombrearcexcel = "liquidados del periodo ".strtolower($desperiodo).".xls";
                    header('Content-Disposition: attachment;filename='.$nombrearcexcel.'');
                    // --------------------------------------------------------------------- //
                    header('Cache-Control: max-age=0');
                    /// Genero la Salida
                    $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');
                    $objWriter->save('php://output');
                    exit;
                }
            }
            else
            {
                // consulta del informe
                $vsql = "SELECT * FROM tmpinfliquidados WHERE codperiodo = '".$codperiodo."' ORDER BY codvende";

                // Salida en vista html
                if($tiposalida=="vista")
                {
                    // pintamos la ventana
                    $cont.= $clase->HeaderBlanco("Liquidados por periodo");
                    $cont.='<table width="1300">
                             <tr class="CabezoteTabla"> 
                              <td width="10"> &nbsp; </td>
                              <td width="37"> <img src="images/iconos/docxpagar.png" width="32" height="32" border="0"> </td>
                              <td width="900"> <b> Liquidados del periodo </b> <br> <font color="blue"> '.$desperiodo.' </font> </td>
                              <td width="50"> &nbsp; </td>    				 				 				 				
                              <td width="30" align="center"> &nbsp; </td> 
                              <td width="30" align="center"> &nbsp; </td>
                              <td width="30" align="center"> &nbsp; </td>
                              <td width="10"> &nbsp; </td>    				 				 				 				 
                             </tr>	 			   
                            </table>';
    
                    $cont.='<script type="text/javascript" src="lib/sorttable.js"></script>
                            <table width="1300" class="sortable">
                             <thead> 
                              <tr class="TituloTabla" style="display:block;padding-top:5px;height:25px;">
                               <td width="13">&nbsp;</td>                           
                               <td width="112" align="left"> <p>Nombre</p> </td>
                               <td width="26" align="right"> D&iacute;as </td>
                               <td width="78" align="right"> B&aacute;sico </td>
                               <td width="66" align="right"> Salario </td>
                               <td width="64" align="right"> Trans. </td>
                               <td width="71" align="right"> Pensi&oacute;n </td>
                               <td width="72" align="right"> Salud </td>
                               <td width="62" align="right"> D&iacute;as V. </td>
                               <td width="94" align="right"> Vacacion. </td>
                               <td width="60" align="right"> D&iacute;asP </td>
                               <td width="82" align="right"> Prima </td>
                               <td width="83" align="right"> Cesant&iacute;a </td>
                               <td width="78" align="right"> Intereses </td>
                               <td width="81" align="right"> Indem. </td>
                               <td width="99" align="right"> Devgds. </td>
                               <td width="96" align="right"> Descts. </td>
                               <td width="102" align="right"> T.devegs </td>
                               <td width="102" align="right"> T.desct </td>
                               <td width="93" align="right"> Neto </td>
                               <td width="25"> &nbsp; </td>
                              </tr>
                             </thead>
                             <tbody style="display:block; width:1300px; height:490px; overflow-Y:scroll">';
    
                    $i = 0;
                    $conex  = $clase->Conectar();
                    $result = mysql_query($vsql,$conex);
                    while($row = mysql_fetch_array($result))
                    {    
                        $i++;
                        if($i%2 == 0)
                            $cont.='<tr class="TablaDocsPar">';
                        else
                            $cont.='<tr class="TablaDocsImPar">';
    
                        $cont.=' <td width="13">&nbsp;</td>
                                 <td width="112" align="left"> '.$row['nombre'].' </td>
                                 <td width="26" align="right"> '.$row['diastrab'].' </td>
                                 <td width="78" align="right"> '.number_format($row['basico']).' </td>
                                 <td width="66" align="right"> '.number_format($row['sueldo']).' </td>
                                 <td width="64" align="right"> '.number_format($row['subsidiotransporte']).' </td>
                                 <td width="71" align="right"> '.number_format($row['pension']).' </td>
                                 <td width="72" align="right"> '.number_format($row['salud']).' </td>
                                 <td width="62" align="right"> '.number_format($row['diasvaca']).' </td>
                                 <td width="94" align="right"> '.number_format($row['pagovaca']).' </td>
                                 <td width="60" align="right"> '.number_format($row['diasprima']).' </td>
                                 <td width="82" align="right"> '.number_format($row['pagoprima']).' </td>
                                 <td width="83" align="right"> '.number_format($row['pagocedesantias']).' </td>
                                 <td width="78" align="right"> '.number_format($row['pagointereses']).' </td>
                                 <td width="81" align="right"> '.number_format($row['indemnizacion']).' </td>
                                 <td width="99" align="right"> '.number_format($row['otrosdevengados']).' </td>
                                 <td width="96" align="right"> '.number_format($row['otrosdescuentos']).' </td>
                                 <td width="102" align="right"> '.number_format($row['totaldevengado']).' </td>
                                 <td width="102" align="right"> '.number_format($row['totaldescuento']).' </td>
                                 <td width="93" align="right"> '.number_format($row['netoapagar']).' </td>
                                </tr>';
                    }
    
                    $cont.=' </tbody> 
                            </table>';
                    echo $cont;
                }                

                // vista en formato pdf
                if($tiposalida=="pdf")
                {
                    // Traducción al español del mes que devuelve la función date()
                    $mesimp = date('F');
                    if($mesimp=="January")       $mesimp = "Enero";
                    if($mesimp=="February")      $mesimp = "Febrero";
                    if($mesimp=="March")         $mesimp = "Marzo";
                    if($mesimp=="April")         $mesimp = "Abril";
                    if($mesimp=="May")           $mesimp = "Mayo";
                    if($mesimp=="June")          $mesimp = "Junio";
                    if($mesimp=="July")          $mesimp = "Julio";
                    if($mesimp=="August")        $mesimp = "Agosto";
                    if($mesimp=="September")     $mesimp = "Septiembre";
                    if($mesimp=="October")       $mesimp = "Octubre";
                    if($mesimp=="November")      $mesimp = "Noviembre";
                    if($mesimp=="December")      $mesimp = "Diciembre";
    
                    $clase = new Sistema();
                    ini_set("memory_limit","200M");
                    require('lib/fpdf/fpdf.php');
                    $pdf = new FPDF('L','mm','a3');
    
                    $pdf->AddPage("");
    
                    // Logo Dromedicas
                    $pdf->Image('images/empresa/logo-dromedicas-en-azul.png',10,10,20,25,'PNG','');
    
                    $x = 35;
                    $y = 15;
                    $pagina = 1;
    
                    $pdf->SetFont('Arial','B',10);      $enc= "DROMEDICAS DEL ORIENTE SAS - NIT: 900265730-0";      $pdf->Text($x,$y,$enc);
    
                    // Fecha y hora de impresión
                    $fechoraimp = $mesimp." ".date('d')." de ".date('Y g:i a')."    Pagina: ".$pagina;
    
                    // impresión del encabezado
                    $pdf->SetFont('Arial','',8);        $pdf->Text($x+320,$y,$fechoraimp);
                    $pdf->SetFont('Arial','B',10);      $enc= "LIQUIDADOS DEL PERIODO ".$desperiodo;                $pdf->Text($x,$y+7,$enc);
                    $pdf->SetFillColor(220,220,220);    $pdf->Rect(7,$y+28,405,8,'F');
                    $enc= "DOCUMENTO";                  $pdf->Text(9,$y+33,$enc);
                    $enc= "NOMBRE";                     $pdf->Text(34,$y+33,$enc);
                    $enc= "DIAS";                       $pdf->Text(90,$y+33,$enc);
                    $enc= "BASICO";                     $pdf->Text(101,$y+33,$enc);
                    $enc= "SALARIO";                    $pdf->Text(116,$y+33,$enc);
                    $enc= "TRANS";                      $pdf->Text(134,$y+33,$enc);
                    $enc= "PENSION";                    $pdf->Text(149,$y+33,$enc);
                    $enc= "SALUD";                      $pdf->Text(168,$y+33,$enc);
                    $enc= "DIAS V.";                    $pdf->Text(183,$y+33,$enc);
                    $enc= "VACACION";                   $pdf->Text(197,$y+33,$enc);
                    $enc= "DIAS P.";                    $pdf->Text(217,$y+33,$enc);
                    $enc= "PRIMA";                      $pdf->Text(234,$y+33,$enc);
                    $enc= "CESANTIAS";                  $pdf->Text(248,$y+33,$enc);
                    $enc= "INTERESES";                  $pdf->Text(272,$y+33,$enc);
                    $enc= "INDEMN";                     $pdf->Text(294,$y+33,$enc);
                    $enc= "DEVGDS";                     $pdf->Text(313,$y+33,$enc);
                    $enc= "DESCTS";                     $pdf->Text(333,$y+33,$enc);
                    $enc= "T. DEVGS";                   $pdf->Text(352,$y+33,$enc);
                    $enc= "T. DESCT";                   $pdf->Text(373,$y+33,$enc);
                    $enc= "NETO";                       $pdf->Text(400,$y+33,$enc);
                    $pdf->SetFont('Arial','',8);
                    
                    // inicialización de variables
                    $x = 9;
                    $y = 56;
                    $totaldevengado = 0;
                    $totaldescuento = 0;
                    $netoapagar = 0;
    
                    $conex = $clase->Conectar();
                    $result = mysql_query($vsql,$conex);
                    while($row = mysql_fetch_array($result))
                    {
                        $i++;
    
                        // Impresión de documento y nombre
                        $pdf->Text($x,$y,$row['dni']);
                        $pdf->Text($x+25,$y,substr($row['nombre'],0,30));
    
                        // Días trabajados
                        $longitud = strlen($row['diastrab']);
                        if($longitud==1)        $pdf->Text($x+88,$y,number_format($row['diastrab']));
                        if($longitud==2)        $pdf->Text($x+86,$y,number_format($row['diastrab']));
    
                        // Sueldo básico
                        $longitud = strlen($row['basico']);
                        if($longitud==7)        $pdf->Text($x+93,$y,number_format($row['basico']));
                        if($longitud==6)        $pdf->Text($x+96,$y,number_format($row['basico']));
    
                        // sueldo devengado
                        $sueldo = $row['sueldo'];
    
                        if($sueldo==NULL)
                            $sueldo = 0;
    
                        $longitud = strlen($sueldo);
    
                        if($longitud==7)        $pdf->Text($x+109,$y,number_format($sueldo));
                        if($longitud==6)        $pdf->Text($x+112,$y,number_format($sueldo));
                        if($longitud==5)        $pdf->Text($x+114,$y,number_format($sueldo));
                        if($longitud==4)        $pdf->Text($x+118,$y,number_format($sueldo));
                        if($longitud==3)        $pdf->Text($x+121,$y,number_format($sueldo));
                        if($longitud==2)        $pdf->Text($x+124,$y,number_format($sueldo));
                        if($longitud==1)        $pdf->Text($x+123,$y,number_format($sueldo));
                        if($longitud==0)        $pdf->Text($x+94,$y,number_format($sueldo));                    
    
                        // Subsidio de subsidiotransporte
                        $subsidiotransporte = $row['subsidiotransporte'];
                        $longitud = strlen($subsidiotransporte);
    
                        if($longitud==5)        $pdf->Text($x+128,$y,number_format($subsidiotransporte));
                        if($longitud==4)        $pdf->Text($x+130,$y,number_format($subsidiotransporte));
                        if($longitud==3)        $pdf->Text($x+132,$y,number_format($subsidiotransporte));
                        if($longitud==2)        $pdf->Text($x+134,$y,number_format($subsidiotransporte));
                        if($longitud==1)        $pdf->Text($x+137,$y,number_format($subsidiotransporte));
    
                        // Pensión
                        $pension = $row['pension'];
                        $longitud = strlen($pension);
    
                        if($longitud==5)        $pdf->Text($x+147,$y,number_format($pension));
                        if($longitud==4)        $pdf->Text($x+149,$y,number_format($pension));
                        if($longitud==3)        $pdf->Text($x+151,$y,number_format($pension));
                        if($longitud==2)        $pdf->Text($x+153,$y,number_format($pension));
                        if($longitud==1)        $pdf->Text($x+155,$y,number_format($pension));                    
    
                        // Salud
                        $salud = $row['salud'];
                        $longitud = strlen($salud);
    
                        if($longitud==5)        $pdf->Text($x+162,$y,number_format($salud));
                        if($longitud==4)        $pdf->Text($x+164,$y,number_format($salud));
                        if($longitud==3)        $pdf->Text($x+166,$y,number_format($salud));
                        if($longitud==2)        $pdf->Text($x+168,$y,number_format($salud));
                        if($longitud==1)        $pdf->Text($x+170,$y,number_format($salud));
    
                        // Días de vacaciones
                        $diasvaca = $row['diasvaca'];
                        $longitud = strlen($diasvaca);
    
                        if($longitud==3)        $pdf->Text($x+180,$y,number_format($diasvaca));
                        if($longitud==2)        $pdf->Text($x+182,$y,number_format($diasvaca));
                        if($longitud==1)        $pdf->Text($x+184,$y,number_format($diasvaca));                    
    
                        // Pago de vacaciones
                        $pagovaca = $row['pagovaca'];
                        $longitud = strlen(intval($pagovaca));
    
                        if($longitud==9)        $pdf->Text($x+196,$y,number_format($pagovaca));
                        if($longitud==8)        $pdf->Text($x+196,$y,number_format($pagovaca));
                        if($longitud==7)        $pdf->Text($x+196,$y,number_format($pagovaca));
                        if($longitud==6)        $pdf->Text($x+196,$y,number_format($pagovaca));
                        if($longitud==5)        $pdf->Text($x+199,$y,number_format($pagovaca));
                        if($longitud==4)        $pdf->Text($x+201,$y,number_format($pagovaca));
                        if($longitud==3)        $pdf->Text($x+202,$y,number_format($pagovaca));
                        if($longitud==2)        $pdf->Text($x+206,$y,number_format($pagovaca));
                        if($longitud==1)        $pdf->Text($x+207,$y,number_format($pagovaca));
    
                        // Días de prima
                        $diasprima = $row['diasprima'];
                        if($diasprima==NULL)        $diasprima=0;
                        $longitud = strlen($diasprima);
    
                        if($longitud==3)        $pdf->Text($x+214,$y,number_format($diasprima));
                        if($longitud==2)        $pdf->Text($x+216,$y,number_format($diasprima));
                        if($longitud==1)        $pdf->Text($x+218,$y,number_format($diasprima));
    
                        // Pago de la prima
                        $pagoprimas = $row['pagoprima'];
                        $longitud = strlen(intval($pagoprimas));
    
                        if($longitud==9)        $pdf->Text($x+226,$y,number_format($pagoprimas));
                        if($longitud==8)        $pdf->Text($x+226,$y,number_format($pagoprimas));
                        if($longitud==7)        $pdf->Text($x+226,$y,number_format($pagoprimas));
                        if($longitud==6)        $pdf->Text($x+226,$y,number_format($pagoprimas));
                        if($longitud==5)        $pdf->Text($x+228,$y,number_format($pagoprimas));
                        if($longitud==4)        $pdf->Text($x+230,$y,number_format($pagoprimas));
                        if($longitud==3)        $pdf->Text($x+232,$y,number_format($pagoprimas));
                        if($longitud==2)        $pdf->Text($x+234,$y,number_format($pagoprimas));
                        if($longitud==1)        $pdf->Text($x+236,$y,number_format($pagoprimas));
    
                        // Pago de cesantías
                        $pagocedesantias = $row['pagocedesantias'];
                        $longitud = strlen(intval($pagocedesantias));
    
                        if($longitud==9)        $pdf->Text($x+249,$y,number_format($pagocedesantias));
                        if($longitud==7)        $pdf->Text($x+246,$y,number_format($pagocedesantias));
                        if($longitud==6)        $pdf->Text($x+249,$y,number_format($pagocedesantias));
                        if($longitud==5)        $pdf->Text($x+251,$y,number_format($pagocedesantias));
                        if($longitud==4)        $pdf->Text($x+254,$y,number_format($pagocedesantias));
                        if($longitud==3)        $pdf->Text($x+256,$y,number_format($pagocedesantias));
                        if($longitud==2)        $pdf->Text($x+258,$y,number_format($pagocedesantias));
                        if($longitud==1)        $pdf->Text($x+260,$y,number_format($pagocedesantias));
    
                        // Intereses de las cesantías
                        $pagointereses = $row['pagointereses'];
                        $longitud = strlen(intval($pagointereses));
    
                        if($longitud==6)        $pdf->Text($x+272,$y,number_format($pagointereses));
                        if($longitud==5)        $pdf->Text($x+274,$y,number_format($pagointereses));
                        if($longitud==4)        $pdf->Text($x+276,$y,number_format($pagointereses));
                        if($longitud==3)        $pdf->Text($x+278,$y,number_format($pagointereses));
                        if($longitud==2)        $pdf->Text($x+280,$y,number_format($pagointereses));
                        if($longitud==1)        $pdf->Text($x+282,$y,number_format($pagointereses));
    
                        // Indemnización
                        $indemnizacion = $row['indemnizacion'];
                        $longitud = strlen($indemnizacion);
    
                        if($indemnizacion==NULL)
                            $indemnizacion=0;
    
                        if($longitud==6)
                            $pdf->Text($x+297,$y,number_format($indemnizacion));
    
                        if($longitud==5)
                            $pdf->Text($x+288,$y,number_format($indemnizacion));
    
                        if($longitud==4)
                            $pdf->Text($x+290,$y,number_format($indemnizacion));
    
                        if($longitud==3)
                            $pdf->Text($x+292,$y,number_format($indemnizacion));
    
                        if($longitud==2)
                            $pdf->Text($x+294,$y,number_format($indemnizacion));
    
                        if($longitud==1)
                            $pdf->Text($x+286,$y,number_format($indemnizacion));
    
                        // Otros devengados
                        $otrosdevengados = $row['otrosdevengados'];
                        $longitud = strlen($otrosdevengados);
    
                        $pdf->Text($x+309,$y,number_format($otrosdevengados));
    
                        // Otros descuentos
                        $otrosdescuentos = $row['otrosdescuentos'];
                        $longitud = strlen(intval($otrosdescuentos));
    
                        if($longitud==6)        $pdf->Text($x+328,$y,number_format($otrosdescuentos));
                        if($longitud==5)        $pdf->Text($x+330,$y,number_format($otrosdescuentos));
                        if($longitud==4)        $pdf->Text($x+332,$y,number_format($otrosdescuentos));
                        if($longitud==3)        $pdf->Text($x+334,$y,number_format($otrosdescuentos));
                        if($longitud==2)        $pdf->Text($x+336,$y,number_format($otrosdescuentos));
                        if($longitud==1)        $pdf->Text($x+336,$y,number_format($otrosdescuentos));
    
                        // // cálculo de los totales
                        // $totaldevengado = $salario + $transporte + $pagovaca + $pagoprimas + $pagocesantia + $pagointereses + $indemnizacion + $otrosdev;
                        // $totaldescuento = $pension + $salud + $otrosdesc;
                        // $netoapagar = $totaldevengado - $totaldescuento;
    
                        // total devengados
                        $totaldevengado = $row['totaldevengado'];
                        $longitud = strlen(intval($totaldevengado));
    
                        if($longitud==7)        $pdf->Text($x+347,$y,number_format($totaldevengado));
                        if($longitud==6)        $pdf->Text($x+349,$y,number_format($totaldevengado));
                        if($longitud==5)        $pdf->Text($x+351,$y,number_format($totaldevengado));
                        if($longitud==4)        $pdf->Text($x+353,$y,number_format($totaldevengado));
                        if($longitud==3)        $pdf->Text($x+355,$y,number_format($totaldevengado));
                        if($longitud==2)        $pdf->Text($x+357,$y,number_format($totaldevengado));
                        if($longitud==1)        $pdf->Text($x+359,$y,number_format($totaldevengado));
    
                        // total descuentos
                        $totaldescuento = $row['totaldescuento'];
                        $longitud = strlen($totaldescuento);
    
                        if($longitud==6)        $pdf->Text($x+369,$y,number_format($totaldescuento));
                        if($longitud==5)        $pdf->Text($x+371,$y,number_format($totaldescuento));
                        if($longitud==4)        $pdf->Text($x+373,$y,number_format($totaldescuento));
                        if($longitud==3)        $pdf->Text($x+375,$y,number_format($totaldescuento));
                        if($longitud==2)        $pdf->Text($x+377,$y,number_format($totaldescuento));
                        if($longitud==1)        $pdf->Text($x+379,$y,number_format($totaldescuento));
    
                        // neto a pagar
                        $netoapagar = $row['netoapagar'];
                        $longitud = strlen(intval($netoapagar));
    
                        if($longitud==15)       $pdf->Text($x+371,$y,number_format($netoapagar));
                        if($longitud==14)       $pdf->Text($x+373,$y,number_format($netoapagar));
                        if($longitud==13)       $pdf->Text($x+375,$y,number_format($netoapagar));
                        if($longitud==12)       $pdf->Text($x+377,$y,number_format($netoapagar));
                        if($longitud==11)       $pdf->Text($x+379,$y,number_format($netoapagar));
                        if($longitud==10)       $pdf->Text($x+383,$y,number_format($netoapagar));
                        if($longitud==9)        $pdf->Text($x+383,$y,number_format($netoapagar));
                        if($longitud==8)        $pdf->Text($x+385,$y,number_format($netoapagar));
                        if($longitud==7)        $pdf->Text($x+388,$y,number_format($netoapagar));
                        if($longitud==6)        $pdf->Text($x+391,$y,number_format($netoapagar));
                        if($longitud==5)        $pdf->Text($x+391,$y,number_format($netoapagar));
                        if($longitud==4)        $pdf->Text($x+393,$y,number_format($netoapagar));
                        if($longitud==3)        $pdf->Text($x+395,$y,number_format($netoapagar));
                        if($longitud==2)        $pdf->Text($x+397,$y,number_format($netoapagar));
                        if($longitud==1)        $pdf->Text($x+399,$y,number_format($netoapagar));
                        // ------------------------------------------------------------------- //
                        $y+=6;
    
                        if($i%36 == 0)
                        {
                            $pdf->AddPage("");
    
                            // Logo Dromedicas
                            $pdf->Image('images/empresa/logo-dromedicas-en-azul.png',10,10,20,25,'PNG','');
    
                            $x = 35;
                            $y = 15;
                            $pagina++;
    
                            $pdf->SetFont('Arial','B',10);      $enc= "DROMEDICAS DEL ORIENTE SAS - NIT: 900265730-0";      $pdf->Text($x,$y,$enc);
            
                            // Fecha y hora de impresión
                            $fechoraimp = $mesimp." ".date('d')." de ".date('Y g:i a')."    Pagina: ".$pagina;
    
                            $pdf->SetFont('Arial','',8);        $pdf->Text($x+320,$y,$fechoraimp);
                            $pdf->SetFont('Arial','B',10);      $enc= "LIQUIDADOS DEL PERIODO ".$desperiodo;                $pdf->Text($x,$y+7,$enc);
                            $pdf->SetFillColor(220,220,220);    $pdf->Rect(7,$y+28,405,8,'F');
                            $enc= "DOCUMENTO";                  $pdf->Text(9,$y+33,$enc);
                            $enc= "NOMBRE";                     $pdf->Text(34,$y+33,$enc);
                            $enc= "DIAS";                       $pdf->Text(90,$y+33,$enc);
                            $enc= "BASICO";                     $pdf->Text(101,$y+33,$enc);
                            $enc= "SALARIO";                    $pdf->Text(116,$y+33,$enc);
                            $enc= "TRANS";                      $pdf->Text(134,$y+33,$enc);
                            $enc= "PENSION";                    $pdf->Text(149,$y+33,$enc);
                            $enc= "SALUD";                      $pdf->Text(168,$y+33,$enc);
                            $enc= "DIAS V.";                    $pdf->Text(183,$y+33,$enc);
                            $enc= "VACACION";                   $pdf->Text(197,$y+33,$enc);
                            $enc= "DIAS P.";                    $pdf->Text(217,$y+33,$enc);
                            $enc= "PRIMA";                      $pdf->Text(234,$y+33,$enc);
                            $enc= "CESANTIAS";                  $pdf->Text(248,$y+33,$enc);
                            $enc= "INTERESES";                  $pdf->Text(272,$y+33,$enc);
                            $enc= "INDEMN";                     $pdf->Text(294,$y+33,$enc);
                            $enc= "DEVGDS";                     $pdf->Text(313,$y+33,$enc);
                            $enc= "DESCTS";                     $pdf->Text(333,$y+33,$enc);
                            $enc= "T. DEVGS";                   $pdf->Text(352,$y+33,$enc);
                            $enc= "T. DESCT";                   $pdf->Text(373,$y+33,$enc);
                            $enc= "NETO";                       $pdf->Text(400,$y+33,$enc);
                            $pdf->SetFont('Arial','',8);
    
                            $x = 9;
                            $y = 56;
                        }                        
                    }
                    $pdf->Output();
                }

                // salida a excel
                if($tiposalida=="excel")
                {
                    require_once 'lib/PHPExcel.php';
                    $clase = new Sistema();
                    $clase->Conectar();
                    ini_set("memory_limit","100M");
    
                    // Preparación del entorno para la salida a Excel
                    $clase = new Sistema();
                    $clase->Nombredb = $_SESSION['DBNOMBRE'];
                    error_reporting(E_ALL);
                    ini_set('display_errors', TRUE);
                    ini_set('display_startup_errors', TRUE);
                    date_default_timezone_set('Europe/London');
                
                    if (PHP_SAPI == 'cli')
                        die('This example should only be run from a Web Browser');
                
                    // Create new PHPExcel object
                    $objPHPExcel = new PHPExcel();
                
                    // Set document properties
                    $objPHPExcel->getProperties()->setCreator("Sistemas y Soluciones Web de Colombia")
                                                 ->setLastModifiedBy("Sistemas y Soluciones Web de Colombia")
                                                 ->setTitle("Liquidados por periodo - DROPOS")
                                                 ->setSubject("Liquidados por periodo - DROPOS")
                                                 ->setDescription("Liquidados por periodo - DROPOS")
                                                 ->setKeywords("Liquidados por periodo - DROPOS")
                                                 ->setCategory("Categoria General");
    
                    // encabezado
                    $objPHPExcel->setActiveSheetIndex(0)
                                ->setCellValue('A1', 'LIQUIDADOS POR PERIODO')
                                ->setCellValue('A2', $desperiodo) 
                                ->setCellValue('A4', 'CODIGO')
                                ->setCellValue('B4', 'DOCUMENTO')
                                ->setCellValue('C4', 'NOMBRE')
                                ->setCellValue('D4', 'DIAS TRAB.')
                                ->setCellValue('E4', 'BASICO')
                                ->setCellValue('F4', 'SALARIO')
                                ->setCellValue('G4', 'TRANSPORTE')
                                ->setCellValue('H4', 'PENSION')
                                ->setCellValue('I4', 'SALUD')
                                ->setCellValue('J4', 'DIAS VACA.')
                                ->setCellValue('K4', 'PAGO VACA.')
                                ->setCellValue('L4', 'DIAS PRIMA')
                                ->setCellValue('M4', 'PAGO PRIMA')
                                ->setCellValue('N4', 'PAGO CESAN.')
                                ->setCellValue('O4', 'PAGO INTERS.')
                                ->setCellValue('P4', 'INDEMNIZACION')
                                ->setCellValue('Q4', 'OTROS DEVGS.')
                                ->setCellValue('R4', 'OTROS DESC.')
                                ->setCellValue('S4', 'TOTAL DEVENG.')
                                ->setCellValue('T4', 'TOTAL DESCTS.')
                                ->setCellValue('U4', 'NETO A PAGAR');                    
    
                    $objPHPExcel->getActiveSheet()->getColumnDimension('A')->setAutoSize(true);         $objPHPExcel->getActiveSheet()->getColumnDimension('B')->setAutoSize(true);
                    $objPHPExcel->getActiveSheet()->getColumnDimension('C')->setAutoSize(true);         $objPHPExcel->getActiveSheet()->getColumnDimension('D')->setAutoSize(true);
                    $objPHPExcel->getActiveSheet()->getColumnDimension('E')->setAutoSize(true);         $objPHPExcel->getActiveSheet()->getColumnDimension('F')->setAutoSize(true);
                    $objPHPExcel->getActiveSheet()->getColumnDimension('G')->setAutoSize(true);         $objPHPExcel->getActiveSheet()->getColumnDimension('H')->setAutoSize(true);
                    $objPHPExcel->getActiveSheet()->getColumnDimension('I')->setAutoSize(true);         $objPHPExcel->getActiveSheet()->getColumnDimension('J')->setAutoSize(true);
                    $objPHPExcel->getActiveSheet()->getColumnDimension('K')->setAutoSize(true);         $objPHPExcel->getActiveSheet()->getColumnDimension('L')->setAutoSize(true);
                    $objPHPExcel->getActiveSheet()->getColumnDimension('M')->setAutoSize(true);         $objPHPExcel->getActiveSheet()->getColumnDimension('N')->setAutoSize(true);
                    $objPHPExcel->getActiveSheet()->getColumnDimension('O')->setAutoSize(true);         $objPHPExcel->getActiveSheet()->getColumnDimension('P')->setAutoSize(true);
                    $objPHPExcel->getActiveSheet()->getColumnDimension('Q')->setAutoSize(true);         $objPHPExcel->getActiveSheet()->getColumnDimension('R')->setAutoSize(true);
                    $objPHPExcel->getActiveSheet()->getColumnDimension('S')->setAutoSize(true);         $objPHPExcel->getActiveSheet()->getColumnDimension('T')->setAutoSize(true);
                    $objPHPExcel->getActiveSheet()->getColumnDimension('U')->setAutoSize(true);

                    // Inmovilizar paneles
                    $objPHPExcel->getActiveSheet(0)->freezePaneByColumnAndRow(0,5);
    
                    $conex  = $clase->Conectar();
                    $result = mysql_query($vsql,$conex);
                    $cant   = mysql_num_rows($result);
                    $i = 5;

                    // Detalle del informe
                    while($row = mysql_fetch_array($result))
                    {
                        // formato del código de vendedor
                        $codvende = $row['codvende'];
                        if(substr($codvende,0,1) == "0")
                            $codvende = "'".$codvende;
                        
                        $objPHPExcel->setActiveSheetIndex(0)
                                    ->setCellValue('A'.$i, $codvende)
                                    ->setCellValue('B'.$i, $row['dni'])
                                    ->setCellValue('C'.$i, $row['nombre'])
                                    ->setCellValue('D'.$i, number_format($row['diastrab']))
                                    ->setCellValue('E'.$i, number_format($row['basico']))
                                    ->setCellValue('F'.$i, number_format($row['sueldo']))
                                    ->setCellValue('G'.$i, number_format($row['subsidiotransporte']))
                                    ->setCellValue('H'.$i, number_format($row['pension']))
                                    ->setCellValue('I'.$i, number_format($row['salud']))
                                    ->setCellValue('J'.$i, number_format($row['diasvaca']))
                                    ->setCellValue('K'.$i, number_format($row['pagovaca']))
                                    ->setCellValue('L'.$i, number_format($row['diasprima']))
                                    ->setCellValue('M'.$i, number_format($row['pagoprima']))
                                    ->setCellValue('N'.$i, number_format($row['pagocedesantias']))
                                    ->setCellValue('O'.$i, number_format($row['pagointereses']))
                                    ->setCellValue('P'.$i, number_format($row['indemnizacion']))
                                    ->setCellValue('Q'.$i, number_format($row['otrosdevengados']))
                                    ->setCellValue('R'.$i, number_format($row['otrosdescuentos']))
                                    ->setCellValue('S'.$i, number_format($row['totaldevengado']))
                                    ->setCellValue('T'.$i, number_format($row['totaldescuento']))
                                    ->setCellValue('U'.$i, number_format($row['netoapagar']));
                        $i++;
                    }
    
                    $rangoEncabezado = 'A4:U4';
                    $rangoCeldas     = 'A4:U'.($i-1);
                    // ----------------------------------------------------------------------------------------------------------------------------------------------------------- //
                    
                    // Formato de Encabezado y Celdas
                    $objPHPExcel->getActiveSheet()->getRowDimension('1')->setRowHeight(15);
                    
                    $EstiloCeldas = array(
                    'borders' => array(
                        'allborders' => array(
                            'style' => PHPExcel_Style_Border::BORDER_THIN,
                            'color' => array('argb' => '00000000'),
                        ),
                        ),
                    );
                    $objPHPExcel->getActiveSheet()->getStyle($rangoCeldas)->applyFromArray($EstiloCeldas);
                    /// Formato de Encabezados 
                    $EstiloEncabezado = array(
                    'font' => array(
                        'bold' => true,
                    ),
                    'alignment' => array(
                        'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,
                        'vertical' => PHPExcel_Style_Alignment::VERTICAL_CENTER,		
                    ),
                    'borders' => array(
                        'allborders' => array(
                            'style' => PHPExcel_Style_Border::BORDER_THIN,
                            'color' => array('argb' => '00000000'),
                        ),
                    ),
                    'fill' => array(
                        'type' => PHPExcel_Style_Fill::FILL_SOLID,
                        'rotation' => 90,
                        'startcolor' => array(
                            'argb' => '00FFFFCC',
                        ),
                        'endcolor' => array(
                            'argb' => 'FFFFFF',
                        ),
                        ),
                    );
                    $objPHPExcel->getActiveSheet()->getStyle($rangoEncabezado)->applyFromArray($EstiloEncabezado);
                    // Rename worksheet
                    $objPHPExcel->getActiveSheet()->setTitle('liquidados');
                    // Set active sheet index to the first sheet, so Excel opens this as the first sheet
                    $objPHPExcel->setActiveSheetIndex(0);
                    // Redirect output to a client’s web browser (Excel5)
                    header('Content-Type: application/vnd.ms-excel');
                    // --------------------------------------------------------------------- //                
                    $nombrearcexcel = "liquidados del periodo ".strtolower($desperiodo).".xls";
                    header('Content-Disposition: attachment;filename='.$nombrearcexcel.'');
                    // --------------------------------------------------------------------- //
                    header('Cache-Control: max-age=0');
                    /// Genero la Salida
                    $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');
                    $objWriter->save('php://output');
                    exit;
                }
            }
        }
    }
?>