<?PHP
    @session_start(); 
    include("lib/Sistema.php");  
  
    $clase = new Sistema();
    $clase->Nombredb = $_SESSION['DBNOMBRE'];  
    $avisos = ""; 
    $opcion = "";
    $opcion = $_GET["opcion"];

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: ""
    // Creación: 14/05/2024		última modificación: 21/10/2024
    // Creador: Luis Flórez		modificado por: Luis Flórez
    // Descripción: Ventana principal que muestra todas las liquidaciones del periodo en 
    //              curso con las principales opciones
    // Última modificación: Adaptación para usar la nueva tabla de informes (05/09/2024)
    //                      Enlace para la ventana en la cual se seleccionará el empleado 
    //                      para incluir liquidación 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "")
    {
        // Validación del perfil de nómina
        $vsql = "SELECT COUNT(*) AS valnomina 
                   FROM usuariosxgrupos 
                  WHERE nomusuario = '".$_SESSION['USERNAME']."' 
                        AND (nomgrupo LIKE '%NOMINA%' OR nomgrupo LIKE '%PERFILNOMINA%')";
        $valnomina = $clase->SeleccionarUno($vsql);
        
        // validación para el acceso al formulario
        if(($valnomina == 0))
        {
            $clase->Aviso(2,"No tiene permiso para acceder a este formulario");
            header("Location: principal.php");
        }
        else
        {
            // determino el periodp actual
            $vsql = "SELECT periodoid
                       FROM periodosnomina 
                      WHERE periodoid = (SELECT MAX(periodoid) FROM periodosnomina WHERE calculado ='CHECKED')";
            $periodoid = $clase->SeleccionarUno($vsql);

            $fecdesde = $clase->BDLockup($periodoid,'periodosnomina','periodoid','fecdesde');
            $codperiodo = substr($fecdesde,5,2).substr($fecdesde,0,4);

            // nombre del periodo
            $desperiodo = $clase->BDLockup($codperiodo,'periodos','codperiodo','desperiodo');

            // Validación de los botones de limpiar las liquidaciones y descargar
            $vsql32 = "SELECT COUNT(*) numliquidaciones FROM tmpinfliquidados WHERE codperiodo = '".$codperiodo."'";
            $numliquidaciones = $clase->SeleccionarUno($vsql32);

            if($numliquidaciones > 0)
            {
                $htmllimpiar = '<a href="?opcion=confirmarlimpiarliq&codperiodo='.$codperiodo.'" rel="facebox">
                                 <img src="images/iconos/anulardoc.png" border="0" width="38" height="38" title="limpiar todas las liquidaciones">
                                </a>';
                $htmldescargar = '<a href="?opcion=descargarlistado&codperiodo='.$codperiodo.'&listaperiodos='.$listaperiodos.'" target="_blank">
                                   <img src="images/iconos/descargar.png" border="0" width="38" height="38" title="descargar el informe de liquidaciones">
                                  </a>';
            }
            else
            {
                $htmllimpiar = '<img src="images/iconos/anulardoc.png" border="0" width="38" height="38" title="no existen liquidaciones para eliminar">';
                $htmldescargar = '<img src="images/iconos/descargar.png" border="0" width="38" height="38" title="descargar el informe de liquidaciones">';
            }

            // --------------------------------------------------------------------------------------------------------------------------------------------------------- //
            if(($_SESSION['USERNAME'] == "LFLOREZ") || ($_SESSION["SUPERUSUARIO"] == "CHECKED"))
            {
                $botoncorreciones = '<a href="?opcion=ventanacorrecionnew&codperiodo='.$codperiodo.'" rel="facebox">
                                      <img src="images/iconos/reconciliar.png" width="34" height="34" border="0" title="corregir liquidados '.$desperiodo.'">
                                     </a>';
                $botonactualizarliq = '<a href="?opcion=confirmaractliq&codperiodo='.$codperiodo.'" rel="facebox">
                                        <img src="images/iconos/asistente.png" width="34" height="34" border="0" title="importar liquidaciones faltantes">
                                       </a>';

                $botonsincronizarliq = '<a href="?opcion=sincronizarliq&codperiodo='.$codperiodo.'" target="_blank">
                                         <img src="images/iconos/transferencia.png" width="34" height="34" border="0" title="sincronizar liquidaciones">
                                        </a>';
            }
            else 
            {
                $botoncorreciones = '';
                $botonactualizarliq = '';
                $botonsincronizarliq = '';
            }
            // --------------------------------------------------------------------------------------------------------------------------------------------------------- //
            // $botoncorreciones = '<a href="?opcion=ventanacorrecionnew&codperiodo='.$codperiodo.'" rel="facebox">
            //                       <img src="images/iconos/reconciliar.png" width="34" height="34" border="0" title="corregir liquidados '.$desperiodo.'">
            //                      </a>';

            // $botonactualizarliq = '<a href="?opcion=confirmaractliq&codperiodo='.$codperiodo.'" rel="facebox">
            //                         <img src="images/iconos/asistente.png" width="34" height="34" border="0" title="importar liquidaciones faltantes">
            //                        </a>';
            // --------------------------------------------------------------------------------------------------------------------------------------------------------- //

            // pinto la ventana
            $enc = $clase->HeaderBlancoFull("liquidados ".strtolower($desperiodo));

            // encabezado
            $enc.= '<script src="lib/jquery-2.1.3.js"></script>
                    <script src="lib/tableHeadFixer.js"></script>	
                    <script>
                     $(document).ready(function() {
                      $("#fixTableV").tableHeadFixer({"left" : 3}); 
                     });
                    </script>
                     <link rel="stylesheet" href="http://code.jquery.com/ui/1.9.2/themes/base/jquery-ui.css"> 
                     <script src="http://code.jquery.com/jquery-1.8.3.js"></script>
                     <script src="http://code.jquery.com/ui/1.9.2/jquery-ui.js"></script>
                     <script src="https://cdnjs.cloudflare.com/ajax/libs/chosen/1.4.2/chosen.jquery.js"></script>
                     <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/chosen/1.4.2/chosen.css">
                    <script type="text/javascript">
                     $(function() {
                      $(".chzn-select").chosen();
                     });
                    </script>
                    <script src="lib/tableHeadFixer.js"></script>	
                    <script>
                     $(document).ready(function() {
                      $("#fixTableV").tableHeadFixer({"left" : 2}); 
                     });
                    </script>
                    <table width="100%">
                     <tr class="CabezoteTabla"> 
                      <td width="5"> &nbsp; </td>
                      <td width="10"> <img src="images/iconos/cajas.png" width="32" height="32" border="0"> </td>
                      <td width="260" align="left"> <font color="#000a7b"> <b> Liquidaciones '.$desperiodo.' </b> </font> </td>
                      <td width="880" align="left"> &nbsp; </td>
                      <td width="30"> '.$botoncorreciones.' </td>
                      <td width="10"> &nbsp; </td>
                      <td width="30"> '.$botonactualizarliq.' </td>
                      <td width="10"> &nbsp; </td>
                      <td width="30"> '.$botonsincronizarliq.' </td>
                      <td width="10"> &nbsp; </td>
                      <td width="30"> 
                       <a href="?opcion=seleccionarempleado&codperiodo='.$codperiodo.'" rel="facebox">
                        <img src="images/iconos/nuevodoc.png" width="32" height="32" border="0" title="incluir una nueva liquidaci&oacute;n"> 
                       </a>
                      </td>
                      <td width="10"> &nbsp; </td>
                      <td width="30"> 
                       <a href="?opcion=subirliquidados&codperiodo='.$codperiodo.'" rel="facebox">
                        <img src="images/iconos/cargar.png" width="34" height="34" border="0" title="importar liquidados '.$desperiodo.'">
                       </a>
                      </td>
                      <td width="10"> &nbsp; </td>
                      <td width="30"> '.$htmllimpiar.' </td>
                      <td width="10"> &nbsp; </td>
                      <td width="30"> '.$htmldescargar.' </td>
                      <td width="10"> &nbsp; </td>
                      <td width="30"> <a href="liquidados.php" title="refrescar la ventana"> <img src="images/iconos/refrescar.png" width="34" height="34" border="0"> </a> </td>
                      <td width="10"> &nbsp; </td>
                      <td width="50" align="center"> <a href="principal.php"> <input type="button" value="<<" class="button blue"> </a> </td> 
                      <td width="8"> &nbsp; </td>
                     </tr>
                    </table>';

            // títulos
            $enc.= '<script type="text/javascript" src="lib/sorttable.js"></script>
                    <div id="parent">
                    <table id="fixTableV" class="sortable">
                     <thead>
                      <tr class=""> 		 
                       <th class="ventasGeneral"> Documento </th>
                       <th class="ventasGeneral"> C&oacute;digo </th>
                       <th class="ventasGeneral" data-title="Sum"> Nombre </th>
                       <th class="clientes" align="right"> Ingreso </th>
                       <th class="clientes" align="right"> Retiro </th>
                       <th class="boniGeneral" align="right"> B&aacute;sico </th>
                       <th class="boniGeneral" data-title="d&iacute;as trabajados en la quincena"> D&iacute;as trab. </th>
                       <th class="boniGeneral" align="right"> Salario </th>
                       <th class="boniGeneral" align="right"> Transporte </th>
                       <th class="boniGeneral" align="right"> Salud </th>            
                       <th class="boniGeneral" align="right"> Pensi&oacute;n </th>
                       <th class="clientes"> D&iacute;as vaca. </th>
                       <th class="clientes"> Pago vaca. </th>
                       <th class="clientes" align="right"> D&iacute;as prima </th>                       
                       <th class="clientes" align="right"> Pago prima </th>
                       <th class="clientes" align="right"> D&iacute;as cesan. </th>
                       <th class="clientes" align="right"> Pago cesan. </th>
                       <th class="clientes" align="right"> Pago inters. </th>
                       <th class="clientes" align="right"> Indemnizaci&oacute;n </th>
                       <th class="clientes" align="right"> Otros devgs. </th>
                       <th class="clientes" align="right"> Otros desc. </th>
                       <th class="ventasGeneral" align="right"> Total deveng. </th>
                       <th class="ventasGeneral" align="right"> Total descts. </th>
                       <th class="ventasGeneral" align="right"> Neto a pagar </th>
                       <th class="ventasGeneral" align="right"> &nbsp; </th>
                       <th class="ventasGeneral" align="right"> &nbsp; </th>
                      </tr>
                     </thead>
                     <tbody>';

            // consulta para la vista
            $vsql = "SELECT * FROM tmpinfliquidados WHERE codperiodo = '".$codperiodo."' ORDER BY codvende";

            // impresión del detalle
            $i = 0;
            $det = '';
            $conex  = $clase->Conectar();
            $result = @mysql_query($vsql,$conex);
            while($row = @mysql_fetch_array($result))
            {
                if($i%2 == 0)
                    $det.='<tr class="TablaDocsImPar">';
                else
                    $det.='<tr class="TablaDocsPar">';

                // formato de las fechas
                $fecingreso = substr($row['fecingreso'],8,2)."/".substr($row['fecingreso'],5,2)."/".substr($row['fecingreso'],0,4);
                $fecharetiro = substr($row['fecretiro'],8,2)."/".substr($row['fecretiro'],5,2)."/".substr($row['fecretiro'],0,4);

                // impresión de las liquidaciones
                $det.=' <td class="cuotaVenta" align="center"> <b> '.$row['dni'].' </b> </td>
                        <td class="cuotaVenta" align="center"> <b> '.$row['codvende'].' </b> </td>
                        <td class="cuotaVenta" align="center"> <b> <font color="blue"> '.$row['nombre'].' </font> </b> </td>
                        <td style="text-align: center;"> '.$fecingreso.' </td>
                        <td style="text-align: center;"> '.$fecharetiro.' </td>
                        <td style="text-align: right;"> '.number_format($row['basico']).' </td>
                        <td style="text-align: right;"> '.number_format($row['diastrab']).' </td>
                        <td style="text-align: right;"> '.number_format($row['sueldo']).' </td>
                        <td style="text-align: right;"> '.number_format($row['subsidiotransporte']).' </td>
                        <td style="text-align: right;"> '.number_format($row['salud']).' </td>
                        <td style="text-align: right;"> '.number_format($row['pension']).' </td>
                        <td style="text-align: right;"> '.number_format($row['diasvaca']).' </td>
                        <td style="text-align: right;"> '.number_format($row['pagovaca']).' </td>
                        <td style="text-align: right;"> '.number_format($row['diasprima']).' </td>
                        <td style="text-align: right;"> '.number_format($row['pagoprima']).' </td>
                        <td style="text-align: right;"> '.number_format($row['diasdecesantias']).' </td>
                        <td style="text-align: right;"> '.number_format($row['pagocedesantias']).' </td>
                        <td style="text-align: right;"> '.number_format($row['pagointereses']).' </td>
                        <td style="text-align: right;"> '.number_format($row['indemnizacion']).' </td>
                        <td style="text-align: right;"> '.number_format($row['otrosdevengados']).' </td>
                        <td style="text-align: right;"> '.number_format($row['otrosdescuentos']).' </td>
                        <td style="text-align: right;"> <b> '.number_format($row['totaldevengado']).' </b> </td>
                        <td style="text-align: right;"> <b>'.number_format($row['totaldescuento']).' </b> </td>
                        <td style="text-align: right;"> <b> '.number_format($row['netoapagar']).' </b> </td>';

                // determino si la liquidación está cerrada
                $terid = $row['terid'];
                $codperiodo = $row['codperiodo'];

                $vsqldatos = "SELECT norecalcular FROM parametrosliquidacion WHERE terid = ".$terid." AND codperiodo = '".$codperiodo."'";
                $norecalcular = $clase->SeleccionarUno($vsqldatos);

                if($norecalcular == "CHECKED")
                    $det.=' <td style="text-align: right;"> <img src="images/basicas/bloqueado.png" title="liquidaci&oacuten cerrada" border="0" width="20" height="20"> </td>
                            <td style="text-align: right;">
                             <a href="?opcion=editarliquidacion&terid='.$terid.'&codperiodo='.$codperiodo.'" target="_blank"> 
                              <img src="images/basicas/iconobuscar.png" title="editar liquidaci&oacute;n" border="0" width="20" height="20"> 
                             </a>                            
                            </td>
                           </tr>';
                else
                    $det.=' <td style="text-align: right;">
                             <a href="?opcion=confirmarelim&terid='.$row['terid'].'&codperiodo='.$row['codperiodo'].'" rel="facebox">
                              <img src="images/basicas/iconoborrar.png" title="eliminar liquidaci&oacute;n" border="0" width="20" height="20">
                             </a>
                            </td>
                            <td style="text-align: right;">
                             <a href="?opcion=editarliquidacion&terid='.$terid.'&codperiodo='.$codperiodo.'" target="_blank"> 
                              <img src="images/basicas/iconobuscar.png" title="editar liquidaci&oacute;n" border="0" width="20" height="20"> 
                             </a>
                            </td>
                           </tr>';
                $i++;
            }

            $pie = '</tbody></table>';

            $cont = $enc.$det.$pie;
            echo $cont;
            exit;
        }
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: descargarlistado
    // Creación: 16/05/2024		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que genera la hoja de Excel con el informe de liquidaciones del 
    //              periodo en curso
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "descargarlistado")
    {
        $codperiodo = $_GET['codperiodo'];
        $listaperiodos = $_GET['listaperiodos'];

        // Periodos en detalle liquidación
        $desperiodo = $clase->BDLockup($codperiodo,'periodos','codperiodo','desperiodo');

        // Consulta del informe
        $vsql = "SELECT * FROM tmpinfliquidados WHERE codperiodo = '".$codperiodo."' ORDER BY codvende";

        require_once 'lib/PHPExcel.php';
        $clase = new Sistema();
        $clase->Conectar();
        ini_set("memory_limit","100M");

        // Preparación del entorno para la salida a Excel
        $clase = new Sistema();
        $clase->Nombredb = $_SESSION['DBNOMBRE'];
        error_reporting(E_ALL);
        ini_set('display_errors', TRUE);
        ini_set('display_startup_errors', TRUE);
        date_default_timezone_set('Europe/London');
    
        if (PHP_SAPI == 'cli')
            die('This example should only be run from a Web Browser');
    
        // Create new PHPExcel object
        $objPHPExcel = new PHPExcel();
    
        // Set document properties
        $objPHPExcel->getProperties()->setCreator("Sistemas y Soluciones Web de Colombia")
                                     ->setLastModifiedBy("Sistemas y Soluciones Web de Colombia")
                                     ->setTitle("Liquidados por periodo - DROPOS")
                                     ->setSubject("Liquidados por periodo - DROPOS")
                                     ->setDescription("Liquidados por periodo - DROPOS")
                                     ->setKeywords("Liquidados por periodo - DROPOS")
                                     ->setCategory("Categoria General");

        // encabezado
        $objPHPExcel->setActiveSheetIndex(0)
                    ->setCellValue('A1', 'LIQUIDADOS POR PERIODO')
                    ->setCellValue('A2', $desperiodo) 
                    ->setCellValue('A4', 'CODIGO')
                    ->setCellValue('B4', 'DOCUMENTO')
                    ->setCellValue('C4', 'NOMBRE')
                    ->setCellValue('D4', 'DIAS TRAB.')
                    ->setCellValue('E4', 'BASICO')
                    ->setCellValue('F4', 'SALARIO')
                    ->setCellValue('G4', 'TRANSPORTE')
                    ->setCellValue('H4', 'PENSION')
                    ->setCellValue('I4', 'SALUD')
                    ->setCellValue('J4', 'DIAS VACA.')
                    ->setCellValue('K4', 'PAGO VACA.')
                    ->setCellValue('L4', 'DIAS PRIMA')
                    ->setCellValue('M4', 'PAGO PRIMA')
                    ->setCellValue('N4', 'DIAS CESAN.')
                    ->setCellValue('O4', 'PAGO CESAN.')
                    ->setCellValue('P4', 'PAGO INTERS.')
                    ->setCellValue('Q4', 'INDEMNIZACION')
                    ->setCellValue('R4', 'OTROS DEVGS.')
                    ->setCellValue('S4', 'OTROS DESC.')
                    ->setCellValue('T4', 'TOTAL DEVENG.')
                    ->setCellValue('U4', 'TOTAL DESCTS.')
                    ->setCellValue('V4', 'NETO A PAGAR');

        $objPHPExcel->getActiveSheet()->getColumnDimension('A')->setAutoSize(true);         $objPHPExcel->getActiveSheet()->getColumnDimension('B')->setAutoSize(true);
        $objPHPExcel->getActiveSheet()->getColumnDimension('C')->setAutoSize(true);         $objPHPExcel->getActiveSheet()->getColumnDimension('D')->setAutoSize(true);
        $objPHPExcel->getActiveSheet()->getColumnDimension('E')->setAutoSize(true);         $objPHPExcel->getActiveSheet()->getColumnDimension('F')->setAutoSize(true);
        $objPHPExcel->getActiveSheet()->getColumnDimension('G')->setAutoSize(true);         $objPHPExcel->getActiveSheet()->getColumnDimension('H')->setAutoSize(true);
        $objPHPExcel->getActiveSheet()->getColumnDimension('I')->setAutoSize(true);         $objPHPExcel->getActiveSheet()->getColumnDimension('J')->setAutoSize(true);
        $objPHPExcel->getActiveSheet()->getColumnDimension('K')->setAutoSize(true);         $objPHPExcel->getActiveSheet()->getColumnDimension('L')->setAutoSize(true);
        $objPHPExcel->getActiveSheet()->getColumnDimension('M')->setAutoSize(true);         $objPHPExcel->getActiveSheet()->getColumnDimension('N')->setAutoSize(true);
        $objPHPExcel->getActiveSheet()->getColumnDimension('O')->setAutoSize(true);         $objPHPExcel->getActiveSheet()->getColumnDimension('P')->setAutoSize(true);
        $objPHPExcel->getActiveSheet()->getColumnDimension('Q')->setAutoSize(true);         $objPHPExcel->getActiveSheet()->getColumnDimension('R')->setAutoSize(true);
        $objPHPExcel->getActiveSheet()->getColumnDimension('S')->setAutoSize(true);         $objPHPExcel->getActiveSheet()->getColumnDimension('T')->setAutoSize(true);
        $objPHPExcel->getActiveSheet()->getColumnDimension('U')->setAutoSize(true);         $objPHPExcel->getActiveSheet()->getColumnDimension('V')->setAutoSize(true);

        // Inmovilizar paneles
        $objPHPExcel->getActiveSheet(0)->freezePaneByColumnAndRow(0,5);

        $conex  = $clase->Conectar();
        $result = mysql_query($vsql,$conex);
        $cant   = mysql_num_rows($result);
        $i = 5;

        // Detalle del informe
        while($row = mysql_fetch_array($result))
        {
            // formato del código de vendedor
            $codvende = $row['codvende'];
            if(substr($codvende,0,1) == "0")
                $codvende = "'".$codvende;
            
            $objPHPExcel->setActiveSheetIndex(0)
                        ->setCellValue('A'.$i, $codvende)
                        ->setCellValue('B'.$i, $row['dni'])
                        ->setCellValue('C'.$i, $row['nombre'])
                        ->setCellValue('D'.$i, number_format($row['diastrab']))
                        ->setCellValue('E'.$i, number_format($row['basico']))
                        ->setCellValue('F'.$i, number_format($row['sueldo']))
                        ->setCellValue('G'.$i, number_format($row['subsidiotransporte']))
                        ->setCellValue('H'.$i, number_format($row['pension']))
                        ->setCellValue('I'.$i, number_format($row['salud']))
                        ->setCellValue('J'.$i, number_format($row['diasvaca']))
                        ->setCellValue('K'.$i, number_format($row['pagovaca']))
                        ->setCellValue('L'.$i, number_format($row['diasprima']))
                        ->setCellValue('M'.$i, number_format($row['pagoprima']))
                        ->setCellValue('N'.$i, number_format($row['diasdecesantias']))
                        ->setCellValue('O'.$i, number_format($row['pagocedesantias']))
                        ->setCellValue('P'.$i, number_format($row['pagointereses']))
                        ->setCellValue('Q'.$i, number_format($row['indemnizacion']))
                        ->setCellValue('R'.$i, number_format($row['otrosdevengados']))
                        ->setCellValue('S'.$i, number_format($row['otrosdescuentos']))
                        ->setCellValue('T'.$i, number_format($row['totaldevengado']))
                        ->setCellValue('U'.$i, number_format($row['totaldescuento']))
                        ->setCellValue('V'.$i, number_format($row['netoapagar']));
            $i++;
        }

        $rangoEncabezado = 'A4:V4';
        $rangoCeldas     = 'A4:V'.($i-1);
        // ----------------------------------------------------------------------------------------------------------------------------------------------------------- //
        
        // Formato de Encabezado y Celdas
        $objPHPExcel->getActiveSheet()->getRowDimension('1')->setRowHeight(15);
        
        $EstiloCeldas = array(
        'borders' => array(
            'allborders' => array(
                'style' => PHPExcel_Style_Border::BORDER_THIN,
                'color' => array('argb' => '00000000'),
            ),
            ),
        );
        $objPHPExcel->getActiveSheet()->getStyle($rangoCeldas)->applyFromArray($EstiloCeldas);
        /// Formato de Encabezados 
        $EstiloEncabezado = array(
        'font' => array(
            'bold' => true,
        ),
        'alignment' => array(
            'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,
            'vertical' => PHPExcel_Style_Alignment::VERTICAL_CENTER,		
        ),
        'borders' => array(
            'allborders' => array(
                'style' => PHPExcel_Style_Border::BORDER_THIN,
                'color' => array('argb' => '00000000'),
            ),
        ),
        'fill' => array(
            'type' => PHPExcel_Style_Fill::FILL_SOLID,
            'rotation' => 90,
            'startcolor' => array(
                'argb' => '00FFFFCC',
            ),
            'endcolor' => array(
                'argb' => 'FFFFFF',
            ),
            ),
        );
        $objPHPExcel->getActiveSheet()->getStyle($rangoEncabezado)->applyFromArray($EstiloEncabezado);
        // Rename worksheet
        $objPHPExcel->getActiveSheet()->setTitle('liquidados');
        // Set active sheet index to the first sheet, so Excel opens this as the first sheet
        $objPHPExcel->setActiveSheetIndex(0);
        // Redirect output to a client’s web browser (Excel5)
        header('Content-Type: application/vnd.ms-excel');
        // --------------------------------------------------------------------- //                
        $nombrearcexcel = "liquidados del periodo ".strtolower($desperiodo).".xls";
        header('Content-Disposition: attachment;filename='.$nombrearcexcel.'');
        // --------------------------------------------------------------------- //
        header('Cache-Control: max-age=0');
        /// Genero la Salida
        $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');
        $objWriter->save('php://output');
        exit;
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: editarunaliquidacion
    // Creación: 15/05/2024		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción para editar la liquidación
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "editarunaliquidacion")
    {
        $terid = $_GET['terid'];
        $listaperiodos = $_GET['listaperiodos'];
        $codperiodo = $_GET['codperiodo'];
        $periodoid = $_GET['periodoid'];

        // nombre del periodo
        $descripcionperiodo = $clase->BDLockup($periodoid,'periodosnomina','periodoid','descripcion');        

        // Variable para el nombre de empleado
        $vsqldatos = "SELECT CONCAT(primernombre,' ',segundonombre,' ',primerapellido,' ',segundoapellido) AS nombreemp FROM terceros WHERE terid = ".$terid;
        $nombreemp = $clase->SeleccionarUno($vsqldatos);
        $vsqldatos = "";

        // Variable para el nombre del periodo
        $descripcion = $clase->BDLockup($periodoid,'periodosnomina','periodoid','descripcion');

        // Salario básico
        $basico = $clase->BDLockup($terid,'terceros','terid','basico');

        // Cédula o documento del empleado
        $dni = $clase->BDLockup($terid,'terceros','terid','dni');

        // La sección
        $vsqldatos = "SELECT s.descripcionsec 
                        FROM terceros t
                             INNER JOIN seccion s ON (t.seccionid = s.seccionid) 
                       WHERE t.terid = ".$terid;
        $seccion = $clase->SeleccionarUno($vsqldatos);
        $vsqldatos = "";

        // fechas de ingreso y retiro
        $vsql21 = "SELECT MAX(id) AS id FROM histcontrato WHERE terid = ".$terid;
        $id = $clase->SeleccionarUno($vsql21);
        $ultfecingreso = $clase->BDLockup($id,'histcontrato','id','fecingreso');
        $fecingreso = substr($ultfecingreso,8,2)."/".substr($ultfecingreso,5,2)."/".substr($ultfecingreso,0,4);
        $fecretiro = $clase->BDLockup($id,'histcontrato','id','fecretiro');

        if(($fecretiro == NULL) || ($fecretiro == '0000-00-00') || ($fecretiro == ''))
            $fecretiro = $clase->BDLockup($terid,'terceros','terid','fecharetiro');

        // ---------------------------------------------------------------------------------------------------------------------------------------------------- //        
        // días trabajados
        $vsqldatos = "SELECT valor AS diastrab 
                        FROM detalleliquidacion 
                       WHERE terid = ".$terid." 
                             AND pernominaid IN ($listaperiodos) 
                             AND conceptoid = 1";
        $diastrab = $clase->SeleccionarUno($vsqldatos);
        $vsqldatos = "";

        if($diastrab=="")
            $diastrab = 0;

        $diastrab2 = $diastrab;

        // El cargo
        $vsqldatos = "SELECT c.descripcioncargo 
                        FROM terceros t
                             INNER JOIN cargos c ON (t.cargoid = c.cargoid) 
                       WHERE t.terid = ".$terid;
        $cargo = $clase->SeleccionarUno($vsqldatos);
        $vsqldatos = "";

        // sueldo
        $vsqldatos = "SELECT devengados AS sueldo 
                        FROM detalleliquidacion 
                       WHERE terid = ".$terid." 
                             AND pernominaid IN ($listaperiodos) 
                             AND conceptoid=1";
        $sueldo = $clase->SeleccionarUno($vsqldatos);
        $vsqldatos = "";

        if($sueldo=="")
            $sueldo = 0;

        // auxilio de transporte
        $vsqldatos = "SELECT devengados AS auxtransporte 
                        FROM detalleliquidacion 
                       WHERE terid = ".$terid." 
                             AND pernominaid IN ($listaperiodos) 
                             AND conceptoid=3";
        $auxtransporte = $clase->SeleccionarUno($vsqldatos);
        $vsqldatos = "";

        if($auxtransporte=="")
            $auxtransporte = 0;

        // pensión
        $vsqldatos = "SELECT descuentos AS pension 
                        FROM detalleliquidacion 
                       WHERE terid = ".$terid." 
                             AND pernominaid IN ($listaperiodos) 
                             AND conceptoid=4";
        $pension = $clase->SeleccionarUno($vsqldatos);
        $vsqldatos = "";

        if($pension=="")
            $pension = 0;

        // salud
        $vsqldatos = "SELECT descuentos AS salud 
                        FROM detalleliquidacion 
                       WHERE terid = ".$terid." 
                             AND pernominaid IN ($listaperiodos) 
                             AND conceptoid=5";
        $salud = $clase->SeleccionarUno($vsqldatos);
        $vsqldatos = "";

        if($salud=="")
            $salud = 0;
        
        // Primas
        $vsqldatos = "SELECT l.cantidad AS diasprima
                        FROM liquidacion l
                       WHERE l.terid = ".$terid."
                             AND l.periodonomina = '".$codperiodo."' 
                             AND l.tipo = 'primas'
                             AND l.terid NOT IN (SELECT terid
                                                   FROM noliquida
                                                  WHERE terid = l.terid
                                                        AND periodonomina = '".$codperiodo."' 
                                                        AND tipo = 'primas')";
        $diasprima = $clase->SeleccionarUno($vsqldatos);
        $vsqldatos = "";

        if($diasprima=="")
            $diasprima = 0;

        $vsqldatos = "SELECT l.pago AS pagoprimas
                        FROM liquidacion l
                       WHERE l.terid = ".$terid."
                             AND l.periodonomina = '".$codperiodo."' 
                             AND l.tipo = 'primas'
                             AND l.terid NOT IN (SELECT terid
                                                   FROM noliquida
                                                  WHERE terid = l.terid
                                                        AND periodonomina = '".$codperiodo."' 
                                                        AND tipo = 'primas')";
        $pagoprimas = $clase->SeleccionarUno($vsqldatos);
        $vsqldatos = "";

        if($pagoprimas=="")
            $pagoprimas = 0;

        // Vacaciones
        $vsqldatos = "SELECT cantidad AS diasvaca
                        FROM liquidacion
                       WHERE terid=".$terid."
                             AND periodonomina = '".$codperiodo."' 
                             AND tipo = 'vacaciones'";
        $diasvaca = $clase->SeleccionarUno($vsqldatos);
        $vsqldatos = "";

        if($diasvaca=="")
            $diasvaca = 0;

        $vsqldatos = "SELECT pago AS pagovaca
                        FROM liquidacion
                       WHERE terid=".$terid."
                             AND periodonomina = '".$codperiodo."' 
                             AND tipo = 'vacaciones'";
        $pagovaca = $clase->SeleccionarUno($vsqldatos);
        $vsqldatos = "";

        if($pagovaca=="")
            $pagovaca = 0;

        // Cesantías
        $vsqldatos = "SELECT pago AS pagocesantias
                        FROM liquidacion
                       WHERE terid=".$terid."
                             AND periodonomina = '".$codperiodo."' 
                             AND tipo = 'cesantias'";
        $pagocesantias = $clase->SeleccionarUno($vsqldatos);
        $vsqldatos = "";

        if($pagocesantias=="")
            $pagocesantias = 0;

        $vsqldatos = "SELECT porcentaje AS porcesantias
                        FROM liquidacion
                       WHERE terid=".$terid."
                             AND periodonomina = '".$codperiodo."' 
                             AND tipo = 'cesantias'";
        $porcesantias = $clase->SeleccionarUno($vsqldatos);
        $vsqldatos = "";

        if($porcesantias=="")
            $porcesantias = 0;

        $vsqldatos = "SELECT pagointereses 
                        FROM liquidacion
                       WHERE terid=".$terid."
                             AND periodonomina = '".$codperiodo."' 
                             AND tipo = 'cesantias'";
        $pagointereses = $clase->SeleccionarUno($vsqldatos);
        $vsqldatos = "";

        if($pagointereses=="")
            $pagointereses = 0;
        
        // Indemnización
        $vsqldatos = "SELECT pago AS pagoinde
                        FROM liquidacion
                       WHERE terid=".$terid."
                             AND periodonomina = '".$codperiodo."' 
                             AND tipo = 'indemnizacion'";
        $pagoinde = $clase->SeleccionarUno($vsqldatos);
        $vsqldatos = "";

        if($pagoinde=="")
            $pagoinde = 0;

        // ------------------------------------------------------------------------------------------------------------------------------------------------------------------------- //
        // Combo de periodos
        $params = ' class="Texto11" style="height: 32px;" ';
        
        // periodo actual
        $vsqldatos = "SELECT pernominaid FROM detalleliquidacion WHERE terid = ".$terid." AND pernominaid IN ($listaperiodos) LIMIT 0,1";
        $periodoidactual = $clase->SeleccionarUno($vsqldatos);
        $vsqldatos = "";

        if(strlen($periodoidactual) == 0)
            $periodoidactual = $periodoid;

        // Determino qué tipo de periodo es para armar el combo
        $fecdesde = $clase->BDLockup($periodoidactual,'periodosnomina','periodoid','fecdesde');
        $diadesde = substr($fecdesde, -2);

        if($diadesde=="01")
        {
            $vsqlcomboperiodos = "SELECT periodoid, descripcion FROM periodosnomina WHERE periodoid IN ($listaperiodos) ORDER BY periodoid ASC";
            $comboperiodos = $clase->CrearComboBuscar("periodoidcombo",$vsqlcomboperiodos,"descripcion","periodoid",$periodoidactual,"N",$params,300);
        }

        if($diadesde=="16")
        {
            $vsqlcomboperiodos = "SELECT periodoid, descripcion FROM periodosnomina WHERE periodoid = ".$periodoid." ORDER BY periodoid ASC";
            $comboperiodos = $clase->CrearComboBuscar("periodoidcombo",$vsqlcomboperiodos,"descripcion","periodoid",$periodoidactual,"N",$params,300);
        }

        // ------------------------------------------------------------------------------------------------------------------------------------------------------------------------- //
        // determino si la liquidación está cerrada
        $vsqldatos = "SELECT norecalcular FROM parametrosliquidacion WHERE terid = ".$terid." AND codperiodo = '".$codperiodo."'";
        $norecalcular = $clase->SeleccionarUno($vsqldatos);

        // Icono de la ventana
        if($norecalcular == "CHECKED")
        {
            $htmliconoventana = '<img src="images/iconos/cerrar.png" width="32" height="32" border="0">';
            $htmltitulo = 'Liquidaci&oacute;n cerrada';
            $comboperiodos = '';
        }
        else
        {
            $htmliconoventana = '<img src="images/iconos/retirados.png" width="32" height="32" border="0">';
            $htmltitulo = 'Editar Liquidaci&oacute;n';
        }

        // nombre del periodo
        $desperiodo = $clase->BDLockup($codperiodo,'periodos','codperiodo','desperiodo');

        // Pintamos la ventana
        $cont = $clase->Header("S","W");

        $cont.='<form action="?opcion=cambiarfecha" method="POST" name="x">
                <input type="hidden" name = "terid" value = "'.$terid.'">
                <input type="hidden" name = "listaperiodos" value = "'.$listaperiodos.'">
                <input type="hidden" name = "codperiodo" value = "'.$codperiodo.'">
                <input type="hidden" name = "periodoid" value = "'.$periodoid.'">
                <input type="hidden" name = "periodoidactual" value = "'.$periodoidactual.'">
                <input type="hidden" name = "periodoidcombo" value = "'.$periodoidcombo.'">
                <input type="hidden" name="cesantiasant" value="'.$cesantiasant.'">
                <input type="hidden" name="norecalcular" value="'.$norecalcular.'">
                <table width="100%">
                 <tr class="CabezoteTabla"> 
                  <td width="10"> &nbsp; </td>
                  <td width="40" align="center"> '.$htmliconoventana.' </td>
                  <td width="508"> <b> '.$htmltitulo.'  <font color="blue"> <br> '.$desperiodo.' </font> </b> </td>
                  <td width="384"> '.$comboperiodos.' </td>
                  <td width="24"> 
                   <a href="terceros.php?opcion=detalles2&id='.$terid.'" title="editar ficha del empleado" target="_blank">
                    <img src="images/iconos/clientes.png" width="34" height="34" border="0"> 
                   </a> 
                  </td>
                  <td width="10"> &nbsp; </td>
                  <td width="24"> 
                   <!-- ---------------------------------------------------------------------------------------------------------------------------------------------------
                   <a href="?opcion=imprimirliq&terid='.$terid.'&codperiodo='.$codperiodo.'&periodoid='.$periodoid.'" title="imprimir liquidaci&oacute;n" target="_blank">
                    <img src="images/iconos/exportarpdf2.png" width="34" height="34" border="0"> 
                   </a> 
                   ---------------------------------------------------------------------------------------------------------------------------------------------------- -->
                   <img src="images/iconos/exportarpdf2.png" width="34" height="34" border="0" title="imprimir liquidaci&oacute;n (esta opci&oacute;n est&aacute; en construcci&oacute;n)"> 
                  </td>
                  <td width="10"> &nbsp; </td>
                  <td width="24"> 
                   <a href="?opcion=precalconliq&terid='.$terid.'&codperiodo='.$codperiodo.'&periodoid='.$periodoid.'&listaperiodos='.$listaperiodos.'" title="calcular vacaciones, primas y cesantías" rel="facebox"> 
                    <img src="images/iconos/calculando.png" width="34" height="34" border="0"> 
                   </a> 
                  </td>
                  <td width="10"> &nbsp; </td>
                  <td width="24">
                   <a href="?opcion=incluirconcepto&terid='.$terid.'&periodoid='.$periodoid.'&codperiodo='.$codperiodo.'&listaperiodos='.$listaperiodos.'&periodoidactual='.$periodoidactual.'" title="incluir un concepto en la quincena" rel="facebox"> 
                    <img src="images/iconos/nuevodoc.png" width="34" height="34" border="0"> 
                   </a> 
                  </td>
                  <td width="10"> &nbsp; </td>
                  <td width="24"> 
                   <a href="?opcion=editarlicencia&terid='.$terid.'&periodoid='.$periodoid.'&codperiodo='.$codperiodo.'&listaperiodos='.$listaperiodos.'&periodoidactual='.$periodoidactual.'" title="incluir una licencia" rel="facebox">
                    <img src="images/iconos/gastos.png" title="licencias" width="34" height="34" border="0">
                   </a>
                  </td>
                  <td width="10"> &nbsp; </td>
                  <td width="24"> 
                   <a href="?opcion=actincapacidadarl&terid='.$terid.'&periodoid='.$periodoid.'&diastrab='.$diastrab.'&codperiodo='.$codperiodo.'&listaperiodos='.$listaperiodos.'&periodoidactual='.$periodoidactual.'" title="recalcular incapacidad ARL" target="_blank"> 
                    <img src="images/iconos/refrescar.png" width="34" height="34" border="0">  
                   </a> 
                  </td>
                  <td width="10"> &nbsp; </td>
                  <td width="24"> 
                   <a href="?opcion=confirmarelim&terid='.$terid.'&periodoid='.$periodoid.'&codperiodo='.$codperiodo.'&listaperiodos='.$listaperiodos.'" title="eliminar toda la liquidación" rel="facebox"> 
                    <img src="images/iconos/anulardoc.png" width="34" height="34" border="0"> 
                   </a> 
                  </td>
                  <td width="10"> &nbsp; </td>
                 </tr> 
                </table>';

        if($norecalcular == "CHECKED")
        {
            $botonelivaca = '';
            $botoneliprima = '';
            $botonelicesantia = '';
            $botoneliindem = '';
        }
        else
        {
            $botonelivaca = '<a href="?opcion=confirelivaca&codperiodo='.$codperiodo.'&terid='.$terid.'&periodoid='.$periodoid.'&listaperiodos='.$listaperiodos.'" rel="facebox">
                              <img src="images/basicas/iconoborrar.png" title="eliminar vacaciones" border="0">
                             </a>';
            $botoneliprima = '<a href="?opcion=confireliprima&codperiodo='.$codperiodo.'&terid='.$terid.'&periodoid='.$periodoid.'&listaperiodos='.$listaperiodos.'" rel="facebox">
                               <img src="images/basicas/iconoborrar.png" title="eliminar prima" border="0">
                              </a>';
            $botonelicesantia = '<a href="?opcion=confirelicesantia&codperiodo='.$codperiodo.'&terid='.$terid.'&periodoid='.$periodoid.'&listaperiodos='.$listaperiodos.'" rel="facebox">
                                  <img src="images/basicas/iconoborrar.png" title="eliminar cesant&iacute;a" border="0">
                                 </a>';
            $botoneliindem = '<a href="?opcion=confireliindem&codperiodo='.$codperiodo.'&terid='.$terid.'&periodoid='.$periodoid.'&listaperiodos='.$listaperiodos.'" rel="facebox">
                               <img src="images/basicas/iconoborrar.png" title="eliminar indemnizaci&oacute;n" border="0">
                              </a>';
        }

        $lbldiastrab = ''.number_format($diastrab).'';
        $lbldiastrab2 = ''.number_format($diastrab2).'';
        $htmldiasvaca = ''.number_format($diasvaca).'';
        $htmlpagovaca = ''.number_format($pagovaca,2).'';
        $htmldiasprima = ''.number_format($diasprima).'';
        $htmlpagoprimas = ''.number_format($pagoprimas,2).'';
        $htmlpagocesantias = ''.number_format($pagocesantias,2).'';
        $htmlporcesantias = ''.number_format($porcesantias,2).'';
        $htmlpagointereses = ''.number_format($pagointereses,2).'';
        $htmlpagoinde = ''.number_format($pagoinde,2).'';

        // ------------------------------------------------------------------------------------ //
        // Validación de la fecha de retiro
        $comienzoper2 = substr($listaperiodos,0,2);
        $finper2 = substr($listaperiodos,-2);
        $fecdesde2 = $clase->BDLockup($comienzoper2,'periodosnomina','periodoid','fecdesde');
        $fechasta2 = $clase->BDLockup($finper2,'periodosnomina','periodoid','fechasta');
        // ------------------------------------------------------------------------------------ //

        $cont.='<table width="100%">
                 <tr class="BarraDocumentos" style="height:50px;Important!"> 
                  <td width="47"> &nbsp; </td>
                  <td width="330"> <label class="Texto12"> Empleado(a): <br> '.$nombreemp.' </label> </td>
                  <td width="266"> <label class="Texto12"> Documento:<br> '.$dni.' </label> </td>
                  <td width="265"> <label class="Texto12"> Secci&oacute;n: <br> '.$seccion.' </label> </td>
                  <td width="206"> <label class="Texto12"> Cargo: <br> '.$cargo.' </label> </td>
                 </tr>
                 <tr class="BarraDocumentos" style="height:50px;Important!">
                  <td width="47"> &nbsp; </td>
                  <td width="330"> <label class="Texto12"> Salario b&aacute;sico: <br> '.number_format($basico).' </label> </td>
                  <td width="266"> <label class="Texto12"> Ingreso: <br> '.$fecingreso.' </label> </td>
                  <td width="265"> 
                   <label class="Texto12"> Retiro: </label> <br> 
                   <input type="date" name="fecretiro" class="Texto12New" style="width:120px;height:25px;" autocomplete="off" value = "'.$fecretiro.'" min="'.$fecdesde2.'" max = "'.$fechasta2.'">
                   &nbsp; <input type="submit" value="..." class="button blue">
                   </form>
                  </td>
                  <td width="206"> &nbsp; </td>
                 </tr>
                 <!-- ----------------------------------------------------------------------
                 <form action="?opcion=calculosliq" name="y" method="POST">
                 <input type="hidden" name="basico" value="'.$basico.'">
                 <input type="hidden" name="terid" value="'.$terid.'">
                 <input type="hidden" name="periodoid" value="'.$periodoid.'">
                 <input type="hidden" name="codperiodo" value="'.$codperiodo.'">
                 <input type="hidden" name="listaperiodos" value="'.$listaperiodos.'">
                 ---------------------------------------------------------------------- -->
                 <tr class="BarraDocumentos" style="height:50px;Important!">
                  <td width="47"> &nbsp; </td>
                  <td width="330"> <label class="Texto12"> D&iacute;as trabajados: </label> '.number_format($diastrab).' </td>
                  <td width="266"> <label class="Texto12"> Sueldo: </label> '.number_format($sueldo).' </td>
                  <td width="265"> <label class="Texto12"> Pensi&oacute;n: </label> '.number_format($pension).' </td>
                  <td width="206"> <label class="Texto12"> Salud: </label> '.number_format($salud).' </td>
                 </tr>
                 <tr class="BarraDocumentos" style="height:50px;Important!">
                  <td width="47"> &nbsp; </td>
                  <td width="330"> <label class="Texto12"> D&iacute;as trabajados: </label> '.number_format($diastrab2).' </td>
                  <td width="266"> <label class="Texto12"> Transporte: </label> '.number_format($auxtransporte).' </td>
                  <td width="265"> &nbsp; </td>
                  <td width="206"> &nbsp; </td>
                 </tr>
                 <tr class="BarraDocumentos" style="height:50px;Important!">
                  <td width="47" align="center"> '.$botonelivaca.' </td>
                  <td width="330"> <label class="Texto12"> Vacaciones: </label> </td>
                  <td width="266"> <label class="Texto12"> D&iacute;as: </label> '.$htmldiasvaca.' </td>
                  <td width="265"> <label class="Texto12"> Pago: </label> '.$htmlpagovaca.' </td>
                  <td width="206"> &nbsp; </td>
                 </tr>
                 <tr class="BarraDocumentos" style="height:50px;Important!">
                  <td width="47" align="center"> '.$botoneliprima.' </td>
                  <td width="330"> <label class="Texto12"> Primas: </label> </td>
                  <td width="266"> <label class="Texto12"> D&iacute;as: </label> '.$htmldiasprima.' </td>
                  <td width="265"> <label class="Texto12"> Pago: </label> '.$htmlpagoprimas.' </td>
                  <td width="206"> &nbsp; </td>
                 </tr>
                 <tr class="BarraDocumentos" style="height:50px;Important!">
                  <td width="47" align="center"> '.$botonelicesantia.' </td>
                  <td width="330"> <label class="Texto12"> Cesant&iacute;as: </label> </td>
                  <td width="266"> <label class="Texto12"> Pago: </label> '.$htmlpagocesantias.' </td>
                  <td width="265"> <label class="Texto12"> Porc.: </label> '.$htmlporcesantias.' % </td>
                  <td width="206"> <label class="Texto11"> Intereses: </label> '.$htmlpagointereses.' </td>
                 </tr>
                 <tr class="BarraDocumentos" style="height:50px;Important!">
                  <td width="47" align="center"> '.$botoneliindem.' </td>
                  <td width="330"> <label class="Texto12"> Indemnizaci&oacute;n: </label> </td>
                  <td width="266"> <label class="Texto12"> Pago: </label> '.$htmlpagoinde.' </td>
                  <td width="265"> &nbsp; </td>
                  <td width="206"> &nbsp; </td>
                 </tr>
                </table>';

        $cont.='<table width="100%">
                 <tr class="BarraDocumentos" style="height:40px;Important!">
                  <center>
                  <td width="657" align="center"> <b> Otros conceptos </b> </td>
                  </center>
                 </tr>
                </table>';

        $cont.='<script type="text/javascript" src="lib/sorttable.js"></script>
                <table width="100%" class="sortable">
                 <thead> 
                  <tr class="TituloTabla" style="display:block;padding-top:5px;height:20px;">
                   <td width="12"> &nbsp; </td>
                   <td width="290"> Concepto </td>
                   <td width="320" align="right"> Devengados </td>			
                   <td width="23" align="right"> &nbsp; </td>
                   <td width="320" align="right"> Descuentos </td>
                   <td width="60"> &nbsp; </td>
                  </tr>
                </thead>
                <tbody style="display:block; width:1050px; height:150px; overflow-Y:scroll">';

        // Consulta con los demás conceptos del empleado en el periodo
        $vsql = "SELECT d.detalleid, c.nomconcepto, d.devengados, d.descuentos, c.tipodc, d.conceptoid 
                   FROM detalleliquidacion d
                        INNER JOIN conceptosnomina c ON (d.conceptoid = c.conceptoid)
                  WHERE d.pernominaid IN ($listaperiodos)
                        AND d.terid = ".$terid."
                        AND d.conceptoid NOT IN (1,3,4,5)
               ORDER BY c.tipodc, c.codconcepto";

        // Conexión a la base de datos
        $conex  = $clase->Conectar();
        $result = mysql_query($vsql,$conex);
        $cant   = mysql_num_rows($result);

        // Inicialización de variables
        $totdevengado = 0;
        $totdescuento = 0;
        $netoapagar = 0;

        // Validación de la ejecución del ciclo
        if($cant>0)
        {
            $i = 0;
            while($row = mysql_fetch_array($result))
            {
                $i++;
                if($i%2 == 0)
                    $cont.='<tr class="TablaDocsPar">';
                else
                    $cont.='<tr class="TablaDocsImPar">';
    
                $cont.=' <td width="12"> &nbsp; </td>
                            <td width="290"> '.$row['nomconcepto'].' </td>';

                // Impresión del monto si es un devengado
                if($row['tipodc']=="C")
                {
                    $cont.=' <td width="320" align="right">'.number_format($row['devengados']).' </td>
                             <td width="23" align="right"> &nbsp; </td>
                             <td width="320" align="right"> &nbsp; </td>';

                    $totdevengado += $row['devengados'];
                }

                // Impresión del monto si es un descuento
                if($row['tipodc']=="D")
                {
                    $cont.=' <td width="320" align="right"> &nbsp; </td>
                             <td width="23" align="right"> &nbsp; </td>
                             <td width="320" align="right">'.number_format($row['descuentos']).' </td>';
                                                                                                 
                    if(($row['conceptoid']!=6) && ($row['conceptoid']!=9) && ($row['conceptoid']!=43) && ($row['conceptoid']!=58))
                        $totdescuento += $row['descuentos'];
                }

                if($norecalcular == "CHECKED")
                    $cont.=' <td width="40" align="center"> &nbsp; </td>
                             <td width="30" align="center"> &nbsp; </td>
                            </tr>';
                else
                    $cont.=' <td width="40" align="center"> &nbsp; </td>
                             <td width="30" align="center"> 
                              <a href="?opcion=confirmarelimconcepto&codperiodo='.$codperiodo.'&terid='.$terid.'&periodoid='.$periodoid.'&listaperiodos='.$listaperiodos.'&detalleid='.$row['detalleid'].'&periodoidactual='.$periodoidactual.'" rel="facebox">
                               <img src="images/basicas/iconoborrar.png" title="eliminar conceptos" border="0">
                              </a>
                             </td>
                            </tr>';
            }
        }

        $cont.=' </tbody>
                </table>';

        // Cálculo de los totales
        $totdevengado += $sueldo + $auxtransporte + $pagoprimas + $pagovaca + $pagocesantias + $pagointereses + $pagoinde;
        $totdescuento += ($pension + $salud);
        $netoapagar = $totdevengado - $totdescuento;

        // Impresión de los totales
        $cont.='<table width="100%">
                 <tr class="TituloTabla"> 
                  <td width="261"> &nbsp; </td>
                  <td width="375" align="right"> <font color="WHITE"> <b> Total devengado: </b> '.number_format($totdevengado,2).' </font> </td>
                  <td width="375" align="right"> <font color="WHITE"> <b> Total descuentos: </b> '.number_format($totdescuento,2).' </font> </td>
                  <td width="375" align="right"> <font color="WHITE"> <b> Neto a pagar: </b> '.number_format($netoapagar,2).' </font> </td>
                  <td width="222"> &nbsp; </td>
                 </tr>
                </table>';

        echo $cont.$clase->PiePagina();
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: cambiarfecha
    // Creación: 15/05/2024		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción para procesar el recalculo de la quincena a partir de la fecha  
    //              de retiro
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "cambiarfecha")
    {
        $terid = $_POST['terid'];
        $listaperiodos = $_POST['listaperiodos'];
        $codperiodo = $_POST['codperiodo'];
        $periodoid = $_POST['periodoid'];
        $fecretiro = $_POST['fecretiro'];
        $periodoidactual = $_POST['periodoidactual'];
        $periodoidcombo = $_POST['periodoidcombo'];
        // $norecalcular = $_POST['norecalcular'];

        // determino si la liquidación está cerrada
        $vsqldatos = "SELECT norecalcular FROM parametrosliquidacion WHERE terid = ".$terid." AND codperiodo = '".$codperiodo."'";
        $norecalcular = $clase->SeleccionarUno($vsqldatos);        

        if($norecalcular == "CHECKED")
        {
            // emito el mensaje correspondiente        
            $clase->Aviso(3,"Esta liquidación está cerrada");

            // Redirecciono el formulario
            header("Location: liquidados.php?opcion=editarunaliquidacion&terid=$terid&listaperiodos=$listaperiodos&codperiodo=$codperiodo&periodoid=$periodoid");            
        }
        else
        {
            // actualizo en el histórico de contrato
            $vsql21 = "SELECT MAX(id) AS id FROM histcontrato WHERE terid = ".$terid;
            $id = $clase->SeleccionarUno($vsql21);
            
            $vsql42 = "UPDATE histcontrato SET fecretiro = '".$fecretiro."' WHERE id = ".$id;
            $clase->EjecutarSQL($vsql42);
    
            // actualizo en terceros
            $vsql41 = "UPDATE terceros SET fecharetiro = '".$fecretiro."' WHERE terid = ".$terid;
            $clase->EjecutarSQL($vsql41);
    
            // actualizo los días trabajados
            $fecdesde = $clase->BDLockup($periodoidcombo,'periodosnomina','periodoid','fecdesde');
            $fechasta = $clase->BDLockup($periodoidcombo,'periodosnomina','periodoid','fechasta');        
    
            if(($fecretiro>=$fecdesde)&&($fecretiro<=$fechasta))
            {
                // Procedo a calcular los días que trabajó durante el periodo
                $fecha1= new DateTime($fecdesde);
                $fecha2= new DateTime($fecretiro);
                $diff = $fecha1->diff($fecha2);
                
                $difendias = $diff->days;
                $diastrab = $difendias + 1;
            }
            else
                $diastrab = 0;
    
            // actualizo el sueldo
            if($diastrab > 0)
            {
                // limpio lo anterioromente calculado
                $vsql = "DELETE FROM detalleliquidacion WHERE terid = ".$terid." AND pernominaid IN ($listaperiodos) AND conceptoid IN (1,3,4,5)";
                $clase->EjecutarSQL($vsql);
                $periodoid = $periodoidcombo;
    
                // salario básico
                $basico = $clase->BDLockup($terid,'terceros','terid','basico');
    
                // Obtengo la formula del sueldo
                $vsql = "SELECT formula FROM conceptosnomina WHERE conceptoid = 1";
                $formulabasico = $clase->SeleccionarUno($vsql);
    
                // Calculo el sueldo básico
                eval("\$sueldo = $formulabasico;");
                $sueldo = round($sueldo,0);
    
                $vsql = "SELECT max(detalleid) FROM detalleliquidacion";
                $numreg = $clase->SeleccionarUno($vsql);
    
                $vsql = "INSERT INTO detalleliquidacion VALUES ($numreg+1,".$terid.",1,".$periodoidcombo.",".$sueldo.",0,".$diastrab.",$basico)";
                $clase->EjecutarSQL($vsql);
    
                // echo $vsql; exit();
    
                // Recalculo el subsidio de transporte
                $smlv = $_SESSION['N_SALMIN2020'];
                $valsubtrasp = $smlv * 2;                   // Variable para la validación del auxilio de transporte
    
                // Obtengo la formula para el subsidio de transporte
                $auxtrans = $_SESSION['N_AUXTRANS2020'];
                $vsql = "SELECT formula FROM conceptosnomina WHERE conceptoid = 3";
                $formulatransporte = $clase->SeleccionarUno($vsql);
    
                $cargoid = $clase->BDLockup($terid,'terceros','terid','cargoid');                               // Obtengo el cargo del empleado
                $aplicatransporte = $clase->BDLockup($cargoid,'cargos','cargoid','aplicatransporte');           // Obtengo el control del cálculo de subsidio de transporte
    
                if(($basico <= $valsubtrasp)&&($aplicatransporte=="CHECKED"))
                {
                    // Calculo el subsidio de transporte
                    eval("\$subsidiotransporte = $formulatransporte;");
                    $subsidiotransporte = round($subsidiotransporte,0);
                }
                else
                    $subsidiotransporte = 0;
    
                // Obtengo el valor del subsidio de transporte
                $valsubtransporte = $_SESSION['N_AUXTRANS2020'];
    
                $vsql = "SELECT max(detalleid) FROM detalleliquidacion";
                $numreg = $clase->SeleccionarUno($vsql);
    
                $vsql = "INSERT INTO detalleliquidacion VALUES ($numreg+1,".$terid.",3,".$periodoidcombo.",".$subsidiotransporte.",0,".$diastrab.",$valsubtransporte)";
                $clase->EjecutarSQL($vsql);
            }
            else
            {
                $vsql = "DELETE FROM detalleliquidacion WHERE terid = ".$terid." AND pernominaid = ".$periodoidcombo." AND conceptoid IN (1,3,4,5)";
                $clase->EjecutarSQL($vsql);
            }       
    
            // Determino si el empleado es de condición extralegal
            $extralegal = $clase->BDLockup($terid,'terceros','terid','extralegal');
            $epsid = $clase->BDLockup($terid,'terceros','terid','epsid');
            $pensionesid = $clase->BDLockup($terid,'terceros','terid','pensionesid');
            
            if($epsid==NULL)                $epsid = 0;
            if($pensionesid==NULL)          $pensionesid = 0;
    
            $totnovedades = 0;
            $sueldodeducciones = 0;
    
            $vsql69 = "SELECT IFNULL(SUM(d.devengados),0) AS totnovedades 
                         FROM detalleliquidacion d
                              INNER JOIN conceptosnomina c ON (d.conceptoid = c.conceptoid)
                        WHERE d.terid = ".$terid."
                              AND d.pernominaid = ".$periodoidcombo." 
                              AND (c.eslicencia = 'CHECKED' AND c.tipodc = 'C')";
            $totnovedades = $clase->SeleccionarUno($vsql69);
            $sueldodeducciones = $sueldo + $totnovedades;
            
            $cargoid = $clase->BDLockup($terid,'terceros','terid','cargoid');                       // Obtengo el cargo del empleado
            $aplicapension = $clase->BDLockup($cargoid,'cargos','cargoid','aplicapension');         // Obtengo el control del cálculo de pensión
            $aplicasalud = $clase->BDLockup($cargoid,'cargos','cargoid','aplicasalud');             // Obtengo el control del cálculo de salud
    
            if($extralegal=="CHECKED")
            {
                $pension = 0;
                $salud = 0;
            }
            else
            {
                // Recalculo pensión y salud
                if(($pensionesid==5)||($aplicapension!="CHECKED"))
                    $pension = 0;
                else
                {
                    // Obtengo la formula para el descuento por pensión
                    $vsql = "SELECT formula FROM conceptosnomina WHERE conceptoid = 4";
                    $formulapension = $clase->SeleccionarUno($vsql);
    
                    // Calculo la pensión
                    eval("\$pension = $formulapension;");
                    $pension = round($pension,0);
                }
    
                if(($epsid==37)||($aplicasalud!="CHECKED"))
                    $salud = 0;
                else
                {
                    // Obtengo la formula para el descuento de salud
                    $vsql = "SELECT formula FROM conceptosnomina WHERE conceptoid = 5";
                    $formulasalud = $clase->SeleccionarUno($vsql);
                    
                    // Calculo la salud
                    eval("\$salud = $formulasalud;");
                    $salud = round($salud,0);
                }
            }
    
            // grabo la pensión
            $vsql = "SELECT max(detalleid) FROM detalleliquidacion";
            $numreg = $clase->SeleccionarUno($vsql);
            
            $vsql = "INSERT INTO detalleliquidacion VALUES ($numreg+1,".$terid.",4,".$periodoidcombo.",0,".$pension.",0,$sueldodeducciones)";
            $clase->EjecutarSQL($vsql);
    
            // grabo la salud
            $vsql = "SELECT max(detalleid) FROM detalleliquidacion";
            $numreg = $clase->SeleccionarUno($vsql);
    
            $vsql = "INSERT INTO detalleliquidacion VALUES ($numreg+1,".$terid.",5,".$periodoidcombo.",0,".$salud.",0,$sueldodeducciones)";
            $clase->EjecutarSQL($vsql);
    
            // Aquí depuro los conceptos que estén en cero
            $vsql = "DELETE FROM detalleliquidacion WHERE devengados = 0 AND descuentos = 0 AND pernominaid =".$periodoidcombo." AND terid =".$terid."";
            $clase->EjecutarSQL($vsql);
    
            // mensaje correspondiente
            $clase->Aviso(1,"Fecha de retiro actualizada satisfactoriamente");
    
            // Redirecciono el formulario
            header("Location: liquidados.php?opcion=editarunaliquidacion&terid=$terid&listaperiodos=$listaperiodos&codperiodo=$codperiodo&periodoid=$periodoid");
        }
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: precalconliq
    // Creación: 16/05/2024		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que pre calcula las vacaciones, primas y cesantías del periodo 
    //              trabajado
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "precalconliq")
    {        
        $terid = $_GET['terid'];
        $codperiodo = $_GET['codperiodo'];
        $periodoid = $_GET['periodoid'];
        $listaperiodos = $_GET['listaperiodos'];

        // Inicialización de variables
        $diasps = 0;                    $diasss = 0;                    $tienecambio = false;
        $promsueldoact = 0;             $sueldointegralact = 0;         $basico = 0;
        $yearingreso = 0;               $nombreemp = "";        

        // fechas de ingreso y retiro
        $vsql21 = "SELECT MAX(id) AS id FROM histcontrato WHERE terid = ".$terid;
        $id = $clase->SeleccionarUno($vsql21);
        $fecingreso = $clase->BDLockup($id,'histcontrato','id','fecingreso');

        $basico = $clase->BDLockup($terid,'terceros','terid','basico');                     // sueldo básico
        $yearingreso = intval(substr($fecingreso,0,4));                                     // año de la fecha de ingreso

        // Nombre del empleado
        $vsql = "SELECT CONCAT(primernombre,' ',segundonombre,' ',primerapellido,' ',segundoapellido) AS nombreemp FROM terceros WHERE terid = ".$terid."";
        $nombreemp = $clase->SeleccionarUno($vsql);

        // Obtengo el id del último contrato
        $vsql = "SELECT MAX(id) AS id FROM histcontrato WHERE terid = ".$terid;
        $id = $clase->SeleccionarUno($vsql);
        $fecretiro = $clase->BDLockup($id,'histcontrato','id','fecretiro');

        if(($fecretiro == NULL) || ($fecretiro == '0000-00-00') || ($fecretiro == ''))
            $fecretiro = $clase->BDLockup($terid,'terceros','terid','fecharetiro');

        // validación del subsidio de transporte
        $smlv = $_SESSION['N_SALMIN2020'];
        $valtransporte = $smlv * 2;

        if($basico > $valtransporte)
            $auxtrans = 0;
        else
            $auxtrans = $_SESSION['N_AUXTRANS2020'];            

        // ------------------------------------------------------------------------------------------- //
        // Determino si hubo un cambio de salario en los últimos tres meses
        $tienecambio = tienecambiosalario($terid,$fecretiro);

        if($tienecambio)
        {
            $promsueldoact = calsueldopromedio($terid,$fecingreso);            
            $sueldointegralact = $promsueldoact + $auxtrans;
        }
        else
            $sueldointegralact = $basico + $auxtrans;                
        
        // año anterior
        $yearprev = date("Y") - 1;

        if($yearingreso>$yearprev)
        {
            $basicoant = 0;
            $auxtransant = 0;
            $diasyearant = 0;
            $sueldointegralant = 0;
        }
        else
        {
            // máximo periodo del año anterior
            $vsql = " SELECT MAX(periodoid) AS periodoidant FROM periodosnomina WHERE YEAR(fechasta) = ".$yearprev." ";
            $periodoidant = $clase->SeleccionarUno($vsql);
    
            // básico de año anterior
            $vsql = "SELECT saldo 
                       FROM hisdetallenomina 
                      WHERE terid = ".$terid." 
                            AND pernominaid = ".$periodoidant." 
                            AND conceptoid IN (1,10,11,12,13,31,38,43)";
            $basicoant = $clase->SeleccionarUno($vsql);

            // ------------------------------------------------------------------------------------------- //
            $vsql25 = "SELECT MIN(periodoid) permin2
                         FROM periodosnomina 
                        WHERE fecdesde >= '".$fecingreso."' 
                              AND YEAR(fecdesde) = ".$yearprev." 
                              AND cerrado = 'CHECKED' ";
            $permin2 = $clase->SeleccionarUno($vsql25);
            
            $vsql26 = "SELECT MAX(periodoid) permax2
                         FROM periodosnomina 
                        WHERE fecdesde >= '".$fecingreso."' 
                              AND YEAR(fecdesde) = ".$yearprev." 
                              AND cerrado = 'CHECKED' ";
            $permax2 = $clase->SeleccionarUno($vsql26);
            // ------------------------------------------------------------------------------------------- //
    
            if(($basicoant==0)||($basicoant==NULL))
            {
                $basicoant = 0;
                $auxtransant = 0;
                $diasyearant = 0;
                $sueldointegralant = 0;
            }
            else
            {
                // auxilio de transporte del año anterior
                $vsql = "SELECT saldo FROM hisdetallenomina WHERE conceptoid = 3 AND pernominaid = ".$periodoidant." AND terid = ".$terid;
                $auxtransant = $clase->SeleccionarUno($vsql);
    
                // Sueldo integral del año anterior
                $sueldointegralant = $basicoant + $auxtransant;
    
                // días laborados el año anterior
                $vsql = "SELECT periodoid
                           FROM periodosnomina
                          WHERE fecdesde <= '".$fecingreso."'
                                AND fechasta >= '".$fecingreso."'";
                $eneroant = $clase->SeleccionarUno($vsql);
        
                $vsql = "SELECT SUM(valor) AS diasyearant 
                           FROM hisdetallenomina 
                          WHERE terid = ".$terid." 
                                AND conceptoid IN (1,10,11,12,13,23,31,38,40) 
                                AND pernominaid BETWEEN ".$eneroant." AND ".$periodoidant." 
                                AND pernominaid NOT IN (SELECT pernominaid 
                                                          FROM periodoterceros 
                                                         WHERE periodoterceros.terid = ".$terid." 
                                                               AND periodoterceros.pernominaid BETWEEN ".$permin2." AND ".$permax2." 
                                                               AND periodoterceros.extralegal = 'CHECKED')";
                $diasyearant = $clase->SeleccionarUno($vsql);
            }
        }

        // ----------------------------------------------------------------------------------------------- //
        // Días laborados en el primer trimestre del año actual
        $yeartoday = date("Y");

        $comienzoprimersemestre = $yeartoday."-01-01";
        $finprimersemestre = $yeartoday."-06-30";

        // si el empleado ingresó en este periodo
        if($fecingreso>=$comienzoprimersemestre)
        {
            $vsql = " SELECT MAX(periodoid) AS primeroenero FROM periodosnomina WHERE fecdesde <= '".$fecingreso."' ";
            $primeroenero = $clase->SeleccionarUno($vsql);
    
            $vsql = " SELECT periodoid AS treintajunio FROM periodosnomina WHERE fechasta = '".$finprimersemestre."' ";
            $treintajunio = $clase->SeleccionarUno($vsql);
    
            // Días en el histórico
            $vsql = "SELECT IFNULL(SUM(valor),0) AS diasps
                       FROM hisdetallenomina 
                      WHERE terid = ".$terid." 
                            AND conceptoid IN (1,10,11,12,13,23,31,38,40) 
                            AND pernominaid BETWEEN ".$primeroenero." AND ".$treintajunio." 
                            AND pernominaid NOT IN (SELECT pernominaid 
                                                      FROM periodoterceros
                                                     WHERE periodoterceros.terid = ".$terid." 
                                                           AND periodoterceros.pernominaid BETWEEN ".$primeroenero." AND ".$treintajunio."
                                                           AND periodoterceros.extralegal = 'CHECKED')";
            $diasps = $clase->SeleccionarUno($vsql);
    
            // Días en la liquidación
            $vsql = "SELECT IFNULL(SUM(valor),0) AS diasliq
                       FROM detalleliquidacion 
                      WHERE terid = ".$terid." 
                            AND conceptoid IN (1,10,11,12,13,23,31,38,40) 
                            AND pernominaid BETWEEN ".$primeroenero." AND ".$treintajunio."";
            $diasliq = $clase->SeleccionarUno($vsql);
    
            $diasps += $diasliq;
        }

        if(($fecingreso<$comienzoprimersemestre)&&($diasyearant>0))
        {
            $diasliq = 0;
            $vsql = " SELECT periodoid AS primeroenero FROM periodosnomina WHERE fecdesde = '".$comienzoprimersemestre."' ";
            $primeroenero = $clase->SeleccionarUno($vsql);

            $vsql = " SELECT periodoid AS treintajunio FROM periodosnomina WHERE fechasta = '".$finprimersemestre."' ";
            $treintajunio = $clase->SeleccionarUno($vsql);
    
            // Días en el histórico
            $vsql = "SELECT IFNULL(SUM(valor),0) AS diasps
                       FROM hisdetallenomina 
                      WHERE terid = ".$terid." 
                            AND conceptoid IN (1,10,11,12,13,23,31,38,40) 
                            AND pernominaid BETWEEN ".$primeroenero." AND ".$treintajunio."
                            AND pernominaid NOT IN (SELECT pernominaid 
                                                      FROM periodoterceros
                                                     WHERE periodoterceros.terid = ".$terid." 
                                                           AND periodoterceros.pernominaid BETWEEN ".$primeroenero." AND ".$treintajunio."
                                                           AND periodoterceros.extralegal = 'CHECKED')";
            $diasps = $clase->SeleccionarUno($vsql);
    
            // Días en la liquidación
            $vsql = "SELECT IFNULL(SUM(valor),0) AS diasliq
                       FROM detalleliquidacion 
                      WHERE terid = ".$terid." 
                            AND conceptoid IN (1,10,11,12,13,23,31,38,40)
                            AND pernominaid BETWEEN ".$primeroenero." AND ".$treintajunio."";
            $diasliq = $clase->SeleccionarUno($vsql);
    
            $diasps += $diasliq;
        }

        // Días laborados en el segundo semestre del año
        $inisegsemestre = $yeartoday."-07-01";
        $finsegsemestre = $yeartoday."-12-31";

        // si el empleado ingresó en este periodo
        if($fecingreso>=$inisegsemestre)
        {
            $vsql = " SELECT MAX(periodoid) AS primerojulio FROM periodosnomina WHERE fecdesde <= '".$fecingreso."' ";
            $primerojulio = $clase->SeleccionarUno($vsql);

            $vsql = " SELECT periodoid AS treintayuno FROM periodosnomina WHERE fechasta = '".$finsegsemestre."' ";
            $treintayuno = $clase->SeleccionarUno($vsql);
    
            $vsql = "SELECT IFNULL(SUM(valor),0) AS diasss
                       FROM hisdetallenomina 
                      WHERE terid = ".$terid." 
                            AND conceptoid IN (1,10,11,12,13,23,31,38,40) 
                            AND pernominaid BETWEEN ".$primerojulio." AND ".$treintayuno."
                            AND pernominaid NOT IN (SELECT pernominaid 
                                                      FROM periodoterceros
                                                     WHERE periodoterceros.terid = ".$terid." 
                                                           AND periodoterceros.pernominaid BETWEEN ".$primeroenero." AND ".$treintajunio."
                                                           AND periodoterceros.extralegal = 'CHECKED')";
            $diasss = $clase->SeleccionarUno($vsql);
    
            // Días en la liquidación
            $vsql = "SELECT IFNULL(SUM(valor),0) AS diasliq
                       FROM detalleliquidacion 
                      WHERE terid = ".$terid." 
                            AND conceptoid IN (1,10,11,12,13,23,31,38,40) 
                            AND pernominaid BETWEEN ".$primerojulio." AND ".$treintayuno."";
            $diasliq = $clase->SeleccionarUno($vsql);
    
            $diasss += $diasliq;
        }

        if(($fecingreso<$inisegsemestre)&&($diasps>0))
        {
            $vsql = " SELECT periodoid AS primerojulio FROM periodosnomina WHERE fecdesde = '".$inisegsemestre."' ";
            $primerojulio = $clase->SeleccionarUno($vsql);

            $vsql = " SELECT periodoid AS treintayuno FROM periodosnomina WHERE fechasta = '".$finsegsemestre."' ";
            $treintayuno = $clase->SeleccionarUno($vsql);
    
            $vsql = "SELECT IFNULL(SUM(valor),0) AS diasss
                       FROM hisdetallenomina 
                      WHERE terid = ".$terid." 
                            AND conceptoid IN (1,10,11,12,13,23,31,38,40) 
                            AND pernominaid BETWEEN ".$primerojulio." AND ".$treintayuno."
                            AND pernominaid NOT IN (SELECT pernominaid 
                                                      FROM periodoterceros
                                                     WHERE periodoterceros.terid = ".$terid." 
                                                           AND periodoterceros.pernominaid BETWEEN ".$primeroenero." AND ".$treintajunio."
                                                           AND periodoterceros.extralegal = 'CHECKED')";
            $diasss = $clase->SeleccionarUno($vsql);
    
            // Días en la liquidación
            $vsql = "SELECT IFNULL(SUM(valor),0) AS diasliq
                       FROM detalleliquidacion 
                      WHERE terid = ".$terid." 
                            AND conceptoid IN (1,10,11,12,13,23,31,38,40) 
                            AND pernominaid BETWEEN ".$primerojulio." AND ".$treintayuno."";
            $diasliq = $clase->SeleccionarUno($vsql);
    
            $diasss += $diasliq;
        }

        $cesantiasant = "";                 $cesantiasact = "CHECKED";                  $intcesant = "";
        $intcesact = "CHECKED";             $chkvacaciones = "CHECKED";                 $chkprimasps = "CHECKED";
        $chkprimasss = "CHECKED";           $chklimpiar = "";

        if($diasyearant==0)     $disabled1 = "disabled";
        else                    $disabled1 = "";

        $ingreso = substr($fecingreso,8,2)."/".substr($fecingreso,5,2)."/".substr($fecingreso,0,4);
        $retiro = substr($fecretiro,8,2)."/".substr($fecretiro,5,2)."/".substr($fecretiro,0,4);

        // valido si la liquidación está cerrada
        $vsqldatos = "SELECT norecalcular FROM parametrosliquidacion WHERE terid = ".$terid." AND codperiodo = '".$codperiodo."'";
        $norecalcular = $clase->SeleccionarUno($vsqldatos);

        if($norecalcular == "CHECKED")
            $htmlbotonaceptar= '<table width="400">
                                 <tr class="CabezoteTabla">
                                  <td align="center"> <h3> <font color="red"> Esta liquidaci&oacute;n está cerrada </font> </h3> </form> </td>
                                 </tr>
                                </table>';
        else
            $htmlbotonaceptar= '<table width="400">
                                 <tr class="CabezoteTabla">
                                  <td align="center">                    
                                   <input type="submit" value="aceptar" class="button blue">
                                   </form>
                                  </td>
                                 </tr>
                                </table>';

        // pinto la ventana
        $cont.='<table width="400">
                 <tr class="CabezoteTabla">
                  <td width="10"> &nbsp; </td>
                  <td align="center"> 
                  <b>Calcular<br>cesant&iacute;as, primas y vacaciones</b>
                  </td>
                 </tr> 
                 <tr class="CabezoteTabla">
                  <td width="10"> &nbsp; </td>
                  <td align="left">                    
                   Empleado: <font color="BLUE">'.$nombreemp.'</font><br><br>
                   Fecha de ingreso: <font color="BLUE">'.$ingreso.'</font><br>
                   Fecha de retiro: <font color="BLUE">'.$retiro.'</font><br><br>
                   D&iacute;as laborados año anterior: <font color="BLUE">'.$diasyearant.'</font><br>
                   D&iacute;as laborados primer semestre: <font color="BLUE">'.$diasps.'</font><br>
                   D&iacute;as laborados segundo semestre: <font color="BLUE">'.$diasss.'</font><br><br>
                   Sueldo b&aacute;sico año anterior: <font color="BLUE">'.number_format($basicoant).'</font><br>
                   Auxilio de transporte año anterior: <font color="BLUE">'.number_format($auxtransant).'</font><br>
                   Sueldo integral año anterior: <font color="BLUE">'.number_format($sueldointegralant).'</font><br><br>
                   Sueldo b&aacute;sico año actual: <font color="BLUE">'.number_format($basico).'</font><br>
                   Auxilio de transporte año actual: <font color="BLUE">'.number_format($auxtrans).'</font><br>
                   Sueldo integral año actual: <font color="BLUE">'.number_format($sueldointegralact).'</font><br><br>
                  </td>
                 </tr> 
                </table>
                <form action="?opcion=calconliq" name="y" method="POST">
                <input type="hidden" name="terid" value="'.$terid.'">
                <input type="hidden" name="codperiodo" value="'.$codperiodo.'">
                <input type="hidden" name="periodoid" value="'.$periodoid.'">                
                <input type="hidden" name="sueldointegralact" value="'.$sueldointegralact.'">
                <input type="hidden" name="sueldointegralant" value="'.$sueldointegralant.'">
                <input type="hidden" name="diasyearant" value="'.$diasyearant.'">
                <input type="hidden" name="diasps" value="'.$diasps.'">
                <input type="hidden" name="diasss" value="'.$diasss.'">
                <input type="hidden" name="fecingreso" value="'.$fecingreso.'">
                <input type="hidden" name="listaperiodos" value="'.$listaperiodos.'">
                <table width="400">
                 <tr class="CabezoteTabla">
                  <td width="10"> &nbsp; </td>
                  <td align="left">
                   <input type="checkbox" value="CHECKED" name="cesantiasant" class="Texto11" '.$cesantiasant.' '.$disabled1.'> Cesantías causadas año anterior <br>
                   <input type="checkbox" value="CHECKED" name="cesantiasact" class="Texto11" '.$cesantiasact.'> Cesantías causadas año actual <br>
                   <input type="checkbox" value="CHECKED" name="intcesant" class="Texto11" '.$intcesant.' '.$disabled1.'> Intereses cesantías año anterior <br>
                   <input type="checkbox" value="CHECKED" name="intcesact" class="Texto11" '.$intcesact.'> Intereses cesantías año actual <br>
                   <input type="checkbox" value="CHECKED" name="chkvacaciones" class="Texto11" '.$chkvacaciones.'> Vacaciones <br>
                   <input type="checkbox" value="CHECKED" name="chkprimasps" class="Texto11" '.$chkprimasps.'> Primas primer semestre <br>
                   <input type="checkbox" value="CHECKED" name="chkprimasss" class="Texto11" '.$chkprimasss.'> Primas segundo semestre <br><br>
                   <input type="checkbox" value="CHECKED" name="chklimpiar" class="Texto11" '.$chklimpiar.'> Limpiar datos anteriores <br><br>
                  </td>
                 </tr>
                </table> 
                '.$htmlbotonaceptar.'';
        echo $cont;
        exit();
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: confirelivaca
    // Creación: 20/05/2024		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que pinta la ventana para confirma la eliminación de una 
    //              liquidación
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "confirelivaca")
    {
        $codperiodo = $_GET['codperiodo'];
        $terid = $_GET['terid'];
        $periodoid = $_GET['periodoid'];
        $listaperiodos = $_GET['listaperiodos'];

        // nombre del empleado
        $vsql3 = "SELECT CONCAT(primernombre,' ',segundonombre,' ',primerapellido,' ',segundoapellido) AS nombreemp FROM terceros WHERE terid = ".$terid;
        $nombreemp = $clase->SeleccionarUno($vsql3);

        // Días de vacaciones
        $vsqlcanvacaciones = "SELECT cantidad AS canvacaciones
                                FROM liquidacion
                               WHERE terid=".$terid."
                                     AND periodonomina = '".$codperiodo."' 
                                     AND tipo = 'vacaciones'";
        $canvacaciones = $clase->SeleccionarUno($vsqlcanvacaciones);

        if($canvacaciones==NULL)
            $canvacaciones = 0;

        // Pago de vacaciones
        $vsqlpagovaca = "SELECT pago AS pagovaca
                           FROM liquidacion
                          WHERE terid=".$terid."
                                AND periodonomina = '".$codperiodo."' 
                                AND tipo = 'vacaciones'";
        $pagovaca = $clase->SeleccionarUno($vsqlpagovaca);

        if($pagovaca==NULL)
            $pagovaca = 0;

        // id de las vacaciones
        $vsqlidliquidacion = "SELECT idliquidacion
                                FROM liquidacion
                               WHERE terid=".$terid."
                                     AND periodonomina = '".$codperiodo."' 
                                     AND tipo = 'vacaciones'";
        $idliquidacion = $clase->SeleccionarUno($vsqlidliquidacion);

        // determino si la liquidación está cerrada
        $vsqldatos = "SELECT norecalcular FROM parametrosliquidacion WHERE terid = ".$terid." AND codperiodo = '".$codperiodo."'";
        $norecalcular = $clase->SeleccionarUno($vsqldatos);

        if($norecalcular == "CHECKED")
            $cont ='<table width="500">
                     <tr class="CabezoteTabla"> 
                      <td align="center"><br><b>Eliminar vacaciones</b><br><br></td> 
                     </tr> 
                    </table>
                    <table width="500">
                     <tr class="TablaDocsImPar">       
                      <td width="400" align="center"> <label class="Texto12"> Esta liquidaci&oacute;n est&aacute; cerrada </label> </td>
                     </tr>
                     <tr class="TablaDocsImPar">       
                      <td width="400" align="center"><br><br>                      
                       <input type="hidden" name="idliquidacion" value="'.$idliquidacion.'">
                       <input type="hidden" name="periodoid" value="'.$periodoid.'">                   
                       <input type="hidden" name="codperiodo" value="'.$codperiodo.'">
                       <input type="hidden" name="listaperiodos" value="'.$listaperiodos.'">
                       <input type="hidden" name="terid" value="'.$terid.'">                      
                       <a href="liquidados.php?opcion=editarunaliquidacion&periodoid='.$periodoid.'&terid='.$terid.'&codperiodo='.$codperiodo.'&listaperiodos='.$listaperiodos.'">
                        <input type="button" value="ACEPTAR" class="button blue">
                       </a>
                      </td>        
                     </tr>
                    </table><br>';
        else
            $cont ='<table width="500">
                     <tr class="CabezoteTabla"> 
                      <td align="center"><br><b>Eliminar vacaciones</b><br><br></td> 
                     </tr> 
                    </table>
                    <table width="500">
                     <tr class="TablaDocsImPar">       
                      <td width="400" align="center">¿Confirma que desea eliminar las vacaciones al empleado<br><b> '.$nombreemp.'</b> <br> de <b>'.$canvacaciones.'</b> d&iacute;as por un monto de <b>'.number_format($pagovaca).' </b> pesos?</td>
                     </tr>
                     <tr class="TablaDocsImPar">       
                      <td width="400" align="center"><br><br>
                       <form action="?opcion=eliminarvacaciones" method="POST">
                       <input type="hidden" name="idliquidacion" value="'.$idliquidacion.'">
                       <input type="hidden" name="periodoid" value="'.$periodoid.'">                   
                       <input type="hidden" name="codperiodo" value="'.$codperiodo.'">
                       <input type="hidden" name="listaperiodos" value="'.$listaperiodos.'">
                       <input type="hidden" name="terid" value="'.$terid.'">
                       <input type="submit" value="ACEPTAR" class="button red">
                       <a href="liquidados.php?opcion=editarunaliquidacion&periodoid='.$periodoid.'&terid='.$terid.'&codperiodo='.$codperiodo.'&listaperiodos='.$listaperiodos.'">
                        <input type="button" value="CANCELAR" class="button blue">
                       </a>
                       </form>
                       <br>
                      </td>        
                     </tr>
                    </table><br>';
        echo $cont;
        exit();
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: eliminarvacaciones
    // Creación: 20/05/2024		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que elimina las vacaciones de un empleado
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////        
    if($opcion == "eliminarvacaciones")
    {
        $idliquidacion = $_POST['idliquidacion'];
        $periodoid = $_POST['periodoid'];
        $terid = $_POST['terid'];
        $listaperiodos = $_POST['listaperiodos'];
        $codperiodo = $_POST['codperiodo'];

        // determino si la liquidación está cerrada
        $vsqldatos = "SELECT norecalcular FROM parametrosliquidacion WHERE terid = ".$terid." AND codperiodo = '".$codperiodo."'";
        $norecalcular = $clase->SeleccionarUno($vsqldatos);

        if($norecalcular == "CHECKED")
            $clase->Aviso(3,"Esta liquidación está cerrada");
        else
        {
            $vsql = "DELETE FROM liquidacion WHERE idliquidacion = ".$idliquidacion;
            $clase->EjecutarSQL($vsql);
    
            if(mysql_affected_rows() < 1)
                $clase->Aviso(3,"No se eliminaron las vacaciones");
            else
                $clase->Aviso(1,"Vacaciones eliminadas satisfactoriamente");
        }

        // Redirecciono el formulario
        header("Location: liquidados.php?opcion=editarunaliquidacion&terid=$terid&listaperiodos=$listaperiodos&codperiodo=$codperiodo&periodoid=$periodoid");
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: confireliprima
    // Creación: 20/05/2024		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción para confirmar la eliminación de la prima del empleado
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////    
    if($opcion == "confireliprima")
    {
        $codperiodo = $_GET['codperiodo'];
        $terid = $_GET['terid'];
        $periodoid = $_GET['periodoid'];
        $listaperiodos = $_GET['listaperiodos'];

        // nombre del empleado
        $vsql3 = "SELECT CONCAT(primernombre,' ',segundonombre,' ',primerapellido,' ',segundoapellido) AS nombreemp FROM terceros WHERE terid = ".$terid;
        $nombreemp = $clase->SeleccionarUno($vsql3);

        // Días de la prima
        $vsqlcanprimas = "SELECT cantidad AS canprimas
                            FROM liquidacion
                           WHERE terid = ".$terid."
                                 AND periodonomina = '".$codperiodo."' 
                                 AND tipo = 'primas'";
        $canprimas = $clase->SeleccionarUno($vsqlcanprimas);

        if($canprimas==NULL)
            $canprimas = 0;

        // Pago de la prima
        $vsqlpagoprimas = "SELECT pago AS pagoprimas
                             FROM liquidacion
                            WHERE terid = ".$terid."
                                  AND periodonomina = '".$codperiodo."' 
                                  AND tipo = 'primas'";
        $pagoprimas = $clase->SeleccionarUno($vsqlpagoprimas);

        if($pagoprimas==NULL)
            $pagoprimas = 0;

        // id de la prima
        $vsqlidliquidacion = "SELECT idliquidacion
                                FROM liquidacion
                               WHERE terid = ".$terid."
                                     AND periodonomina = '".$codperiodo."' 
                                     AND tipo = 'primas'";
        $idliquidacion = $clase->SeleccionarUno($vsqlidliquidacion);

        // determino si la liquidación está cerrada
        $vsqldatos = "SELECT norecalcular FROM parametrosliquidacion WHERE terid = ".$terid." AND codperiodo = '".$codperiodo."'";
        $norecalcular = $clase->SeleccionarUno($vsqldatos);

        if($norecalcular == "CHECKED")
            $cont ='<table width="500">
                     <tr class="CabezoteTabla"> 
                      <td align="center"><br><b>Eliminar vacaciones</b><br><br></td> 
                     </tr> 
                    </table>
                    <table width="500">
                     <tr class="TablaDocsImPar">       
                      <td width="400" align="center"> <label class="Texto12"> Esta liquidaci&oacute;n est&aacute; cerrada </label> </td>
                     </tr>
                     <tr class="TablaDocsImPar">       
                      <td width="400" align="center"><br><br>                      
                       <input type="hidden" name="idliquidacion" value="'.$idliquidacion.'">
                       <input type="hidden" name="periodoid" value="'.$periodoid.'">                   
                       <input type="hidden" name="codperiodo" value="'.$codperiodo.'">
                       <input type="hidden" name="listaperiodos" value="'.$listaperiodos.'">
                       <input type="hidden" name="terid" value="'.$terid.'">                      
                       <a href="liquidados.php?opcion=editarunaliquidacion&periodoid='.$periodoid.'&terid='.$terid.'&codperiodo='.$codperiodo.'&listaperiodos='.$listaperiodos.'">
                        <input type="button" value="ACEPTAR" class="button blue">
                       </a>
                      </td>        
                     </tr>
                    </table><br>';
        else
            $cont ='<table width="500">
                     <tr class="CabezoteTabla"> 
                      <td align="center"> <br> <b> Eliminar prima </b> <br> <br> </td> 
                     </tr> 
                    </table>
                    <table width="500">
                     <tr class="TablaDocsImPar">       
                      <td width="400" align="center">¿Confirma que desea eliminar la prima al empleado<br><b> '.$nombreemp.'</b> <br> de <b>'.$canprimas.'</b> d&iacute;as por un monto de <b>'.number_format($pagoprimas).' </b> pesos?</td>
                     </tr>
                     <tr class="TablaDocsImPar">       
                      <td width="400" align="center"><br><br>
                       <form action="?opcion=eliminarprima" method="POST">
                       <input type="hidden" name="idliquidacion" value="'.$idliquidacion.'">
                       <input type="hidden" name="periodoid" value="'.$periodoid.'">
                       <input type="hidden" name="terid" value="'.$terid.'">
                       <input type="hidden" name="codperiodo" value="'.$codperiodo.'">
                       <input type="hidden" name="listaperiodos" value="'.$listaperiodos.'">
                       <input type="submit" value="ACEPTAR" class="button red">
                       <a href="liquidados.php?opcion=editarunaliquidacion&periodoid='.$periodoid.'&terid='.$terid.'&codperiodo='.$codperiodo.'&listaperiodos='.$listaperiodos.'">
                        <input type="button" value="CANCELAR" class="button blue">
                       </a>
                       </form>
                       <br>
                      </td>        
                     </tr>
                    </table><br>';
        echo $cont;
        exit();
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: eliminarprima
    // Creación: 20/05/2024		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que elimina la prima de un empleado
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////        
    if($opcion == "eliminarprima")
    {
        $idliquidacion = $_POST['idliquidacion'];
        $periodoid = $_POST['periodoid'];
        $terid = $_POST['terid'];
        $codperiodo = $_POST['codperiodo'];
        $listaperiodos = $_POST['listaperiodos'];

        // determino si la liquidación está cerrada
        $vsqldatos = "SELECT norecalcular FROM parametrosliquidacion WHERE terid = ".$terid." AND codperiodo = '".$codperiodo."'";
        $norecalcular = $clase->SeleccionarUno($vsqldatos);

        if($norecalcular == "CHECKED")
            $clase->Aviso(3,"Esta liquidación está cerrada");
        else
        {
            $vsql = "DELETE FROM liquidacion WHERE idliquidacion = ".$idliquidacion;
            $clase->EjecutarSQL($vsql);
    
            if(mysql_affected_rows() < 1)
                $clase->Aviso(3,"No se eliminó la prima");
            else
                $clase->Aviso(1,"Prima eliminada satisfactoriamente");
        }

        // Redirecciono el formulario
        header("Location: liquidados.php?opcion=editarunaliquidacion&terid=$terid&listaperiodos=$listaperiodos&codperiodo=$codperiodo&periodoid=$periodoid");
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: confirelicesantia
    // Creación: 20/05/2024		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción para confirmar la eliminación de la cesantía
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////    
    if($opcion == "confirelicesantia")
    {
        $codperiodo = $_GET['codperiodo'];
        $terid = $_GET['terid'];
        $periodoid = $_GET['periodoid'];
        $listaperiodos = $_GET['listaperiodos'];

        // nombre del empleado
        $vsql3 = "SELECT CONCAT(primernombre,' ',segundonombre,' ',primerapellido,' ',segundoapellido) AS nombreemp FROM terceros WHERE terid = ".$terid;
        $nombreemp = $clase->SeleccionarUno($vsql3);

        // Pago de la cesantía
        $vsqlpagocesantia = "SELECT pago AS pagocesantia
                               FROM liquidacion
                              WHERE terid = ".$terid."
                                    AND periodonomina = '".$codperiodo."' 
                                    AND tipo = 'cesantias'";
        $pagocesantia = $clase->SeleccionarUno($vsqlpagocesantia);

        if($pagocesantia==NULL)
            $pagocesantia = 0;

        // Porcentaje cesantía
        $vsqlporccesantia = "SELECT porcentaje AS porccesantia
                               FROM liquidacion
                              WHERE terid = ".$terid."
                                    AND periodonomina = '".$codperiodo."' 
                                    AND tipo = 'cesantias'";
        $porccesantia = $clase->SeleccionarUno($vsqlporccesantia);

        if($porccesantia==NULL)
            $porccesantia = 0;

        // Pago de intereses de cesantías
        $vsqlpagointereses = "SELECT pagointereses AS pagointereses
                                FROM liquidacion
                               WHERE terid = ".$terid."
                                     AND periodonomina = '".$codperiodo."' 
                                     AND tipo = 'cesantias'";
        $pagointereses = $clase->SeleccionarUno($vsqlpagointereses);

        if($pagointereses==NULL)
            $pagointereses = 0;

        // id de la cesantía
        $vsqlidliquidacion = "SELECT idliquidacion
                                FROM liquidacion
                               WHERE terid = ".$terid."
                                     AND periodonomina = '".$codperiodo."' 
                                     AND tipo = 'cesantias'";
        $idliquidacion = $clase->SeleccionarUno($vsqlidliquidacion);

        // determino si la liquidación está cerrada
        $vsqldatos = "SELECT norecalcular FROM parametrosliquidacion WHERE terid = ".$terid." AND codperiodo = '".$codperiodo."'";
        $norecalcular = $clase->SeleccionarUno($vsqldatos);

        if($norecalcular == "CHECKED")
            $cont ='<table width="500">
                     <tr class="CabezoteTabla"> 
                      <td align="center"><br><b>Eliminar vacaciones</b><br><br></td> 
                     </tr> 
                    </table>
                    <table width="500">
                     <tr class="TablaDocsImPar">       
                      <td width="400" align="center"> <label class="Texto12"> Esta liquidaci&oacute;n est&aacute; cerrada </label> </td>
                     </tr>
                     <tr class="TablaDocsImPar">       
                      <td width="400" align="center"><br><br>                      
                       <input type="hidden" name="idliquidacion" value="'.$idliquidacion.'">
                       <input type="hidden" name="periodoid" value="'.$periodoid.'">                   
                       <input type="hidden" name="codperiodo" value="'.$codperiodo.'">
                       <input type="hidden" name="listaperiodos" value="'.$listaperiodos.'">
                       <input type="hidden" name="terid" value="'.$terid.'">                      
                       <a href="liquidados.php?opcion=editarunaliquidacion&periodoid='.$periodoid.'&terid='.$terid.'&codperiodo='.$codperiodo.'&listaperiodos='.$listaperiodos.'">
                        <input type="button" value="ACEPTAR" class="button blue">
                       </a>
                      </td>        
                     </tr>
                    </table><br>';
        else
            $cont ='<table width="500">
                     <tr class="CabezoteTabla"> 
                      <td align="center"><br><b>Eliminar cesant&iacute;a</b><br><br></td> 
                     </tr> 
                    </table>
                    <table width="500">
                     <tr class="TablaDocsImPar">       
                      <td width="400" align="center">¿Confirma que desea eliminar la cesant&iacute;a al empleado<br><b> '.$nombreemp.'</b> <br> por un monto de <b>'.number_format($pagocesantia).' </b> pesos <br> con un porcentaje <b>'.number_format($porccesantia).' </b> % y pago de intereses <b>'.number_format($pagointereses).'</b>?</td>       
                     </tr>
                     <tr class="TablaDocsImPar">       
                      <td width="400" align="center"><br><br>
                       <form action="?opcion=eliminarcesantia" method="POST">
                       <input type="hidden" name="idliquidacion" value="'.$idliquidacion.'">
                       <input type="hidden" name="periodoid" value="'.$periodoid.'">
                       <input type="hidden" name="terid" value="'.$terid.'">
                       <input type="hidden" name="codperiodo" value="'.$codperiodo.'">
                       <input type="hidden" name="listaperiodos" value="'.$listaperiodos.'">                   
                       <input type="submit" value="ACEPTAR" class="button red">
                       <a href="liquidados.php?opcion=editarunaliquidacion&periodoid='.$periodoid.'&terid='.$terid.'&codperiodo='.$codperiodo.'&listaperiodos='.$listaperiodos.'">
                        <input type="button" value="CANCELAR" class="button blue">
                       </a>
                       </form>
                       <br>
                      </td>        
                     </tr>
                    </table><br>';
        echo $cont;
        exit();
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: eliminarcesantia
    // Creación: 20/05/2024		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que elimina la cesantía de un empleado
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////        
    if($opcion == "eliminarcesantia")
    {
        $idliquidacion = $_POST['idliquidacion'];
        $periodoid = $_POST['periodoid'];
        $terid = $_POST['terid'];
        $codperiodo = $_POST['codperiodo'];
        $listaperiodos = $_POST['listaperiodos'];

        // determino si la liquidación está cerrada
        $vsqldatos = "SELECT norecalcular FROM parametrosliquidacion WHERE terid = ".$terid." AND codperiodo = '".$codperiodo."'";
        $norecalcular = $clase->SeleccionarUno($vsqldatos);

        if($norecalcular == "CHECKED")
            $clase->Aviso(3,"Esta liquidación está cerrada");
        else
        {
            $vsql = "DELETE FROM liquidacion WHERE idliquidacion = ".$idliquidacion;
            $clase->EjecutarSQL($vsql);
    
            if(mysql_affected_rows() < 1)
                $clase->Aviso(3,"No se eliminó la cesantía");
            else
                $clase->Aviso(1,"Cesantía eliminada satisfactoriamente");
        }

        // Redirecciono el formulario
        header("Location: liquidados.php?opcion=editarunaliquidacion&terid=$terid&listaperiodos=$listaperiodos&codperiodo=$codperiodo&periodoid=$periodoid");
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: confireliindem
    // Creación: 20/05/2024		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción para confirmar la eliminación de una indemnización
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////    
    if($opcion == "confireliindem")
    {
        $codperiodo = $_GET['codperiodo'];
        $terid = $_GET['terid'];
        $periodoid = $_GET['periodoid'];
        $listaperiodos = $_GET['listaperiodos'];

        // nombre del empleado
        $vsql3 = "SELECT CONCAT(primernombre,' ',segundonombre,' ',primerapellido,' ',segundoapellido) AS nombreemp FROM terceros WHERE terid = ".$terid;
        $nombreemp = $clase->SeleccionarUno($vsql3);

        $vsqlindemnizacion = "SELECT pago AS indemnizacion
                                FROM liquidacion
                               WHERE terid=".$terid."
                                     AND periodonomina = '".$codperiodo."' 
                                     AND tipo = 'indemnizacion'";
        $indemnizacion = $clase->SeleccionarUno($vsqlindemnizacion);

        if($indemnizacion==NULL)
            $indemnizacion=0;

        // id de la cesantía
        $vsqlidliquidacion = "SELECT idliquidacion
                                FROM liquidacion
                               WHERE terid=".$terid."
                                     AND periodonomina = '".$codperiodo."' 
                                     AND tipo = 'indemnizacion'";
        $idliquidacion = $clase->SeleccionarUno($vsqlidliquidacion);

        // determino si la liquidación está cerrada
        $vsqldatos = "SELECT norecalcular FROM parametrosliquidacion WHERE terid = ".$terid." AND codperiodo = '".$codperiodo."'";
        $norecalcular = $clase->SeleccionarUno($vsqldatos);

        if($norecalcular == "CHECKED")
            $cont ='<table width="500">
                     <tr class="CabezoteTabla"> 
                      <td align="center"><br><b>Eliminar vacaciones</b><br><br></td> 
                     </tr> 
                    </table>
                    <table width="500">
                     <tr class="TablaDocsImPar">
                      <td width="400" align="center"> <label class="Texto12"> Esta liquidaci&oacute;n est&aacute; cerrada </label> </td>
                     </tr>
                     <tr class="TablaDocsImPar">
                      <td width="400" align="center"> <br><br>
                       <input type="hidden" name="idliquidacion" value="'.$idliquidacion.'">
                       <input type="hidden" name="periodoid" value="'.$periodoid.'">
                       <input type="hidden" name="codperiodo" value="'.$codperiodo.'">
                       <input type="hidden" name="listaperiodos" value="'.$listaperiodos.'">
                       <input type="hidden" name="terid" value="'.$terid.'">
                       <a href="liquidados.php?opcion=editarunaliquidacion&periodoid='.$periodoid.'&terid='.$terid.'&codperiodo='.$codperiodo.'&listaperiodos='.$listaperiodos.'">
                        <input type="button" value="ACEPTAR" class="button blue">
                       </a>
                      </td>
                     </tr>
                    </table><br>';
        else
            $cont ='<table width="500">
                     <tr class="CabezoteTabla"> 
                      <td align="center"> <br> <b> Eliminar indemnizaci&oacute;n </b> <br><br> </td> 
                     </tr> 
                    </table>
                    <table width="500">
                     <tr class="TablaDocsImPar">
                      <td width="400" align="center">
                       ¿Confirma que desea eliminar la indemnizaci&oacute;n al empleado<br><b> '.$nombreemp.'</b> <br> por un monto de <b> '.number_format($indemnizacion).' </b>pesos?
                      </td>
                     </tr>
                     <tr class="TablaDocsImPar">
                      <td width="400" align="center"> <br><br>
                       <form action="?opcion=eliminarinde" method="POST">
                       <input type="hidden" name="idliquidacion" value="'.$idliquidacion.'">
                       <input type="hidden" name="periodoid" value="'.$periodoid.'">
                       <input type="hidden" name="terid" value="'.$terid.'">
                       <input type="hidden" name="codperiodo" value="'.$codperiodo.'">
                       <input type="hidden" name="listaperiodos" value="'.$listaperiodos.'">
                       <input type="submit" value="ACEPTAR" class="button red">
                       <a href="liquidados.php?opcion=editarunaliquidacion&periodoid='.$periodoid.'&terid='.$terid.'&codperiodo='.$codperiodo.'&listaperiodos='.$listaperiodos.'">
                        <input type="button" value="CANCELAR" class="button blue">
                       </a>
                       </form>
                       <br>
                      </td>
                     </tr>
                    </table><br>';
        echo $cont;
        exit();
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: eliminarinde
    // Creación: 20/05/2024		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que elimina la indemnización de un empleado
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////        
    if($opcion == "eliminarinde")
    {
        $idliquidacion = $_POST['idliquidacion'];
        $periodoid = $_POST['periodoid'];
        $terid = $_POST['terid'];
        $codperiodo = $_POST['codperiodo'];
        $listaperiodos = $_POST['listaperiodos'];

        // determino si la liquidación está cerrada
        $vsqldatos = "SELECT norecalcular FROM parametrosliquidacion WHERE terid = ".$terid." AND codperiodo = '".$codperiodo."'";
        $norecalcular = $clase->SeleccionarUno($vsqldatos);

        if($norecalcular == "CHECKED")
            $clase->Aviso(3,"Esta liquidación está cerrada");
        else
        {
            $vsql = "DELETE FROM liquidacion WHERE idliquidacion = ".$idliquidacion;
            $clase->EjecutarSQL($vsql);
    
            if(mysql_affected_rows() < 1)
                $clase->Aviso(3,"No se eliminó la indemnización");
            else
                $clase->Aviso(1,"Indemnización eliminada satisfactoriamente");
        }

        // Redirecciono el formulario
        header("Location: liquidados.php?opcion=editarunaliquidacion&terid=$terid&listaperiodos=$listaperiodos&codperiodo=$codperiodo&periodoid=$periodoid");
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: confirmarelim
    // Creación: 20/05/2024		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción para confirmar la eliminación de toda una liquidación
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////        
    if($opcion == "confirmarelim")
    {
        $terid = $_GET['terid'];
        $codperiodo = $_GET['codperiodo'];

        // obtengo el nombre del empleado
        $vsql = "SELECT nombre FROM tmpinfliquidados WHERE terid = ".$terid." AND codperiodo = '".$codperiodo."'";
        // echo $vsql; exit();
        $nombreemp = $clase->SeleccionarUno($vsql);

        // obtengo el nombre del periodo
        $desperiodo = $clase->BDLockup($codperiodo,'periodos','codperiodo','desperiodo');

        // Pintamos la ventana

        // determino si la liquidación está cerrada
        $vsqldatos = "SELECT norecalcular FROM parametrosliquidacion WHERE terid = ".$terid." AND codperiodo = '".$codperiodo."'";
        $norecalcular = $clase->SeleccionarUno($vsqldatos);

        if($norecalcular == "CHECKED")
            $cont ='<table width="500">
                     <tr class="CabezoteTabla"> 
                      <td align="center"><br> <b> Eliminar vacaciones </b> <br><br> </td> 
                     </tr> 
                    </table>
                    <table width="500">
                     <tr class="TablaDocsImPar">       
                      <td width="400" align="center"> <label class="Texto12"> Esta liquidaci&oacute;n est&aacute; cerrada </label> </td>
                     </tr>
                     <tr class="TablaDocsImPar">       
                      <td width="400" align="center"> <br><br> 
                       <a href="liquidados.php">
                        <input type="button" value="ACEPTAR" class="button blue">
                       </a>
                      </td>        
                     </tr>
                    </table><br>';
        else        
            $cont ='<table width="500">
                     <tr class="CabezoteTabla"> 
                      <td align="center"> <br> <b> Eliminar liquidaci&oacute;n </b> <br><br> </td> 
                     </tr> 
                    </table>
                    <table width="500">
                     <tr class="TablaDocsImPar">       
                      <td width="400" align="center"> 
                       <label class="Texto12"> ¿Confirma que desea eliminar la liquidaci&oacute;n del empleado<br> <b> '.$nombreemp.'</b> <br> en el periodo <b>'.$desperiodo.'</b>? </label> 
                      </td>
                     </tr>
                     <tr class="TablaDocsImPar">       
                      <td width="400" align="center"><br><br>
                       <form action="?opcion=eliminarliq" method="POST">
                       <input type="hidden" name="terid" value="'.$terid.'">                       
                       <input type="hidden" name="codperiodo" value="'.$codperiodo.'">                       
                       <input type="submit" value="ACEPTAR" class="button red">
                       <a href="liquidados.php">
                        <input type="button" value="CANCELAR" class="button blue">
                       </a>
                       </form>
                       <br>
                      </td>        
                     </tr>
                    </table><br>';
        echo $cont;
        exit();
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opciones: eliminarliq
    // Creación: 13/12/2021		última modificación: 04/04/2024
    // Creador: Luis Flórez		modificado por: Luis Flórez
    // Descripción: Opción que elimina completamente una liquidación de un empleado
    // Última modificación: Eliminación del registro en la tabla de parámetros de 
    //                      liquidación (19/02/2024)
    //                      Se revirtió la eliminación de la tabla parámetros de liquidación
    ////////////////////////////////////////////////////////////////////////////////////////        
    if($opcion == "eliminarliq")
    {
        $terid = $_POST['terid'];
        $codperiodo = $_POST['codperiodo'];

        // lista de quincenas del periodo
        $listaperiodos = generarlistaper($codperiodo);

        // Elimino los registros en el detalle de liquidación
        $vsql = "DELETE FROM detalleliquidacion WHERE pernominaid IN ($listaperiodos) AND terid = ".$terid;
        $clase->EjecutarSQL($vsql);

        // Elimino los registros en la tabla de liquidación
        $vsql = "DELETE FROM liquidacion WHERE periodonomina = '".$codperiodo."' AND terid = ".$terid;
        $clase->EjecutarSQL($vsql);

        // elimino en la tabla parametrosliquidacion
        $vsql = "DELETE FROM parametrosliquidacion WHERE codperiodo = '".$codperiodo."' AND terid = ".$terid;
        $clase->EjecutarSQL($vsql);

        // elimino en la tabla del informe
        $vsql = "DELETE FROM tmpinfliquidados WHERE codperiodo = '".$codperiodo."' AND terid = ".$terid;
        $clase->EjecutarSQL($vsql);

        // Emito el mensaje correspondiente
        $clase->Aviso(1,"Liquidación eliminada exitosamente");

        // Redirecciono el formulario
        header("Location: liquidados.php");
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: calconliq
    // Creación: 20/05/2024		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que calcula las vacaciones, primas y cesantías
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "calconliq")
    {
        $terid = $_POST['terid'];
        $codperiodo = $_POST['codperiodo'];
        $periodoid = $_POST['periodoid'];
        $sueldointegralact = $_POST['sueldointegralact'];
        $sueldointegralant = $_POST['sueldointegralant'];
        $diasyearant = $_POST['diasyearant'];
        $diasps = $_POST['diasps'];
        $diasss = $_POST['diasss'];
        $cesantiasant = $_POST['cesantiasant'];
        $cesantiasact = $_POST['cesantiasact'];
        $intcesant = $_POST['intcesant'];
        $intcesact = $_POST['intcesact'];
        $chkvacaciones = $_POST['chkvacaciones'];
        $chkprimasps = $_POST['chkprimasps'];
        $chkprimasss = $_POST['chkprimasss'];
        $chklimpiar = $_POST['chklimpiar'];
        $fecingreso = $_POST['fecingreso'];
        $listaperiodos = $_POST['listaperiodos'];

        // Inicialización de variables
        $pagocenact = 0;                            $cantidad = 0;                          $porcentaje = 0;                        $pagointereses = 0;
        $pagovaca = 0;                              $diasvaca = 0;                          $diasprima = 0;                         $pagoprimasps = 0;
        $lbprocesado = false;                       $pagocesant = 0;                        $cantidadact = 0;                       $cantidadant = 0;
        $pagocesantias = 0;                         $interesesact = 0;                      $interesesant = 0;                      $pagoprimasss = 0;
        $pagoprimas = 0;

        // ---------------------------------------------------------- //
        // Limpio los datos de cesantías, primas y vacaciones que 
        // existieran antes de este cálculo para evitar duplicados
        if($chklimpiar == "CHECKED")
        {
            // Limpio la tabla liquidación
            $vsql = "DELETE FROM liquidacion WHERE terid = ".$terid." AND periodonomina = '".$codperiodo."'";
            $clase->EjecutarSQL($vsql);

            // Limpio la tabla para la impresión de la liquidación
            $vsql = "DELETE FROM impresionliquidacion WHERE terid = ".$terid." AND periodonomina = '".$codperiodo."'";
            $clase->EjecutarSQL($vsql);
        }

        // ---------------------------------------------------------- //
        // Cálculo de cesantías
        if(($cesantiasact == "CHECKED")||($cesantiasant == "CHECKED")||($intcesact == "CHECKED")||($intcesant == "CHECKED"))
        {
            // Cálculo de cesantías del año actual
            if($cesantiasact == "CHECKED")
            {
                $cantidadact = $diasps + $diasss;
                $pagocenact = $sueldointegralact * $cantidadact / 360;
            }
            else
            {
                $pagocenact = 0;
                $cantidadact = 0;
            }
            
            // Cálculo de cesantías del año anterior
            if($cesantiasant == "CHECKED")
            {
                $pagocesant = $sueldointegralant * $diasyearant / 360;
                $cantidadant = $diasyearant;
            }
            else
            {
                $pagocesant = 0;
                $cantidadant = 0;
            }
            
            // sub totales
            $pagocesantias = $pagocenact + $pagocesant;
            $pagocesantias = round($pagocesantias,2);
            $cantidad = $cantidadact + $cantidadant;
            $porcentaje = 12;

            // Intereses año actual
            if($intcesact == "CHECKED")
                $interesesact = (($pagocenact * ($diasps + $diasss)) * 0.12 / 360);
            else
                $interesesact = 0;

            // intereses del año anterior
            if($intcesant == "CHECKED")
                $interesesant = (($pagocesant * $diasyearant) * 0.12 / 360);
            else
                $interesesant = 0;

            $pagointereses = $interesesact + $interesesant;
            $pagointereses = round($pagointereses,2);

            // Guardo en la tabla
            $vsql = "INSERT INTO liquidacion (periodonomina, terid, tipo, pago, cantidad, porcentaje, pagointereses) 
                                      VALUES ('".$codperiodo."',".$terid.",'cesantias',".$pagocesantias.",".$cantidad.",".$porcentaje.",".$pagointereses.")";
            $clase->EjecutarSQL($vsql);

            if(mysql_affected_rows() >= 1)
                $lbprocesado = true;
        }

        // ---------------------------------------------------------- //
        // Cálculo de vacaciones
        if($chkvacaciones == "CHECKED")
        {
            // Determino si hay vacaciones canceladas previamente
            $vsql22 = "SELECT MIN(periodoid) permin
                         FROM periodosnomina 
                        WHERE fecdesde >= '".$fecingreso."' 
                              AND cerrado = 'CHECKED' ";
            $permin = $clase->SeleccionarUno($vsql22);

            // Determino si hay vacaciones canceladas previamente
            $vsql23 = "SELECT MAX(periodoid) permax
                         FROM periodosnomina 
                        WHERE fecdesde >= '".$fecingreso."' 
                              AND cerrado = 'CHECKED' ";
            $permax = $clase->SeleccionarUno($vsql23);

            $vsql24 = "SELECT pernominaid pervacaciones
                         FROM hisdetallenomina 
                        WHERE terid = ".$terid."         
                              AND conceptoid = 38 
                              AND pernominaid >= ".$permin." AND pernominaid <= ".$permax."";
            $pervacaciones = $clase->SeleccionarUno($vsql24);

            if(strlen($pervacaciones) > 0)
            {
                $pervacaciones++;

                $vsql31 = "SELECT IFNULL(SUM(valor),0) AS diasvaca  
                             FROM hisdetallenomina 
                            WHERE terid = ".$terid."         
                                  AND (pernominaid >= ".$pervacaciones." AND pernominaid <= ".$permax.")  
                                  AND conceptoid IN (1,10,11,12,13,23,31,38,40)";
                $diasvaca = $clase->SeleccionarUno($vsql31);
            }
            else
                $diasvaca = $diasyearant + $diasps + $diasss;
            
            // ---------------------------------------------------------- //
            
            // sueldo básico
            $basico = $clase->BDLockup($terid,'terceros','terid','basico');
            // $pagovaca = $basico * ($diasyearant + $diasps + $diasss) / 720;

            $pagovaca = $basico * $diasvaca / 720;

            $pagovaca = round($pagovaca,2);
            // $diasvaca = $diasyearant + $diasps + $diasss;

            // Almaceno en la tabla
            $vsql = "INSERT INTO liquidacion (periodonomina, terid, tipo, pago, cantidad, porcentaje, pagointereses) 
                                      VALUES ('".$codperiodo."',".$terid.",'vacaciones',".$pagovaca.",".$diasvaca.",0,0)";
            $clase->EjecutarSQL($vsql);

            if(mysql_affected_rows() >= 1)
                $lbprocesado = true;
        }
        
        // ---------------------------------------------------------- //
        // Cálculo de primas
        if(($chkprimasps == "CHECKED") || ($chkprimasss == "CHECKED"))
        {
            // Primas primer semestre
            if($chkprimasps == "CHECKED")
            {
                $diasprima += $diasps;
                $pagoprimasps = $sueldointegralact * $diasps / 360;
            }

            // Primas segundo semestre
            if($chkprimasss == "CHECKED")
            {
                $diasprima += $diasss;
                $pagoprimasss = $sueldointegralact * $diasss / 360;
            }

            $pagoprimas = $pagoprimasps + $pagoprimasss;
            $pagoprimas = round($pagoprimas,2);

            // Almaceno en la tabla
            $vsql = "INSERT INTO liquidacion (periodonomina, terid, tipo, pago, cantidad, porcentaje, pagointereses) 
                                      VALUES ('".$codperiodo."',".$terid.",'primas',".$pagoprimas.",".$diasprima.",0,0)";
            $clase->EjecutarSQL($vsql);

            if(mysql_affected_rows() >= 1)
                $lbprocesado = true;
        }

        // -------------------------------------------------------------------------- //
        // Guardo la configuración de impresión y emito el mensaje correspondiente
        if($lbprocesado)
        {
            // limpio
            $vsql2 = "DELETE FROM impresionliquidacion WHERE terid = ".$terid." AND periodonomina = '".$codperiodo."'";
            $clase->EjecutarSQL($vsql2);

            // guardo
            $vsql = "INSERT INTO impresionliquidacion (periodonomina,terid,cesantiasant,cesantiasact,intcesant,intcesact,vacaciones,primasps,primasss) 
                                                VALUE ('".$codperiodo."',".$terid.",'".$cesantiasant."','".$cesantiasact."','".$intcesant."',
                                                       '".$intcesact."','".$chkvacaciones."','".$chkprimasps."','".$chkprimasss."')";
            $clase->EjecutarSQL($vsql);

            // mensaje
            $clase->Aviso(1,"Datos almacenados satisfactoriamente");
        }
        else
            $clase->Aviso(3,"No se almacenaron los datos");
        
        // -------------------------------------------------------------------------- //

        // Redirecciono el formulario
        header("Location: liquidados.php?opcion=editarunaliquidacion&terid=$terid&listaperiodos=$listaperiodos&codperiodo=$codperiodo&periodoid=$periodoid");
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: confirmarlimpiarliq
    // Creación: 21/05/2024		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que pinta la ventana para confirmar la eliminación de todas las 
    //              liquidaciones del periodo actual
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "confirmarlimpiarliq")
    {
        $codperiodo = $_GET['codperiodo'];
        
        // nombre del periodo
        $desperiodo = $clase->BDLockup($codperiodo,'periodos','codperiodo','desperiodo');
        
        // Pinto la ventana
        $cont ='<table width="500">
                 <tr class="CabezoteTabla">
                  <td width="50" align="left"> <img src="images/iconos/alertas.png" width="32" height="32" border="0"> </td>
                  <td width="450" align="center"><br> <label class="Texto12"> <b> Eliminar liquidaciones </b> </label> <br><br> </td>
                 </tr> 
                </table>
                <table width="500">
                 <tr class="TablaDocsImPar"> 
                  <td width="400" align="center">
                   <label class="Texto12">¿Confirma que desea eliminar todas las liquidaciones del periodo <br> <b>'.trim($desperiodo).'</b>? <br><br> Esta operaci&oacute;n no podrá ser revertida </label> 
                  </td>
                 </tr>
                 <tr class="TablaDocsImPar">
                  <td width="400" align="center"><br><br> 
                   <form action="?opcion=eliminarallliquidaciones" method="POST">
                   <input type="hidden" name="codperiodo" value="'.$codperiodo.'"> 
                   <input type="submit" value="ACEPTAR" class="button blue">
                   <a href="liquidados.php" > <input type="button" value="CANCELAR" class="button red"> </a>
                   </form>
                   <br>
                  </td> 
                 </tr>
                </table>';
        echo $cont;
        exit();
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: eliminarallliquidaciones
    // Creación: 21/05/2024		última modificación: 05/09/2024
    // Creador: Luis Flórez		modificado por: Luis Flórez
    // Descripción: Opción que elimina todas las liquidaciones del periodo actual
    // Última modificación: Inclusión de la nueva tabla para el informe
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "eliminarallliquidaciones")
    {
        $codperiodo = $_POST['codperiodo'];

        $listaperiodos = generarlistaper($codperiodo);

		// Elimino las liquidaciones
		$vsql = "DELETE FROM liquidacion WHERE periodonomina = '".$codperiodo."' AND terid NOT IN (SELECT terid 
                                                                                                     FROM parametrosliquidacion 
                                                                                                    WHERE codperiodo = '".$codperiodo."'
                                                                                                          AND norecalcular = 'CHECKED')";
		$clase->EjecutarSQL($vsql);

		// Elimino las quincenas procesadas en las liquidaciones
		$vsql2 = "DELETE FROM detalleliquidacion WHERE pernominaid IN ($listaperiodos) AND terid NOT IN (SELECT terid 
                                                                                                           FROM parametrosliquidacion 
                                                                                                          WHERE codperiodo = '".$codperiodo."'
                                                                                                            AND norecalcular = 'CHECKED')";
		$clase->EjecutarSQL($vsql2);

        // elimino en la tabla del informe
        $vsql4 = "DELETE FROM tmpinfliquidados WHERE codperiodo = '".$codperiodo."' AND terid NOT IN (SELECT terid 
                                                                                                        FROM parametrosliquidacion 
                                                                                                       WHERE codperiodo = '".$codperiodo."'
                                                                                                             AND norecalcular = 'CHECKED')";
        $clase->EjecutarSQL($vsql4);

		// Elimino los parámetros de liquidación
		$vsql3 = "DELETE FROM parametrosliquidacion WHERE codperiodo = '".$codperiodo."' AND norecalcular <> 'CHECKED'";
		$clase->EjecutarSQL($vsql3);        

        // emito el mensaje correspondiente
        $clase->Aviso(1,"Liquidaciones eliminadas exitosamente");

        // Redirecciono el formulario
        header("Location: liquidados.php");
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opciones: incluirconcepto
    // Creación: 21/05/2024		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Ventana para la inclusión de conceptos para los liquidados
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "incluirconcepto")
    {
        $periodoid = $_GET['periodoid'];
        $terid = $_GET['terid'];
        $idliquidados = $_GET['idliquidados'];
        $codperiodo = $_GET['codperiodo'];

        // $descripcion  = $clase->BDLockup($periodoid,'periodosnomina','periodoid','descripcion');

        // nombre del periodo
        $desperiodo = $clase->BDLockup($codperiodo,'periodos','codperiodo','desperiodo');

        // Nombre del empleado
        $sqlnomemp = "SELECT CONCAT(primernombre,' ',segundonombre,' ',primerapellido,' ',segundoapellido) AS nombreemp 
                        FROM terceros 
                       WHERE terid = ".$terid;
        $nombreemp = $clase->SeleccionarUno($sqlnomemp);

        // Conceptos para liquidados
        $vsqlcombooca = "SELECT conceptoid, CONCAT(codconcepto,' - ',nomconcepto) 
                           FROM conceptosnomina 
                          WHERE (montoocasional = 'CHECKED' OR montopermanente = 'CHECKED' OR eslibranza = 'CHECKED')
                       ORDER BY conceptoid";

        $comboconceptos = $clase->CrearComboBuscar("conceptoid",$vsqlcombooca,"nombres","conceptoid","","N",$params,420);

        $params = ' class="Texto11" ';
        $monto = 1;
        
        // determino si la liquidación está cerrada
        $vsqldatos = "SELECT norecalcular FROM parametrosliquidacion WHERE terid = ".$terid." AND codperiodo = '".$codperiodo."'";
        $norecalcular = $clase->SeleccionarUno($vsqldatos);

        if($norecalcular == "CHECKED")
            $cont ='<table width="500">
                     <tr class="CabezoteTabla"> 
                      <td align="center"> <br> <b> Inclusi&oacute;n de conceptos para liquidados </b> <br><br> </td> 
                     </tr> 
                    </table>
                    <table width="500">
                     <tr class="TablaDocsImPar">       
                      <td width="400" align="center"> <label class="Texto12"> Esta liquidaci&oacute;n est&aacute; cerrada </label> </td>
                     </tr>
                     <tr class="TablaDocsImPar">       
                      <td width="400" align="center"><br><br>                      
                       <input type="hidden" name="codperiodo" value="'.$codperiodo.'">                       
                       <input type="hidden" name="terid" value="'.$terid.'">                      
                       <a href="liquidados.php?opcion=editarliquidacion&terid='.$terid.'&codperiodo='.$codperiodo.'">
                        <input type="button" value="ACEPTAR" class="button blue">
                       </a>
                      </td>        
                     </tr>
                    </table><br>';
        else        
            $cont= '<table width="500">
                     <tr class="CabezoteTabla">                   
                      <td width="50" align="left"> <img src="images/iconos/egresos.png" width="32" height="32" border="0"> </td>
                      <td width="450" align="center"> <label class="Texto12"> <b> Inclusi&oacute;n de conceptos para liquidados </b> <br> <font color="blue"> '.$desperiodo.' </font> </label> </td>                  
                     </tr>
                    </table>
                    <form action="?opcion=guardarconliq" method="POST">
                    <input type="hidden" name="periodoid" value="'.$periodoid.'">
                    <input type="hidden" name="terid" value="'.$terid.'">
                    <input type="hidden" name="idliquidados" value="'.$idliquidados.'">
                    <input type="hidden" name="codperiodo" value="'.$codperiodo.'">
                    <table width="500">
                     <tr class="BarraDocumentos" style="height:60px;Important!"> 
                      <td width="10"> &nbsp; </td>
                      <td width="490" align="left"> <label class="Texto12"> <b>Empleado: </b> <br>'.$nombreemp.' </label> </td>
                     </tr>
                     <tr class="BarraDocumentos" style="height:60px;Important!"> 
                      <td width="20"> &nbsp; </td>
                      <td width="480" align="left"> <label class="Texto12"> <b>Concepto:</b> </label> <br> '.$comboconceptos.' </td>
                     </tr>
                     <tr class="BarraDocumentos" style="height:60px;Important!"> 
                      <td width="20"> &nbsp; </td>
                      <td width="480" align="left"> 
                       <label class="Texto12"> <b> Monto: </b> </label> <br> 
                       <input type="number" name="monto" min="1" class="Texto12New" size="20" style="width:150px;height:25px;" autocomplete="off" title="monto a descontar" value="'.$monto.'">
                      </td>
                     </tr>
                    </table>
                    <table width="500">
                     <tr class="BarraDocumentos" style="height:50px;Important!"> 
                      <td width="480" align="center">
                       <input type="submit" value="ACEPTAR" class="button blue">
                       <a href="liquidados.php?opcion=editarliquidacion&terid='.$terid.'&codperiodo='.$codperiodo.'">
                        <input type="button" value="CANCELAR" class="button red">
                       </a>
                       </form>
                      </td>
                     </tr>
                    </table>';
        echo $cont;
        exit();
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opciones: guardarconliq
    // Creación: 18/09/2024		última modificación: 
    // Creador: Luis Flórez		modificado por: Luis Flórez
    // Descripción: Opción para guardar en la tabla correspondiente el concepto para 
    //              liquidados
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////    
    if($opcion == "guardarconliq")
    {
        $periodoid = $_POST['periodoid'];
        $conceptoid = $_POST['conceptoid'];
        $terid = $_POST['terid'];
        $monto = $_POST['monto'];
        $idliquidados = $_POST['idliquidados'];
        $codperiodo = $_POST['codperiodo'];               

        // Validación para no repetir un concepto
        $vsql2 = "SELECT COUNT(*) AS numregistro 
                    FROM detalleliquidacion 
                   WHERE terid = ".$terid." 
                         AND conceptoid = ".$conceptoid." 
                         AND pernominaid = '".$periodoid;
        $numregistro = $clase->SeleccionarUno($vsql2);

        if($numregistro>0)
        {
            $vsql3 = "SELECT CONCAT(primernombre,' ',segundonombre,' ',primerapellido,' ',segundoapellido) AS nombreemp FROM terceros WHERE terid = ".$terid;
            $nombreemp = $clase->SeleccionarUno($vsql3);

            $vsql4 = "SELECT nomconcepto FROM conceptosnomina WHERE conceptoid = ".$conceptoid;
            $nomconcepto = $clase->SeleccionarUno($vsql4);

            $clase->Aviso(3,"$nombreemp ya tiene $nomconcepto en este periodo");
        }
        else
        {
            // Obtengo el número de registros de la tabla detallenomina
            $vsql = "SELECT MAX(detalleid) FROM detalleliquidacion";
            $numeroid = $clase->SeleccionarUno($vsql);
    
            // Incremento el ID
            $numeroid++;
    
            $tipodc = $clase->BDLockup($conceptoid,'conceptosnomina','conceptoid','tipodc');
        
            // Almaceno en la tabla detalleliquidacion
            if($tipodc=="C")
                $vsql = "INSERT INTO detalleliquidacion (detalleid,terid,conceptoid,pernominaid,devengados,descuentos,valor,saldo) 
                                                 VALUES ($numeroid,".$terid.",".$conceptoid.",".$periodoid.",".$monto.",0,0,0)";
            else
                $vsql = "INSERT INTO detalleliquidacion (detalleid,terid,conceptoid,pernominaid,devengados,descuentos,valor,saldo) 
                                                VALUES ($numeroid,".$terid.",".$conceptoid.",".$periodoid.",0,".$monto.",0,0)";
    
            // almaceno la información
            $clase->EjecutarSQL($vsql);

            // elimino los registros duplicados
            $vsql = "SELECT COUNT(*) AS numrepetidas 
                       FROM detalleliquidacion 
                      WHERE terid = ".$terid." 
                            AND conceptoid = '".$conceptoid."' 
                            AND pernominaid = '".$periodoid;
            $numrepetidas = $clase->SeleccionarUno($vsq);

            if($numrepetidas >  1)
            {
                $vsql = "SELECT MAX(detalleid) 
                           FROM detalleliquidacion 
                          WHERE terid = ".$terid." 
                                AND conceptoid = ".$conceptoid." 
                                AND pernominaid = '".$periodoid;
                $detalleidrepetido = $clase->SeleccionarUno($vsq);

                $vsql = "DELETE FROM detalleliquidacion WHERE detalleid = ".$detalleidrepetido;
                $clase->EjecutarSQL($vsql);
            }

            // actualizo los totales
            $sueldo = $clase->BDLockup($idliquidados,'tmpinfliquidados','idliquidados','sueldo');
            $subsidiotransporte = $clase->BDLockup($idliquidados,'tmpinfliquidados','idliquidados','subsidiotransporte');
            $pagovaca = $clase->BDLockup($idliquidados,'tmpinfliquidados','idliquidados','pagovaca');
            $pagoprima = $clase->BDLockup($idliquidados,'tmpinfliquidados','idliquidados','pagoprima');
            $pagocedesantias = $clase->BDLockup($idliquidados,'tmpinfliquidados','idliquidados','pagocedesantias');
            $pagointereses = $clase->BDLockup($idliquidados,'tmpinfliquidados','idliquidados','pagointereses');
            $indemnizacion = $clase->BDLockup($idliquidados,'tmpinfliquidados','idliquidados','indemnizacion');
            
            // lista de quincenas del periodo
            $listaperiodos = generarlistaper($codperiodo);
            
            // otros devengados
            $vsq22 = "SELECT SUM(IF(devengados>0,devengados,0)) otrosdevengados
                        FROM detalleliquidacion 
                       WHERE terid = ".$terid." 
                             AND pernominaid IN ($listaperiodos)
                             AND conceptoid NOT IN (1,3)";
            $otrosdevengados = $clase->SeleccionarUno($vsq22);

            $totaldevengado = $sueldo + $subsidiotransporte + $pagovaca + $pagoprima + $pagocedesantias + $pagointereses + $indemnizacion + $otrosdevengados;

            $pension = $clase->BDLockup($idliquidados,'tmpinfliquidados','idliquidados','pension');
            $salud = $clase->BDLockup($idliquidados,'tmpinfliquidados','idliquidados','salud');

            // otros descuentos
            $vsq23 = "SELECT SUM(IF(descuentos>0,descuentos,0)) otrosdescuentos
                        FROM detalleliquidacion 
                       WHERE terid = ".$terid." 
                             AND pernominaid IN ($listaperiodos) 
                             AND conceptoid NOT IN (4,5,6,9,43,58)";
            $otrosdescuentos = $clase->SeleccionarUno($vsq23);
            
            // total descuento
            $totaldescuento = $pension + $salud + $otrosdescuentos;

            // neto a pagar
            $netoapagar = $totaldevengado - $totaldescuento;

            // grabo los totales
            $vsql = "UPDATE tmpinfliquidados SET 
                            otrosdevengados = ".$otrosdevengados.", 
                            otrosdescuentos = ".$otrosdescuentos.",
                            totaldevengado = ".$totaldevengado.",
                            totaldescuento = ".$totaldescuento.",
                            netoapagar = ".$netoapagar."
                      WHERE idliquidados = ".$idliquidados;
            $clase->EjecutarSQL($vsql);
    
            // Envío el mensaje correspondiente
            $clase->Aviso(1,"Concepto procesado exitosamente");
        }

        // Redirecciono el formulario
        header("Location: liquidados.php?opcion=editarliquidacion&terid=$terid&codperiodo=$codperiodo");
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: editarlicencia
    // Creación: 21/05/2024		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que pinta la ventana para captar los datos de la licencia
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "editarlicencia")
    {
        $terid = $_GET['terid'];
        $periodoid = $_GET['periodoid'];
        $idliquidados = $_GET['idliquidados'];
        $codperiodo = $_GET['codperiodo'];

        // nombre del periodo
        $desperiodo = $clase->BDLockup($codperiodo,'periodos','codperiodo','desperiodo');
        
        // nombre del empleado
        $nombre = $clase->BDLockup($idliquidados,'tmpinfliquidados','idliquidados','nombre');

        // Combo de licencias
        $params = ' class="Texto11" ';
        $vsqlcombolic = "SELECT conceptoid, CONCAT(codconcepto,' - ',nomconcepto) FROM conceptosnomina WHERE eslicencia='CHECKED' ORDER BY conceptoid";
        $combolicencias = $clase->CrearComboBuscar("conceptoid",$vsqlcombolic,"nombres","conceptoid","","N",$params,350);

        $dias = 1;

        // determino si la liquidación está cerrada
        $vsqldatos = "SELECT norecalcular FROM parametrosliquidacion WHERE terid = ".$terid." AND codperiodo = '".$codperiodo."'";
        $norecalcular = $clase->SeleccionarUno($vsqldatos);
        
        if($norecalcular == "CHECKED")
            $cont ='<table width="500">
                     <tr class="CabezoteTabla"> 
                      <td align="center"><br> <b>Eliminar vacaciones</b> <br><br> </td> 
                     </tr> 
                    </table>
                    <table width="500">
                     <tr class="TablaDocsImPar">       
                      <td width="400" align="center"> <label class="Texto12"> Esta liquidaci&oacute;n est&aacute; cerrada </label> </td>
                     </tr>
                     <tr class="TablaDocsImPar">       
                      <td width="400" align="center"><br><br>                       
                       <input type="hidden" name="codperiodo" value="'.$codperiodo.'">                       
                       <input type="hidden" name="terid" value="'.$terid.'">                      
                       <a href="liquidados.php?opcion=editarliquidacion&terid='.$terid.'&codperiodo='.$codperiodo.'">
                        <input type="button" value="ACEPTAR" class="button blue">
                       </a>
                      </td>        
                     </tr>
                    </table><br>';
        else
            $cont= '<table width="500">
                     <tr class="CabezoteTabla">
                      <td width="50" align="left"> <img src="images/iconos/calculando.png" width="32" height="32" border="0"> </td>
                      <td width="450" align="center"> <label class="Texto12"> <b>Inclusi&oacute;n de licencia para liquidados <br> <font color="blue"> '.$desperiodo.' </font> </b> </label> </td>
                     </tr>
                    </table>
                    <form action="?opcion=almlicencias" method="POST">
                    <input type="hidden" name="periodoid" value="'.$periodoid.'">
                    <input type="hidden" name="terid" value="'.$terid.'">
                    <input type="hidden" name="codperiodo" value="'.$codperiodo.'">
                    <input type="hidden" name="idliquidados" value="'.$idliquidados.'">                    
                    <table width="500">
                     <tr class="BarraDocumentos" style="height:60px;Important!"> 
                      <td width="20"> &nbsp; </td>
                      <td width="480" align="left"> <label class="Texto12"> <b> Empleado: </b> <br>'.$nombre.' </label> </td>
                     </tr>
                     <tr class="BarraDocumentos" style="height:60px;Important!"> 
                      <td width="20"> &nbsp; </td>
                      <td width="480" align="left">  <label class="Texto12"> <b> Licencia: </b> </label> <br> '.$combolicencias.' </td>
                     </tr>
                     <tr class="BarraDocumentos" style="height:60px;Important!"> 
                      <td width="20"> &nbsp; </td>
                      <td width="480" align="left"> 
                       <label class="Texto12"> <b> D&iacute;as: </b> </label> <br>
                       <input type="number" name="dias" min="1" max="180" class="Texto12New" size="12" style="width:80px;height:25px;" autocomplete="off" title="días de la licencia" value="'.$dias.'"> 
                      </td>
                     </tr>
                    </table>                
                    <table width="500">
                     <tr class="BarraDocumentos" style="height:50px;Important!"> 
                      <td width="480" align="center">
                       <input type="submit" value="ACEPTAR" class="button blue">
                       <a href="liquidados.php?opcion=editarliquidacion&terid='.$terid.'&codperiodo='.$codperiodo.'">
                        <input type="button" value="CANCELAR" class="button red">
                       </a>
                       </form>
                      </td>
                     </tr>
                    </table>';
        echo $cont;
        exit();
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: almlicencias
    // Creación: 21/05/2024		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que almacena la licencia ejecutando todos los cálculos 
    //              correspondientes
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "almlicencias")
    {
        $periodoid = $_POST['periodoid'];
        $terid = $_POST['terid'];
        $dias = $_POST['dias'];
        $conceptoid = $_POST['conceptoid'];
        $codperiodo = $_POST['codperiodo'];
        $idliquidados = $_POST['idliquidados'];        

        // Inicializo las variables
        $basico = 0;                            $formulabasico = "";                            $diastrab = 0;
        $detalleid = 0;                         $sueldo = 0;                                    $numid = 0;
        $licencianorem = 0;                     $formulatransporte = "";                        $subsidiotransporte = 0;
        $lbpaso = false;                        $formulasuspencion = "";                        $suspension = 0;
        $formulaincapacidad = "";               $incapacidad = 0;                               $formulapaternidad = "";
        $paternidad = 0;                        $totnovedades = 0;                              $sueldostr = "";
        $centenas = "";                         $centenasnum = 0;                               $sueldodeducciones = 0;
        $formulapension = "";                   $pension = 0;                                   $detalleid = 0;
        $formulasalud = "";                     $salud = 0;                                     $totrecargos = 0;
        $valorperiodo = 0;                      $valorconcepto = 0;                             $diff = 0;
        $difendias = 0;                         $diaspendiente = 0;

        // Obtengo el salario básico del empleado
        $basico = $clase->BDLockup($idliquidados,'tmpinfliquidados','idliquidados','basico');

        // Obtengo la formula del sueldo
        $vsql = "SELECT formula FROM conceptosnomina WHERE conceptoid = 1";
        $formulabasico = $clase->SeleccionarUno($vsql);        

        // Obtengo los días trabajados en el periodo
        $vsql = "SELECT valor
                   FROM detalleliquidacion  
                  WHERE conceptoid = 1  
                        AND pernominaid = ".$periodoid."
                        AND terid = ".$terid;
        $diastrab = $clase->SeleccionarUno($vsql);

        // Obtengo el ID del registro que se modificará
        $vsql = "SELECT detalleid
                   FROM detalleliquidacion  
                  WHERE conceptoid = 1  
                        AND pernominaid = ".$periodoid."
                        AND terid = ".$terid;
        $detalleid = $clase->SeleccionarUno($vsql);
        
        $diastrab -= $dias;

        eval("\$sueldo = $formulabasico;");
        $sueldo = round($sueldo,0);

        // Almaceno en nuevo sueldo
        $vsql = "UPDATE detalleliquidacion SET 
                        devengados = ".$sueldo.", 
                        valor = ".$diastrab."
                  WHERE detalleid = ".$detalleid;
        $clase->EjecutarSQL($vsql);

        // Valido que se almacene el nuevo sueldo para poder continuar con el proceso
        // Calculo el nuevo ID
        $vsql = "SELECT max(detalleid) FROM detalleliquidacion";
        $numid = $clase->SeleccionarUno($vsql);
        $numid++;

        // Inserto la nueva licencia

        // Obtengo la formula de la licencia
        $vsql = "SELECT formula FROM conceptosnomina WHERE conceptoid = ".$conceptoid;
        $formulalice = $clase->SeleccionarUno($vsql);

        // Calculo la licencia
        if($conceptoid!=10)
        {
            eval("\$montolicencia = $formulalice;");
            $montolicencia = round($montolicencia,0);
        }
        else
        {
            // Calculo la incapacidad

            // Obtengo el salario mínimo legal vigente
            $smlv = $_SESSION['N_SALMIN2020'];

            // Valido si el sueldo básico sea menor al salario mínimo legal vigente
            if($basico<=$smlv)
            {
                $montolicencia = ($smlv*$dias)/30;
                $montolicencia = round($montolicencia,0);
            }
            else
            {
                $porcbasico = ($basico*66.67)/100;
                $porcbasico = round($porcbasico,0);

                // Calculo la incapacidad si el básico sea mayor al mínimo
                if($porcbasico>$smlv)
                {
                    $montolicencia = ($porcbasico*$dias)/30;
                    $montolicencia = round($montolicencia,0);
                }
                else
                {
                    if($conceptoid==10)         $montolicencia = ($smlv*$dias)/30;
                    if($conceptoid==40)         $montolicencia = ($basico*$dias)/30;

                    $montolicencia = round($montolicencia,0);
                }
            }
        }

        // ------------------------------------------------------------------------------------------------------------------- //
        // Obtengo el tipo de licencia
        $tipodc = $clase->BDLockup($conceptoid,'conceptosnomina','conceptoid','tipodc');

        // en detallenomina

        // ------------------------------------------------------------------------------------------------------------------- //
        // Determino si el registro existe para modificarlo o incluirlo
        $vsql = "SELECT COUNT(*) AS repetida 
                   FROM detalleliquidacion
                  WHERE pernominaid = ".$periodoid."
                        AND conceptoid = ".$conceptoid."
                        AND terid = ".$terid."";
        $repetida = $clase->SeleccionarUno($vsql);

        // ------------------------------------------------------------------------------------------------------------------- //
        if($repetida==0)
        {
            if($tipodc=="C")
                $vsql = "INSERT INTO detalleliquidacion (detalleid,terid,conceptoid,pernominaid,devengados,descuentos,valor,saldo) 
                                            VALUES ($numid,".$terid.",".$conceptoid.",".$periodoid.",".$montolicencia.",0,".$dias.",".$basico.")";
            else
                $vsql = "INSERT INTO detalleliquidacion (detalleid,terid,conceptoid,pernominaid,devengados,descuentos,valor,saldo) 
                                            VALUES ($numid,".$terid.",".$conceptoid.",".$periodoid.",0,".$montolicencia.",".$dias.",".$basico.")";
        }
        else
        {
            // Determino el id del registro
            $vsql = "SELECT detalleid AS detalleid 
                       FROM detalleliquidacion
                      WHERE pernominaid = ".$periodoid."
                            AND conceptoid = ".$conceptoid."
                            AND terid = ".$terid."";
            $detalleid = $clase->SeleccionarUno($vsql);

            $valor = $clase->BDLockup($detalleid,'detalleliquidacion','detalleid','valor');
            $valor += $dias;

            // Actualizo la licencia
            if($tipodc=="C")
            {
                $devengados = $clase->BDLockup($detalleid,'detalleliquidacion','detalleid','devengados');
                $devengados += $montolicencia;
                
                $vsql = "UPDATE detalleliquidacion SET 
                                devengados = ".$devengados.", 
                                valor = ".$valor."
                          WHERE detalleid = ".$detalleid."";
            }
            else
            {
                $descuentos = $clase->BDLockup($detalleid,'detalleliquidacion','detalleid','descuentos');
                $descuentos += $montolicencia;

                $vsql = "UPDATE detalleliquidacion SET 
                                descuentos = ".$descuentos.", 
                                valor = ".$valor."
                          WHERE detalleid = ".$detalleid."";
            }
        }
        $clase->EjecutarSQL($vsql);

        // ---------------------------------------------------------------------------------------------------------- //
        // Recalculo el subsidio de transporte siempre y cuando el básico no exceda de dos salarios mínimos

        // Obtengo el salario mínimo legal vigente
        $smlv = $_SESSION['N_SALMIN2020'];

        // Obtengo el cargo del empleado
        $vsqldatos = "SELECT cargoid FROM terceros WHERE terid = ".$terid;
        $cargoid = $clase->SeleccionarUno($vsqldatos);
        $vsqldatos = "";

        // Obtengo el control del cálculo de subsidio de transporte
        $aplicatransporte = $clase->BDLockup($cargoid,'cargos','cargoid','aplicatransporte');

        // Variable para la validación del auxilio de transporte
        $valsubtrasp = $smlv * 2;        

        if(($basico <= $valsubtrasp)&&($aplicatransporte=="CHECKED"))
        {
            // Obtengo el ID del registro que se modificará
            $vsql = "SELECT detalleid
                       FROM detalleliquidacion 
                      WHERE conceptoid = 3  
                            AND pernominaid = ".$periodoid."
                            AND terid = ".$terid."";
            $detalleid = $clase->SeleccionarUno($vsql);

            // Obtengo la formula del subsidio de transporte
            $auxtrans = $_SESSION['N_AUXTRANS2020'];
            $vsql = "SELECT formula FROM conceptosnomina WHERE conceptoid = 3";
            $formulatransporte = $clase->SeleccionarUno($vsql);

            eval("\$subsidiotransporte = $formulatransporte;");
            $subsidiotransporte = round($subsidiotransporte,0);
        }
        else
            $subsidiotransporte = 0;

        // ID transporte
        $vsql = "SELECT detalleid AS idtransporte FROM detalleliquidacion WHERE terid = ".$terid." AND pernominaid = ".$periodoid." AND conceptoid = 3";
        $idtransporte = $clase->SeleccionarUno($vsql);

        // Grabo el subsidio de transporte
        if($idtransporte!="")
            $vsql = "UPDATE detalleliquidacion SET 
                            devengados = ".$subsidiotransporte.",
                            valor = ".$diastrab."
                      WHERE detalleid = ".$idtransporte."";
        else
        {
            $vsql = "SELECT max(detalleid) FROM detalleliquidacion";
            $numreg = $clase->SeleccionarUno($vsql);

            $vsql = "INSERT INTO detalleliquidacion VALUES ($numreg+1,".$terid.",3,".$periodoid.",".$subsidiotransporte.",0,".$diastrab.",$auxtrans)";
        }
        $clase->EjecutarSQL($vsql);        
        
        // Obtengo el total devengado por novedades
        $vsql = "SELECT SUM(d.devengados) AS totnovedades 
                   FROM detalleliquidacion d
                        INNER JOIN conceptosnomina c ON (d.conceptoid = c.conceptoid)
                  WHERE d.terid = ".$terid."
                        AND d.pernominaid = ".$periodoid." 
                        AND (c.eslicencia='CHECKED' AND c.tipodc='C') ";
        $totnovedades = $clase->SeleccionarUno($vsql);

        $vsql = "SELECT IFNULL(SUM(d.devengados),0) totrecargos 
                   FROM detalleliquidacion d
                        INNER JOIN conceptosnomina c ON (d.conceptoid = c.conceptoid)
                  WHERE d.terid = ".$terid."
                        AND d.pernominaid = ".$periodoid." 
                        AND (c.recargo = 'CHECKED' AND c.tipodc = 'C')";
        $totrecargos = $clase->SeleccionarUno($vsql);

        $sueldodeducciones = $sueldo + $totnovedades + $totrecargos;

        // Determino si es extralegal
        $vsqldatos = "SELECT extralegal FROM terceros WHERE terid = ".$terid;
        $extralegal = $clase->SeleccionarUno($vsqldatos);
        $vsqldatos = "";

        // Determino la eps
        $vsqldatos = "SELECT epsid FROM terceros WHERE terid = ".$terid;
        $epsid = $clase->SeleccionarUno($vsqldatos);
        $vsqldatos = "";

        // Fondo de pensiones
        $vsqldatos = "SELECT pensionesid FROM terceros WHERE terid = ".$terid;
        $pensionesid = $clase->SeleccionarUno($vsqldatos);
        $vsqldatos = "";
        
        if($epsid==NULL)                $epsid=0;
        if($pensionesid==NULL)          $pensionesid=0;

        $aplicapension = $clase->BDLockup($cargoid,'cargos','cargoid','aplicapension');     // Obtengo el control del cálculo de pensión
        $aplicasalud = $clase->BDLockup($cargoid,'cargos','cargoid','aplicasalud');         // Obtengo el control del cálculo de salud

        if($extralegal=="CHECKED")
        {
            $pension = 0;
            $salud = 0;
        }
        else
        {
            // Recalculo pensión y salud
            if(($pensionesid==5)||($aplicapension!="CHECKED"))
                $pension = 0;
            else
            {
                // Obtengo la formula para el descuento por pensión
                $vsql = "SELECT formula FROM conceptosnomina WHERE conceptoid = 4";
                $formulapension = $clase->SeleccionarUno($vsql);

                // Calculo la pensión
                eval("\$pension = $formulapension;");
                $pension = round($pension,0);
            }

            if(($epsid==37)||($aplicasalud!="CHECKED"))
                $salud = 0;
            else
            {
                // Obtengo la formula para el descuento de salud
                $vsql = "SELECT formula FROM conceptosnomina WHERE conceptoid = 5";
                $formulasalud = $clase->SeleccionarUno($vsql);
                
                // Calculo la salud
                eval("\$salud = $formulasalud;");
                $salud = round($salud,0);
            }
        }

        //  ID pensión
        $vsql = "SELECT detalleid AS idpension FROM detalleliquidacion WHERE terid = ".$terid." AND pernominaid = ".$periodoid." AND conceptoid = 4";
        $idpension = $clase->SeleccionarUno($vsql);

        // Grabo la pensión
        if($idpension!="")
            $vsql = "UPDATE detalleliquidacion SET 
                            descuentos = ".$pension.",
                            saldo = ".$sueldodeducciones."
                      WHERE detalleid = ".$idpension."";
        else
        {
            $vsql = "SELECT max(detalleid) FROM detalleliquidacion";
            $numreg = $clase->SeleccionarUno($vsql);

            $vsql = "INSERT INTO detalleliquidacion VALUES ($numreg+1,".$terid.",4,".$periodoid.",0,".$pension.",0,$sueldodeducciones)";
        }
        $clase->EjecutarSQL($vsql);

        // ID salud
        $vsql = "SELECT detalleid AS idsalud FROM detalleliquidacion WHERE terid = ".$terid." AND pernominaid = ".$periodoid." AND conceptoid = 5";
        $idsalud = $clase->SeleccionarUno($vsql);

        // Grabo la salud
        if($idsalud!="")
            $vsql = "UPDATE detalleliquidacion SET 
                            descuentos = ".$salud.",
                            saldo = ".$sueldodeducciones."
                      WHERE detalleid = ".$idsalud."";
        else
        {
            $vsql = "SELECT max(detalleid) FROM detalleliquidacion";
            $numreg = $clase->SeleccionarUno($vsql);

            $vsql = "INSERT INTO detalleliquidacion VALUES ($numreg+1,".$terid.",5,".$periodoid.",0,".$salud.",0,$sueldodeducciones)";
        }
        $clase->EjecutarSQL($vsql);

        // ----------------------------------------------------------------------------------------------------------- //
        // Aquí depuro la tabla eliminando los registros en cero, es decir lo que no se calculó
        $vsql = "DELETE FROM detalleliquidacion WHERE devengados <= 0 AND descuentos <= 0 AND pernominaid =".$periodoid;
        $clase->EjecutarSQL($vsql);

        // ----------------------------------------------------------------------------------------------------------- //
        // actualizo la tabla tmpinfliquidados

        // días trabajados
        $vsql = "SELECT SUM(IF(conceptoid IN (1,10,13,46),valor,0))
                   FROM detalleliquidacion
                  WHERE terid = ".$terid." 
                        AND pernominaid = ".$periodoid;
        $diastrabtmp = $clase->SeleccionarUno($vsql);

        // sueldo
        $vsql = "SELECT SUM(IF(conceptoid = 1,devengados,0)) 
                   FROM detalleliquidacion
                  WHERE terid = ".$terid." 
                        AND pernominaid = ".$periodoid;
        $sueldotmp = $clase->SeleccionarUno($vsql);

        // subsidio de transporte
        $vsql = "SELECT SUM(IF(conceptoid = 3,devengados,0)) 
                   FROM detalleliquidacion
                  WHERE terid = ".$terid." 
                        AND pernominaid = ".$periodoid;
        $subsidiotransportetmp = $clase->SeleccionarUno($vsql);

        // pensión
        $vsql = "SELECT SUM(IF(conceptoid = 4,descuentos,0)) 
                   FROM detalleliquidacion
                  WHERE terid = ".$terid." 
                        AND pernominaid = ".$periodoid;
        $pensiontmp = $clase->SeleccionarUno($vsql);

        // salud
        $vsql = "SELECT SUM(IF(conceptoid = 5,descuentos,0)) 
                   FROM detalleliquidacion
                  WHERE terid = ".$terid." 
                        AND pernominaid = ".$periodoid;
        $saludtmp = $clase->SeleccionarUno($vsql);

        $vsql = "UPDATE tmpinfliquidados SET 
                        diastrab = ".$diastrabtmp.", 
                        sueldo = ".$sueldotmp.",
                        subsidiotransporte = ".$subsidiotransportetmp.",
                        pension = ".$pensiontmp.",
                        salud = ".$saludtmp."
                  WHERE idliquidados = ".$idliquidados;
        $clase->EjecutarSQL($vsql);    

        // actualizo los totales
        $sueldo = $clase->BDLockup($idliquidados,'tmpinfliquidados','idliquidados','sueldo');
        $subsidiotransporte = $clase->BDLockup($idliquidados,'tmpinfliquidados','idliquidados','subsidiotransporte');
        $pagovaca = $clase->BDLockup($idliquidados,'tmpinfliquidados','idliquidados','pagovaca');
        $pagoprima = $clase->BDLockup($idliquidados,'tmpinfliquidados','idliquidados','pagoprima');
        $pagocedesantias = $clase->BDLockup($idliquidados,'tmpinfliquidados','idliquidados','pagocedesantias');
        $pagointereses = $clase->BDLockup($idliquidados,'tmpinfliquidados','idliquidados','pagointereses');
        $indemnizacion = $clase->BDLockup($idliquidados,'tmpinfliquidados','idliquidados','indemnizacion');
        
        // lista de quincenas del periodo
        $listaperiodos = generarlistaper($codperiodo);
        
        // otros devengados
        $vsq22 = "SELECT SUM(IF(devengados > 0,devengados,0)) otrosdevengados
                    FROM detalleliquidacion 
                   WHERE terid = ".$terid." 
                         AND pernominaid IN ($listaperiodos)
                         AND conceptoid NOT IN (1,3) LIMIT 0,1";
        $otrosdevengados = $clase->SeleccionarUno($vsq22);

        $totaldevengado = $sueldo + $subsidiotransporte + $pagovaca + $pagoprima + $pagocedesantias + $pagointereses + $indemnizacion + $otrosdevengados;

        $pension = $clase->BDLockup($idliquidados,'tmpinfliquidados','idliquidados','pension');
        $salud = $clase->BDLockup($idliquidados,'tmpinfliquidados','idliquidados','salud');

        // otros descuentos
        $vsq23 = "SELECT SUM(IF(descuentos > 0,descuentos,0)) otrosdescuentos
                    FROM detalleliquidacion 
                   WHERE terid = ".$terid." 
                         AND pernominaid IN ($listaperiodos) 
                         AND conceptoid NOT IN (4,5,6,9,43,58) LIMIT 0,1";
        $otrosdescuentos = $clase->SeleccionarUno($vsq23);
        
        // total descuento
        $totaldescuento = $pension + $salud + $otrosdescuentos;

        // neto a pagar
        $netoapagar = $totaldevengado - $totaldescuento;

        // grabo los totales
        $vsql = "UPDATE tmpinfliquidados SET 
                        otrosdevengados = ".$otrosdevengados.", 
                        otrosdescuentos = ".$otrosdescuentos.",
                        totaldevengado = ".$totaldevengado.",
                        totaldescuento = ".$totaldescuento.",
                        netoapagar = ".$netoapagar."
                  WHERE idliquidados = ".$idliquidados;
        $clase->EjecutarSQL($vsql);        

        // emito el mensaje correspondiente
        $nomconcepto = $clase->BDLockup($conceptoid,'conceptosnomina','conceptoid','nomconcepto');
        $nombre = $clase->BDLockup($idliquidados,'tmpinfliquidados','idliquidados','nombre');
        $clase->Aviso(1,"Se incluyó exitosamente el concepto $nomconcepto al empleado $nombre");

        // Redirecciono el formulario
        header("Location: liquidados.php?opcion=editarliquidacion&terid=$terid&codperiodo=$codperiodo");
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: confirmarelimconcepto
    // Creación: 21/05/2024		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que pinta la ventana para confirmar la eliminación de un 
    //              concepto
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "confirmarelimconcepto")
    {
        $codperiodo = $_GET['codperiodo'];
        $terid = $_GET['terid'];
        $periodoid = $_GET['periodoid'];
        $listaperiodos = $_GET['listaperiodos'];
        $detalleid = $_GET['detalleid'];
        $periodoidactual = $_GET['periodoidactual'];
        $detalleid = $_GET['detalleid'];        

        // echo $codperiodo.' -- '.$terid.' -- '.$periodoid.' -- '.$listaperiodos.' -- '.$detalleid.' -- '.$periodoidactual; exit();

        // Datos del registro
        $conceptoid = $clase->BDLockup($detalleid,'detalleliquidacion','detalleid','conceptoid');
        $terid = $clase->BDLockup($detalleid,'detalleliquidacion','detalleid','terid');
        $devengados = $clase->BDLockup($detalleid,'detalleliquidacion','detalleid','devengados');
        $descuentos = $clase->BDLockup($detalleid,'detalleliquidacion','detalleid','descuentos');

        $nomconcepto = $clase->BDLockup($conceptoid,'conceptosnomina','conceptoid','nomconcepto');

        // nombre del empleado
        $vsql3 = "SELECT CONCAT(primernombre,' ',segundonombre,' ',primerapellido,' ',segundoapellido) AS nombreemp FROM terceros WHERE terid = ".$terid;
        $nombreemp = $clase->SeleccionarUno($vsql3);
        
        if($devengados != 0)
            $monto = $devengados;
        else
            $monto = $descuentos;

        // determino si la liquidación está cerrada
        $vsqldatos = "SELECT norecalcular FROM parametrosliquidacion WHERE terid = ".$terid." AND codperiodo = '".$codperiodo."'";
        $norecalcular = $clase->SeleccionarUno($vsqldatos);

        // Pinto la ventana
        if($norecalcular == "CHECKED")
            $cont ='<table width="500">
                     <tr class="CabezoteTabla"> 
                      <td align="center"><br><b>Eliminar vacaciones</b><br><br></td> 
                     </tr> 
                    </table>
                    <table width="500">
                     <tr class="TablaDocsImPar">       
                      <td width="400" align="center"> <label class="Texto12"> Esta liquidaci&oacute;n est&aacute; cerrada </label> </td>
                     </tr>
                     <tr class="TablaDocsImPar">       
                      <td width="400" align="center"><br><br>                      
                       <input type="hidden" name="idliquidacion" value="'.$idliquidacion.'">
                       <input type="hidden" name="periodoid" value="'.$periodoid.'">                   
                       <input type="hidden" name="codperiodo" value="'.$codperiodo.'">
                       <input type="hidden" name="listaperiodos" value="'.$listaperiodos.'">
                       <input type="hidden" name="terid" value="'.$terid.'">                      
                       <a href="liquidados.php?opcion=editarunaliquidacion&periodoid='.$periodoid.'&terid='.$terid.'&codperiodo='.$codperiodo.'&listaperiodos='.$listaperiodos.'">
                        <input type="button" value="ACEPTAR" class="button blue">
                       </a>
                      </td>        
                     </tr>
                    </table><br>';            
        else        
            $cont ='<table width="500">
                     <tr class="CabezoteTabla">
                      <td width="50" align="left"> <img src="images/iconos/eliminardoc.png" width="32" height="32" border="0"> </td>
                      <td width="450" align="center"> <b> Eliminar concepto </b> </td>
                     </tr>
                    </table>
                    <table width="500">
                     <tr class="TablaDocsImPar">       
                      <td width="500" align="center">
                       <label class="Texto12"> ¿Confirma que desea eliminar el concepto <br><b> '.$nomconcepto.'</b> <br> por un monto de <b>'.number_format($monto).'</b> pesos? </label> 
                      </td>
                     </tr>
                     <tr class="TablaDocsImPar">       
                      <td width="400" align="center"><br><br>
                       <form action="?opcion=eliminaconpemp" method="POST">
                       <input type="hidden" name="detalleid" value="'.$detalleid.'">
                       <input type="hidden" name="periodoid" value="'.$periodoid.'">                   
                       <input type="hidden" name="codperiodo" value="'.$codperiodo.'">
                       <input type="hidden" name="listaperiodos" value="'.$listaperiodos.'">
                       <input type="hidden" name="terid" value="'.$terid.'">
                       <input type="hidden" name="detalleid" value="'.$detalleid.'">
                       <input type="hidden" name="periodoidactual" value="'.$periodoidactual.'">
                       <input type="hidden" name="conceptoid" value="'.$conceptoid.'">
                       <input type="submit" value="ACEPTAR" class="button red">
                       <a href="liquidados.php?opcion=editarunaliquidacion&periodoid='.$periodoid.'&terid='.$terid.'&codperiodo='.$codperiodo.'&listaperiodos='.$listaperiodos.'">
                        <input type="button" value="CANCELAR" class="button blue">
                       </a>
                       </form>
                      </td>
                     </tr>
                    </table>';
        echo $cont;
        exit();
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: eliminaconpemp
    // Creación: 21/05/2024		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que elimina un concepto y realiza los cálculos en caso de ser 
    //              necesario
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "eliminaconpemp")
    {
        $periodoid = $_POST['periodoid'];
        $terid = $_POST['terid'];
        $conceptoid = $_POST['conceptoid'];
        $listaperiodos = $_POST['listaperiodos'];
        $codperiodo = $_POST['codperiodo'];        
        $periodoidactual = $_POST['periodoidactual'];
        $detalleid = $_POST['detalleid'];

        // echo $periodoid.' -- '.$terid.' -- '.$conceptoid.' -- '.$listaperiodos.' -- '.$codperiodo.' -- '.$periodoidactual.' -- '.$detalleid; exit();

        // Determino el ámbito del concepto
        $eslicencia = $clase->BDLockup($conceptoid,'conceptosnomina','conceptoid','eslicencia');

        if($eslicencia != "CHECKED")
        {
            $vsql = "DELETE FROM detalleliquidacion WHERE detalleid = ".$detalleid;
            $clase->EjecutarSQL($vsql);
        }
        else
        {
            // Obtengo el salario básico del empleado
            $vsqldatos = "SELECT basico FROM terceros WHERE terid = ".$terid;
            $basico = $clase->SeleccionarUno($vsqldatos);
            $vsqldatos = "";

            // en detallenomina

            // Obtengo los días trabajados en el periodo
            $vsql = "SELECT valor
                       FROM detalleliquidacion 
                      WHERE conceptoid = 1  
                            AND pernominaid = ".$periodoidactual."
                            AND terid = ".$terid."";
            $diastrab = $clase->SeleccionarUno($vsql);

            // Obtengo el ID del registro que se modificará
            $vsql = "SELECT detalleid
                       FROM detalleliquidacion 
                      WHERE conceptoid = 1  
                            AND pernominaid = ".$periodoidactual."
                            AND terid = ".$terid."";
            $detalleidsueldo = $clase->SeleccionarUno($vsql);

            // Obtengo la formula del sueldo
            $vsql = "SELECT formula FROM conceptosnomina WHERE conceptoid = 1";
            $formulabasico = $clase->SeleccionarUno($vsql);

            $diasconcepto = $clase->BDLockup($detalleid,'detalleliquidacion','detalleid','valor');

            // echo $diastrab.' -- '.$diasconcepto; exit();

            // echo $detalleidsueldo; exit();

            // Recalculo el sueldo del periodo
            $diastrab += $diasconcepto;
            eval("\$sueldo = $formulabasico;");
            $sueldo = round($sueldo,0);

            // Almaceno en nuevo sueldo
            $vsql = "UPDATE detalleliquidacion SET 
                            devengados = ".$sueldo.", 
                            valor = ".$diastrab."
                      WHERE detalleid = ".$detalleidsueldo;
            $clase->EjecutarSQL($vsql);

            // Valido que se almacene el nuevo sueldo para poder continuar con el proceso
            if(mysql_affected_rows() > 0)
            {
                // // Ahora voy a recalcular el subsidio de transporte si es necesario
                // $lb_grabosueldo = true;       // Variable que controla el mensaje correspondiente
    
                // Obtengo el salario mínimo legal vigente
                $smlv = $_SESSION['N_SALMIN2020'];
    
                // Variable para la validación del auxilio de transporte
                $valsubtrasp = $smlv * 2;

                // Obtengo el cargo del empleado
                $vsqldatos = "SELECT cargoid FROM terceros WHERE terid = ".$terid;
                $cargoid = $clase->SeleccionarUno($vsqldatos);
                $vsqldatos = "";

                // Obtengo el control del cálculo de subsidio de transporte
                $aplicatransporte = $clase->BDLockup($cargoid,'cargos','cargoid','aplicatransporte');

                if(($basico <= $valsubtrasp) && ($aplicatransporte=="CHECKED"))
                {        
                    // Obtengo la formula del subsidio de transporte
                    $auxtrans = $_SESSION['N_AUXTRANS2020'];
                    $vsql = "SELECT formula FROM conceptosnomina WHERE conceptoid = 3";
                    $formulatransporte = $clase->SeleccionarUno($vsql);
    
                    eval("\$subsidiotransporte = $formulatransporte;");
                    $subsidiotransporte = round($subsidiotransporte,0);
                }
                else
                    $subsidiotransporte = 0;

                // ID transporte
                $vsql = "SELECT detalleid AS idtransporte FROM detalleliquidacion WHERE terid = ".$terid." AND pernominaid = ".$periodoidactual." AND conceptoid = 3";
                $idtransporte = $clase->SeleccionarUno($vsql);
        
                if($idtransporte!="")
                    // Grabo el subsidio de transporte
                    $vsql = "UPDATE detalleliquidacion SET 
                                    devengados = ".$subsidiotransporte.",
                                    valor = ".$diastrab."
                                WHERE detalleid = ".$idtransporte."";
                else
                {
                    // Obtengo el valor del subsidio de transporte
                    $valsubtransporte = $_SESSION['N_AUXTRANS2020'];
        
                    $vsql = "SELECT max(detalleid) FROM detalleliquidacion";
                    $numreg = $clase->SeleccionarUno($vsql);
        
                    $vsql = "INSERT INTO detalleliquidacion VALUES ($numreg+1,".$terid.",3,".$periodoidactual.",".$subsidiotransporte.",0,".$diastrab.",$valsubtransporte)";
                }
                $clase->EjecutarSQL($vsql);

                // ----------------------------- //
                // Recalculo la pensión y la salud

                // ------------------------------------------------------------------------------------------------------------- //
                // Obtengo la formula para el descuento por pensión
                $vsql = "SELECT formula FROM conceptosnomina WHERE conceptoid = 4";
                $formulapension = $clase->SeleccionarUno($vsql);

                // Obtengo la formula para el descuento de salud
                $vsql = "SELECT formula FROM conceptosnomina WHERE conceptoid = 5";
                $formulasalud = $clase->SeleccionarUno($vsql);

                // Determino si es extralegal
                $vsqldatos = "SELECT extralegal FROM terceros WHERE terid = ".$terid;
                $extralegal = $clase->SeleccionarUno($vsqldatos);
                $vsqldatos = "";

                // Determino la eps
                $vsqldatos = "SELECT epsid FROM terceros WHERE terid = ".$terid;
                $epsid = $clase->SeleccionarUno($vsqldatos);
                $vsqldatos = "";

                // Fondo de pensiones
                $vsqldatos = "SELECT pensionesid FROM terceros WHERE terid = ".$terid;
                $pensionesid = $clase->SeleccionarUno($vsqldatos);
                $vsqldatos = "";
                
                if($epsid==NULL)                    $epsid=0;
                if($pensionesid==NULL)              $pensionesid=0;

                // ----------------------------------------------------------------------------------------------------------- //
                $aplicapension = $clase->BDLockup($cargoid,'cargos','cargoid','aplicapension');     // Obtengo el control del cálculo de pensión
                $aplicasalud = $clase->BDLockup($cargoid,'cargos','cargoid','aplicasalud');         // Obtengo el control del cálculo de salud                    

                $vsql = "SELECT SUM(d.devengados) AS totnovedades 
                            FROM detalleliquidacion d
                                INNER JOIN conceptosnomina c ON (d.conceptoid = c.conceptoid)
                            WHERE d.terid = ".$terid."
                                AND d.pernominaid = ".$periodoidactual." 
                                AND (c.eslicencia='CHECKED' AND c.tipodc='C')";
                $totnovedades = $clase->SeleccionarUno($vsql);

                // Actualizo el sueldo
                $sueldo += $totnovedades;
                $sueldodeducciones = $sueldo;
    
                if($extralegal=="CHECKED")
                {
                    $pension = 0;
                    $salud = 0;
                }
                else
                {
                    // Recalculo pensión y salud
                    if(($pensionesid==5) || ($aplicapension!="CHECKED"))
                        $pension = 0;
                    else
                    {
                        // Obtengo la formula para el descuento por pensión
                        $vsql = "SELECT formula FROM conceptosnomina WHERE conceptoid = 4";
                        $formulapension = $clase->SeleccionarUno($vsql);
    
                        // Calculo la pensión
                        eval("\$pension = $formulapension;");
                        $pension = round($pension,0);
                    }
    
                    if(($epsid==37) || ($aplicasalud!="CHECKED"))
                        $salud = 0;
                    else
                    {
                        // Obtengo la formula para el descuento de salud
                        $vsql = "SELECT formula FROM conceptosnomina WHERE conceptoid = 5";
                        $formulasalud = $clase->SeleccionarUno($vsql);
                        
                        // Calculo la salud
                        eval("\$salud = $formulasalud;");
                        $salud = round($salud,0);
                    }
                }                    
    
                //  ID pensión
                $vsql = "SELECT detalleid AS idpension FROM detalleliquidacion WHERE terid = ".$terid." AND pernominaid = ".$periodoidactual." AND conceptoid = 4";
                $idpension = $clase->SeleccionarUno($vsql);
    
                // Grabo la pensión
                if($idpension!="")
                    $vsql = "UPDATE detalleliquidacion SET 
                                    descuentos = ".$pension.",
                                    saldo = ".$sueldodeducciones."
                                WHERE detalleid = ".$idpension."";
                else
                {
                    $vsql = "SELECT max(detalleid) FROM detalleliquidacion";
                    $numreg = $clase->SeleccionarUno($vsql);
    
                    $vsql = "INSERT INTO detalleliquidacion VALUES ($numreg+1,".$terid.",4,".$periodoidactual.",0,".$pension.",0,$sueldodeducciones)";
                }        
                $clase->EjecutarSQL($vsql);
    
                // ID salud
                $vsql = "SELECT detalleid AS idsalud FROM detalleliquidacion WHERE terid = ".$terid." AND pernominaid = ".$periodoidactual." AND conceptoid = 5";
                $idsalud = $clase->SeleccionarUno($vsql);
    
                // Grabo la salud
                if($idsalud!="")
                    $vsql = "UPDATE detalleliquidacion SET 
                                    descuentos = ".$salud.",
                                    saldo = ".$sueldodeducciones."
                                WHERE detalleid = ".$idsalud."";
                else
                {
                    $vsql = "SELECT max(detalleid) FROM detalleliquidacion";
                    $numreg = $clase->SeleccionarUno($vsql);
    
                    $vsql = "INSERT INTO detalleliquidacion VALUES ($numreg+1,".$terid.",5,".$periodoidactual.",0,".$salud.",0,$sueldodeducciones)";
                }
                $clase->EjecutarSQL($vsql);

                // elimino el concepto
                $vsql = "DELETE FROM detalleliquidacion WHERE detalleid = ".$detalleid;
                $clase->EjecutarSQL($vsql);                
            }            
        }

        // Nombre del concepto
        $nomconcepto = $clase->BDLockup($conceptoid,'conceptosnomina','conceptoid','nomconcepto');

        // Aquí depuro la tabla eliminando los registros en cero, es decir lo que no se calculó
        $vsql = "DELETE FROM detalleliquidacion WHERE devengados <= 0 AND descuentos <= 0 AND pernominaid IN ($listaperiodos) AND terid = ".$terid."";
        $clase->EjecutarSQL($vsql);

        // mensaje correspondiente
        $clase->Aviso(1,"$nomconcepto Eliminada satisfactoriamente");

        // Redirecciono el formulario
        header("Location: liquidados.php?opcion=editarunaliquidacion&terid=$terid&listaperiodos=$listaperiodos&codperiodo=$codperiodo&periodoid=$periodoid");
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: actincapacidadarl
    // Creación: 02/02/2024		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que re calcula la pensión y la salud para una incapacidad en 
    //              caso de ser necesario
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "actincapacidadarl")
    {
        $terid = $_GET['terid'];
        $periodoid = $_GET['periodoid'];
        $diastrab = $_GET['diastrab'];
        $codperiodo = $_GET['codperiodo'];
        $listaperiodos = $_GET['listaperiodos'];
        $periodoidactual = $_GET['periodoidactual'];

        // determino si la liquidación está cerrada
        $vsqldatos = "SELECT norecalcular FROM parametrosliquidacion WHERE terid = ".$terid." AND codperiodo = '".$codperiodo."'";
        $norecalcular = $clase->SeleccionarUno($vsqldatos);

        if($norecalcular == "CHECKED")
            $clase->Aviso(3,"Esta liquidación está cerrada");
        else
        {
            $detalleid = 0;            $dias = 0;                      $smlv = 0;
            $basico = 0;               $montolicencia = 0;             $dias = $diastrab;
    
            // Determino si el empleado tiene una incapacidad para ser recalculada
            $vsql = "SELECT detalleid
                       FROM detalleliquidacion 
                      WHERE conceptoid = 10  
                            AND pernominaid = ".$periodoidactual."
                            AND terid = ".$terid."";
            $detalleid = $clase->SeleccionarUno($vsql);
    
            if(strlen($detalleid) == 0)
            {
                $vsql = "SELECT CONCAT(primernombre,' ',segundonombre,' ',primerapellido,' ',segundoapellido) AS nombreemp FROM terceros WHERE terid = ".$terid;
                $nombreemp = $clase->SeleccionarUno($vsql);
    
                $clase->Aviso(3,"$nombreemp no tiene incapacidades en este periodo");
            }
            else
            {
                // Obtengo los días de incapacidad
                $vsql2 = "SELECT valor AS dias
                            FROM detalleliquidacion 
                           WHERE detalleid = ".$detalleid;
                $dias = $clase->SeleccionarUno($vsql2);
        
                // Obtengo el salario mínimo legal vigente
                $smlv = $_SESSION['N_SALMIN2020'];
        
                // Obtengo el salario básico del empleado
                $basico = $clase->BDLockup($terid,'terceros','terid','basico');
        
                if($basico>=$smlv)
                {
                    $montolicencia = ($basico*$dias)/30;
                    $montolicencia = round($montolicencia,0);
                }
        
                // // Almaceno la modificación
                // $vsql = "UPDATE detalleliquidacion SET 
                //                 devengados = ".$montolicencia."
                //           WHERE detalleid = ".$detalleid;
                // $clase->EjecutarSQL($vsql);
        
                // Procedo a recalcular pensión y salud
        
                // Obtengo la formula del sueldo
                $vsql = "SELECT formula FROM conceptosnomina WHERE conceptoid = 1";
                $formulabasico = $clase->SeleccionarUno($vsql);
        
                // Calculo el sueldo básico
                eval("\$sueldo = $formulabasico;");
                $sueldo = round($sueldo,0);
        
                // Determino si el empleado es de condición extralegal
                $extralegal = $clase->BDLockup($terid,'terceros','terid','extralegal');
                $epsid = $clase->BDLockup($terid,'terceros','terid','epsid');
                $pensionesid = $clase->BDLockup($terid,'terceros','terid','pensionesid');
                $cargoid = $clase->BDLockup($terid,'terceros','terid','cargoid');                       // Obtengo el cargo del empleado
                
                if($epsid==NULL)                $epsid=0;
                if($pensionesid==NULL)          $pensionesid=0;
        
                // Consulta para el total de devengados
                $vsql = "SELECT SUM(d.devengados) AS totnovedades 
                           FROM detalleliquidacion d
                                INNER JOIN conceptosnomina c ON (d.conceptoid = c.conceptoid)
                          WHERE d.terid = ".$terid."
                                AND d.pernominaid = ".$periodoidactual." 
                                AND (c.eslicencia='CHECKED' AND c.tipodc='C')";
                $totnovedades = $clase->SeleccionarUno($vsql);
    
                // $sueldodeducciones = $sueldo + $totnovedades;
                $sueldodeducciones = $sueldo + $montolicencia;            
        
                $aplicapension = $clase->BDLockup($cargoid,'cargos','cargoid','aplicapension');             // Obtengo el control del cálculo de pensión
                $aplicasalud = $clase->BDLockup($cargoid,'cargos','cargoid','aplicasalud');                 // Obtengo el control del cálculo de salud
                
                if($extralegal=="CHECKED")
                {
                    $pension = 0;
                    $salud = 0;
                }
                else
                {
                    // Recalculo pensión y salud
                    if(($pensionesid==5) || ($aplicapension!="CHECKED"))
                        $pension = 0;
                    else
                    {
                        // Obtengo la formula para el descuento por pensión
                        $vsql = "SELECT formula FROM conceptosnomina WHERE conceptoid = 4";
                        $formulapension = $clase->SeleccionarUno($vsql);
        
                        // Calculo la pensión
                        eval("\$pension = $formulapension;");
                        $pension = round($pension,0);
                    }
        
                    if(($epsid==37) || ($aplicasalud!="CHECKED"))
                        $salud = 0;
                    else
                    {
                        // Obtengo la formula para el descuento de salud
                        $vsql = "SELECT formula FROM conceptosnomina WHERE conceptoid = 5";
                        $formulasalud = $clase->SeleccionarUno($vsql);
                        
                        // Calculo la salud
                        eval("\$salud = $formulasalud;");
                        $salud = round($salud,0);
                    }
                }
                // ---------------------------------------------------------------------------------------------------------------------------------------------------- //
                //  ID pensión
                $vsql = "SELECT detalleid AS idpension FROM detalleliquidacion WHERE terid = ".$terid." AND pernominaid = ".$periodoidactual." AND conceptoid = 4";
                $idpension = $clase->SeleccionarUno($vsql);
        
                // Grabo la pensión
                if($idpension!="")            
                    $vsql = "UPDATE detalleliquidacion SET 
                                    descuentos = ".$pension.",
                                    saldo = ".$sueldodeducciones."
                              WHERE detalleid = ".$idpension."";
                else
                {
                    $vsql = "SELECT max(detalleid) FROM detalleliquidacion";
                    $numreg = $clase->SeleccionarUno($vsql);
        
                    $vsql = "INSERT INTO detalleliquidacion VALUES ($numreg+1,".$terid.",4,".$periodoidactual.",0,".$pension.",0,$sueldodeducciones)";
                }    
                $clase->EjecutarSQL($vsql);
        
                // ID salud
                $vsql = "SELECT detalleid AS idsalud FROM detalleliquidacion WHERE terid = ".$terid." AND pernominaid = ".$periodoidactual." AND conceptoid = 5";
                $idsalud = $clase->SeleccionarUno($vsql);
        
                // Grabo la salud
                if($idsalud!="")
                    $vsql = "UPDATE detalleliquidacion SET 
                                    descuentos = ".$salud.",
                                    saldo = ".$sueldodeducciones."
                              WHERE detalleid = ".$idsalud."";
                else
                {
                    $vsql = "SELECT max(detalleid) FROM detalleliquidacion";
                    $numreg = $clase->SeleccionarUno($vsql);
        
                    $vsql = "INSERT INTO detalleliquidacion VALUES ($numreg+1,".$terid.",5,".$periodoidactual.",0,".$salud.",0,$sueldodeducciones)";
                }    
                $clase->EjecutarSQL($vsql);
    
                // Aquí depuro los conceptos que estén en cero
                $vsql = "DELETE FROM detalleliquidacion WHERE devengados = 0 AND descuentos = 0 AND pernominaid = ".$periodoidactual." AND terid =".$terid."";
                $clase->EjecutarSQL($vsql);
            }
        }

        // Redirecciono el formulario
        header("Location: liquidados.php?opcion=editarunaliquidacion&terid=$terid&listaperiodos=$listaperiodos&codperiodo=$codperiodo&periodoid=$periodoid");
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: ventanaselempleado
    // Creación: 23/05/2024		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que pinta la ventana para seleccionar el empleado a ser incluido
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "ventanaselempleado")
    {
        $listaperiodos = $_GET['listaperiodos'];
        $codperiodo = $_GET['codperiodo'];
        $periodoid = $_GET['periodoid'];

        // Consulta para el combo de empleados
		$vsqlcomboemp = "SELECT terid, CONCAT(dni,' - ',codvende,' - ',primernombre,' ',segundonombre,' ',primerapellido,' ',segundoapellido) 
                           FROM terceros 
                          WHERE (primernombre <> '' AND primerapellido <> '')
                                AND basico > 0
                       ORDER BY primernombre";

        $descripcion = $clase->BDLockup($periodoid,'periodosnomina','periodoid','descripcion');

        // Nombre del periodo
        $fecdesde = $clase->BDLockup($periodoid,'periodosnomina','periodoid','fecdesde');
        $codperiodo = substr($fecdesde,5,2).substr($fecdesde,0,4);
        $desperiodo = $clase->BDLockup($codperiodo,'periodos','codperiodo','desperiodo');

        // Pintamos la ventana
        $cont = $clase->Header("S","W");
        $cont.='<table width="100%">
                 <tr class="CabezoteTabla"> 
                  <td width="10"> &nbsp; </td>
                  <td width="37"> <img src="images/iconos/retirados.png" width="32" height="32" border="0"> </td>
                  <td width="900"> <b> Incluir liquidaci&oacute;n <br> <font color="BLUE"> '.$desperiodo.' </font> </b> </td>
                  <td width="20"> 
                   <a href="infhistcont.php?opcion=ventanadatos" title="hist&oacute;rico de contrato" target="_blank">
                    <img src="images/iconos/agenda.png" border="0" width="38" height="38">                    
                   </a> 
                  </td>
                  <td width="10"> &nbsp; </td>
                  <td width="20"> 
                   <a href="terceros.php" title="acceder a la ficha terceros" target="_blank">
                    <img src="images/iconos/terceros.png" border="0" width="38" height="38">                    
                   </a> 
                  </td>
                  <td width="10"> &nbsp; </td>
                  <td width="20"> <a href="principal.php" title="ventana principal"> <input type="button" value="<<" class="button blue"> </a> </td>
                  <td width="10"> &nbsp; </td>
                 </tr>
                </table>';
    
        $cont.='<table width="100%">
                 <tr class="CabezoteTabla"> 
                  <td width="10"> &nbsp; </td>
                  <td width="37"> &nbsp; </td>
                  <form action="?opcion=verificarempledo" method="POST" name="x">
                  <input type="hidden" name="periodoid" value="'.$periodoid.'">
                  <input type="hidden" name="listaperiodos" value="'.$listaperiodos.'">
                  <input type="hidden" name="codperiodo" value="'.$codperiodo.'">
                  <td width="730"> <label class="Texto12"> Empleado: </label> '.$clase->CrearComboBuscar("terid",$vsqlcomboemp,"nombres","terid","","S",$params,550).' </td>
                 </tr>
                </table>';
            
        // --------------------------------------------------------------------------------------------------------------------------- //    
        $cont.='<table width="100%">
                 <tr class="CabezoteTabla"> 
                  <td align="center"> <input type="submit" value="aceptar" class="button blue"> </form> </td>
                 </tr>
                </table>';

        // Pie de página
        $cont.='<table width="100%"> 
                 <tr class="CabezoteTabla"> <td align="center"> &nbsp; </td> </tr>
                 <tr class="CabezoteTabla"> <td align="center"> &nbsp; </td> </tr>
                 <tr class="CabezoteTabla"> <td align="center"> &nbsp; </td> </tr>
                 <tr class="CabezoteTabla"> <td align="center"> &nbsp; </td> </tr>
                 <tr class="CabezoteTabla"> <td align="center"> &nbsp; </td> </tr>
                 <tr class="CabezoteTabla"> <td align="center"> &nbsp; </td> </tr>
                 <tr class="CabezoteTabla"> <td align="center"> &nbsp; </td> </tr>
                 <tr class="CabezoteTabla"> <td align="center"> &nbsp; </td> </tr>
                 <tr class="CabezoteTabla"> <td align="center"> &nbsp; </td> </tr>
                </table>';

        echo $cont.$clase->PiePagina();
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: verificarempledo
    // Creación: 23/05/2024		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que valida el empleado seleccionado 
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "verificarempledo")
    {
        $listaperiodos = $_POST['listaperiodos'];
        $codperiodo = $_POST['codperiodo'];
        $periodoid = $_POST['periodoid'];
        $terid = $_POST['terid'];

        // echo $listaperiodos.' -- '.$codperiodo.' -- '.$periodoid.' -- '.$terid; exit();

        // inicialización de variables
        $numliq = 0;
        $numdet = 0;        

        // busco en la tabla liquidacion
        $vsql = "SELECT COUNT(*) numliq FROM liquidacion WHERE periodonomina = '".$codperiodo."' AND terid = ".$terid;
        $numliq = $clase->SeleccionarUno($vsql);

        $vsql = "SELECT COUNT(*) numdet FROM detalleliquidacion WHERE pernominaid IN ($listaperiodos) AND terid = ".$terid;
        $numdet = $clase->SeleccionarUno($vsql);

        // valido que el empleado ya tenga liquidación en este periodo
        if(($numliq > 0) || ($numdet > 0))        
            header("Location: liquidados.php?opcion=editarunaliquidacion&terid=$terid&listaperiodos=$listaperiodos&codperiodo=$codperiodo&periodoid=$periodoid");
        else
        {
            // valido las fechas de ingreso y retiro
            $vsql21 = "SELECT MAX(id) AS id FROM histcontrato WHERE terid = ".$terid;
            $id = $clase->SeleccionarUno($vsql21);
            $ultfecingreso = $clase->BDLockup($id,'histcontrato','id','fecingreso');
            $fecretiro = $clase->BDLockup($id,'histcontrato','id','fecretiro');
    
            if(($fecretiro == NULL) || ($fecretiro == '0000-00-00') || ($fecretiro == ''))
                $fecretiro = $clase->BDLockup($terid,'terceros','terid','fecharetiro');

            if($ultfecingreso >= $fecretiro)
            {
                $clase->Aviso(3,"La fecha de ingreso debe ser inferior a la fecha de retiro");
                header("Location: liquidados.php?opcion=ventanaselempleado&listaperiodos=$listaperiodos&codperiodo=$codperiodo&periodoid=$periodoid");
            }
            else
            {
                $comienzoper = substr($listaperiodos,0,2);
                $finper = substr($listaperiodos,-2);

                $fecdesde = $clase->BDLockup($comienzoper,'periodosnomina','periodoid','fecdesde');
                $fechasta = $clase->BDLockup($finper,'periodosnomina','periodoid','fechasta');
        
                if(($fecretiro >= $fecdesde) && ($fecretiro <= $fechasta))
                    header("Location: liquidados.php?opcion=editarunaliquidacion&terid=$terid&listaperiodos=$listaperiodos&codperiodo=$codperiodo&periodoid=$periodoid");
                else
                {
                    $clase->Aviso(3,"La fecha de retiro no está dentro del periodo a liquidar");
                    header("Location: liquidados.php?opcion=ventanaselempleado&listaperiodos=$listaperiodos&codperiodo=$codperiodo&periodoid=$periodoid");
                }
            }
        }
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: importarexcelliquidados
    // Creación: 29/05/2024		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que pinta la ventana para captar la hoja de Excel con los 
    //              liquidados
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "importarexcelliquidados")
    {
        $listaperiodos = $_GET['listaperiodos'];
        $codperiodo = $_GET['codperiodo'];
        $periodoid = $_GET['periodoid'];

        // nombre del periodo
        $desperiodo = $clase->BDLockup($codperiodo,'periodos','codperiodo','desperiodo');

        $cont = '';
        $servidor = $_SERVER['SERVER_NAME'].":".$_SERVER['SERVER_PORT'];

        // // Validación del servidor
        // if(($servidor!="dromedicas.sytes.net:9996")&&($servidor!="192.168.14.248:9999"))
        //     $cont.='<table width="400">
        //              <tr class="CabezoteTabla"> 
        //               <td align="center"> <b>Servidor incorrecto </b> </td>
        //              </tr> 
        //              <tr class="CabezoteTabla"> 
        //               <td align="center"> 
        //                <font color=red> Este servidor est&aacute; inhabilitado para hacer este <br> 
        //                proceso, por favor diríjase al servidor </font> <br> 
        //                <font color=blue> 192.168.14.248:9999 </font> <br>
        //                <font color=red>o al servidor </font> <br> 
        //                <font color=blue> dromedicas.sytes.net:9996 </font> <br>
        //                <font color=red> para poder ejecutar este proceso </font> <br><br>
        //               </td> 
        //              </tr>
        //              <tr class="TablaDocsPar">
        //               <td width="100%" align="center"> 
        //                <form name="importa" method="post" action="?opcion=""" id="theform" enctype="multipart/form-data">                        
        //                 <input type="submit" name="enviar" id="enviarr"  value="aceptar" class="button blue" />
        //                </form> 
        //               </td>
        //              </tr>
        //             </table>';
        // else
        // {
            // pinto la ventana
            $cont.='<script type="text/javascript" src="lib/jquery-2.1.3.min.js"></script>
                    <script>
                     $(function()
                     {
                      $("#enviarr").on("click",function()
                      {
                        $(this).val("Espere por favor ...")
                        .attr("disabled","disabled");
                        $("#theform").submit();
                      });
                     });
                    </script>';

            // encabezado
            $cont.='<table width="1200">
                     <tr class="CabezoteTabla"> 
                      <td align="center"> <label class="Texto13"> <strong> Importar empleados liquidados <br> <font color="blue">'.strtolower($desperiodo).'</font> </strong> </label> </td> 
                     </tr> 
                    </table>
                    <table width="1200">
                     <tr class="TablaDocsPar"> 
                      <td width="100%" align="center"> 
                       <form name="importa" method="post" action="?opcion=actualizacionterceros" id="theform" enctype="multipart/form-data">
                       <input type="file" name="excel" /><br><br>
                       <input type="submit" name="enviar" id="enviarr"  value="Importar archivo" class="button blue" />
                       <input type="hidden" value="upload" name="action" /> 
                       </form> 
                      </td> 
                     </tr>
                    </table>';

            // Descripción de la hoja
            $cont.='<table width="1200">
                     <tr class="TablaDocsPar">
                      <td align="left"> &nbsp; <label class="Texto12"> La hoja de Excel debe tener la siguiente estructura: </label> </td> 
                     </tr> 
                    </table>
                    <table width="1200">
                     <tr class="TablaDocsPar">
                      <td align="left"> &nbsp; <label class="Texto12"> Columna <b>A</b>: c&oacute;digo </label> </td> 
                      <td align="left"> &nbsp; <label class="Texto12"> Columna <b>B</b>: retiro </label> </td> 
                      <td align="left"> &nbsp; <label class="Texto12"> Columna <b>C</b>: motivo </label> </td> 
                      <td align="left"> &nbsp; <label class="Texto12"> Columna <b>D</b>: regi&oacute;n </label> </td> 
                     </tr>
                     <tr class="TablaDocsPar">
                      <td align="left"> &nbsp; <label class="Texto12"> Columna <b>E</b>: zona </label> </td> 
                      <td align="left"> &nbsp; <label class="Texto12"> Columna <b>F</b>: licencia remunerada </label> </td> 
                      <td align="left"> &nbsp; <label class="Texto12"> Columna <b>G</b>: incapacidad </label> </td> 
                      <td align="left"> &nbsp; <label class="Texto12"> Columna <b>H</b>: incapacidad arl </label> </td> 
                     </tr>
                     <tr class="TablaDocsPar"> 
                      <td align="left"> &nbsp; <label class="Texto12"> Columna <b>I</b>: licencia cumplea&ntilde;os </label> </td> 
                      <td align="left"> &nbsp; <label class="Texto12"> Columna <b>J</b>: licencia no remunerada </label> </td> 
                      <td align="left"> &nbsp; <label class="Texto12"> Columna <b>K</b>: suspensi&oacute;n </label> </td> 
                      <td align="left"> &nbsp; <label class="Texto12"> Columna <b>L</b>: facturas cr&eacute;dito </label> </td> 
                     </tr>
                     <tr class="TablaDocsPar"> 
                      <td align="left"> &nbsp; <label class="Texto12"> Columna <b>M</b>: embargo </label> </td> 
                      <td align="left"> &nbsp; <label class="Texto12"> Columna <b>N</b>: cooptelecuc </label> </td> 
                      <td align="left"> &nbsp; <label class="Texto12"> Columna <b>O</b>: progresa </label> </td> 
                      <td align="left"> &nbsp; <label class="Texto12"> Columna <b>P</b>: &oacute;ptica de todos </label> </td> 
                     </tr>
                     <tr class="TablaDocsPar"> 
                      <td align="left"> &nbsp; <label class="Texto12"> Columna <b>Q</b>: sura </label> </td> 
                      <td align="left"> &nbsp; <label class="Texto12"> Columna <b>R</b>: prestamos </label> </td> 
                      <td align="left"> &nbsp; <label class="Texto12"> Columna <b>S</b>: los olivos </label> </td> 
                      <td align="left"> &nbsp; <label class="Texto12"> Columna <b>T</b>: esperanza </label> </td> 
                     </tr>
                     <tr class="TablaDocsPar"> 
                      <td align="left"> &nbsp; <label class="Texto12"> Columna <b>U</b>: recordar </label> </td> 
                      <td align="left"> &nbsp; <label class="Texto12"> Columna <b>V</b>: seguros b&oacute;livar </label> </td> 
                      <td align="left"> &nbsp; <label class="Texto12"> Columna <b>W</b>: bancolombia </label> </td> 
                      <td align="left"> &nbsp; <label class="Texto12"> Columna <b>X</b>: davivienda </label> </td> 
                     </tr>
                     <tr class="TablaDocsPar"> 
                      <td align="left"> &nbsp; <label class="Texto12"> Columna <b>Y</b>: anticipo de n&oacute;mina </label> </td> 
                      <td align="left"> &nbsp; <label class="Texto12"> Columna <b>Z</b>: cesant&iacute;as año anterior (s/n) </label> </td> 
                      <td align="left"> &nbsp; <label class="Texto12"> Columna <b>AA</b>: intereses cen año anterior (s/n) </label> </td> 
                      <td align="left"> &nbsp; <label class="Texto12"> Columna <b>AB</b>: cesant&iacute;as año actual (s/n) </label> </td> 
                     </tr>
                     <tr class="TablaDocsPar"> 
                      <td align="left"> &nbsp; <label class="Texto12"> Columna <b>AC</b>: intereses cen año actual (s/n) </label> </td> 
                      <td align="left"> &nbsp; <label class="Texto12"> Columna <b>AD</b>: vacaciones </label> </td> 
                      <td align="left"> &nbsp; <label class="Texto12"> Columna <b>AE</b>: primas primer semestre (s/n) </label> </td> 
                      <td align="left"> &nbsp; <label class="Texto12"> Columna <b>AF</b>: primas segundo semestre (s/n) </label> </td> 
                     </tr>
                    </table>';

            // // imagen de ejemplo de la hoja de excel
            // $cont.='<table width="1200">
            //          <tr class="TablaDocsPar"> 
            //           <td align="center"> 
            //            <img src="images/iconos/ejemplolicenciassubirliq.png" width="450" height="200" border="0">
            //           </td> 
            //          </tr>
            //          <tr class="TablaDocsPar"> 
            //           <td width="100%" align="center"> 
            //            <font color="blue"> Importante: Se debe utilizar un archivo de Excel con extensión .xlsx</font>
            //           </td> 
            //          </tr>
            //         </table>';
        // }
        echo $cont;
        exit();
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: subirliquidados
    // Creación: 25/07/2024		última modificación: 11/11/2024
    // Creador: Luis Flórez		modificado por: Luis Flórez
    // Descripción: Opción que pinta la ventana para captar la hoja de Excel con las  
    //              liquidaciones
    // Última modificación: Inclusión de los nuevos conceptos tipo recargos y reorganización 
    //                      de los demás 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "subirliquidados")
    {
        $codperiodo = $_GET['codperiodo'];

        $cont = '';
        $servidor = $_SERVER['SERVER_NAME'].":".$_SERVER['SERVER_PORT'];

        // // Validación del servidor
        // if(($servidor!="dromedicas.sytes.net:9996")&&($servidor!="192.168.14.248:9999"))
        //     $cont.='<table width="400">
        //              <tr class="CabezoteTabla"> 
        //               <td align="center"> <b>Servidor incorrecto </b> </td>
        //              </tr> 
        //              <tr class="CabezoteTabla"> 
        //               <td align="center"> 
        //                <font color=red> Este servidor est&aacute; inhabilitado para hacer este <br> 
        //                proceso, por favor dir&iacute;jase al servidor </font> <br>
        //                <a href="http://192.168.14.248:9999/dropos/login/" target="_blank"> 
        //                 <font color=blue> 192.168.14.248:9999 </font> <br>                        
        //                </a>
        //                <font color=red> para poder importar estos datos </font> <br><br>
        //               </td> 
        //              </tr>
        //              <tr class="TablaDocsPar">
        //               <td width="100%" align="center"> 
        //                <form name="importa" method="post" action="?opcion="liquidados.php"" id="theform" enctype="multipart/form-data">                        
        //                 <input type="submit" name="enviar" id="enviarr"  value="aceptar" class="button blue" />
        //                </form> 
        //               </td>
        //              </tr>
        //             </table>';
        // else
        // {
            // nombre del periodo
            $desperiodo = $clase->BDLockup($codperiodo,'periodos','codperiodo','desperiodo');

            // pinto la ventana
            $cont.='<script type="text/javascript" src="lib/jquery-2.1.3.min.js"></script>
                    <script>
                     $(function()
                      {
                        $("#enviarr").on("click",function()
                       {
                        $(this).val("Espere por favor ...")
                        .attr("disabled","disabled");
                        $("#theform").submit();
                       });    
                      });
                    </script>';

            // encabezado
            $cont.='<table width="950">
                     <tr class="CabezoteTabla"> 
                      <td align="center"> <label class="Texto13"> <strong> Importar empleados liquidados <br> <font color="blue">'.strtolower($desperiodo).'</font> </strong> </label> </td> 
                     </tr> 
                    </table>
                    <table width="950">
                     <tr class="TablaDocsPar"> 
                      <td width="100%" align="center"> 
                       <form name="importa" method="post" action="?opcion=calcularliqmasivamente" id="theform" enctype="multipart/form-data">
                       <input type="hidden" name = "codperiodo" value = "'.$codperiodo.'">
                       <input type="file" name="excel" /><br><br>
                       <input type="submit" name="enviar" id="enviarr"  value="Importar archivo" class="button blue" />
                       <input type="hidden" value="upload" name="action" /> 
                       </form> 
                      </td> 
                     </tr>
                    </table>';
    
            // Título
            $cont.='<table width="950">
                     <tr class="TablaDocsPar"> 
                      <td width="100%" align="center"> 
                       <label class="Texto13"><strong>La hoja de Excel debe tener la siguiente estructura: </strong></label>
                      </td> 
                     </tr>
                    </table>';

            // estructura de la tabla
            $cont.='<table width="950">
                     <tr class="TablaDocsPar"> 
                      <td align="left"> &nbsp; Columna <b>A</b>: c&odigo </td> 
                      <td align="left"> &nbsp; Columna <b>B</b>: cesant&iacute;as a&ntilde;o anterior (SI/NO) </td> 
                      <td align="left"> &nbsp; Columna <b>C</b>: intereses cesant&iacute;as a&ntilde;o anterior (SI/NO) </td> 
                     </tr>
                     <tr class="TablaDocsPar"> 
                      <td align="left"> &nbsp; Columna <b>D</b>: cesant&iacute;as a&ntilde;o actual (SI/NO) </td> 
                      <td align="left"> &nbsp; Columna <b>E</b>: intereses cesant&iacute;as a&ntilde;o actual (SI/NO) </td> 
                      <td align="left"> &nbsp; Columna <b>F</b>: vacaciones (fecha) </td> 
                     </tr>
                     <tr class="TablaDocsPar"> 
                      <td align="left"> &nbsp; Columna <b>G</b>: primas primer semestre (SI/NO) </td> 
                      <td align="left"> &nbsp; Columna <b>H</b>: primas segundo semestre (SI/NO) </td> 
                      <td align="left"> &nbsp; Columna <b>I</b>: fecha de ingreso (formato aaaa-mm-dd) </td> 
                     </tr>
                     <tr class="TablaDocsPar"> 
                      <td align="left"> &nbsp; Columna <b>J</b>: fecha de retiro (formato aaaa-mm-dd) </td> 
                      <td align="left"> &nbsp; Columna <b>K</b>: calcular quincena (SI/NO) </td> 
                      <td align="left"> &nbsp; Columna <b>L</b>: Indemnizaci&oacute;n </td> 
                     </tr>
                     <tr class="TablaDocsPar"> 
                      <td align="left"> &nbsp; Columna <b>M</b>: Recargo nocturno </td> 
                      <td align="left"> &nbsp; Columna <b>N</b>: Hora extra diurna </td> 
                      <td align="left"> &nbsp; Columna <b>O</b>: Hora extra nocturna </td> 
                     </tr>
                     <tr class="TablaDocsPar"> 
                      <td align="left"> &nbsp; Columna <b>P</b>: Hora extra diurna dominical </td> 
                      <td align="left"> &nbsp; Columna <b>Q</b>: Hora extra nocturna dominical y festivo </td> 
                      <td align="left"> &nbsp; Columna <b>R</b>: Domingos y festivos </td> 
                     </tr>
                     <tr class="TablaDocsPar"> 
                      <td align="left"> &nbsp; Columna <b>S</b>: Recargo nocturno dominical y festivo </td> 
                      <td align="left"> &nbsp; Columna <b>T</b>: LNR </td> 
                      <td align="left"> &nbsp; Columna <b>U</b>: Suspensi&oacute;n </td> 
                     </tr>
                     <tr class="TablaDocsPar"> 
                      <td align="left"> &nbsp; Columna <b>V</b>: Incapacidad </td> 
                      <td align="left"> &nbsp; Columna <b>W</b>: Maternidad </td> 
                      <td align="left"> &nbsp; Columna <b>X</b>: Paternidad </td> 
                     </tr>
                     <tr class="TablaDocsPar"> 
                      <td align="left"> &nbsp; Columna <b>Y</b>: Licencia remunerada </td> 
                      <td align="left"> &nbsp; Columna <b>Z</b>: Cumplea&ntilde;os </td> 
                      <td align="left"> &nbsp; Columna <b>AA</b>: Matrimonio </td> 
                     </tr>
                     <tr class="TablaDocsPar"> 
                      <td align="left"> &nbsp; Columna <b>AB</b>: Incapacidad ARL </td> 
                      <td align="left"> &nbsp; Columna <b>AC</b>: Incapacidad +180 </td> 
                      <td align="left"> &nbsp; Columna <b>AD</b>: D&iacute;a de la familia </td> 
                     </tr>
                     <tr class="TablaDocsPar"> 
                      <td align="left"> &nbsp; Columna <b>AE</b>: Facturas cr&eacute;dito </td> 
                      <td align="left"> &nbsp; Columna <b>AF</b>: Embargo </td> 
                      <td align="left"> &nbsp; Columna <b>AG</b>: Cooptelecuc </td> 
                     </tr>
                     <tr class="TablaDocsPar"> 
                      <td align="left"> &nbsp; Columna <b>AH</b>: Progressa </td> 
                      <td align="left"> &nbsp; Columna <b>AI</b>: &Oacute;ptica para todos </td> 
                      <td align="left"> &nbsp; Columna <b>AJ</b>: Suramericana </td> 
                     </tr>
                     <tr class="TablaDocsPar"> 
                      <td align="left"> &nbsp; Columna <b>AK</b>: Pr&eacute;stamos personales </td> 
                      <td align="left"> &nbsp; Columna <b>AL</b>: Los olivos </td> 
                      <td align="left"> &nbsp; Columna <b>AM</b>: La esperanza </td> 
                     </tr>
                     <tr class="TablaDocsPar"> 
                      <td align="left"> &nbsp; Columna <b>AN</b>: Recordar </td> 
                      <td align="left"> &nbsp; Columna <b>AO</b>: Seguros Bol&iacute;var </td> 
                      <td align="left"> &nbsp; Columna <b>AP</b>: Bancolombia </td> 
                     </tr>
                     <tr class="TablaDocsPar"> 
                      <td align="left"> &nbsp; Columna <b>AQ</b>: Davivienda </td> 
                      <td align="left"> &nbsp; Columna <b>AR</b>: Anticipo de nómina </td> 
                      <td align="left"> &nbsp; </td> 
                     </tr>
                    </table>';

            // imagen de ejemplo de la hoja de excel
            $cont.='<table width="950">
                     <!-- -----------------------------------------------------------------------------------------
                     <tr class="TablaDocsPar"> 
                      <td align="center"> 
                       <img src="images/iconos/ejemplolicenciassubirliq.png" width="450" height="200" border="0">
                      </td> 
                     </tr>
                     ------------------------------------------------------------------------------------------ -->
                     <tr class="TablaDocsPar"> 
                      <td width="100%" align="center"> 
                       <font color="blue"> Importante: Se debe utilizar un archivo de Excel con extensión .xlsx</font>
                      </td> 
                     </tr>
                    </table>';
        // }
        echo $cont;
        exit();
    }    

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: calcularliqmasivamente
    // Creación: 17/08/2024		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que calcula masivamente las liquidaciones de acuerdo a la hoja 
    //              previamente seleccionada
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "calcularliqmasivamente")
    {
		set_time_limit(0);
		extract($_POST);		
        $codperiodo = $_POST["codperiodo"];
		$archivo = $_FILES['excel']['name'];
		$tipo = $_FILES['excel']['type'];
		$destino = "recursos/xls/bak_".$archivo;        

        // Valido que la extensión del archivo sea xlsx
        $extension = pathinfo($destino, PATHINFO_EXTENSION);
        
        if($extension!="xlsx")
        {
            $clase->Aviso(3,"El archivo debe tener extensión .xlsx");
            header("Location: liquidados.php");
        }
        else
        {
            /// Valido si se cargó el archivo o no
            if (!copy($_FILES['excel']['tmp_name'],$destino))
                echo "Error Al Cargar el Archivo";
        
            if (file_exists ("recursos/xls/bak_".$archivo))
            {
                require_once('lib/PHPExcel.php');
                require_once('lib/PHPExcel/Reader/Excel2007.php');                               
                
                $objReader = new PHPExcel_Reader_Excel2007();
                $objPHPExcel = $objReader->load("recursos/xls/bak_".$archivo);
                $objFecha = new PHPExcel_Shared_Date();
                $objPHPExcel->setActiveSheetIndex(0);
                $conex = $clase->Conectar();
                $recorrer = true;  $i = 1;                

                while($recorrer)
                {
                    $_DATOS_EXCEL[$i]['codvende'] = $objPHPExcel->getActiveSheet()->getCell('A'.$i)->getCalculatedValue();
                    $_DATOS_EXCEL[$i]['cesantiasyearanterior'] = $objPHPExcel->getActiveSheet()->getCell('B'.$i)->getCalculatedValue();
                    $_DATOS_EXCEL[$i]['intcesantiasyearanterior'] = $objPHPExcel->getActiveSheet()->getCell('C'.$i)->getCalculatedValue();
                    $_DATOS_EXCEL[$i]['cesantiasyearactual'] = $objPHPExcel->getActiveSheet()->getCell('D'.$i)->getCalculatedValue();
                    $_DATOS_EXCEL[$i]['intcesantiasyearactual'] = $objPHPExcel->getActiveSheet()->getCell('E'.$i)->getCalculatedValue();
                    $_DATOS_EXCEL[$i]['vacaciones'] = $objPHPExcel->getActiveSheet()->getCell('F'.$i)->getCalculatedValue();
                    $_DATOS_EXCEL[$i]['primasprimersemestre'] = $objPHPExcel->getActiveSheet()->getCell('G'.$i)->getCalculatedValue();
                    $_DATOS_EXCEL[$i]['primassegundosemestre'] = $objPHPExcel->getActiveSheet()->getCell('H'.$i)->getCalculatedValue();
                    $_DATOS_EXCEL[$i]['fecingreso'] = $objPHPExcel->getActiveSheet()->getCell('I'.$i);
                    $_DATOS_EXCEL[$i]['fecretiro'] = $objPHPExcel->getActiveSheet()->getCell('J'.$i);
                    $_DATOS_EXCEL[$i]['calcularquin'] = $objPHPExcel->getActiveSheet()->getCell('K'.$i)->getCalculatedValue();
                    $_DATOS_EXCEL[$i]['indemnizacion'] = $objPHPExcel->getActiveSheet()->getCell('L'.$i)->getCalculatedValue();
                    $_DATOS_EXCEL[$i]['recargonoc'] = $objPHPExcel->getActiveSheet()->getCell('M'.$i)->getCalculatedValue();
                    $_DATOS_EXCEL[$i]['recargonocmedellin'] = $objPHPExcel->getActiveSheet()->getCell('N'.$i)->getCalculatedValue();
                    $_DATOS_EXCEL[$i]['horaextradiurna'] = $objPHPExcel->getActiveSheet()->getCell('O'.$i)->getCalculatedValue();
                    $_DATOS_EXCEL[$i]['horaextranoc'] = $objPHPExcel->getActiveSheet()->getCell('P'.$i)->getCalculatedValue();
                    $_DATOS_EXCEL[$i]['horaextradiurnadom'] = $objPHPExcel->getActiveSheet()->getCell('Q'.$i)->getCalculatedValue();
                    $_DATOS_EXCEL[$i]['horaextranocdomfes'] = $objPHPExcel->getActiveSheet()->getCell('R'.$i)->getCalculatedValue();
                    $_DATOS_EXCEL[$i]['domingosfestivos'] = $objPHPExcel->getActiveSheet()->getCell('S'.$i)->getCalculatedValue();
                    $_DATOS_EXCEL[$i]['recargonocdomfes'] = $objPHPExcel->getActiveSheet()->getCell('T'.$i)->getCalculatedValue();
                    $_DATOS_EXCEL[$i]['lnr'] = $objPHPExcel->getActiveSheet()->getCell('U'.$i)->getCalculatedValue();
                    $_DATOS_EXCEL[$i]['suspension'] = $objPHPExcel->getActiveSheet()->getCell('V'.$i)->getCalculatedValue();
                    $_DATOS_EXCEL[$i]['incapacidad'] = $objPHPExcel->getActiveSheet()->getCell('W'.$i)->getCalculatedValue();
                    $_DATOS_EXCEL[$i]['maternidad'] = $objPHPExcel->getActiveSheet()->getCell('X'.$i)->getCalculatedValue();
                    $_DATOS_EXCEL[$i]['paternidad'] = $objPHPExcel->getActiveSheet()->getCell('Y'.$i)->getCalculatedValue();
                    $_DATOS_EXCEL[$i]['licenciaremunerada'] = $objPHPExcel->getActiveSheet()->getCell('Z'.$i)->getCalculatedValue();
                    $_DATOS_EXCEL[$i]['birthday'] = $objPHPExcel->getActiveSheet()->getCell('AA'.$i)->getCalculatedValue();
                    $_DATOS_EXCEL[$i]['matrimonio'] = $objPHPExcel->getActiveSheet()->getCell('AB'.$i)->getCalculatedValue();
                    $_DATOS_EXCEL[$i]['incapacidadarl'] = $objPHPExcel->getActiveSheet()->getCell('AC'.$i)->getCalculatedValue();
                    $_DATOS_EXCEL[$i]['incapacidad180'] = $objPHPExcel->getActiveSheet()->getCell('AD'.$i)->getCalculatedValue();
                    $_DATOS_EXCEL[$i]['familia'] = $objPHPExcel->getActiveSheet()->getCell('AE'.$i)->getCalculatedValue();
                    $_DATOS_EXCEL[$i]['facturascredito'] = $objPHPExcel->getActiveSheet()->getCell('AF'.$i)->getCalculatedValue();
                    $_DATOS_EXCEL[$i]['embargo'] = $objPHPExcel->getActiveSheet()->getCell('AG'.$i)->getCalculatedValue();
                    $_DATOS_EXCEL[$i]['cooptelecuc'] = $objPHPExcel->getActiveSheet()->getCell('AH'.$i)->getCalculatedValue();
                    $_DATOS_EXCEL[$i]['progressa'] = $objPHPExcel->getActiveSheet()->getCell('AI'.$i)->getCalculatedValue();
                    $_DATOS_EXCEL[$i]['opticaparatodos'] = $objPHPExcel->getActiveSheet()->getCell('AJ'.$i)->getCalculatedValue();
                    $_DATOS_EXCEL[$i]['suramericana'] = $objPHPExcel->getActiveSheet()->getCell('AK'.$i)->getCalculatedValue();
                    $_DATOS_EXCEL[$i]['prestamos'] = $objPHPExcel->getActiveSheet()->getCell('AL'.$i)->getCalculatedValue();
                    $_DATOS_EXCEL[$i]['losolivos'] = $objPHPExcel->getActiveSheet()->getCell('AM'.$i)->getCalculatedValue();
                    $_DATOS_EXCEL[$i]['laesperanza'] = $objPHPExcel->getActiveSheet()->getCell('AN'.$i)->getCalculatedValue();
                    $_DATOS_EXCEL[$i]['recordar'] = $objPHPExcel->getActiveSheet()->getCell('AO'.$i)->getCalculatedValue();
                    $_DATOS_EXCEL[$i]['segurosbolivar'] = $objPHPExcel->getActiveSheet()->getCell('AP'.$i)->getCalculatedValue();
                    $_DATOS_EXCEL[$i]['bancolombia'] = $objPHPExcel->getActiveSheet()->getCell('AQ'.$i)->getCalculatedValue();
                    $_DATOS_EXCEL[$i]['davivienda'] = $objPHPExcel->getActiveSheet()->getCell('AR'.$i)->getCalculatedValue();
                    $_DATOS_EXCEL[$i]['anticipodenomina'] = $objPHPExcel->getActiveSheet()->getCell('AS'.$i)->getCalculatedValue();
                
                    if(strlen($_DATOS_EXCEL[$i]['codvende']) == 0)
                        $recorrer = false;
                    
                    $i++;
                } /// Fin del While
            }
            else
            { echo "Necesitas primero importar el archivo";  }  /// Si NO Cargó el archivo

            // ------------------------------------------------------------------------------------------ //
            //Teniendo la Informacion en el Array la inserto en la Base de Datos
            $errores = 0;
            $grabados = 0;            

            $desperiodo = $clase->BDLockup($codperiodo,'periodos','codperiodo','desperiodo');
            $carpetaactual = 'reportes/';

            // Construcción de la variable con los documentos no grabados
            $nocedulas = 'EMPLEADOS LIQUIDADOS'.Chr(13).Chr(10);
            $nocedulas.= ''.str_pad($desperiodo,1,"").''.Chr(13).Chr(10);
            $nocedulas.= 'DOCUMENTOS NO GRABADOS:'.Chr(13).Chr(10);
            $nocedulas.= ''.Chr(13).Chr(10);

            for($j=1; $j < $i; $j++)
            {
                // inicializo las variables
                $lbgrabo = false;                               $basico = 0;                            $auxtrans = $_SESSION['N_AUXTRANS2020'];
                $smlv = $_SESSION['N_SALMIN2020'];              $numparam = 0;                          $sueldo = 0;
                $vsqlparam = "";                                $numparam = 0;                          $vsql69 = "";
                $vsql17 = "";                                   $vsql18 = "";                           $idhistorico = 0;
                $vsql42 = "";                                   $vsql41 = "";                           $diastrab = 0;
                $difendias = 0;                                 $numreg = 0;                            $valsubtrasp = 0;
                $cargoid = 0;                                   $aplicatransporte = 0;                  $subsidiotransporte = 0;
                $conceptoid = 0;                                $montolicencia = 0;                     $tipodc = "";
                $porcbasico = 0;                                $dias = 0;                              $totnovedades = 0;
                $totrecargos = 0;                               $sueldodeducciones = 0;                 $extralegal = "";
                $epsid = 0;                                     $pensionesid = 0;                       $aplicapension = "";
                $aplicasalud = "";                              $pension = 0;                           $salud = 0;
                $monto = 0;                                     $numeroid = 0;                          $yearingreso = 0;
                $promsueldoact = 0;                             $yearprev = 0;                          $basicoant = 0;
                $auxtransant = 0;                               $diasyearant = 0;                       $sueldointegralant = 0;
                $periodoidant = 0;                              $basicoant = 0;                         $vsql25 = "";
                $permin2 = 0;                                   $vsql26 = "";                           $auxtransant = 0;
                $sueldointegralant = 0;                         $eneroant = 0;                          $diasyearant = 0;
                $comienzoprimersemestre = "";                   $finprimersemestre = "";                $primeroenero = 0;
                $treintajunio = 0;                              $diasliq = 0;                           $inisegsemestre = "";
                $finsegsemestre = "";                           $primerojulio = 0;                      $treintayuno = 0;
                $primerojulio = 0;                              $treintayuno = 0;                       $cargoid = 0;
                $aplicatransporte = "";                         $fechainicesantias = "";                $diascesantias = 0;
                $cantidadact = 0;                               $pervacaciones = 0;                     $fecprevaca = "";
                $diasvacaciones = 0;                            $ultimobasico = 0;                      $ultimoperbasico = 0;
                $recarnonocturno = 0;                           $pagoprimasps = 0;                      $pagoprimasss = 0;
                $pagoprimas = 0;                                $basicoinf = 0;                         $dni = "";                
                $nombreempleado = "";                           $vsq22 = "";                            $otrosdevengados = "";
                $vsq23 = "";                                    $otrosdescuentos = 0;                   $totaldevengado = 0;
                $totaldescuento = 0;                            $netoapagar = 0;                        $vsqlnorecalcular = "";
                $norecalcularaux = "";                          $auxcodper = "";                        $vsqlsegsoc = "";
                $valseguridadsocial = 0;                        $vsql188 = "";                          $numhistorico = 0;
                $ultsueldo = 0;                                 $idcondicionaux = 0;

                // Validación del código del empleado
                $codvende = $_DATOS_EXCEL[$j]['codvende'];

                // depuración del código de vendedor
                if(substr($codvende,0,1) == "'")
                    $codvende = substr($codvende,1,strlen($codvende));
                
                $terid = $clase->SeleccionarUno("SELECT terid FROM terceros WHERE codvende = '".$codvende."' AND basico > 0");

                if($terid != "")
                {
                    // fechas de ingreso y retiro
                    $fecingreso = $_DATOS_EXCEL[$j]['fecingreso'];
                    $fecretiro = $_DATOS_EXCEL[$j]['fecretiro'];

                    // validación del estado de la liquidación
                    $vsqlnorecalcular = "SELECT norecalcular FROM parametrosliquidacion WHERE terid = ".$terid." AND codperiodo = '".$codperiodo."'";
                    $norecalcularaux = $clase->SeleccionarUno($vsqlnorecalcular);

                    // Validación de las fechas de ingreso y retiro y estatus de la liquidación
                    if((strlen($fecingreso) > 0) && (strlen($fecretiro) > 0) && ($norecalcularaux != "CHECKED"))
                    {
                        if(substr($fecretiro,0,1) != "'")
                            $fecretiro = "'".$fecretiro;

                        // Obtengo el periodo de acuerdo a la fecha de retiro
                        $auxcodper = substr($fecretiro,6,2).substr($fecretiro,1,4);
                        $codperiodo = $auxcodper;

                        // Parámetros establecidos en la hoja de Excel
                        $cesantiasyearanterior = strtoupper($_DATOS_EXCEL[$j]['cesantiasyearanterior']);
                        $cesantiasyearactual = strtoupper($_DATOS_EXCEL[$j]['cesantiasyearactual']);
                        $intcesantiasyearanterior = strtoupper($_DATOS_EXCEL[$j]['intcesantiasyearanterior']);
                        $intcesantiasyearactual = strtoupper($_DATOS_EXCEL[$j]['intcesantiasyearactual']);
                        $vacaciones = strtoupper($_DATOS_EXCEL[$j]['vacaciones']);
                        $primasprimersemestre = strtoupper($_DATOS_EXCEL[$j]['primasprimersemestre']);
                        $primassegundosemestre = strtoupper($_DATOS_EXCEL[$j]['primassegundosemestre']);
                        $calcularquin = strtoupper($_DATOS_EXCEL[$j]['calcularquin']);
                        $nroquincena = 0;
                        $norecalcular = "";

                        // valido que el empleado exista en la tabla parametrosliquidacion
                        $vsqlparam = "SELECT COUNT(*) numparam FROM parametrosliquidacion WHERE terid = ".$terid." AND codperiodo = '".$codperiodo."'";
                        $numparam = $clase->SeleccionarUno($vsqlparam);

                        if($numparam > 0)
                        {
                            $vsql69 = "DELETE FROM parametrosliquidacion WHERE codperiodo = '".$codperiodo."' AND terid = ".$terid;
                            $clase->EjecutarSQL($vsql69);                            
                        }

                        // Almaceno en la tabla de parámetros de cálculo masivo de las liquidaciones
                        $vsql69 = "INSERT INTO parametrosliquidacion (terid,codperiodo,cesantiasyearanterior,cesantiasyearactual,intcesantiasyearanterior,intcesantiasyearactual,vacaciones,primasprimersemestre,
                                                                      primassegundosemestre,calcularquin,nroquincena,norecalcular) 
                                         VALUE (".$terid.",'".$codperiodo."','".$cesantiasyearanterior."','".$cesantiasyearactual."','".$intcesantiasyearanterior."','".$intcesantiasyearactual."',
                                                '".$vacaciones."','".$primasprimersemestre."','".$primassegundosemestre."','".$calcularquin."',".$nroquincena.",'".$norecalcular."')";
                        $clase->EjecutarSQL($vsql69);

                        // ---------------------------------------------------------------------------------------------------- //
                        $vsql69 = "DELETE FROM liquidacion WHERE terid = ".$terid." AND periodonomina = '".$codperiodo."'";
                        $clase->EjecutarSQL($vsql69);

                        $listaperiodos = generarlistaper($codperiodo);

                        $vsql69 = "DELETE FROM detalleliquidacion WHERE pernominaid IN ($listaperiodos) AND terid = ".$terid;
                        $clase->EjecutarSQL($vsql69);                        

                        $vsql69 = "DELETE FROM tmpinfliquidados WHERE terid = ".$terid." AND codperiodo = '".$codperiodo."'";
                        $clase->EjecutarSQL($vsql69);

                        // ---------------------------------------------------------------------------------------------------- //
                        $basico = $clase->BDLockup($terid,"terceros","terid","basico");

                        // --------------------------------------------------------------------------------------------------------------- //
                        // actualizo las fechas de ingreso y retiro
                        $vsql188 = "SELECT COUNT(*) numhistorico FROM histcontrato WHERE terid = ".$terid;
                        $numhistorico = $clase->SeleccionarUno($vsql188);                        

                        if($numhistorico > 0)
                        {
                            // actualización en el histórico de contrato
                            $vsql18 = "SELECT MAX(id) FROM histcontrato WHERE terid = ".$terid;
                            $idhistorico = $clase->SeleccionarUno($vsql18);
    
                            // depuro la fecha de ingreso en caso de ser necesario
                            if(substr($fecingreso,0,1) == "'")
                                $fecingreso = substr($fecingreso,1,strlen($fecingreso));
    
                            $vsql42 = "UPDATE histcontrato SET fecingreso = '".$fecingreso."' WHERE id = ".$idhistorico;
                            $clase->EjecutarSQL($vsql42);
    
                            // depuro la fecha de retiro en caso de ser necesario
                            if(substr($fecretiro,0,1) == "'")
                                $fecretiro = substr($fecretiro,1,strlen($fecretiro));
    
                            $vsql42 = "UPDATE histcontrato SET fecretiro = '".$fecretiro."' WHERE id = ".$idhistorico;
                            $clase->EjecutarSQL($vsql42);
                    
                            // actualizo en terceros
                            $vsql41 = "UPDATE terceros SET fecharetiro = '".$fecretiro."' WHERE terid = ".$idhistorico;
                            $clase->EjecutarSQL($vsql41);
                        }
                        else
                        {
                            $ultsueldo = $clase->BDLockup($terid,'terceros','terid','basico');
                            $idcondicionaux = $clase->BDLockup($terid,'terceros','terid','idcondicion');

                            if($idcondicionaux == "")
                                $idcondicionaux = 0;

                            // depuro la fecha de ingreso en caso de ser necesario
                            if(substr($fecingreso,0,1) == "'")
                                $fecingreso = substr($fecingreso,1,strlen($fecingreso));

                            // depuro la fecha de retiro en caso de ser necesario
                            if(substr($fecretiro,0,1) == "'")
                                $fecretiro = substr($fecretiro,1,strlen($fecretiro));                                

                            $vsql41 = "INSERT INTO histcontrato (terid,fecingreso,fecretiro,ultsueldo,idcondicion) 
                                            VALUE (".$terid.",'".$fecingreso."','".$fecretiro."',".$ultsueldo.",".$idcondicionaux.")";
                            $clase->EjecutarSQL($vsql41);
                        }

                        // periodo en la cual se procesará la liquidación
                        $vsqlper = "SELECT periodoid FROM periodosnomina WHERE fecdesde <= '".$fecretiro."' AND fechasta >= '".$fecretiro."'";
                        $periodoidliq = $clase->SeleccionarUno($vsqlper);

                        // Calculo los días de quincena
                        if(($calcularquin == "SI") || ($calcularquin == "si") || ($calcularquin == "X") || ($calcularquin == "x"))
                        {
                            // Establezco los días trabajados
                            $fecdesde = $clase->BDLockup($periodoidliq,'periodosnomina','periodoid','fecdesde');
                            $fechasta = $clase->BDLockup($periodoidliq,'periodosnomina','periodoid','fechasta');

                            // Cálculo los días trabajados en caso de que el empleado haya ingresado durante este periodo
                            if(($fecingreso>=$fecdesde)&&($fecingreso<=$fechasta))
                            {
                                $diastrab = 0;

                                // Procedo a calcular los días que trabajó durante el periodo
                                $fecha1= new DateTime($fecingreso);
                                $fecha2= new DateTime($fechasta);
                                $diff = $fecha1->diff($fecha2);
                                
                                $difendias = $diff->days;
                                $diastrab = $difendias + 1;
            
                                $diadesde = substr($fecdesde, -2);
                                if($diadesde=="16")
                                {
                                    $fechaEntera = strtotime($fechasta);
                                    $valdias = date("d", $fechaEntera);
                                    if($valdias=="28")          $diastrab += 2;
                                    if($valdias=="29")          $diastrab += 1;
                                    if($valdias=="31")          $diastrab -= 1;
                                }

                                $diastrab2 = $diastrab;
                            }

                            // Valido si la fecha de retiro está dentro del rango de periodo
                            if(($fecretiro>=$fecdesde)&&($fecretiro<=$fechasta))
                            {
                                $diastrab = 0;

                                // Procedo a calcular los días que trabajó durante el periodo
                                $fecha1= new DateTime($fecdesde);
                                $fecha2= new DateTime($fecretiro);
                                $diff = $fecha1->diff($fecha2);
                                
                                $difendias = $diff->days;
                                $diastrab = $difendias + 1;

                                $diastrab2 = $diastrab;
                            }

                            // valido si el empleado tiene fecha de ingreso y retiro dentro del periodo
                            if((($fecingreso>=$fecdesde)&&($fecingreso<=$fechasta)) && (($fecretiro>=$fecdesde)&&($fecretiro<=$fechasta)))
                            {
                                $diastrab = 0;

                                // Procedo a calcular los días que trabajó durante el periodo
                                $fecha1= new DateTime($fecingreso);
                                $fecha2= new DateTime($fecretiro);
                                $diff = $fecha1->diff($fecha2);
                                
                                $difendias = $diff->days;
                                $diastrab = $difendias + 1;

                                $diastrab2 = $diastrab;
                            }

                            if($diastrab >= 16)
                                $diastrab = 15;

                            if($diastrab2 >= 16)
                                $diastrab2 = 15;

                            // obtengo los montos de las licencias
                            $lnr = $_DATOS_EXCEL[$j]['lnr'];
                            $suspension = $_DATOS_EXCEL[$j]['suspension'];
                            $incapacidad = $_DATOS_EXCEL[$j]['incapacidad'];
                            $maternidad = $_DATOS_EXCEL[$j]['maternidad'];
                            $paternidad = $_DATOS_EXCEL[$j]['paternidad'];
                            $licenciaremunerada = $_DATOS_EXCEL[$j]['licenciaremunerada'];
                            $birthday = $_DATOS_EXCEL[$j]['birthday'];
                            $matrimonio = $_DATOS_EXCEL[$j]['matrimonio'];
                            $incapacidadarl = $_DATOS_EXCEL[$j]['incapacidadarl'];
                            $incapacidad180 = $_DATOS_EXCEL[$j]['incapacidad180'];
                            $familia = $_DATOS_EXCEL[$j]['familia'];

                            // resto los días por licencia
                            if($lnr > 0)
                                $diastrab -= $lnr;

                            if($suspension > 0)
                                $diastrab -= $suspension;

                            if($incapacidad > 0)
                                $diastrab -= $incapacidad;

                            if($maternidad > 0)
                                $diastrab -= $maternidad;

                            if($paternidad > 0)
                                $diastrab -= $paternidad;

                            if($licenciaremunerada > 0)
                                $diastrab -= $licenciaremunerada;

                            if($birthday > 0)
                                $diastrab -= $birthday;

                            if($matrimonio > 0)
                                $diastrab -= $matrimonio;

                            if($incapacidadarl > 0)
                                $diastrab -= $incapacidadarl;

                            if($incapacidad180 > 0)
                                $diastrab -= $incapacidad180;

                            if($familia > 0)
                                $diastrab -= $familia;

                            // calculo el sueldo
                            if($diastrab > 0)
                            {
                                // Obtengo la formula del sueldo
                                $formulabasico = $clase->SeleccionarUno("SELECT formula FROM conceptosnomina WHERE conceptoid = 1");
        
                                // Calculo el sueldo básico
                                eval("\$sueldo = $formulabasico;");
                                $sueldo = round($sueldo,0);

                                // sueldo
                                $numreg = $clase->SeleccionarUno("SELECT max(detalleid) FROM detalleliquidacion");
                                $numreg++;
                                $clase->EjecutarSQL("INSERT INTO detalleliquidacion VALUES ($numreg,".$terid.",1,".$periodoidliq.",".$sueldo.",0,".$diastrab.",$basico)");

                                // Calculo el subsidio de transporte
                                // Variable para la validación del auxilio de transporte
                                $valsubtrasp = $smlv * 2;
        
                                // Obtengo la formula para el subsidio de transporte
                                $auxtrans = $_SESSION['N_AUXTRANS2020'];
                                $formulatransporte = $clase->SeleccionarUno("SELECT formula FROM conceptosnomina WHERE conceptoid = 3");
        
                                $cargoid = $clase->BDLockup($terid,'terceros','terid','cargoid');                       // Obtengo el cargo del empleado
                                $aplicatransporte = $clase->BDLockup($cargoid,'cargos','cargoid','aplicatransporte');   // Obtengo el control del cálculo de subsidio de transporte
        
                                if(($basico <= $valsubtrasp)&&($aplicatransporte=="CHECKED"))
                                {
                                    // Calculo el subsidio de transporte
                                    $aux_trans = $diastrab;
        
                                    eval("\$subsidiotransporte = $formulatransporte;");
                                    $subsidiotransporte = round($subsidiotransporte,0);
                                }
                                else
                                    $subsidiotransporte = 0;

                                // Obtengo el valor del subsidio de transporte
                                $valsubtransporte = $_SESSION['N_AUXTRANS2020'];        
                                
                                $numreg = $clase->SeleccionarUno("SELECT max(detalleid) FROM detalleliquidacion");
                                $numreg++;
                                $clase->EjecutarSQL("INSERT INTO detalleliquidacion VALUES ($numreg,".$terid.",3,".$periodoidliq.",".$subsidiotransporte.",0,".$diastrab.",$valsubtransporte)");
                            }
                            else
                                $sueldo = 0;

                            // ahora calculos las novedades

                            // licencia no remunerada
                            if($lnr > 0)
                            {
                                $conceptoid = 6;
                                $dias = $lnr;

                                // Obtengo la formula de la licencia
                                $formulalice = $clase->SeleccionarUno("SELECT formula FROM conceptosnomina WHERE conceptoid = ".$conceptoid."");

                                eval("\$montolicencia = $formulalice;");
                                $montolicencia = round($montolicencia,0);

                                // Calculo el nuevo ID
                                $numid = $clase->SeleccionarUno("SELECT max(detalleid) FROM detalleliquidacion");
                                $numid++;

                                // Obtengo el tipo de licencia
                                $tipodc = $clase->BDLockup($conceptoid,'conceptosnomina','conceptoid','tipodc');

                                if($tipodc=="C")
                                    $vsql = "INSERT INTO detalleliquidacion (detalleid,terid,conceptoid,pernominaid,devengados,descuentos,valor,saldo) 
                                                                VALUES ($numid,".$terid.",".$conceptoid.",".$periodoidliq.",".$montolicencia.",0,".$dias.",".$basico.")";
                                else
                                    $vsql = "INSERT INTO detalleliquidacion (detalleid,terid,conceptoid,pernominaid,devengados,descuentos,valor,saldo) 
                                                                VALUES ($numid,".$terid.",".$conceptoid.",".$periodoidliq.",0,".$montolicencia.",".$dias.",".$basico.")";
                                                                
                                $clase->EjecutarSQL($vsql);
                            }                            

                            // suspensión
                            if($suspension > 0)
                            {
                                $conceptoid = 9;
                                $dias = $suspension;

                                // Obtengo la formula de la licencia
                                $formulalice = $clase->SeleccionarUno("SELECT formula FROM conceptosnomina WHERE conceptoid = ".$conceptoid."");

                                eval("\$montolicencia = $formulalice;");
                                $montolicencia = round($montolicencia,0);

                                // Calculo el nuevo ID
                                $numid = $clase->SeleccionarUno("SELECT max(detalleid) FROM detalleliquidacion");
                                $numid++;

                                // Obtengo el tipo de licencia
                                $tipodc = $clase->BDLockup($conceptoid,'conceptosnomina','conceptoid','tipodc');

                                if($tipodc=="C")
                                    $vsql = "INSERT INTO detalleliquidacion (detalleid,terid,conceptoid,pernominaid,devengados,descuentos,valor,saldo) 
                                                                VALUES ($numid,".$terid.",".$conceptoid.",".$periodoidliq.",".$montolicencia.",0,".$dias.",".$basico.")";
                                else
                                    $vsql = "INSERT INTO detalleliquidacion (detalleid,terid,conceptoid,pernominaid,devengados,descuentos,valor,saldo) 
                                                                VALUES ($numid,".$terid.",".$conceptoid.",".$periodoidliq.",0,".$montolicencia.",".$dias.",".$basico.")";
                                                                
                                $clase->EjecutarSQL($vsql);
                            }                           

                            // incapacidad
                            if($incapacidad > 0)
                            {
                                $conceptoid = 10;
                                $dias = $incapacidad;

                                // Valido si el sueldo básico sea menor al salario mínimo legal vigente
                                if($basico<=$smlv)
                                {
                                    $montolicencia = ($smlv*$dias)/30;
                                    $montolicencia = round($montolicencia,0);
                                }
                                else
                                {
                                    $porcbasico = ($basico*66.67)/100;
                                    $porcbasico = round($porcbasico,0);

                                    // Calculo la incapacidad si el básico sea mayor al mínimo
                                    if($porcbasico>$smlv)
                                    {
                                        $montolicencia = ($porcbasico*$dias)/30;
                                        $montolicencia = round($montolicencia,0);
                                    }
                                    else
                                    {
                                        $montolicencia = ($smlv*$dias) / 30;
                                        $montolicencia = round($montolicencia,0);
                                    }
                                }

                                // Calculo el nuevo ID
                                $numid = $clase->SeleccionarUno("SELECT max(detalleid) FROM detalleliquidacion");
                                $numid++;

                                // Obtengo el tipo de licencia
                                $tipodc = $clase->BDLockup($conceptoid,'conceptosnomina','conceptoid','tipodc');

                                if($tipodc=="C")
                                    $vsql = "INSERT INTO detalleliquidacion (detalleid,terid,conceptoid,pernominaid,devengados,descuentos,valor,saldo) 
                                                                VALUES ($numid,".$terid.",".$conceptoid.",".$periodoidliq.",".$montolicencia.",0,".$dias.",".$basico.")";
                                else
                                    $vsql = "INSERT INTO detalleliquidacion (detalleid,terid,conceptoid,pernominaid,devengados,descuentos,valor,saldo) 
                                                                VALUES ($numid,".$terid.",".$conceptoid.",".$periodoidliq.",0,".$montolicencia.",".$dias.",".$basico.")";
                                                                
                                $clase->EjecutarSQL($vsql);
                            }                            

                            // maternidad
                            if($maternidad > 0)
                            {
                                $conceptoid = 11;
                                $dias = $maternidad;

                                // Obtengo la formula de la licencia
                                $formulalice = $clase->SeleccionarUno("SELECT formula FROM conceptosnomina WHERE conceptoid = ".$conceptoid."");

                                eval("\$montolicencia = $formulalice;");
                                $montolicencia = round($montolicencia,0);

                                // Calculo el nuevo ID
                                $numid = $clase->SeleccionarUno("SELECT max(detalleid) FROM detalleliquidacion");
                                $numid++;

                                // Obtengo el tipo de licencia
                                $tipodc = $clase->BDLockup($conceptoid,'conceptosnomina','conceptoid','tipodc');

                                if($tipodc=="C")
                                    $vsql = "INSERT INTO detalleliquidacion (detalleid,terid,conceptoid,pernominaid,devengados,descuentos,valor,saldo) 
                                                                VALUES ($numid,".$terid.",".$conceptoid.",".$periodoidliq.",".$montolicencia.",0,".$dias.",".$basico.")";
                                else
                                    $vsql = "INSERT INTO detalleliquidacion (detalleid,terid,conceptoid,pernominaid,devengados,descuentos,valor,saldo) 
                                                                VALUES ($numid,".$terid.",".$conceptoid.",".$periodoidliq.",0,".$montolicencia.",".$dias.",".$basico.")";
                                                                
                                $clase->EjecutarSQL($vsql);
                            }

                            if($paternidad > 0)
                            {
                                $conceptoid = 12;
                                $dias = $paternidad;

                                // Obtengo la formula de la licencia
                                $formulalice = $clase->SeleccionarUno("SELECT formula FROM conceptosnomina WHERE conceptoid = ".$conceptoid."");

                                eval("\$montolicencia = $formulalice;");
                                $montolicencia = round($montolicencia,0);

                                // Calculo el nuevo ID
                                $numid = $clase->SeleccionarUno("SELECT max(detalleid) FROM detalleliquidacion");
                                $numid++;

                                // Obtengo el tipo de licencia
                                $tipodc = $clase->BDLockup($conceptoid,'conceptosnomina','conceptoid','tipodc');

                                if($tipodc=="C")
                                    $vsql = "INSERT INTO detalleliquidacion (detalleid,terid,conceptoid,pernominaid,devengados,descuentos,valor,saldo) 
                                                                VALUES ($numid,".$terid.",".$conceptoid.",".$periodoidliq.",".$montolicencia.",0,".$dias.",".$basico.")";
                                else
                                    $vsql = "INSERT INTO detalleliquidacion (detalleid,terid,conceptoid,pernominaid,devengados,descuentos,valor,saldo) 
                                                                VALUES ($numid,".$terid.",".$conceptoid.",".$periodoidliq.",0,".$montolicencia.",".$dias.",".$basico.")";
                                                                
                                $clase->EjecutarSQL($vsql);
                            }

                            if($licenciaremunerada > 0)
                            {
                                $conceptoid = 13;
                                $dias = $licenciaremunerada;

                                // Obtengo la formula de la licencia
                                $formulalice = $clase->SeleccionarUno("SELECT formula FROM conceptosnomina WHERE conceptoid = ".$conceptoid."");

                                eval("\$montolicencia = $formulalice;");
                                $montolicencia = round($montolicencia,0);

                                // Calculo el nuevo ID
                                $numid = $clase->SeleccionarUno("SELECT max(detalleid) FROM detalleliquidacion");
                                $numid++;

                                // Obtengo el tipo de licencia
                                $tipodc = $clase->BDLockup($conceptoid,'conceptosnomina','conceptoid','tipodc');

                                if($tipodc=="C")
                                    $vsql = "INSERT INTO detalleliquidacion (detalleid,terid,conceptoid,pernominaid,devengados,descuentos,valor,saldo) 
                                                                VALUES ($numid,".$terid.",".$conceptoid.",".$periodoidliq.",".$montolicencia.",0,".$dias.",".$basico.")";
                                else
                                    $vsql = "INSERT INTO detalleliquidacion (detalleid,terid,conceptoid,pernominaid,devengados,descuentos,valor,saldo) 
                                                                VALUES ($numid,".$terid.",".$conceptoid.",".$periodoidliq.",0,".$montolicencia.",".$dias.",".$basico.")";
                                                                
                                $clase->EjecutarSQL($vsql);
                            }

                            if($birthday > 0)
                            {
                                $conceptoid = 23;
                                $dias = $birthday;

                                // Obtengo la formula de la licencia
                                $formulalice = $clase->SeleccionarUno("SELECT formula FROM conceptosnomina WHERE conceptoid = ".$conceptoid."");

                                eval("\$montolicencia = $formulalice;");
                                $montolicencia = round($montolicencia,0);

                                // Calculo el nuevo ID
                                $numid = $clase->SeleccionarUno("SELECT max(detalleid) FROM detalleliquidacion");
                                $numid++;

                                // Obtengo el tipo de licencia
                                $tipodc = $clase->BDLockup($conceptoid,'conceptosnomina','conceptoid','tipodc');

                                if($tipodc=="C")
                                    $vsql = "INSERT INTO detalleliquidacion (detalleid,terid,conceptoid,pernominaid,devengados,descuentos,valor,saldo) 
                                                                VALUES ($numid,".$terid.",".$conceptoid.",".$periodoidliq.",".$montolicencia.",0,".$dias.",".$basico.")";
                                else
                                    $vsql = "INSERT INTO detalleliquidacion (detalleid,terid,conceptoid,pernominaid,devengados,descuentos,valor,saldo) 
                                                                VALUES ($numid,".$terid.",".$conceptoid.",".$periodoidliq.",0,".$montolicencia.",".$dias.",".$basico.")";
                                                                
                                $clase->EjecutarSQL($vsql);
                            }

                            if($matrimonio > 0)
                            {
                                $conceptoid = 31;
                                $dias = $matrimonio;

                                // Obtengo la formula de la licencia
                                $formulalice = $clase->SeleccionarUno("SELECT formula FROM conceptosnomina WHERE conceptoid = ".$conceptoid."");

                                eval("\$montolicencia = $formulalice;");
                                $montolicencia = round($montolicencia,0);

                                // Calculo el nuevo ID
                                $numid = $clase->SeleccionarUno("SELECT max(detalleid) FROM detalleliquidacion");
                                $numid++;

                                // Obtengo el tipo de licencia
                                $tipodc = $clase->BDLockup($conceptoid,'conceptosnomina','conceptoid','tipodc');

                                if($tipodc=="C")
                                    $vsql = "INSERT INTO detalleliquidacion (detalleid,terid,conceptoid,pernominaid,devengados,descuentos,valor,saldo) 
                                                                VALUES ($numid,".$terid.",".$conceptoid.",".$periodoidliq.",".$montolicencia.",0,".$dias.",".$basico.")";
                                else
                                    $vsql = "INSERT INTO detalleliquidacion (detalleid,terid,conceptoid,pernominaid,devengados,descuentos,valor,saldo) 
                                                                VALUES ($numid,".$terid.",".$conceptoid.",".$periodoidliq.",0,".$montolicencia.",".$dias.",".$basico.")";
                                                                
                                $clase->EjecutarSQL($vsql);
                            }

                            if($incapacidadarl > 0)
                            {
                                $conceptoid = 40;
                                $dias = $incapacidadarl;

                                // Valido si el sueldo básico sea menor al salario mínimo legal vigente
                                if($basico<=$smlv)
                                {
                                    $montolicencia = ($smlv*$dias)/30;
                                    $montolicencia = round($montolicencia,0);
                                }
                                else
                                {
                                    $porcbasico = ($basico*66.67)/100;
                                    $porcbasico = round($porcbasico,0);

                                    // Calculo la incapacidad si el básico sea mayor al mínimo
                                    if($porcbasico>$smlv)
                                    {
                                        $montolicencia = ($porcbasico*$dias)/30;
                                        $montolicencia = round($montolicencia,0);
                                    }
                                    else
                                    {
                                        $montolicencia = ($basico*$dias) / 30;
                                        $montolicencia = round($montolicencia,0);
                                    }
                                }

                                // Calculo el nuevo ID
                                $numid = $clase->SeleccionarUno("SELECT max(detalleid) FROM detalleliquidacion");
                                $numid++;

                                // Obtengo el tipo de licencia
                                $tipodc = $clase->BDLockup($conceptoid,'conceptosnomina','conceptoid','tipodc');

                                if($tipodc=="C")
                                    $vsql = "INSERT INTO detalleliquidacion (detalleid,terid,conceptoid,pernominaid,devengados,descuentos,valor,saldo) 
                                                                VALUES ($numid,".$terid.",".$conceptoid.",".$periodoidliq.",".$montolicencia.",0,".$dias.",".$basico.")";
                                else
                                    $vsql = "INSERT INTO detalleliquidacion (detalleid,terid,conceptoid,pernominaid,devengados,descuentos,valor,saldo) 
                                                                VALUES ($numid,".$terid.",".$conceptoid.",".$periodoidliq.",0,".$montolicencia.",".$dias.",".$basico.")";
                                                                
                                $clase->EjecutarSQL($vsql);
                            }

                            if($incapacidad180 > 0)
                            {
                                $conceptoid = 43;
                                $dias = $incapacidad180;

                                // Obtengo la formula de la licencia
                                $formulalice = $clase->SeleccionarUno("SELECT formula FROM conceptosnomina WHERE conceptoid = ".$conceptoid."");

                                eval("\$montolicencia = $formulalice;");
                                $montolicencia = round($montolicencia,0);

                                // Calculo el nuevo ID
                                $numid = $clase->SeleccionarUno("SELECT max(detalleid) FROM detalleliquidacion");
                                $numid++;

                                // Obtengo el tipo de licencia
                                $tipodc = $clase->BDLockup($conceptoid,'conceptosnomina','conceptoid','tipodc');

                                if($tipodc=="C")
                                    $vsql = "INSERT INTO detalleliquidacion (detalleid,terid,conceptoid,pernominaid,devengados,descuentos,valor,saldo) 
                                                                VALUES ($numid,".$terid.",".$conceptoid.",".$periodoidliq.",".$montolicencia.",0,".$dias.",".$basico.")";
                                else
                                    $vsql = "INSERT INTO detalleliquidacion (detalleid,terid,conceptoid,pernominaid,devengados,descuentos,valor,saldo) 
                                                                VALUES ($numid,".$terid.",".$conceptoid.",".$periodoidliq.",0,".$montolicencia.",".$dias.",".$basico.")";
                                                                
                                $clase->EjecutarSQL($vsql);
                            }

                            if($familia > 0)
                            {
                                $conceptoid = 46;
                                $dias = $familia;

                                // Obtengo la formula de la licencia
                                $formulalice = $clase->SeleccionarUno("SELECT formula FROM conceptosnomina WHERE conceptoid = ".$conceptoid."");

                                eval("\$montolicencia = $formulalice;");
                                $montolicencia = round($montolicencia,0);

                                // Calculo el nuevo ID
                                $numid = $clase->SeleccionarUno("SELECT max(detalleid) FROM detalleliquidacion");
                                $numid++;

                                // Obtengo el tipo de licencia
                                $tipodc = $clase->BDLockup($conceptoid,'conceptosnomina','conceptoid','tipodc');

                                if($tipodc=="C")
                                    $vsql = "INSERT INTO detalleliquidacion (detalleid,terid,conceptoid,pernominaid,devengados,descuentos,valor,saldo) 
                                                                VALUES ($numid,".$terid.",".$conceptoid.",".$periodoidliq.",".$montolicencia.",0,".$dias.",".$basico.")";
                                else
                                    $vsql = "INSERT INTO detalleliquidacion (detalleid,terid,conceptoid,pernominaid,devengados,descuentos,valor,saldo) 
                                                                VALUES ($numid,".$terid.",".$conceptoid.",".$periodoidliq.",0,".$montolicencia.",".$dias.",".$basico.")";
                                                                
                                $clase->EjecutarSQL($vsql);
                            }
                        }

                        // Ingreso el recargo nocturno
                        $recargonoc = $_DATOS_EXCEL[$j]['recargonoc'];

                        if($recargonoc > 0)
                        {
                            $cantidad = $recargonoc;

                            // Obtengo la formula del recargo
                            $formularecargo = $clase->SeleccionarUno("SELECT formula FROM conceptosnomina WHERE conceptoid = 47");

                            // Calculo el recargo
                            eval("\$recargonocturno = $formularecargo;");
                            $recargonocturno = round($recargonocturno,0);

                            // incremento el id
                            $numreg = $clase->SeleccionarUno("SELECT max(detalleid) FROM detalleliquidacion");
                            
                            // almaceno el recargo
                            $clase->EjecutarSQL("INSERT INTO detalleliquidacion VALUES ($numreg+1,".$terid.",47,".$periodoidliq.",".$recargonocturno.",0,".$cantidad.",$basico)");
                        }

                        // Ingreso el recargo nocturno para Medellín
                        $recargonocmedellin = $_DATOS_EXCEL[$j]['recargonocmedellin'];

                        if($recargonocmedellin > 0)
                        {
                            $cantidad = $recargonocmedellin;

                            // Obtengo la formula del recargo
                            $formularecargomedellin = $clase->SeleccionarUno("SELECT formula FROM conceptosnomina WHERE conceptoid = 56");

                            // Calculo el recargo
                            eval("\$recargonocmedellin = $formularecargomedellin;");
                            $recargonocmedellin = round($recargonocmedellin,0);

                            // incremento el id
                            $numreg = $clase->SeleccionarUno("SELECT max(detalleid) FROM detalleliquidacion");
                            
                            // almaceno el recargo
                            $clase->EjecutarSQL("INSERT INTO detalleliquidacion VALUES ($numreg+1,".$terid.",56,".$periodoidliq.",".$recargonocmedellin.",0,".$cantidad.",$basico)");
                        }

                        // Ingreso la hora extra diurna
                        $horaextradiurna = $_DATOS_EXCEL[$j]['horaextradiurna'];

                        if($horaextradiurna > 0)
                        {
                            $cantidad = $horaextradiurna;

                            // Obtengo la formula del recargo
                            $formularecargo = $clase->SeleccionarUno("SELECT formula FROM conceptosnomina WHERE conceptoid = 49");

                            // Calculo el recargo
                            eval("\$recargohorased = $formularecargo;");
                            $recargohorased = round($recargohorased,0);

                            // incremento el id
                            $numreg = $clase->SeleccionarUno("SELECT max(detalleid) FROM detalleliquidacion");
                            
                            // almaceno el recargo
                            $clase->EjecutarSQL("INSERT INTO detalleliquidacion VALUES ($numreg+1,".$terid.",49,".$periodoidliq.",".$recargohorased.",0,".$cantidad.",$basico)");
                        }

                        // Ingreso la hora extra nocturna
                        $horaextranoc = $_DATOS_EXCEL[$j]['horaextranoc'];

                        if($horaextranoc > 0)
                        {
                            $cantidad = $horaextranoc;

                            // Obtengo la formula del recargo
                            $formularecargo = $clase->SeleccionarUno("SELECT formula FROM conceptosnomina WHERE conceptoid = 50");

                            // Calculo el recargo
                            eval("\$recarhohoraenoc = $formularecargo;");
                            $recarhohoraenoc = round($recarhohoraenoc,0);

                            // incremento el id
                            $numreg = $clase->SeleccionarUno("SELECT max(detalleid) FROM detalleliquidacion");
                            
                            // almaceno el recargo
                            $clase->EjecutarSQL("INSERT INTO detalleliquidacion VALUES ($numreg+1,".$terid.",50,".$periodoidliq.",".$recarhohoraenoc.",0,".$cantidad.",$basico)");
                        }

                        // Ingreso la hora extra diurna dominical
                        $horaextradiurnadom = $_DATOS_EXCEL[$j]['horaextradiurnadom'];

                        if($horaextradiurnadom > 0)
                        {
                            $cantidad = $horaextradiurnadom;

                            // Obtengo la formula del recargo
                            $formularecargo = $clase->SeleccionarUno("SELECT formula FROM conceptosnomina WHERE conceptoid = 51");

                            // Calculo el recargo
                            eval("\$recargohoraediurnad = $formularecargo;");
                            $recargohoraediurnad = round($recargohoraediurnad,0);

                            // incremento el id
                            $numreg = $clase->SeleccionarUno("SELECT max(detalleid) FROM detalleliquidacion");
                            
                            // almaceno el recargo
                            $clase->EjecutarSQL("INSERT INTO detalleliquidacion VALUES ($numreg+1,".$terid.",51,".$periodoidliq.",".$recargohoraediurnad.",0,".$cantidad.",$basico)");
                        }

                        // Ingreso la hora extra nocturna dominical y festivo
                        $horaextranocdomfes = $_DATOS_EXCEL[$j]['horaextranocdomfes'];

                        if($horaextranocdomfes > 0)
                        {
                            $cantidad = $horaextranocdomfes;

                            // Obtengo la formula del recargo
                            $formularecargo = $clase->SeleccionarUno("SELECT formula FROM conceptosnomina WHERE conceptoid = 52");

                            // Calculo el recargo
                            eval("\$recargohoraextranocdf = $formularecargo;");
                            $recargohoraextranocdf = round($recargohoraextranocdf,0);

                            // incremento el id
                            $numreg = $clase->SeleccionarUno("SELECT max(detalleid) FROM detalleliquidacion");
                            
                            // almaceno el recargo
                            $clase->EjecutarSQL("INSERT INTO detalleliquidacion VALUES ($numreg+1,".$terid.",52,".$periodoidliq.",".$recargohoraextranocdf.",0,".$cantidad.",$basico)");
                        }

                        // Ingreso de domingos y festivos
                        $domingosfestivos = $_DATOS_EXCEL[$j]['domingosfestivos'];

                        if($domingosfestivos > 0)
                        {
                            $cantidad = $domingosfestivos;

                            // Obtengo la formula del recargo
                            $formularecargo = $clase->SeleccionarUno("SELECT formula FROM conceptosnomina WHERE conceptoid = 53");

                            // Calculo el recargo
                            eval("\$recargodomingosfestivos = $formularecargo;");
                            $recargodomingosfestivos = round($recargodomingosfestivos,0);

                            // incremento el id
                            $numreg = $clase->SeleccionarUno("SELECT max(detalleid) FROM detalleliquidacion");
                            
                            // almaceno el recargo
                            $clase->EjecutarSQL("INSERT INTO detalleliquidacion VALUES ($numreg+1,".$terid.",53,".$periodoidliq.",".$recargodomingosfestivos.",0,".$cantidad.",$basico)");
                        }

                        // Ingreso de domingos y festivos
                        $recargonocdomfes = $_DATOS_EXCEL[$j]['recargonocdomfes'];

                        if($recargonocdomfes > 0)
                        {
                            $cantidad = $recargonocdomfes;

                            // Obtengo la formula del recargo
                            $formularecargo = $clase->SeleccionarUno("SELECT formula FROM conceptosnomina WHERE conceptoid = 54");

                            // Calculo el recargo
                            eval("\$recargonocdomfest = $formularecargo;");
                            $recargonocdomfest = round($recargonocdomfest,0);

                            // incremento el id
                            $numreg = $clase->SeleccionarUno("SELECT max(detalleid) FROM detalleliquidacion");
                            
                            // almaceno el recargo
                            $clase->EjecutarSQL("INSERT INTO detalleliquidacion VALUES ($numreg+1,".$terid.",54,".$periodoidliq.",".$recargonocdomfest.",0,".$cantidad.",$basico)");
                        }

                        // ------------------------------------------------------------------------------------------------------------------------------------------------------------------- //
                        // calculo pensión y salud
                        $vsqlsegsoc = "SELECT IFNULL(SUM(valor),0) valseguridadsocial 
                                         FROM detalleliquidacion
                                        WHERE terid = ".$terid." 
                                              AND pernominaid = ".$periodoidliq." 
                                              AND conceptoid IN (1,47,10,11,12,23,31,40,46,13)";
                        $valseguridadsocial = $clase->SeleccionarUno($vsqlsegsoc);                        

                        if($valseguridadsocial > 0)
                        {
                            // calculo pensión y salud    
                            $vsql = "SELECT IFNULL(SUM(d.devengados),0) totnovedades 
                                       FROM detalleliquidacion d
                                            INNER JOIN conceptosnomina c ON (d.conceptoid = c.conceptoid)
                                      WHERE d.terid = ".$terid."
                                            AND d.pernominaid = ".$periodoidliq." 
                                            AND (c.eslicencia = 'CHECKED' AND c.tipodc = 'C')";
                            $totnovedades = $clase->SeleccionarUno($vsql);
    
                            $vsql = "SELECT IFNULL(SUM(d.devengados),0) totrecargos 
                                       FROM detalleliquidacion d
                                            INNER JOIN conceptosnomina c ON (d.conceptoid = c.conceptoid)
                                      WHERE d.terid = ".$terid."
                                            AND d.pernominaid = ".$periodoidliq."                                             
                                            AND (c.recargo = 'CHECKED' AND c.tipodc = 'C')";
                            $totrecargos = $clase->SeleccionarUno($vsql);                            
                    
                            $sueldodeducciones = $sueldo + $totnovedades + $totrecargos; 
    
                            // Determino si el empleado es de condición extralegal                            
                            $idcondicion = $clase->SeleccionarUno("SELECT idcondicion FROM histcontrato WHERE terid = ".$terid." ORDER BY id DESC LIMIT 0,1");

                            if($idcondicion == 3)
                                $extralegal = "CHECKED";
                            else
                                $extralegal = "";

                            $epsid = $clase->BDLockup($terid,'terceros','terid','epsid');
                            $pensionesid = $clase->BDLockup($terid,'terceros','terid','pensionesid');
                            
                            if($epsid==NULL)                $epsid=0;
                            if($pensionesid==NULL)          $pensionesid=0;
                            
                            $cargoid = $clase->BDLockup($terid,'terceros','terid','cargoid');                           // Obtengo el cargo del empleado
                            $aplicapension = $clase->BDLockup($cargoid,'cargos','cargoid','aplicapension');             // Obtengo el control del cálculo de pensión
                            $aplicasalud = $clase->BDLockup($cargoid,'cargos','cargoid','aplicasalud');                 // Obtengo el control del cálculo de salud
    
                            if($extralegal=="CHECKED")
                            {
                                $pension = 0;
                                $salud = 0;
                            }
                            else
                            {
                                // Recalculo pensión y salud
                                if(($pensionesid==5) || ($aplicapension!="CHECKED"))
                                    $pension = 0;
                                else
                                {
                                    // Obtengo la formula para el descuento por pensión
                                    $vsql = "SELECT formula FROM conceptosnomina WHERE conceptoid = 4";
                                    $formulapension = $clase->SeleccionarUno($vsql);                                    
    
                                    // Calculo la pensión
                                    eval("\$pension = $formulapension;");
                                    $pension = round($pension,0);
                                }
    
                                if(($epsid==37) || ($aplicasalud!="CHECKED"))
                                    $salud = 0;
                                else
                                {
                                    // Obtengo la formula para el descuento de salud
                                    $vsql = "SELECT formula FROM conceptosnomina WHERE conceptoid = 5";
                                    $formulasalud = $clase->SeleccionarUno($vsql);
                                    
                                    // Calculo la salud
                                    eval("\$salud = $formulasalud;");
                                    $salud = round($salud,0);
                                }
                            }
                            
                            // pensión
                            $numreg = $clase->SeleccionarUno("SELECT max(detalleid) FROM detalleliquidacion");
                            $numreg++;
                            $clase->EjecutarSQL("INSERT INTO detalleliquidacion VALUES ($numreg,".$terid.",4,".$periodoidliq.",0,".$pension.",0,$sueldodeducciones)");
    
                            // salud
                            $numreg = $clase->SeleccionarUno("SELECT max(detalleid) FROM detalleliquidacion");
                            $numreg++;
                            $clase->EjecutarSQL("INSERT INTO detalleliquidacion VALUES ($numreg,".$terid.",5,".$periodoidliq.",0,".$salud.",0,$sueldodeducciones)");
                        }
                        else
                        {
                            $pension = 0;
                            $salud = 0;
                        }

                        // ------------------------------------------------------------------------------------------------------------------------------------------------------------------- //
                        // Ahora procedo a guardar los montos de otros descuentos tales como libranzas y descuentos ocasionales 

                        // facturas a crédito
                        $facturascredito = round($_DATOS_EXCEL[$j]['facturascredito'],0);
                        if($facturascredito > 0)
                        {
                            $conceptoid = 8;
                            $monto = $facturascredito;

                            // Obtengo el número de registros de la tabla detalleliquidacion
                            $numeroid = $clase->SeleccionarUno("SELECT MAX(detalleid) FROM detalleliquidacion");
                    
                            // Incremento el ID
                            $numeroid++;
    
                            // Determino el tipo de concepto
                            $tipodc = $clase->BDLockup($conceptoid,'conceptosnomina','conceptoid','tipodc');
    
                            // Construyo la instrucción
                            if($tipodc=="C")
                                $vsql = "INSERT INTO detalleliquidacion (detalleid,terid,conceptoid,pernominaid,devengados,descuentos,valor,saldo) 
                                              VALUES ($numeroid,".$terid.",".$conceptoid.",".$periodoidliq.",".$monto.",0,0,0)";
                            else
                                $vsql = "INSERT INTO detalleliquidacion (detalleid,terid,conceptoid,pernominaid,devengados,descuentos,valor,saldo) 
                                              VALUES ($numeroid,".$terid.",".$conceptoid.",".$periodoidliq.",0,".$monto.",0,0)";
    
                            // Almaceno en la tabla
                            $clase->EjecutarSQL($vsql);
                        }

                        // embargo
                        $embargo = round($_DATOS_EXCEL[$j]['embargo'],0);
                        if($embargo > 0)
                        {
                            $conceptoid = 30;
                            $monto = $embargo;

                            // Obtengo el número de registros de la tabla detalleliquidacion
                            $numeroid = $clase->SeleccionarUno("SELECT MAX(detalleid) FROM detalleliquidacion");
                    
                            // Incremento el ID
                            $numeroid++;
    
                            // Determino el tipo de concepto
                            $tipodc = $clase->BDLockup($conceptoid,'conceptosnomina','conceptoid','tipodc');
    
                            // Construyo la instrucción
                            if($tipodc=="C")
                                $vsql = "INSERT INTO detalleliquidacion (detalleid,terid,conceptoid,pernominaid,devengados,descuentos,valor,saldo) 
                                              VALUES ($numeroid,".$terid.",".$conceptoid.",".$periodoidliq.",".$monto.",0,0,0)";
                            else
                                $vsql = "INSERT INTO detalleliquidacion (detalleid,terid,conceptoid,pernominaid,devengados,descuentos,valor,saldo) 
                                              VALUES ($numeroid,".$terid.",".$conceptoid.",".$periodoidliq.",0,".$monto.",0,0)";
    
                            // Almaceno en la tabla
                            $clase->EjecutarSQL($vsql);
                        }

                        // cooptelecuc
                        $cooptelecuc = round($_DATOS_EXCEL[$j]['cooptelecuc'],0);
                        if($cooptelecuc > 0)
                        {
                            $conceptoid = 17;
                            $monto = $cooptelecuc;

                            // Obtengo el número de registros de la tabla detalleliquidacion
                            $numeroid = $clase->SeleccionarUno("SELECT MAX(detalleid) FROM detalleliquidacion");
                    
                            // Incremento el ID
                            $numeroid++;
    
                            // Determino el tipo de concepto
                            $tipodc = $clase->BDLockup($conceptoid,'conceptosnomina','conceptoid','tipodc');
    
                            // Construyo la instrucción
                            if($tipodc=="C")
                                $vsql = "INSERT INTO detalleliquidacion (detalleid,terid,conceptoid,pernominaid,devengados,descuentos,valor,saldo) 
                                              VALUES ($numeroid,".$terid.",".$conceptoid.",".$periodoidliq.",".$monto.",0,0,0)";
                            else
                                $vsql = "INSERT INTO detalleliquidacion (detalleid,terid,conceptoid,pernominaid,devengados,descuentos,valor,saldo) 
                                              VALUES ($numeroid,".$terid.",".$conceptoid.",".$periodoidliq.",0,".$monto.",0,0)";
    
                            // Almaceno en la tabla
                            $clase->EjecutarSQL($vsql);
                        }

                        // progressa
                        $progressa = round($_DATOS_EXCEL[$j]['progressa'],0);
                        if($progressa > 0)
                        {
                            $conceptoid = 16;
                            $monto = $progressa;

                            // Obtengo el número de registros de la tabla detalleliquidacion
                            $numeroid = $clase->SeleccionarUno("SELECT MAX(detalleid) FROM detalleliquidacion");
                    
                            // Incremento el ID
                            $numeroid++;
    
                            // Determino el tipo de concepto
                            $tipodc = $clase->BDLockup($conceptoid,'conceptosnomina','conceptoid','tipodc');
    
                            // Construyo la instrucción
                            if($tipodc=="C")
                                $vsql = "INSERT INTO detalleliquidacion (detalleid,terid,conceptoid,pernominaid,devengados,descuentos,valor,saldo) 
                                              VALUES ($numeroid,".$terid.",".$conceptoid.",".$periodoidliq.",".$monto.",0,0,0)";
                            else
                                $vsql = "INSERT INTO detalleliquidacion (detalleid,terid,conceptoid,pernominaid,devengados,descuentos,valor,saldo) 
                                              VALUES ($numeroid,".$terid.",".$conceptoid.",".$periodoidliq.",0,".$monto.",0,0)";
    
                            // Almaceno en la tabla
                            $clase->EjecutarSQL($vsql);
                        }

                        // óptica para todos
                        $opticaparatodos = round($_DATOS_EXCEL[$j]['opticaparatodos'],0);
                        if($opticaparatodos > 0)
                        {
                            $conceptoid = 14;
                            $monto = $opticaparatodos;

                            // Obtengo el número de registros de la tabla detalleliquidacion
                            $numeroid = $clase->SeleccionarUno("SELECT MAX(detalleid) FROM detalleliquidacion");
                    
                            // Incremento el ID
                            $numeroid++;
    
                            // Determino el tipo de concepto
                            $tipodc = $clase->BDLockup($conceptoid,'conceptosnomina','conceptoid','tipodc');
    
                            // Construyo la instrucción
                            if($tipodc=="C")
                                $vsql = "INSERT INTO detalleliquidacion (detalleid,terid,conceptoid,pernominaid,devengados,descuentos,valor,saldo) 
                                              VALUES ($numeroid,".$terid.",".$conceptoid.",".$periodoidliq.",".$monto.",0,0,0)";
                            else
                                $vsql = "INSERT INTO detalleliquidacion (detalleid,terid,conceptoid,pernominaid,devengados,descuentos,valor,saldo) 
                                              VALUES ($numeroid,".$terid.",".$conceptoid.",".$periodoidliq.",0,".$monto.",0,0)";
    
                            // Almaceno en la tabla
                            $clase->EjecutarSQL($vsql);
                        }

                        // seguro de vida suramericana
                        $suramericana = round($_DATOS_EXCEL[$j]['suramericana'],0);
                        if($suramericana > 0)
                        {
                            $conceptoid = 27;
                            $monto = $suramericana;

                            // Obtengo el número de registros de la tabla detalleliquidacion
                            $numeroid = $clase->SeleccionarUno("SELECT MAX(detalleid) FROM detalleliquidacion");
                    
                            // Incremento el ID
                            $numeroid++;
    
                            // Determino el tipo de concepto
                            $tipodc = $clase->BDLockup($conceptoid,'conceptosnomina','conceptoid','tipodc');
    
                            // Construyo la instrucción
                            if($tipodc=="C")
                                $vsql = "INSERT INTO detalleliquidacion (detalleid,terid,conceptoid,pernominaid,devengados,descuentos,valor,saldo) 
                                              VALUES ($numeroid,".$terid.",".$conceptoid.",".$periodoidliq.",".$monto.",0,0,0)";
                            else
                                $vsql = "INSERT INTO detalleliquidacion (detalleid,terid,conceptoid,pernominaid,devengados,descuentos,valor,saldo) 
                                              VALUES ($numeroid,".$terid.",".$conceptoid.",".$periodoidliq.",0,".$monto.",0,0)";
    
                            // Almaceno en la tabla
                            $clase->EjecutarSQL($vsql);
                        }

                        // prestamos personales
                        $prestamos = round($_DATOS_EXCEL[$j]['prestamos'],0);
                        if($prestamos > 0)
                        {
                            $conceptoid = 26;
                            $monto = $prestamos;

                            // Obtengo el número de registros de la tabla detalleliquidacion
                            $numeroid = $clase->SeleccionarUno("SELECT MAX(detalleid) FROM detalleliquidacion");
                    
                            // Incremento el ID
                            $numeroid++;
    
                            // Determino el tipo de concepto
                            $tipodc = $clase->BDLockup($conceptoid,'conceptosnomina','conceptoid','tipodc');
    
                            // Construyo la instrucción
                            if($tipodc=="C")
                                $vsql = "INSERT INTO detalleliquidacion (detalleid,terid,conceptoid,pernominaid,devengados,descuentos,valor,saldo) 
                                              VALUES ($numeroid,".$terid.",".$conceptoid.",".$periodoidliq.",".$monto.",0,0,0)";
                            else
                                $vsql = "INSERT INTO detalleliquidacion (detalleid,terid,conceptoid,pernominaid,devengados,descuentos,valor,saldo) 
                                              VALUES ($numeroid,".$terid.",".$conceptoid.",".$periodoidliq.",0,".$monto.",0,0)";
    
                            // Almaceno en la tabla
                            $clase->EjecutarSQL($vsql);
                        }

                        // los olivos
                        $losolivos = round($_DATOS_EXCEL[$j]['losolivos'],0);
                        if($losolivos > 0)
                        {
                            $conceptoid = 20;
                            $monto = $losolivos;

                            // Obtengo el número de registros de la tabla detalleliquidacion
                            $numeroid = $clase->SeleccionarUno("SELECT MAX(detalleid) FROM detalleliquidacion");
                    
                            // Incremento el ID
                            $numeroid++;
    
                            // Determino el tipo de concepto
                            $tipodc = $clase->BDLockup($conceptoid,'conceptosnomina','conceptoid','tipodc');
    
                            // Construyo la instrucción
                            if($tipodc=="C")
                                $vsql = "INSERT INTO detalleliquidacion (detalleid,terid,conceptoid,pernominaid,devengados,descuentos,valor,saldo) 
                                              VALUES ($numeroid,".$terid.",".$conceptoid.",".$periodoidliq.",".$monto.",0,0,0)";
                            else
                                $vsql = "INSERT INTO detalleliquidacion (detalleid,terid,conceptoid,pernominaid,devengados,descuentos,valor,saldo) 
                                              VALUES ($numeroid,".$terid.",".$conceptoid.",".$periodoidliq.",0,".$monto.",0,0)";
    
                            // Almaceno en la tabla
                            $clase->EjecutarSQL($vsql);
                        }

                        // la esperanza
                        $laesperanza = round($_DATOS_EXCEL[$j]['laesperanza'],0);
                        if($laesperanza > 0)
                        {
                            $conceptoid = 21;
                            $monto = $laesperanza;

                            // Obtengo el número de registros de la tabla detalleliquidacion
                            $numeroid = $clase->SeleccionarUno("SELECT MAX(detalleid) FROM detalleliquidacion");
                    
                            // Incremento el ID
                            $numeroid++;
    
                            // Determino el tipo de concepto
                            $tipodc = $clase->BDLockup($conceptoid,'conceptosnomina','conceptoid','tipodc');
    
                            // Construyo la instrucción
                            if($tipodc=="C")
                                $vsql = "INSERT INTO detalleliquidacion (detalleid,terid,conceptoid,pernominaid,devengados,descuentos,valor,saldo) 
                                              VALUES ($numeroid,".$terid.",".$conceptoid.",".$periodoidliq.",".$monto.",0,0,0)";
                            else
                                $vsql = "INSERT INTO detalleliquidacion (detalleid,terid,conceptoid,pernominaid,devengados,descuentos,valor,saldo) 
                                              VALUES ($numeroid,".$terid.",".$conceptoid.",".$periodoidliq.",0,".$monto.",0,0)";
    
                            // Almaceno en la tabla
                            $clase->EjecutarSQL($vsql);
                        }

                        // recordar
                        $recordar = round($_DATOS_EXCEL[$j]['recordar'],0);
                        if($recordar > 0)
                        {
                            $conceptoid = 19;
                            $monto = $recordar;

                            // Obtengo el número de registros de la tabla detalleliquidacion
                            $numeroid = $clase->SeleccionarUno("SELECT MAX(detalleid) FROM detalleliquidacion");
                    
                            // Incremento el ID
                            $numeroid++;
    
                            // Determino el tipo de concepto
                            $tipodc = $clase->BDLockup($conceptoid,'conceptosnomina','conceptoid','tipodc');
    
                            // Construyo la instrucción
                            if($tipodc=="C")
                                $vsql = "INSERT INTO detalleliquidacion (detalleid,terid,conceptoid,pernominaid,devengados,descuentos,valor,saldo) 
                                              VALUES ($numeroid,".$terid.",".$conceptoid.",".$periodoidliq.",".$monto.",0,0,0)";
                            else
                                $vsql = "INSERT INTO detalleliquidacion (detalleid,terid,conceptoid,pernominaid,devengados,descuentos,valor,saldo) 
                                              VALUES ($numeroid,".$terid.",".$conceptoid.",".$periodoidliq.",0,".$monto.",0,0)";
    
                            // Almaceno en la tabla
                            $clase->EjecutarSQL($vsql);
                        }

                        // seguros bolívar
                        $segurosbolivar = round($_DATOS_EXCEL[$j]['segurosbolivar'],0);
                        if($segurosbolivar > 0)
                        {
                            $conceptoid = 44;
                            $monto = $segurosbolivar;

                            // Obtengo el número de registros de la tabla detalleliquidacion
                            $numeroid = $clase->SeleccionarUno("SELECT MAX(detalleid) FROM detalleliquidacion");
                    
                            // Incremento el ID
                            $numeroid++;
    
                            // Determino el tipo de concepto
                            $tipodc = $clase->BDLockup($conceptoid,'conceptosnomina','conceptoid','tipodc');
    
                            // Construyo la instrucción
                            if($tipodc=="C")
                                $vsql = "INSERT INTO detalleliquidacion (detalleid,terid,conceptoid,pernominaid,devengados,descuentos,valor,saldo) 
                                              VALUES ($numeroid,".$terid.",".$conceptoid.",".$periodoidliq.",".$monto.",0,0,0)";
                            else
                                $vsql = "INSERT INTO detalleliquidacion (detalleid,terid,conceptoid,pernominaid,devengados,descuentos,valor,saldo) 
                                              VALUES ($numeroid,".$terid.",".$conceptoid.",".$periodoidliq.",0,".$monto.",0,0)";
    
                            // Almaceno en la tabla
                            $clase->EjecutarSQL($vsql);
                        }

                        // Bancolombia
                        $bancolombia = round($_DATOS_EXCEL[$j]['bancolombia'],0);
                        if($bancolombia > 0)
                        {
                            $conceptoid = 29;
                            $monto = $bancolombia;

                            // Obtengo el número de registros de la tabla detalleliquidacion
                            $numeroid = $clase->SeleccionarUno("SELECT MAX(detalleid) FROM detalleliquidacion");
                    
                            // Incremento el ID
                            $numeroid++;
    
                            // Determino el tipo de concepto
                            $tipodc = $clase->BDLockup($conceptoid,'conceptosnomina','conceptoid','tipodc');
    
                            // Construyo la instrucción
                            if($tipodc=="C")
                                $vsql = "INSERT INTO detalleliquidacion (detalleid,terid,conceptoid,pernominaid,devengados,descuentos,valor,saldo) 
                                              VALUES ($numeroid,".$terid.",".$conceptoid.",".$periodoidliq.",".$monto.",0,0,0)";
                            else
                                $vsql = "INSERT INTO detalleliquidacion (detalleid,terid,conceptoid,pernominaid,devengados,descuentos,valor,saldo) 
                                              VALUES ($numeroid,".$terid.",".$conceptoid.",".$periodoidliq.",0,".$monto.",0,0)";
    
                            // Almaceno en la tabla
                            $clase->EjecutarSQL($vsql);
                        }

                        // Davivienda
                        $davivienda = round($_DATOS_EXCEL[$j]['davivienda'],0);
                        if($davivienda > 0)
                        {
                            $conceptoid = 18;
                            $monto = $davivienda;

                            // Obtengo el número de registros de la tabla detalleliquidacion
                            $numeroid = $clase->SeleccionarUno("SELECT MAX(detalleid) FROM detalleliquidacion");
                    
                            // Incremento el ID
                            $numeroid++;
    
                            // Determino el tipo de concepto
                            $tipodc = $clase->BDLockup($conceptoid,'conceptosnomina','conceptoid','tipodc');
    
                            // Construyo la instrucción
                            if($tipodc=="C")
                                $vsql = "INSERT INTO detalleliquidacion (detalleid,terid,conceptoid,pernominaid,devengados,descuentos,valor,saldo) 
                                              VALUES ($numeroid,".$terid.",".$conceptoid.",".$periodoidliq.",".$monto.",0,0,0)";
                            else
                                $vsql = "INSERT INTO detalleliquidacion (detalleid,terid,conceptoid,pernominaid,devengados,descuentos,valor,saldo) 
                                              VALUES ($numeroid,".$terid.",".$conceptoid.",".$periodoidliq.",0,".$monto.",0,0)";
    
                            // Almaceno en la tabla
                            $clase->EjecutarSQL($vsql);
                        }

                        // anticipo de nómina
                        $anticipodenomina = round($_DATOS_EXCEL[$j]['anticipodenomina'],0);
                        if($anticipodenomina > 0)
                        {
                            $conceptoid = 33;
                            $monto = $anticipodenomina;

                            // Obtengo el número de registros de la tabla detalleliquidacion
                            $numeroid = $clase->SeleccionarUno("SELECT MAX(detalleid) FROM detalleliquidacion");
                    
                            // Incremento el ID
                            $numeroid++;
    
                            // Determino el tipo de concepto
                            $tipodc = $clase->BDLockup($conceptoid,'conceptosnomina','conceptoid','tipodc');
    
                            // Construyo la instrucción
                            if($tipodc=="C")
                                $vsql = "INSERT INTO detalleliquidacion (detalleid,terid,conceptoid,pernominaid,devengados,descuentos,valor,saldo) 
                                              VALUES ($numeroid,".$terid.",".$conceptoid.",".$periodoidliq.",".$monto.",0,0,0)";
                            else
                                $vsql = "INSERT INTO detalleliquidacion (detalleid,terid,conceptoid,pernominaid,devengados,descuentos,valor,saldo) 
                                              VALUES ($numeroid,".$terid.",".$conceptoid.",".$periodoidliq.",0,".$monto.",0,0)";
    
                            // Almaceno en la tabla
                            $clase->EjecutarSQL($vsql);
                        }

                        // Aquí depuro los conceptos que estén en cero
                        $clase->EjecutarSQL("DELETE FROM detalleliquidacion WHERE devengados = 0 AND descuentos = 0 AND pernominaid = ".$periodoidliq." AND terid = ".$terid."");
                        // --------------------------------------------------------------------------------------------- //
                        // Procedo a calcular las cesantías, primas y vacaciones

                        // Inicialización de variables
                        $diasps = 0;
                        $diasss = 0;

                        // año de la fecha de ingreso
                        $yearingreso = intval(substr($fecingreso,0,4));

                        $tienecambio = tienecambiosalario($terid,$fecretiro);                        

                        if($tienecambio)
                        {
                            // $promsueldoact = calcularsueldopromedio($terid,$listaperiodos,$fecretiro,$fecingreso);
                            $promsueldoact = newcalcularsueldoprom($terid,$codperiodo,$fecingreso,$fecretiro);
                            $basico = $promsueldoact;
                        }
                        else
                            $promsueldoact = 0;
                        
                        // año anterior
                        $yearprev = date("Y") - 1;

                        if($yearingreso>$yearprev)
                        {
                            $basicoant = 0;
                            $auxtransant = 0;
                            $diasyearant = 0;
                            $sueldointegralant = 0;
                        }
                        else
                        {
                            // máximo periodo del año anterior
                            $periodoidant = $clase->SeleccionarUno("SELECT MAX(periodoid) AS periodoidant FROM periodosnomina WHERE YEAR(fechasta) = ".$yearprev."");
                    
                            // básico de año anterior
                            $vsql = "SELECT saldo 
                                       FROM hisdetallenomina 
                                      WHERE terid = ".$terid." 
                                            AND pernominaid = ".$periodoidant." 
                                            AND conceptoid IN (1,10,11,12,13,31,38,43)";
                            $basicoant = $clase->SeleccionarUno($vsql);

                            $vsql25 = "SELECT MIN(periodoid) permin2
                                         FROM periodosnomina 
                                        WHERE fecdesde >= '".$fecingreso."' 
                                              AND YEAR(fecdesde) = ".$yearprev." 
                                              AND cerrado = 'CHECKED' ";
                            $permin2 = $clase->SeleccionarUno($vsql25);
                
                            if(strlen($permin2) == 0)
                            {
                                $vsql25 = "SELECT MIN(periodoid) permin2
                                             FROM periodosnomina 
                                            WHERE fecdesde >= '".$fecingreso."'
                                                  AND cerrado = 'CHECKED' ";
                                $permin2 = $clase->SeleccionarUno($vsql25);
                                $permin2--;
                            }
                            
                            $vsql26 = "SELECT MAX(periodoid) permax2
                                         FROM periodosnomina 
                                        WHERE fecdesde >= '".$fecingreso."' 
                                              AND YEAR(fecdesde) = ".$yearprev." 
                                              AND cerrado = 'CHECKED' ";
                            $permax2 = $clase->SeleccionarUno($vsql26);
                
                            if(strlen($permax2) == 0)
                                $permax2 = $permin2;

                            if(($basicoant==0)||($basicoant==NULL))
                            {
                                $basicoant = 0;
                                $auxtransant = 0;
                                $diasyearant = 0;
                                $sueldointegralant = 0;
                            }
                            else
                            {
                                // auxilio de transporte del año anterior
                                $auxtransant = $clase->SeleccionarUno("SELECT saldo FROM hisdetallenomina WHERE conceptoid = 3 AND pernominaid = ".$periodoidant." AND terid = ".$terid."");
                    
                                // Sueldo integral del año anterior
                                $sueldointegralant = $basicoant + $auxtransant;
                    
                                // días laborados el año anterior
                                $vsql = "SELECT periodoid
                                           FROM periodosnomina
                                          WHERE fecdesde <= '".$fecingreso."'
                                                AND fechasta >= '".$fecingreso."'";
                                $eneroant = $clase->SeleccionarUno($vsql);
                        
                                $vsql = "SELECT SUM(valor) AS diasyearant 
                                           FROM hisdetallenomina 
                                          WHERE terid = ".$terid." 
                                                AND conceptoid IN (1,10,11,12,13,23,31,38,40) 
                                                AND pernominaid BETWEEN ".$eneroant." AND ".$periodoidant." 
                                                AND pernominaid NOT IN (SELECT pernominaid 
                                                                          FROM periodoterceros 
                                                                         WHERE periodoterceros.terid = ".$terid." 
                                                                               AND periodoterceros.pernominaid BETWEEN ".$permin2." AND ".$permax2." 
                                                                               AND periodoterceros.extralegal = 'CHECKED')";
                                $diasyearant = $clase->SeleccionarUno($vsql);
                            }
                        }

                        // ----------------------------------------------------------------------------------------------- //
                        // Días laborados en el primer trimestre del año actual
                        $yeartoday = date("Y");

                        $comienzoprimersemestre = $yeartoday."-01-01";
                        $finprimersemestre = $yeartoday."-06-30";

                        // si el empleado ingresó en este periodo
                        if($fecingreso>=$comienzoprimersemestre)
                        {
                            $primeroenero = $clase->SeleccionarUno("SELECT MAX(periodoid) AS primeroenero FROM periodosnomina WHERE fecdesde <= '".$fecingreso."'");
                            $treintajunio = $clase->SeleccionarUno("SELECT periodoid AS treintajunio FROM periodosnomina WHERE fechasta = '".$finprimersemestre."'");
                    
                            // Días en el histórico
                            $vsql = "SELECT IFNULL(SUM(valor),0) AS diasps
                                       FROM hisdetallenomina 
                                      WHERE terid = ".$terid." 
                                            AND conceptoid IN (1,10,11,12,13,23,31,38,40) 
                                            AND pernominaid BETWEEN ".$primeroenero." AND ".$treintajunio." 
                                            AND pernominaid NOT IN (SELECT pernominaid 
                                                                      FROM periodoterceros
                                                                     WHERE periodoterceros.terid = ".$terid." 
                                                                           AND periodoterceros.pernominaid BETWEEN ".$primeroenero." AND ".$treintajunio."
                                                                           AND periodoterceros.extralegal = 'CHECKED')";
                            $diasps = $clase->SeleccionarUno($vsql);
                    
                            // Días en la liquidación
                            $vsql = "SELECT IFNULL(SUM(valor),0) AS diasliq
                                       FROM detalleliquidacion 
                                      WHERE terid = ".$terid." 
                                            AND conceptoid IN (1,10,11,12,13,23,31,38,40) 
                                            AND pernominaid BETWEEN ".$primeroenero." AND ".$treintajunio."";
                            $diasliq = $clase->SeleccionarUno($vsql);
                    
                            $diasps += $diasliq;
                        }

                        if(($fecingreso<$comienzoprimersemestre)&&($diasyearant>0))
                        {
                            $diasliq = 0;
                            $primeroenero = $clase->SeleccionarUno("SELECT periodoid AS primeroenero FROM periodosnomina WHERE fecdesde = '".$comienzoprimersemestre."'");                
                            $treintajunio = $clase->SeleccionarUno("SELECT periodoid AS treintajunio FROM periodosnomina WHERE fechasta = '".$finprimersemestre."'");
                    
                            // Días en el histórico
                            $vsql = "SELECT IFNULL(SUM(valor),0) AS diasps
                                       FROM hisdetallenomina 
                                      WHERE terid = ".$terid." 
                                            AND conceptoid IN (1,10,11,12,13,23,31,38,40) 
                                            AND pernominaid BETWEEN ".$primeroenero." AND ".$treintajunio."
                                            AND pernominaid NOT IN (SELECT pernominaid 
                                                                      FROM periodoterceros
                                                                     WHERE periodoterceros.terid = ".$terid." 
                                                                           AND periodoterceros.pernominaid BETWEEN ".$primeroenero." AND ".$treintajunio."
                                                                           AND periodoterceros.extralegal = 'CHECKED')";
                            $diasps = $clase->SeleccionarUno($vsql);
                    
                            // Días en la liquidación
                            $vsql = "SELECT IFNULL(SUM(valor),0) AS diasliq
                                       FROM detalleliquidacion 
                                      WHERE terid = ".$terid." 
                                            AND conceptoid IN (1,10,11,12,13,23,31,38,40)
                                            AND pernominaid BETWEEN ".$primeroenero." AND ".$treintajunio."";
                            $diasliq = $clase->SeleccionarUno($vsql);
                    
                            $diasps += $diasliq;
                        }

                        // ----------------------------------------------------------------------------------------------- //
                        // Días laborados en el segundo semestre del año
                        $inisegsemestre = $yeartoday."-07-01";
                        $finsegsemestre = $yeartoday."-12-31";

                        // si el empleado ingresó en este periodo
                        if($fecingreso>=$inisegsemestre)
                        {
                            $primerojulio = $clase->SeleccionarUno("SELECT MAX(periodoid) AS primerojulio FROM periodosnomina WHERE fecdesde <= '".$fecingreso."'");
                            $treintayuno = $clase->SeleccionarUno("SELECT periodoid AS treintayuno FROM periodosnomina WHERE fechasta = '".$finsegsemestre."'");
                    
                            $vsql = "SELECT IFNULL(SUM(valor),0) AS diasss
                                       FROM hisdetallenomina 
                                      WHERE terid = ".$terid." 
                                            AND conceptoid IN (1,10,11,12,13,23,31,38,40) 
                                            AND pernominaid BETWEEN ".$primerojulio." AND ".$treintayuno."
                                            AND pernominaid NOT IN (SELECT pernominaid 
                                                                      FROM periodoterceros
                                                                     WHERE periodoterceros.terid = ".$terid." 
                                                                           AND periodoterceros.pernominaid BETWEEN ".$primeroenero." AND ".$treintajunio."
                                                                           AND periodoterceros.extralegal = 'CHECKED')";
                            $diasss = $clase->SeleccionarUno($vsql);
                    
                            // Días en la liquidación
                            $vsql = "SELECT IFNULL(SUM(valor),0) AS diasliq
                                       FROM detalleliquidacion 
                                      WHERE terid = ".$terid." 
                                            AND conceptoid IN (1,10,11,12,13,23,31,38,40) 
                                            AND pernominaid BETWEEN ".$primerojulio." AND ".$treintayuno."";
                            $diasliq = $clase->SeleccionarUno($vsql);
                    
                            $diasss += $diasliq;
                        }

                        if(($fecingreso<$inisegsemestre)&&($diasps>0))
                        {
                            $primerojulio = $clase->SeleccionarUno("SELECT periodoid AS primerojulio FROM periodosnomina WHERE fecdesde = '".$inisegsemestre."'");
                            $treintayuno = $clase->SeleccionarUno("SELECT periodoid AS treintayuno FROM periodosnomina WHERE fechasta = '".$finsegsemestre."'");
                    
                            $vsql = "SELECT IFNULL(SUM(valor),0) AS diasss
                                       FROM hisdetallenomina 
                                      WHERE terid = ".$terid." 
                                            AND conceptoid IN (1,10,11,12,13,23,31,38,40) 
                                            AND pernominaid BETWEEN ".$primerojulio." AND ".$treintayuno."
                                            AND pernominaid NOT IN (SELECT pernominaid 
                                                                      FROM periodoterceros
                                                                     WHERE periodoterceros.terid = ".$terid." 
                                                                           AND periodoterceros.pernominaid BETWEEN ".$primeroenero." AND ".$treintajunio."
                                                                           AND periodoterceros.extralegal = 'CHECKED')";
                            $diasss = $clase->SeleccionarUno($vsql);

                            $vsql = "SELECT IFNULL(SUM(valor),0) AS diasliq
                                       FROM detalleliquidacion 
                                      WHERE terid = ".$terid." 
                                            AND conceptoid IN (1,10,11,12,13,23,31,38,40) 
                                            AND pernominaid IN ($listaperiodos)";
                            $diasliq = $clase->SeleccionarUno($vsql);
                    
                            $diasss += $diasliq;
                        }

                        // Inicialización de variables
                        $pagocenact = 0;                            $cantidad = 0;                          $porcentaje = 0;                        $pagointereses = 0;
                        $pagovaca = 0;                              $diasvaca = 0;                          $diasprima = 0;                         $pagoprimasps = 0;
                        $lbprocesado = false;                       $pagocesant = 0;                        $cantidadact = 0;                       $cantidadant = 0;
                        $pagocesantias = 0;                         $interesesact = 0;                      $interesesant = 0;                      $pagoprimasss = 0;
                        $pagoprimas = 0;                            $recarnonocturno = 0;                   $ultimobasico = 0;                      $ultimoperbasico = 0;
                        $diascesantias = 0;                         $diasvacaciones = 0;                    $fechainicesantias = "";                $diasdecesantias = 0;                   
                        $auxtrans = $_SESSION['N_AUXTRANS2020'];    $smlv = $_SESSION['N_SALMIN2020'];      $ultimobasico = 0;

                        // valido el subsidio de transporte
                        $valsubtrasp = $smlv * 2;

                        $cargoid = $clase->BDLockup($terid,'terceros','terid','cargoid');                       // Obtengo el cargo del empleado
                        $aplicatransporte = $clase->BDLockup($cargoid,'cargos','cargoid','aplicatransporte');   // Obtengo el control del cálculo de subsidio de transporte

                        if(($basico >= $valsubtrasp) || ($aplicatransporte==""))
                            $auxtrans = 0;

                        // cesantías
                        if(($cesantiasyearactual == "SI") || ($cesantiasyearanterior == "SI") || ($intcesantiasyearactual == "SI") || ($intcesantiasyearanterior == "SI"))
                        {
                            // Cálculo de cesantías del año actual
                            if($cesantiasyearactual == "SI")
                            {
                                if($fecingreso > $comienzoprimersemestre)
                                    $fechainicesantias = $fecingreso;
                                else
                                    $fechainicesantias = $comienzoprimersemestre;

                                $diascesantias = calculardias($terid,$fechainicesantias,$fecretiro,$listaperiodos);
                                $cantidadact = $diascesantias;

                                $pagocenact = ($basico + $auxtrans) * $cantidadact / 360;
                            }
                            else
                            {
                                $pagocenact = 0;
                                $cantidadact = 0;
                            }
                            
                            // Cálculo de cesantías del año anterior
                            if($cesantiasyearanterior == "SI")
                            {
                                $pagocesant = ($sueldointegralant + $auxtrans) * $diasyearant / 360;
                                $cantidadant = $diasyearant;
                            }
                            else
                            {
                                $pagocesant = 0;
                                $cantidadant = 0;
                            }
                            
                            // sub totales
                            $pagocesantias = $pagocenact + $pagocesant;
                            $pagocesantias = round($pagocesantias,2);
                            $cantidad = $cantidadact + $cantidadant;
                            $porcentaje = 12;

                            // Intereses año actual
                            if($intcesantiasyearactual == "SI")
                                $interesesact = (($pagocenact * $cantidadact) * 0.12 / 360);
                            else
                                $interesesact = 0;

                            // intereses del año anterior
                            if($intcesantiasyearanterior == "SI")
                                $interesesant = (($pagocesant * $diasyearant) * 0.12 / 360);
                            else
                                $interesesant = 0;

                            $pagointereses = $interesesact + $interesesant;
                            $pagointereses = round($pagointereses,2);

                            $diasdecesantias = $cantidad;

                            // Guardo en la tabla
                            $vsql = "INSERT INTO liquidacion (periodonomina, terid, tipo, pago, cantidad, porcentaje, pagointereses) 
                                          VALUES ('".$codperiodo."',".$terid.",'cesantias',".$pagocesantias.",".$cantidad.",".$porcentaje.",".$pagointereses.")";
                            $clase->EjecutarSQL($vsql);
                        }

                        // Cálculo de vacaciones
                        if($vacaciones == "")
                        {
                            // Determino si hay vacaciones canceladas previamente
                            $vsql22 = "SELECT MIN(periodoid) permin
                                         FROM periodosnomina 
                                        WHERE fecdesde >= '".$fecingreso."' 
                                              AND cerrado = 'CHECKED'";
                            $permin = $clase->SeleccionarUno($vsql22);

                            // Determino si hay vacaciones canceladas previamente
                            $vsql23 = "SELECT MAX(periodoid) permax
                                         FROM periodosnomina 
                                        WHERE fecdesde >= '".$fecingreso."' 
                                              AND cerrado = 'CHECKED'";
                            $permax = $clase->SeleccionarUno($vsql23);

                            $vsql24 = "SELECT pernominaid pervacaciones
                                         FROM hisdetallenomina 
                                        WHERE terid = ".$terid." 
                                              AND conceptoid = 38 
                                              AND pernominaid >= ".$permin." AND pernominaid <= ".$permax."";
                            $pervacaciones = $clase->SeleccionarUno($vsql24);

                            // ---------------------------------------------------------------------------------------- //
                            // nuevo método para calcular los días trabajados
                            if(strlen($pervacaciones) > 0)
                            {
                                $pervacaciones++;
                                $fecprevaca = $clase->SeleccionarUno("SELECT fecdesde FROM periodosnomina WHERE periodoid = ".$pervacaciones."");
                                $diasvacaciones = calculardias($terid,$fecprevaca,$fecretiro,$listaperiodos);
                            }
                            else
                                $diasvacaciones = calculardias($terid,$fecingreso,$fecretiro,$listaperiodos);

                            $diasvaca = $diasvacaciones;

                            // ------------------------------------------------------------------------------------------------------------------------------ //
                            $ultimobasico = $clase->SeleccionarUno("SELECT saldo FROM detalleliquidacion WHERE conceptoid = 1 AND pernominaid = ".$periodoidliq." AND terid = ".$terid."");
                            
                            if($ultimobasico == 0)
                            {
                                $ultimoperbasico = $clase->SeleccionarUno("SELECT MAX(pernominaid) FROM detallenomina WHERE conceptoid = 1 AND terid = ".$terid."");
                                $ultimobasico = $clase->SeleccionarUno("SELECT saldo FROM detallenomina WHERE conceptoid = 1 AND pernominaid = ".$ultimoperbasico." AND terid = ".$terid."");
                            }

                            // busco recargo nocturno
                            $recarnonocturno = buscarrecargonoc($terid,$periodoidliq);

                            $pagovaca = ($ultimobasico + $recarnonocturno) * $diasvaca / 720;
                            $pagovaca = round($pagovaca,2);

                            // Almaceno en la tabla
                            $vsql = "INSERT INTO liquidacion (periodonomina, terid, tipo, pago, cantidad, porcentaje, pagointereses) VALUES ('".$codperiodo."',".$terid.",'vacaciones',".$pagovaca.",".$diasvaca.",0,0)";
                            $clase->EjecutarSQL($vsql);
                        }
                        else
                        {
                            $diasvacaciones = calculardias($terid,$vacaciones,$fecretiro,$listaperiodos);
                            $diasvaca = $diasvacaciones;

                            // ubico el último salario básico
                            $id = $clase->SeleccionarUno("SELECT MAX(id) AS id FROM histcontrato WHERE terid = ".$terid."");
                            $ultsueldovac = $clase->BDLockup($id,'histcontrato','id','ultsueldo');

                            if(($ultsueldovac == 0) || ($ultsueldovac == "") || ($ultsueldovac == NULL))
                                $ultimobasico = $clase->BDLockup($terid,'terceros','terid','basico');
                            else
                                $ultimobasico = $ultsueldovac;

                            // busco recargo nocturno
                            $recarnonocturno = buscarrecargonoc($terid,$periodoidliq);

                            $pagovaca = ($ultimobasico + $recarnonocturno) * $diasvaca / 720;
                            $pagovaca = round($pagovaca,2);

                            // Almaceno en la tabla
                            $vsql = "INSERT INTO liquidacion (periodonomina,terid,tipo,pago,cantidad,porcentaje,pagointereses) VALUES ('".$codperiodo."',".$terid.",'vacaciones',".$pagovaca.",".$diasvaca.",0,0)";
                            $clase->EjecutarSQL($vsql);
                        }
                    
                        // Cálculo de primas
                        if(($primasprimersemestre == "SI") || ($primassegundosemestre == "SI"))
                        {
                            $diasdeprima = 0;
                            if($primasprimersemestre == "SI")
                            {
                                if($comienzoprimersemestre >= $fecingreso)
                                    $diasdeprima = calculardias($terid,$comienzoprimersemestre,$fecretiro,$listaperiodos);
                                else
                                    $diasdeprima = calculardias($terid,$fecingreso,$fecretiro,$listaperiodos);

                                $pagoprimasss = ($basico + $auxtrans) * $diasdeprima / 360;
                            }
                            // --------------------------------------------------------------- //

                            // --------------------------------------------------------------- //
                            // Primas segundo semestre
                            // if($primassegundosemestre == "SI")
                            // {
                            //     $diasprima += $diasss;
                            //     $pagoprimasss = ($basico + $auxtrans) * $diasss / 360;
                            // }
                            // --------------------------------------------------------------- //
                            if($primassegundosemestre == "SI")
                            {
                                if($inisegsemestre >= $fecingreso)
                                    $diasdeprima = calculardias($terid,$inisegsemestre,$fecretiro,$listaperiodos);
                                else
                                    $diasdeprima = calculardias($terid,$fecingreso,$fecretiro,$listaperiodos);

                                $pagoprimasss = ($basico + $auxtrans) * $diasdeprima / 360;
                            }
                            // --------------------------------------------------------------- //
                            $diasprima = $diasdeprima;
                            $pagoprimas = $pagoprimasps + $pagoprimasss;
                            $pagoprimas = round($pagoprimas,2);

                            // Almaceno en la tabla
                            $clase->EjecutarSQL("INSERT INTO liquidacion (periodonomina,terid,tipo,pago,cantidad,porcentaje,pagointereses) VALUES ('".$codperiodo."',".$terid.",'primas',".$pagoprimas.",".$diasprima.",0,0)");
                        }

                        // Almaceno la indemnización
                        $indemnizacion = $_DATOS_EXCEL[$j]['indemnizacion'];

                        if($indemnizacion > 0)                        
                            $clase->EjecutarSQL("INSERT INTO liquidacion (periodonomina,terid,tipo,pago,cantidad,porcentaje,pagointereses) VALUES ('".$codperiodo."',".$terid.",'indemnizacion',".$indemnizacion.",0,0,0)");                        
                        
                        if($indemnizacion == "")
                            $indemnizacion = 0;

                        // Aquí depuro los conceptos que estén en cero
                        $clase->EjecutarSQL("DELETE FROM liquidacion WHERE pago = 0 AND cantidad = 0 AND porcentaje = 0 AND pagointereses = 0 AND periodonomina = '".$codperiodo."' AND terid = ".$terid."");

                        // -------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- //
                        // preparo los datos para la tabla del informe

                        // básico
                        $basicoinf = $clase->BDLockup($terid,"terceros","terid","basico");

                        // documento
                        $dni = $clase->BDLockup($terid,'terceros','terid','dni');

                        // nombre del empleado
                        $nomreemp = "CONCAT(primernombre,' ',segundonombre,' ',primerapellido,' ',segundoapellido)";
                        $nombreempleado = $clase->BDLockup($terid,'terceros','terid',$nomreemp);

                        // otros devengados
                        $vsq22 = "SELECT SUM(IF(devengados>0,devengados,0)) otrosdevengados
                                    FROM detalleliquidacion 
                                   WHERE terid = ".$terid." 
                                         AND pernominaid IN ($listaperiodos)
                                         AND conceptoid NOT IN (1,3)";
                        $otrosdevengados = $clase->SeleccionarUno($vsq22);

                        if($otrosdevengados == "")
                            $otrosdevengados = 0;

                        // otros descuentos
                        $vsq23 = "SELECT SUM(IF(descuentos>0,descuentos,0)) otrosdescuentos
                                    FROM detalleliquidacion 
                                   WHERE terid = ".$terid." 
                                         AND pernominaid IN ($listaperiodos) 
                                         AND conceptoid NOT IN (4,5,6,9,43,58)";
                        $otrosdescuentos = $clase->SeleccionarUno($vsq23);

                        if($otrosdescuentos == "")
                            $otrosdescuentos = 0;

                        // total devengado
                        $totaldevengado = $sueldo + $subsidiotransporte + $pagovaca + $pagoprimas + $pagocesantias + $pagointereses + $indemnizacion + $otrosdevengados;

                        // total descuento
                        $totaldescuento = $pension + $salud + $otrosdescuentos;

                        // neto a pagar
                        $netoapagar = $totaldevengado - $totaldescuento;

                        if($calcularquin != "SI")
                        {
                            $diastrab = 0;                      $sueldo = 0;                        $subsidiotransporte = 0;                $promsueldoact = 0;
                        }

                        // guardo en la tabla del informe
                        $vsql = "INSERT INTO tmpinfliquidados (codperiodo,terid,dni,codvende,nombre,fecingreso,fecretiro,basico,sueldopromedio,diastrab,sueldo,subsidiotransporte,pension,salud,diasvaca,pagovaca,
                                                               diasprima,pagoprima,diasdecesantias,pagocedesantias,pagointereses,indemnizacion,otrosdevengados,otrosdescuentos,totaldevengado, totaldescuento,netoapagar) 
                                       VALUE ('".$codperiodo."',".$terid.",'".$dni."','".$codvende."','".$nombreempleado."','".$fecingreso."','".$fecretiro."',".$basicoinf.",".$promsueldoact.",".$diastrab.",".$sueldo.",
                                              ".$subsidiotransporte.",".$pension.",".$salud.",".$diasvaca.",".$pagovaca.",".$diasprima.",".$pagoprimas.",".$diasdecesantias.",".$pagocesantias.",
                                              ".$pagointereses.",".$indemnizacion.",".$otrosdevengados.",".$otrosdescuentos.",".$totaldevengado.",".$totaldescuento.",".$netoapagar.")";
                        $clase->EjecutarSQL($vsql);
                        // -------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- //
                    }
                }
            }

            // Elimino el Archivo
            unlink($destino);
    
            // Emito el mensaje correspondiente
            $clase->Aviso(1,"Se cargaron satisfactoriamente las liquidaciones del periodo $desperiodo");

            // Redirecciona el formulario
            header("Location: liquidados.php");
        }
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: editarliquidacion
    // Creación: 05/09/2024		última modificación: 01/11/2024
    // Creador: Luis Flórez		modificado por: Luis Flórez
    // Descripción: Opción para editar los datos de una liquidación
    // Última modificación: Impresión del salario promedio cuando corresponda y ventana para 
    //                      visualizar el detalle del promedio
    ////////////////////////////////////////////////////////////////////////////////////////    
    if($opcion == "editarliquidacion")
    {
        $terid = $_GET['terid'];
        $codperiodo = $_GET['codperiodo'];       

        // determino si la liquidación existe
        $vsql = "SELECT * FROM tmpinfliquidados WHERE codperiodo = '".$codperiodo."' AND terid = ".$terid;        

        $conex  = $clase->Conectar();
        $result = @mysql_query($vsql,$conex);
        if($row = mysql_fetch_array($result))
        {
            // obtengo los datos de la liquidación
            $idliquidados = $row['idliquidados'];
            
            $dni = $clase->BDLockup($idliquidados,'tmpinfliquidados','idliquidados','dni');
            $codvende = $clase->BDLockup($idliquidados,'tmpinfliquidados','idliquidados','codvende');
            $nombre = $clase->BDLockup($idliquidados,'tmpinfliquidados','idliquidados','nombre');
            $fecingreso = $clase->BDLockup($idliquidados,'tmpinfliquidados','idliquidados','fecingreso');
            $fecretiro = $clase->BDLockup($idliquidados,'tmpinfliquidados','idliquidados','fecretiro');
            $basico = $clase->BDLockup($idliquidados,'tmpinfliquidados','idliquidados','basico');
            $sueldopromedio = $clase->BDLockup($idliquidados,'tmpinfliquidados','idliquidados','sueldopromedio');
            $diastrab = $clase->BDLockup($idliquidados,'tmpinfliquidados','idliquidados','diastrab');
            $sueldo = $clase->BDLockup($idliquidados,'tmpinfliquidados','idliquidados','sueldo');
            $subsidiotransporte = $clase->BDLockup($idliquidados,'tmpinfliquidados','idliquidados','subsidiotransporte');
            $pension = $clase->BDLockup($idliquidados,'tmpinfliquidados','idliquidados','pension');
            $salud = $clase->BDLockup($idliquidados,'tmpinfliquidados','idliquidados','salud');
            $diasvaca = $clase->BDLockup($idliquidados,'tmpinfliquidados','idliquidados','diasvaca');
            $pagovaca = $clase->BDLockup($idliquidados,'tmpinfliquidados','idliquidados','pagovaca');
            $diasprima = $clase->BDLockup($idliquidados,'tmpinfliquidados','idliquidados','diasprima');
            $pagoprima = $clase->BDLockup($idliquidados,'tmpinfliquidados','idliquidados','pagoprima');
            $diasdecesantias = $clase->BDLockup($idliquidados,'tmpinfliquidados','idliquidados','diasdecesantias');
            $pagocedesantias = $clase->BDLockup($idliquidados,'tmpinfliquidados','idliquidados','pagocedesantias');
            $pagointereses = $clase->BDLockup($idliquidados,'tmpinfliquidados','idliquidados','pagointereses');
            $indemnizacion = $clase->BDLockup($idliquidados,'tmpinfliquidados','idliquidados','indemnizacion');

            // periodo en la cual se procesará la liquidación
            $vsqlper = "SELECT periodoid FROM periodosnomina WHERE fecdesde <= '".$fecretiro."' AND fechasta >= '".$fecretiro."'";
            $periodoidliq = $clase->SeleccionarUno($vsqlper);

            // determino si se puede editar
            $vsqldatos = "SELECT norecalcular FROM parametrosliquidacion WHERE terid = ".$terid." AND codperiodo = '".$codperiodo."'";
            $norecalcular = $clase->SeleccionarUno($vsqldatos);
    
            if($norecalcular == "CHECKED")
            {
                // icono superior
                $iconosuperior = '<img src="images/basicas/bloqueado.png" title="registro cerraro para recalculo" border="0" width="28" height="28">';

                // botones superiores
                $botonhistorico = '';
                $botonterceros = '';
                $botonprecalculo = '';
                $botonincluirconp = '';
                $botoneditlic = '';
                $botonelimconcepto = '';
                $botonactincarl = '';
                $botonelimliq = '';
                $botonfichater = '';
                $botonprecalconliq = '';
                $botonelivaca = '';
                $botoneliprima = '';
                $botonelicesantia = '';
                $botonrecargonocturno = '';
                $botoneliindem = '';

                // datos de la quicena
                $datdiastrab = ''.number_format($diastrab).'';
                $datsueldo = ''.number_format($sueldo).'';
                $datsubsidiotransporte = ''.number_format($subsidiotransporte).'';
                $datpension = ''.number_format($pension).'';
                $datsalud = ''.number_format($salud).'';
                $datdiasdecesantias = ''.number_format($diasdecesantias).'';
                $datpagocedesantias = ''.number_format($pagocedesantias).'';
                $datpagointereses = ''.number_format($pagointereses).'';
                $datdiasprima = ''.number_format($diasprima).'';
                $datpagoprima = ''.number_format($pagoprima).'';
                $datdiasvaca = ''.number_format($diasvaca).'';
                $datpagovaca = ''.number_format($pagovaca).'';
                $datindemnizacion = ''.number_format($indemnizacion).'';
            }
            else
            {
                $tiposalida = "vista";

                // icono superior
                $iconosuperior = '<img src="images/iconos/retirados.png" width="32" height="32" border="0">';

                // botones superiores
                $botonhistorico = '<a href="infhistcont.php?opcion=listadocontratos&terid='.$terid.'&tiposalida='.$tiposalida.'" title="hist&oacute;rico de contratos" target="_blank">
                                    <img src="images/iconos/agenda.png" width="34" height="34" border="0"> 
                                   </a>';

                $botonterceros = '<a href="terceros.php?opcion=detalles2&id='.$terid.'" title="editar ficha del empleado" target="_blank">
                                   <img src="images/iconos/clientes.png" width="34" height="34" border="0"> 
                                  </a>';

                $botonincluirconp = '<a href="?opcion=incluirconcepto&terid='.$terid.'&periodoid='.$periodoidliq.'&idliquidados='.$idliquidados.'&codperiodo='.$codperiodo.'" title="incluir un concepto en la quincena" rel="facebox"> 
                                      <img src="images/iconos/nuevodoc.png" width="34" height="34" border="0">
                                     </a>';

                $botoneditlic = '<a href="?opcion=editarlicencia&terid='.$terid.'&periodoid='.$periodoidliq.'&idliquidados='.$idliquidados.'&codperiodo='.$codperiodo.'" rel="facebox">
                                  <img src="images/iconos/gastos.png" title="incluir licencias" width="34" height="34" border="0">
                                 </a>';

                $botonrecargonocturno = '<a href="?opcion=incluirrecargonoc&codperiodo='.$codperiodo.'&terid='.$terid.'&idliquidados='.$idliquidados.'&periodoid='.$periodoidliq.'" rel="facebox">
                                 <img src="images/iconos/park.png" title="incluir recargo nocturno" border="0" width="32" height="32">
                                </a>';

                $botonelimconcepto = '<a href="?opcion=ventanaelimconp&terid='.$terid.'&periodoid='.$periodoidliq.'&idliquidados='.$idliquidados.'&codperiodo='.$codperiodo.'" rel="facebox">
                                       <img src="images/iconos/eliminardoc.png" title="eliminar concepto" width="34" height="34" border="0">
                                      </a>';

                $botonelimliq = '<a href="?opcion=confirmarelim&terid='.$terid.'&listaperiodos='.$listaperiodos.'&codperiodo='.$codperiodo.'" title="eliminar toda la liquidaci&oacute;n" rel="facebox"> 
                                  <img src="images/iconos/anulardoc.png" width="34" height="34" border="0">
                                 </a>';

                $botonfichater = '<a href="terceros.php?opcion=detalles2&id='.$terid.'" title="editar ficha del empleado" target="_blank">
                                   <img src="images/iconos/clientes.png" width="32" height="32" border="0"> 
                                  </a>';

                $botonprecalconliq = '<a href="?opcion=precalconliq&terid='.$terid.'&codperiodo='.$codperiodo.'&periodoid='.$periodoidliq.'" title="calcular vacaciones, primas y cesant&iacute;as" rel="facebox"> 
                                       <img src="images/iconos/calculando.png" width="32" height="32" border="0">
                                      </a>';

                $botonelivaca = '<a href="?opcion=confirmarelivaca&codperiodo='.$codperiodo.'&terid='.$terid.'&idliquidados='.$idliquidados.'" rel="facebox">
                                  <img src="images/basicas/iconoborrar.png" title="eliminar vacaciones" border="0">
                                 </a>';

                $botoneliprima = '<a href="?opcion=confirborrarprima&codperiodo='.$codperiodo.'&terid='.$terid.'&idliquidados='.$idliquidados.'" rel="facebox">
                                   <img src="images/basicas/iconoborrar.png" title="eliminar prima" border="0">
                                  </a>';

                $botonelicesantia = '<a href="?opcion=confirborrarcesantia&codperiodo='.$codperiodo.'&terid='.$terid.'&idliquidados='.$idliquidados.'" rel="facebox">
                                      <img src="images/basicas/iconoborrar.png" title="eliminar cesant&iacute;a" border="0">
                                     </a>';

                $botoneliindem = '<a href="?opcion=confirborrarindem&codperiodo='.$codperiodo.'&terid='.$terid.'&idliquidados='.$idliquidados.'" rel="facebox">
                                   <img src="images/basicas/iconoborrar.png" title="eliminar cesant&iacute;a" border="0">
                                  </a>';

                // datos de la quincena
                $datdiastrab = '<input type="number" name="diastrab" min="0" max="15" step="1" class="Texto11New" size="2" style="width:60px;height:25px" autocomplete="off" title="d&iacute;as trabajados" value="'.$diastrab.'">';
                $datsueldo = '<input type="number" name="sueldo" min="0" step="1" class="Texto11New" size="20" style="width:100px;height:25px" autocomplete="off" title="sueldo devengado" value="'.$sueldo.'">';
                $datsubsidiotransporte = '<input type="number" name="subsidiotransporte" min="0" step="1" class="Texto11New" size="20" style="width:100px;height:25px" autocomplete="off" title="subsidio de transporte" value="'.$subsidiotransporte.'">';
                $datpension = '<input type="number" name="pension" min="0" step="1" class="Texto11New" size="20" style="width:100px;height:25px" autocomplete="off" title="pensi&oacute;n" value="'.$pension.'">';
                $datsalud = '<input type="number" name="salud" min="0" step="1" class="Texto11New" size="20" style="width:100px;height:25px" autocomplete="off" title="salud" value="'.$salud.'">';
                $datdiasdecesantias = '<input type="number" name="diasdecesantias" min="0" step="1" class="Texto11New" size="20" style="width:100px;height:25px" autocomplete="off" title="d&iacute;as de cesant&iacuteas" value="'.$diasdecesantias.'">';
                $datpagocedesantias = '<input type="number" name="pagocedesantias" min="0" step="0.01" class="Texto11New" size="20" style="width:100px;height:25px" autocomplete="off" title="pago de cesant&iacute;as" value="'.$pagocedesantias.'">';
                $datpagointereses = '<input type="number" name="pagointereses" min="0" step="0.01" class="Texto11New" size="20" style="width:100px;height:25px" autocomplete="off" title="intereses de cesant&iacute;as" value="'.$pagointereses.'">';
                $datdiasprima = '<input type="number" name="diasprima" min="0" step="1" class="Texto11New" size="20" style="width:100px;height:25px" autocomplete="off" title="d&iacute;as de primas" value="'.$diasprima.'">';
                $datpagoprima = '<input type="number" name="pagoprima" min="0" step="0.01" class="Texto11New" size="20" style="width:100px;height:25px" autocomplete="off" title="pago de primas" value="'.$pagoprima.'">';
                $datdiasvaca = '<input type="number" name="diasvaca" min="0" step="1" class="Texto11New" size="20" style="width:100px;height:25px" autocomplete="off" title="d&iacute;as de vacaciones" value="'.$diasvaca.'">';
                $datpagovaca = '<input type="number" name="pagovaca" min="0" step="0.01" class="Texto11New" size="20" style="width:100px;height:25px" autocomplete="off" title="pago de vacaciones" value="'.$pagovaca.'">';
                $datindemnizacion = '<input indemnizacion" name="indemnizacion" min="0" step="0.01" class="Texto11New" size="20" style="width:100px;height:25px" autocomplete="off" title="indemnizaci&oacute;n" value="'.$indemnizacion.'">';
            }

            // descripción del periodo
            $desperiodo = $clase->BDLockup($codperiodo,'periodos','codperiodo','desperiodo');

            // formato de fechas
            $fechadeingreso  = substr($row['fecingreso'],8,2)."/".substr($row['fecingreso'],5,2)."/".substr($row['fecingreso'],0,4);
            $fecchaderetiro  = substr($row['fecretiro'],8,2)."/".substr($row['fecretiro'],5,2)."/".substr($row['fecretiro'],0,4);
            
            // Pintamos la ventana
            $cont = $clase->Header("S","W");
            
            // encabezado
            $cont.='<table width="100%">
                     <tr class="BarraDocumentos" style="height:45px;Important!">
                      <td width="10"> &nbsp; </td>
                      <td width="37"> '.$iconosuperior.' </td>
                      <td width="800"> <b> Liquidaci&oacute;n del periodo <br> <font color="blue"> '.$desperiodo.' </font> </b> </td>
                      <td width="24"> '.$botonhistorico.' </td>
                      <td width="10"> &nbsp; </td>
                      <td width="24"> '.$botonterceros.' </td>
                      <td width="10"> &nbsp; </td>
                      <td width="24"> '.$botonincluirconp.' </td>
                      <td width="10"> &nbsp; </td>
                      <td width="24"> '.$botoneditlic.' </td>
                      <td width="10"> &nbsp; </td>
                      <td width="24"> '.$botonrecargonocturno.' </td>
                      <td width="10"> &nbsp; </td>
                      <td width="24"> '.$botonelimconcepto.' </td>
                      <td width="10"> &nbsp; </td>
                      <td width="24"> '.$botonelimliq.' </td>
                      <td width="10"> &nbsp; </td>
                      <td width="24"> 
                       <a href="calculoliquidados.php?opcion=ventanaliquidados"> 
                       <input type="button" value="<<" class="button blue"> </a> 
                      </td>
                      <td width="10"> &nbsp; </td>
                     </tr> 
                    </table>';

            // datos personales
            $cont.='<table width="100%">
                     <tr class="CabezoteTabla"> 
                      <td width="47"> &nbsp; </td>
                      <td width="352"> <label class="Texto12"> Documento: </label> '.$dni.' </td>
                      <td width="255"> &nbsp; </td>
                      <td width="206"> &nbsp; </td>
                      <td width="206"> &nbsp; </td>
                     </tr>
                     <tr class="CabezoteTabla">
                      <td width="47"> &nbsp; </td>
                      <td width="352"> <label class="Texto12"> Empleado(a): <br> </label> '.$nombre.' </td>
                      <td width="255"> <label class="Texto12"> Salario b&aacute;sico: <br> '.number_format($basico).' </label> </td>
                      <td width="206"> <label class="Texto12"> Fecha de ingreso: <br> '.$fechadeingreso.' </label> </td>
                      <td width="206"> <label class="Texto12"> Fecha de retiro: <br> '.$fecchaderetiro.' </label> </td>
                     </tr>
                    </table>';

            // primas, vacaciones y cesantías
            if($norecalcular != "CHECKED")
                $cont.='<form action="?opcion=guardarliquidacion" name="y" method="POST">
                        <input type="hidden" name="idliquidados" value="'.$idliquidados.'">
                        <input type="hidden" name="terid" value="'.$terid.'">
                        <input type="hidden" name="codperiodo" value="'.$codperiodo.'">';

            $cont.='<table width="100%"> 
                     <tr class="CabezoteTabla">
                      <td width="47" align="center"> '.$botonelicesantia.' </td>
                      <td width="352"> <label class="Texto12"> Cesant&iacute;as: </label> </td>
                      <td width="255"> <label class="Texto12"> D&iacute;as: </label> '.$datdiasdecesantias.' </td>
                      <td width="206"> <label class="Texto12"> Pago: </label> '.$datpagocedesantias.' </td>
                      <td width="206"> <label class="Texto11"> Intereses: </label> '.$datpagointereses.' </td>
                     </tr>
                     <tr class="CabezoteTabla">
                      <td width="47" align="center"> '.$botoneliprima.' </td>
                      <td width="352"> <label class="Texto12"> Primas: </label> </td>
                      <td width="255"> <label class="Texto12"> D&iacute;as: </label> '.$datdiasprima.' </td>
                      <td width="206"> <label class="Texto12"> Pago: </label> '.$datpagoprima.' </td>
                      <td width="206"> &nbsp; </td>
                     </tr>
                     <tr class="CabezoteTabla">
                      <td width="47" align="center"> '.$botonelivaca.' </td>
                      <td width="352"> <label class="Texto12"> Vacaciones: </label> </td>
                      <td width="255"> <label class="Texto12"> D&iacute;as: </label> '.$datdiasvaca.' </td>
                      <td width="206"> <label class="Texto12"> Pago: </label> '.$datpagovaca.' </td>
                      <td width="206"> &nbsp; </td>
                     </tr>
                     <tr class="CabezoteTabla">
                      <td width="47" align="center"> '.$botoneliindem.' </td>
                      <td width="352"> <label class="Texto12"> Indemnizaci&oacute;n: </label> </td>
                      <td width="255"> <label class="Texto12"> Pago: </label> '.$datindemnizacion.' </td>
                      <td width="206"> &nbsp; </td>
                      <td width="206"> &nbsp; </td>
                     </tr>
                    </table>';

            if($norecalcular != "CHECKED")
                $cont.='<table width="100%">
                         <tr class="CabezoteTabla"> 
                          <center>
                          <td width="657" align="center">                    
                           <input type="submit" value="aceptar" class="button blue">
                           </form>
                          </td>
                          </center>
                         </tr>
                        </table>';

            // datos de la quincena 
            if($norecalcular != "CHECKED")
                $cont.='<form action="?opcion=guardarquincena" name="x" method="POST">
                        <input type="hidden" name="idliquidados" value="'.$idliquidados.'">
                        <input type="hidden" name="terid" value="'.$terid.'">
                        <input type="hidden" name="codperiodo" value="'.$codperiodo.'">';

            $cont.='<table width="100%">
                     <tr class="CabezoteTabla" style="height:60px;Important!">
                      <td width="47"> &nbsp; </td>
                      <td width="122" align="left"> <label class="Texto12"> D&iacute;as: </label> '.$datdiastrab.' </td>
                      <td width="200" align="left"> <label class="Texto12"> Sueldo: </label> '.$datsueldo.' </td>
                      <td width="220" align="left"> <label class="Texto12"> Transporte: </label> '.$datsubsidiotransporte.' </td>
                      <td width="190" align="left"> <label class="Texto12"> Salud: </label> '.$datsalud.' </td>
                      <td width="190" align="left"> <label class="Texto12"> Pensi&oacute;n: </label> '.$datpension.' </td>
                      <td width="100" align="center">';

            if($norecalcular != "CHECKED")
                $cont.='<input type="submit" value="aceptar" class="button blue"> 
                        </form>';
            else
                $cont.='&nbsp;';

            $cont.='  </td>
                      <td width="35"> &nbsp; </td>
                     </tr>
                    </table>';

            // impresión del sueldo promedio
            if($sueldopromedio > 0)
            {
                $cont.='<table width="100%">
                         <tr class="CabezoteTabla" style="height:30px;Important!">
                          <td width="60"> &nbsp; </td>
                          <td width="300" align="left"> <label class="Texto12"> Sueldo promedio: </label> '.number_format($sueldopromedio).' </td>
                          <td width="1248" align="left"> 
                           <a href="?opcion=mostrarpromedios&terid='.$terid.'&codperiodo='.$codperiodo.'&fecingreso='.$fecingreso.'&fecretiro='.$fecretiro.'" title="mostrar sueldos para el promedio" rel="facebox"> 
                            <img src="images/iconos/especialidades.png" width="32" height="32" border="0">
                           </a>
                          </td>
                         </tr>
                        </table>';
            }

            // otros devengados       
            $cont.='<form action="?opcion=actualizardetalleliq" name="x" method="POST">
                    <input type="hidden" name="idliquidados" value="'.$idliquidados.'">
                    <input type="hidden" name="terid" value="'.$terid.'">
                    <input type="hidden" name="codperiodo" value="'.$codperiodo.'">
                    <script type="text/javascript" src="lib/sorttable.js"></script>
                    <table width="100%" class="sortable">
                     <thead> 
                      <tr class="TituloTabla" style="display:block;padding-top:5px;height:20px;">
                       <td width="12"> &nbsp; </td>
                       <td width="290"> Concepto </td>
                       <td width="320" align="right"> Devengados </td>
                       <td width="23" align="right"> &nbsp; </td>
                       <td width="320" align="right"> Descuentos </td>
                       <td width="60"> &nbsp; </td>
                      </tr>
                     </thead>
                     <tbody style="display:block; width:1050px; height:150px; overflow-Y:scroll">';

            // lista de quincenas del periodo
            $listaperiodos = generarlistaper($codperiodo);
    
            // Consulta con los demás conceptos del empleado en el periodo
            $vsql = "SELECT c.nomconcepto, d.devengados, d.descuentos, c.tipodc, d.conceptoid, d.detalleid  
                       FROM detalleliquidacion d
                            INNER JOIN conceptosnomina c ON (d.conceptoid = c.conceptoid)
                      WHERE d.pernominaid IN ($listaperiodos)
                            AND d.terid = ".$terid."
                            AND d.conceptoid NOT IN (1,3,4,5)
                   ORDER BY c.tipodc, c.codconcepto";
    
            // Conexión a la base de datos
            $conex  = $clase->Conectar();
            $result = mysql_query($vsql,$conex);
            $cant   = mysql_num_rows($result);
    
            // Inicialización de variables
            $totdevengado = 0;
            $totdescuento = 0;
            $netoapagar = 0;
    
            // Validación de la ejecución del ciclo
            if($cant>0)
            {
                $i = 0;
                while($row = mysql_fetch_array($result))
                {
                    $i++;
                    if($i%2 == 0)
                        $cont.='<tr class="TablaDocsPar">';
                    else
                        $cont.='<tr class="TablaDocsImPar">';
        
                    $cont.=' <td width="12">&nbsp;  </td>
                            <td width="290"> '.$row['nomconcepto'].' </td>';                            
    
                    // Impresión del monto si es un devengado
                    if($row['tipodc']=="C")
                    {
                        if($norecalcular != "CHECKED")
                            $cont.=' <td width="320" align="right">
                                      <input type="number" name="pedir-'.$row['detalleid'].'" min="0" step="0.01" class="Texto11New" size="20" style="width:100px;height:25px" autocomplete="off" value="'.$row['devengados'].'">
                                     </td>
                                     <td width="23" align="right"> &nbsp; </td>
                                     <td width="320" align="right"> &nbsp; </td>
                                     <td width="60"> &nbsp; </td>
                                    </tr>';                            
                        else
                            $cont.=' <td width="320" align="right">'.number_format($row['devengados']).' </td>
                                     <td width="23" align="right"> &nbsp; </td>
                                     <td width="320" align="right"> &nbsp; </td>
                                     <td width="60"> &nbsp; </td>
                                    </tr>';
    
                        $totdevengado += $row['devengados'];
                    }
    
                    // Impresión del monto si es un descuento
                    if($row['tipodc']=="D")
                    {
                        if($norecalcular != "CHECKED")
                            $cont.=' <td width="320" align="right"> &nbsp; </td>
                                     <td width="23" align="right"> &nbsp; </td>
                                     <td width="320" align="right">
                                      <input type="number" name="pedir-'.$row['detalleid'].'" min="0" step="0.01" class="Texto11New" size="20" style="width:100px;height:25px" autocomplete="off" value="'.$row['descuentos'].'">
                                     </td> 
                                     <td width="60"> &nbsp; </td>
                                    </tr>';
                        else
                            $cont.=' <td width="320" align="right"> &nbsp; </td>
                                     <td width="23" align="right"> &nbsp; </td>
                                     <td width="320" align="right">'.number_format($row['descuentos']).' </td>
                                     <td width="60"> &nbsp; </td>
                                    </tr>';
                                                                                                        
                        if(($row['conceptoid']!=6)&&($row['conceptoid']!=9)&&($row['conceptoid']!=43)&&($row['conceptoid']!=58))
                            $totdescuento += $row['descuentos'];
                    }
                }
            }
    
            $cont.=' </tbody>
                    </table>';

            // Cálculo de los totales
            $totdevengado += $sueldo + $subsidiotransporte + $pagoprima + $pagovaca + $pagocedesantias + $pagointereses + $indemnizacion;
            $totdescuento += ($pension + $salud);
            $netoapagar = $totdevengado - $totdescuento;

            // Impresión de los totales
            $cont.='<table width="100%">
                     <tr class="TituloTabla"> 
                      <td width="261"> &nbsp; </td>
                      <td width="375" align="right"> <font color="WHITE"> <b> Total devengado: </b> '.number_format($totdevengado,2).' </font> </td>
                      <td width="375" align="right"> <font color="WHITE"> <b> Total descuentos: </b> '.number_format($totdescuento,2).' </font> </td>
                      <td width="375" align="right"> <font color="WHITE"> <b> Neto a pagar: </b> '.number_format($netoapagar,2).' </font> </td>
                      <td width="222"> &nbsp; </td>
                     </tr>
                    </table>';

            if(($norecalcular != "CHECKED") && ($cant>0))
                $cont.='<table width="100%">
                         <tr class="CabezoteTabla"> 
                          <center>
                          <td width="657" align="center">                    
                           <input type="submit" value="aceptar" class="button blue">
                           </form>
                          </td>
                          </center>
                         </tr>
                        </table>';                                        

            echo $cont.$clase->PiePagina();
        }
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: guardarliquidacion
    // Creación: 16/09/2024		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción para guardar los cambios de las primas, vacaciones y cesantías
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "guardarliquidacion")
    {
        $idliquidados = $_POST['idliquidados'];
        $terid = $_POST['terid'];
        $codperiodo = $_POST['codperiodo'];
        $diasdecesantias = $_POST['diasdecesantias'];
        $pagocedesantias = $_POST['pagocedesantias'];
        $pagointereses = $_POST['pagointereses'];
        $diasprima = $_POST['diasprima'];
        $pagoprima = $_POST['pagoprima'];
        $diasvaca = $_POST['diasvaca'];
        $pagovaca = $_POST['pagovaca'];
        $indemnizacion = $_POST['indemnizacion'];

        // actualizo las cesantías en la tabla liquidacion
        $numregistro = 0;
        $porcesantias = 12;
        $idliquidacion = 0;
        $vsql2 = "SELECT COUNT(*) AS numregistro FROM liquidacion WHERE terid = ".$terid." AND periodonomina = '".$codperiodo."' AND tipo = 'cesantias'";
        $numregistro = $clase->SeleccionarUno($vsql2);

        if($numregistro > 0)
        {
            $vsql3 = "SELECT idliquidacion FROM liquidacion WHERE terid = ".$terid." AND periodonomina = '".$codperiodo."' AND tipo = 'cesantias'";
            $idliquidacion = $clase->SeleccionarUno($vsql3);

            $vsql4 = "UPDATE liquidacion SET 
                             pago = ".$pagocedesantias.",
                             cantidad = ".$diasdecesantias.",
                             pagointereses = ".$pagointereses."
                       WHERE idliquidacion = ".$idliquidacion;
        }
        else
            $vsql4 = "INSERT INTO liquidacion (periodonomina, terid, tipo, pago, cantidad, porcentaje, pagointereses) 
                                    VALUES ('".$codperiodo."',".$terid.",'cesantias',".$pagocedesantias.",".$diasdecesantias.",".$porcesantias.",".$pagointereses.")";

        $clase->EjecutarSQL($vsql4);

        // actualizo las primas en la tabla liquidacion
        $numregistro = 0;
        $idliquidacion = 0;
        $vsql2 = "SELECT COUNT(*) AS numregistro FROM liquidacion WHERE terid = ".$terid." AND periodonomina = '".$codperiodo."' AND tipo = 'primas'";
        $numregistro = $clase->SeleccionarUno($vsql2);

        if($numregistro > 0)
        {
            $vsql3 = "SELECT idliquidacion FROM liquidacion WHERE terid = ".$terid." AND periodonomina = '".$codperiodo."' AND tipo = 'primas'";
            $idliquidacion = $clase->SeleccionarUno($vsql3);

            $vsql4 = "UPDATE liquidacion SET 
                             pago = ".$pagoprima.",
                             cantidad = ".$diasprima." 
                       WHERE idliquidacion = ".$idliquidacion;
        }
        else
            $vsql4 = "INSERT INTO liquidacion (periodonomina, terid, tipo, pago, cantidad, porcentaje, pagointereses) VALUES ('".$codperiodo."',".$terid.",'primas',".$pagoprima.",".$diasprima.",0,0)";

        $clase->EjecutarSQL($vsql4);

        //  actualizo las vacaciones en la tabla liquidacion
        $numregistro = 0;
        $idliquidacion = 0;
        $vsql2 = "SELECT COUNT(*) AS numregistro FROM liquidacion WHERE terid = ".$terid." AND periodonomina = '".$codperiodo."' AND tipo = 'vacaciones'";
        $numregistro = $clase->SeleccionarUno($vsql2);

        if($numregistro > 0)
        {
            $vsql3 = "SELECT idliquidacion FROM liquidacion WHERE terid = ".$terid." AND periodonomina = '".$codperiodo."' AND tipo = 'vacaciones'";
            $idliquidacion = $clase->SeleccionarUno($vsql3);

            $vsql4 = "UPDATE liquidacion SET 
                             pago = ".$pagovaca.",
                             cantidad = ".$diasvaca." 
                       WHERE idliquidacion = ".$idliquidacion;
        }
        else
            $vsql4 = "INSERT INTO liquidacion (periodonomina, terid, tipo, pago, cantidad, porcentaje, pagointereses) VALUES ('".$codperiodo."',".$terid.",'vacaciones',".$pagovaca.",".$diasvaca.",0,0)";

        $clase->EjecutarSQL($vsql4);

        // actualizo la indemnización en la tabla liquidacion
        $numregistro = 0;
        $idliquidacion = 0;
        $vsql2 = "SELECT COUNT(*) AS numregistro FROM liquidacion WHERE terid = ".$terid." AND periodonomina = '".$codperiodo."' AND tipo = 'indemnizacion'";
        $numregistro = $clase->SeleccionarUno($vsql2);

        if($numregistro > 0)
        {
            $vsql3 = "SELECT idliquidacion FROM liquidacion WHERE terid = ".$terid." AND periodonomina = '".$codperiodo."' AND tipo = 'indemnizacion'";
            $idliquidacion = $clase->SeleccionarUno($vsql3);

            $vsql4 = "UPDATE liquidacion SET pago = ".$indemnizacion." WHERE idliquidacion = ".$idliquidacion."";
        }
        else
            $vsql4 = "INSERT INTO liquidacion (periodonomina, terid, tipo, pago, cantidad, porcentaje, pagointereses) VALUES ('".$codperiodo."',".$terid.",'indemnizacion',".$indemnizacion.",0,0,0)";

        $clase->EjecutarSQL($vsql4);

        // depuro los registos en la tabla liquidacion
        $vsql = "DELETE FROM liquidacion WHERE pago = 0 AND cantidad = 0 AND pagointereses = 0 AND periodonomina = '".$codperiodo."' AND terid = ".$terid;
        $clase->EjecutarSQL($vsql);

        // realizo los cambios en la tabla tmpinfliquidados
        $vsql = "UPDATE tmpinfliquidados SET 
                        diasvaca = ".$diasvaca.",
                        pagovaca = ".$pagovaca.",
                        diasprima = ".$diasprima.",
                        pagoprima = ".$pagoprima.",
                        diasdecesantias = ".$diasdecesantias.",
                        pagocedesantias = ".$pagocedesantias.",
                        pagointereses = ".$pagointereses.",
                        indemnizacion = ".$indemnizacion." 
                  WHERE idliquidados = ".$idliquidados;
        $clase->EjecutarSQL($vsql);

        // actualizo los totales
        $sueldo = $clase->BDLockup($idliquidados,'tmpinfliquidados','idliquidados','sueldo');
        $subsidiotransporte = $clase->BDLockup($idliquidados,'tmpinfliquidados','idliquidados','subsidiotransporte');
        $pagovaca = $clase->BDLockup($idliquidados,'tmpinfliquidados','idliquidados','pagovaca');
        $pagoprima = $clase->BDLockup($idliquidados,'tmpinfliquidados','idliquidados','pagoprima');
        $pagocedesantias = $clase->BDLockup($idliquidados,'tmpinfliquidados','idliquidados','pagocedesantias');
        $pagointereses = $clase->BDLockup($idliquidados,'tmpinfliquidados','idliquidados','pagointereses');
        $indemnizacion = $clase->BDLockup($idliquidados,'tmpinfliquidados','idliquidados','indemnizacion');

        // lista de quincenas del periodo
        $listaperiodos = generarlistaper($codperiodo);
        
        // otros devengados
        $vsq22 = "SELECT SUM(IF(devengados>0,devengados,0)) otrosdevengados
                    FROM detalleliquidacion 
                   WHERE terid = ".$terid." 
                         AND pernominaid IN ($listaperiodos)
                         AND conceptoid NOT IN (1,3) LIMIT 0,1";
        $otrosdevengados = $clase->SeleccionarUno($vsq22);

        $totaldevengado = $sueldo + $subsidiotransporte + $pagovaca + $pagoprima + $pagocedesantias + $pagointereses + $indemnizacion + $otrosdevengados;

        $pension = $clase->BDLockup($idliquidados,'tmpinfliquidados','idliquidados','pension');
        $salud = $clase->BDLockup($idliquidados,'tmpinfliquidados','idliquidados','salud');

        // otros descuentos
        $vsq23 = "SELECT SUM(IF(descuentos>0,descuentos,0)) otrosdescuentos
                    FROM detalleliquidacion 
                   WHERE terid = ".$terid." 
                          AND pernominaid IN ($listaperiodos) 
                          AND conceptoid NOT IN (4,5,6,9,43,58) LIMIT 0,1";
        $otrosdescuentos = $clase->SeleccionarUno($vsq23);

        // total descuento
        $totaldescuento = $pension + $salud + $otrosdescuentos;

        // neto a pagar
        $netoapagar = $totaldevengado - $totaldescuento;

        // grabo los totales
        $vsql = "UPDATE tmpinfliquidados SET 
                        otrosdevengados = ".$otrosdevengados.", 
                        otrosdescuentos = ".$otrosdescuentos.",
                        totaldevengado = ".$totaldevengado.",
                        totaldescuento = ".$totaldescuento.",
                        netoapagar = ".$netoapagar."
                  WHERE idliquidados = ".$idliquidados;
        $clase->EjecutarSQL($vsql);

        // emito el mensaje correspondiente
        $clase->Aviso(1,"Cambios realizados satisfactoriamente");

        // redirecciono el formulario
        header("Location: liquidados.php?opcion=editarliquidacion&terid=$terid&codperiodo=$codperiodo");
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: confirmarelivaca
    // Creación: 16/09/2024		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción para confirmar la eliminación de las vacaciones del empleado
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////    
    if($opcion == "confirmarelivaca")
    {
        $codperiodo = $_GET['codperiodo'];
        $terid = $_GET['terid'];
        $idliquidados = $_GET['idliquidados'];

        // nombre del empleado
        $vsql3 = "SELECT CONCAT(primernombre,' ',segundonombre,' ',primerapellido,' ',segundoapellido) AS nombreemp FROM terceros WHERE terid = ".$terid;
        $nombreemp = $clase->SeleccionarUno($vsql3);

        // Días de vacaciones
        $vsqlcanvacaciones = "SELECT cantidad AS canvacaciones 
                                FROM liquidacion 
                               WHERE terid = ".$terid." 
                                     AND periodonomina = '".$codperiodo."' 
                                     AND tipo = 'vacaciones'";
        $canvacaciones = $clase->SeleccionarUno($vsqlcanvacaciones);

        if($canvacaciones == NULL)
            $canvacaciones = 0;

        // Pago de vacaciones
        $vsqlpagovaca = "SELECT pago AS pagovaca
                           FROM liquidacion
                          WHERE terid = ".$terid."
                                AND periodonomina = '".$codperiodo."' 
                                AND tipo = 'vacaciones'";
        $pagovaca = $clase->SeleccionarUno($vsqlpagovaca);

        if($pagovaca == NULL)
            $pagovaca = 0;

        // id de las vacaciones
        $vsqlidliquidacion = "SELECT idliquidacion
                                FROM liquidacion
                               WHERE terid = ".$terid."
                                     AND periodonomina = '".$codperiodo."' 
                                     AND tipo = 'vacaciones'";
        $idliquidacion = $clase->SeleccionarUno($vsqlidliquidacion);

        // pinto la ventana
        $cont ='<table width="500">
                 <tr class="CabezoteTabla"> 
                  <td align="center"> <br> <b>Eliminar vacaciones</b> <br><br> </td> 
                 </tr> 
                </table>
                <table width="500">
                 <tr class="TablaDocsImPar">       
                  <td width="400" align="center">
                   <label class="Texto12">
                   ¿Confirma que desea eliminar las vacaciones al empleado<br><b>'.$nombreemp.'</b> <br> de <b>'.$canvacaciones.'</b> d&iacute;as por un monto de <b>'.number_format($pagovaca).' </b> pesos?
                   </label>
                  </td>
                 </tr>
                 <tr class="TablaDocsImPar">       
                  <td width="400" align="center"> <br><br>
                   <form action="?opcion=eliminarvacacionesemp" method="POST">
                   <input type="hidden" name="idliquidacion" value="'.$idliquidacion.'">
                   <input type="hidden" name="codperiodo" value="'.$codperiodo.'">
                   <input type="hidden" name="terid" value="'.$terid.'">
                   <input type="hidden" name="idliquidados" value="'.$idliquidados.'">
                   <input type="submit" value="ACEPTAR" class="button blue">
                   <a href="liquidados.php?opcion=editarliquidacion&terid='.$terid.'&codperiodo='.$codperiodo.'"><input type="button" value="CANCELAR" class="button red"></a>
                   </form>
                   <br>
                  </td>
                 </tr>
                </table>';
        echo $cont;
        exit();
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: eliminarvacacionesemp
    // Creación: 16/09/2024		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que elimina las vacaciones de un empleado
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////        
    if($opcion == "eliminarvacacionesemp")
    {
        $idliquidacion = $_POST['idliquidacion'];
        $idliquidados = $_POST['idliquidados'];
        $terid = $_POST['terid'];
        $codperiodo = $_POST['codperiodo'];
        
        // elimina en la tabla liquidacion
        $vsql = "DELETE FROM liquidacion WHERE idliquidacion = ".$idliquidacion;
        $clase->EjecutarSQL($vsql);

        // elimina en la tabla tmpinfliquidados
        $diasvaca = 0;
        $pagovaca = 0;

        $vsql = "UPDATE tmpinfliquidados SET 
                        diasvaca = ".$diasvaca.",
                        pagovaca = ".$pagovaca." 
                  WHERE idliquidados = ".$idliquidados;
        $clase->EjecutarSQL($vsql);

        // emito el mensaje correspondiente
        $clase->Aviso(1,"Vacaciones eliminadas satisfactoriamente");

        // Redirecciono el formulario
        header("Location: liquidados.php?opcion=editarliquidacion&terid=$terid&codperiodo=$codperiodo");
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: confirborrarprima
    // Creación: 16/09/2024		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción para confirmar la eliminación de la prima del empleado
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "confirborrarprima")
    {
        $codperiodo = $_GET['codperiodo'];
        $terid = $_GET['terid'];
        $idliquidados = $_GET['idliquidados'];

        // nombre del empleado
        $vsql3 = "SELECT CONCAT(primernombre,' ',segundonombre,' ',primerapellido,' ',segundoapellido) AS nombreemp FROM terceros WHERE terid = ".$terid;
        $nombreemp = $clase->SeleccionarUno($vsql3);

        // Días de la prima
        $vsqlcanprimas = "SELECT cantidad AS canprimas
                            FROM liquidacion
                           WHERE terid = ".$terid."
                                 AND periodonomina = '".$codperiodo."' 
                                 AND tipo = 'primas'";
        $canprimas = $clase->SeleccionarUno($vsqlcanprimas);

        if($canprimas==NULL)
            $canprimas = 0;

        // Pago de la prima
        $vsqlpagoprimas = "SELECT pago AS pagoprimas
                             FROM liquidacion
                            WHERE terid = ".$terid."
                                  AND periodonomina = '".$codperiodo."' 
                                  AND tipo = 'primas'";
        $pagoprimas = $clase->SeleccionarUno($vsqlpagoprimas);

        if($pagoprimas==NULL)
            $pagoprimas = 0;

        // id de la prima
        $vsqlidliquidacion = "SELECT idliquidacion
                                FROM liquidacion
                               WHERE terid = ".$terid."
                                     AND periodonomina = '".$codperiodo."' 
                                     AND tipo = 'primas'";
        $idliquidacion = $clase->SeleccionarUno($vsqlidliquidacion);

        // determino si la liquidación está cerrada
        $vsqldatos = "SELECT norecalcular FROM parametrosliquidacion WHERE terid = ".$terid." AND codperiodo = '".$codperiodo."'";
        $norecalcular = $clase->SeleccionarUno($vsqldatos);

        if($norecalcular == "CHECKED")
            $cont ='<table width="500">
                     <tr class="CabezoteTabla"> 
                      <td align="center"> <br> <b> Eliminar vacaciones </b> <br><br> </td> 
                     </tr> 
                    </table>
                    <table width="500">
                     <tr class="TablaDocsImPar">
                      <td width="400" align="center"> <label class="Texto12"> Esta liquidaci&oacute;n est&aacute; cerrada </label> </td>
                     </tr>
                     <tr class="TablaDocsImPar">
                      <td width="400" align="center"> <br><br>
                       <input type="hidden" name="idliquidacion" value="'.$idliquidacion.'">
                       <input type="hidden" name="codperiodo" value="'.$codperiodo.'">
                       <input type="hidden" name="terid" value="'.$terid.'">
                       <input type="hidden" name="idliquidados" value="'.$idliquidados.'">
                       <a href="liquidados.php?opcion=editarliquidacion&terid='.$terid.'&codperiodo='.$codperiodo.'">
                        <input type="button" value="ACEPTAR" class="button blue">
                       </a>
                      </td>
                     </tr>
                    </table><br>';
        else
            $cont ='<table width="500">
                     <tr class="CabezoteTabla"> 
                      <td align="center"> <br> <b> Eliminar prima </b> <br> <br> </td> 
                     </tr> 
                    </table>
                    <table width="500">
                     <tr class="TablaDocsImPar">
                      <td width="400" align="center"> ¿Confirma que desea eliminar la prima al empleado<br><b> '.$nombreemp.'</b> <br> de <b>'.$canprimas.'</b> d&iacute;as por un monto de <b>'.number_format($pagoprimas).' </b> pesos? </td>
                     </tr>
                     <tr class="TablaDocsImPar">
                      <td width="400" align="center"> <br><br>
                       <form action="?opcion=borrarprima" method="POST">
                       <input type="hidden" name="idliquidacion" value="'.$idliquidacion.'">
                       <input type="hidden" name="codperiodo" value="'.$codperiodo.'">
                       <input type="hidden" name="terid" value="'.$terid.'">
                       <input type="hidden" name="idliquidados" value="'.$idliquidados.'">
                       <input type="submit" value="ACEPTAR" class="button red">
                       <a href="liquidados.php?opcion=editarliquidacion&terid='.$terid.'&codperiodo='.$codperiodo.'">
                        <input type="button" value="CANCELAR" class="button blue">
                       </a>
                       </form>
                       <br>
                      </td>
                     </tr>
                    </table><br>';
        echo $cont;
        exit();
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: borrarprima
    // Creación: 17/09/2024		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que elimina la prima de un empleado
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////    
    if($opcion == "borrarprima")
    {
        $idliquidacion = $_POST['idliquidacion'];
        $idliquidados = $_POST['idliquidados'];
        $terid = $_POST['terid'];
        $codperiodo = $_POST['codperiodo'];

        // determino si la liquidación está cerrada
        $vsqldatos = "SELECT norecalcular FROM parametrosliquidacion WHERE terid = ".$terid." AND codperiodo = '".$codperiodo."'";
        $norecalcular = $clase->SeleccionarUno($vsqldatos);

        if($norecalcular == "CHECKED")
            $clase->Aviso(3,"Esta liquidación está cerrada");
        else
        {
            // elimino el registro en al tabla liquidacion
            $vsql = "DELETE FROM liquidacion WHERE idliquidacion = ".$idliquidacion;
            $clase->EjecutarSQL($vsql);

            // realizo los cambios en la tabla tmpinfliquidados
            $diasprima = 0;
            $pagoprima = 0;

            $vsql = "UPDATE tmpinfliquidados SET 
                            diasprima = ".$diasprima.", 
                            pagoprima = ".$pagoprima." 
                      WHERE idliquidados = ".$idliquidados;
            $clase->EjecutarSQL($vsql);

            $clase->Aviso(1,"Prima eliminada satisfactoriamente");
        }

        // Redirecciono el formulario
        header("Location: liquidados.php?opcion=editarliquidacion&terid=$terid&codperiodo=$codperiodo");
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: confirborrarcesantia
    // Creación: 17/09/2024		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción para confirmar la eliminación de la cesantía
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////    
    if($opcion == "confirborrarcesantia")
    {
        $codperiodo = $_GET['codperiodo'];
        $terid = $_GET['terid'];
        $idliquidados = $_GET['idliquidados'];

        // nombre del empleado
        $vsql3 = "SELECT CONCAT(primernombre,' ',segundonombre,' ',primerapellido,' ',segundoapellido) AS nombreemp FROM terceros WHERE terid = ".$terid;
        $nombreemp = $clase->SeleccionarUno($vsql3);

        // Pago de la cesantía
        $vsqlpagocesantia = "SELECT pago AS pagocesantia
                               FROM liquidacion
                              WHERE terid = ".$terid."
                                    AND periodonomina = '".$codperiodo."' 
                                    AND tipo = 'cesantias'";
        $pagocesantia = $clase->SeleccionarUno($vsqlpagocesantia);

        if($pagocesantia==NULL)
            $pagocesantia = 0;

        // Porcentaje cesantía
        $vsqlporccesantia = "SELECT porcentaje AS porccesantia
                               FROM liquidacion
                              WHERE terid = ".$terid."
                                    AND periodonomina = '".$codperiodo."' 
                                    AND tipo = 'cesantias'";
        $porccesantia = $clase->SeleccionarUno($vsqlporccesantia);

        if($porccesantia==NULL)
            $porccesantia = 0;

        // Pago de intereses de cesantías
        $vsqlpagointereses = "SELECT pagointereses AS pagointereses
                                FROM liquidacion
                               WHERE terid = ".$terid."
                                     AND periodonomina = '".$codperiodo."' 
                                     AND tipo = 'cesantias'";
        $pagointereses = $clase->SeleccionarUno($vsqlpagointereses);

        if($pagointereses==NULL)
            $pagointereses = 0;

        // id de la cesantía
        $vsqlidliquidacion = "SELECT idliquidacion
                                FROM liquidacion
                               WHERE terid = ".$terid."
                                     AND periodonomina = '".$codperiodo."' 
                                     AND tipo = 'cesantias'";
        $idliquidacion = $clase->SeleccionarUno($vsqlidliquidacion);

        // determino si la liquidación está cerrada
        $vsqldatos = "SELECT norecalcular FROM parametrosliquidacion WHERE terid = ".$terid." AND codperiodo = '".$codperiodo."'";
        $norecalcular = $clase->SeleccionarUno($vsqldatos);

        if($norecalcular == "CHECKED")
            $cont ='<table width="500">
                     <tr class="CabezoteTabla"> 
                      <td align="center"> <br> <b> Eliminar vacaciones </b> <br><br> </td> 
                     </tr> 
                    </table>
                    <table width="500">
                     <tr class="TablaDocsImPar">       
                      <td width="400" align="center"> <label class="Texto12"> Esta liquidaci&oacute;n est&aacute; cerrada </label> </td>
                     </tr>
                     <tr class="TablaDocsImPar">
                      <td width="400" align="center"> <br><br>
                       <input type="hidden" name="idliquidacion" value="'.$idliquidacion.'">
                       <input type="hidden" name="codperiodo" value="'.$codperiodo.'">
                       <input type="hidden" name="terid" value="'.$terid.'">
                       <input type="hidden" name="idliquidados" value="'.$idliquidados.'">
                       <a href="liquidados.php?opcion=editarliquidacion&terid='.$terid.'&codperiodo='.$codperiodo.'">
                        <input type="button" value="ACEPTAR" class="button blue">
                       </a>
                      </td>
                     </tr>
                    </table><br>';
        else
            $cont ='<table width="500">
                     <tr class="CabezoteTabla"> 
                      <td align="center"> <br> <b> Eliminar cesant&iacute;a </b> <br><br> </td> 
                     </tr> 
                    </table>
                    <table width="500">
                     <tr class="TablaDocsImPar">
                      <td width="400" align="center">
                       <label class="Texto12">
                       ¿Confirma que desea eliminar la cesant&iacute;a al empleado<br><b> '.$nombreemp.'</b> <br> por un monto de <b>'.number_format($pagocesantia).' </b> pesos <br> con un porcentaje <b>'.number_format($porccesantia).' </b> % y pago de intereses <b>'.number_format($pagointereses).'</b>?
                       </label> 
                      </td>
                     </tr>
                     <tr class="TablaDocsImPar">
                      <td width="400" align="center"> <br><br>
                       <form action="?opcion=borrarcesantia" method="POST">
                       <input type="hidden" name="idliquidacion" value="'.$idliquidacion.'">
                       <input type="hidden" name="codperiodo" value="'.$codperiodo.'">
                       <input type="hidden" name="terid" value="'.$terid.'">
                       <input type="hidden" name="idliquidados" value="'.$idliquidados.'">
                       <input type="submit" value="ACEPTAR" class="button red">
                       <a href="liquidados.php?opcion=editarliquidacion&terid='.$terid.'&codperiodo='.$codperiodo.'">
                        <input type="button" value="CANCELAR" class="button blue">
                       </a>
                       </form>
                       <br>
                      </td>
                     </tr>
                    </table>';
        echo $cont;
        exit();
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: borrarcesantia
    // Creación: 17/09/2024		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que elimina la cesantía de un empleado
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "borrarcesantia")
    {
        $idliquidacion = $_POST['idliquidacion'];
        $idliquidados = $_POST['idliquidados'];
        $terid = $_POST['terid'];
        $codperiodo = $_POST['codperiodo'];

        // determino si la liquidación está cerrada
        $vsqldatos = "SELECT norecalcular FROM parametrosliquidacion WHERE terid = ".$terid." AND codperiodo = '".$codperiodo."'";
        $norecalcular = $clase->SeleccionarUno($vsqldatos);

        if($norecalcular == "CHECKED")
            $clase->Aviso(3,"Esta liquidación está cerrada");
        else
        {
            $vsql = "DELETE FROM liquidacion WHERE idliquidacion = ".$idliquidacion;
            $clase->EjecutarSQL($vsql);

            // realizo los cambios en la tabla tmpinfliquidados
            $diasdecesantias = 0;
            $pagocedesantias = 0;
            $pagointereses = 0;

            $vsql = "UPDATE tmpinfliquidados SET 
                            diasdecesantias = ".$diasdecesantias.",
                            pagocedesantias = ".$pagocedesantias.",
                            pagointereses = ".$pagointereses." 
                      WHERE idliquidados = ".$idliquidados;

            $clase->EjecutarSQL($vsql);
    
            // emito el mensaje correspondiente
            $clase->Aviso(1,"Cesantía eliminada satisfactoriamente");
        }

        // Redirecciono el formulario
        header("Location: liquidados.php?opcion=editarliquidacion&terid=$terid&codperiodo=$codperiodo");
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: confirborrarindem
    // Creación: 17/09/2024		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción para confirmar la eliminación de una indemnización
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////    
    if($opcion == "confirborrarindem")
    {
        $codperiodo = $_GET['codperiodo'];
        $terid = $_GET['terid'];
        $idliquidados = $_GET['idliquidados'];

        // nombre del empleado
        $vsql3 = "SELECT CONCAT(primernombre,' ',segundonombre,' ',primerapellido,' ',segundoapellido) AS nombreemp FROM terceros WHERE terid = ".$terid;
        $nombreemp = $clase->SeleccionarUno($vsql3);

        $vsqlindemnizacion = "SELECT pago AS indemnizacion
                                FROM liquidacion
                               WHERE terid = ".$terid."
                                     AND periodonomina = '".$codperiodo."' 
                                     AND tipo = 'indemnizacion'";
        $indemnizacion = $clase->SeleccionarUno($vsqlindemnizacion);

        if($indemnizacion==NULL)
            $indemnizacion=0;

        // id de la cesantía
        $vsqlidliquidacion = "SELECT idliquidacion
                                FROM liquidacion
                               WHERE terid = ".$terid."
                                     AND periodonomina = '".$codperiodo."' 
                                     AND tipo = 'indemnizacion'";
        $idliquidacion = $clase->SeleccionarUno($vsqlidliquidacion);

        // determino si la liquidación está cerrada
        $vsqldatos = "SELECT norecalcular FROM parametrosliquidacion WHERE terid = ".$terid." AND codperiodo = '".$codperiodo."'";
        $norecalcular = $clase->SeleccionarUno($vsqldatos);

        if($norecalcular == "CHECKED")
            $cont ='<table width="500">
                     <tr class="CabezoteTabla"> 
                      <td align="center"> <br> <b> Eliminar vacaciones </b> <br><br> </td> 
                     </tr> 
                    </table>
                    <table width="500">
                     <tr class="TablaDocsImPar">
                      <td width="400" align="center"> <label class="Texto12"> Esta liquidaci&oacute;n est&aacute; cerrada </label> </td>
                     </tr>
                     <tr class="TablaDocsImPar">
                      <td width="400" align="center"> <br><br>
                       <input type="hidden" name="idliquidacion" value="'.$idliquidacion.'">
                       <input type="hidden" name="idliquidados" value="'.$idliquidados.'">
                       <input type="hidden" name="codperiodo" value="'.$codperiodo.'"> 
                       <input type="hidden" name="terid" value="'.$terid.'">
                       <a href="liquidados.php?opcion=editarliquidacion&terid='.$terid.'&codperiodo='.$codperiodo.'">
                        <input type="button" value="ACEPTAR" class="button blue">
                       </a>
                      </td>
                     </tr>
                    </table><br>';
        else
            $cont ='<table width="500">
                     <tr class="CabezoteTabla"> 
                      <td align="center"> <br> <b> Eliminar indemnizaci&oacute;n </b> <br><br> </td> 
                     </tr> 
                    </table>
                    <table width="500">
                     <tr class="TablaDocsImPar">
                      <td width="400" align="center">
                       ¿Confirma que desea eliminar la indemnizaci&oacute;n al empleado<br><b> '.$nombreemp.'</b> <br> por un monto de <b> '.number_format($indemnizacion).' </b>pesos?
                      </td>
                     </tr>
                     <tr class="TablaDocsImPar">
                      <td width="400" align="center"> <br><br>
                       <form action="?opcion=borrarindemnizacion" method="POST">
                       <input type="hidden" name="idliquidacion" value="'.$idliquidacion.'">
                       <input type="hidden" name="idliquidados" value="'.$idliquidados.'">
                       <input type="hidden" name="codperiodo" value="'.$codperiodo.'"> 
                       <input type="hidden" name="terid" value="'.$terid.'">
                       <input type="submit" value="ACEPTAR" class="button red">
                       <a href="liquidados.php?opcion=editarliquidacion&terid='.$terid.'&codperiodo='.$codperiodo.'">
                        <input type="button" value="CANCELAR" class="button blue">
                       </a>
                       </form>
                       <br>
                      </td>
                     </tr>
                    </table>';
        echo $cont;
        exit();
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: borrarindemnizacion
    // Creación: 17/09/2024		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que elimina la indemnización de un empleado
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "borrarindemnizacion")
    {
        $idliquidacion = $_POST['idliquidacion'];
        $idliquidados = $_POST['idliquidados'];
        $terid = $_POST['terid'];
        $codperiodo = $_POST['codperiodo'];

        // determino si la liquidación está cerrada
        $vsqldatos = "SELECT norecalcular FROM parametrosliquidacion WHERE terid = ".$terid." AND codperiodo = '".$codperiodo."'";
        $norecalcular = $clase->SeleccionarUno($vsqldatos);

        if($norecalcular == "CHECKED")
            $clase->Aviso(3,"Esta liquidación está cerrada");
        else
        {
            // elimino el registro de la tabla liquidacion
            $vsql = "DELETE FROM liquidacion WHERE idliquidacion = ".$idliquidacion;
            $clase->EjecutarSQL($vsql);

            // realizo los cambios en la tabla tmpinfliquidados
            $indemnizacion = 0;
            $vsql = "UPDATE tmpinfliquidados SET indemnizacion = ".$indemnizacion." WHERE idliquidados = ".$idliquidados;
            $clase->EjecutarSQL($vsql);
            
            // emito el mensaje correspondiente
            $clase->Aviso(1,"Indemnización eliminada satisfactoriamente");
        }

        // Redirecciono el formulario
        header("Location: liquidados.php?opcion=editarliquidacion&terid=$terid&codperiodo=$codperiodo");
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: guardarquincena
    // Creación: 17/09/2024		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que actualiza los datos de la quincena laborada en la liquidación
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "guardarquincena")
    {
        $idliquidados = $_POST['idliquidados'];
        $terid = $_POST['terid'];
        $codperiodo = $_POST['codperiodo'];
        $diastrab = $_POST['diastrab'];
        $sueldo = $_POST['sueldo'];
        $subsidiotransporte = $_POST['subsidiotransporte'];
        $pension = $_POST['pension'];
        $salud = $_POST['salud'];
        
        // lista de quincenas del periodo
        $listaperiodos = generarlistaper($codperiodo);

        // obtengo el periodo
        $vsql = "SELECT MAX(pernominaid) periodoid FROM detalleliquidacion WHERE pernominaid IN ($listaperiodos) AND terid = ".$terid;
        $periodoid = $clase->SeleccionarUno($vsql);

        // obtengo el básico
        $basico = $clase->BDLockup($idliquidados,'tmpinfliquidados','idliquidados','basico');

        // sueldo
        $numregistro = 0;
        $detalleid = 0;
        $vsql2 = "SELECT COUNT(*) AS numregistro FROM detalleliquidacion WHERE terid = ".$terid." AND pernominaid = ".$periodoid." AND conceptoid = 1";
        $numregistro = $clase->SeleccionarUno($vsql2);

        if($numregistro > 0)
        {
            $vsql3 = "SELECT detalleid FROM detalleliquidacion WHERE terid = ".$terid." AND pernominaid = ".$periodoid." AND conceptoid = 1";
            $detalleid = $clase->SeleccionarUno($vsql3);

            $vsql4 = "UPDATE detalleliquidacion SET 
                             devengados = ".$sueldo.",
                             valor = ".$diastrab.", 
                             saldo = ".$basico."
                       WHERE detalleid = ".$detalleid;
        }
        else
            $vsql4 = "INSERT INTO detalleliquidacion (terid,conceptoid,pernominaid,devengados,descuentos,valor,saldo) 
                            VALUE (".$terid.",1,".$periodoid.",".$sueldo.",0,".$diastrab.",".$basico.")";

        $clase->EjecutarSQL($vsql4);

        // subsidio de transporte
        $numregistro = 0;
        $detalleid = 0;
        $valsubtransporte = $_SESSION['N_AUXTRANS2020'];
        $vsql2 = "SELECT COUNT(*) AS numregistro FROM detalleliquidacion WHERE terid = ".$terid." AND pernominaid = ".$periodoid." AND conceptoid = 3";
        $numregistro = $clase->SeleccionarUno($vsql2);

        if($numregistro > 0)
        {
            $vsql3 = "SELECT detalleid FROM detalleliquidacion WHERE terid = ".$terid." AND pernominaid = ".$periodoid." AND conceptoid = 3";
            $detalleid = $clase->SeleccionarUno($vsql3);

            $vsql4 = "UPDATE detalleliquidacion SET 
                             devengados = ".$subsidiotransporte.",
                             valor = ".$diastrab.", 
                             saldo = ".$valsubtransporte."
                       WHERE detalleid = ".$detalleid;
        }
        else
            $vsql4 = "INSERT INTO detalleliquidacion (terid,conceptoid,pernominaid,devengados,descuentos,valor,saldo) 
                            VALUE (".$terid.",3,".$periodoid.",".$subsidiotransporte.",0,".$diastrab.",".$valsubtransporte.")";

        $clase->EjecutarSQL($vsql4);

        // pensión
        $numregistro = 0;
        $detalleid = 0;

        $vsql = "SELECT SUM(d.devengados) AS totnovedades 
                   FROM detalleliquidacion d
                        INNER JOIN conceptosnomina c ON (d.conceptoid = c.conceptoid)
                  WHERE d.terid = ".$terid."
                        AND d.pernominaid = ".$periodoid." 
                        AND (c.eslicencia = 'CHECKED' AND c.tipodc='C')";
        $totnovedades = $clase->SeleccionarUno($vsql);

        $vsql = "SELECT IFNULL(SUM(d.devengados),0) AS totrecargos 
                   FROM detallenomina d
                        INNER JOIN conceptosnomina c ON (d.conceptoid = c.conceptoid)
                  WHERE d.terid = ".$terid."
                        AND d.pernominaid = ".$periodoid." 
                        AND (c.recargo = 'CHECKED' AND c.tipodc='C')";
        $totrecargos = $clase->SeleccionarUno($vsql);

        $sueldodeducciones = $sueldo + $totnovedades + $totrecargos;

        $vsql2 = "SELECT COUNT(*) AS numregistro FROM detalleliquidacion WHERE terid = ".$terid." AND pernominaid = ".$periodoid." AND conceptoid = 4";
        $numregistro = $clase->SeleccionarUno($vsql2);

        if($numregistro > 0)
        {
            $vsql3 = "SELECT detalleid FROM detalleliquidacion WHERE terid = ".$terid." AND pernominaid = ".$periodoid." AND conceptoid = 4";
            $detalleid = $clase->SeleccionarUno($vsql3);

            $vsql4 = "UPDATE detalleliquidacion SET 
                             descuentos = ".$pension.", 
                             saldo = ".$sueldodeducciones." 
                       WHERE detalleid = ".$detalleid;
        }
        else
            $vsql4 = "INSERT INTO detalleliquidacion (terid,conceptoid,pernominaid,devengados,descuentos,valor,saldo) 
                            VALUE (".$terid.",4,".$periodoid.",0,".$pension.",0,".$sueldodeducciones.")";

        $clase->EjecutarSQL($vsql4);

        // salud
        $numregistro = 0;
        $detalleid = 0;

        $vsql = "SELECT SUM(d.devengados) AS totnovedades 
                   FROM detalleliquidacion d
                        INNER JOIN conceptosnomina c ON (d.conceptoid = c.conceptoid)
                  WHERE d.terid = ".$terid."
                        AND d.pernominaid = ".$periodoid." 
                        AND (c.eslicencia = 'CHECKED' AND c.tipodc='C')";
        $totnovedades = $clase->SeleccionarUno($vsql);

        $vsql = "SELECT IFNULL(SUM(d.devengados),0) AS totrecargos 
                   FROM detallenomina d
                        INNER JOIN conceptosnomina c ON (d.conceptoid = c.conceptoid)
                  WHERE d.terid = ".$terid."
                        AND d.pernominaid = ".$periodoid." 
                        AND (c.recargo = 'CHECKED' AND c.tipodc='C')";
        $totrecargos = $clase->SeleccionarUno($vsql);

        $sueldodeducciones = $sueldo + $totnovedades + $totrecargos;

        $vsql2 = "SELECT COUNT(*) AS numregistro FROM detalleliquidacion WHERE terid = ".$terid." AND pernominaid = ".$periodoid." AND conceptoid = 5";
        $numregistro = $clase->SeleccionarUno($vsql2);

        if($numregistro > 0)
        {
            $vsql3 = "SELECT detalleid FROM detalleliquidacion WHERE terid = ".$terid." AND pernominaid = ".$periodoid." AND conceptoid = 5";
            $detalleid = $clase->SeleccionarUno($vsql3);

            $vsql4 = "UPDATE detalleliquidacion SET 
                             descuentos = ".$salud.", 
                             saldo = ".$sueldodeducciones." 
                       WHERE detalleid = ".$detalleid."";
        }
        else
            $vsql4 = "INSERT INTO detalleliquidacion (terid,conceptoid,pernominaid,devengados,descuentos,valor,saldo) 
                            VALUE (".$terid.",5,".$periodoid.",0,".$salud.",0,".$sueldodeducciones.")";

        $clase->EjecutarSQL($vsql4);

        // Aquí depuro los conceptos que estén en cero
        $vsql = "DELETE FROM detalleliquidacion WHERE devengados = 0 AND descuentos = 0 AND pernominaid = ".$periodoid." AND terid = ".$terid;
        $clase->EjecutarSQL($vsql);

        // Actualizo la tabla
        $vsql = "UPDATE tmpinfliquidados SET 
                        diastrab = ".$diastrab.",
                        sueldo = ".$sueldo.",
                        subsidiotransporte = ".$subsidiotransporte.",
                        pension = ".$pension.",
                        salud = ".$salud." 
                  WHERE idliquidados = ".$idliquidados;
        $clase->EjecutarSQL($vsql);

        // actualizo los totales
        $sueldo = $clase->BDLockup($idliquidados,'tmpinfliquidados','idliquidados','sueldo');
        $subsidiotransporte = $clase->BDLockup($idliquidados,'tmpinfliquidados','idliquidados','subsidiotransporte');
        $pagovaca = $clase->BDLockup($idliquidados,'tmpinfliquidados','idliquidados','pagovaca');
        $pagoprima = $clase->BDLockup($idliquidados,'tmpinfliquidados','idliquidados','pagoprima');
        $pagocedesantias = $clase->BDLockup($idliquidados,'tmpinfliquidados','idliquidados','pagocedesantias');
        $pagointereses = $clase->BDLockup($idliquidados,'tmpinfliquidados','idliquidados','pagointereses');
        $indemnizacion = $clase->BDLockup($idliquidados,'tmpinfliquidados','idliquidados','indemnizacion');
        
        // lista de quincenas del periodo
        $listaperiodos = generarlistaper($codperiodo);
        
        // otros devengados
        $vsq22 = "SELECT SUM(IF(devengados>0,devengados,0)) otrosdevengados
                    FROM detalleliquidacion 
                   WHERE terid = ".$terid." 
                         AND pernominaid IN ($listaperiodos)
                         AND conceptoid NOT IN (1,3) LIMIT 0,1";
        $otrosdevengados = $clase->SeleccionarUno($vsq22);

        $totaldevengado = $sueldo + $subsidiotransporte + $pagovaca + $pagoprima + $pagocedesantias + $pagointereses + $indemnizacion + $otrosdevengados;

        $pension = $clase->BDLockup($idliquidados,'tmpinfliquidados','idliquidados','pension');
        $salud = $clase->BDLockup($idliquidados,'tmpinfliquidados','idliquidados','salud');

        // otros descuentos
        $vsq23 = "SELECT SUM(IF(descuentos>0,descuentos,0)) otrosdescuentos
                    FROM detalleliquidacion 
                   WHERE terid = ".$terid." 
                         AND pernominaid IN ($listaperiodos) 
                         AND conceptoid NOT IN (4,5,6,9,43,58) LIMIT 0,1";
        $otrosdescuentos = $clase->SeleccionarUno($vsq23);
        
        // total descuento
        $totaldescuento = $pension + $salud + $otrosdescuentos;

        // neto a pagar
        $netoapagar = $totaldevengado - $totaldescuento;

        // grabo los totales
        $vsql = "UPDATE tmpinfliquidados SET 
                        otrosdevengados = ".$otrosdevengados.", 
                        otrosdescuentos = ".$otrosdescuentos.",
                        totaldevengado = ".$totaldevengado.",
                        totaldescuento = ".$totaldescuento.",
                        netoapagar = ".$netoapagar."
                  WHERE idliquidados = ".$idliquidados;
        $clase->EjecutarSQL($vsql);

        // emito el mensaje correspondiente
        $clase->Aviso(1,"Datos almacenados satisfactoriamente");

        // Redirecciono el formulario
        header("Location: liquidados.php?opcion=editarliquidacion&terid=$terid&codperiodo=$codperiodo");
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: ventanaelimconp
    // Creación: 19/09/2024		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que pinta la ventana para confirma la eliminación de un concepto
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "ventanaelimconp")
    {
        $terid = $_GET['terid'];
        $periodoid = $_GET['periodoid'];
        $idliquidados = $_GET['idliquidados'];
        $codperiodo = $_GET['codperiodo'];

        // nombre del periodo
        $desperiodo = $clase->BDLockup($codperiodo,'periodos','codperiodo','desperiodo');

        // nombre del empleado
        $nombre = $clase->BDLockup($idliquidados,'tmpinfliquidados','idliquidados','nombre');
 
        // combo de conceptos
        $params = ' class="Texto11" ';
        $vsqlcombocon = "SELECT c.conceptoid, CONCAT(c.codconcepto,' - ',c.nomconcepto) descripcion 
                           FROM conceptosnomina c
                                INNER JOIN detalleliquidacion d ON (c.conceptoid = d.conceptoid AND d.terid = ".$terid.")
                          WHERE (c.eslicencia='CHECKED' OR c.eslibranza ='CHECKED' OR c.montoocasional ='CHECKED' 
                                 OR c.montopermanente ='CHECKED' OR c.recargo ='CHECKED') 
                                AND d.pernominaid = ".$periodoid."  
                       ORDER BY c.conceptoid";
        $vsqlcomboconcepto = $clase->CrearComboBuscar("conceptoid",$vsqlcombocon,"nombres","conceptoid","","N",$params,300);

        // pinto la venana
        $cont ='<table width="500">
                 <tr class="CabezoteTabla"> 
                  <td width="20"> &nbsp; </td>
                  <td width="40"> <img src="images/iconos/eliminardoc.png" width="32" height="32" border="0"> </td>
                  <td width="440" align="center">
                   <label class="Texto12"> 
                   <b> Liquidaci&oacute;n del periodo </b> <font color="blue"> <br> '.$desperiodo.' </font> <br> Eliminar concepto 
                   </label>
                  </td>
                 </tr> 
                </table>
                <form action="?opcion=eliminarconceptoliq" method="POST">
                <input type="hidden" name="periodoid" value="'.$periodoid.'">
                <input type="hidden" name="terid" value="'.$terid.'">
                <input type="hidden" name="idliquidados" value="'.$idliquidados.'">
                <input type="hidden" name="codperiodo" value="'.$codperiodo.'">
                <table width="500">
                 <tr class="BarraDocumentos" style="height:50px;Important!">
                  <td width="20"> &nbsp; </td>
                  <td width="480" align="left"> <label class="Texto12"> <b>Empleado:</b> '.$nombre.' </label> </td>
                 </tr>
                 <tr class="BarraDocumentos" style="height:50px;Important!">
                  <td width="20"> &nbsp; </td>
                  <td width="480" align="left"> <label class="Texto12"> <b>Concepto:</b> </label> '.$vsqlcomboconcepto.' </td>
                 </tr>
                </table>
                <table width="500">
                 <tr class="BarraDocumentos" style="height:50px;Important!"> 
                  <td width="500" align="center">
                   <input type="submit" value="ACEPTAR" class="button blue">
                   <a href="liquidados.php?opcion=editarliquidacion&terid='.$terid.'&codperiodo='.$codperiodo.'">
                    <input type="button" value="CANCELAR" class="button red">
                   </a>
                   </form>
                  </td>
                 </tr>
                </table>';
        echo $cont;
        exit();
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: eliminarconceptoliq
    // Creación: 19/09/2024		última modificación: 02/10/2024
    // Creador: Luis Flórez		modificado por: Luis Flórez
    // Descripción: Proceso que elimina un concepto y actualiza la liquidación
    // Última modificación: Inclusión de la eliminación de recargos nocturnos
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "eliminarconceptoliq")
    {
        $terid = $_POST['terid'];
        $periodoid = $_POST['periodoid'];
        $idliquidados = $_POST['idliquidados'];
        $codperiodo = $_POST['codperiodo'];
        $conceptoid = $_POST['conceptoid'];

        // Obtengo los días del concepto que se eliminará
        $vsql = "SELECT SUM(valor) AS diasconcepto FROM detalleliquidacion WHERE terid = ".$terid." AND conceptoid = ".$conceptoid." AND pernominaid = ".$periodoid;
        $diasconcepto = $clase->SeleccionarUno($vsql);

        // elimino el concepto
        $vsql = "DELETE FROM detalleliquidacion WHERE terid = ".$terid." AND conceptoid = ".$conceptoid." AND pernominaid = ".$periodoid;
        $clase->EjecutarSQL($vsql);

        // Determino el ámbito del concepto
        $eslicencia = $clase->BDLockup($conceptoid,'conceptosnomina','conceptoid','eslicencia');
        $recargo = $clase->BDLockup($conceptoid,'conceptosnomina','conceptoid','recargo');

        // Valido si es una libranza o licencia para recalcular lo correspondiente a ese caso
        if(($eslicencia == "CHECKED") || ($recargo == "CHECKED"))
        {
            $basico = $clase->BDLockup($idliquidados,'tmpinfliquidados','idliquidados','basico');

            // Obtengo los días trabajados en el periodo
            $vsql = "SELECT valor
                       FROM detalleliquidacion 
                      WHERE conceptoid = 1  
                            AND pernominaid = ".$periodoid."
                            AND terid = ".$terid;
            $diastrab = $clase->SeleccionarUno($vsql);

            if($diastrab > 0)
            {
                // Obtengo el ID del registro que se modificará
                $vsql = "SELECT detalleid
                           FROM detalleliquidacion 
                          WHERE conceptoid = 1  
                                AND pernominaid = ".$periodoid."
                                AND terid = ".$terid;
                $detalleid = $clase->SeleccionarUno($vsql);
    
                // Obtengo la formula del sueldo
                $vsql = "SELECT formula FROM conceptosnomina WHERE conceptoid = 1";
                $formulabasico = $clase->SeleccionarUno($vsql);
    
                // Recalculo el sueldo del periodo
                $diastrab += $diasconcepto;
                eval("\$sueldo = $formulabasico;");
                $sueldo = round($sueldo,0);
    
                if(strlen($detalleid) == 0)
                {
                    $vsql = "SELECT max(detalleid) FROM detalleliquidacion";
                    $numreg = $clase->SeleccionarUno($vsql);
    
                    $vsql = "INSERT INTO detalleliquidacion VALUES ($numreg+1,".$terid.",1,".$periodoid.",".$sueldo.",0,".$diastrab.",$basico)";
                }
                else            
                    $vsql = "UPDATE detalleliquidacion SET 
                                    devengados = ".$sueldo.", 
                                    valor = ".$diastrab."
                              WHERE detalleid = ".$detalleid;
    
                // Almaceno en nuevo sueldo
                $clase->EjecutarSQL($vsql);
    
                // Obtengo el salario mínimo legal vigente
                $smlv = $_SESSION['N_SALMIN2020'];
    
                // Variable para la validación del auxilio de transporte
                $valsubtrasp = $smlv * 2;
    
                // Obtengo el cargo del empleado
                $vsqldatos = "SELECT cargoid FROM terceros WHERE terid = ".$terid;
                $cargoid = $clase->SeleccionarUno($vsqldatos);
                $vsqldatos = "";
    
                // Obtengo el control del cálculo de subsidio de transporte
                $aplicatransporte = $clase->BDLockup($cargoid,'cargos','cargoid','aplicatransporte');
    
                if(($basico <= $valsubtrasp) && ($aplicatransporte=="CHECKED"))
                {
                    // Obtengo la formula del subsidio de transporte
                    $auxtrans = $_SESSION['N_AUXTRANS2020'];
                    $vsql = "SELECT formula FROM conceptosnomina WHERE conceptoid = 3";
                    $formulatransporte = $clase->SeleccionarUno($vsql);
    
                    eval("\$subsidiotransporte = $formulatransporte;");
                    $subsidiotransporte = round($subsidiotransporte,0);
                }
                else
                    $subsidiotransporte = 0;
    
                // ID transporte
                $vsql = "SELECT detalleid AS idtransporte FROM detalleliquidacion WHERE terid = ".$terid." AND pernominaid = ".$periodoid." AND conceptoid = 3";
                $idtransporte = $clase->SeleccionarUno($vsql);
        
                if($idtransporte != "")
                    $vsql = "UPDATE detalleliquidacion SET 
                                    devengados = ".$subsidiotransporte.",
                                    valor = ".$diastrab."
                              WHERE detalleid = ".$idtransporte."";
                else
                {
                    // Obtengo el valor del subsidio de transporte
                    $valsubtransporte = $_SESSION['N_AUXTRANS2020'];
        
                    $vsql = "SELECT max(detalleid) FROM detalleliquidacion";
                    $numreg = $clase->SeleccionarUno($vsql);
        
                    $vsql = "INSERT INTO detalleliquidacion VALUES ($numreg+1,".$terid.",3,".$periodoid.",".$subsidiotransporte.",0,".$diastrab.",$valsubtransporte)";
                }
    
                // Grabo el subsidio de transporte
                $clase->EjecutarSQL($vsql);
            }
            else
            {
                $sueldo = 0;
                $subsidiotransporte = 0;
            }

            // ----------------------------- //
            // Recalculo la pensión y la salud

            // Obtengo la formula para el descuento por pensión
            $vsql = "SELECT formula FROM conceptosnomina WHERE conceptoid = 4";
            $formulapension = $clase->SeleccionarUno($vsql);

            // Obtengo la formula para el descuento de salud
            $vsql = "SELECT formula FROM conceptosnomina WHERE conceptoid = 5";
            $formulasalud = $clase->SeleccionarUno($vsql);

            // Determino si es extralegal
            $vsqldatos = "SELECT extralegal FROM terceros WHERE terid = ".$terid;
            $extralegal = $clase->SeleccionarUno($vsqldatos);
            $vsqldatos = "";

            // Determino la eps
            $vsqldatos = "SELECT epsid FROM terceros WHERE terid = ".$terid;
            $epsid = $clase->SeleccionarUno($vsqldatos);
            $vsqldatos = "";

            // Fondo de pensiones
            $vsqldatos = "SELECT pensionesid FROM terceros WHERE terid = ".$terid;
            $pensionesid = $clase->SeleccionarUno($vsqldatos);
            $vsqldatos = "";
            
            if($epsid==NULL)                    $epsid=0;
            if($pensionesid==NULL)              $pensionesid=0;

            // ----------------------------------------------------------------------------------------------------------- //
            $aplicapension = $clase->BDLockup($cargoid,'cargos','cargoid','aplicapension');     // Obtengo el control del cálculo de pensión
            $aplicasalud = $clase->BDLockup($cargoid,'cargos','cargoid','aplicasalud');         // Obtengo el control del cálculo de salud

            $vsql = "SELECT SUM(d.devengados) AS totnovedades 
                       FROM detalleliquidacion d
                            INNER JOIN conceptosnomina c ON (d.conceptoid = c.conceptoid)
                      WHERE d.terid = ".$terid."
                            AND d.pernominaid = ".$periodoid." 
                            AND (c.eslicencia='CHECKED' AND c.tipodc='C')";
            $totnovedades = $clase->SeleccionarUno($vsql);

            $vsql = "SELECT IFNULL(SUM(d.devengados),0) AS totrecargos 
                       FROM detalleliquidacion d
                            INNER JOIN conceptosnomina c ON (d.conceptoid = c.conceptoid)
                      WHERE d.terid = ".$terid."
                            AND d.pernominaid = ".$periodoid." 
                            AND (c.recargo = 'CHECKED' AND c.tipodc='C')";
            $totrecargos = $clase->SeleccionarUno($vsql);

            // Actualizo el sueldo
            $sueldodeducciones = $sueldo + $totnovedades + $totrecargos;

            if($extralegal == "CHECKED")
            {
                $pension = 0;
                $salud = 0;
            }
            else
            {
                // Recalculo pensión y salud
                if(($pensionesid == 5) || ($aplicapension != "CHECKED"))
                    $pension = 0;
                else
                {
                    // Obtengo la formula para el descuento por pensión
                    $vsql = "SELECT formula FROM conceptosnomina WHERE conceptoid = 4";
                    $formulapension = $clase->SeleccionarUno($vsql);

                    // Calculo la pensión
                    eval("\$pension = $formulapension;");
                    $pension = round($pension,0);
                }

                if(($epsid == 37) || ($aplicasalud != "CHECKED"))
                    $salud = 0;
                else
                {
                    // Obtengo la formula para el descuento de salud
                    $vsql = "SELECT formula FROM conceptosnomina WHERE conceptoid = 5";
                    $formulasalud = $clase->SeleccionarUno($vsql);
                    
                    // Calculo la salud
                    eval("\$salud = $formulasalud;");
                    $salud = round($salud,0);
                }
            }

            //  ID pensión
            $vsql = "SELECT detalleid AS idpension FROM detalleliquidacion WHERE terid = ".$terid." AND pernominaid = ".$periodoid." AND conceptoid = 4";
            $idpension = $clase->SeleccionarUno($vsql);

            // Grabo la pensión
            if($idpension!="")
                $vsql = "UPDATE detalleliquidacion SET 
                                descuentos = ".$pension.",
                                saldo = ".$sueldodeducciones."
                          WHERE detalleid = ".$idpension."";
            else
            {
                $vsql = "SELECT max(detalleid) FROM detalleliquidacion";
                $numreg = $clase->SeleccionarUno($vsql);

                $vsql = "INSERT INTO detalleliquidacion VALUES ($numreg+1,".$terid.",4,".$periodoid.",0,".$pension.",0,$sueldodeducciones)";
            }
            $clase->EjecutarSQL($vsql);

            // ID salud
            $vsql = "SELECT detalleid AS idsalud FROM detalleliquidacion WHERE terid = ".$terid." AND pernominaid = ".$periodoid." AND conceptoid = 5";
            $idsalud = $clase->SeleccionarUno($vsql);

            // Grabo la salud
            if($idsalud!="")
                $vsql = "UPDATE detalleliquidacion SET 
                                descuentos = ".$salud.",
                                saldo = ".$sueldodeducciones."
                          WHERE detalleid = ".$idsalud."";
            else
            {
                $vsql = "SELECT max(detalleid) FROM detalleliquidacion";
                $numreg = $clase->SeleccionarUno($vsql);

                $vsql = "INSERT INTO detalleliquidacion VALUES ($numreg+1,".$terid.",5,".$periodoid.",0,".$salud.",0,$sueldodeducciones)";
            }
            $clase->EjecutarSQL($vsql);

            // Aquí depuro la tabla eliminando los registros en cero, es decir lo que no se calculó
            $vsql = "DELETE FROM detalleliquidacion WHERE devengados <= 0 AND descuentos = <0 AND pernominaid = ".$periodoid." AND terid = ".$terid;
            $clase->EjecutarSQL($vsql);

            // actualizo en la tabla tmpinfliquidados

            // días trabajados
            $vsql = "SELECT SUM(IF(conceptoid IN (1,10,13,46),valor,0))
                       FROM detalleliquidacion
                      WHERE terid = ".$terid." 
                            AND pernominaid = ".$periodoid;
            $diastrabtmp = $clase->SeleccionarUno($vsql);

            // sueldo
            $vsql = "SELECT SUM(IF(conceptoid = 1,devengados,0)) 
                       FROM detalleliquidacion
                      WHERE terid = ".$terid." 
                            AND pernominaid = ".$periodoid;
            $sueldotmp = $clase->SeleccionarUno($vsql);

            // subsidio de transporte
            $vsql = "SELECT SUM(IF(conceptoid = 3,devengados,0)) 
                       FROM detalleliquidacion
                      WHERE terid = ".$terid." 
                            AND pernominaid = ".$periodoid;
            $subsidiotransportetmp = $clase->SeleccionarUno($vsql);

            // pensión
            $vsql = "SELECT SUM(IF(conceptoid = 4,descuentos,0)) 
                       FROM detalleliquidacion
                      WHERE terid = ".$terid." 
                            AND pernominaid = ".$periodoid;
            $pensiontmp = $clase->SeleccionarUno($vsql);

            // salud
            $vsql = "SELECT SUM(IF(conceptoid = 5,descuentos,0)) 
                       FROM detalleliquidacion
                      WHERE terid = ".$terid." 
                            AND pernominaid = ".$periodoid;
            $saludtmp = $clase->SeleccionarUno($vsql);

            $vsql = "UPDATE tmpinfliquidados SET 
                            diastrab = ".$diastrabtmp.", 
                            sueldo = ".$sueldotmp.",
                            subsidiotransporte = ".$subsidiotransportetmp.",
                            pension = ".$pensiontmp.",
                            salud = ".$saludtmp."
                      WHERE idliquidados = ".$idliquidados;
            $clase->EjecutarSQL($vsql);
        }

        // actualizo los totales
        $sueldo = $clase->BDLockup($idliquidados,'tmpinfliquidados','idliquidados','sueldo');
        $subsidiotransporte = $clase->BDLockup($idliquidados,'tmpinfliquidados','idliquidados','subsidiotransporte');
        $pagovaca = $clase->BDLockup($idliquidados,'tmpinfliquidados','idliquidados','pagovaca');
        $pagoprima = $clase->BDLockup($idliquidados,'tmpinfliquidados','idliquidados','pagoprima');
        $pagocedesantias = $clase->BDLockup($idliquidados,'tmpinfliquidados','idliquidados','pagocedesantias');
        $pagointereses = $clase->BDLockup($idliquidados,'tmpinfliquidados','idliquidados','pagointereses');
        $indemnizacion = $clase->BDLockup($idliquidados,'tmpinfliquidados','idliquidados','indemnizacion');
        
        // lista de quincenas del periodo
        $listaperiodos = generarlistaper($codperiodo);
        
        // otros devengados
        $vsq22 = "SELECT SUM(IF(devengados > 0,devengados,0)) otrosdevengados
                    FROM detalleliquidacion 
                   WHERE terid = ".$terid." 
                         AND pernominaid IN ($listaperiodos)
                         AND conceptoid NOT IN (1,3) LIMIT 0,1";
        $otrosdevengados = $clase->SeleccionarUno($vsq22);

        $totaldevengado = $sueldo + $subsidiotransporte + $pagovaca + $pagoprima + $pagocedesantias + $pagointereses + $indemnizacion + $otrosdevengados;

        $pension = $clase->BDLockup($idliquidados,'tmpinfliquidados','idliquidados','pension');
        $salud = $clase->BDLockup($idliquidados,'tmpinfliquidados','idliquidados','salud');

        // otros descuentos
        $vsq23 = "SELECT SUM(IF(descuentos > 0,descuentos,0)) otrosdescuentos
                    FROM detalleliquidacion 
                   WHERE terid = ".$terid." 
                         AND pernominaid IN ($listaperiodos) 
                         AND conceptoid NOT IN (4,5,6,9,43,58) LIMIT 0,1";
        $otrosdescuentos = $clase->SeleccionarUno($vsq23);
        
        // total descuento
        $totaldescuento = $pension + $salud + $otrosdescuentos;

        // neto a pagar
        $netoapagar = $totaldevengado - $totaldescuento;

        // grabo los totales
        $vsql = "UPDATE tmpinfliquidados SET 
                        otrosdevengados = ".$otrosdevengados.", 
                        otrosdescuentos = ".$otrosdescuentos.",
                        totaldevengado = ".$totaldevengado.",
                        totaldescuento = ".$totaldescuento.",
                        netoapagar = ".$netoapagar."
                  WHERE idliquidados = ".$idliquidados;
        $clase->EjecutarSQL($vsql);        

        // emito el mensaje correspondiente
        $nomconcepto = $clase->BDLockup($conceptoid,'conceptosnomina','conceptoid','nomconcepto');
        $nombre = $clase->BDLockup($idliquidados,'tmpinfliquidados','idliquidados','nombre');
        $clase->Aviso(1,"Se eliminó exitosamente el concepto $nomconcepto al empleado $nombre");

        // Redirecciono el formulario
        header("Location: liquidados.php?opcion=editarliquidacion&terid=$terid&codperiodo=$codperiodo");
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: ventanacorrecion
    // Creación: 24/09/2024		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que pinta la ventana para captar la hoja de Excel con las  
    //              correcciones de las liquidaciones
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "ventanacorrecion")
    {
        $codperiodo = $_GET['codperiodo'];

        $cont = '';
        $servidor = $_SERVER['SERVER_NAME'].":".$_SERVER['SERVER_PORT'];

        // // Validación del servidor
        // if(($servidor!="dromedicas.sytes.net:9996")&&($servidor!="192.168.14.248:9999"))
        //     $cont.='<table width="400">
        //              <tr class="CabezoteTabla"> 
        //               <td align="center"> <b>Servidor incorrecto </b> </td>
        //              </tr> 
        //              <tr class="CabezoteTabla"> 
        //               <td align="center"> 
        //                <font color=red> Este servidor est&aacute; inhabilitado para hacer este <br> 
        //                proceso, por favor diríjase al servidor </font> <br> 
        //                <font color=blue> 192.168.14.248:9999 </font> <br>
        //                <font color=red>o al servidor </font> <br> 
        //                <font color=blue> dromedicas.sytes.net:9996 </font> <br>
        //                <font color=red> para poder ejecutar este proceso </font> <br><br>
        //               </td> 
        //              </tr>
        //              <tr class="TablaDocsPar">
        //               <td width="100%" align="center"> 
        //                <form name="importa" method="post" action="?opcion=""" id="theform" enctype="multipart/form-data">                        
        //                 <input type="submit" name="enviar" id="enviarr"  value="aceptar" class="button blue" />
        //                </form> 
        //               </td>
        //              </tr>
        //             </table>';
        // else
        // {
            // nombre del periodo
            $desperiodo = $clase->BDLockup($codperiodo,'periodos','codperiodo','desperiodo');

            // pinto la ventana
            $cont.='<script type="text/javascript" src="lib/jquery-2.1.3.min.js"></script>
                    <script>
                     $(function()
                      {
                        $("#enviarr").on("click",function()
                       {
                        $(this).val("Espere por favor ...")
                        .attr("disabled","disabled");
                        $("#theform").submit();
                       });    
                      });
                    </script>';

            // encabezado
            $cont.='<table width="950">
                     <tr class="CabezoteTabla"> 
                      <td align="center"> <label class="Texto13"> <strong> Importar empleados liquidados <br> <font color="blue">'.strtolower($desperiodo).'</font> </strong> </label> </td> 
                     </tr> 
                    </table>
                    <table width="950">
                     <tr class="TablaDocsPar"> 
                      <td width="100%" align="center"> 
                       <form name="importa" method="post" action="?opcion=corregirliquidaciones" id="theform" enctype="multipart/form-data">
                       <input type="hidden" name = "codperiodo" value = "'.$codperiodo.'">
                       <input type="file" name="excel" /><br><br>
                       <input type="submit" name="enviar" id="enviarr"  value="Importar archivo" class="button blue" />
                       <input type="hidden" value="upload" name="action" /> 
                       </form> 
                      </td> 
                     </tr>
                    </table>';
    
            // Título
            $cont.='<table width="950">
                     <tr class="TablaDocsPar"> 
                      <td width="100%" align="center"> 
                       <label class="Texto13"><strong>La hoja de Excel debe tener la siguiente estructura: </strong></label>
                      </td> 
                     </tr>
                    </table>';

            // estructura de la tabla
            $cont.='<table width="950">
                     <tr class="TablaDocsPar"> 
                      <td align="left"> &nbsp; Columna <b>A</b>: c&eacute;dula </td> 
                      <td align="left"> &nbsp; Columna <b>B</b>: Sueldo  </td> 
                      <td align="left"> &nbsp; Columna <b>C</b>: Transporte </td> 
                     </tr>
                     <tr class="TablaDocsPar"> 
                      <td align="left"> &nbsp; Columna <b>D</b>: Pensi&oacute;n </td> 
                      <td align="left"> &nbsp; Columna <b>E</b>: Saud </td> 
                      <td align="left"> &nbsp; Columna <b>F</b>: Pago vacaciones </td> 
                     </tr>
                     <tr class="TablaDocsPar"> 
                      <td align="left"> &nbsp; Columna <b>G</b>: Pago prima </td> 
                      <td align="left"> &nbsp; Columna <b>H</b>: Pago cesant&iacute;a </td> 
                      <td align="left"> &nbsp; Columna <b>I</b>: Pago intereses </td> 
                     </tr>
                    </table>';

            // imagen de ejemplo de la hoja de excel
            $cont.='<table width="950">
                     <tr class="TablaDocsPar"> 
                      <td align="center"> 
                       <img src="images/iconos/ejemplocorreccionliq.png" width="950" height="260" border="0">
                      </td> 
                     </tr>
                     <tr class="TablaDocsPar"> 
                      <td width="100%" align="center"> 
                       <font color="blue"> Importante: Se debe utilizar un archivo de Excel con extensión .xlsx</font>
                      </td> 
                     </tr>
                    </table>';
        // }
        echo $cont;
        exit();        
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: corregirliquidaciones
    // Creación: 24/09/2024		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que efectúa las correcciones a las liquidaciones
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "corregirliquidaciones")
    {
		set_time_limit(0);
		extract($_POST);
        $codperiodo = $_POST["codperiodo"];
		$archivo = $_FILES['excel']['name'];
		$tipo = $_FILES['excel']['type'];
		$destino = "recursos/xls/bak_".$archivo;

        // Valido que la extensión del archivo sea xlsx
        $extension = pathinfo($destino, PATHINFO_EXTENSION);
        
        if($extension!="xlsx")
        {
            $clase->Aviso(3,"El archivo debe tener extensión .xlsx");
            header("Location: liquidados.php");
        }
        else
        {
            /// Valido si se cargó el archivo o no
            if (!copy($_FILES['excel']['tmp_name'],$destino))
                echo "Error Al Cargar el Archivo";
        
            if (file_exists ("recursos/xls/bak_".$archivo))
            {
                require_once('lib/PHPExcel.php');
                require_once('lib/PHPExcel/Reader/Excel2007.php');
                
                $objReader = new PHPExcel_Reader_Excel2007();
                $objPHPExcel = $objReader->load("recursos/xls/bak_".$archivo);
                $objFecha = new PHPExcel_Shared_Date();
                $objPHPExcel->setActiveSheetIndex(0);
                $conex = $clase->Conectar();
                $recorrer = true;  $i = 1;

                while($recorrer)
                {
                    $_DATOS_EXCEL[$i]['dni'] = $objPHPExcel->getActiveSheet()->getCell('A'.$i)->getCalculatedValue();
                    $_DATOS_EXCEL[$i]['sueldo'] = $objPHPExcel->getActiveSheet()->getCell('B'.$i)->getCalculatedValue();
                    $_DATOS_EXCEL[$i]['subsidiotransporte'] = $objPHPExcel->getActiveSheet()->getCell('C'.$i)->getCalculatedValue();
                    $_DATOS_EXCEL[$i]['pension'] = $objPHPExcel->getActiveSheet()->getCell('D'.$i)->getCalculatedValue();
                    $_DATOS_EXCEL[$i]['salud'] = $objPHPExcel->getActiveSheet()->getCell('E'.$i)->getCalculatedValue();
                    $_DATOS_EXCEL[$i]['pagovaca'] = $objPHPExcel->getActiveSheet()->getCell('F'.$i)->getCalculatedValue();
                    $_DATOS_EXCEL[$i]['pagoprima'] = $objPHPExcel->getActiveSheet()->getCell('G'.$i)->getCalculatedValue();
                    $_DATOS_EXCEL[$i]['pagocedesantias'] = $objPHPExcel->getActiveSheet()->getCell('H'.$i)->getCalculatedValue();
                    $_DATOS_EXCEL[$i]['pagointereses'] = $objPHPExcel->getActiveSheet()->getCell('I'.$i)->getCalculatedValue();
                
                    if(strlen($_DATOS_EXCEL[$i]['dni']) == 0)
                        $recorrer = false;
                    
                    $i++;
                } /// Fin del While
            }
            else
            { echo "Necesitas primero importar el archivo";  }  /// Si NO Cargó el archivo

            // lista de quincenas del periodo
            $listaperiodos = generarlistaper($codperiodo);

            for($j=1; $j < $i; $j++)
            {
                // inicialización de variables
                $sueldotot = 0;                 $subsidiotransportetot = 0;                 $pagovacatot = 0;                   $pagoprimatot = 0;
                $pagocedesantiastot = 0;        $pagointeresestot = 0;                      $indemnizaciontot = 0;              $pensiontot = 0;
                $saludtot = 0;                  $sueldodeducciones = 0;                     $sueldoemp = 0;                     $totnovedades = 0;
                $totrecargos = 0;

                $dni = $_DATOS_EXCEL[$j]['dni'];

                // valido que el empleado exista
                $vsql = "SELECT terid FROM tmpinfliquidados WHERE codperiodo = '".$codperiodo."' AND dni = '".$dni."'";
                $terid = $clase->SeleccionarUno($vsql);

                if($terid != "")
                {
                    $vsql = "SELECT idliquidados FROM tmpinfliquidados WHERE codperiodo = '".$codperiodo."' AND terid = ".$terid;
                    $idliquidados = $clase->SeleccionarUno($vsql);

                    // sueldo
                    $sueldo = round($_DATOS_EXCEL[$j]['sueldo'],0);

                    if($sueldo != 0)
                    {
                        // obtengo el periodo
                        $vsql = "SELECT MAX(pernominaid) periodoid FROM detalleliquidacion WHERE pernominaid IN ($listaperiodos) AND terid = ".$terid;
                        $periodoid = $clase->SeleccionarUno($vsql);

                        // obtengo el básico
                        $basico = $clase->BDLockup($idliquidados,'tmpinfliquidados','idliquidados','basico');

                        // días trabajados
                        $diastrab = (30 / $basico) * $sueldo;
                        $diastrab = round($diastrab,0);

                        // inicializo
                        $numregistro = 0;
                        $detalleid = 0;
                        $sualdoanterior = 0;
                        $sueldonuevo = 0;

                        // determino si ya existe
                        $vsql2 = "SELECT COUNT(*) AS numregistro FROM detalleliquidacion WHERE terid = ".$terid." AND pernominaid = ".$periodoid." AND conceptoid = 1";
                        $numregistro = $clase->SeleccionarUno($vsql2);

                        if($numregistro > 0)
                        {
                            // calculo el nuevo sueldo
                            $vsql3 = "SELECT devengados FROM detalleliquidacion WHERE terid = ".$terid." AND pernominaid = ".$periodoid." AND conceptoid = 1";
                            $sualdoanterior = $clase->SeleccionarUno($vsql3);

                            $sueldonuevo = $sualdoanterior + abs($sueldo);

                            // determino su id
                            $vsql3 = "SELECT detalleid FROM detalleliquidacion WHERE terid = ".$terid." AND pernominaid = ".$periodoid." AND conceptoid = 1";
                            $detalleid = $clase->SeleccionarUno($vsql3);

                            $vsql4 = "UPDATE detalleliquidacion SET 
                                             devengados = ".$sueldonuevo.",
                                             valor = ".$diastrab.", 
                                             saldo = ".$basico."
                                       WHERE detalleid = ".$detalleid;
                        }
                        else
                        {
                            $sueldonuevo = abs($sueldo);

                            $vsql4 = "INSERT INTO detalleliquidacion (terid,conceptoid,pernominaid,devengados,descuentos,valor,saldo) 
                                            VALUE (".$terid.",1,".$periodoid.",".$sueldonuevo.",0,".$diastrab.",".$basico.")";
                        }

                        // guardo en la tabla detalleliquidacion
                        $clase->EjecutarSQL($vsql4);

                        $vsql73 = "UPDATE tmpinfliquidados SET sueldo = ".$sueldonuevo." WHERE idliquidados = ".$idliquidados;
                        
                        // guardo en la tabla tmpinfliquidados
                        $clase->EjecutarSQL($vsql73);
                    }

                    // transporte
                    $subsidiotransporte = round($_DATOS_EXCEL[$j]['subsidiotransporte'],0);

                    if($subsidiotransporte != 0)
                    {
                        // obtengo el periodo
                        $vsql = "SELECT MAX(pernominaid) periodoid FROM detalleliquidacion WHERE pernominaid IN ($listaperiodos) AND terid = ".$terid;
                        $periodoid = $clase->SeleccionarUno($vsql);
                        
                        $valsubtransporte = $_SESSION['N_AUXTRANS2020'];

                        // días trabajados
                        $diastrab = (30 / $valsubtransporte) * $subsidiotransporte;
                        $diastrab = round($diastrab,0);

                        // inicializo
                        $numregistro = 0;
                        $detalleid = 0;
                        $trasporteanterior = 0;
                        $transportenuevo = 0;
                        
                        // determino si ya existe
                        $vsql2 = "SELECT COUNT(*) AS numregistro FROM detalleliquidacion WHERE terid = ".$terid." AND pernominaid = ".$periodoid." AND conceptoid = 3";
                        $numregistro = $clase->SeleccionarUno($vsql2);

                        if($numregistro > 0)
                        {
                            // calculo el nuevo subsidio de transporte
                            $vsql3 = "SELECT devengados FROM detalleliquidacion WHERE terid = ".$terid." AND pernominaid = ".$periodoid." AND conceptoid = 3";
                            $trasporteanterior = $clase->SeleccionarUno($vsql3);
                            
                            $transportenuevo = $trasporteanterior + abs($subsidiotransporte);

                            // determino su id
                            $vsql3 = "SELECT detalleid FROM detalleliquidacion WHERE terid = ".$terid." AND pernominaid = ".$periodoid." AND conceptoid = 3";
                            $detalleid = $clase->SeleccionarUno($vsql3);
                
                            $vsql4 = "UPDATE detalleliquidacion SET 
                                             devengados = ".$transportenuevo.",
                                             valor = ".$diastrab.", 
                                             saldo = ".$valsubtransporte."
                                       WHERE detalleid = ".$detalleid;
                        }
                        else
                        {
                            $transportenuevo = abs($subsidiotransporte);

                            $vsql4 = "INSERT INTO detalleliquidacion (terid,conceptoid,pernominaid,devengados,descuentos,valor,saldo) 
                                            VALUE (".$terid.",3,".$periodoid.",".$transportenuevo.",0,".$diastrab.",".$valsubtransporte.")";
                        }

                        // guardo en la tabla detalleliquidacion
                        $clase->EjecutarSQL($vsql4);

                        $vsql73 = "UPDATE tmpinfliquidados SET subsidiotransporte = ".$transportenuevo." WHERE idliquidados = ".$idliquidados;
                        
                        // guardo en la tabla tmpinfliquidados
                        $clase->EjecutarSQL($vsql73);
                    }

                    // pensión 
                    $pension = round($_DATOS_EXCEL[$j]['pension'],0);

                    if($pension != 0)
                    {
                        // obtengo el periodo
                        $vsql = "SELECT MAX(pernominaid) periodoid FROM detalleliquidacion WHERE pernominaid IN ($listaperiodos) AND terid = ".$terid;
                        $periodoid = $clase->SeleccionarUno($vsql);

                        // inicializo
                        $numregistro = 0;
                        $pensionanterior = 0;
                        $pensionnueva = 0;

                        // determino el sueldo para las deducciones
                        $vsql = "SELECT IFNULL(devengados,0) FROM detalleliquidacion WHERE pernominaid = ".$periodoid." AND conceptoid = 1 AND terid = ".$terid;
                        $sueldoemp = $clase->SeleccionarUno($vsql);
                        
                        $vsql = "SELECT SUM(d.devengados) AS totnovedades 
                                   FROM detalleliquidacion d
                                        INNER JOIN conceptosnomina c ON (d.conceptoid = c.conceptoid)
                                  WHERE d.terid = ".$terid."
                                        AND d.pernominaid = ".$periodoid." 
                                        AND (c.eslicencia='CHECKED' AND c.tipodc='C')";
                        $totnovedades = $clase->SeleccionarUno($vsql);
            
                        $vsql = "SELECT IFNULL(SUM(d.devengados),0) AS totrecargos 
                                   FROM detalleliquidacion d
                                        INNER JOIN conceptosnomina c ON (d.conceptoid = c.conceptoid)
                                  WHERE d.terid = ".$terid."
                                        AND d.pernominaid = ".$periodoid." 
                                        AND (c.recargo = 'CHECKED' AND c.tipodc='C')";
                        $totrecargos = $clase->SeleccionarUno($vsql);

                        $sueldodeducciones = $sueldoemp + $totnovedades + $totrecargos;

                        // determino si ya existe
                        $vsql2 = "SELECT COUNT(*) AS numregistro FROM detalleliquidacion WHERE terid = ".$terid." AND pernominaid = ".$periodoid." AND conceptoid = 4";
                        $numregistro = $clase->SeleccionarUno($vsql2);

                        if($numregistro > 0)
                        {
                            // calculo la nueva pensión
                            $vsql3 = "SELECT descuentos FROM detalleliquidacion WHERE terid = ".$terid." AND pernominaid = ".$periodoid." AND conceptoid = 4";
                            $pensionanterior = $clase->SeleccionarUno($vsql3);

                            $pensionnueva = $pensionanterior + abs($pension);

                            // determino su id
                            $vsql3 = "SELECT detalleid FROM detalleliquidacion WHERE terid = ".$terid." AND pernominaid = ".$periodoid." AND conceptoid = 4";
                            $detalleid = $clase->SeleccionarUno($vsql3);

                            $vsql4 = "UPDATE detalleliquidacion SET 
                                            descuentos = ".$pensionnueva.",
                                            saldo = ".$sueldodeducciones."
                                      WHERE detalleid = ".$detalleid;
                        }
                        else
                        {
                            $vsql = "SELECT max(detalleid) FROM detalleliquidacion";
                            $numreg = $clase->SeleccionarUno($vsql);

                            $pensionnueva = abs($pension);
            
                            $vsql4 = "INSERT INTO detalleliquidacion VALUES ($numreg+1,".$terid.",4,".$periodoid.",0,".$pensionnueva.",0,$sueldodeducciones)";
                        }

                        // guardo en la tabla detalleliquidacion
                        $clase->EjecutarSQL($vsql4);

                        $vsql73 = "UPDATE tmpinfliquidados SET pension = ".$pensionnueva." WHERE idliquidados = ".$idliquidados;
                        
                        // guardo en la tabla tmpinfliquidados
                        $clase->EjecutarSQL($vsql73);
                    }

                    // salud 
                    $salud = round($_DATOS_EXCEL[$j]['salud'],0);

                    if($salud != 0)
                    {
                        // obtengo el periodo
                        $vsql = "SELECT MAX(pernominaid) periodoid FROM detalleliquidacion WHERE pernominaid IN ($listaperiodos) AND terid = ".$terid;
                        $periodoid = $clase->SeleccionarUno($vsql);

                        // inicializo
                        $numregistro = 0;
                        $saludanterior = 0;
                        $saludnueva = 0;

                        // determino el sueldo para las deducciones
                        $vsql = "SELECT devengados FROM detalleliquidacion WHERE pernominaid = ".$periodoid." AND conceptoid = 1 AND terid = ".$terid;
                        $sueldoemp = $clase->SeleccionarUno($vsql);
                        
                        $vsql = "SELECT SUM(d.devengados) AS totnovedades 
                                   FROM detalleliquidacion d
                                        INNER JOIN conceptosnomina c ON (d.conceptoid = c.conceptoid)
                                  WHERE d.terid = ".$terid."
                                        AND d.pernominaid = ".$periodoid." 
                                        AND (c.eslicencia='CHECKED' AND c.tipodc='C')";
                        $totnovedades = $clase->SeleccionarUno($vsql);
            
                        $vsql = "SELECT IFNULL(SUM(d.devengados),0) AS totrecargos 
                                   FROM detalleliquidacion d
                                        INNER JOIN conceptosnomina c ON (d.conceptoid = c.conceptoid)
                                  WHERE d.terid = ".$terid."
                                        AND d.pernominaid = ".$periodoid." 
                                        AND (c.recargo = 'CHECKED' AND c.tipodc='C')";
                        $totrecargos = $clase->SeleccionarUno($vsql);

                        $sueldodeducciones = $sueldoemp + $totnovedades + $totrecargos;

                        // determino si ya existe
                        $vsql2 = "SELECT COUNT(*) AS numregistro FROM detalleliquidacion WHERE terid = ".$terid." AND pernominaid = ".$periodoid." AND conceptoid = 5";
                        $numregistro = $clase->SeleccionarUno($vsql2);

                        if($numregistro > 0)
                        {
                            // calculo la nueva pensión
                            $vsql3 = "SELECT descuentos FROM detalleliquidacion WHERE terid = ".$terid." AND pernominaid = ".$periodoid." AND conceptoid = 5";
                            $saludanterior = $clase->SeleccionarUno($vsql3);

                            $saludnueva = $saludanterior + abs($salud);

                            // determino su id
                            $vsql3 = "SELECT detalleid FROM detalleliquidacion WHERE terid = ".$terid." AND pernominaid = ".$periodoid." AND conceptoid = 5";
                            $detalleid = $clase->SeleccionarUno($vsql3);

                            $vsql4 = "UPDATE detalleliquidacion SET 
                                            descuentos = ".$saludnueva.",
                                            saldo = ".$sueldodeducciones." 
                                      WHERE detalleid = ".$detalleid;
                        }
                        else
                        {
                            $vsql = "SELECT max(detalleid) FROM detalleliquidacion";
                            $numreg = $clase->SeleccionarUno($vsql);

                            $saludnueva = abs($salud);
            
                            $vsql4 = "INSERT INTO detalleliquidacion VALUES ($numreg+1,".$terid.",4,".$periodoid.",0,".$saludnueva.",0,$sueldodeducciones)";
                        }

                        // guardo en la tabla detalleliquidacion
                        $clase->EjecutarSQL($vsql4);

                        $vsql73 = "UPDATE tmpinfliquidados SET salud = ".$saludnueva." WHERE idliquidados = ".$idliquidados;
                        
                        // guardo en la tabla tmpinfliquidados
                        $clase->EjecutarSQL($vsql73);
                    }

                    // vacaciones
                    $pagovaca = round($_DATOS_EXCEL[$j]['pagovaca'],0);

                    if($pagovaca != 0)
                    {
                        $numregistro = 0;
                        $idliquidacion = 0;
                        $pagovacaanterior = 0;
                        $pagovacanuevo = 0;

                        // determino si ya existe
                        $vsql2 = "SELECT COUNT(*) AS numregistro FROM liquidacion WHERE terid = ".$terid." AND periodonomina = '".$codperiodo."' AND tipo = 'vacaciones'";
                        $numregistro = $clase->SeleccionarUno($vsql2);
                
                        if($numregistro > 0)
                        {
                            // calculo el monto de las vacaciones
                            $vsql2 = "SELECT pago FROM liquidacion WHERE terid = ".$terid." AND periodonomina = '".$codperiodo."' AND tipo = 'vacaciones'";
                            $pagovacaanterior = $clase->SeleccionarUno($vsql2);
    
                            $pagovacanuevo = $pagovacaanterior + abs($pagovaca);

                            // consigo su id
                            $vsql3 = "SELECT idliquidacion FROM liquidacion WHERE terid = ".$terid." AND periodonomina = '".$codperiodo."' AND tipo = 'vacaciones'";
                            $idliquidacion = $clase->SeleccionarUno($vsql3);
                
                            $vsql4 = "UPDATE liquidacion SET pago = ".$pagovacanuevo." WHERE idliquidacion = ".$idliquidacion;
                        }
                        else
                        {
                            $pagovacanuevo = abs($pagovaca);
                            $diasvaca = $clase->BDLockup($idliquidados,'tmpinfliquidados','idliquidados','diasvaca');
                            $vsql4 = "INSERT INTO liquidacion (periodonomina, terid, tipo, pago, cantidad, porcentaje, pagointereses) 
                                           VALUES ('".$codperiodo."',".$terid.",'vacaciones',".$pagovacanuevo.",".$diasvaca.",0,0)";
                        }
                
                        // guardo en la tabla detalleliquidacion
                        $clase->EjecutarSQL($vsql4);

                        $vsql73 = "UPDATE tmpinfliquidados SET pagovaca = ".$pagovacanuevo." WHERE idliquidados = ".$idliquidados;
                        
                        // guardo en la tabla tmpinfliquidados
                        $clase->EjecutarSQL($vsql73);
                    }

                    // primas
                    $pagoprima = round($_DATOS_EXCEL[$j]['pagoprima'],0);

                    if($pagoprima != 0)
                    {
                        $numregistro = 0;
                        $idliquidacion = 0;
                        $pagoprimaanterior = 0;
                        $pagoprimanuevo = 0;

                        // determino si ya existe
                        $vsql2 = "SELECT COUNT(*) AS numregistro FROM liquidacion WHERE terid = ".$terid." AND periodonomina = '".$codperiodo."' AND tipo = 'primas'";
                        $numregistro = $clase->SeleccionarUno($vsql2);
                
                        if($numregistro > 0)
                        {
                            // calculo las primas
                            $vsql2 = "SELECT pago FROM liquidacion WHERE terid = ".$terid." AND periodonomina = '".$codperiodo."' AND tipo = 'primas'";
                            $pagoprimaanterior = $clase->SeleccionarUno($vsql2);
    
                            $pagoprimanuevo = $pagoprimaanterior + abs($pagoprima);

                            // busco su id
                            $vsql3 = "SELECT idliquidacion FROM liquidacion WHERE terid = ".$terid." AND periodonomina = '".$codperiodo."' AND tipo = 'primas'";
                            $idliquidacion = $clase->SeleccionarUno($vsql3);
                
                            $vsql4 = "UPDATE liquidacion SET pago = ".$pagoprimanuevo." WHERE idliquidacion = ".$idliquidacion;
                        }
                        else
                        {
                            $diasprima = $clase->BDLockup($idliquidados,'tmpinfliquidados','idliquidados','diasprima');
                            $pagoprimanuevo = abs($pagoprima);
                            $vsql4 = "INSERT INTO liquidacion (periodonomina, terid, tipo, pago, cantidad, porcentaje, pagointereses) 
                                                       VALUES ('".$codperiodo."',".$terid.",'primas',".$pagoprimanuevo.",".$diasprima.",0,0)";
                        }
                
                        // guardo en la tabla detalleliquidacion
                        $clase->EjecutarSQL($vsql4);

                        $vsql73 = "UPDATE tmpinfliquidados SET pagoprima = ".$pagoprimanuevo." WHERE idliquidados = ".$idliquidados;
                        
                        // guardo en la tabla tmpinfliquidados
                        $clase->EjecutarSQL($vsql73);
                    }
                    
                    // cesantías
                    $pagocedesantias = round($_DATOS_EXCEL[$j]['pagocedesantias'],0);
                    $pagointereses = round($_DATOS_EXCEL[$j]['pagointereses'],0);

                    if(($pagocedesantias != 0) || ($pagointereses != 0))
                    {
                        // inicializo
                        $numregistro = 0;
                        $idliquidacion = 0;
                        $pagocedesantiasanterior = 0;
                        $pagocedesantiasnuevo = 0;
                        $pagointeresesant = 0;
                        $pagointeresesnew = 0;

                        // determino si ya existe
                        $vsql2 = "SELECT COUNT(*) AS numregistro FROM liquidacion WHERE terid = ".$terid." AND periodonomina = '".$codperiodo."' AND tipo = 'cesantias'";
                        $numregistro = $clase->SeleccionarUno($vsql2);
                
                        if($numregistro > 0)
                        {
                            // calculo el nuevo pago de cesantías
                            $vsql2 = "SELECT pago FROM liquidacion WHERE terid = ".$terid." AND periodonomina = '".$codperiodo."' AND tipo = 'cesantias'";
                            $pagocedesantiasanterior = $clase->SeleccionarUno($vsql2);

                            $pagocedesantiasnuevo = $pagocedesantiasanterior + abs($pagocedesantias);

                            // calculo los nuevos intereses
                            $vsql2 = "SELECT pagointereses FROM liquidacion WHERE terid = ".$terid." AND periodonomina = '".$codperiodo."' AND tipo = 'cesantias'";
                            $pagointeresesant = $clase->SeleccionarUno($vsql2);

                            $pagointeresesnew = $pagointeresesant + abs($pagointereses);

                            // determino su id
                            $vsql3 = "SELECT idliquidacion FROM liquidacion WHERE terid = ".$terid." AND periodonomina = '".$codperiodo."' AND tipo = 'cesantias'";
                            $idliquidacion = $clase->SeleccionarUno($vsql3);
                
                            $vsql4 = "UPDATE liquidacion SET pago = ".$pagocedesantiasnuevo.", pagointereses = ".$pagointeresesnew." WHERE idliquidacion = ".$idliquidacion;
                        }
                        else
                        {
                            $diasdecesantias = $clase->BDLockup($idliquidados,'tmpinfliquidados','idliquidados','diasdecesantias');
                            $porcentaje = 12;
                            $pagocedesantiasnuevo = abs($pagocedesantias);
                            $pagointeresesnew = abs($pagointereses);

                            $vsql4 = "INSERT INTO liquidacion (periodonomina, terid, tipo, pago, cantidad, porcentaje, pagointereses) 
                                           VALUES ('".$codperiodo."',".$terid.",'cesantias',".$pagocedesantiasnuevo.",".$diasdecesantias.",".$porcentaje.",".$pagointeresesnew.")";
                        }
                
                        // guardo en la tabla detalleliquidacion
                        $clase->EjecutarSQL($vsql4);

                        $vsql73 = "UPDATE tmpinfliquidados SET 
                                          pagocedesantias = ".$pagocedesantiasnuevo.",  
                                          pagointereses = ".$pagointeresesnew." 
                                    WHERE idliquidados = ".$idliquidados;
                        
                        // guardo en la tabla tmpinfliquidados
                        $clase->EjecutarSQL($vsql73);
                    }

                    // actualizo los totales
                    $sueldotot = $clase->BDLockup($idliquidados,'tmpinfliquidados','idliquidados','sueldo');
                    $subsidiotransportetot = $clase->BDLockup($idliquidados,'tmpinfliquidados','idliquidados','subsidiotransporte');
                    $pagovacatot = $clase->BDLockup($idliquidados,'tmpinfliquidados','idliquidados','pagovaca');
                    $pagoprimatot = $clase->BDLockup($idliquidados,'tmpinfliquidados','idliquidados','pagoprima');
                    $pagocedesantiastot = $clase->BDLockup($idliquidados,'tmpinfliquidados','idliquidados','pagocedesantias');
                    $pagointeresestot = $clase->BDLockup($idliquidados,'tmpinfliquidados','idliquidados','pagointereses');
                    $indemnizaciontot = $clase->BDLockup($idliquidados,'tmpinfliquidados','idliquidados','indemnizacion');
                    
                    // otros devengados
                    $vsq22 = "SELECT SUM(IF(devengados>0,devengados,0)) otrosdevengados
                                FROM detalleliquidacion 
                               WHERE terid = ".$terid." 
                                     AND pernominaid IN ($listaperiodos)
                                     AND conceptoid NOT IN (1,3) LIMIT 0,1";
                    $otrosdevengados = $clase->SeleccionarUno($vsq22);

                    $totaldevengado = $sueldotot + $subsidiotransportetot + $pagovacatot + $pagoprimatot + $pagocedesantiastot + $pagointeresestot + $indemnizaciontot + $otrosdevengados;

                    $pensiontot = $clase->BDLockup($idliquidados,'tmpinfliquidados','idliquidados','pension');
                    $saludtot = $clase->BDLockup($idliquidados,'tmpinfliquidados','idliquidados','salud');

                    // otros descuentos
                    $vsq23 = "SELECT SUM(IF(descuentos>0,descuentos,0)) otrosdescuentos 
                                FROM detalleliquidacion 
                               WHERE terid = ".$terid." 
                                     AND pernominaid IN ($listaperiodos) 
                                     AND conceptoid NOT IN (4,5,6,9,43,58) LIMIT 0,1";
                    $otrosdescuentos = $clase->SeleccionarUno($vsq23);
                    
                    // total descuento
                    $totaldescuento = $pensiontot + $saludtot + $otrosdescuentos;

                    // neto a pagar
                    $netoapagar = $totaldevengado - $totaldescuento;

                    // grabo los totales
                    $vsql = "UPDATE tmpinfliquidados SET 
                                    otrosdevengados = ".$otrosdevengados.", 
                                    otrosdescuentos = ".$otrosdescuentos.",
                                    totaldevengado = ".$totaldevengado.",
                                    totaldescuento = ".$totaldescuento.",
                                    netoapagar = ".$netoapagar."
                              WHERE idliquidados = ".$idliquidados;
                    $clase->EjecutarSQL($vsql);
                }
            }

            // emito el mensaje correspondiente
            $clase->Aviso(1,"Datos almacenados satisfactoriamente");

            // redirecciona el formulario
            header("Location: liquidados.php");
        }
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: confirmaractliq
    // Creación: 05/10/2024		última modificación: 13/11/2024
    // Creador: Luis Flórez		modificado por: Luis Flórez
    // Descripción: Opción que pinta la ventana para validar la actualización de 
    //              liquidaciones manuales
    // Última modificación: Ajuste de la ventana y botones
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "confirmaractliq")
    {
        $codperiodo = $_GET['codperiodo'];

        // inicialización de variables
        $numregtmp = 0;
        $numregliq = 0;

        // número de registros en la tabla tmpinfliquidados
        $vsql13 = "SELECT COUNT(*) numregtmp FROM tmpinfliquidados WHERE codperiodo = '".$codperiodo."'";
        $numregtmp = $clase->SeleccionarUno($vsql13);

        // número de registros en la tabla liquidacion
        $vsql33 = "SELECT DISTINCT terid FROM liquidacion WHERE periodonomina = '".$codperiodo."'";
        $conex = $clase->Conectar();
        $result3 = mysql_query($vsql33,$conex);
        $numregliq = mysql_num_rows($result3);

        // valido la actualización
        if($numregliq <= $numregtmp)
            $cont ='<table width="500">
                     <tr class="CabezoteTabla"> 
                      <td width="50" align="center"> <img src="images/iconos/alerta.png" width="32" height="32" border="0"> </td> 
                      <td width="450" align="center"> <br> <b> Actualizar liquidaciones </b> <br><br> </td> 
                     </tr> 
                    </table>
                    <table width="500">
                     <tr class="TablaDocsImPar">       
                      <td width="400" align="center"> <br> <h2> No hay liquidaciones por actualizar </h2> </td>
                     </tr>
                     <tr class="TablaDocsImPar">       
                      <td width="400" align="center"><br><br>
                       <a href="liquidados.php">
                        <input type="button" value="ACEPTAR" class="button blue">
                       </a>
                      </td>
                     </tr>
                    </table><br>';
        else
        {
            // muestro los empleados sujetos a actualización de liquidaciones
            $vsql = "SELECT DISTINCT l.terid,
                            (SELECT dni FROM terceros WHERE terid = l.terid LIMIT 0,1) dni,
                            (SELECT CONCAT(primernombre,' ',segundonombre,' ',primerapellido,' ',segundoapellido) FROM terceros WHERE terid = l.terid LIMIT 0,1) nombre
                       FROM liquidacion l 
                      WHERE l.periodonomina = '".$codperiodo."' 
                            AND l.terid NOT IN (SELECT terid 
                                                  FROM tmpinfliquidados 
                                                  WHERE codperiodo = '".$codperiodo."')";

            // impresión del detalle
            $i = 0;             $det = '';
            $conex  = $clase->Conectar();
            $result = mysql_query($vsql,$conex);
            while($row = mysql_fetch_array($result))
            {
                $i++;
                if($i%2 == 0)
                    $det.='<tr class="TablaDocsPar">';
                else
                    $det.='<tr class="TablaDocsImPar">';

                $det.= ' <td width="20"> &nbsp; </td>
                         <td width="100" align="left"> '.$row['dni'].' </td>
                         <td width="380" align="left"> '.$row['nombre'].' </td>
                        </tr>';
            }

            // impresión de los botones y el pie de página
            $pie.= ' </tbody>
                    </table>
                    <table width="500"> <tr class="TituloTabla"> <td width="500"> &nbsp; </td> </tr> </table>
                    <table width="500">
                     <tr class="TablaDocsImPar">
                      <td width="500" align="center"><br>
                       <form action="?opcion=actualizarliqmanuales" method="POST">
                       <input type="hidden" name="codperiodo" value="'.$codperiodo.'">
                       <input type="submit" value="ACEPTAR" class="button blue">
                       <a href="liquidados.php"> <input type="button" value="CANCELAR" class="button red"> </a>
                       </form>
                      </td>
                     </tr>
                    </table>';

            // encabezado de la ventana
            $enc = '<table width="500">
                     <tr class="CabezoteTabla"> 
                      <td width="50" align="center"> <img src="images/iconos/alerta.png" width="32" height="32" border="0"> </td> 
                      <td width="450" align="center"> <br> <b> Actualizar liquidaciones </b> <br><br> </td> 
                     </tr> 
                    </table>
                    <script type="text/javascript" src="lib/sorttable.js"></script>
                    <table width="500" class="sortable">
                     <thead> 
                      <tr class="TituloTabla" style="display:block;padding-top:5px;height:20px;">
                       <td width="20"> &nbsp; </td>
                       <td width="100"> Documento </td>
                       <td width="380"> Nombre </td>
                      </tr>
                     </thead>
                     <tbody style="display:block; width:500px; height:150px; overflow-Y:scroll">';

            // Construyo el contenido del formulario
            $cont = $enc.$det.$pie;
        }

        echo $cont;
        exit();
    }
    
    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: actualizarliqmanuales
    // Creación: 05/10/2024		última modificación: 13/11/2024
    // Creador: Luis Flórez		modificado por: Luis Flórez
    // Descripción: Opción que actualiza las liquidaciones procesadas de forma manual
    // Última modificación: Depuración de las tablas para evitar duplicados
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "actualizarliqmanuales")
    {
        $codperiodo = $_POST['codperiodo'];

        $vsql = "SELECT DISTINCT l.terid 
                   FROM liquidacion l 
                  WHERE l.periodonomina = '".$codperiodo."' 
                        AND l.terid NOT IN (SELECT terid 
                                              FROM tmpinfliquidados 
                                             WHERE codperiodo = '".$codperiodo."')";

        $conex = $clase->Conectar();
        $result = mysql_query($vsql,$conex);
        $numregact = mysql_num_rows($result);
        while($row = mysql_fetch_array($result))
        {
            $terid = $row['terid'];

            // inicializo las variables
            $pagoprima = 0;
            $pagovaca = 0;
            $pagocedesantias = 0;
            $pagointereses = 0;

            // obtengo el valor de las primas
            $vsql35 = "SELECT IFNULL(pago,0) pagoprimas FROM liquidacion WHERE periodonomina = '".$codperiodo."' AND tipo = 'primas' AND terid = ".$terid;
            $pagoprima = $clase->SeleccionarUno($vsql35);

            if($pagoprima == "")
                $pagoprima = 0;

            $vsql35 = "SELECT IFNULL(cantidad,0) diasprima FROM liquidacion WHERE periodonomina = '".$codperiodo."' AND tipo = 'primas' AND terid = ".$terid;
            $diasprima = $clase->SeleccionarUno($vsql35);

            if($diasprima == "")
                $diasprima = 0;

            // obtengo el valor de las vacaciones
            $vsql35 = "SELECT IFNULL(pago,0) pagovaca FROM liquidacion WHERE periodonomina = '".$codperiodo."' AND tipo = 'vacaciones' AND terid = ".$terid;
            $pagovaca = $clase->SeleccionarUno($vsql35);

            if($pagovaca == "")
                $pagovaca = 0;

            $vsql35 = "SELECT IFNULL(cantidad,0) diasvaca FROM liquidacion WHERE periodonomina = '".$codperiodo."' AND tipo = 'vacaciones' AND terid = ".$terid;
            $diasvaca = $clase->SeleccionarUno($vsql35);

            if($diasvaca == "")
                $diasvaca = 0;

            // obtengo los valores de las cesantías
            $vsql35 = "SELECT IFNULL(pago,0) pagocedesantias FROM liquidacion WHERE periodonomina = '".$codperiodo."' AND tipo = 'cesantias' AND terid = ".$terid;
            $pagocedesantias = $clase->SeleccionarUno($vsql35);

            if($pagocedesantias == "")
                $pagocedesantias = 0;

            $vsql35 = "SELECT IFNULL(pagointereses,0) pagointereses FROM liquidacion WHERE periodonomina = '".$codperiodo."' AND tipo = 'cesantias' AND terid = ".$terid;
            $pagointereses = $clase->SeleccionarUno($vsql35);

            if($pagointereses == "")
                $pagointereses = 0;

            $vsql35 = "SELECT IFNULL(cantidad,0) diasdecesantias FROM liquidacion WHERE periodonomina = '".$codperiodo."' AND tipo = 'cesantias' AND terid = ".$terid;
            $diasdecesantias = $clase->SeleccionarUno($vsql35);

            if($diasdecesantias == "")
                $diasdecesantias = 0;

            // obtengo el valor de la indemnización                
            $vsql35 = "SELECT IFNULL(pago,0) indemnizacion FROM liquidacion WHERE periodonomina = '".$codperiodo."' AND tipo = 'indemnizacion' AND terid = ".$terid;
            $indemnizacion = $clase->SeleccionarUno($vsql35);

            if($indemnizacion == "")
                $indemnizacion = 0;

            // lista de quincenas del periodo
            $listaperiodos = generarlistaper($codperiodo);

            // días trabajados
            $vsql = "SELECT SUM(IF(conceptoid IN (1,10,13,46),valor,0))
                       FROM detalleliquidacion
                      WHERE terid = ".$terid." 
                            AND pernominaid IN ($listaperiodos)";
            $diastrabtmp = $clase->SeleccionarUno($vsql);

            if($diastrabtmp == "")
                $diastrabtmp = 0;

            // sueldo
            $vsql = "SELECT SUM(IF(conceptoid = 1,devengados,0)) 
                       FROM detalleliquidacion
                      WHERE terid = ".$terid." 
                            AND pernominaid IN ($listaperiodos)";
            $sueldotmp = $clase->SeleccionarUno($vsql);

            if($sueldotmp == "")
                $sueldotmp = 0;

            // subsidio de transporte
            $vsql = "SELECT SUM(IF(conceptoid = 3,devengados,0)) 
                       FROM detalleliquidacion
                      WHERE terid = ".$terid." 
                            AND pernominaid IN ($listaperiodos)";
            $subsidiotransportetmp = $clase->SeleccionarUno($vsql);

            if($subsidiotransportetmp == "")
                $subsidiotransportetmp = 0;

            // pensión
            $vsql = "SELECT SUM(IF(conceptoid = 4,descuentos,0)) 
                       FROM detalleliquidacion
                      WHERE terid = ".$terid." 
                            AND pernominaid IN ($listaperiodos)";
            $pensiontmp = $clase->SeleccionarUno($vsql);

            if($pensiontmp == "")
                $pensiontmp = 0;

            // salud
            $vsql = "SELECT SUM(IF(conceptoid = 5,descuentos,0)) 
                       FROM detalleliquidacion
                      WHERE terid = ".$terid." 
                            AND pernominaid IN ($listaperiodos)";
            $saludtmp = $clase->SeleccionarUno($vsql);

            if($saludtmp == "")
                $saludtmp = 0;

            // otros devengados
            $vsq22 = "SELECT IFNULL(SUM(devengados),0) otrosdevengados 
                        FROM detalleliquidacion 
                       WHERE terid = ".$terid." 
                             AND pernominaid IN ($listaperiodos)
                             AND conceptoid NOT IN (1,3) LIMIT 0,1";
            $otrosdevengados = $clase->SeleccionarUno($vsq22);            

            $totaldevengado = $sueldotmp + $subsidiotransportetmp + $pagovaca + $pagoprima + $pagocedesantias + $pagointereses + $indemnizacion + $otrosdevengados;

            // otros descuentos
            $vsq23 = "SELECT IFNULL(SUM(descuentos),0) otrosdescuentos 
                        FROM detalleliquidacion 
                       WHERE terid = ".$terid." 
                             AND pernominaid IN ($listaperiodos) 
                             AND conceptoid NOT IN (4,5,6,9,43,58) LIMIT 0,1";
            $otrosdescuentos = $clase->SeleccionarUno($vsq23);
            
            // total descuento
            $totaldescuento = $pensiontmp + $saludtmp + $otrosdescuentos;

            // neto a pagar
            $netoapagar = $totaldevengado - $totaldescuento;

            // básico
            $basicoinf = $clase->BDLockup($terid,"terceros","terid","basico");

            // documento
            $dni = $clase->BDLockup($terid,'terceros','terid','dni');

            // nombre del empleado
            $nomreemp = "CONCAT(primernombre,' ',segundonombre,' ',primerapellido,' ',segundoapellido)";
            $nombreempleado = $clase->BDLockup($terid,'terceros','terid',$nomreemp);

            // documento
            $codvende = $clase->BDLockup($terid,'terceros','terid','codvende');

            // fechas de ingreso y retiro
            $vsql21 = "SELECT MAX(id) AS id FROM histcontrato WHERE terid = ".$terid;
            $id = $clase->SeleccionarUno($vsql21);
            $fecingreso = $clase->BDLockup($id,'histcontrato','id','fecingreso');
            $fecretiro = $clase->BDLockup($id,'histcontrato','id','fecretiro');

            // Depuro las tablas para evitar duplicados
            $clase->EjecutarSQL("DELETE FROM tmpinfliquidados WHERE codperiodo = '".$codperiodo."' AND terid = ".$terid."");
            $clase->EjecutarSQL("DELETE FROM parametrosliquidacion WHERE codperiodo = '".$codperiodo."' AND terid = ".$terid."");

            // guardo en la tabla del informe
            $vsql = "INSERT INTO tmpinfliquidados (codperiodo,terid,dni,codvende,nombre,fecingreso,fecretiro,basico,diastrab,sueldo,subsidiotransporte,pension,salud,diasvaca,pagovaca,diasprima,
                                                   pagoprima,diasdecesantias,pagocedesantias,pagointereses,indemnizacion,otrosdevengados,otrosdescuentos,totaldevengado, totaldescuento,netoapagar) 
                           VALUE ('".$codperiodo."',".$terid.",'".$dni."','".$codvende."','".$nombreempleado."','".$fecingreso."','".$fecretiro."',".$basicoinf.",".$diastrabtmp.",".$sueldotmp.",
                                  ".$subsidiotransportetmp.",".$pensiontmp.",".$saludtmp.",".$diasvaca.",".$pagovaca.",".$diasprima.",".$pagoprima.",".$diasdecesantias.",".$pagocedesantias.",
                                  ".$pagointereses.",".$indemnizacion.",".$otrosdevengados.",".$otrosdescuentos.",".$totaldevengado.",".$totaldescuento.",".$netoapagar.")";
            $clase->EjecutarSQL($vsql);

            // guardo en la tabla parametrosliquidacion
            $cesantiasyearanterior = "NO";                          $cesantiasyearactual = "SI";                            $intcesantiasyearanterior = "NO";
            $intcesantiasyearactual = "SI";                         $vacaciones = "SI";                                     $primasprimersemestre = "SI";
            $primassegundosemestre = "NO";                          $calcularquin = "SI";                                   $nroquincena = 1;
            $norecalcular = "";

            $vsql69 = "INSERT INTO parametrosliquidacion (terid,codperiodo,cesantiasyearanterior,cesantiasyearactual,intcesantiasyearanterior,intcesantiasyearactual,vacaciones,
                                                          primasprimersemestre,primassegundosemestre,calcularquin,nroquincena,norecalcular) 
                             VALUE (".$terid.",'".$codperiodo."','".$cesantiasyearanterior."','".$cesantiasyearactual."','".$intcesantiasyearanterior."','".$intcesantiasyearactual."',
                                    '".$vacaciones."','".$primasprimersemestre."','".$primassegundosemestre."','".$calcularquin."',".$nroquincena.",'".$norecalcular."')";
            $clase->EjecutarSQL($vsql69);
        }

        // Redirecciono el formulario
        header("Location: liquidados.php");
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: incluirrecargonoc
    // Creación: 02/10/2024		última modificación: 08/11/2024
    // Creador: Luis Flórez		modificado por: Luis Flórez
    // Descripción: Opción que pinta la ventana para captar los días del recargo nocturno
    // Última modificación: Adaptación para todos los tipos de recargo
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "incluirrecargonoc")
    {
        $codperiodo = $_GET['codperiodo'];
        $terid = $_GET['terid'];
        $idliquidados = $_GET['idliquidados'];
        $periodoid = $_GET['periodoid'];

        // nombre del periodo
        $desperiodo = $clase->BDLockup($codperiodo,'periodos','codperiodo','desperiodo');

        // nombre del empleado
        $nombre = $clase->BDLockup($idliquidados,'tmpinfliquidados','idliquidados','nombre');

        // $dias = 1;

        // combo de recargos
        $vsqlcomborecargo = "SELECT conceptoid, nomconcepto descripcion FROM conceptosnomina WHERE recargo = 'CHECKED'";
        $comborecargo = $clase->CrearComboBuscar("conceptoid",$vsqlcomborecargo,"descripcion","conceptoid","","S",$params,400);

        // cantidad
        $cantidad = 1;        

        // determino si la liquidación está cerrada
        $vsqldatos = "SELECT norecalcular FROM parametrosliquidacion WHERE terid = ".$terid." AND codperiodo = '".$codperiodo."'";
        $norecalcular = $clase->SeleccionarUno($vsqldatos);

        // pinto la ventana
        if($norecalcular == "CHECKED")
            $cont ='<table width="500">
                     <tr class="CabezoteTabla"> 
                      <td align="center"><br> <b>Advertencia</b> <br><br> </td> 
                     </tr> 
                    </table>
                    <table width="500">
                     <tr class="TablaDocsImPar">       
                      <td width="400" align="center"> <label class="Texto12"> Esta liquidaci&oacute;n est&aacute; cerrada </label> </td>
                     </tr>
                     <tr class="TablaDocsImPar">
                      <td width="400" align="center"> <br><br>
                       <input type="hidden" name="codperiodo" value="'.$codperiodo.'">
                       <input type="hidden" name="terid" value="'.$terid.'">
                       <a href="liquidados.php?opcion=editarliquidacion&terid='.$terid.'&codperiodo='.$codperiodo.'">
                        <input type="button" value="ACEPTAR" class="button blue">
                       </a>
                      </td>
                     </tr>
                    </table><br>';
        else
            $cont= '<table width="500">
                     <tr class="CabezoteTabla">
                      <td width="50" align="left"> <img src="images/iconos/park.png" width="32" height="32" border="0"> </td>
                      <td width="450" align="center"> <label class="Texto12"> <b>Inclusi&oacute;n de recargo <br> <font color="blue"> '.$desperiodo.' </font> </b> </label> </td>
                     </tr>
                    </table>
                    <form action="?opcion=guardarrecargonoc" method="POST">
                    <input type="hidden" name="periodoid" value="'.$periodoid.'">
                    <input type="hidden" name="terid" value="'.$terid.'">
                    <input type="hidden" name="codperiodo" value="'.$codperiodo.'">
                    <input type="hidden" name="idliquidados" value="'.$idliquidados.'">
                    <table width="500">
                     <tr class="BarraDocumentos" style="height:60px;Important!"> 
                      <td width="20"> &nbsp; </td>
                      <td width="480" align="left"> <label class="Texto12"> <b> Empleado: </b> <br>'.$nombre.' </label> </td>
                     </tr>
                     <tr class="BarraDocumentos" style="height:60px;Important!"> 
                      <td width="20"> &nbsp; </td>
                      <td width="480" align="left"> <label class="Texto12"> <b> Concepto: </b> <br>'.$comborecargo.' </label> </td>
                     </tr>
                     <tr class="BarraDocumentos" style="height:60px;Important!"> 
                      <td width="20"> &nbsp; </td>
                      <td width="480" align="left"> 
                       <label class="Texto12"> <b> Cantidad: </b> </label> <br>
                       <input type="number" name="cantidad" min="1" max="180" class="Texto12New" size="12" style="width:80px;height:25px;" autocomplete="off" title="días de recargo" value="'.$cantidad.'"> 
                      </td>
                     </tr>
                    </table>
                    <table width="500">
                     <tr class="BarraDocumentos" style="height:50px;Important!"> 
                      <td width="480" align="center">
                       <input type="submit" value="ACEPTAR" class="button blue">
                       <a href="liquidados.php?opcion=editarliquidacion&terid='.$terid.'&codperiodo='.$codperiodo.'">
                        <input type="button" value="CANCELAR" class="button red">
                       </a>
                       </form>
                      </td>
                     </tr>
                    </table>';
        echo $cont;
        exit();
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: guardarrecargonoc
    // Creación: 02/10/2024		última modificación: 08/11/2024
    // Creador: Luis Flórez		modificado por: Luis Flórez
    // Descripción: Opción que guarda el recargo nocturno y actualiza la liquidación
    // Última modificación: Adaptación para todos los tipos de recargo
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "guardarrecargonoc")
    {
        $terid = $_POST['terid'];
        $periodoid = $_POST['periodoid'];
        $idliquidados = $_POST['idliquidados'];
        $codperiodo = $_POST['codperiodo'];
        $conceptoid = $_POST["conceptoid"];
        $cantidad = $_POST["cantidad"];

        if((strlen($conceptoid == 0)) || (strlen($cantidad) == 0))
            $clase->Aviso(3,"Debe incluir concepto y cantidad");
        else
        {
            // obtengo el salario base
            $vsql = "SELECT ultsueldo FROM histcontrato WHERE terid = ".$terid." ORDER BY id DESC LIMIT 0,1";
            $basico = $clase->SeleccionarUno($vsql);
    
            if(($basico == "") || ($basico == 0))
                $basico = $clase->BDLockup($terid,"terceros","terid","basico");
    
            // Obtengo la formula del recargo
            $vsql = "SELECT formula FROM conceptosnomina WHERE conceptoid = ".$conceptoid;
            $formularecargo = $clase->SeleccionarUno($vsql);
    
            // Calculo el recargo
            eval("\$recargo = $formularecargo;");
            $recargo = round($recargo,0);
    
            // incremento el id
            $vsql = "SELECT max(detalleid) FROM detalleliquidacion";
            $numreg = $clase->SeleccionarUno($vsql);
            
            // almaceno el recargo
            $vsql = "INSERT INTO detalleliquidacion VALUES ($numreg+1,".$terid.",".$conceptoid.",".$periodoid.",".$recargo.",0,".$cantidad.",$basico)";
            $clase->EjecutarSQL($vsql);
    
            // ---------------------------------------------------------------------------------------------------------- //
            // Recalculo el subsidio de transporte siempre y cuando el básico no exceda de dos salarios mínimos
    
            // Obtengo el salario mínimo legal vigente
            $smlv = $_SESSION['N_SALMIN2020'];
    
            // Obtengo el cargo del empleado
            $vsqldatos = "SELECT cargoid FROM terceros WHERE terid = ".$terid;
            $cargoid = $clase->SeleccionarUno($vsqldatos);
            $vsqldatos = "";
    
            // Obtengo el control del cálculo de subsidio de transporte
            $aplicatransporte = $clase->BDLockup($cargoid,'cargos','cargoid','aplicatransporte');
    
            // Variable para la validación del auxilio de transporte
            $valsubtrasp = $smlv * 2;
    
            if(($basico <= $valsubtrasp)&&($aplicatransporte=="CHECKED"))
            {
                // Obtengo el ID del registro que se modificará
                $vsql = "SELECT detalleid
                           FROM detalleliquidacion 
                          WHERE conceptoid = 3  
                                AND pernominaid = ".$periodoid."
                                AND terid = ".$terid."";
                $detalleid = $clase->SeleccionarUno($vsql);
    
                // Obtengo la formula del subsidio de transporte
                $auxtrans = $_SESSION['N_AUXTRANS2020'];
                $vsql = "SELECT formula FROM conceptosnomina WHERE conceptoid = 3";
                $formulatransporte = $clase->SeleccionarUno($vsql);
    
                eval("\$subsidiotransporte = $formulatransporte;");
                $subsidiotransporte = round($subsidiotransporte,0);
            }
            else
                $subsidiotransporte = 0;
    
            // ID transporte
            $vsql = "SELECT detalleid AS idtransporte FROM detalleliquidacion WHERE terid = ".$terid." AND pernominaid = ".$periodoid." AND conceptoid = 3";
            $idtransporte = $clase->SeleccionarUno($vsql);
    
            // Grabo el subsidio de transporte
            if($idtransporte!="")
                $vsql = "UPDATE detalleliquidacion SET 
                                devengados = ".$subsidiotransporte.",
                                valor = ".$diastrab."
                          WHERE detalleid = ".$idtransporte."";
            else
            {
                $vsql = "SELECT max(detalleid) FROM detalleliquidacion";
                $numreg = $clase->SeleccionarUno($vsql);
    
                $vsql = "INSERT INTO detalleliquidacion VALUES ($numreg+1,".$terid.",3,".$periodoid.",".$subsidiotransporte.",0,".$diastrab.",$auxtrans)";
            }
            $clase->EjecutarSQL($vsql);
    
            // sueldo
            $vsql = "SELECT SUM(IF(conceptoid = 1,devengados,0)) 
                       FROM detalleliquidacion
                      WHERE terid = ".$terid." 
                            AND pernominaid = ".$periodoid;
            $sueldo = $clase->SeleccionarUno($vsql);
            
            // Obtengo el total devengado por novedades
            $vsql = "SELECT SUM(d.devengados) AS totnovedades 
                       FROM detalleliquidacion d
                            INNER JOIN conceptosnomina c ON (d.conceptoid = c.conceptoid)
                      WHERE d.terid = ".$terid."
                            AND d.pernominaid = ".$periodoid." 
                            AND (c.eslicencia='CHECKED' AND c.tipodc='C')";
            $totnovedades = $clase->SeleccionarUno($vsql);
    
            $vsql = "SELECT IFNULL(SUM(d.devengados),0) totrecargos 
                       FROM detalleliquidacion d
                            INNER JOIN conceptosnomina c ON (d.conceptoid = c.conceptoid)
                      WHERE d.terid = ".$terid."
                            AND d.pernominaid = ".$periodoid."                                                
                            AND (c.recargo = 'CHECKED' AND c.tipodc = 'C')";
            $totrecargos = $clase->SeleccionarUno($vsql);
    
            $sueldodeducciones = $sueldo + $totnovedades + $totrecargos;
    
            // Determino si es extralegal
            $vsqldatos = "SELECT extralegal FROM terceros WHERE terid = ".$terid;
            $extralegal = $clase->SeleccionarUno($vsqldatos);
            $vsqldatos = "";
    
            // Determino la eps
            $vsqldatos = "SELECT epsid FROM terceros WHERE terid = ".$terid;
            $epsid = $clase->SeleccionarUno($vsqldatos);
            $vsqldatos = "";
    
            // Fondo de pensiones
            $vsqldatos = "SELECT pensionesid FROM terceros WHERE terid = ".$terid;
            $pensionesid = $clase->SeleccionarUno($vsqldatos);
            $vsqldatos = "";
            
            if($epsid==NULL)                $epsid=0;
            if($pensionesid==NULL)          $pensionesid=0;
    
            $aplicapension = $clase->BDLockup($cargoid,'cargos','cargoid','aplicapension');     // Obtengo el control del cálculo de pensión
            $aplicasalud = $clase->BDLockup($cargoid,'cargos','cargoid','aplicasalud');         // Obtengo el control del cálculo de salud
    
            if($extralegal=="CHECKED")
            {
                $pension = 0;
                $salud = 0;
            }
            else
            {
                // Recalculo pensión y salud
                if(($pensionesid==5)||($aplicapension!="CHECKED"))
                    $pension = 0;
                else
                {
                    // Obtengo la formula para el descuento por pensión
                    $vsql = "SELECT formula FROM conceptosnomina WHERE conceptoid = 4";
                    $formulapension = $clase->SeleccionarUno($vsql);
    
                    // Calculo la pensión
                    eval("\$pension = $formulapension;");
                    $pension = round($pension,0);
                }
    
                if(($epsid==37)||($aplicasalud!="CHECKED"))
                    $salud = 0;
                else
                {
                    // Obtengo la formula para el descuento de salud
                    $vsql = "SELECT formula FROM conceptosnomina WHERE conceptoid = 5";
                    $formulasalud = $clase->SeleccionarUno($vsql);
                    
                    // Calculo la salud
                    eval("\$salud = $formulasalud;");
                    $salud = round($salud,0);
                }
            }
    
            //  ID pensión
            $vsql = "SELECT detalleid AS idpension FROM detalleliquidacion WHERE terid = ".$terid." AND pernominaid = ".$periodoid." AND conceptoid = 4";
            $idpension = $clase->SeleccionarUno($vsql);
    
            // Grabo la pensión
            if($idpension!="")
                $vsql = "UPDATE detalleliquidacion SET 
                                descuentos = ".$pension.",
                                saldo = ".$sueldodeducciones."
                          WHERE detalleid = ".$idpension."";
            else
            {
                $vsql = "SELECT max(detalleid) FROM detalleliquidacion";
                $numreg = $clase->SeleccionarUno($vsql);
    
                $vsql = "INSERT INTO detalleliquidacion VALUES ($numreg+1,".$terid.",4,".$periodoid.",0,".$pension.",0,$sueldodeducciones)";
            }
            $clase->EjecutarSQL($vsql);
    
            // ID salud
            $vsql = "SELECT detalleid AS idsalud FROM detalleliquidacion WHERE terid = ".$terid." AND pernominaid = ".$periodoid." AND conceptoid = 5";
            $idsalud = $clase->SeleccionarUno($vsql);
    
            // Grabo la salud
            if($idsalud!="")
                $vsql = "UPDATE detalleliquidacion SET 
                                descuentos = ".$salud.",
                                saldo = ".$sueldodeducciones."
                          WHERE detalleid = ".$idsalud."";
            else
            {
                $vsql = "SELECT max(detalleid) FROM detalleliquidacion";
                $numreg = $clase->SeleccionarUno($vsql);
    
                $vsql = "INSERT INTO detalleliquidacion VALUES ($numreg+1,".$terid.",5,".$periodoid.",0,".$salud.",0,$sueldodeducciones)";
            }
            $clase->EjecutarSQL($vsql);
    
            // ----------------------------------------------------------------------------------------------------------- //
            // Aquí depuro la tabla eliminando los registros en cero, es decir lo que no se calculó
            $vsql = "DELETE FROM detalleliquidacion WHERE devengados <= 0 AND descuentos <= 0 AND pernominaid =".$periodoid;
            $clase->EjecutarSQL($vsql);
    
            // ----------------------------------------------------------------------------------------------------------- //
            // actualizo la tabla tmpinfliquidados
    
            // días trabajados
            $vsql = "SELECT SUM(IF(conceptoid IN (1,10,13,46),valor,0))
                       FROM detalleliquidacion
                      WHERE terid = ".$terid." 
                            AND pernominaid = ".$periodoid;
            $diastrabtmp = $clase->SeleccionarUno($vsql);
    
            // sueldo
            $vsql = "SELECT SUM(IF(conceptoid = 1,devengados,0)) 
                       FROM detalleliquidacion
                      WHERE terid = ".$terid." 
                            AND pernominaid = ".$periodoid;
            $sueldotmp = $clase->SeleccionarUno($vsql);
    
            // subsidio de transporte
            $vsql = "SELECT SUM(IF(conceptoid = 3,devengados,0)) 
                       FROM detalleliquidacion
                      WHERE terid = ".$terid." 
                            AND pernominaid = ".$periodoid;
            $subsidiotransportetmp = $clase->SeleccionarUno($vsql);
    
            // pensión
            $vsql = "SELECT SUM(IF(conceptoid = 4,descuentos,0)) 
                       FROM detalleliquidacion
                      WHERE terid = ".$terid." 
                            AND pernominaid = ".$periodoid;
            $pensiontmp = $clase->SeleccionarUno($vsql);
    
            // salud
            $vsql = "SELECT SUM(IF(conceptoid = 5,descuentos,0)) 
                       FROM detalleliquidacion
                      WHERE terid = ".$terid." 
                            AND pernominaid = ".$periodoid;
            $saludtmp = $clase->SeleccionarUno($vsql);
    
            $vsql = "UPDATE tmpinfliquidados SET 
                            diastrab = ".$diastrabtmp.", 
                            sueldo = ".$sueldotmp.",
                            subsidiotransporte = ".$subsidiotransportetmp.",
                            pension = ".$pensiontmp.",
                            salud = ".$saludtmp."
                      WHERE idliquidados = ".$idliquidados;
            $clase->EjecutarSQL($vsql);
    
            // actualizo los totales
            $sueldotmp = $clase->BDLockup($idliquidados,'tmpinfliquidados','idliquidados','sueldo');
            $subsidiotransportetmp = $clase->BDLockup($idliquidados,'tmpinfliquidados','idliquidados','subsidiotransporte');
            $pagovaca = $clase->BDLockup($idliquidados,'tmpinfliquidados','idliquidados','pagovaca');
            $pagoprima = $clase->BDLockup($idliquidados,'tmpinfliquidados','idliquidados','pagoprima');
            $pagocedesantias = $clase->BDLockup($idliquidados,'tmpinfliquidados','idliquidados','pagocedesantias');
            $pagointereses = $clase->BDLockup($idliquidados,'tmpinfliquidados','idliquidados','pagointereses');
            $indemnizacion = $clase->BDLockup($idliquidados,'tmpinfliquidados','idliquidados','indemnizacion');
            
            // lista de quincenas del periodo
            $listaperiodos = generarlistaper($codperiodo);
            
            // otros devengados
            $vsq22 = "SELECT SUM(IF(devengados > 0,devengados,0)) otrosdevengados
                        FROM detalleliquidacion 
                       WHERE terid = ".$terid." 
                             AND pernominaid IN ($listaperiodos)
                             AND conceptoid NOT IN (1,3) LIMIT 0,1";
            $otrosdevengados = $clase->SeleccionarUno($vsq22);
    
            $totaldevengado = $sueldotmp + $subsidiotransportetmp + $pagovaca + $pagoprima + $pagocedesantias + $pagointereses + $indemnizacion + $otrosdevengados;
    
            // otros descuentos
            $vsq23 = "SELECT SUM(IF(descuentos > 0,descuentos,0)) otrosdescuentos
                        FROM detalleliquidacion 
                       WHERE terid = ".$terid." 
                             AND pernominaid IN ($listaperiodos) 
                             AND conceptoid NOT IN (4,5,6,9,43,58) LIMIT 0,1";
            $otrosdescuentos = $clase->SeleccionarUno($vsq23);
            
            // total descuento
            $totaldescuento = $pensiontmp + $saludtmp + $otrosdescuentos;
    
            // neto a pagar
            $netoapagar = $totaldevengado - $totaldescuento;
    
            // grabo los totales
            $vsql = "UPDATE tmpinfliquidados SET 
                            otrosdevengados = ".$otrosdevengados.", 
                            otrosdescuentos = ".$otrosdescuentos.",
                            totaldevengado = ".$totaldevengado.",
                            totaldescuento = ".$totaldescuento.",
                            netoapagar = ".$netoapagar."
                      WHERE idliquidados = ".$idliquidados;
            $clase->EjecutarSQL($vsql);        
    
            // emito el mensaje correspondiente        
            $nombre = $clase->BDLockup($idliquidados,'tmpinfliquidados','idliquidados','nombre');
            $clase->Aviso(1,"Se incluyó exitosamente el recargo a $nombre");
        }

        // Redirecciono el formulario
        header("Location: liquidados.php?opcion=editarliquidacion&terid=$terid&codperiodo=$codperiodo");
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: seleccionarempleado
    // Creación: 21/10/2024		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que pinta la ventana para seleccionar al empleado que se 
    //              incluirá una liquidación
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "seleccionarempleado")
    {
        $codperiodo = $_GET['codperiodo'];

        // Consulta para el combo de empleados
		$vsqlcomboemp = "SELECT terid, CONCAT(dni,' - ',codvende,' - ',primernombre,' ',segundonombre,' ',primerapellido,' ',segundoapellido) 
                           FROM terceros 
                          WHERE (primernombre <> '' AND primerapellido <> '')
                                AND basico > 0
                       ORDER BY primernombre";
        $comboempleados = $clase->CrearComboBuscar("terid",$vsqlcomboemp,"nombres","terid","","S",$params,490);

        // Periodo anterior
        $vsql = "SELECT periodoid FROM periodosnomina WHERE periodoid = (SELECT MAX(periodoid) FROM periodosnomina WHERE calculado ='CHECKED')";
        $periodoid = $clase->SeleccionarUno($vsql);

        // descripción del periodo
        $desperiodo = $clase->BDLockup($codperiodo,'periodos','codperiodo','desperiodo');

        // pinta la ventana
        $cont= '<table width="600">
                 <tr class="CabezoteTabla"> 
                  <td width="50" align="left"> <img src="images/iconos/vistaprevia.png" width="32" height="32" border="0"> </td>
                  <td width="550" align="center"> <label class="Texto12"> <b> Seleccionar empleado <br> <font color="blue"> '.$desperiodo.' </font> </b> </label> </td>
                 </tr>
                </table>
                <form action="calculoliquidados.php?opcion=ventanareprocesarliq" method="POST" target="_blank">
                <input type="hidden" name="periodoid" value="'.$periodoid.'"> 
                <table width="600">
                 <tr class="BarraDocumentos" style="height:60px;Important!"> 
                  <td width="10"> &nbsp; </td>
                  <td width="590" align="left"> <label class="Texto12"> <b> Empleado: </b> </label> &nbsp; '.$comboempleados.' </td>
                 </tr>
                </table>
                <table width="600">
                 <tr class="BarraDocumentos" style="height:50px;Important!"> 
                  <td width="600" align="center">
                   <input type="submit" value="ACEPTAR" class="button blue">
                   <a href="liquidados.php"> <input type="button" value="CANCELAR" class="button red"> </a>
                   </form>
                  </td>
                 </tr>
                </table>';
        echo $cont;
        exit();
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: mostrarpromedios
    // Creación: 31/10/2024		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que pinta la ventana para visualizar las quincenas del promedio 
    //              anual de un empleado
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "mostrarpromedios")
    {
        $terid = $_GET['terid'];
        $codperiodo = $_GET['codperiodo'];
        $fecingreso = $_GET['fecingreso'];
        $fecretiro = $_GET['fecretiro'];

        // inicialización de variables
        $yeartoday = date("Y");
        $yearingerso = intval(substr($fecingreso,0,4));

        if($yearingerso == $yeartoday)
            $perinicial = $clase->SeleccionarUno("SELECT MIN(periodoid) perinicial FROM periodosnomina WHERE YEAR(fechasta) = ".$yeartoday." AND calculado = 'CHECKED' AND ('".$fecingreso."' >= fecdesde AND '".$fecingreso."' <= fechasta)");
        else
            $perinicial = $clase->SeleccionarUno("SELECT MIN(periodoid) perinicial FROM periodosnomina WHERE YEAR(fechasta) = ".$yeartoday." AND calculado = 'CHECKED' AND fecdesde >= '".$fecingreso."'");

        $perfinal = $clase->SeleccionarUno("SELECT MAX(periodoid) perinicial FROM periodosnomina WHERE YEAR(fechasta) = ".$yeartoday." AND calculado = 'CHECKED' AND fechasta <= '".$fecretiro."'");
        $listaperiodos = generarlistaper($codperiodo);
        $nombreempl = $clase->SeleccionarUno("SELECT nombre FROM tmpinfliquidados WHERE codperiodo = '".$codperiodo."' AND terid = ".$terid."");
        $fecini = substr($fecingreso,8,2)."/".substr($fecingreso,5,2)."/".substr($fecingreso,0,4);
        $fecfin = substr($fecretiro,8,2)."/".substr($fecretiro,5,2)."/".substr($fecretiro,0,4);

        // consulta de los periodos
        $vsql = "SELECT pn.periodoid, pn.descripcion, (pt.basico / 2) saldo , 
                        (SELECT IFNULL(SUM(devengados),0) FROM hisdetallenomina WHERE pernominaid =  pn.periodoid AND terid = pt.terid AND conceptoid = 47) recargonoc, 
                        (SELECT SUM(IF(conceptoid = 49,devengados,0)) FROM hisdetallenomina WHERE pernominaid = pn.periodoid AND terid = pt.terid) horaextdiurna, 
                        (SELECT SUM(IF(conceptoid = 50,devengados,0)) FROM hisdetallenomina WHERE pernominaid = pn.periodoid AND terid = pt.terid) horaextnocturna, 
                        (SELECT SUM(IF(conceptoid = 51,devengados,0)) FROM hisdetallenomina WHERE pernominaid = pn.periodoid AND terid = pt.terid) horaextdiurnadom, 
                        (SELECT SUM(IF(conceptoid = 52,devengados,0)) FROM hisdetallenomina WHERE pernominaid = pn.periodoid AND terid = pt.terid) horaextnocturnadomfes, 
                        (SELECT SUM(IF(conceptoid = 53,devengados,0)) FROM hisdetallenomina WHERE pernominaid = pn.periodoid AND terid = pt.terid) domingosyfestivos, 
                        (SELECT SUM(IF(conceptoid = 54,devengados,0)) FROM hisdetallenomina WHERE pernominaid = pn.periodoid AND terid = pt.terid) recargonocdomfes                         
                   FROM periodosnomina pn 
                        INNER JOIN periodoterceros pt ON (pn.periodoid = pt.pernominaid) 
                  WHERE pn.periodoid BETWEEN ".$perinicial." AND ".$perfinal."  
                        AND pn.calculado = 'CHECKED' 
                        AND pt.terid = ".$terid."  
                        AND pt.extralegal <> 'CHECKED' 
                  UNION ALL 
                 SELECT MAX(dl.pernominaid) periodoid, pn.descripcion, (MAX(dl.saldo) / 2) saldo ,
                        (SELECT IFNULL(SUM(devengados),0) FROM detalleliquidacion WHERE pernominaid =  pn.periodoid AND terid = dl.terid AND conceptoid = 47) recargonoc , 
                        (SELECT SUM(IF(conceptoid = 49,devengados,0)) FROM detalleliquidacion WHERE pernominaid = pn.periodoid AND terid = dl.terid) horaextdiurna, 
                        (SELECT SUM(IF(conceptoid = 50,devengados,0)) FROM detalleliquidacion WHERE pernominaid = pn.periodoid AND terid = dl.terid) horaextnocturna, 
                        (SELECT SUM(IF(conceptoid = 51,devengados,0)) FROM detalleliquidacion WHERE pernominaid = pn.periodoid AND terid = dl.terid) horaextdiurnadom, 
                        (SELECT SUM(IF(conceptoid = 52,devengados,0)) FROM detalleliquidacion WHERE pernominaid = pn.periodoid AND terid = dl.terid) horaextnocturnadomfes, 
                        (SELECT SUM(IF(conceptoid = 53,devengados,0)) FROM detalleliquidacion WHERE pernominaid = pn.periodoid AND terid = dl.terid) domingosyfestivos, 
                        (SELECT SUM(IF(conceptoid = 54,devengados,0)) FROM detalleliquidacion WHERE pernominaid = pn.periodoid AND terid = dl.terid) recargonocdomfes                         
                   FROM detalleliquidacion dl
                        INNER JOIN periodosnomina pn ON (dl.pernominaid = pn.`periodoid`)
                  WHERE dl.terid = ".$terid."  
                        AND dl.pernominaid IN ($listaperiodos) 
                        AND dl.conceptoid IN (1,10,11,12,13,23,31,38,40,46) 
               ORDER BY 1";
        
        $cont= '<table width="1600">
                 <tr class="CabezoteTabla"> 
                  <td width="50" align="left"> <img src="images/iconos/especialidades.png" width="32" height="32" border="0"> </td>
                  <td width="1550" align="center"> 
                   <label class="Texto12"> <b> Sueldos para el promedio <br> <font color="blue"> '.$nombreempl.' </font> <br> Ingreso: '.$fecini.' &nbsp;&nbsp; Retiro: '.$fecfin.' </b> </label> 
                  </td>
                 </tr>
                </table>';

        $cont.='<script type="text/javascript" src="lib/sorttable.js"></script>
                <table width="1600" class="sortable">
                 <thead> 
                  <tr class="TituloTabla" style="display:block;padding-top:5px;height:20px;">
                   <td width="12"> &nbsp; </td>
                   <td width="172" align="left"> Periodo </td>
                   <td width="188" align="right"> Sueldo </td>
                   <td width="148" align="right"> Recargo Noc </td>
                   <td width="148" align="right"> Hora ext Di </td>
                   <td width="148" align="right"> Hora ext Noc </td>
                   <td width="148" align="right"> Hora ext Di Dom </td>
                   <td width="148" align="right"> Hora ext No Dom Fes </td>
                   <td width="148" align="right"> Domingos y fest </td>
                   <td width="168" align="right"> Recargo Noc dom fes </td>                   
                   <td width="148" align="right"> Total mes </td>
                   <td width="24"> &nbsp; </td>
                  </tr>
                 </thead>
                 <tbody style="display:block; width:1600px; height:520px; overflow-Y:scroll">';

        // Conexión a la base de datos
        $i = 0;        
        $totyear = 0;
        $cuentames = 0;
        $promedioaux = 0;
        $conex  = $clase->Conectar();
        $result = mysql_query($vsql,$conex);
        while($row = mysql_fetch_array($result))
        {
            $totalmes = 0;

            // valido que no sea Null
            if(($row['periodoid'] != NULL) && ($row['saldo'] != NULL) && ($row['recargonoc'] != NULL) && ($row['horaextdiurna'] != NULL)&& ($row['horaextnocturna'] != NULL)&& ($row['horaextdiurnadom'] != NULL)&& ($row['horaextnocturnadomfes'] != NULL)&& ($row['domingosyfestivos'] != NULL)&& ($row['recargonocdomfes'] != NULL))
            {
                $i++;
                if($i%2 == 0)
                    $cont.='<tr class="TablaDocsPar">';
                else
                    $cont.='<tr class="TablaDocsImPar">';
    
                $totalmes = $row['saldo'] + $row['recargonoc'] + $row['horaextdiurna'] + $row['horaextnocturna'] + $row['horaextdiurnadom'] + $row['horaextnocturnadomfes'] + $row['domingosyfestivos'] + $row['recargonocdomfes'];

                $cont.=' <td width="12"> &nbsp; </td>
                         <td width="250" align="left"> '.$row['descripcion'].' </td>
                         <td width="108" align="right"> '.number_format($row['saldo']).' </td>
                         <td width="153" align="right"> '.number_format($row['recargonoc']).' </td>
                         <td width="153" align="right"> '.number_format($row['horaextdiurna']).' </td>
                         <td width="148" align="right"> '.number_format($row['horaextnocturna']).' </td>
                         <td width="148" align="right"> '.number_format($row['horaextdiurnadom']).' </td>
                         <td width="148" align="right"> '.number_format($row['horaextnocturnadomfes']).' </td>
                         <td width="148" align="right"> '.number_format($row['domingosyfestivos']).' </td>
                         <td width="173" align="right"> '.number_format($row['recargonocdomfes']).' </td>
                         <td width="153" align="right"> '.number_format($totalmes).' </td>
                         <td width="4"> &nbsp; </td>
                        </tr>';
    
                $totyear += $totalmes;
                $cuentames++;
            }
        }

        $cont.=' </tbody>
                </table>';

        // suma de todas las quincenas
        $cont.='<table width="1600">
                 <tr class="TituloTabla"> 
                  <td width="1201" align="right"> &nbsp; </td>
                  <td width="375" align="right"> <font color="WHITE"> <b> Suma: '.number_format($totyear).' </b> </font> </td>
                  <td width="24"> &nbsp; </td>
                 </tr>
                </table>';

        // número de quincenas
        $cont.='<table width="1600">
                 <tr class="TituloTabla"> 
                  <td width="1201" align="right"> &nbsp; </td>
                  <td width="375" align="right"> <font color="WHITE"> <b> Quincenas: '.number_format($cuentames).' </b> </font> </td>
                  <td width="24"> &nbsp; </td>
                 </tr>
                </table>';

        // impresión del promedio
        $promedioaux = ($totyear / $cuentames) * 2;

        $cont.='<table width="1600">
                 <tr class="TituloTabla"> 
                  <td width="12" align="left"> &nbsp; </td>
                  <td width="1189" align="left"> Formula: (suma / quincena) * 2 </td>
                  <td width="375" align="right"> <font color="WHITE"> <b> Promedio: '.number_format($promedioaux).' </b> </font> </td>
                  <td width="24"> &nbsp; </td>
                 </tr>
                </table>';

        echo $cont;
        exit();
    }

    if($opcion == "ventanacorrecionnew")
    {
        $codperiodo = $_GET['codperiodo'];

        $cont = '';
        $servidor = $_SERVER['SERVER_NAME'].":".$_SERVER['SERVER_PORT'];

        // Validación del servidor
        if(($servidor!="dromedicas.sytes.net:9996")&&($servidor!="192.168.14.248:9999"))
            $cont.='<table width="400">
                     <tr class="CabezoteTabla"> 
                      <td align="center"> <b>Servidor incorrecto </b> </td>
                     </tr> 
                     <tr class="CabezoteTabla"> 
                      <td align="center"> 
                       <font color=red> Este servidor est&aacute; inhabilitado para hacer este <br> 
                       proceso, por favor diríjase al servidor </font> <br> 
                       <font color=blue> 192.168.14.248:9999 </font> <br>
                       <font color=red>o al servidor </font> <br> 
                       <font color=blue> dromedicas.sytes.net:9996 </font> <br>
                       <font color=red> para poder ejecutar este proceso </font> <br><br>
                      </td> 
                     </tr>
                     <tr class="TablaDocsPar">
                      <td width="100%" align="center"> 
                       <form name="importa" method="post" action="?opcion=""" id="theform" enctype="multipart/form-data">                        
                        <input type="submit" name="enviar" id="enviarr"  value="aceptar" class="button blue" />
                       </form> 
                      </td>
                     </tr>
                    </table>';
        else
        {
            // nombre del periodo
            $desperiodo = $clase->BDLockup($codperiodo,'periodos','codperiodo','desperiodo');

            // pinto la ventana
            $cont.='<script type="text/javascript" src="lib/jquery-2.1.3.min.js"></script>
                    <script>
                     $(function()
                      {
                        $("#enviarr").on("click",function()
                       {
                        $(this).val("Espere por favor ...")
                        .attr("disabled","disabled");
                        $("#theform").submit();
                       });    
                      });
                    </script>';

            // encabezado
            $cont.='<table width="950">
                     <tr class="CabezoteTabla"> 
                      <td align="center"> <label class="Texto13"> <strong> Importar empleados liquidados <br> <font color="blue">'.strtolower($desperiodo).'</font> </strong> </label> </td> 
                     </tr> 
                    </table>
                    <table width="950">
                     <tr class="TablaDocsPar"> 
                      <td width="100%" align="center"> 
                       <form name="importa" method="post" action="?opcion=corregirliquidacionesnew" id="theform" enctype="multipart/form-data">
                       <input type="hidden" name = "codperiodo" value = "'.$codperiodo.'">
                       <input type="file" name="excel" /><br><br>
                       <input type="submit" name="enviar" id="enviarr"  value="Importar archivo" class="button blue" />
                       <input type="hidden" value="upload" name="action" /> 
                       </form> 
                      </td> 
                     </tr>
                    </table>';
    
            // Título
            $cont.='<table width="950">
                     <tr class="TablaDocsPar"> 
                      <td width="100%" align="center"> 
                       <label class="Texto13"><strong>La hoja de Excel debe tener la siguiente estructura: </strong></label>
                      </td> 
                     </tr>
                    </table>';

            // estructura de la tabla
            $cont.='<table width="950">
                     <tr class="TablaDocsPar"> 
                      <td align="left"> &nbsp; Columna <b>A</b>: Documento </td> 
                      <td align="left"> &nbsp; Columna <b>B</b>: Sueldo  </td> 
                      <td align="left"> &nbsp; Columna <b>C</b>: Transporte </td> 
                     </tr>
                     <tr class="TablaDocsPar"> 
                      <td align="left"> &nbsp; Columna <b>D</b>: Pensi&oacute;n </td> 
                      <td align="left"> &nbsp; Columna <b>E</b>: Saud </td> 
                      <td align="left"> &nbsp; Columna <b>F</b>: D&iacute;as de vacacaciones </td> 
                     </tr>
                     <tr class="TablaDocsPar"> 
                      <td align="left"> &nbsp; Columna <b>G</b>: Pago de vacaciones </td> 
                      <td align="left"> &nbsp; Columna <b>H</b>: D&iacute;as de prima </td> 
                      <td align="left"> &nbsp; Columna <b>I</b>: Pago de prima </td> 
                     </tr>
                     <tr class="TablaDocsPar"> 
                      <td align="left"> &nbsp; Columna <b>J</b>: D&iacute;as cesant&iacute;as </td> 
                      <td align="left"> &nbsp; Columna <b>K</b>: Pago de cesant&iacute;as </td> 
                      <td align="left"> &nbsp; Columna <b>L</b>: Pago intereses </td> 
                     </tr>
                     <tr class="TablaDocsPar"> 
                      <td align="left"> &nbsp; Columna <b>M</b>: Otros devengados </td> 
                      <td align="left"> &nbsp; Columna <b>N</b>: Otros descuentos </td> 
                      <td align="left"> &nbsp; &nbsp; </td> 
                     </tr>
                    </table>';

            // imagen de ejemplo de la hoja de excel
            $cont.='<table width="950">
                     <tr class="TablaDocsPar"> 
                      <td align="center"> 
                       <img src="images/iconos/ejemplocorreccionliqnew.png" width="950" height="260" border="0">
                      </td> 
                     </tr>
                     <tr class="TablaDocsPar"> 
                      <td width="100%" align="center"> 
                       <font color="blue"> Importante: Se debe utilizar un archivo de Excel con extensión .xlsx</font>
                      </td> 
                     </tr>
                    </table>';
        }
        echo $cont;
        exit();        
    }

    if($opcion == "corregirliquidacionesnew")
    {
		set_time_limit(0);
		extract($_POST);
        $codperiodo = $_POST["codperiodo"];
		$archivo = $_FILES['excel']['name'];
		$tipo = $_FILES['excel']['type'];
		$destino = "recursos/xls/bak_".$archivo;

        // Valido que la extensión del archivo sea xlsx
        $extension = pathinfo($destino, PATHINFO_EXTENSION);
        
        if($extension!="xlsx")
        {
            $clase->Aviso(3,"El archivo debe tener extensión .xlsx");
            header("Location: liquidados.php");
        }
        else
        {
            /// Valido si se cargó el archivo o no
            if (!copy($_FILES['excel']['tmp_name'],$destino))
                echo "Error Al Cargar el Archivo";
        
            if (file_exists ("recursos/xls/bak_".$archivo))
            {
                require_once('lib/PHPExcel.php');
                require_once('lib/PHPExcel/Reader/Excel2007.php');
                
                $objReader = new PHPExcel_Reader_Excel2007();
                $objPHPExcel = $objReader->load("recursos/xls/bak_".$archivo);
                $objFecha = new PHPExcel_Shared_Date();
                $objPHPExcel->setActiveSheetIndex(0);
                $conex = $clase->Conectar();
                $recorrer = true;  $i = 1;

                while($recorrer)
                {
                    $_DATOS_EXCEL[$i]['dni'] = $objPHPExcel->getActiveSheet()->getCell('A'.$i)->getCalculatedValue();
                    $_DATOS_EXCEL[$i]['sueldo'] = $objPHPExcel->getActiveSheet()->getCell('B'.$i)->getCalculatedValue();
                    $_DATOS_EXCEL[$i]['subsidiotransporte'] = $objPHPExcel->getActiveSheet()->getCell('C'.$i)->getCalculatedValue();
                    $_DATOS_EXCEL[$i]['pension'] = $objPHPExcel->getActiveSheet()->getCell('D'.$i)->getCalculatedValue();
                    $_DATOS_EXCEL[$i]['salud'] = $objPHPExcel->getActiveSheet()->getCell('E'.$i)->getCalculatedValue();
                    $_DATOS_EXCEL[$i]['diasvacaciones'] = $objPHPExcel->getActiveSheet()->getCell('F'.$i)->getCalculatedValue();
                    $_DATOS_EXCEL[$i]['pagovacaciones'] = $objPHPExcel->getActiveSheet()->getCell('G'.$i)->getCalculatedValue();
                    $_DATOS_EXCEL[$i]['diasprima'] = $objPHPExcel->getActiveSheet()->getCell('H'.$i)->getCalculatedValue();
                    $_DATOS_EXCEL[$i]['pagoprima'] = $objPHPExcel->getActiveSheet()->getCell('I'.$i)->getCalculatedValue();
                    $_DATOS_EXCEL[$i]['diascesantias'] = $objPHPExcel->getActiveSheet()->getCell('J'.$i)->getCalculatedValue();
                    $_DATOS_EXCEL[$i]['pagocesantias'] = $objPHPExcel->getActiveSheet()->getCell('K'.$i)->getCalculatedValue();
                    $_DATOS_EXCEL[$i]['pagointereses'] = $objPHPExcel->getActiveSheet()->getCell('L'.$i)->getCalculatedValue();
                    $_DATOS_EXCEL[$i]['otrosdevengados'] = $objPHPExcel->getActiveSheet()->getCell('M'.$i)->getCalculatedValue();
                    $_DATOS_EXCEL[$i]['otrosdescuentos'] = $objPHPExcel->getActiveSheet()->getCell('N'.$i)->getCalculatedValue();
                
                    if(strlen($_DATOS_EXCEL[$i]['dni']) == 0)
                        $recorrer = false;
                    
                    $i++;
                } /// Fin del While
            }
            else
            { echo "Necesitas primero importar el archivo";  }  /// Si NO Cargó el archivo

            // ------------------------------------------------------------------------------------------------------------------------------- //
            // proceso para respaldar las tablas antes de la corrección
            $listaperiodos = generarlistaper($codperiodo);

            // elimino las tablas de respaldo            
            $clase->EjecutarSQL("DROP TABLE IF EXISTS respaldoliquidacion");
            $clase->EjecutarSQL("DROP TABLE IF EXISTS respaldodetliq");

            // respaldo de la tabla liquidacion
            $clase->EjecutarSQL("CREATE TABLE respaldoliquidacion AS (SELECT * FROM liquidacion WHERE periodonomina = '".$codperiodo."')");

            // respaldo de la tabla detalleliquidacion
            $clase->EjecutarSQL("CREATE TABLE respaldodetliq AS (SELECT * FROM detalleliquidacion WHERE pernominaid IN ($listaperiodos))");
            // ------------------------------------------------------------------------------------------------------------------------------- //            
            // inicialización de variables
            $sueldonuevo = 0;                $sualdoanterior = 0;                    $sueldo = 0;                    $transportenuevo = 0;
            $trasporteanterior = 0;          $subsidiotransporte = 0;                $pensionnueva = 0;              $pensionanterior = 0;
            $pension = 0;                    $totnovedades = 0;                      $totrecargos = 0;               $sueldodeducciones = 0;
            $nuevacantidad = 0;              $cantidadanterior = 0;                  $diasvacaciones = 0;            $nuevopago = 0;
            $pagoanterior = 0;               $pagovacaciones = 0;                    $nuevocantidad = 0;             $diasprima = 0;
            $nuevopagointereses = 0;         $pagointeresesanterior = 0;             $pagointereses = 0;             $newotrosdevengados = 0;
            $otrosdevengadosante = 0;        $otrosdevengados = 0;                   $newotrosdescuentos = 0;        $otrosdescuentosante = 0;
            $otrosdescuentos = 0;            $sueldoact = 0;                         $subsidiotransporteact = 0;     $pagovacaact = 0;
            $pagoprimaact = 0;               $pagocedesantiasact = 0;                $pagointeresesact = 0;          $indemnizacionact = 0;
            $totaldevengado = 0;             $pensionact = 0;                        $saludact = 0;                  $totaldescuento = 0;
            $otrosdescuentosact = 0;         $netoapagar = 0;
            // ------------------------------------------------------------------------------------------------------------------------------- //            

            for($j=1; $j < $i; $j++)
            {
                $dni = $_DATOS_EXCEL[$j]['dni'];

                // valido que el empleado exista en las liquidaciones procesadas
                $terid = $clase->SeleccionarUno("SELECT terid FROM tmpinfliquidados WHERE codperiodo = '".$codperiodo."' AND dni = '".$dni."'");
                $idliquidados = $clase->SeleccionarUno("SELECT idliquidados FROM tmpinfliquidados WHERE codperiodo = '".$codperiodo."' AND terid = ".$terid."");

                if($terid != "")
                {
                    // valido el sueldo
                    $sueldo = round($_DATOS_EXCEL[$j]['sueldo'],0);

                    if($sueldo != 0)
                    {
                        // obtengo el periodo
                        $periodoid = $clase->SeleccionarUno("SELECT MAX(pernominaid) periodoid FROM detalleliquidacion WHERE pernominaid IN ($listaperiodos) AND terid = ".$terid."");

                        // obtengo el básico
                        $basico = $clase->SeleccionarUno("SELECT MAX(ultsueldo) ultsueldo FROM histcontrato WHERE terid = ".$terid."");

                        if($basico == "")
                            $basico = $clase->BDLockup($terid,'terceros','terid','basico');

                        // días trabajados
                        $diastrab = (30 / $basico) * $sueldo;
                        $diastrab = round($diastrab,0);

                        // inicializo
                        $numregistro = 0;
                        $detalleid = 0;
                        $sualdoanterior = 0;
                        $sueldonuevo = 0;

                        // determino si ya existe
                        $numregistro = $clase->SeleccionarUno("SELECT COUNT(*) AS numregistro FROM detalleliquidacion WHERE terid = ".$terid." AND pernominaid = ".$periodoid." AND conceptoid = 1");

                        if($numregistro > 0)
                        {
                            // calculo el nuevo sueldo
                            $sualdoanterior = $clase->SeleccionarUno("SELECT devengados FROM detalleliquidacion WHERE terid = ".$terid." AND pernominaid = ".$periodoid." AND conceptoid = 1");

                            if($sueldo < 0)
                                $sueldonuevo = $sualdoanterior + abs($sueldo);
                            else
                                $sueldonuevo = $sualdoanterior - $sueldo;

                            // determino su id
                            $detalleid = $clase->SeleccionarUno("SELECT detalleid FROM detalleliquidacion WHERE terid = ".$terid." AND pernominaid = ".$periodoid." AND conceptoid = 1");

                            $vsql4 = "UPDATE detalleliquidacion SET 
                                             devengados = ".$sueldonuevo.",
                                             valor = ".$diastrab.", 
                                             saldo = ".$basico."
                                       WHERE detalleid = ".$detalleid;
                        }
                        else
                        {
                            $sueldonuevo = abs($sueldo);

                            $vsql4 = "INSERT INTO detalleliquidacion (terid,conceptoid,pernominaid,devengados,descuentos,valor,saldo) 
                                            VALUE (".$terid.",1,".$periodoid.",".$sueldonuevo.",0,".$diastrab.",".$basico.")";
                        }

                        // guardo en la tabla detalleliquidacion
                        $clase->EjecutarSQL($vsql4);

                        // guardo en la tabla tmpinfliquidados
                        $clase->EjecutarSQL("UPDATE tmpinfliquidados SET basico = ".$basico.", diastrab = ".$diastrab.", sueldo = ".$sueldonuevo." WHERE idliquidados = ".$idliquidados."");
                    }

                    // subsidio de transporte
                    $subsidiotransporte = round($_DATOS_EXCEL[$j]['subsidiotransporte'],0);

                    if($subsidiotransporte != 0)
                    {
                        // obtengo el periodo
                        $periodoid = $clase->SeleccionarUno("SELECT MAX(pernominaid) periodoid FROM detalleliquidacion WHERE pernominaid IN ($listaperiodos) AND terid = ".$terid."");
                        
                        $valsubtransporte = $_SESSION['N_AUXTRANS2020'];

                        // días trabajados
                        $diastrab = (30 / $valsubtransporte) * $subsidiotransporte;
                        $diastrab = round($diastrab,0);

                        // inicializo
                        $numregistro = 0;
                        $detalleid = 0;
                        $trasporteanterior = 0;
                        $transportenuevo = 0;
                        
                        // determino si ya existe
                        $numregistro = $clase->SeleccionarUno("SELECT COUNT(*) AS numregistro FROM detalleliquidacion WHERE terid = ".$terid." AND pernominaid = ".$periodoid." AND conceptoid = 3");

                        if($numregistro > 0)
                        {
                            // calculo el nuevo subsidio de transporte
                            $trasporteanterior = $clase->SeleccionarUno("SELECT devengados FROM detalleliquidacion WHERE terid = ".$terid." AND pernominaid = ".$periodoid." AND conceptoid = 3");
                            
                            if($subsidiotransporte < 0)
                                $transportenuevo = $trasporteanterior + abs($subsidiotransporte);
                            else
                                $transportenuevo = $trasporteanterior - $subsidiotransporte;

                            // determino su id
                            $detalleid = $clase->SeleccionarUno("SELECT detalleid FROM detalleliquidacion WHERE terid = ".$terid." AND pernominaid = ".$periodoid." AND conceptoid = 3");
                
                            $vsql4 = "UPDATE detalleliquidacion SET 
                                             devengados = ".$transportenuevo.",
                                             valor = ".$diastrab.", 
                                             saldo = ".$valsubtransporte."
                                       WHERE detalleid = ".$detalleid;
                        }
                        else
                        {
                            $transportenuevo = abs($subsidiotransporte);

                            $vsql4 = "INSERT INTO detalleliquidacion (terid,conceptoid,pernominaid,devengados,descuentos,valor,saldo) 
                                            VALUE (".$terid.",3,".$periodoid.",".$transportenuevo.",0,".$diastrab.",".$valsubtransporte.")";
                        }

                        // guardo en la tabla detalleliquidacion
                        $clase->EjecutarSQL($vsql4);                        
                        
                        // guardo en la tabla tmpinfliquidados
                        $clase->EjecutarSQL( "UPDATE tmpinfliquidados SET subsidiotransporte = ".$transportenuevo." WHERE idliquidados = ".$idliquidados."");
                    }

                    // pensión 
                    $pension = round($_DATOS_EXCEL[$j]['pension'],0);

                    if($pension != 0)
                    {
                        // obtengo el periodo
                        $periodoid = $clase->SeleccionarUno("SELECT MAX(pernominaid) periodoid FROM detalleliquidacion WHERE pernominaid IN ($listaperiodos) AND terid = ".$terid."");

                        // obtengo el sueldo con deducciones
                        $sueldo = $clase->SeleccionarUno("SELECT basico FROM tmpinfliquidados WHERE idliquidados = ".$idliquidados."");

                        $vsql = "SELECT SUM(d.devengados) AS totnovedades 
                                   FROM detalleliquidacion d
                                        INNER JOIN conceptosnomina c ON (d.conceptoid = c.conceptoid)
                                  WHERE d.terid = ".$terid."
                                        AND d.pernominaid = ".$periodoid." 
                                        AND (c.eslicencia='CHECKED' AND c.tipodc='C') ";
                        $totnovedades = $clase->SeleccionarUno($vsql);
            
                        $vsql = "SELECT IFNULL(SUM(d.devengados),0) AS totrecargos 
                                   FROM detalleliquidacion d
                                        INNER JOIN conceptosnomina c ON (d.conceptoid = c.conceptoid)
                                  WHERE d.terid = ".$terid."
                                        AND d.pernominaid = ".$periodoid."                            
                                        AND (c.recargo = 'CHECKED' AND c.tipodc = 'C')";
                        $totrecargos = $clase->SeleccionarUno($vsql);

                        $sueldodeducciones = $sueldo + $totnovedades + $totrecargos;

                        // determino si ya existe
                        $numregistro = $clase->SeleccionarUno("SELECT COUNT(*) AS numregistro FROM detalleliquidacion WHERE terid = ".$terid." AND pernominaid = ".$periodoid." AND conceptoid = 4");

                        if($numregistro > 0)
                        {
                            // calculo la nueva pensión
                            $pensionanterior = $clase->SeleccionarUno("SELECT descuentos FROM detalleliquidacion WHERE terid = ".$terid." AND pernominaid = ".$periodoid." AND conceptoid = 4");

                            if($pension < 0)
                                $pensionnueva = $pensionanterior + abs($pension);
                            else
                                $pensionnueva = $pensionanterior - $pension;

                            // determino su id
                            $detalleid = $clase->SeleccionarUno("SELECT detalleid FROM detalleliquidacion WHERE terid = ".$terid." AND pernominaid = ".$periodoid." AND conceptoid = 4");

                            $vsql4 = "UPDATE detalleliquidacion SET 
                                             descuentos = ".$pensionnueva.",
                                             saldo = ".$sueldodeducciones."
                                       WHERE detalleid = ".$detalleid;
                        }
                        else
                        {
                            $numreg = $clase->SeleccionarUno("SELECT max(detalleid) FROM detalleliquidacion");
                            $pensionnueva = abs($pension);
                            $vsql4 = "INSERT INTO detalleliquidacion VALUES ($numreg+1,".$terid.",4,".$periodoid.",0,".$pensionnueva.",0,$sueldodeducciones)";
                        }

                        // guardo en la tabla detalleliquidacion
                        $clase->EjecutarSQL($vsql4);
                        
                        // guardo en la tabla tmpinfliquidados
                        $clase->EjecutarSQL("UPDATE tmpinfliquidados SET pension = ".$pensionnueva." WHERE idliquidados = ".$idliquidados."");
                    }

                    // salud 
                    $salud = round($_DATOS_EXCEL[$j]['salud'],0);

                    if($salud != 0)
                    {
                        // obtengo el periodo
                        $periodoid = $clase->SeleccionarUno("SELECT MAX(pernominaid) periodoid FROM detalleliquidacion WHERE pernominaid IN ($listaperiodos) AND terid = ".$terid."");

                        // obtengo el sueldo con deducciones
                        $sueldo = $clase->SeleccionarUno("SELECT basico FROM tmpinfliquidados WHERE idliquidados = ".$idliquidados."");

                        $vsql = "SELECT SUM(d.devengados) AS totnovedades 
                                   FROM detalleliquidacion d
                                        INNER JOIN conceptosnomina c ON (d.conceptoid = c.conceptoid)
                                  WHERE d.terid = ".$terid."
                                        AND d.pernominaid = ".$periodoid." 
                                        AND (c.eslicencia='CHECKED' AND c.tipodc='C') ";
                        $totnovedades = $clase->SeleccionarUno($vsql);
            
                        $vsql = "SELECT IFNULL(SUM(d.devengados),0) AS totrecargos 
                                   FROM detalleliquidacion d
                                        INNER JOIN conceptosnomina c ON (d.conceptoid = c.conceptoid)
                                  WHERE d.terid = ".$terid."
                                        AND d.pernominaid = ".$periodoid."                            
                                        AND (c.recargo = 'CHECKED' AND c.tipodc = 'C')";
                        $totrecargos = $clase->SeleccionarUno($vsql);

                        $sueldodeducciones = $sueldo + $totnovedades + $totrecargos;

                        // determino si ya existe
                        $numregistro = $clase->SeleccionarUno("SELECT COUNT(*) AS numregistro FROM detalleliquidacion WHERE terid = ".$terid." AND pernominaid = ".$periodoid." AND conceptoid = 5");

                        if($numregistro > 0)
                        {
                            // calculo la nueva pensión
                            $saludanterior = $clase->SeleccionarUno("SELECT descuentos FROM detalleliquidacion WHERE terid = ".$terid." AND pernominaid = ".$periodoid." AND conceptoid = 5");

                            if($salud < 0)
                                $saludnueva = $saludanterior + abs($salud);
                            else
                                $saludnueva = $saludanterior - $salud;

                            // determino su id
                            $detalleid = $clase->SeleccionarUno("SELECT detalleid FROM detalleliquidacion WHERE terid = ".$terid." AND pernominaid = ".$periodoid." AND conceptoid = 5");

                            $vsql4 = "UPDATE detalleliquidacion SET 
                                             descuentos = ".$saludnueva.",
                                             saldo = ".$sueldodeducciones." 
                                       WHERE detalleid = ".$detalleid;
                        }
                        else
                        {
                            $numreg = $clase->SeleccionarUno("SELECT max(detalleid) FROM detalleliquidacion");
                            $saludnueva = abs($salud);            
                            $vsql4 = "INSERT INTO detalleliquidacion VALUES ($numreg+1,".$terid.",4,".$periodoid.",0,".$saludnueva.",0,$sueldodeducciones)";
                        }

                        // guardo en la tabla detalleliquidacion
                        $clase->EjecutarSQL($vsql4);
                        
                        // guardo en la tabla tmpinfliquidados
                        $clase->EjecutarSQL("UPDATE tmpinfliquidados SET salud = ".$saludnueva." WHERE idliquidados = ".$idliquidados."");
                    }

                    // ----------------------------------------------------------------------------------------------------------- //
                    // Aquí depuro la tabla eliminando los registros en cero, es decir lo que no se calculó
                    $clase->EjecutarSQL("DELETE FROM detalleliquidacion WHERE devengados <= 0 AND descuentos <= 0 AND pernominaid =".$periodoid."");

                    // días de vacaciones
                    $diasvacaciones = round($_DATOS_EXCEL[$j]['diasvacaciones'],0);

                    if($diasvacaciones != 0)
                    {
                        // determino si ya existe
                        $numregistro = $clase->SeleccionarUno("SELECT COUNT(*) AS numregistro FROM liquidacion WHERE terid = ".$terid." AND periodonomina = '".$codperiodo."' AND tipo = 'vacaciones'");

                        if($numregistro > 0)
                        {
                            $cantidadanterior = $clase->SeleccionarUno("SELECT cantidad FROM liquidacion WHERE terid = ".$terid." AND periodonomina = '".$codperiodo."' AND tipo = 'vacaciones'");

                            if($diasvacaciones < 0)
                                $nuevacantidad = $cantidadanterior + abs($diasvacaciones);
                            else
                                $nuevacantidad = $cantidadanterior - $diasvacaciones;

                            $idliquidacion = $clase->SeleccionarUno("SELECT idliquidacion FROM liquidacion WHERE terid = ".$terid." AND periodonomina = '".$codperiodo."' AND tipo = 'vacaciones'");

                            $vsql4 = "UPDATE idliquidacion SET cantidad = ".$nuevacantidad." WHERE idliquidacion = ".$idliquidacion;
                        }
                        else
                        {
                            $numreg = $clase->SeleccionarUno("SELECT max(detalleid) FROM detalleliquidacion");
                            $nuevacantidad = abs($diasvacaciones);
                            $vsql4 = "INSERT INTO liquidacion VALUE ($numreg+1,".$terid.",'vacaciones',0,".$nuevacantidad.",0,0)";
                        }

                        // guardo en la tabla liquidacion
                        $clase->EjecutarSQL($vsql4);

                        // guardo en la tabla tmpinfliquidados
                        $clase->EjecutarSQL("UPDATE tmpinfliquidados SET diasvaca = ".$nuevacantidad." WHERE idliquidados = ".$idliquidados."");
                    }

                    // pago de vacaciones
                    $pagovacaciones = round($_DATOS_EXCEL[$j]['pagovacaciones'],0);

                    if($pagovacaciones != 0)
                    {
                        // determino si ya existe
                        $numregistro = $clase->SeleccionarUno("SELECT COUNT(*) AS numregistro FROM liquidacion WHERE terid = ".$terid." AND periodonomina = '".$codperiodo."' AND tipo = 'vacaciones'");

                        if($numregistro > 0)
                        {
                            $pagoanterior = $clase->SeleccionarUno("SELECT pago FROM liquidacion WHERE terid = ".$terid." AND periodonomina = '".$codperiodo."' AND tipo = 'vacaciones'");

                            if($pagovacaciones < 0)
                                $nuevopago = $pagoanterior + abs($pagovacaciones);
                            else
                                $nuevopago = $pagoanterior - $pagovacaciones;

                            $idliquidacion = $clase->SeleccionarUno("SELECT idliquidacion FROM liquidacion WHERE terid = ".$terid." AND periodonomina = '".$codperiodo."' AND tipo = 'vacaciones'");

                            $vsql4 = "UPDATE idliquidacion SET pago = ".$nuevopago." WHERE idliquidacion = ".$idliquidacion;
                        }
                        else
                        {
                            $numreg = $clase->SeleccionarUno("SELECT max(detalleid) FROM detalleliquidacion");
                            $nuevopago = abs($pagovacaciones);
                            $vsql4 = "INSERT INTO liquidacion VALUE ($numreg+1,".$terid.",'vacaciones',".$nuevopago.",0,0,0)";
                        }

                        // guardo en la tabla liquidacion
                        $clase->EjecutarSQL($vsql4);

                        // guardo en la tabla tmpinfliquidados
                        $clase->EjecutarSQL("UPDATE tmpinfliquidados SET pagovaca = ".$nuevopago." WHERE idliquidados = ".$idliquidados."");
                    }

                    // días de prima
                    $diasprima = round($_DATOS_EXCEL[$j]['diasprima'],0);

                    if($diasprima != 0)
                    {
                        // determino si ya existe
                        $numregistro = $clase->SeleccionarUno("SELECT COUNT(*) AS numregistro FROM liquidacion WHERE terid = ".$terid." AND periodonomina = '".$codperiodo."' AND tipo = 'primas'");

                        if($numregistro > 0)
                        {
                            $cantidadanterior = $clase->SeleccionarUno("SELECT cantidad FROM liquidacion WHERE terid = ".$terid." AND periodonomina = '".$codperiodo."' AND tipo = 'primas'");

                            if($diasprima < 0)
                                $nuevocantidad = $cantidadanterior + abs($diasprima);
                            else
                                $nuevocantidad = $cantidadanterior - $diasprima;

                            $idliquidacion = $clase->SeleccionarUno("SELECT idliquidacion FROM liquidacion WHERE terid = ".$terid." AND periodonomina = '".$codperiodo."' AND tipo = 'primas'");

                            $vsql4 = "UPDATE idliquidacion SET cantidad = ".$nuevocantidad." WHERE idliquidacion = ".$idliquidacion;
                        }
                        else
                        {
                            $numreg = $clase->SeleccionarUno("SELECT max(detalleid) FROM detalleliquidacion");
                            $nuevocantidad = abs($diasprima);
                            $vsql4 = "INSERT INTO liquidacion VALUE ($numreg+1,".$terid.",'primas',0,".$nuevocantidad.",0,0)";
                        }

                        // guardo en la tabla detalleliquidacion
                        $clase->EjecutarSQL($vsql4);

                        // guardo en la tabla tmpinfliquidados
                        $clase->EjecutarSQL("UPDATE tmpinfliquidados SET diasprima = ".$nuevocantidad." WHERE idliquidados = ".$idliquidados."");
                    }

                    // pago de prima
                    $pagoprima = round($_DATOS_EXCEL[$j]['pagoprima'],0);

                    if($pagoprima != 0)
                    {
                        // determino si ya existe
                        $numregistro = $clase->SeleccionarUno("SELECT COUNT(*) AS numregistro FROM liquidacion WHERE terid = ".$terid." AND periodonomina = '".$codperiodo."' AND tipo = 'primas'");

                        if($numregistro > 0)
                        {
                            $pagoanterior = $clase->SeleccionarUno("SELECT pago FROM liquidacion WHERE terid = ".$terid." AND periodonomina = '".$codperiodo."' AND tipo = 'primas'");

                            if($pagoprima < 0)
                                $nuevopago = $pagoanterior + abs($pagoprima);
                            else
                                $nuevopago = $pagoanterior - $pagoprima;

                            $idliquidacion = $clase->SeleccionarUno("SELECT idliquidacion FROM liquidacion WHERE terid = ".$terid." AND periodonomina = '".$codperiodo."' AND tipo = 'primas'");

                            $vsql4 = "UPDATE idliquidacion SET pago = ".$nuevopago." WHERE idliquidacion = ".$idliquidacion;
                        }
                        else
                        {
                            $numreg = $clase->SeleccionarUno("SELECT max(detalleid) FROM detalleliquidacion");
                            $nuevopago = abs($pagoprima);
                            $vsql4 = "INSERT INTO liquidacion VALUE ($numreg+1,".$terid.",'primas',".$nuevopago.",0,0,0)";
                        }

                        // guardo en la tabla detalleliquidacion
                        $clase->EjecutarSQL($vsql4);

                        // guardo en la tabla tmpinfliquidados
                        $clase->EjecutarSQL("UPDATE tmpinfliquidados SET pagoprima = ".$nuevopago." WHERE idliquidados = ".$idliquidados."");                        
                    }

                    // días de cesantías
                    $diascesantias = round($_DATOS_EXCEL[$j]['diascesantias'],0);

                    if($diascesantias != 0)
                    {
                        // determino si ya existe
                        $numregistro = $clase->SeleccionarUno("SELECT COUNT(*) AS numregistro FROM liquidacion WHERE terid = ".$terid." AND periodonomina = '".$codperiodo."' AND tipo = 'cesantias'");

                        if($numregistro > 0)
                        {
                            $cantidadanterior = $clase->SeleccionarUno("SELECT cantidad FROM liquidacion WHERE terid = ".$terid." AND periodonomina = '".$codperiodo."' AND tipo = 'cesantias'");

                            if($diascesantias < 0)
                                $nuevacantidad = $cantidadanterior + abs($diascesantias);
                            else
                                $nuevacantidad = $cantidadanterior - $diascesantias;

                            $idliquidacion = $clase->SeleccionarUno("SELECT idliquidacion FROM liquidacion WHERE terid = ".$terid." AND periodonomina = '".$codperiodo."' AND tipo = 'cesantias'");

                            $vsql4 = "UPDATE idliquidacion SET cantidad = ".$nuevacantidad." WHERE idliquidacion = ".$idliquidacion;
                        }
                        else
                        {
                            $numreg = $clase->SeleccionarUno("SELECT max(detalleid) FROM detalleliquidacion");
                            $nuevacantidad = abs($diascesantias);
                            $vsql4 = "INSERT INTO liquidacion VALUE ($numreg+1,".$terid.",'cesantias',0,".$nuevacantidad.",0,0)";
                        }

                        // guardo en la tabla liquidacion
                        $clase->EjecutarSQL($vsql4);

                        // guardo en la tabla tmpinfliquidados
                        $clase->EjecutarSQL("UPDATE tmpinfliquidados SET diasdecesantias = ".$nuevacantidad." WHERE idliquidados = ".$idliquidados."");
                    }

                    // pago de cesantías
                    $pagocesantias = round($_DATOS_EXCEL[$j]['pagocesantias'],0);

                    if($pagocesantias != 0)
                    {
                        // determino si ya existe
                        $numregistro = $clase->SeleccionarUno("SELECT COUNT(*) AS numregistro FROM liquidacion WHERE terid = ".$terid." AND periodonomina = '".$codperiodo."' AND tipo = 'cesantias'");

                        if($numregistro > 0)
                        {
                            $pagoanterior = $clase->SeleccionarUno("SELECT pago FROM liquidacion WHERE terid = ".$terid." AND periodonomina = '".$codperiodo."' AND tipo = 'cesantias'");

                            if($pagocesantias < 0)
                                $nuevopago = $pagoanterior + abs($pagocesantias);
                            else
                                $nuevopago = $pagoanterior - $pagocesantias;

                            $idliquidacion = $clase->SeleccionarUno("SELECT idliquidacion FROM liquidacion WHERE terid = ".$terid." AND periodonomina = '".$codperiodo."' AND tipo = 'cesantias'");

                            $vsql4 = "UPDATE idliquidacion SET pago = ".$nuevopago." WHERE idliquidacion = ".$idliquidacion;
                        }
                        else
                        {
                            $numreg = $clase->SeleccionarUno("SELECT max(detalleid) FROM detalleliquidacion");
                            $nuevopago = abs($pagocesantias);
                            $vsql4 = "INSERT INTO liquidacion VALUE ($numreg+1,".$terid.",'cesantias',".$nuevopago.",0,0,0)";
                        }

                        // guardo en la tabla liquidacion
                        $clase->EjecutarSQL($vsql4);

                        // guardo en la tabla tmpinfliquidados
                        $clase->EjecutarSQL("UPDATE tmpinfliquidados SET pagocedesantias = ".$nuevopago." WHERE idliquidados = ".$idliquidados."");
                    }

                    // pago de intereses de cesantías
                    $pagointereses = round($_DATOS_EXCEL[$j]['pagointereses'],0);

                    if($pagointereses != 0)
                    {
                        // determino si ya existe
                        $numregistro = $clase->SeleccionarUno("SELECT COUNT(*) AS numregistro FROM liquidacion WHERE terid = ".$terid." AND periodonomina = '".$codperiodo."' AND tipo = 'cesantias'");

                        if($numregistro > 0)
                        {
                            $pagointeresesanterior = $clase->SeleccionarUno("SELECT pagointereses FROM liquidacion WHERE terid = ".$terid." AND periodonomina = '".$codperiodo."' AND tipo = 'cesantias'");

                            if($pagointereses < 0)
                                $nuevopagointereses = $pagointeresesanterior + abs($pagointereses);
                            else
                                $nuevopagointereses = $pagointeresesanterior - $pagointereses;

                            $idliquidacion = $clase->SeleccionarUno("SELECT idliquidacion FROM liquidacion WHERE terid = ".$terid." AND periodonomina = '".$codperiodo."' AND tipo = 'cesantias'");

                            $vsql4 = "UPDATE idliquidacion SET pagointereses = ".$nuevopagointereses." WHERE idliquidacion = ".$idliquidacion;
                        }
                        else
                        {
                            $numreg = $clase->SeleccionarUno("SELECT max(detalleid) FROM detalleliquidacion");
                            $nuevopagointereses = abs($pagointereses);
                            $vsql4 = "INSERT INTO liquidacion VALUE ($numreg+1,".$terid.",'cesantias',0,0,0,".$nuevopagointereses.")";
                        }

                        // guardo en la tabla liquidacion
                        $clase->EjecutarSQL($vsql4);

                        // guardo en la tabla tmpinfliquidados
                        $clase->EjecutarSQL("UPDATE tmpinfliquidados SET pagointereses = ".$nuevopagointereses." WHERE idliquidados = ".$idliquidados."");
                    }

                    // otros devengados
                    $otrosdevengados = round($_DATOS_EXCEL[$j]['otrosdevengados'],0);

                    if($otrosdevengados != 0)
                    {
                        // obtengo el valor actual
                        $otrosdevengadosante = $clase->BDLockup($idliquidados,'tmpinfliquidados','idliquidados','otrosdevengados');

                        // calculo el nuevo valor
                        if($otrosdevengados < 0)
                            $newotrosdevengados = $otrosdevengadosante + abs($otrosdevengados);
                        else
                            $newotrosdevengados = $otrosdevengadosante - $otrosdevengados;

                        // guardo en la tabla tmpinfliquidados
                        $clase->EjecutarSQL("UPDATE tmpinfliquidados SET otrosdevengados = ".$newotrosdevengados." WHERE idliquidados = ".$idliquidados."");
                    }

                    // otros descuentos
                    $otrosdescuentos = round($_DATOS_EXCEL[$j]['otrosdescuentos'],0);

                    if($otrosdescuentos != 0)
                    {
                        // obtengo el valor actual
                        $otrosdescuentosante = $clase->BDLockup($idliquidados,'tmpinfliquidados','idliquidados','otrosdescuentos');

                        // calculo el nuevo valor
                        if($otrosdescuentos < 0)
                            $newotrosdescuentos = $otrosdescuentosante + abs($otrosdescuentos);
                        else
                            $newotrosdescuentos = $otrosdescuentosante - $otrosdescuentos;

                        // guardo en la tabla tmpinfliquidados
                        $clase->EjecutarSQL("UPDATE tmpinfliquidados SET otrosdescuentos = ".$newotrosdescuentos." WHERE idliquidados = ".$idliquidados."");
                    }
                    
                    // actualizo los totales
                    $sueldoact = $clase->BDLockup($idliquidados,'tmpinfliquidados','idliquidados','sueldo');
                    $subsidiotransporteact = $clase->BDLockup($idliquidados,'tmpinfliquidados','idliquidados','subsidiotransporte');
                    $pagovacaact = $clase->BDLockup($idliquidados,'tmpinfliquidados','idliquidados','pagovaca');
                    $pagoprimaact = $clase->BDLockup($idliquidados,'tmpinfliquidados','idliquidados','pagoprima');
                    $pagocedesantiasact = $clase->BDLockup($idliquidados,'tmpinfliquidados','idliquidados','pagocedesantias');
                    $pagointeresesact = $clase->BDLockup($idliquidados,'tmpinfliquidados','idliquidados','pagointereses');
                    $indemnizacionact = $clase->BDLockup($idliquidados,'tmpinfliquidados','idliquidados','indemnizacion');

                    // otros devengados
                    $vsq22 = "SELECT SUM(IF(devengados>0,devengados,0)) otrosdevengados
                                FROM detalleliquidacion 
                               WHERE terid = ".$terid." 
                                     AND pernominaid IN ($listaperiodos)
                                     AND conceptoid NOT IN (1,3)";
                    $otrosdevengadosact = $clase->SeleccionarUno($vsq22);

                    $totaldevengado = $sueldoact + $subsidiotransporteact + $pagovacaact + $pagoprimaact + $pagocedesantiasact + $pagointeresesact + $indemnizacionact + $otrosdevengadosact;

                    $pensionact = $clase->BDLockup($idliquidados,'tmpinfliquidados','idliquidados','pension');
                    $saludact = $clase->BDLockup($idliquidados,'tmpinfliquidados','idliquidados','salud');
        
                    // otros descuentos
                    $vsq23 = "SELECT SUM(IF(descuentos>0,descuentos,0)) otrosdescuentos
                                FROM detalleliquidacion 
                               WHERE terid = ".$terid." 
                                     AND pernominaid IN ($listaperiodos) 
                                     AND conceptoid NOT IN (4,5,6,9,43,58)";
                    $otrosdescuentosact = $clase->SeleccionarUno($vsq23);
                    
                    // total descuento
                    $totaldescuento = $pensionact + $saludact + $otrosdescuentosact;

                    // neto a pagar
                    $netoapagar = $totaldevengado - $totaldescuento;

                    // grabo los totales
                    $vsql = "UPDATE tmpinfliquidados SET 
                                    totaldevengado = ".$totaldevengado.",
                                    totaldescuento = ".$totaldescuento.",
                                    netoapagar = ".$netoapagar."
                              WHERE idliquidados = ".$idliquidados;
                    $clase->EjecutarSQL($vsql);
                }
            }

            // Elimino el Archivo
            unlink($destino);
    
            // Emito el mensaje correspondiente
            $clase->Aviso(1,"Se corrigieron satisfactoriamente las liquidaciones del periodo $desperiodo");

            // Redirecciona el formulario
            header("Location: liquidados.php");            
        }
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: sincronizarliq
    // Creación: 28/04/2025		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción para sincronizar la información de la tabla temporal de 
    //              liquidaciones con la tabla liquidación
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "sincronizarliq")
    {
        $codperiodo = $_GET['codperiodo'];

        // corrijo las vacaciones
        $vsql71 = "UPDATE liquidacion SET liquidacion.pago = (SELECT pagovaca 
                                                                FROM tmpinfliquidados 
                                                               WHERE tmpinfliquidados.terid = liquidacion.`terid` 
                                                                     AND codperiodo = '".$codperiodo."') 
                    WHERE liquidacion.tipo = 'vacaciones' AND liquidacion.`periodonomina` = '".$codperiodo."'";

        // guardo en la tabla liquidacion
        $clase->EjecutarSQL($vsql71);

        // corrijo las primas
        $vsql71 = "UPDATE liquidacion SET liquidacion.pago = (SELECT pagoprima 
                                                                FROM tmpinfliquidados 
                                                               WHERE liquidacion.terid = tmpinfliquidados.`terid` 
                                                                     AND codperiodo = '".$codperiodo."') 
                    WHERE liquidacion.tipo = 'primas' AND liquidacion.`periodonomina` = '".$codperiodo."'";

        // guardo en la tabla liquidacion
        $clase->EjecutarSQL($vsql71);

        // corrijo el pago de cesantías
        $vsql71 = "UPDATE liquidacion SET liquidacion.pago = (SELECT pagocedesantias 
                                                                FROM tmpinfliquidados 
                                                               WHERE liquidacion.terid = tmpinfliquidados.`terid` 
                                                                     AND codperiodo = '".$codperiodo."') 
                    WHERE liquidacion.tipo = 'cesantias' AND liquidacion.`periodonomina` = '".$codperiodo."'";

        // guardo en la tabla liquidacion
        $clase->EjecutarSQL($vsql71);

        // corrijo los intereses de cesantías
        $vsql71 = "UPDATE liquidacion SET liquidacion.pagointereses = (SELECT pagointereses 
                                                                         FROM tmpinfliquidados 
                                                                        WHERE liquidacion.terid = tmpinfliquidados.`terid` 
                                                                              AND codperiodo = '".$codperiodo."') 
                    WHERE liquidacion.tipo = 'cesantias' AND liquidacion.`periodonomina` = '".$codperiodo."'";

        // guardo en la tabla liquidacion
        $clase->EjecutarSQL($vsql71);

        // Redirecciona el formulario
        header("Location: liquidados.php");
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: actualizardetalleliq
    // Creación: 06/10/2025		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que actualiza los detalles de la liquidación junto con los 
    //              totales
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "actualizardetalleliq")
    {
        $idliquidados = $_POST['idliquidados'];
        $terid = $_POST['terid'];
        $codperiodo = $_POST['codperiodo'];

        // lista de quincenas del periodo
        $listaperiodos = generarlistaper($codperiodo);

        // Consulta con los demás conceptos del empleado en el periodo
        $vsql = "SELECT c.nomconcepto, d.devengados, d.descuentos, c.tipodc, d.conceptoid, d.detalleid   
                   FROM detalleliquidacion d
                        INNER JOIN conceptosnomina c ON (d.conceptoid = c.conceptoid)
                  WHERE d.pernominaid IN ($listaperiodos)
                        AND d.terid = ".$terid."
                        AND d.conceptoid NOT IN (1,3,4,5)
               ORDER BY c.tipodc, c.codconcepto";

        // Conexión a la base de datos
        $conex  = $clase->Conectar();
        $result = mysql_query($vsql,$conex);
        while($row = mysql_fetch_array($result)) 
        {
            $tipodc = $row['tipodc'];

            // actualizo los devengados
            if($row['tipodc'] == "C")
            {
                $devengados = $row['devengados'];
                $newmontodevengado = $_POST['pedir-'.$row['detalleid']];

                if($devengados != $newmontodevengado)
                {
                    $detalleid = $row['detalleid'];
                    $clase->EjecutarSQL("UPDATE detalleliquidacion SET devengados = ".$newmontodevengado." WHERE detalleid = ".$detalleid."");
                }
            }

            // actualizo los descuentos
            if($row['tipodc'] == "D")
            {
                $descuentos = $row['descuentos'];
                $newmontodescuentos = $_POST['pedir-'.$row['detalleid']];

                if($descuentos != $newmontodescuentos)
                {
                    $detalleid = $row['detalleid'];
                    $clase->EjecutarSQL("UPDATE detalleliquidacion SET descuentos = ".$newmontodescuentos." WHERE detalleid = ".$detalleid."");
                }
            }
        }

        // actualizo los totales
        $sueldo = $clase->BDLockup($idliquidados,'tmpinfliquidados','idliquidados','sueldo');
        $subsidiotransporte = $clase->BDLockup($idliquidados,'tmpinfliquidados','idliquidados','subsidiotransporte');
        $pagovaca = $clase->BDLockup($idliquidados,'tmpinfliquidados','idliquidados','pagovaca');
        $pagoprima = $clase->BDLockup($idliquidados,'tmpinfliquidados','idliquidados','pagoprima');
        $pagocedesantias = $clase->BDLockup($idliquidados,'tmpinfliquidados','idliquidados','pagocedesantias');
        $pagointereses = $clase->BDLockup($idliquidados,'tmpinfliquidados','idliquidados','pagointereses');
        $indemnizacion = $clase->BDLockup($idliquidados,'tmpinfliquidados','idliquidados','indemnizacion');
        
        // otros devengados
        $vsq22 = "SELECT SUM(IF(devengados>0,devengados,0)) otrosdevengados
                    FROM detalleliquidacion 
                   WHERE terid = ".$terid." 
                         AND pernominaid IN ($listaperiodos)
                         AND conceptoid NOT IN (1,3) LIMIT 0,1";
        $otrosdevengados = $clase->SeleccionarUno($vsq22);

        $totaldevengado = $sueldo + $subsidiotransporte + $pagovaca + $pagoprima + $pagocedesantias + $pagointereses + $indemnizacion + $otrosdevengados;

        $pension = $clase->BDLockup($idliquidados,'tmpinfliquidados','idliquidados','pension');
        $salud = $clase->BDLockup($idliquidados,'tmpinfliquidados','idliquidados','salud');

        // otros descuentos
        $vsq23 = "SELECT SUM(IF(descuentos>0,descuentos,0)) otrosdescuentos
                    FROM detalleliquidacion 
                   WHERE terid = ".$terid." 
                          AND pernominaid IN ($listaperiodos) 
                          AND conceptoid NOT IN (4,5,6,9,43,58) LIMIT 0,1";
        $otrosdescuentos = $clase->SeleccionarUno($vsq23);

        // total descuento
        $totaldescuento = $pension + $salud + $otrosdescuentos;

        // neto a pagar
        $netoapagar = $totaldevengado - $totaldescuento;

        // grabo los totales
        $vsql = "UPDATE tmpinfliquidados SET 
                        otrosdevengados = ".$otrosdevengados.", 
                        otrosdescuentos = ".$otrosdescuentos.",
                        totaldevengado = ".$totaldevengado.",
                        totaldescuento = ".$totaldescuento.",
                        netoapagar = ".$netoapagar."
                  WHERE idliquidados = ".$idliquidados;
        $clase->EjecutarSQL($vsql);

        // emito el mensaje correspondiente
        $clase->Aviso(1,"Cambios realizados satisfactoriamente");

        // redirecciono el formulario
        header("Location: liquidados.php?opcion=editarliquidacion&terid=$terid&codperiodo=$codperiodo");
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Función newcalcularsueldoprom
    // Parámetros de entrada:    $terid         --> id del empelado
    //                           $codperiodo    --> código del periodo
    //                           $fecingreso    --> fecha de ingreso
    //                           $fecretiro     --> Fecha de retiro
    // Valor de retorno:         $promsueldoact --> suedo promedio
    // Descripción: Fusión que calcula el sueldo promedio de un empleado
    ////////////////////////////////////////////////////////////////////////////////////////    
    function newcalcularsueldoprom($terid,$codperiodo,$fecingreso,$fecretiro)
    {
        $clase2 = new Sistema();

        // años
        $yeartoday = date("Y");
        $yearingerso = intval(substr($fecingreso,0,4));

        // periodos
        if($yearingerso == $yeartoday)
            $perinicial = $clase2->SeleccionarUno("SELECT MIN(periodoid) perinicial FROM periodosnomina WHERE YEAR(fechasta) = ".$yeartoday." AND calculado = 'CHECKED' AND ('".$fecingreso."' >= fecdesde AND '".$fecingreso."' <= fechasta)");
        else
            $perinicial = $clase2->SeleccionarUno("SELECT MIN(periodoid) perinicial FROM periodosnomina WHERE YEAR(fechasta) = ".$yeartoday." AND calculado = 'CHECKED' AND fecdesde >= '".$fecingreso."'");

        $perfinal = $clase2->SeleccionarUno("SELECT MAX(periodoid) perinicial FROM periodosnomina WHERE YEAR(fechasta) = ".$yeartoday." AND calculado = 'CHECKED' AND fechasta <= '".$fecretiro."'");
        $listaperiodos = generarlistaper($codperiodo);

        // consulta con todas las quincenas para el promedio anual
        // $vsql = "SELECT pn.periodoid, pn.descripcion, (pt.basico / 2) saldo , 
        //                 (SELECT IFNULL(SUM(devengados),0) 
        //                    FROM hisdetallenomina
        //                   WHERE pernominaid =  pn.periodoid
        //                         AND terid = pt.terid
        //                         AND conceptoid = 47) recargonoc
        //            FROM periodosnomina pn 
        //                 INNER JOIN periodoterceros pt ON (pn.periodoid = pt.pernominaid) 
        //           WHERE pn.periodoid BETWEEN ".$perinicial." AND ".$perfinal."  
        //                 AND pn.calculado = 'CHECKED' 
        //                 AND pt.terid = ".$terid."  
        //                 AND pt.extralegal <> 'CHECKED' 
        //           UNION ALL 
        //          SELECT MAX(dl.pernominaid) periodoid, pn.descripcion, (MAX(dl.saldo) / 2) saldo ,
        //                 (SELECT IFNULL(SUM(devengados),0) 
        //                    FROM detalleliquidacion
        //                   WHERE pernominaid =  pn.periodoid
        //                         AND terid = dl.terid
        //                         AND conceptoid = 47) recargonoc 
        //            FROM detalleliquidacion dl
        //                 INNER JOIN periodosnomina pn ON (dl.pernominaid = pn.`periodoid`)
        //           WHERE dl.terid = ".$terid."  
        //                 AND dl.pernominaid IN ($listaperiodos) 
        //                 AND dl.conceptoid IN (1,10,11,12,13,23,31,38,40,46) 
        //        ORDER BY 1";

        $vsql = "SELECT pn.periodoid, pn.descripcion, (pt.basico / 2) saldo , 
                        (SELECT IFNULL(SUM(devengados),0) FROM hisdetallenomina WHERE pernominaid = pn.periodoid AND terid = pt.terid AND conceptoid = 47) recargonoc, 
                        (SELECT SUM(IF(conceptoid = 49,devengados,0)) FROM hisdetallenomina WHERE pernominaid = pn.periodoid AND terid = pt.terid) horaextdiurna, 
                        (SELECT SUM(IF(conceptoid = 50,devengados,0)) FROM hisdetallenomina WHERE pernominaid = pn.periodoid AND terid = pt.terid) horaextnocturna, 
                        (SELECT SUM(IF(conceptoid = 51,devengados,0)) FROM hisdetallenomina WHERE pernominaid = pn.periodoid AND terid = pt.terid) horaextdiurnadom, 
                        (SELECT SUM(IF(conceptoid = 52,devengados,0)) FROM hisdetallenomina WHERE pernominaid = pn.periodoid AND terid = pt.terid) horaextnocturnadomfes, 
                        (SELECT SUM(IF(conceptoid = 53,devengados,0)) FROM hisdetallenomina WHERE pernominaid = pn.periodoid AND terid = pt.terid) domingosyfestivos, 
                        (SELECT SUM(IF(conceptoid = 54,devengados,0)) FROM hisdetallenomina WHERE pernominaid = pn.periodoid AND terid = pt.terid) recargonocdomfes 
                   FROM periodosnomina pn 
                        INNER JOIN periodoterceros pt ON (pn.periodoid = pt.pernominaid) 
                  WHERE pn.periodoid BETWEEN ".$perinicial." AND ".$perfinal."  
                        AND pn.calculado = 'CHECKED' 
                        AND pt.terid = ".$terid."  
                        AND pt.extralegal <> 'CHECKED' 
                  UNION ALL 
                 SELECT MAX(dl.pernominaid) periodoid, pn.descripcion, (MAX(dl.saldo) / 2) saldo ,
                        (SELECT IFNULL(SUM(devengados),0) FROM detalleliquidacion WHERE pernominaid = pn.periodoid AND terid = dl.terid AND conceptoid = 47) recargonoc, 
                        (SELECT SUM(IF(conceptoid = 49,devengados,0)) FROM detalleliquidacion WHERE pernominaid = pn.periodoid AND terid = dl.terid) horaextdiurna, 
                        (SELECT SUM(IF(conceptoid = 50,devengados,0)) FROM detalleliquidacion WHERE pernominaid = pn.periodoid AND terid = dl.terid) horaextnocturna, 
                        (SELECT SUM(IF(conceptoid = 51,devengados,0)) FROM detalleliquidacion WHERE pernominaid = pn.periodoid AND terid = dl.terid) horaextdiurnadom, 
                        (SELECT SUM(IF(conceptoid = 52,devengados,0)) FROM detalleliquidacion WHERE pernominaid = pn.periodoid AND terid = dl.terid) horaextnocturnadomfes, 
                        (SELECT SUM(IF(conceptoid = 53,devengados,0)) FROM detalleliquidacion WHERE pernominaid = pn.periodoid AND terid = dl.terid) domingosyfestivos, 
                        (SELECT SUM(IF(conceptoid = 54,devengados,0)) FROM detalleliquidacion WHERE pernominaid = pn.periodoid AND terid = dl.terid) recargonocdomfes 
                   FROM detalleliquidacion dl
                        INNER JOIN periodosnomina pn ON (dl.pernominaid = pn.`periodoid`)
                  WHERE dl.terid = ".$terid."  
                        AND dl.pernominaid IN ($listaperiodos) 
                        AND dl.conceptoid IN (1,10,11,12,13,23,31,38,40,46) 
               ORDER BY 1";
                              
        // Conexión a la base de datos
        $totyear = 0;
        $cuentames = 0;
        $promsueldoact = 0;
        $conex  = $clase2->Conectar();
        $result = mysql_query($vsql,$conex);
        while($row = mysql_fetch_array($result))
        {
            $totalmes = 0;

            // valido que no sea Null
            // if(($row['periodoid'] != NULL) && ($row['saldo'] != NULL) && ($row['recargonoc'] != NULL))

            if(($row['periodoid'] != NULL) && ($row['saldo'] != NULL) && ($row['recargonoc'] != NULL) && ($row['horaextdiurna'] != NULL) && ($row['horaextnocturna'] != NULL) && ($row['horaextdiurnadom'] != NULL) && ($row['horaextnocturnadomfes'] != NULL) && ($row['domingosyfestivos'] != NULL) && ($row['recargonocdomfes'] != NULL))
            {
                // $totalmes = $row['saldo'] + $row['recargonoc'];
                $totalmes = $row['saldo'] + $row['recargonoc'] + $row['horaextdiurna'] + $row['horaextnocturna'] + $row['horaextdiurnadom'] + $row['horaextnocturnadomfes'] + $row['domingosyfestivos'] + $row['recargonocdomfes'];
                $totyear += $totalmes;
                $cuentames++;
            }
        }
        
        $promsueldoact = ($totyear / $cuentames) * 2;

        return $promsueldoact;
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Función tienecambiosalario
    // Parámetros de entrada:    $terid --> ID del empelado
    //                           $fecretiro --> Fecha de retiro
    // Valor de retorno:         $tienecambio --> true o false si tiene cambio de salario
    // Descripción: Función que determina si un empleado tiene cambio de salario en los 
    //              últimos tres meses
    ////////////////////////////////////////////////////////////////////////////////////////
    function tienecambiosalario($terid,$fecretiro)
    {
        $clase2 = new Sistema();

        $vsql28 = "SELECT MAX(periodoid) maxper4 FROM periodosnomina WHERE fechasta <= '".$fecretiro."'";
        $maxper4 = $clase2->SeleccionarUno($vsql28);        

        // --------------------------------------------------------------------------------------------------------------------------------------------------- //
        $maxper4++;

        $i = 1;
        $tienecambio = false;
        $recarnonocturno = 0;

        // consulta de los últimos tres meses o seis quincenas laboradas
        $vsql29 = "SELECT pernominaid, basico saldo 
                     FROM periodoterceros 
                    WHERE terid = ".$terid."
                          AND pernominaid <= ".$maxper4."
                    UNION ALL
                   SELECT pernominaid, saldo 
                     FROM detalleliquidacion 
                    WHERE terid = ".$terid." 
                          AND conceptoid IN (1,10,11,12,13,31,38,43) 
                          AND pernominaid <= ".$maxper4."
                 ORDER BY 1 DESC LIMIT 0,6";

        $conex = $clase2->Conectar();
        $result3 = mysql_query($vsql29,$conex);
        while($row3 = mysql_fetch_array($result3))
        {
            $saldo = $row3['saldo'];
            $pernominaid = $row3['pernominaid'];

            // busco recargo nocturno
            $recarnonocturno = buscarrecargonoc($terid,$pernominaid);
            $saldo += $recarnonocturno;

            // determino si existe variación
            if($i == 1)
                $auxcambio = $saldo;
            else
            {
                if($saldo > 0)
                {
                    if($saldo != $auxcambio)
                        $tienecambio = true;
                    
                    $auxcambio = $saldo;
                }
            }
            $i++;
        }

        return $tienecambio;
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Función buscarrecargonoc
    // Parámetros de entrada:    $terid --> ID del empelado
    //                           $fecretiro --> ID del periodo
    // Valor de retorno:         $recargonocper --> Monto del recargo nocturno
    // Descripción: Función que busca los conceptos tipo recargo de un empleado en un 
    //              periodo
    ////////////////////////////////////////////////////////////////////////////////////////
    function buscarrecargonoc($terid,$pernominaid)
    {
        $clase2 = new Sistema();

        // inicialización de variables
        $recargonochis = 0;                 $recargonocliq = 0;                 $recargonocper = 0;
        $vsql11 = "";                       $vsql12 = "";

        // recargo nocturno en el histórico
        // $vsql11 = "SELECT IFNULL(devengados,0) recargonochis FROM hisdetallenomina WHERE terid = ".$terid." AND pernominaid = ".$pernominaid." AND conceptoid = 47";
        // $recargonochis = $clase2->SeleccionarUno($vsql11);

        $recargonochis = $clase2->SeleccionarUno("SELECT SUM(IF(conceptoid IN (47,49,50,51,52,53,54),devengados,0)) recargonochis FROM hisdetallenomina WHERE terid = ".$terid." AND pernominaid = ".$pernominaid."");

        // recargo nocturno en la liquidación 
        // $vsql12 = "SELECT IFNULL(devengados,0) recargonocliq FROM detalleliquidacion WHERE terid = ".$terid." AND pernominaid = ".$pernominaid." AND conceptoid = 47";
        // $recargonocliq = $clase2->SeleccionarUno($vsql12);

        $recargonocliq = $clase2->SeleccionarUno("SELECT SUM(IF(conceptoid IN (47,49,50,51,52,53,54),devengados,0)) recargonocliq FROM detalleliquidacion WHERE terid = ".$terid." AND pernominaid = ".$pernominaid."");

        // Suma de ambos montos
        $recargonocper = $recargonochis + $recargonocliq;

        return $recargonocper;
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Función calsueldopromedio
    // Parámetro de entrada:    $terid --> ID del empleado
    //                          $fecretiro    --> Fecha fin del periodo
    // Valor de retorno:        true o false
    // Descripción: Función que calcula el sueldo promedio de un empleado
    ////////////////////////////////////////////////////////////////////////////////////////
    function calsueldopromedio($terid,$fecingreso)
    {
        $clase2 = new Sistema();

        // inicializaión de variables
        $yearactual2 = date("Y");           $acumsueldo = 0;
        $nroquinceda = 0;                   $cant1 = 0;
        $cant2 = 0;                         $salpromedio = 0;

        // rango de periodos 
        $vsql36 = "SELECT MIN(periodoid) permin3
                     FROM periodosnomina 
                    WHERE fecdesde >= '".$fecingreso."' 
                          AND YEAR(fecdesde) = ".$yearactual2." 
                          AND calculado = 'CHECKED'";
        $permin3 = $clase2->SeleccionarUno($vsql36);
        
        $vsql37 = "SELECT MAX(periodoid) permax3
                     FROM periodosnomina 
                    WHERE fecdesde >= '".$fecingreso."' 
                          AND YEAR(fecdesde) = ".$yearactual2." 
                          AND calculado = 'CHECKED'";
        $permax3 = $clase2->SeleccionarUno($vsql37);

        // promedio en hisdetallenomina
        $vsql38 = "SELECT saldo 
                     FROM hisdetallenomina 
                    WHERE terid = ".$terid." 
                          AND conceptoid = 1 
                          AND (pernominaid >= ".$permin3." AND pernominaid <= ".$permax3.")";

        $conex = $clase2->Conectar();
        $result4 = mysql_query($vsql38,$conex);
        $cant1 = mysql_num_rows($result4);

        if($cant1 > 0)
        {
            $saldo = 0;
            while($row4 = mysql_fetch_array($result4))
            {
                $nroquinceda++;
                $saldo = $row4['saldo'];
    
                $acumsueldo += $saldo;
            }
        }

        // promedio en detalleliquidacion
        $permax3++;
        $vsql39 = "SELECT saldo 
                     FROM detalleliquidacion  
                    WHERE terid = ".$terid." 
                          AND conceptoid = 1 
                          AND (pernominaid >= ".$permin3." AND pernominaid <= ".$permax3.")";

        $conex = $clase2->Conectar();
        $result6 = mysql_query($vsql39,$conex);
        $cant2 = mysql_num_rows($result6);

        if($cant2 > 0)
        {
            $saldo = 0;
            while($row5 = mysql_fetch_array($result6))
            {
                $nroquinceda++;
                $saldo = $row5['saldo'];
    
                $acumsueldo += $saldo;
            }
        }

        // cálculo el sueldo promedio
        $salpromedio = $acumsueldo / $nroquinceda;
        $salpromedio = intval($salpromedio);

        return $salpromedio;
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Función generarlistaper
    // Parámetro de entrada:    $codperiodo    --> código del periodo
    // Valor de retorno:        $listaperiodos --> lista de periodos de nómina del periodo
    // Descripción: Función que devuelve la lista de periodos de nómina del periodo que se 
    //              está procesando
    ////////////////////////////////////////////////////////////////////////////////////////
    function generarlistaper($codperiodo)
    {
        $clase2 = new Sistema();

        $yeartoday = date("Y");

        $monthtoday = date("m");
        $daytoday = date("j");
        if(($monthtoday=="01")&&($daytoday<=16))   $yeartoday--;
        // ------------------------------------------------------------- //

        // Determino los periodos de nómina que se eliminarán
        $vsqlmesval = "SELECT MAX(MONTH(fechasta)) AS nummesval
                         FROM periodosnomina 
                        WHERE consecutivone <> ''
                              AND YEAR(fechasta) = ".$yeartoday."";
        $nummesval = $clase2->SeleccionarUno($vsqlmesval);
        
        $nummesval++;

        if($nummesval==13)      $nummesval = 1;

        $vsqlcodmesrep  = "SELECT codperiodo FROM periodos WHERE anoperiodo = ".$yeartoday." AND mesperiodo = ".$nummesval." ORDER BY orden";
        $codperiodo = $clase2->SeleccionarUno($vsqlcodmesrep);

        if(($codperiodo=="")||($codperiodo==NULL))
        {
            $yeartoday--;
            $nummesval--;
            $vsqlcodmesrep = "SELECT codperiodo FROM periodos WHERE anoperiodo = ".$yeartoday." AND mesperiodo = ".$nummesval." ORDER BY orden";
            $codperiodo = $clase2->SeleccionarUno($vsqlcodmesrep);
        }

        $vsqldesmesrep  = "SELECT desperiodo FROM periodos WHERE anoperiodo = ".$yeartoday." AND mesperiodo = ".$nummesval." ORDER BY orden";
        $desmesrep = $clase2->SeleccionarUno($vsqldesmesrep);

        $desperiodo = $clase2->BDLockup($codperiodo,'periodos','codperiodo','desperiodo');
        $mesperiodo = substr($desperiodo,0,-5);

        // fechas del periodo
        $fecinicio = substr($desperiodo,-4)."-".substr($codperiodo,0,2)."-01";
        $fecfinal = date("Y-m-t", strtotime($fecinicio));

        // Consulta de los periodos de nómina
        $vsql = "SELECT periodoid 
                   FROM periodosnomina 
                  WHERE descripcion LIKE '%".$mesperiodo."%' 
                        AND descripcion LIKE '%".$yeartoday."%'";
        $conex  = $clase2->Conectar();
        $result = mysql_query($vsql,$conex);
        $periodosreportar = mysql_num_rows($result);

        // Periodos a procesar
        if($periodosreportar>0)
        {
            $j = 0;
            while($row = mysql_fetch_array($result))
            {
                $listaperiodos.= $row['periodoid'].",";
                $segundaquinper = $row['periodoid'];

                $j++;
                if($j==1)   $pquin = $row['periodoid'];
                if($j==2)   $squin = $row['periodoid'];
            }
            $listaperiodos = substr($listaperiodos, 0, -1);
        }
        return($listaperiodos);
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Función calcularsueldopromedio
    // Parámetro de entrada:    $terid         --> id del empleado
    //                          $listaperiodos --> lista de quincenas del periodo
    //                          $fecretiro     --> fecha de retiro
    // Valor de retorno:        $promedioemp   --> sueldo promedio del año en curso
    // Descripción: Función que calcula el sueldo promedio del año en curso
    ////////////////////////////////////////////////////////////////////////////////////////
    function calcularsueldopromedio($terid,$listaperiodos,$fecretiro,$fecingreso)
    {
        $clase2 = new Sistema();

        // inicialización de variables
        $yeartoday = date("Y");                                     $saldo = 0;                                     $pernominaid = 0;
        $recarnonocturno = 0;                                       $acumuladoemp = 0;                              $promedioemp = 0;
        $perinicial = 0;                                            $perfinal = 0;                                  $cant2 = 0;

        // periodo inicial
        $vsql3 = "SELECT MIN(periodoid) perinicial FROM periodosnomina WHERE YEAR(fechasta) = ".$yeartoday." AND calculado = 'CHECKED' AND fecdesde >= '".$fecingreso."'";
        $perinicial = $clase2->SeleccionarUno($vsql3);

        // periodo final        
        $vsql4 = "SELECT MAX(periodoid) perinicial FROM periodosnomina WHERE YEAR(fechasta) = ".$yeartoday." AND calculado = 'CHECKED' AND fechasta <= '".$fecretiro."'";
        $perfinal = $clase2->SeleccionarUno($vsql4);

        // consulta con los peridos que serán evaluados
        $vsql = "SELECT pn.periodoid pernominaid, pt.basico saldo
                   FROM periodosnomina pn 
                        INNER JOIN periodoterceros pt ON (pn.periodoid = pt.pernominaid) 
                  WHERE pn.periodoid BETWEEN ".$perinicial." AND ".$perfinal." 
                        AND pn.calculado = 'CHECKED'                         
                        AND pt.terid = ".$terid." 
                        AND pt.extralegal <> 'CHECKED' 
                  UNION ALL
                 SELECT MAX(pernominaid) pernominaid, saldo
                   FROM detalleliquidacion 
                  WHERE terid = ".$terid."   
                        AND pernominaid IN ($listaperiodos)  
                        AND conceptoid IN (1,10,11,12,13,23,31,38,40,46) 
               ORDER BY 1";

        $conex = $clase2->Conectar();
        $result = mysql_query($vsql,$conex);
        $cant2 = mysql_num_rows($result);
        while($row = mysql_fetch_array($result))
        {
            $saldo = $row['saldo'] / 2;
            $pernominaid = $row['pernominaid'];            

            if(($pernominaid != Null) && ($saldo != Null))
            {
                // busco recargo nocturno
                $recarnonocturno = buscarrecargonoc($terid,$pernominaid);
                $saldo += $recarnonocturno;
    
                $acumuladoemp += $saldo;
            }
        }

        $promedioemp = $acumuladoemp / $cant2;
        $promedioemp = intval($promedioemp) * 2;

        return $promedioemp;
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Función calculardias
    // Parámetro de entrada:    $terid         --> id del empleado
    //                          $fecingreso    --> fecha de ingreso
    //                          $fecretiro     --> fecha de retiro
    // Valor de retorno:        $listaperiodos --> lista de periodos de nómina del periodo
    // Descripción: Función que calcula el número de días trabajados de un empleado en un 
    //              lapso de tiempo.
    ////////////////////////////////////////////////////////////////////////////////////////
    function calculardias($terid,$fecingreso,$fecretiro,$listaperiodos)    
    {
        $clase2 = new Sistema();        

        // inicialización de variables
        $auxdiaingreso = 0;                 $auxdiaretiro = 0;                  $diaingreso = 0;
        $mesingreso = 0;                    $diaretiro = 0;                     $mesretiro = 0;
        $auxdiaingreso = 0;                 $diaslaborados = 0;                 $vsql36 = "";
        $permin3 = 0;                       $vsql37 = "";                       $permax3 = 0;
        $vsql = "";                         $totnovedadeshis = 0;               $totnovedadesliq = 0;

        // determino los días, mes y año de las fechas de ingreso y retiro
        $diaingreso = intval(substr($fecingreso,8,2));
        $mesingreso = intval(substr($fecingreso,5,2));
        $yearingreso = substr($fecingreso,0,4);
        $diaretiro = intval(substr($fecretiro,8,2));
        $mesretiro = intval(substr($fecretiro,5,2));
        $yearretiro = substr($fecretiro,0,4);

        // Evalúo las fechas de ingreso y retiro
        if(($diaingreso == 1) && (($diaretiro == 30) || ($diaretiro == 31)))
        {
            $fecha1= new DateTime($fecingreso);
            $fecha2= new DateTime($fecretiro);
            $diff = $fecha1->diff($fecha2);
            $difmes =  $diff->format('%m');
        }
        else
        {
            if($diaingreso != 1)
            {
                $auxdiaingreso = 30 - $diaingreso;
                $auxdiaingreso++;
                $auxmesingreso = $mesingreso + 1;
    
                if($auxmesingreso > 12)
                {
                    $auxyearingreso = intval($yearingreso) + 1;
                    $auxfechaingreso = strval($auxyearingreso)."-01-01";
                }
                else
                {
                    if($auxmesingreso < 10)
                    {
                        $auxmesingreso2 = "0".strval($auxmesingreso);
                        $auxfechaingreso = $yearingreso."-".$auxmesingreso2."-01";
                    }   
                    else
                        $auxfechaingreso = $yearingreso."-".$auxmesingreso."-01";
                }
            }
            else
                $auxfechaingreso = $fecingreso;

            if(($diaretiro != 30) && ($diaretiro != 31))
            {
                $auxdiaretiro = $diaretiro;
                $auxmesretiro = $mesretiro - 1;

                if($auxmesretiro < 10)
                {
                    $auxmesretiro2 = "0".$auxmesretiro;
                    $auxfecharetiro = $yearretiro."-".$auxmesretiro2."-30";
                }
                else
                    $auxfecharetiro = $yearretiro."-".strval($auxmesretiro)."-30";
            }
            else
                $auxfecharetiro = $fecretiro;

            $fecha1= new DateTime($auxfechaingreso);
            $fecha2= new DateTime($auxfecharetiro);
            $diff = $fecha1->diff($fecha2);
            $difmes =  $diff->format('%m');
            $difmes++;
        }

        $diaslaborados = ($difmes * 30) + $auxdiaingreso + $auxdiaretiro;

        // rango de periodos 
        $vsql36 = "SELECT MIN(periodoid) permin3
                     FROM periodosnomina 
                    WHERE fecdesde >= '".$fecingreso."'";
        $permin3 = $clase2->SeleccionarUno($vsql36);
        
        $vsql37 = "SELECT periodoid permax3
                     FROM periodosnomina 
                    WHERE '".$fecretiro."' >= fecdesde AND '".$fecretiro."' <= fechasta";
        $permax3 = $clase2->SeleccionarUno($vsql37);

        // novedades del histórico
        $vsql = "SELECT IFNULL(SUM(d.valor),0) totnovedades 
                   FROM hisdetallenomina d
                        INNER JOIN conceptosnomina c ON (d.conceptoid = c.conceptoid)
                  WHERE d.terid = ".$terid."
                        AND (d.pernominaid BETWEEN ".$permin3." AND ".$permax3.") 
                        AND (c.eslicencia = 'CHECKED' AND c.tipodc = 'D')";
        $totnovedadeshis = $clase2->SeleccionarUno($vsql);

        // novedades de la liquidación
        $vsql = "SELECT IFNULL(SUM(d.valor),0) totnovedades 
                   FROM detalleliquidacion d
                        INNER JOIN conceptosnomina c ON (d.conceptoid = c.conceptoid)
                  WHERE d.terid = ".$terid."
                        AND (d.pernominaid BETWEEN ".$permin3." AND ".$permax3.") 
                        AND (c.eslicencia = 'CHECKED' AND c.tipodc = 'D')";
        $totnovedadesliq = $clase2->SeleccionarUno($vsql);
        
        // calculo los días laborados
        $diaslaborados = $diaslaborados - $totnovedadeshis - $totnovedadesliq;

        // ---------------------------------------------------------------------------------- //
        // casos especiales

        // mismo año y mismo mes en las fechas de ingreso y retiro
        if(($yearingreso == $yearretiro) && ($mesingreso == $mesretiro))
        {
            $t1 = substr($yearingreso,-2);
            if($mesingreso < 10)
                $mes2 = "0".strval($mesingreso);
            else
                $mes2 = strval($mesingreso);

            $tt = "SELECT IFNULL(SUM(h.valor),0) dias
                     FROM hisdetallenomina h
                    WHERE h.terid = ".$terid." 
                          AND h.conceptoid IN (1,10,11,12,13,23,31,38,40,46)
                          AND h.pernominaid IN (SELECT periodoid FROM periodosnomina WHERE SUBSTR(codigo,4,2) = '".$mes2."' AND SUBSTR(codigo,1,2) = '".$t1."')
                          AND h.pernominaid NOT IN (SELECT pernominaid 
                                                      FROM periodoterceros pt 
                                                     WHERE pt.terid = ".$terid." 
                                                           AND pt.pernominaid = h.pernominaid 
                                                           AND pt.extralegal = 'CHECKED')";
            $diasuno = $clase2->SeleccionarUno($tt);            

            $tb = "SELECT IFNULL(SUM(valor),0) dias
                     FROM detalleliquidacion 
                    WHERE terid = ".$terid." 
                          AND pernominaid IN ($listaperiodos)
                          AND conceptoid IN (1,10,11,12,13,23,31,38,40,46)";
            $diasdos = $clase2->SeleccionarUno($tb);

            $diaslaborados = $diasuno + $diasdos;
        }

        // mismo año diferente mes
        if(($yearingreso == $yearretiro) && ($mesingreso != $mesretiro))
        {
            $t1 = substr($yearingreso,-2);

            if($mesingreso < 10)
                $mes1 = "0".strval($mesingreso);
            else
                $mes1 = strval($mesingreso);

            if($mesretiro < 10)
                $mes2 = "0".strval($mesretiro);
            else
                $mes2 = strval($mesretiro);

            $tt = "SELECT IFNULL(SUM(h.valor),0) dias 
                     FROM hisdetallenomina h 
                    WHERE h.terid = ".$terid." 
                          AND h.conceptoid IN (1,10,11,12,13,23,31,38,40,46) 
                          AND h.pernominaid IN (SELECT periodoid 
                                                  FROM periodosnomina 
                                                 WHERE SUBSTR(codigo,4,2) BETWEEN '".$mes1."' AND '".$mes2."'
                                                       AND SUBSTR(codigo,1,2) = '".$t1."') 
                          AND h.pernominaid NOT IN (SELECT pernominaid 
                                                      FROM periodoterceros pt 
                                                     WHERE pt.terid = ".$terid." 
                                                           AND pt.pernominaid = h.pernominaid 
                                                           AND pt.extralegal = 'CHECKED')";
            $diasuno = $clase2->SeleccionarUno($tt);            

            $tb = "SELECT IFNULL(SUM(valor),0) dias
                     FROM detalleliquidacion 
                    WHERE terid = ".$terid." 
                          AND pernominaid IN ($listaperiodos)
                          AND conceptoid IN (1,10,11,12,13,23,31,38,40,46)";
            $diasdos = $clase2->SeleccionarUno($tb);

            $diaslaborados = $diasuno + $diasdos;
        }
        // ---------------------------------------------------------------------------------- //

        return $diaslaborados;
    }
?>