<?PHP
 class Sistema
 {
  // MySQL Class v0.8.1 del 15 Abril 2015

    public $UsuarioBD;
    public $ClaveBD;
    public $ServidorBD;
    public $NombreBD;   
    public $URLSitio;   
  
    private $Conex;             // Database Connection Link
    public  $lastError;         // Holds the last error
    public  $lastQuery;         // Ultimo Query
    public  $result;            // Holds the MySQL query result
    public  $records;           // Holds the total number of records returned
    public  $affected;          // Holds the total number of records affected
    public  $rawResults;        // Holds raw 'arrayed' results
    public  $arrayedResult;     // Holds an array of the result 

  ////////////////////////////////////////////////
  //  * Class Constructor *
  ////////////////////////////////////////////////
  function __construct($hostname='localhost', $port=3306, $persistant = false)
  {
     date_default_timezone_set('America/Bogota');  
     $db = parse_ini_file("datasource.ini");

     $this->UsuarioBD  =  $db['UsuarioBD'];
     $this->ClaveBD    =  $db['ClaveBD'];
     $this->NombreBD   =  $db['NombreBD'];
     $this->ServidorBD =  $db['ServidorBD'];

     ///// Ya completados los datos me conecto
     $this->Conectar();
  }
  
  /* *******************
   * Class Destructor  *
   * *******************/
  function __destruct(){
    $this->closeConnection();
    //echo mysqli_error();
  } 

   ///////////////////////////////////////////////////////
   // ****************************************************
   // FUNCIONES DE CONEXION A LA BASE DE DATOS           
   // ****************************************************
   // Establece una Conexion a la Base de Datos Activa
   // Devuelve : El Enlace a la conexion
   ///////////////////////////////////////////////////////
   function Conectar($persistant = false)
   {
     $this->closeConnection();
    
     if($persistant)
     {
        $this->Conex = @mysqli_pconnect($this->ServidorBD,$this->UsuarioBD,$this->ClaveBD);
     }else{
        $this->Conex = @mysqli_connect($this->ServidorBD,$this->UsuarioBD,$this->ClaveBD,$this->NombreBD);
     }  
     
     if(!$this->Conex)
     {
        $this->lastError = 'ERROR al conectar al Servidor !  <br><font color="blue">ERROR No. <b> 00 ' .mysqli_errno($this->Conex) . "</font><font color=\"red\"></b><br>Detalle del Problema : <b>" .mysqli_error($this->Conex);
        echo $this->lastError; exit;
        return false;
     }  
     
     /*
     if(!$this->UseDB()){
        $this->lastError = 'ERROR al conectar al Servidor !  <br>ERROR No. <b>' .mysqli_errno($this->Conex) . "</b><br>Detalle del Problema : <b>" .mysqli_error($this->Conex);
        echo $this->lastError; exit;
        return false;
     }
     */
     $this->setCharset(); // TODO: remove forced charset find out a specific management
     return($this->Conex);     
   }
    
    /////////////////////////////////////////////////
    private function GetServidor()
    {
       return($this->ServidorBD);
    }

    /////////////////////////////////////////////////
    private function GetDatabase()
    {
       return($this->NombreBD);
    }

    /////////////////////////////////////////////////
    private function GetUsuario()
    {
       return($this->UsuarioBD);
    }

    /////////////////////////////////////////////////
    private function GetClave()
    {
       return($this->ClaveBD);
    }
       
    /////////////////////////////////////////////////
    public function closeConnection()
    {
      if(@$this->Conex)
      {
        // Commit before closing just in case :)
        @$this->commit();
        @mysqli_close($this->Conex);
//        echo mysqli_error($this->Conex);
      }
    }
    
    /////////////////////////////////////////////////
    private function Desconectar()
    {
       $this->closeConnection();
    }

    ///////////////////////////////////////////////////
    // Performs a 'mysqli_real_escape_string' on the entire array/string
    private function SecureData($data, $types=array()){
    if(is_array($data)){
            $i = 0;
      foreach($data as $key=>$val){
        if(!is_array($data[$key])){
                    $data[$key] = $this->CleanData($data[$key], $types[$i]);
          $data[$key] = mysqli_real_escape_string($data[$key], $this->Conex);
                    $i++;
        }
      }
    }else{
            $data = $this->CleanData($data, $types);
            $data = @mysqli_real_escape_string($data, $this->Conex);
    }
    return $data;
  }

    // clean the variable with given types
    // possible types: none, str, int, float, bool, datetime, ts2dt (given timestamp convert to mysql datetime)
    // bonus types: hexcolor, email
    private function CleanData($data, $type = ''){
        switch($type) {
            case 'none':
            // useless do not reaffect just do nothing
            // $data = $data;
            break;
            case 'str':
            case 'string':
                settype( $data, 'string');
                break;
            case 'int':
            case 'integer':
                settype( $data, 'integer');
                break;
            case 'float':
                settype( $data, 'float');
                break;
            case 'bool':
            case 'boolean':
                settype( $data, 'boolean');
                break;
            // Y-m-d H:i:s
            // 2014-01-01 12:30:30
            case 'datetime':
                $data = trim( $data );
                $data = preg_replace('/[^\d\-: ]/i', '', $data);
                preg_match( '/^([\d]{4}-[\d]{2}-[\d]{2} [\d]{2}:[\d]{2}:[\d]{2})$/', $data, $matches );
                $data = $matches[1];
                break;
            case 'ts2dt':
                settype( $data, 'integer');
                $data = date('Y-m-d H:i:s', $data);
                break;
            // bonus types
            case 'hexcolor':
                preg_match( '/(#[0-9abcdef]{6})/i', $data, $matches );
                $data = $matches[1];
                break;
            case 'email':
                $data = filter_var($data, FILTER_VALIDATE_EMAIL);
                break;
            default:
                break;
        }
        return $data;
    }
    
  // Select database to use
  private function UseDB(){
    /*
    mysqli_select_db($this->NombreBD,$this->Conex);
    if(!mysqli_select_db($this->NombreBD,$this->Conex)){
      $this->lastError = 'ERROR al Seleccionar la Base de Datos : ' . mysqli_error($this->Conex);
      return false;
    }else{
      return true;
    }
    */
  }
  
    public function commit(){
    return @mysqli_query("COMMIT", $this->Conex);
  }
  
  public function rollback(){
    return @mysqli_query("ROLLBACK", $this->Conex);
  }
  public function setCharset( $charset = 'UTF8' ) {
    return @mysqli_set_charset( $this->SecureData($charset,'string'), $this->Conex);
  }

    // Returns last insert ID
    public function lastInsertID(){
        return @mysqli_insert_id($this->Conex);
    }
    
  // Return number of rows
    public function countRows($from, $where=''){
        $result = $this->select($from, $where, '', '', false, 'AND','count(*)');
        return $result["count(*)"];
    }
    
  //////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
  // Gets a single row from $from where $where is true
    public function select($from, $where='', $orderBy='', $limit='', $like=false, $operand='AND',$cols='*', $wheretypes=array()){
        // Catch Exceptions
        if(trim($from) == ''){
            return false;
        }
        $query = "SELECT {$cols} FROM `{$from}` WHERE ";
        if(is_array($where) && $where != ''){
            // Prepare Variables
            $where = $this->SecureData($where, $wheretypes);
            foreach($where as $key=>$value){
                if($like){
                    $query .= "`{$key}` LIKE '%{$value}%' {$operand} ";
                }else{
                    $query .= "`{$key}` = '{$value}' {$operand} ";
                }
            }
            $query = substr($query, 0, -(strlen($operand)+2));
        }else{
            $query = substr($query, 0, -6);
        }
        if($orderBy != ''){
            $query .= ' ORDER BY ' . $orderBy;
        }
        if($limit != ''){
            $query .= ' LIMIT ' . $limit;
        }
        $result = $this->executeSQL($query);
        if(is_array($result)) return $result;
        return array();
    }
      
  // ************************************************************
  // Ejecuta una consulta SQL DE ACCION (INSERT - UPDATE - DELETE)
    // Recibe : La Consulta SQL a Ejecutar  
  function EjecutarSQL($SQL)
  {
     $this->lastQuery = $SQL;
     $this->Conectar();
     if($this->result = @mysqli_query($this->Conex , $SQL))
     {
            if (gettype($this->result) === 'resource') {
                $this->records  = @mysqli_num_rows($this->result);
            } else {
               $this->records  = 0;
            }
            $this->affected = @mysqli_affected_rows($this->Conex);
            if($this->records > 0){
                $this->arrayResults();
                return $this->arrayedResult;
            }else{
                return true;
            }
        }else{
            $this->lastError = @mysqli_error($this->Conex);
            
            return false;
       }
     $this->closeConnection();
  }


  
  // ************************************************************
  // Busca el Campo RETORNO en la tabla TABLA por el campo CAMPO 
  // segun un CRITERIO
    // Recibe : CRITERIO - TABLA - CAMPO A BUSCAR - CAMPO A RETORNAR
  function BDLockup($criterio,$tabla,$campo,$retorno)
  {
     $campoEnc = "";
     $conex    = $this->Conectar();
     $consulta = "SELECT " . $retorno . " AS RET FROM " . $tabla . " WHERE " . $campo . " ='" . $criterio . "'";
     $this->lastQuery = $consulta;
     $result = @mysqli_query($conex,$consulta);
     if($row = @mysqli_fetch_array($result)) 
       $campoEnc = $row['RET'];
     
     @mysqli_free_result($result); 
     $this->closeConnection();
     return($campoEnc);   
  }
  
  // ************************************************************
  // Ejecuta una consulta SQL y Devuelve el UNICO CAMPO econtrado
  // Si la consulta genera mas campos solo devuelve el 1,1
    // Recibe : La Consulta SQL a Ejecutar
  // Devuelve : El Campo encontrado 
  function SeleccionarUno($SQL)
  {
     $campoEnc = "";
     $conex  = $this->Conectar();
     $result = @mysqli_query($conex,$SQL);
     if($row = @mysqli_fetch_array($result)) 
       $campoEnc = $row[0];
  
     @mysqli_free_result($result); 
     $this->closeConnection();
     return($campoEnc);    
  } 

  ///////////////////////////////////////////////////////////////////
  //// Combo Combo con datos de la Base de Datos 
  ///////////////////////////////////////////////////////////////////
  function CrearComboEsp($nombrecombo,$vsql,$caption,$valor,$valordefecto,$incluirblanco,$otros)
  {  
      $conex = $this->Conectar();
      $result = @mysqli_query($conex,$vsql); 
      $cont = '<SELECT name="'.$nombrecombo.'" onkeypress="return TabulaEnter(this, event)" '.$otros.' >';
     
      if($incluirblanco == "S")
        $cont.='<option value=""> </option>';
        
      while($row = @mysqli_fetch_row($result)){
      if($row[0] != "")
      {
          if($valordefecto == $row[0])
              $cont.='<option value="'.$row[0].'" selected> '.$row[1].'</option>';
          else
            $cont.='<option value="'.$row[0].'"> '.$row[1].'</option>';		 		
      }	 
      }
        $cont.='</SELECT>';	   
      return($cont);
 }

 //////////////////////////////////////////////////////////////////////////////////////////
 function CrearComboBuscar($nombrecombo,$vsql,$caption,$valor,$valordefecto,$incluirblanco,$otros,$width)
 {  
      
      /// Recorro la consultas 
      $detalles = '" " : null ,
      ';
      $conex = $this->Conectar();
      $result = @mysqli_query($conex,$vsql); 

      while($row = @mysqli_fetch_row($result))
      {
        $detalles.= ' "'.$row['1'].'" : "'.$row['0'].'" ,
        ';
      }

      //echo $detalles; exit;
      /// Cargo las librerias
      $cont ='
      <link href="http://fonts.googleapis.com/icon?family=Material+Icons" rel="stylesheet">
      <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/materialize/0.97.8/css/materialize.min.css">
      <script type="text/javascript" src="https://code.jquery.com/jquery-2.1.1.min.js"></script>    
      <script src="https://cdnjs.cloudflare.com/ajax/libs/materialize/0.97.8/js/materialize.min.js"></script>
      <meta name="viewport" content="width=device-width, initial-scale=1.0"/>

      <div class="input-field col s12">
      <i class="material-icons prefix">search</i>
      <input type="text" name="'.$nombrecombo.'" style="text-transform:uppercase;" id="autocomplete-input" class="autocomplete" autocomplete="off">
      <label for="autocomplete-input">Digite para Buscar el Paciente</label>
      </div>

      <script>
          document.addEventListener(\'DOMContentLoaded\', function() {
            var elems = document.querySelectorAll(\'.autocomplete\');
            var instances = M.Autocomplete.init(elems, options);
          });

          $(document).ready(function(){
          $(\'input.autocomplete\').autocomplete({
          data: {
            '.$detalles.'
            " " : null
          }
          });
          });
      </script>';

     return($cont);
     /*         
     /// Cargo la Data 
     $cont.= '<select class="chzn-select" name="'.$nombrecombo.'"  style="width:'.$width.'px;" >';
       
      if($incluirblanco == "S")
        $cont.='<option value=""> </option>';
        
      while($row = @mysql_fetch_row($result))
      {
         if($row[0] != "")
         {
             if($valordefecto == $row[0])
                 $cont.='<option value="'.$row[0].'" selected> '.$row[1].'</option>';
             else
                 $cont.='<option value="'.$row[0].'"> '.$row[1].'</option>';		 		
         }	 
      }
      
      $cont.='</SELECT>';	   
      return($cont);
      */
  }


  ///////////////////////////////////////////////////////////////////
  ////  Encabezado General
  ///////////////////////////////////////////////////////////////////
  function Encabezado($titulo)
  {
     if($_SESSION['ACTIVA'] == "CHECKED")
     {
        $cont = '<!DOCTYPE html>
        <html>
        <head>
            <!--Import Google Icon Font-->
            <link href="https://fonts.googleapis.com/icon?family=Material+Icons" rel="stylesheet">
            <!--Import materialize.css-->
            <link type="text/css" rel="stylesheet" href="css/materialize.min.css" media="screen,projection" />
            <link rel="stylesheet" href="css/app.css">
        
            <!--Let browser know website is optimized for mobile-->
            <meta name="viewport" content="width=device-width, initial-scale=1.0" />
            
            <link rel="shortcut icon" href="images/favicon.ico" /> 
        
            <link rel = "stylesheet"
              href = "https://cdnjs.cloudflare.com/ajax/libs/materialize/0.97.3/css/materialize.min.css">
            <script type = "text/javascript"
              src = "https://code.jquery.com/jquery-2.1.1.min.js"></script>           
            <script src = "https://cdnjs.cloudflare.com/ajax/libs/materialize/0.97.3/js/materialize.min.js">
            </script> 
            
            
            <link href="https://www.jqueryscript.net/css/jquerysctipttop.css" rel="stylesheet" type="text/css">

            <script>
              $(document).ready(function() {
                  $(\'select\').material_select();
              });
            </script>

        <title> '.$titulo.' </title>
        </head>
        <body ng-app="mainModule" ng-controller="mainController">';
        return($cont); 
     }
     else
     {
        $_SESSION['ACTIVA'] = "";
        session_destroy();
        header("Location: index.php");
     }
  }

  ///////////////////////////////////////////////////////////////////
  ////  Encabezado General
  ///////////////////////////////////////////////////////////////////
  function EncabezadoB($titulo)
  {
     if($_SESSION['ACTIVA'] == "CHECKED")
     {
        $cont = '<!DOCTYPE html>
        <html>
        <head>
            <!--Import Google Icon Font-->
            <link href="https://fonts.googleapis.com/icon?family=Material+Icons" rel="stylesheet">
            <!--Import materialize.css-->
            <link rel="stylesheet" href="https://maxcdn.bootstrapcdn.com/bootstrap/4.0.0/css/bootstrap.min.css" integrity="sha384-Gn5384xqQ1aoWXA+058RXPxPg6fy4IWvTNh0E263XmFcJlSAwiGgFAW/dAiS6JXm" crossorigin="anonymous">
            <script src="https://code.jquery.com/jquery-3.2.1.slim.min.js" integrity="sha384-KJ3o2DKtIkvYIK3UENzmM7KCkRr/rE9/Qpg6aAZGJwFDMVNA/GpGFF93hXpG5KkN" crossorigin="anonymous"></script>
            <script src="https://cdnjs.cloudflare.com/ajax/libs/popper.js/1.12.9/umd/popper.min.js" integrity="sha384-ApNbgh9B+Y1QKtv3Rn7W3mgPxhU9K/ScQsAP7hUibX39j7fakFPskvXusvfa0b4Q" crossorigin="anonymous"></script>
            <script src="https://maxcdn.bootstrapcdn.com/bootstrap/4.0.0/js/bootstrap.min.js" integrity="sha384-JZR6Spejh4U02d8jOt6vLEHfe/JQGiRRSQQxSfFWpi1MquVdAyjUar5+76PVCmYl" crossorigin="anonymous"></script>
            <!--Let browser know website is optimized for mobile-->
            <meta name="viewport" content="width=device-width, initial-scale=1.0" />    
            <link rel="shortcut icon" href="images/favicon.ico" /> 
  
        <title> '.$titulo.' </title>
        </head>
        <body ng-app="mainModule" ng-controller="mainController">';
        return($cont); 
     }
     else
     {
        $_SESSION['ACTIVA'] = "";
        session_destroy();
        header("Location: index.php");
     }
  }

  ///////////////////////////////////////////////////////////////////
  ////  Logo App con Link
  ///////////////////////////////////////////////////////////////////
  function LogoApp()
  {
      $cont = '<div class="row">
                <div class="details panel s6 m3 l2" style="background-color: white;">
                  <div class="picture">
                      <a href="principal.php"><img src="images/logooptica.jpg" id="imagen" style="width: 300px; padding-left: 0px;"></a>
                  </div>
              </div>';
      return($cont);
  } 
  
  ///////////////////////////////////////////////////////////////////
  ////  Redirecciona a una nueva URL
  ///////////////////////////////////////////////////////////////////
  function Redireccionar($url)
  {
    echo'<script language="javascript">
              <!-- 
                document.location.href = "'.$url.'";  
              -->
            </script>';
    exit;        
  }

 } // Fin de la Clase  
?> 