<?php

include("../../lib/Sistema.php");

/**
 * Clase API del WebService
 * Permite hacer las 4 Actividades Básicas CRUD a la Tabla Transferencias
 * Desde WebService
 * @author Said Rodriguez
 * @version 2017-01-30
 */

class api
{
	private $db;

	/**
	 * Constructor - Abre una conexion a la Base de Datos
	 *
	 * @param Vacío
	 * @return Conexion a la Base de Datos
	 */
	
	function __construct()
	{
		$clase = new Sistema();
		$this->db = new mysqli($clase->ServidorBD,$clase->UsuarioBD,$clase->ClaveBD,$clase->NombreBD);
	}

	/**
	 * Destructor - close DB connection
	 *
	 * @param Vacío
	 * @return Vacío
	 */

	function __destruct()
	{
		$this->db->close();
	}

	/**
	 * Obtiene un Listado de Transferencias (Las Ultimas 200)
	 *
	 * @param Vacio	 
	 * @return Lista de Transferencias en Formato JSON
	 */
	function getListaTransferencias()
	{
		$query = 'SELECT D.docuid , D.tipodoc , D.prefijo , D.numero , D.periodo , D.fechadoc , D.codigo1 , D.codigo2 , 
				  D.codigo3 , D.base , D.iva , D.total , D.totalitems , D.sucursalid , D.creador , D.momento ,
				  B2.codbodega codbodori , B.codbodega codboddes
				  FROM documentos D INNER JOIN docutranfe DT ON (D.docuid = DT.docuid) 
				  INNER JOIN bodegas B ON (B.bodegaid = DT.bodegaiddes) 
				  INNER JOIN bodegas B2 ON (B2.bodegaid = DT.bodegaidori) 
				  WHERE D.tipodoc = "TRB" AND D.fecasentado <> "0000-00-00" ORDER BY D.docuid DESC LIMIT 0,200';
		$list = array();
		$result = $this->db->query($query);
		while ($row = $result->fetch_assoc())
		{
			$list[] = $row;
		}
		return $list;
	}

	/**
	 * Obtiene los datos completos de una Transferencia
	 *
	 * @param Id del Documento Transferencia	 
	 * @return Lista de Datos de la Transferencia en Formato JSON
	 */
    function getDetalleTransferencia($params)
	{
		$query = 'SELECT D.tipodoc , D.prefijo , D.numero , D.periodo , D.fechadoc , D.codigo1 , D.codigo2 , D.nrodocref , 
				  D.codigo3 , D.observacion , D.base , D.iva , D.total , D.totalitems , D.sucursalid , D.creador , D.momento ,
				  B2.codbodega codbodori , B.codbodega codboddes , DT.bodegaidori , DT.bodegaiddes , P.codigo codproducto, 
				  P.productoid , DD.bodegaid , DD.valunitario , DD.valparcial , DD.porciva , DD.valbase , DD.valiva , DD.valtotal , 
				  SUM(DD.cantidad) cantidad , SUM(DD.unidades) unidades , SUM(DD.unicom) unicom , SUM(DD.unifra) unifra 
				  FROM documentos D INNER JOIN docutranfe DT ON (D.docuid = DT.docuid)
				  INNER JOIN dedocumentos DD ON (D.docuid = DD.docuid)
				  INNER JOIN productos P ON (DD.productoid = P.productoid)
			 	  INNER JOIN bodegas B ON (B.bodegaid = DT.bodegaiddes)
				  INNER JOIN bodegas B2 ON (B2.bodegaid = DT.bodegaidori)
				  WHERE D.docuid = '.$params['id'].'  
                  GROUP BY 1,2,3,4,5,6,7,8,9,10,11,12,13,14,15,16,17,18,19,20,21,22,23,24,25,26,27,28,30 ORDER BY D.docuid DESC';
	
		$list = array();
		$result = $this->db->query($query);
		while ($row = $result->fetch_assoc())
		{
			$list[] = $row;
		}
		return $list;
	}

    /**
	 * Asigna un numero de Consecutivo al cruce
	 *
	 * @param Id del Documento Cruce
	 * @return Numero Asignado al cruce
	 */
    function AsignarConsecutivo($docuid)
	{
		//// 1. Busco el Consecutivo Actual de Cruces
		$query = "SELECT numero FROM consecutivos WHERE tipodoc = 'TRB' AND prefijo = 'CRU'";
		$result = $this->db->query($query);
		if($row = $result->fetch_assoc())
		   $CONSEC_ACTUAL = $row['numero'];
		
		//// 2. Consecutivo siguiente con formato
		$NCONSEC = str_pad(($CONSEC_ACTUAL+1) , 5 , "0" , STR_PAD_LEFT);
        
        //// 3. Actualizo la tabla de Consecutivos
		$vsql = "UPDATE consecutivos SET numero = '".$NCONSEC."' WHERE tipodoc = 'TRB' AND prefijo = 'CRU'";
		$stmt = $this->db->prepare($vsql);
	    $r = $stmt->execute();	
        
        //// 4. Actualizo el documento Cruce con el nuevo numero
		$vsql = "UPDATE documentos SET numero = '".$NCONSEC."' WHERE docuid=".$docuid;
		$stmt = $this->db->prepare($vsql);
	    $r = $stmt->execute();	
        
        return($NCONSEC."|".$docuid);
	}
 

    /**
	 * Crea una nueva Transferencia por Cargar
	 *
	 * @param Array con los datos de la Transferencia	 
	 * @return el numero del cruce creado
	 */
    public function setNuevaTransferencia($params)
	{
		$i=0;
		while($params[$i]->tipodoc)
        {
			//// Si es el 1er Registro ($i==0) Inserto el Documento y Docutranfe
			
			if($i==0)
            {
	            //// Le paso los parámetros
	            $pre = $params[$i]->prefijo;    	            $num  = $params[$i]->numero;
	            $per = $params[$i]->periodo;    	            $fec  = $params[$i]->fechadoc;
	            $co1 = $params[$i]->codigo1;    	            $co2  = $params[$i]->codigo2;
                $co3 = $params[$i]->codigo3;    	            $bas  = $params[$i]->base;
                $bor = $params[$i]->bodegaidori;  	            $bde  = $params[$i]->bodegaiddes;
                $obs = $params[$i]->observacion;                $nro  = $params[$i]->nrodocref;
                $iva = $params[$i]->iva;           	            $tot  = $params[$i]->total;
                $ite = $params[$i]->totalitems;   	            $suc  = $params[$i]->sucursalid;
                $cre = $params[$i]->creador;   	                $mom  = $params[$i]->momento;

                //// 1. Elimino la transferencia si Existe
				$vsql = "DELETE FROM documentos WHERE tipodoc = 'TRB' AND prefijo = 'CRU' AND numero = '".$num."'";
				$stmt = $this->db->prepare($vsql);
	            $r = $stmt->execute();	

				/// 2. Inserto el Documento
				$vsql = "INSERT IGNORE INTO documentos(tipodoc,prefijo,numero,periodo,fechadoc,formapago,terid1,terid2,terid3,
					     observacion,base,iva,total,impreso,totalitems,sucursalid,nrodocref,creador,momento) 
                         VALUES('TRB','".$pre."','".$num."','".$per."','".$fec."','CO',1,1,1,'".$obs."',".$bas.",".$iva.",".$tot.
                         ",'S',".$ite.",".$suc.",'".$nro."','".$cre."','".$mom."')";
				$stmt = $this->db->prepare($vsql);
  
	            //// Ejecuto la Consulta SQL
	            $r = $stmt->execute();
	            
	            /// Obtengo el Docuid
	            $NDOCUID = $this->db->insert_id;

                /// 3. Inserto el DocuTranfe
				$vsql = "INSERT INTO docutranfe(docuid,bodegaidori,bodegaiddes,kardexori,kardexdes,codbarra,enviado,planogen) 
				         VALUES(".$NDOCUID.",".$bor.",".$bde.",'S','S','',CURRENT_TIMESTAMP,'S')";
				$stmt = $this->db->prepare($vsql);
	            //// Ejecuto la Consulta SQL
	            $r = $stmt->execute();
            }
            
            /// Si pudo insertar el Encabezado - Procedo con los detalles
            if($NDOCUID != "")
            {
                //// Recibo los parámetros del Detalle
	            $pid = $params[$i]->productoid;    	            $bid  = $params[$i]->bodegaid;
	            $can = $params[$i]->cantidad;    	            $uni  = $params[$i]->unidades;
	            $vun = $params[$i]->valunitario;    	        $vpa  = $params[$i]->valparcial;
	            $por = $params[$i]->porciva;    	            $vba  = $params[$i]->valbase;
	            $viv = $params[$i]->valiva;    	                $vto  = $params[$i]->valtotal;
	            $uco = $params[$i]->unicom;    	                $ufr  = $params[$i]->unifra;
                
                /// 4. Inserto los detalles
                $vsql2 = "INSERT INTO dedocumentos(docuid,productoid,bodegaid,cantidad,unidades,valunitario,valdescuento,
                	      valparcial,porciva,valbase,valiva,valtotal,unicom,unifra) 
                          VALUES(".$NDOCUID.",".$pid.",".$bid.",".$can.",".$uni.",".$vun.",0,".$vpa.",".$por.
                          ",".$vba.",".$viv.",".$vto.",".$uco.",".$ufr.")";
                
                $stmt = $this->db->prepare($vsql2);
	            $r = $stmt->execute();
            } 	
          
            //// Siguiente Registro
	        $i++;
	    }    
        
        /// Recalculo los Valores de la transferencia
        $stmt = $this->db->prepare("CALL PA_CalValoresGEN(".$NDOCUID.")");
	    $r = $stmt->execute();

        /// Le asigno consecutivo al cruce
        $numeroact = $this->AsignarConsecutivo($NDOCUID);
        
        ///  Genero el Archivo por Cargar 
        GenerarAServidor($NDOCUID);
         
        /// Asiento el Cruce 
        $stmt = $this->db->prepare("UPDATE documentos SET fecasentado = CURRENT_DATE WHERE docuid = ".$NDOCUID);
	    $r = $stmt->execute();

        //// Retorno el numero asignado por el servidor al cruce
        return $numeroact; 
	}

} /// Fin de la Clase API


///////////////////////////////////////////////////////////
  ///////////////////////////////////////////////////////////
  function GenerarAServidor($docuid)
  {
     $linea = "";      $cont="";
	 $clase = new Sistema();
	   
	 //// Datos del Tercero
	 $vsql="SELECT T.* FROM terceros T INNER JOIN documentos D ON (T.terid = D.terid1) WHERE D.docuid=".$docuid;
	 $conex  = $clase->Conectar();
     $result = mysql_query($vsql,$conex);
	 if($row = mysql_fetch_array($result))
	 {
	    $linea = "INSERT IGNORE INTO terceros(codigo,dni,tipodoc,apellidos,nombres,telfijo,telmovil,ciudadid,zonaterid,gruposperid,escliente,creador,momento) VALUES('".$row['codigo']."','".$row['dni']."','".$row['tipodoc']."','".$row['apellidos']."','".$row['nombres']."','".$row['telfijo']."','".$row['telmovil']."',1,1,1,'S','".$row['creador']."','".$row['momento']."');";
		$cont.= $linea.Chr(13).Chr(10);  		 
	 }   
	 
	 //// Datos del Documento
	 $vsql="SELECT * FROM documentos WHERE docuid=".$docuid;
	 $conex  = $clase->Conectar();
     $result = mysql_query($vsql,$conex);
	 if($row = mysql_fetch_array($result))
	 {
	    $linea = "*INSERT IGNORE INTO documentos(tipodoc,prefijo,numero,periodo,fechadoc,formapago,terid1,terid2,terid3,observacion,base,iva,total,impreso,totalitems,sucursalid,nrodocref,creador,momento) VALUES('".$row['tipodoc']."','".$row['prefijo']."','".$row['numero']."','".$row['periodo']."','".$row['fechadoc']."','".$row['formapago']."',".$row['terid1'].",".$row['terid2'].",".$row['terid3'].",'".trim(strtoupper(eregi_replace("[\n|\r|\n\r]",' ',$row['observacion'])))."',".$row['base'].",".$row['iva'].",".$row['total'].",'".$row['impreso']."',".$row['totalitems'].",".$row['sucursalid'].",'".$row['nrodocref']."','".$row['creador']."','".$row['momento']."');";
		$cont.= $linea.Chr(13).Chr(10); 
		$nombresincro = $row['tipodoc'].$row['prefijo'].$row['numero'];
	 }  

	 //// Comando *SEL-DOCUID
	 $linea = "|SELECTUNO|SELECT docuid FROM documentos WHERE CONCAT(tipodoc,prefijo,numero)='".$nombresincro."'";
	 $cont .= $linea.Chr(13).Chr(10); 
	 
	 /// Genero 2 Tipos de Documento - 1 de Salida de la Bodega de Origen y otro de Entrada Normal
	 
	 //// Detalles del Documento
	 $vsql="SELECT * FROM dedocumentos WHERE docuid=".$docuid;
	 $conex  = $clase->Conectar();
     $result = mysql_query($vsql,$conex);
	 
	 $cont1 = $cont;   /// Bodega Origen
	 $cont2 = $cont;   /// Bodega Destino

	 
	 while($row = @mysql_fetch_array($result))
	 {
        $linea = "**INSERT INTO dedocumentos(docuid,productoid,bodegaid,cantidad,unidades,valunitario,valdescuento,valparcial,porciva,valbase,valiva,valtotal) VALUES(|||||,".$row['productoid'].",".$row['bodegaid'].",".$row['cantidad'].",".$row['unidades'].",".$row['valunitario'].",".$row['valdescuento'].",".$row['valparcial'].",".$row['porciva'].",".$row['valbase'].",".$row['valiva'].",".$row['valtotal'].");";	    
		$cont1.= $linea.Chr(13).Chr(10);  		 
        $linea = "**INSERT INTO dedocumentos(docuid,productoid,bodegaid,cantidad,unidades,valunitario,valdescuento,valparcial,porciva,valbase,valiva,valtotal) VALUES(|||||,".$row['productoid'].",".$row['bodegaid'].",".$row['cantidad'].",".$row['unidades'].",".$row['valunitario'].",".$row['valdescuento'].",".$row['valparcial'].",".$row['porciva'].",".$row['valbase'].",".$row['valiva'].",".$row['valtotal'].");";		
		$cont2.= $linea.Chr(13).Chr(10);  		 
	 }  

	 //// Docutranfe
	 $vsql="SELECT * FROM docutranfe WHERE docuid=".$docuid;
	 $conex  = $clase->Conectar();
     $result = mysql_query($vsql,$conex);
	 while($row = mysql_fetch_array($result))
	 {
	    $bodegades  = $row['bodegaiddes'];
		$bodegaori  = $row['bodegaidori'];		
		$codbodegaori = $clase->BDLockup($bodegaori,"bodegas","bodegaid","codbodega"); 
		$codbodegades = $clase->BDLockup($bodegades,"bodegas","bodegaid","codbodega");
		$carpetaori = $clase->SeleccionarUno("SELECT codigo FROM sucursales S INNER JOIN bodegas B ON (B.sucursalid = S.sucursalid) WHERE B.bodegaid = ".$bodegaori);
		$carpetades = $clase->SeleccionarUno("SELECT codigo FROM sucursales S INNER JOIN bodegas B ON (B.sucursalid = S.sucursalid) WHERE B.bodegaid = ".$bodegades);

		$linea = "***INSERT INTO docutranfe(docuid,bodegaidori,bodegaiddes,kardexori,kardexdes,codbarra,enviado,planogen) VALUES(|||||,".$row['bodegaidori'].",".$row['bodegaiddes'].",'".$row['kardexori']."','".$row['kardexdes']."','".$row['codbarra']."','".$row['enviado']."','S');";
		$cont1.= $linea.Chr(13).Chr(10);  		 
		$cont2.= $linea.Chr(13).Chr(10);  		 
	 }    
	 
	 ///////////////////////////////////////////////////////////////////////////
	 ///// Si ORIGEN es diferente a la bodega Actual la envio
	 ///////////////////////////////////////////////////////////////////////////
	 if(substr($codbodegaori,0,2) != substr($_SESSION['G_BODEGAPREDETPOS'],0,2))
	 {	   
	   $directorio = "../../../Dropbox/Todos/".$carpetaori."/automatico/"; 
	   $archivo    = "../../../Dropbox/Todos/".$carpetaori."/automatico/".$nombresincro.".txt"; 
	   $archivoz   = "../../../Dropbox/Todos/".$carpetaori."/automatico/DES".$nombresincro.".zip"; 
	   $archivod   = "../../../Dropbox/Todos/".$carpetaori."/transferencias/".$nombresincro.".txt"; 

       if(file_exists($archivo))
	      unlink($archivo);
		  
       //// Creo nuevamente el Archivo con el nuevo contenido
	   $fch= fopen($archivo, "w"); // Abres el archivo para escribir en él
       if($fch)
	   {
	    fwrite($fch, $cont1); // Grabas
        fclose($fch); // Cierras el archivo	 
	   }

       //// Creo nuevamente el Archivo con el nuevo contenido
	   $fch= fopen($archivod, "w"); // Abres el archivo para escribir en él
       if($fch)
	   {
	    fwrite($fch, $cont1); // Grabas
        fclose($fch); // Cierras el archivo	 
	   }

	   //// Lo comprimo en ZIP
	   include('../../lib/pclzip/pclzip.lib.php');
	   $archive = new PclZip($archivoz);
       $archive->add($archivo, PCLZIP_OPT_REMOVE_PATH, $directorio);
       //// Despues de Comprimirlo - Lo Elimino
       unlink($archivo); 
     }    
     
	   ///////////////////////////////////////////////////////////////////////////
 	   /////  DESTINO es diferente a la bodega Actual la envio
	   ///////////////////////////////////////////////////////////////////////////
	   if($codbodegades == "50")
	     $archivo= "../../../Dropbox/00/transferencias/".$nombresincro.".txt"; 
	   else
	   {
         if(($carpetades == "51")||($carpetades == "52")||($carpetades == "53")||($carpetades == "54"))
	 	   $archivo= "../../../Dropbox/".$carpetades."/transferencias/".$nombresincro.".txt"; 
	 	 else
	 	   $archivo= "../../../Dropbox/Todos/".$carpetades."/transferencias/".$nombresincro.".txt"; 	
	   }	

     //// Elimino el Archivo
     if(file_exists($archivo))
	   unlink($archivo);
     
	   //// Creo nuevamente el Archivo con el nuevo contenido	 
	   $fch= fopen($archivo, "w"); // Abres el archivo para escribir en él
     if($fch)
	   {
	     fwrite($fch, $cont2); // Grabas
       fclose($fch); // Cierras el archivo	 
	   }
	 	  
  }  //// Fin de la Funcion

?>