
var nroDeFilas;
var tabla;
var currentNodeInput; 

var stiloFila;
var stiloCelda;


//Establezco la variableglobal nro de Filas, pasando como argumento el id de la tabla
function establecerTabla(nombreTabla){	
	tabla = document.getElementById(nombreTabla);
	nroDeFilas = tabla.tBodies[0].rows.length;
	console.log("Total Filas: " + nroDeFilas );
}


//Usada para establecer los elementos que dispara los eventos en la fila
//los parametros son:
//1 Columna o celda de la fila que dispara el evento
//2 Arreglo con las demas celdas que recibel el resultado en el orden de la respuesta del servidor
//3 url - proceso del lado del servidor que procesa la solicitud
function establecerTriggerDeFila(idTrigger, resultados, url){
	for(var i = 0; i < nroDeFilas; i++){
		var tdElem = tabla.querySelector('#'+idTrigger + (i+1));
		tdElem.classList.add("overtd");
		establecerEventosTrigger(tdElem, resultados, url, idTrigger);
	}	
}


//Permite asignar formato al texto con base a un predicado y el valor de la celda
//Ej: tdOnchange("tienep", "gris", " >= 0", " && " , " <= 60");
function tdOnchange(idElement, color, prdicado, signo, predicado2){
	for(var i = 0; i < nroDeFilas; i++){
		$('#' + idElement + (i+1) ).bind("DOMSubtreeModified",function(e){
			var val = e.target.textContent.replace(",",""); //elimina las comas del formato
			if( val != NaN && val != ""){				
				if(signo != NaN && signo != "" && signo != null){
					if (eval(val + prdicado + signo + val + predicado2 )) {
						if (!e.target.className.includes(color)) {							
							e.target.className += " " + color;
						}
					}
				}else{
					if (eval(val + prdicado)) {
						if (!e.target.className.includes(color)) {
							e.target.className += " " + color;
						}
					}else{
						if (e.target.className.includes(color)) {							
							e.target.className = e.target.className.replace( " "+color , "");
						}
					}					
				}	
			}//fin del if validador 			
		});
	}//fin del for	
}


function highLightElement(idElement, color) {
	$('#' + idElement).unbind().bind("DOMSubtreeModified", function(e) {
		if(e.target.innerHTML !== ""){
			$(this).effect("highlight", {color: color}, 1050);
		}
	});
}


function establecerEventosTrigger(tdElem, resultados, url, trigger){
	tdElem.addEventListener("click", function(){cambiarElemento(tdElem, "click", event, resultados, url, trigger);},false);
	// tdElem.addEventListener("blur", function(){cambiarElemento(tdElem, "blur", event, resultados, url);},false);
}


//interacciona entre input text y el contenido de la celda
function cambiarElemento(tdElem, evento, e, resultados, url, trigger){	
	var valor = tdElem.textContent;

	try{//si el evento es click y el hijo del td es un nodo de texto (type=3)
		if (evento == "click" && e.target.firstChild.nodeType == 3) {
			var nodoInput = nuevoNodo(valor);

			tdElem.innerHTML = "";
			tdElem.appendChild(nodoInput);
			//descomente la siguiente linea si desea que el cursor quede al final
			// nodoInput.value = nodoInput.value;	
			nodoInput.focus();
			nodoInput.addEventListener("blur",function(){reestablecerValor(tdElem, event, resultados, url, trigger); },false);
			nodoInput.addEventListener("keypress",function(){reestablecerValorEnter(tdElem, event); },false);			
		} //fin del if
	}catch(exception){
		console.log("Error----");
	}	

	
}


//reestablece el valor en la celda al oprimir la tecla enter
function reestablecerValorEnter(tdElem, e){	
	if (e.keyCode == 13) {
		// var valorActual = formatoMiles(e.target.value.replace(",",""));
		var valorActual = number_format(e.target.value.replace(",",""),4);

		if ("NaN" == valorActual ) {
			e.target.className += " errorInput";	
			event.preventDefault();
		} else {			
			tdElem.innerHTML = "";
			tdElem.appendChild(document.createTextNode(number_format(valorActual,2)));
		}
	}//fin if principal
}


// function reestablecerValorEnter(tdElem, e){	
// 	if (e.keyCode == 13) {
// 		var valorActual = formatoMiles(e.target.value.replace(",",""));
// 		if ("NaN" == valorActual || 0 == valorActual) {
// 			console.log("Evento Teclado :" );
// 			e.target.className += " errorInput";			
// 			event.preventDefault();
// 		} else {			
// 			tdElem.innerHTML = "";
// 			tdElem.appendChild(document.createTextNode(valorActual));
// 		}
// 	}//fin if principal
// }


 
//reestablece el valor en la celda al perder el foco
//Solamente este metodo hace la llamda asincronica
function reestablecerValor(tdElem, e, resultados, url, campo){	
	console.log("--------------" + e.target.value);

	// var valorActual = formatoMiles(e.target.value.replace(",",""),4);	
	var valorActual = number_format(e.target.value.replace(",",""),4)
	
	console.log("++++++++++++++" + valorActual);

	console.log("Valor: " + valorActual);
	if ("NaN" == valorActual ) {
		e.target.className += " errorInput";		
		event.preventDefault();		
	} else {
		var id = e.target.parentNode.parentNode.getAttribute("data-value");/// esto cambiarlo por un iput hidden
		var fila = e.target.parentNode.parentNode.getAttribute("id");
		url += id+"&"+campo+"="+valorActual.replace(",","");//quitamos las comas
		console.log("*Async Request* " + url);
		actualizarRegistros(fila, resultados, url, tdElem);
		tdElem.innerHTML = "";
		tdElem.appendChild(document.createTextNode(number_format(valorActual,2)));		
	}
}

//metodo Ajax
function actualizarRegistros(fila, resultados, url, tdElem){
	var fila = fila;
		stiloCelda = tdElem.className;
		//reestablece el estilo de la fila
		stiloFila = tdElem.parentNode.className.replace(new RegExp(' highlight', 'g'),'');
	try {
		asyncRequest = new XMLHttpRequest();
		asyncRequest.addEventListener("readystatechange",function(){
										stateChange(fila,resultados, tdElem)}, false);
		asyncRequest.open("GET", url, true);
		asyncRequest.send(null);
	} catch (excepcion){}	
}
	

function stateChange(fila,resultados, tdElem) {
	var tdelement = tdElem;			
	//Estilos aplicados mientras se procesa la solicitud
	if(asyncRequest.readyState >= 1 &&	asyncRequest.readyState <= 3 ){
		if( !tdelement.className.includes(" spinner") ){
			tdelement.className += " spinner";
			tdelement.parentNode.className = "";
		}		
	}
	if (asyncRequest.readyState == 4 && asyncRequest.status == 200) {		
		var response = asyncRequest.responseText.split(';');		
		var resultados = resultados.split(',');	
		console.log(response);	
		if (response != "invalid") {			
			//valido que la respuesta contenga el mismo nro de element de resultados	
			if (resultados.length == response.length && resultados != "") {
				for (var i = 0; i < resultados.length; i++) {

					if(resultados[i].substr(0,2)=="G_"){
						document.getElementById(resultados[i].substr(2,resultados[i].length)).innerHTML="";
						document.getElementById(resultados[i].substr(2,resultados[i].length)).appendChild(
													document.createTextNode( response[i] ));
					}else{
						console.log(resultados[i] + fila);
						document.getElementById(resultados[i] + fila).innerHTML="";
						document.getElementById(resultados[i] + fila).appendChild(
													document.createTextNode( response[i] ));
					}
				}				
				tdelement.className = "";
				tdelement.className = stiloCelda;


				//si antes se ingreso un valor invalido tiene el estio de erro la celda
				//se le elimina este estilo
				if (tdelement.className.includes("errorInput")) {							
					tdelement.className = tdelement.className.replace( " errorInput" , "");
				}
				tdelement.parentNode.className += stiloFila + " highlight";	
				console.log("1 Clase de la fila: " + tdelement.parentNode.className);
			} else {
				//proceso para actualizacion de campo simple sin resultados
				if(resultados=="" && response.length == 1){
					tdelement.className = "";
					tdelement.className = stiloCelda;
					//si antes se ingreso un valor invalido tiene el estio de erro la celda
					//se le elimina este estilo
					if (tdelement.className.includes("errorInput")) {
						tdelement.className = tdelement.className.replace(" errorInput", "");
					}
					tdelement.parentNode.className += stiloFila + " highlight";
					console.log("2 Clase de la fila: " + tdelement.parentNode.className);

				}else{
					console.error("La respuesta recibida no coincide con el nro de campos de la fila");
					tdelement.className = "";
					tdelement.className = stiloCelda;					
				}
			}

		}else{// cuando se ingresa un valor invalido 
			if(response.length == 1){
				if(response[0] == "invalid"){
					tdelement.className = "";
					tdelement.className = stiloCelda;
					tdelement.className += " errorInput";
					tdelement.parentNode.className += stiloFila;
					$(function() {  
						$(tdelement).tooltip({ 
										content: "Debe ingresar un valor consistente",
										disabled: true,								
											 });
						
						$(tdelement).tooltip('enable').tooltip('open');
					});
					console.log("Valor de error recibido: " + response[0]);
					event.preventDefault();							
				}
			}//fin del if interno del else
		} //fin del else interno		
	}//end if principal 
} 


function nuevoNodo(contenido){
	var input = document.createElement("input");
	input.type = "text";
	input.value = contenido;
	input.setAttribute("class", "activeInput");
	input.focus();
    input.setSelectionRange(0,(contenido.length+1));
	return input;	
}


function formatoMiles(n, dp) {
	var s = '' + (Math.floor(n)),
		d = n % 1,
		i = s.length,
		r = '';
	while ((i -= 3) > 0) {
		r = ',' + s.substr(i, 3) + r;
	}
	return s.substr(0, i + 3) + r + (d ? '.' + Math.round(d * Math.pow(10, dp || 2)) : '');
}

function number_format(amount, decimals) {

    amount += ''; // por si pasan un numero en vez de un string
    amount = parseFloat(amount.replace(/[^0-9\.]/g, '')); // elimino cualquier cosa que no sea numero o punto

    decimals = decimals || 0; // por si la variable no fue fue pasada

    // si no es un numero o es igual a cero retorno el mismo cero
    if (isNaN(amount) || amount === 0) 
        return parseFloat(0).toFixed(decimals);

    // si es mayor o menor que cero retorno el valor formateado como numero
    amount = '' + amount.toFixed(decimals);

    var amount_parts = amount.split('.'),
        regexp = /(\d+)(\d{3})/;

    while (regexp.test(amount_parts[0]))
        amount_parts[0] = amount_parts[0].replace(regexp, '$1' + ',' + '$2');

    return amount_parts.join('.');
}




/***JAVA SCRIPT PARA VENTANA DE VENTAS | MODULO RECARGAS***/
function iniciar(){

	var btnRecarga = document.getElementById("ventarecarga");
	btnRecarga.addEventListener("click", function(){abrirModuloRecarga()}, false);
}

function abrirModuloRecarga(){
	var x = (screen.width/2)-210;
    var y = (screen.height/2)-400;
	
	console.log("x: " + x + " - y: " +  y);
	var strWindowFeatures = "scrollbars=no,resize=false,width=500,height=670,left="+ x + ",top=" + y;
	// window.open(strUrl, strWindowName, [strWindowFeatures])
	window.open("recargamodulo.html", "Venta de Recargas", strWindowFeatures);
}

window.addEventListener('load',iniciar,false);

