<?php
//============================================================+
// File name   : example_009.php
// Begin       : 2008-03-04
// Last Update : 2010-12-04
//
// Description : Example 009 for TCPDF class
//               Test Image
//
// Author: Nicola Asuni
//
// (c) Copyright:
//               Nicola Asuni
//               Tecnick.com LTD
//               Manor Coach House, Church Hill
//               Aldershot, Hants, GU12 4RQ
//               UK
//               www.tecnick.com
//               info@tecnick.com
//============================================================+

/**
 * Creates an example PDF TEST document using TCPDF
 * @package com.tecnick.tcpdf
 * @abstract TCPDF - Example: Test Image
 * @author Nicola Asuni
 * @since 2008-03-04
 */

require_once('../config/lang/eng.php');
require_once('../tcpdf.php');

// create new PDF document
$pdf = new TCPDF(PDF_PAGE_ORIENTATION, PDF_UNIT, PDF_PAGE_FORMAT, true, 'UTF-8', false);

// set document information
$pdf->SetCreator(PDF_CREATOR);
$pdf->SetAuthor('Nicola Asuni');
$pdf->SetTitle('TCPDF Example 009');
$pdf->SetSubject('TCPDF Tutorial');
$pdf->SetKeywords('TCPDF, PDF, example, test, guide');

// set default header data
$pdf->SetHeaderData(PDF_HEADER_LOGO, PDF_HEADER_LOGO_WIDTH, PDF_HEADER_TITLE.' 009', PDF_HEADER_STRING);

// set header and footer fonts
$pdf->setHeaderFont(Array(PDF_FONT_NAME_MAIN, '', PDF_FONT_SIZE_MAIN));
$pdf->setFooterFont(Array(PDF_FONT_NAME_DATA, '', PDF_FONT_SIZE_DATA));

// set default monospaced font
$pdf->SetDefaultMonospacedFont(PDF_FONT_MONOSPACED);

//set margins
$pdf->SetMargins(PDF_MARGIN_LEFT, PDF_MARGIN_TOP, PDF_MARGIN_RIGHT);
$pdf->SetHeaderMargin(PDF_MARGIN_HEADER);
$pdf->SetFooterMargin(PDF_MARGIN_FOOTER);

//set auto page breaks
$pdf->SetAutoPageBreak(TRUE, PDF_MARGIN_BOTTOM);

//set image scale factor
$pdf->setImageScale(PDF_IMAGE_SCALE_RATIO);

//set some language-dependent strings
$pdf->setLanguageArray($l);

// -------------------------------------------------------------------

// add a page
$pdf->AddPage();

// set JPEG quality
$pdf->setJPEGQuality(75);

// Image method signature:
// Image($file, $x='', $y='', $w=0, $h=0, $type='', $link='', $align='', $resize=false, $dpi=300, $palign='', $ismask=false, $imgmask=false, $border=0, $fitbox=false, $hidden=false, $fitonpage=false)

// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

// Example of Image from data stream ('PHP rules')
$imgdata = base64_decode(
'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');
//$imgdata = base64_decode(
//'iVBORw0KGgoAAAANSUhEUgAAABwAAAASCAMAAAB/2U7WAAAABlBMVEUAAAD///+l2Z/dAAAASUlEQVR4XqWQUQoAIAxC2/0vXZDrEX4IJTRkb7lobNUStXsB0jIXIAMSsQnWlsV+wULF4Avk9fLq2r8a5HSE35Q3eO2XP1A1wQkZSgETvDtKdQAAAABJRU5ErkJggg==');


// The '@' character is used to indicate that follows an image data stream and not an image file name
$pdf->Image('@'.$imgdata);

// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

// Image example with resizing
$pdf->Image('../images/image_demo.jpg', 15, 140, 75, 113, 'JPG', 'http://www.tcpdf.org', '', true, 150, '', false, false, 1, false, false, false);

// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

// test fitbox with all alignment combinations

$horizontal_alignments = array('L', 'C', 'R');
$vertical_alignments = array('T', 'M', 'B');

$x = 15;
$y = 35;
$w = 30;
$h = 30;
// test all combinations of alignments
for ($i = 0; $i < 3; ++$i) {
	$fitbox = $horizontal_alignments[$i].' ';
	$x = 15;
	for ($j = 0; $j < 3; ++$j) {
		$fitbox{1} = $vertical_alignments[$j];
		$pdf->Rect($x, $y, $w, $h, 'F', array(), array(128,255,128));
//		$pdf->Image('../images/image_demo.jpg', $x, $y, $w, $h, 'JPG', '', '', false, 300, '', false, false, 0, $fitbox, false, false);
		$x += 32; // new column
	}
	$y += 32; // new row
}

$x = 115;
$y = 35;
$w = 25;
$h = 50;
for ($i = 0; $i < 3; ++$i) {
	$fitbox = $horizontal_alignments[$i].' ';
	$x = 115;
	for ($j = 0; $j < 3; ++$j) {
		$fitbox{1} = $vertical_alignments[$j];
		$pdf->Rect($x, $y, $w, $h, 'F', array(), array(128,255,255));
		$pdf->Image('../images/image_demo.jpg', $x, $y, $w, $h, 'JPG', '', '', false, 300, '', false, false, 0, $fitbox, false, false);
		$x += 27; // new column
	}
	$y += 52; // new row
}

// - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -

// Stretching, position and alignment example

$pdf->SetXY(110, 200);
$pdf->Image('../images/image_demo.jpg', '', '', 40, 40, '', '', 'T', false, 300, '', false, false, 1, false, false, false);
$pdf->Image('../images/image_demo.jpg', '', '', 40, 40, '', '', '', false, 300, '', false, false, 1, false, false, false);

// -------------------------------------------------------------------

//Close and output PDF document
$pdf->Output('example_009.pdf', 'I');

//============================================================+
// END OF FILE
//============================================================+
