<?php
  session_start(); 
 
/* 
 * Clase de acceso a datos del Webservice
 * @author Ing. Said Rodriguez
 * @version: 31/08/2016
 */

class WebServiceDB {
    
    protected $mysqli;

    /**
     * Constructor de clase
     */
    public function __construct() 
    {           
        try{
            //conexión a base de datos
            $this->mysqli = new mysqli("localhost" , "root" , "123" , "farmanorte27db");
        }catch (mysqli_sql_exception $e){
            //Si no se puede realizar la conexión          
            http_response_code(400);
            exit;
        } 
    } 
    
    /**
     * obtiene un solo registro dado su ID
     * @param int $id identificador unico de registro
     * @return Array array con los registros obtenidos de la base de datos
     */
    public function getDatosRemision($id=0){      
        $stmt = $this->mysqli->prepare("SELECT * FROM documentos D INNER JOIN dedocumentos DD ON (D.docuid = DD.docuid) WHERE D.docuid=? ; ");
        $stmt->bind_param('s', $id);
        $stmt->execute();
        $result = $stmt->get_result();        
        $peoples = $result->fetch_all(MYSQLI_ASSOC); 
        $stmt->close();
        return $peoples;              
    }
    
    /**
     * obtiene todos los registros de la tabla "people"
     * @return Array array con los registros obtenidos de la base de datos
     */
    public function getUsuarios(){        
        $result = $this->mysqli->query('SELECT * FROM usuarios');          
        $peoples = $result->fetch_all(MYSQLI_ASSOC);          
        $result->close();
        return $peoples; 
    }
    
    /**
     * añade un nuevo registro en la tabla persona
     * @param String $name nombre completo de persona
     * @return bool TRUE|FALSE 
     */
    public function crearDocumentoRemision($ob)
    {
        $stmt = $this->mysqli->prepare("INSERT INTO documentos(tipodoc,prefijo,numero,fechadoc,periodo,observacion,totalitems,
                                        nrodocref,sucursalid,total,creador,momento) VALUES ('TXC',?,?,?,?,?,?,?,?,?,?,?);");
        $stmt->bind_param('sssssisidss', $ob->prefijo , $ob->numero , $ob->fechadoc , $ob->periodo , $ob->observacion , $ob->totalitems , $ob->nrodocref , $ob->sucursalid , $ob->total , $ob->creador , $ob->momento);
        
        $r = $stmt->execute();         
        return $stmt->insert_id;
        $stmt->close();        
    }
    
    /**
     * añade un nuevo registro en la tabla persona
     * @param String $name nombre completo de persona
     * @return bool TRUE|FALSE 
     */
    public function limpiarDocumentoRemision($docuid)
    {
        /// Elimino los detalles
        $stmt = $this->mysqli->prepare("DELETE FROM dedocumentos WHERE docuid = ?;");
        $stmt->bind_param('i', $docuid);
        $r = $stmt->execute();         
        $stmt->close();        
        return;
    }

    /**
     * añade un nuevo registro en la tabla persona
     * @param String $name nombre completo de persona
     * @return bool TRUE|FALSE 
     */
    public function crearDetalleRemision($DOCUID,$ob)
    {
        $stmt = $this->mysqli->prepare("INSERT INTO dedocumentos(docuid,productoid,bodegaid,cantidad,unidades,tipund,costoprod,
                                        valunitario,valparcial,valtotal,unicom,unifra) VALUES (?,?,?,?,?,?,?,?,?,?,?,?);");
        $stmt->bind_param('iiiiisddddii', $DOCUID , $ob->productoid , $ob->bodegaid , $ob->cantidad , $ob->unidades , $ob->tipund , $ob->costoprod , $ob->valunitario , $ob->valparcial , $ob->valtotal , $ob->unicom , $ob->unifra);
        $r = $stmt->execute(); 
        $stmt->close();
        return $r;        
    }

    /**
     * elimina un registro dado el ID
     * @param int $id Identificador unico de registro
     * @return Bool TRUE|FALSE
     */
    public function delete($id=0) {
        $stmt = $this->mysqli->prepare("DELETE FROM usuarios WHERE usuid = ? ; ");
        $stmt->bind_param('s', $id);
        $r = $stmt->execute(); 
        $stmt->close();
        return $r;
    }
    
    /**
     * Actualiza registro dado su ID
     * @param int $id Description
     */
    public function update($id, $newName , $newPass) {
        if($this->checkID($id)){
            $stmt = $this->mysqli->prepare("UPDATE usuarios SET username=? , clave = ? WHERE usuid = ? ; ");
            $stmt->bind_param('sss', $newName,$newPass,$id);
            $r = $stmt->execute(); 
            $stmt->close();
            return $r;    
        }
        return false;
    }
    
    /**
     * verifica si un ID existe
     * @param int $id Identificador unico de registro
     * @return Bool TRUE|FALSE
     */
    public function checkID($id){
        $stmt = $this->mysqli->prepare("SELECT * FROM usuarios WHERE usuid=?");
        $stmt->bind_param("s", $id);
        if($stmt->execute()){
            $stmt->store_result();    
            if ($stmt->num_rows == 1){                
                return true;
            }
        }        
        return false;
    }
    
}
?>