<?php

include("../../lib/Sistema.php");

/**
 * Clase API del WebService
 * Permite hacer las 4 Actividades Básicas CRUD a la Tabla Existencias
 * Desde WebService
 * @author Said Rodriguez
 * @version 2017-01-28
 */

class api
{
	private $db;

	/**
	 * Constructor - Abre una conexion a la Base de Datos
	 *
	 * @param Vacío
	 * @return Conexion a la Base de Datos
	 */
	
	function __construct()
	{
		$clase = new Sistema();
		$this->db = new mysqli($clase->ServidorBD,$clase->UsuarioBD,$clase->ClaveBD,$clase->NombreBD);
	}

	/**
	 * Destructor - close DB connection
	 *
	 * @param Vacío
	 * @return Vacío
	 */

	function __destruct()
	{
		$this->db->close();
	}

	/**
	 * Obtiene la existencia en Sucursales del Producto consultado
	 * @param ID del Producto	 
	 * @return Lista de Existencia por Bodegas en Formato JSON
	 */
	function getSaldoCreditos($params)
	{
		/// Variable de Retorno del Servicio
		$retorno = 0;

		$clase = new Sistema();
		
		//// Evaluamos si tiene Facturas Vencidas
		$tieneVencidas = $clase->SeleccionarUno("SELECT COUNT(*) FROM terceros WHERE (codvende <> '' OR coddomi <> '') AND rolempresa <> '' AND cupocredito > 0 AND inactivo = '' AND dni = '".$params['id']."'");
        if($tieneVencidas > 0)
		    $retorno = 1;
		else
		    $retorno = 0;

		return($retorno);
	}

} /// Fin de la Clase API
