<?PHP
    @session_start(); 
    include("lib/Sistema.php");  
  
    $clase = new Sistema();
    $clase->Nombredb = $_SESSION['DBNOMBRE'];  
    $avisos = ""; 
    $opcion = "";
    $opcion = $_GET["opcion"];

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: crudcantminima
    // Creación: 24/01/2024		última modificación: 09/05/2024
    // Creador: Luis Flórez		modificado por: Luis Flórez
    // Descripción: Opción que pinta la ventana para el crud de productos con cantidades 
    //              mínimas
    // Última modificación: Validación de los botones de errores y de limpiar
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "crudcantminima")
    {
		// consulta del formulario
		if($_SESSION['SQL_CANTIDADMINIMA'] == "")
			$vsql = "SELECT em.minimaid, p.codigo, p.descripcion, gp.descripcion nomlabo, b.nombodega, em.cantidadminima
                       FROM existenciasminimas em
                            INNER JOIN productos p ON (em.productoid = p.productoid)
                            INNER JOIN gruposprod gp ON (p.gruposprodid = gp.gruposprodid)
                            INNER JOIN bodegas b ON (b.bodegaid = em.bodegaid)           
                   ORDER BY em.productoid, b.bodegaid";
		else
			$vsql = $_SESSION['SQL_CANTIDADMINIMA'];

		// inicializo las variables
        $det = '';
		$pie.=' </tbody>
			   </table>';

        // valido que el archivo de mostrar errores exista
        $archivoerror = "reportes/erroresexitmin.txt";
        if (file_exists ($archivoerror))
            $htmlarchivoerror = '<a href="?opcion=vererrores" rel="facebox">
                                  <img src="images/iconos/notas.png" border="0" width="38" height="38" title="c&oacute;digos de productos no guardados en el &uacute;ltimo proceso de importaci&oacute;n">
                                 </a>';
        else
            $htmlarchivoerror = '<img src="images/iconos/notas.png" border="0" width="38" height="38" title="c&oacute;digos de productos no guardados en el &uacute;ltimo proceso de importaci&oacute;n">';               

        // Validación de los botones de limpiar y el informe
        $vsql3 = "SELECT COUNT(*) numminimos FROM existenciasminimas";
        $numminimos = $clase->SeleccionarUno($vsql3);

        if($numminimos > 0)
        {
            $htmllimpiar = '<a href="?opcion=confirmarlimpiar" rel="facebox">
                             <img src="images/iconos/anulardoc.png" border="0" width="38" height="38" title="limpiar toda la lista de productos con existencias m&iacute;nimas">
                            </a>';
            $htmoinforme = '<a href="?opcion=filtrarcedi" rel="facebox">
                             <img src="images/iconos/informe2.png" border="0" width="38" height="38" title="informe de existencias m&iacute;nimas por cedi">
                            </a>';
        }
        else
        {
            $htmllimpiar = '<img src="images/iconos/anulardoc.png" border="0" width="38" height="38" title="no existen productos con existencias m&iacute;nimas">';
            $htmoinforme = '<img src="images/iconos/informe2.png" border="0" width="38" height="38" title="informe de existencias m&iacute;nimas por cedi">';
        }

		// pinto la ventana
		$enc =  $clase->HeaderBlanco("existencias mínimas");
		$enc.=' <table width="1300">
		         <tr class="CabezoteTabla"> 
		          <td width="10"> &nbsp; </td>
		          <td width="37"> <img src="images/iconos/cuotas.png" width="32" height="32" border="0"> </td>
		          <td width="830"> <b> Existencias m&iacute;nimas de productos por cedi </b> </td>
                  <td width="30">
                   <a href="?opcion=ventananuevacantminima" rel="facebox">
                    <img src="images/iconos/nuevodoc.png" width="32" height="32" border="0" title="incluir un nuevo registro"> 
                   </a>
                  </td>
				  <td width="10"> &nbsp; </td>
                  <form action="?opcion=encontrar" method="POST" name="x">
                  <td> <input type="text" name="criterio" size="12" style="width:250px;height:25px" placeholder="c&oacute;digo o nombre del producto a buscar" tabindex="1" id="default"> </td>
				  <td width="5"> &nbsp; </td>
                  <td> <input type="submit" value="Encontrar" class="button"> </form> </td>';

        // botón para anular la búsqueda
		if($_SESSION['SQL_CANTIDADMINIMA'] != "")
           $enc.='<td width="10"> <a href="?opcion=nofiltro"> <img src="images/iconos/devoluciones.png" width="34" height="34" border="0" title="anular &uacute;ltima b&uacute;squeda"> </a> </td>';

		$enc.='   <td width="10"> &nbsp; </td>
		          <td width="30">
		           <a href="?opcion=importarexcel1" rel="facebox">
		            <img src="images/iconos/cargar.png" width="34" height="34" border="0" title="importar productos desde una hoja de Excel">
		           </a>
		          </td>
		          <td width="10"> &nbsp; </td>
				  <td width="30"> '.$htmlarchivoerror.' </td>
		          <td width="10"> &nbsp; </td>
				  <td width="30"> '.$htmllimpiar.' </td>
				  <td width="10"> &nbsp; </td>
				  <td width="30"> '.$htmoinforme.' </td>
				  <td width="10"> &nbsp; </td>
		          <td width="50" align="center"> <a href="principal.php"> <input type="button" value="<<" class="button blue"> </a> </td> 
		          <td width="8"> &nbsp; </td>
		         </tr>
	            </table>
                <script type="text/javascript" src="lib/sorttable.js"></script>
	            <table id="fixTableV" class="sortable">
		         <tr class="TituloTabla">
		          <th width="40"> # </th>
		          <th width="130"> C&oacute;digo </th>
		          <th width="470"> Producto </th>
		          <th width="100"> Laboratorio </th>
		          <th width="100"> Bodega </th>
                  <th width="100"> Cantidad <br> m&iacute;nima </th>
                  <th width="30"> &nbsp; </th>
                  <th width="30"> &nbsp; </th>
		         </tr>';

        // impresión del detalle
        $i = 0;
        $conex  = $clase->Conectar();
        $result = mysql_query($vsql,$conex);
        while($row = mysql_fetch_array($result))
        {
            $i++;
            if($i%2 == 0)
                $det.='<tr class="TablaDocsPar">';
            else
                $det.='<tr class="TablaDocsImPar">';
            
            $det.=' <td align="center"> '.$i.' </td>
                    <td align="center"> '.$row['codigo'].' </td>
                    <td align="center"> '.$row['descripcion'].' </td>
                    <td align="center"> '.$row['nomlabo'].' </td>
                    <td align="center"> '.$row['nombodega'].' </td>
                    <td align="center"> '.number_format($row['cantidadminima']).' </td>
                    <td align="center"> 
                     <a href="?opcion=confirmareliminar&minimaid='.$row['minimaid'].'" rel="facebox">
                      <img src="images/basicas/iconoborrar.png" title="eliminar producto" border="0" width="20" height="20">
                     </a>
                    </td>
                    <td align="center">
                     <a href="?opcion=editarminimo&minimaid='.$row['minimaid'].'" rel="facebox"> 
                      <img src="images/basicas/iconobuscar.png" title="editar producto" border="0" width="20" height="20"> 
                     </a> 
                    </td>
                   </tr>';
        }

		// Construyo el contenido del formulario
        $cont = $enc.$det.$pie;

        echo $cont;
        exit();
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: ventananuevacantminima
    // Creación: 24/01/2024		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que pinta la ventana para captar los datos del nuevo registro 
    //              de productos con cantidades mínimas
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "ventananuevacantminima")
    {
        // combo bodegas
        $params = ' class="Texto12" ';
        $vsqlbodegas = "SELECT bodegaid, nombodega FROM bodegas WHERE nombodega LIKE '%DEPOSITO%'";
        $vsqlcombobodegas = $clase->CrearComboBuscar("bodegaid",$vsqlbodegas,"nombodega","bodegaid","","N",$params,250);

        // Inicialización de variables        
        $cantidadminima = 1;

		// pinto la ventana
		$cont ='<table width="400">
				 <tr class="CabezoteTabla">
				  <td width="50" align="left"> <img src="images/iconos/nuevodoc.png" width="32" height="32" border="0"> </td>
				  <td width="350" align="center"> <b>Incluir Producto</b> <br> </td>
				 </tr> 
				</table>
				<form action="?opcion=guardarnewminima" method="POST" name="x">
				<table width="400">
				 <center><br>
				 <tr class="TablaDocsImPar">
				  <td width="100" align="right"><label class="Texto12"> Producto: </label>&nbsp;</td>
				  <td width="300">				   
                   <!-- ************************************************************************************************ -->
                   <!-- AJAX AUTOSUGGEST SCRIPT -->
                   <script type="text/javascript" src="lib/ajax_framework8.js"></script>
                   <style type="text/css">
                   #search-wrap8 input{font-size:12px; text-transform:Capitalize; background-color:#D6F0FE; border-style:groove;}
                   #res8{width:195px; border:solid 1px #DEDEDE; display:none;}
                   #res8 ul, #res8 li{padding:0; margin:0; border:0; list-style:none; background:#F6F6F6;}
                   #res8 li {border-top:solid 1px #DEDEDE; background:#CEEAF5;}
                   #res8 li a{display:block; padding:2px; text-decoration:none; color:#000000; font-weight:bold; font-size:10px; font-family:Verdana;}
                   #res8 li a small{display:block; text-decoration:none; color:#999999; font-weight:normal; font-size:9px;font-family:Verdana;}
                   #res8 li a:hover{background:#FFFFFF;}
                   #res8 ul {padding:4px;}
                   </style>
                   <div id="search-wrap8">
                   <input name="producto" autocomplete="off" onkeypress="return TabulaEnter(this, event)" id="search-q8" type="text" onkeyup="javascript:autosuggest8();" maxlength="33" size="33" autocomplete="off" tabindex="1"/>
                   <div id="res8"></div>
                   </div>
                   <!-- AJAX AUTOSUGGEST SCRIPT -->
                   <!-- ************************************************************************************************ -->
				  </td>
				 </tr>	
				 <tr class="TablaDocsImPar">
				  <td width="100" align="right"><label class="Texto12"> Bodega: </label>&nbsp; </td>
				  <td width="300">
                   '.$vsqlcombobodegas.'
				  </td>
				 </tr>
				 <tr class="TablaDocsImPar">
				  <td width="100" align="right"><label class="Texto12"> Cant m&iacute;nima: </label>&nbsp; </td>
				  <td width="300">
                   <input type="number" name="cantidadminima" min="1" size="32" class="Texto11" style="width:90px;height:25px" autocomplete="off" value="'.$cantidadminima.'">
				  </td>
				 </tr>
				</table>
				<br>
				<center>
				<input type="submit" value="aceptar" class="button blue">
				<a href="existenciasminimas.php?opcion=crudcantminima"><input type="button" value="CANCELAR" class="button red"></a>
				</form><br>';
		echo $cont;
		exit();        
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: guardarnewminima
    // Creación: 24/01/2024		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que almacena el nuevo registro de productos con cantidades 
    //              mínimas
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "guardarnewminima")
    {
        $producto = $_POST['producto'];
		$bodegaid = $_POST['bodegaid'];
		$cantidadminima = $_POST['cantidadminima'];

        // validación del producto
        if(strlen($producto) == 0)
        {
			echo'<SCRIPT languague="javascript">
				 <!--
					alert("Debe ingresar el producto");
					window.history.back();
				 -->
				 </SCRIPT>';
			exit;
        }
        else
        {
			// obtengo el id del producto
			$productoid = $clase->BDLockup($producto,'productos','codigo','productoid');
            
			if(strlen($productoid) == 0)
			{
				echo'<SCRIPT languague="javascript">
					 <!--
						alert("Producto no existe");
						window.history.back();
					 -->
					 </SCRIPT>';
		  		exit;
			}
            else
            {
                // Valido la existencia del producto y la bodega
				$vsql2 = "SELECT COUNT(*) AS valproducto FROM existenciasminimas WHERE productoid = ".$productoid." AND bodegaid = ".$bodegaid;
				$valproducto = $clase->SeleccionarUno($vsql2);

				if($valproducto > 0)
				{
					$descripcion = $clase->BDLockup($productoid,'productos','productoid','descripcion');
                    $nombodega = $clase->BDLockup($bodegaid,'bodegas','bodegaid','nombodega');

					echo'<SCRIPT languague="javascript">
						 <!--
							alert("'.$descripcion.' ya está incluido en la bodega '.$nombodega.'");
							window.history.back();
						 -->
						 </SCRIPT>';
					exit;
				}
                else
                {
                    // Inserto el nuevo registro
                    $vsql = "INSERT INTO existenciasminimas (bodegaid,productoid, cantidadminima, creador, ultcambio) VALUE (".$bodegaid.",".$productoid.",".$cantidadminima.",'".$_SESSION['USERNAME']."',CURRENT_TIMESTAMP)";
                    $clase->EjecutarSQL($vsql);

                    echo'<SCRIPT languague="javascript">
                         <!--
                            alert("Producto incluido satisfactoriamente");
                            window.history.back();
                         -->
                         </SCRIPT>';
                    exit;
                }
            }
        }
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: confirmareliminar
    // Creación: 24/01/2024		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que pinta la ventana para confirmar la eliminación de un 
    //              producto con cantidad mínima
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "confirmareliminar")
    {
        $minimaid = $_GET['minimaid'];        

		// Obtengo el nombre del producto y de la bodega
		$productoid = $clase->BDLockup($minimaid,'existenciasminimas','minimaid','productoid');
        $bodegaid = $clase->BDLockup($minimaid,'existenciasminimas','minimaid','bodegaid');
        $cantidadminima = $clase->BDLockup($minimaid,'existenciasminimas','minimaid','cantidadminima');
        
		$descripcion = $clase->BDLockup($productoid,'productos','productoid','descripcion');
        $nombodega = $clase->BDLockup($bodegaid,'bodegas','bodegaid','nombodega');

        // Pinto la ventana
        $cont ='<table width="500">
                 <tr class="CabezoteTabla">
                  <td width="50" align="left"> <img src="images/iconos/alertas.png" width="32" height="32" border="0"> </td>
                  <td width="450" align="center"><br> <label class="Texto12"> <b> Eliminar producto </b> </label> <br><br> </td>
                 </tr> 
                </table>
                <table width="500">
                 <tr class="TablaDocsImPar"> 
                  <td width="400" align="center">
                   <label class="Texto12">
                   ¿Confirma que desea eliminar el producto <br> <b>'.trim($descripcion).'</b> <br> de la bodega <b>'.trim($nombodega).'</b> <br> de cantidad m&iacute;nima <b>'.number_format($cantidadminima).'</b>? 
                   </label> 
                  </td>
                 </tr>
                 <tr class="TablaDocsImPar">
                  <td width="400" align="center"><br><br> 
                   <form action="?opcion=eliminarminimo" method="POST">
                   <input type="hidden" name="minimaid" value="'.$minimaid.'"> 
                   <input type="submit" value="ACEPTAR" class="button blue">
                   <a href="existenciasminimas.php?opcion=crudcantminima" > <input type="button" value="CANCELAR" class="button red"> </a>
                   </form>
                   <br>
                  </td> 
                 </tr>
                </table>';
        echo $cont;
        exit();
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: eliminarminimo
    // Creación: 24/01/2024		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que elimina un producto con cantidad mínima
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "eliminarminimo")
    {
        $minimaid = $_POST['minimaid'];

		// Obtengo el nombre del producto
        $productoid = $clase->BDLockup($minimaid,'existenciasminimas','minimaid','productoid');
        $bodegaid = $clase->BDLockup($minimaid,'existenciasminimas','minimaid','bodegaid');

		$descripcion = $clase->BDLockup($productoid,'productos','productoid','descripcion');
        $nombodega = $clase->BDLockup($bodegaid,'bodegas','bodegaid','nombodega');

		// Elimino el prodcuto
		$vsql = "DELETE FROM existenciasminimas WHERE minimaid = ".$minimaid;
		$clase->EjecutarSQL($vsql);

		// emito el mensaje correspondiente
		echo'<SCRIPT languague="javascript">
			 <!--
				alert("'.$descripcion.' eliminado de la lista de producto excluidos de rotación");
				window.history.back();
			 -->
			 </SCRIPT>';
	 	exit;

		// redirecciono el formulario
		header("Location: existenciasminimas.php?opcion=crudcantminima");
    }
    
    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: editarminimo
    // Creación: 24/01/2024		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que pinta la ventana para editar los datos de un producto con 
    //              cantidad mínima
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "editarminimo")
    {
        $minimaid = $_GET['minimaid'];

		// Obtengo el nombre del producto
        $productoid = $clase->BDLockup($minimaid,'existenciasminimas','minimaid','productoid');
        $bodegaid = $clase->BDLockup($minimaid,'existenciasminimas','minimaid','bodegaid');
        $cantidadminima = $clase->BDLockup($minimaid,'existenciasminimas','minimaid','cantidadminima');

		$descripcion = $clase->BDLockup($productoid,'productos','productoid','descripcion');

        // combo bodegas
        $params = ' class="Texto12" ';
        $vsqlbodegas = "SELECT bodegaid, nombodega FROM bodegas WHERE nombodega LIKE '%DEPOSITO%'";
        $vsqlcombobodegas = $clase->CrearComboBuscar("bodegaid",$vsqlbodegas,"nombodega","bodegaid",$bodegaid,"N",$params,250);
		
		// pinto la ventana
        $cont ='<table width="400">
                 <tr class="CabezoteTabla">
                  <td width="50" align="left"> <img src="images/iconos/aspectos.png" width="32" height="32" border="0"> </td>
                  <td width="350" align="center"> <label class="Texto12"> <b>Editar producto <br> <font color="blue"> '.$descripcion.' </font> </b> </label> <br> </td>
                 </tr> 
                </table>
                <form action="?opcion=guardaredicionmin" method="POST" name="x">
                <input type="hidden" name="minimaid" value="'.$minimaid.'">
                <table width="400">
                 <center><br>
                 <tr class="TablaDocsImPar">
                  <td width="100" align="right"> <label class="Texto12"> Bodega: </label> &nbsp; </td>
                  <td width="300"> '.$vsqlcombobodegas.' </td>
                 </tr>
				 <tr class="TablaDocsImPar">
				  <td width="100" align="right"> <label class="Texto12"> Cant m&iacute;nima: </label> &nbsp; </td>
				  <td width="300">
                  <input type="number" name="cantidadminima" min="1" size="32" class="Texto11" style="width:90px;height:25px" autocomplete="off" value="'.$cantidadminima.'">
				  </td>
				 </tr>
                </table>
                <br>
                <center>
                <input type="submit" value="aceptar" class="button blue">
                <a href="existenciasminimas.php?opcion=crudcantminima"> <input type="button" value="CANCELAR" class="button red"> </a>
                </form><br>';
        echo $cont;
        exit();
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: guardaredicionmin
    // Creación: 24/01/2024		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que guarda los datos editados de un producto con cantidad mínima
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "guardaredicionmin")
    {
        $minimaid = $_POST['minimaid'];
        $bodegaid = $_POST['bodegaid'];
        $cantidadminima = $_POST['cantidadminima'];

        $productoid = $clase->BDLockup($minimaid,'existenciasminimas','minimaid','productoid');
        $bodegaidactual = $clase->BDLockup($minimaid,'existenciasminimas','minimaid','bodegaid');

        // Valido la existencia del producto y la bodega
        if($bodegaidactual != $bodegaid)
            $lbcambiabodega = true;
        else
            $lbcambiabodega = false;

        $vsql2 = "SELECT COUNT(*) AS valproducto FROM existenciasminimas WHERE productoid = ".$productoid." AND bodegaid = ".$bodegaid;
        $valproducto = $clase->SeleccionarUno($vsql2);

        if(($valproducto > 0) && $lbcambiabodega)
        {
            $descripcion = $clase->BDLockup($productoid,'productos','productoid','descripcion');
            $nombodega = $clase->BDLockup($bodegaid,'bodegas','bodegaid','nombodega');

            echo'<SCRIPT languague="javascript">
                 <!--
                    alert("'.$descripcion.' ya está incluido en la bodega '.$nombodega.'");
                    window.history.back();
                 -->
                 </SCRIPT>';
            exit;
        }
        else
        {
            // guardo los cambios
            $vsql = "UPDATE existenciasminimas SET 
                            bodegaid = ".$bodegaid.",
                            cantidadminima = ".$cantidadminima.",
                            creador = '".$_SESSION['USERNAME']."',
                            ultcambio = CURRENT_TIMESTAMP 
                      WHERE minimaid = ".$minimaid;
            $clase->EjecutarSQL($vsql);

            // emito el mensaje correspondiente
            echo'<SCRIPT languague="javascript">
                 <!--
                    alert("Producto editado satisfactoriamente");
                    window.history.back();
                 -->
                 </SCRIPT>';
            exit;
        }

		// redirecciono el formulario
		header("Location: existenciasminimas.php?opcion=crudcantminima");
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: encontrar
    // Creación: 24/01/2024		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que realiza una búsqueda por descripción o código de un producto 
    //              con cantidad mínima
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "encontrar")
    {
        $criterio = $_POST['criterio'];
        $vsql = "SELECT em.minimaid, p.codigo, p.descripcion, gp.descripcion nomlabo, b.nombodega, em.cantidadminima
                   FROM existenciasminimas em
                        INNER JOIN productos p ON (em.productoid = p.productoid)
                        INNER JOIN gruposprod gp ON (p.gruposprodid = gp.gruposprodid)
                        INNER JOIN bodegas b ON (b.bodegaid = em.bodegaid) 
                  WHERE p.descripcion LIKE '%".$criterio."%' 
				        OR p.codigo LIKE '%".$criterio."%'
               ORDER BY em.productoid, b.bodegaid";
        $_SESSION['SQL_CANTIDADMINIMA'] = $vsql;
        header("Location: existenciasminimas.php?opcion=crudcantminima");
	}    

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: nofiltro
    // Creación: 24/01/2024		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que anula una búsqueda y muestra todos los productos con 
    //              cantidad mínima
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "nofiltro")
    {
        $criterio = $_POST['criterio'];        
        $vsql = "SELECT em.minimaid, p.codigo, p.descripcion, gp.descripcion nomlabo, b.nombodega, em.cantidadminima 
                   FROM existenciasminimas em 
                        INNER JOIN productos p ON (em.productoid = p.productoid) 
                        INNER JOIN gruposprod gp ON (p.gruposprodid = gp.gruposprodid) 
                        INNER JOIN bodegas b ON (b.bodegaid = em.bodegaid) 
               ORDER BY em.productoid, b.bodegaid";
        $_SESSION['SQL_CANTIDADMINIMA'] = "";
        header("Location: existenciasminimas.php?opcion=crudcantminima");
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: importarexcel1
    // Creación: 24/01/2024		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que pinta la ventana para seleccionar la hoja de Excel desde la 
    //              cual se importarán productos con cantidad mínima
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "importarexcel1")
    {
        $cont = '';
        $servidor = $_SERVER['SERVER_NAME'].":".$_SERVER['SERVER_PORT'];

        // Validación del servidor
        // if(($servidor!="dromedicas.sytes.net:9996")&&($servidor!="192.168.14.248:9999"))
        //     $cont.='<table width="400">
        //              <tr class="CabezoteTabla"> 
        //               <td align="center"> <b>Servidor incorrecto </b></td>
        //              </tr> 
        //              <tr class="CabezoteTabla"> 
        //               <td align="center"> 
        //                <font color=red> Este servidor est&aacute; inhabilitado para hacer este <br> 
        //                proceso, por favor dir&iacute;jase al servidor </font> <br> 
        //                <font color=blue> 192.168.14.248:9999 </font> <br>
        //                <font color=red>o al servidor </font> <br> 
        //                <font color=blue> dromedicas.sytes.net:9996 </font> <br>
        //                <font color=red> para poder importar estos datos </font> <br><br>
        //               </td> 
        //              </tr>
        //              <tr class="TablaDocsPar">
        //               <td width="100%" align="center"> 
        //                <form name="importa" method="post" action="existenciasminimas.php?opcion=crudcantminima" id="theform" enctype="multipart/form-data">
        //                 <input type="submit" name="enviar" id="enviarr" value="aceptar" class="button blue" />
        //                </form> 
        //               </td>
        //              </tr>
        //             </table>';
        // else
        // {
            // pinto la ventana
            $cont.='<script type="text/javascript" src="lib/jquery-2.1.3.min.js"></script>
                    <script>
                     $(function()
                      {
                       $("#enviarr").on("click",function()
                       {
                        $(this).val("Espere por favor ...")
                        .attr("disabled","disabled");
                        $("#theform").submit();
                       });    
                      });
                    </script>
                    <table width="400">
                     <tr class="CabezoteTabla"> 
                      <td align="center"> <b>Importar productos con existencias m&iacute;nimas  </b> <br><br></td> 
                     </tr> 
                    </table>
                    <table width="400">
                     <tr class="TablaDocsPar">
                      <td width="100%" align="center"> 
                       <form name="importa" method="post" action="?opcion=importarexcel2" id="theform" enctype="multipart/form-data">                       
                       <input type="file" name="excel" /><br><br>
                       <input type="submit" name="enviar" id="enviarr"  value="Importar archivo" class="button blue" />
                       <input type="hidden" value="upload" name="action" />
                       </form> 
                      </td>
                     </tr>
                    </table>';
    
			// Impresión de la imagen de ejemplo
            $cont.='<table width="400">
                     <tr class="TablaDocsPar"> <td align="left"> &nbsp; La hoja de Excel debe tener la siguiente estructura: </td> </tr>
                     <tr class="TablaDocsPar"> <td align="left"> &nbsp; Columna <b>A</b>: C&oacute;digo del producto </td> </tr>
					 <tr class="TablaDocsPar"> <td align="left"> &nbsp; Columna <b>B</b>: Cantidad mínima </td> </tr>
					 <tr class="TablaDocsPar"> <td align="left"> &nbsp; Columna <b>C</b>: Bodega </td> </tr>
                     <tr class="TablaDocsPar"> 
                      <td align="left"> 
                       &nbsp; <font color="BLUE"><b>2</b></font> CUCUTA <font color="BLUE"><b>119</b></font> BARRANQUILLA <font color="BLUE"><b>426</b></font> BUCARAMANGA
                      </td> 
                     </tr>
                     <tr class="TablaDocsPar"> 
                      <td align="left"> 
                       &nbsp; <font color="BLUE"><b>779</b></font> MEDELLIN <font color="BLUE">
                      </td>
                     </tr>
                    </table>';
    
			// Botón de ejecutar
            $cont.='<table width="400">
                     <tr class="TablaDocsPar"> 
                      <td align="center"> 
                       <img src="images/iconos/ejemplominimas.png" width="280" height="180" border="0">
                      </td> 
                     </tr>
                     <tr class="TablaDocsPar"> 
                      <td width="100%" align="center"> 
                       <font color="blue"> Importante: Se debe utilizar un archivo de Excel con extensi&oacute;n .xlsx</font>
                      </td> 
                     </tr>
                    </table>';
        // }

        echo $cont;
        exit();
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: importarexcel2
    // Creación: 25/01/2024		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que almacena los nuevos registros de productos con cantidad 
    //              mínima que vienen desde una hoja de Excel
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "importarexcel2")
    {
		set_time_limit(0);
		extract($_POST);		
		$archivo = $_FILES['excel']['name'];
		$tipo = $_FILES['excel']['type'];
		$destino = "recursos/xls/bak_".$archivo;
        
        // Valido que la extensión del archivo sea xlsx
        $extension = pathinfo($destino, PATHINFO_EXTENSION);

        if($extension!="xlsx")
        {
            echo'<SCRIPT languague="javascript">
                 <!--
                    alert("El archivo debe tener extensión .xlsx");
                    window.history.back();
                 -->
                 </SCRIPT>';
            exit;
        }
        else
        {
            /// Valido si se cargó el archivo o no
            if (!copy($_FILES['excel']['tmp_name'],$destino))
                echo "Error Al Cargar el Archivo";
        
            if (file_exists ("recursos/xls/bak_".$archivo))
            {
                require_once('lib/PHPExcel.php');
                require_once('lib/PHPExcel/Reader/Excel2007.php');
                
                $objReader = new PHPExcel_Reader_Excel2007();
                $objPHPExcel = $objReader->load("recursos/xls/bak_".$archivo);
                $objFecha = new PHPExcel_Shared_Date();
                $objPHPExcel->setActiveSheetIndex(0);
                $conex = $clase->Conectar();
                $recorrer = true;  $i = 1;
                while($recorrer)
                {
                    $_DATOS_EXCEL[$i]['codigo'] = $objPHPExcel->getActiveSheet()->getCell('A'.$i)->getCalculatedValue();
					$_DATOS_EXCEL[$i]['cantidadminima'] = $objPHPExcel->getActiveSheet()->getCell('B'.$i)->getCalculatedValue();
					$_DATOS_EXCEL[$i]['bodegaid'] = $objPHPExcel->getActiveSheet()->getCell('C'.$i)->getCalculatedValue();
                
                    if((strlen($_DATOS_EXCEL[$i]['codigo']) == 0) || (strlen($_DATOS_EXCEL[$i]['cantidadminima']) == 0) ||(strlen($_DATOS_EXCEL[$i]['bodegaid']) == 0) || ($_DATOS_EXCEL[$i]['codigo'] == ""))
                        $recorrer = false;
                    
                    $i++;
                } /// Fin del While
            }
            else
            { echo "Necesitas primero importar el archivo";  }  /// Si NO Cargó el archivo

            // ------------------------------------------------------------------------------------------ //
            //Teniendo la Informacion en el Array la inserto en la Base de Datos
            $errores=0;
            $grabados = 0;

            $carpetaactual = 'reportes/';

            // Construcción de la variable con los documentos no grabados
            $nocodigos = 'PRODUCTOS CON EXISTENCIA MINIMA'.Chr(13).Chr(10);
            $nocodigos.= 'CODIGOS NO GRABADOS:'.Chr(13).Chr(10);
            $nocodigos.= ''.Chr(13).Chr(10);

            for($j=1; $j < $i; $j++)
            {
                $lbgrabo = false;
                $valproducto = 0;
                $numbodega = 0;
                $motivo = "";
                $codigo = $_DATOS_EXCEL[$j]['codigo'];

                // Valido que el vendedor existe
                if($codigo != "")
                {
                    $productoid = $clase->BDLockup($codigo,"productos","codigo","productoid");
                    
                    if($productoid != "")
                    {
                        // valido que la bodega exista
                        $bodegaid = $_DATOS_EXCEL[$j]['bodegaid'];

                        $vsql7 = "SELECT COUNT(bodegaid) numbodega FROM bodegas WHERE bodegaid = ".$bodegaid;
                        $numbodega = $clase->SeleccionarUno($vsql7);

                        if($numbodega > 0)
                        {
                            // valido que la cantidad sea mayor a cero
                            $cantidadminima = $_DATOS_EXCEL[$j]['cantidadminima'];

                            if($cantidadminima > 0)
                            {
                                // Valido la existencia del producto y la bodega
                                $vsql2 = "SELECT COUNT(*) AS valproducto FROM existenciasminimas WHERE productoid = ".$productoid." AND bodegaid = ".$bodegaid;
                                $valproducto = $clase->SeleccionarUno($vsql2);

                                if($valproducto == 0)
                                {
									// Inserto el nuevo registro
									$vsql = "INSERT INTO existenciasminimas (bodegaid,productoid, cantidadminima, creador, ultcambio) VALUE (".$bodegaid.",".$productoid.",".$cantidadminima.",'".$_SESSION['USERNAME']."',CURRENT_TIMESTAMP)";
									$clase->EjecutarSQL($vsql);

									if(mysql_affected_rows() >= 1)
									{
										$grabados++;
										$lbgrabo = true;
									}
                                }
                                else
                                    $motivo = "producto y bodega ya existen";
                            }
                            else
                                $motivo = "cantidad menor a cero";
                        }
                        else
                            $motivo = "bodeba no existe";
                    }
                    else
                        $motivo = "producto no existe";
                }
                else
                    $motivo = "codigo en blanco";

                // Almaceno en un archivo de texto las códigos que no fueron grabados en este proceso
                if(!$lbgrabo)
                {
                    $nocodigos.= str_pad($codigo,1,"").'          '.str_pad($motivo,1,"").Chr(13).Chr(10);      // Actualizo la variable con el documento no almacenado
                    $archivo = "erroresexitmin.txt";                                                            // nombre del archivo
                    $fd = fopen ($carpetaactual."/".$archivo, "w");                                             // se abre el archivo para escribir
                    fwrite($fd, $nocodigos);                                                                    // Grabas
                    fclose($fd);                                                                                // Cierras el archivo
                }
            }

            // --------------------------------------------------------------------------------------------------------------- //
            // Impresión de la fecha del último proceso ejecutado
            $mesimp = date('F');
            if($mesimp == "January")       $mesimp = "enero";
            if($mesimp == "February")      $mesimp = "febrero";
            if($mesimp == "March")         $mesimp = "marzo";
            if($mesimp == "April")         $mesimp = "abril";
            if($mesimp == "May")           $mesimp = "mayo";
            if($mesimp == "June")          $mesimp = "junio";
            if($mesimp == "July")          $mesimp = "julio";
            if($mesimp == "August")        $mesimp = "agosto";
            if($mesimp == "September")     $mesimp = "septiembre";
            if($mesimp == "October")       $mesimp = "octubre";
            if($mesimp == "November")      $mesimp = "noviembre";
            if($mesimp == "December")      $mesimp = "diciembre";

            $dayweek = date("l");
            if($dayweek == "Monday")       $dayweek = "lunes";
            if($dayweek == "Tuesday")      $dayweek = "martes";
            if($dayweek == "Wednesday")    $dayweek = "miércoles";
            if($dayweek == "Thursday")     $dayweek = "jueves";
            if($dayweek == "Friday")       $dayweek = "viernes";
            if($dayweek == "Saturday")     $dayweek = "sábado";
            if($dayweek == "Sunday")       $dayweek = "domingo";

            $fechoraimp = "proceso ejecutado el ".$dayweek." ".date('d')." de ".$mesimp." de ".date('Y')." a las ".date('g:i a');

            $nocodigos.= ''.Chr(13).Chr(10);
            $nocodigos.= str_pad($fechoraimp,1,"").''.Chr(13).Chr(10);      // Actualizo la variable con la fecha y la hora de la ejecución del proceso
            $archivo = "erroresexitmin.txt";                                // nombre del archivo
            $fd = fopen ($carpetaactual."/".$archivo, "w");                 // se abre el archivo para escribir
            fwrite($fd, $nocodigos);                                        // Grabas
            fclose($fd);                                                    // Cierras el archivo
            // --------------------------------------------------------------------------------------------------------------- //
      
            // Elimino el Archivo
            unlink($destino);
    
            // Emito el mensaje correspondiente
            if($grabados==0)
			{
				echo'<SCRIPT languague="javascript">
					 <!--
						alert("No se cargaron los productos");
						window.history.back();
					 -->
					 </SCRIPT>';
		   		exit;
			}                
            else
			{
				echo'<SCRIPT languague="javascript">
					 <!--
						alert("Se cargaron '.$grabados.' productos a la lista de productos excluidos");
						window.history.back();
					 -->
					 </SCRIPT>';
		   		exit;
			}                
    
            // Redirecciona el formulario
            header("Location: existenciasminimas.php?opcion=crudcantminima");                              
        }
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: vererrores
    // Creación: 25/01/2024		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que permite ver los productos que fueron incluidos en el último 
    //              proceso de importación desde una hoja de Excel
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "vererrores")
    {
        // Inicialización de variables
        $archivoerror = "reportes/erroresexitmin.txt";
        $txt = "";
        $plantilla = fopen($archivoerror,"r") or die("error al leer archivo");
        
        // Lleno la variable con los documentos no guardados
        while(!feof($plantilla))
        {
            $plantillaFinal = fgets($plantilla);
            $plantillaFinal = nl2br($plantillaFinal);
            $txt.= $plantillaFinal;
        }

        // Pinto la ventana con la información solicitada
        // echo $txt; exit();
        $txt = trim(str_replace("<br />","",$txt));
        $txt = trim(str_replace("          codigo en blanco","",$txt));
        $cont.='<table width="400">
                 <tr class="CabezoteTabla"> 
                  <td align="center"> <b> Documentos no grabados <br>en el &uacute;ltimo proceso </b> </td> 
                 </tr>
                 <tr class="CabezoteTabla"> 
                  <td align="center"> <textarea name="txt" cols="70" rows="38" disabled> '.$txt.' </textarea> </td> 
                 </tr> 
                 <tr class="CabezoteTabla"> 
                  <td align="center">
				  <a href="existenciasminimas.php?opcion=crudcantminima"> <input type="button" value="aceptar" class="button blue"> </a>
                  </td> 
                 </tr>
                </table>';
        echo $cont;
        exit();
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: confirmarlimpiar
    // Creación: 25/01/2024		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que pinta la ventana para confirmar la eliminación de todos los
    //              productos con cantidad mínima
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "confirmarlimpiar")
    {
        // Pinto la ventana
        $cont ='<table width="500">
                 <tr class="CabezoteTabla">
                  <td width="50" align="left"> <img src="images/iconos/anulardoc.png" width="32" height="32" border="0"> </td>
                  <td width="450" align="center"><br> <label class="Texto12"> <b> Eliminar todos los productos </b> </label> <br><br> </td>
                 </tr> 
                </table>
                <table width="500">
                 <tr class="TablaDocsImPar"> 
                  <td width="400" align="center">
                   <label class="Texto12">
                   ¿Confirma que desea eliminar todos los productos con existencias m&iacute;nimas? <br> Esta opci&oacute;n no podr&aacute; ser revertida
                   </label> 
                  </td>
                 </tr>
                 <tr class="TablaDocsImPar">
                  <td width="400" align="center"><br><br> 
                   <form action="?opcion=limpiarminimas" method="POST">                   
                   <input type="submit" value="ACEPTAR" class="button blue">
                   <a href="existenciasminimas.php?opcion=crudcantminima" > <input type="button" value="CANCELAR" class="button red"> </a>
                   </form>
                   <br>
                  </td> 
                 </tr>
                </table>';
        echo $cont;
        exit();        
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: limpiarminimas
    // Creación: 25/01/2024		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que elimina todos los productos con cantidad mínima
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "limpiarminimas")
    {
		// Elimino el prodcuto
		$vsql = "DELETE FROM existenciasminimas";
		$clase->EjecutarSQL($vsql);

		// emito el mensaje correspondiente
		echo'<SCRIPT languague="javascript">
			 <!--
				alert("Eliminados todos los productos con existencias mínimas");
				window.history.back();
			 -->
			 </SCRIPT>';
	 	exit;

		// redirecciono el formulario
		header("Location: existenciasminimas.php?opcion=crudcantminima");        
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: informeextminimas
    // Creación: 25/01/2024		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción con el informe de los productos cuya cantidad actual es menor a 
    //              la cantidad mínima
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "informeextminimas")
    {
        $bodegaid = $_POST['bodegaid'];
        $gruposprodid = $_POST['gruposprodid'];

        if(strlen($bodegaid) == 0)
            $bodegaid = $_GET['bodegaid'];

        if(strlen($gruposprodid) == 0)
            $gruposprodid = $_GET['gruposprodid'];

		// inicializo las variables
        $det = '';
		$pie.=' </tbody>
			   </table>';

        // combo para el cedi
        $params = ' class="Texto12" ';
        $vsqlcedis = "SELECT bodegaid, nombodega FROM bodegas WHERE nombodega LIKE '%DEPOSITO%'";
        $vsqlcombobodegas = $clase->CrearComboBuscar("bodegaid",$vsqlcedis,"nombodega","bodegaid",$bodegaid,"S",$params,250);

        // combo de laboratorio
        $vsqlcombolab = "SELECT gruposprodid , TRIM(descripcion) AS descripcion FROM gruposprod WHERE 1 ORDER BY 2 ASC";
        $combolab = $clase->CrearComboBuscar("gruposprodid",$vsqlcombolab,"descripcion","gruposprodid",$gruposprodid,"S",$params,300);

		// pinto la ventana
		$enc =  $clase->HeaderBlanco("informe de existencias mínimas");
		$enc.=' <table width="1300">
		         <tr class="CabezoteTabla"> 
		          <td width="10"> &nbsp; </td>
		          <td width="37"> <img src="images/iconos/cuotas.png" width="32" height="32" border="0"> </td>
		          <td width="910"> <b> Informe de existencias m&iacute;nimas <br> de productos por cedi </b> </td>
                  <form action="" method="post">
                  <td> '.$vsqlcombobodegas.' </td>
				  <td width="5"> &nbsp; </td>
                  <td> '.$combolab.' </td>
                  <td> <button type="submit" class="button"> buscar </button> </form> </td>
                  <td width="10"> &nbsp; </td>
                  <td width="30">
                   <a href="?opcion=informeextminimas" title="actualizar la ventana"> 
                    <img src="images/iconos/refrescar.png" border="0" width="38" height="38">  
                   </a>
                  </td>
                  <td width="10"> &nbsp; </td>
                  <td width="30"> 
                   <a href="?opcion=crudcantminima" target="_blank">
                    <img src="images/iconos/conceptos.png" border="0" width="38" height="38" title="crud de productos con exitencias m&iacute;nimas">
                   </a> 
                  </td>
                  <td width="10"> &nbsp; </td>
                  <td width="30"> 
                   <a href="?opcion=exportarexcelminimos" target="_blank">
                    <img src="images/iconos/exportarexcel.png" border="0" width="38" height="38" title="exportar a Excel el informe de productos con existencia m&iacute;nima">
                   </a> 
                  </td>
                  <td width="10"> &nbsp; </td>
                  <td width="50" align="center"> <a href="principal.php"> <input type="button" value="<<" class="button blue"> </a> </td> 
                  <td width="8"> &nbsp; </td>
                 </tr>
                </table>
                <script type="text/javascript" src="lib/sorttable.js"></script>
                <table id="fixTableV" class="sortable">
                 <tr class="TituloTabla">
                  <th width="40"> # </th>
                  <th width="130"> C&oacute;digo </th>
                  <th width="470"> Producto </th>
                  <th width="100"> Laboratorio </th>
                  <th width="100"> Bodega </th>
                  <th width="100"> Cantidad <br> actual </th>
                  <th width="100"> Cantidad <br> m&iacute;nima </th>
                  <th width="100"> Diferencia </th>
                 </tr>';

        $bodegaid = $_POST['bodegaid'];
        $gruposprodid = $_POST['gruposprodid'];

        // consulta de la vista
        $vsql = "SELECT em.minimaid, em.productoid, p.codigo, p.descripcion,  gp.descripcion nomlabo, b.nombodega, em.cantidadminima, e.cantidad , (em.cantidadminima - e.cantidad) diferencia
                   FROM existenciasminimas em 
                        INNER JOIN existencias e ON (em.productoid = e.productoid AND em.bodegaid = e.bodegaid) 
                        INNER JOIN productos p ON (em.productoid = p.productoid)
                        INNER JOIN gruposprod gp ON (p.gruposprodid = gp.gruposprodid)
                        INNER JOIN bodegas b ON (b.bodegaid = em.bodegaid) 
                  WHERE em.minimaid > 0 ";

        if(strlen($bodegaid) > 0)
            $vsql.= " AND em.bodegaid = ".$bodegaid." ";

        if(strlen($gruposprodid) > 0)
            $vsql.= " AND p.gruposprodid = ".$gruposprodid." ";

        $vsql.= "HAVING diferencia > 0 
               ORDER BY em.productoid, b.bodegaid";

        $_SESSION['SQL_INFORMEMINIMA'] = $vsql;

        // impresión del detalle
        $i = 0;
        $conex  = $clase->Conectar();
        $result = mysql_query($vsql,$conex);
        while($row = mysql_fetch_array($result))
        {
            $i++;
            if($i%2 == 0)
                $det.='<tr class="TablaDocsPar">';
            else
                $det.='<tr class="TablaDocsImPar">';
            
            $det.=' <td align="center"> '.$i.' </td>
                    <td align="center"> '.$row['codigo'].' </td>
                    <td align="center"> '.$row['descripcion'].' </td>
                    <td align="center"> '.$row['nomlabo'].' </td>
                    <td align="center"> '.$row['nombodega'].' </td>
                    <td align="center"> '.number_format($row['cantidad']).' </td>
                    <td align="center"> '.number_format($row['cantidadminima']).' </td>
                    <td align="center"> <font color="red"> '.number_format($row['diferencia']).' </font> </td>
                   </tr>';            
        }

		// Construyo el contenido del formulario
        $cont = $enc.$det.$pie;

        echo $cont;
        exit();
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: exportarexcelminimos
    // Creación: 25/01/2024		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que genera la salida a Excel del informe de productos cuya 
    //              cantidad actual es menor a la cantidad mínima
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "exportarexcelminimos")
    {
        // consulta de la salida a Excel
        $vsql = $_SESSION['SQL_INFORMEMINIMA'];

        if($vsql == "")
            $vsql = "SELECT em.minimaid, em.productoid, p.codigo, p.descripcion,  gp.descripcion nomlabo, b.nombodega, em.cantidadminima, e.cantidad , (em.cantidadminima - e.cantidad) diferencia
                       FROM existenciasminimas em 
                            INNER JOIN existencias e ON (em.productoid = e.productoid AND `em`.bodegaid = e.bodegaid) 
                            INNER JOIN productos p ON (em.productoid = p.productoid)
                            INNER JOIN gruposprod gp ON (p.gruposprodid = gp.gruposprodid)
                            INNER JOIN bodegas b ON (b.bodegaid = em.bodegaid)
                     HAVING diferencia > 0
                   ORDER BY em.productoid, b.bodegaid";

        // preparación de entorno
        require_once 'lib/PHPExcel.php';
        $clase = new Sistema();
        $clase->Conectar();
        ini_set("memory_limit","100M");

        // Preparación del entorno para la salida a Excel
        $clase = new Sistema();
        $clase->Nombredb = $_SESSION['DBNOMBRE'];
        error_reporting(E_ALL);
        ini_set('display_errors', TRUE);
        ini_set('display_startup_errors', TRUE);
        date_default_timezone_set('Europe/London');
    
        if (PHP_SAPI == 'cli')
            die('This example should only be run from a Web Browser');
    
        // Create new PHPExcel object
        $objPHPExcel = new PHPExcel();
    
        // Set document properties
        $objPHPExcel->getProperties()->setCreator("Sistemas y Soluciones Web de Colombia")
                                    ->setLastModifiedBy("Sistemas y Soluciones Web de Colombia")
                                    ->setTitle("existencias minimas - DROPOS")
                                    ->setSubject("existencias minimas - DROPOS")
                                    ->setDescription("productosexistencias minimas - DROPOS")
                                    ->setKeywords("existencias minimas - DROPOS")
                                    ->setCategory("Categoria General");

        // encabezado
        $objPHPExcel->setActiveSheetIndex(0)
                    ->setCellValue('A1', 'EXISTENCIAS MINIMAS DE PRODUCTOS POR CEDI')                    
                    ->setCellValue('A3', 'CODIGO')
                    ->setCellValue('B3', 'PRODUCTO')
                    ->setCellValue('C3', 'LABORATORIO')
                    ->setCellValue('D3', 'BODEGA')
                    ->setCellValue('E3', 'CANT ACTUAL')
                    ->setCellValue('F3', 'CANT MINIMA')
                    ->setCellValue('G3', 'DIFERENCIA');

        $objPHPExcel->getActiveSheet()->getColumnDimension('A')->setAutoSize(true);                 $objPHPExcel->getActiveSheet()->getColumnDimension('B')->setAutoSize(true);
        $objPHPExcel->getActiveSheet()->getColumnDimension('C')->setAutoSize(true);                 $objPHPExcel->getActiveSheet()->getColumnDimension('D')->setAutoSize(true);
        $objPHPExcel->getActiveSheet()->getColumnDimension('E')->setAutoSize(true);					$objPHPExcel->getActiveSheet()->getColumnDimension('F')->setAutoSize(true);
        $objPHPExcel->getActiveSheet()->getColumnDimension('G')->setAutoSize(true);

        // Inmovilizar paneles
        $objPHPExcel->getActiveSheet(0)->freezePaneByColumnAndRow(0,4);

        // Detalle del informe
        $i = 4;
        $conex  = $clase->Conectar();
        $result = mysql_query($vsql,$conex);
        // $cant   = mysql_num_rows($result);
        while($row = mysql_fetch_array($result))
        {
            $objPHPExcel->setActiveSheetIndex(0)
                        ->setCellValue('A'.$i, $row['codigo'])
                        ->setCellValue('B'.$i, $row['descripcion'])
                        ->setCellValue('C'.$i, $row['nomlabo'])
                        ->setCellValue('D'.$i, $row['nombodega'])
                        ->setCellValue('E'.$i, number_format($row['cantidad']))
                        ->setCellValue('F'.$i, number_format($row['cantidadminima']))
                        ->setCellValue('G'.$i, number_format($row['diferencia']));
            $i++;            
        }

        $rangoEncabezado = 'A3:G3';
        $rangoCeldas     = 'A3:G'.($i-1);

        // ----------------------------------------------------------------------------------------------------------------------------------------------------------- //
        // Formato de Encabezado y Celdas
        $objPHPExcel->getActiveSheet()->getRowDimension('1')->setRowHeight(15);
        
        $EstiloCeldas = array(
        'borders' => array(
            'allborders' => array(
                'style' => PHPExcel_Style_Border::BORDER_THIN,
                'color' => array('argb' => '00000000'),
            ),
            ),
        );
        $objPHPExcel->getActiveSheet()->getStyle($rangoCeldas)->applyFromArray($EstiloCeldas);
        /// Formato de Encabezados 
        $EstiloEncabezado = array(
        'font' => array(
            'bold' => true,
        ),
        'alignment' => array(
            'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,
            'vertical' => PHPExcel_Style_Alignment::VERTICAL_CENTER,		
        ),
        'borders' => array(
            'allborders' => array(
                'style' => PHPExcel_Style_Border::BORDER_THIN,
                'color' => array('argb' => '00000000'),
            ),
        ),
        'fill' => array(
            'type' => PHPExcel_Style_Fill::FILL_SOLID,
            'rotation' => 90,
            'startcolor' => array(
                'argb' => '00FFFFCC',
            ),
            'endcolor' => array(
                'argb' => 'FFFFFF',
            ),
            ),
        );
        $objPHPExcel->getActiveSheet()->getStyle($rangoEncabezado)->applyFromArray($EstiloEncabezado);
        // Rename worksheet
        $objPHPExcel->getActiveSheet()->setTitle('existencias mínimas');
        // Set active sheet index to the first sheet, so Excel opens this as the first sheet
        $objPHPExcel->setActiveSheetIndex(0);
        // Redirect output to a client’s web browser (Excel5)
        header('Content-Type: application/vnd.ms-excel');
        // -------------------------------------------------------------------------------------------- //
        $nombrearcexcel = "existencias mInimas.xls";
        header('Content-Disposition: attachment;filename='.$nombrearcexcel.'');
        // -------------------------------------------------------------------------------------------- //
        header('Cache-Control: max-age=0');
        /// Genero la Salida
        $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');
        $objWriter->save('php://output');
        exit;
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: filtrarcedi
    // Creación: 10/05/2024		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que pinta la ventana para filtrar el cedi para el informe de 
    //              existencias mínimas
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "filtrarcedi")
    {
        // combo bodegas
        $params = ' class="Texto12" ';
        $vsqlbodegas = "SELECT bodegaid, nombodega FROM bodegas WHERE nombodega LIKE '%DEPOSITO%'";
        $vsqlcombobodegas = $clase->CrearComboBuscar("bodegaid",$vsqlbodegas,"nombodega","bodegaid","","N",$params,250);
        
		// pinto la ventana
		$cont ='<table width="400">
				 <tr class="CabezoteTabla">
				  <td width="50" align="left"> <img src="images/iconos/informe2.png" width="32" height="32" border="0"> </td>
				  <td width="350" align="center"> <b>Filtrar CEDIS</b> <br> </td>
				 </tr> 
				</table>
				<form action="?opcion=informeexistenciasmin" method="POST" name="x" target="_blank">
				<table width="400">
				 <center><br>
				 <tr class="TablaDocsImPar">
				  <td width="100" align="right"><label class="Texto12"> Bodega: </label>&nbsp; </td>
				  <td width="300"> '.$vsqlcombobodegas.' </td>
				 </tr>
				</table>
				<br>
				<center>
				<input type="submit" value="aceptar" class="button blue">
				<a href="existenciasminimas.php?opcion=crudcantminima"><input type="button" value="CANCELAR" class="button red"></a>
				</form><br>';
		echo $cont;
		exit();
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: informeexistenciasmin
    // Creación: 10/05/2024		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que pinta la salida en html del informe de existencias mínimas 
    //              por cedi
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "informeexistenciasmin")
    {
        $bodegaid = $_POST['bodegaid'];
        
        // nombre de la bodega
        $nombodega = $clase->BDLockup($bodegaid,'bodegas','bodegaid','nombodega');

        // consulta del informe
        $vsql = "SELECT em.minimaid, p.codigo, p.descripcion, gp.descripcion nomlabo, b.nombodega, em.cantidadminima
                   FROM existenciasminimas em
                        INNER JOIN productos p ON (em.productoid = p.productoid)
                        INNER JOIN gruposprod gp ON (p.gruposprodid = gp.gruposprodid)
                        INNER JOIN bodegas b ON (b.bodegaid = em.bodegaid)           
                  WHERE em.bodegaid = ".$bodegaid." 
               ORDER BY em.productoid, b.bodegaid";

        // Variable para la salida a Excel
        $_SESSION['SQL_INFEXITMINXLS'] = $vsql;

        $conex  = $clase->Conectar();
        $result = mysql_query($vsql,$conex);
        $cant   = mysql_num_rows($result);

        if($cant == 0)
        {
			echo'<SCRIPT languague="javascript">
				 <!--
					alert("No existen productos para este cedi '.$nombodega.'");
					window.history.back();
				 -->
				 </SCRIPT>';
			exit;
            
            // redirecciono el formulario
            header("Location: existenciasminimas.php?opcion=crudcantminima");
        }
        else
        {
            while($row = mysql_fetch_array($result))
            {
                // pinto la ventana
                $enc =  $clase->HeaderBlanco("informe de existencias mínimas");
                $enc.=' <table width="1300">
                         <tr class="CabezoteTabla"> 
                          <td width="10"> &nbsp; </td>
                          <td width="37"> <img src="images/iconos/informe2.png" width="32" height="32" border="0"> </td>
                          <td width="1000"> <b> Informe de existencias m&iacute;nimas <br> <font color="blue"> '.$nombodega.' </font> </b> </td>
                          <td width="30"> 
                           <a href="?opcion=importarexcelexitmin&bodegaid='.$bodegaid.'">
                            <img src="images/iconos/descargar.png" width="34" height="34" border="0" title="exportar productos a una hoja de Excel">
                           </a>
                          </td>
                          <td width="10"> &nbsp; </td>
                          <td width="50" align="center"> <a href="existenciasminimas.php?opcion=crudcantminima"> <input type="button" value="<<" class="button blue"> </a> </td> 
                          <td width="8"> &nbsp; </td>
                         </tr>
                        </table>
                        <script type="text/javascript" src="lib/sorttable.js"></script>
                        <table id="fixTableV" class="sortable">
                         <tr class="TituloTabla">
                          <th width="40"> # </th>
                          <th width="130"> C&oacute;digo </th>
                          <th width="530"> Producto </th>
                          <th width="200"> Laboratorio </th>                          
                          <th width="100"> Cantidad <br> m&iacute;nima </th>
                         </tr>';

                // impresión del detalle
                $i = 0;
                $conex  = $clase->Conectar();
                $result = mysql_query($vsql,$conex);
                while($row = mysql_fetch_array($result))
                {
                    $i++;
                    if($i%2 == 0)
                        $det.='<tr class="TablaDocsPar">';
                    else
                        $det.='<tr class="TablaDocsImPar">';
                    
                    $det.=' <td align="center"> '.$i.' </td>
                            <td align="center"> '.$row['codigo'].' </td>
                            <td align="center"> '.$row['descripcion'].' </td>
                            <td align="center"> '.$row['nomlabo'].' </td>
                            <td align="center"> '.number_format($row['cantidadminima']).' </td>
                           </tr>';
                }
                // Construyo el contenido del formulario
                $cont = $enc.$det.$pie;

                echo $cont;
                exit();
            }
        }        
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: informeexistenciasmin
    // Creación: 10/05/2024		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que genera la salida en una hoja de Excel del informe de 
    //              existencias mínimas por cedi
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "importarexcelexitmin")
    {
        $bodegaid = $_GET['bodegaid'];

        // nombre de la bodega
        $nombodega = $clase->BDLockup($bodegaid,'bodegas','bodegaid','nombodega');
        
        // Variable para la salida a Excel
        $vsql = $_SESSION['SQL_INFEXITMINXLS'];

        // Preparo el entorno
        require_once 'lib/PHPExcel.php';
        $clase = new Sistema();
        $clase->Conectar();
        ini_set("memory_limit","100M");
        
        // Preparación del entorno para la salida a Excel
        $clase = new Sistema();
        $clase->Nombredb = $_SESSION['DBNOMBRE'];
        error_reporting(E_ALL);
        ini_set('display_errors', TRUE);
        ini_set('display_startup_errors', TRUE);
        date_default_timezone_set('Europe/London');
    
        if (PHP_SAPI == 'cli')
            die('This example should only be run from a Web Browser');
    
        // Create new PHPExcel object
        $objPHPExcel = new PHPExcel();
    
        // Set document properties
        $objPHPExcel->getProperties()->setCreator("Sistemas y Soluciones Web de Colombia")
                                     ->setLastModifiedBy("Sistemas y Soluciones Web de Colombia")
                                     ->setTitle("existencias mínimas por cedi - DROPOS")
                                     ->setSubject("existencias mínimas por cedi - DROPOS")
                                     ->setDescription("existencias mínimas por cedi - DROPOS")
                                     ->setKeywords("existencias mínimas por cedi - DROPOS")
                                     ->setCategory("Categoria General");        
        
        $objPHPExcel->setActiveSheetIndex(0)
                    ->setCellValue('A1', 'INFORME DE EXISTENCIAS MÍNIMAS POR CEDI')
                    ->setCellValue('A2', $nombodega)
                    ->setCellValue('A3', '#')
                    ->setCellValue('B3', 'CODIGO')
                    ->setCellValue('C3', 'PRODUCTO')
                    ->setCellValue('D3', 'LABORATORIO')
                    ->setCellValue('E3', 'CANTIDAD MIN');

        $objPHPExcel->getActiveSheet()->getColumnDimension('A')->setAutoSize(true);                 $objPHPExcel->getActiveSheet()->getColumnDimension('B')->setAutoSize(true);
        $objPHPExcel->getActiveSheet()->getColumnDimension('C')->setAutoSize(true);                 $objPHPExcel->getActiveSheet()->getColumnDimension('D')->setAutoSize(true);
        $objPHPExcel->getActiveSheet()->getColumnDimension('E')->setAutoSize(true);

        // Inmovilizar paneles
        $objPHPExcel->getActiveSheet(0)->freezePaneByColumnAndRow(0,4);        
        
        $i = 4;
        $numrg = 0;
        $conex  = $clase->Conectar();
        $result = @mysql_query($vsql,$conex);
        $cant   = @mysql_num_rows($result);
        while($row = @mysql_fetch_array($result))
        {
            $numrg++;
            $objPHPExcel->setActiveSheetIndex(0)
                        ->setCellValue('A'.$i, $numrg)
                        ->setCellValue('B'.$i, $row['codigo'])
                        ->setCellValue('C'.$i, $row['descripcion'])
                        ->setCellValue('D'.$i, $row['nomlabo'])
                        ->setCellValue('E'.$i, number_format($row['cantidadminima']));
            $i++;
        }        

        $rangoEncabezado = 'A3:E3';
        $rangoCeldas     = 'A3:E'.($i-1);

        // Formato de Encabezado y Celdas
        $objPHPExcel->getActiveSheet()->getRowDimension('1')->setRowHeight(15);
        
        $EstiloCeldas = array(
        'borders' => array(
            'allborders' => array(
                'style' => PHPExcel_Style_Border::BORDER_THIN,
                'color' => array('argb' => '00000000'),
            ),
            ),
        );
        $objPHPExcel->getActiveSheet()->getStyle($rangoCeldas)->applyFromArray($EstiloCeldas);
        /// Formato de Encabezados 
        $EstiloEncabezado = array(
        'font' => array(
            'bold' => true,
        ),
        'alignment' => array(
            'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,
            'vertical' => PHPExcel_Style_Alignment::VERTICAL_CENTER,		
        ),
        'borders' => array(
            'allborders' => array(
                'style' => PHPExcel_Style_Border::BORDER_THIN,
                'color' => array('argb' => '00000000'),
            ),
        ),
        'fill' => array(
            'type' => PHPExcel_Style_Fill::FILL_SOLID,
            'rotation' => 90,
            'startcolor' => array(
                'argb' => '00FFFFCC',
            ),
            'endcolor' => array(
                'argb' => 'FFFFFF',
            ),
            ),
        );
        $objPHPExcel->getActiveSheet()->getStyle($rangoEncabezado)->applyFromArray($EstiloEncabezado);
        // Rename worksheet
        $objPHPExcel->getActiveSheet()->setTitle('existencias minimas');
        // Set active sheet index to the first sheet, so Excel opens this as the first sheet
        $objPHPExcel->setActiveSheetIndex(0);
        // Redirect output to a client’s web browser (Excel5)
        header('Content-Type: application/vnd.ms-excel');
        // ------------------------------------------------------------------------------ //
        $nombrearcexcel = "existencias mínimas de ".strtolower($nombodega).".xls";
        header('Content-Disposition: attachment;filename='.$nombrearcexcel.'');
        // ------------------------------------------------------------------------------ //
        header('Cache-Control: max-age=0');
        /// Genero la Salida
        $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');
        $objWriter->save('php://output');
        exit;        
    }
?>