<?PHP
    @session_start();

    require_once("classes/class_validaciones.php");
    $io_fecha=new class_validaciones();   

    include("lib/Sistema.php");
    
    $clase = new Sistema();
    $clase->Nombredb = $_SESSION['DBNOMBRE'];
    $avisos = "";
    $opcion = "";
    $opcion = $_GET["opcion"];

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: ""
    // Creación: 27/05/2021		última modificación: 09/04/2024
    // Creador: Luis Flórez		modificado por: Luis Flórez
    // Descripción: Opción que pinta la ventana donde se imprime el informe tipo vista del
    //              sistema con los empleados que se procesarán en el periodo actual
    //              segmentados en tres grupos: área de administración, área de ventas 
    //              y extralegales
    // Última modificación: Se incorporó el campo de empleado activo en la nómina
    //                      (11/08/2021)
    //                      Se excluyeron de la consulta los empleados con fecha de ingreso 
    //                      superior a la fecha límite del periodo actual
    //                      Números de empleados por área
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "")
    {
        // Obtengo el nombre del periodo a procesar
        $vsql = "SELECT periodoid
                   FROM periodosnomina 
                  WHERE periodoid = (SELECT MIN(periodoid) FROM periodosnomina WHERE cerrado ='')";
        $periodoid = $clase->SeleccionarUno($vsql);

        $descripcion = $clase->BDLockup($periodoid,'periodosnomina','periodoid','descripcion');

        // Fechas del periodo actual
        $fecdesdeper = $clase->BDLockup($periodoid,'periodosnomina','periodoid','fecdesde');
        $fechastaper = $clase->BDLockup($periodoid,'periodosnomina','periodoid','fechasta');

        // inicialización de variables
        $numregadn =  0;                    $numregadn2 =  0;
        $numregvts = 0;                     $numregvts2 = 0;
        $numregext = 0;                     $numregext2 = 0;

        $numeroadm = 0;
        $numerovts = 0;
        $numextral = 0;
        $totalempl = 0;

        $numadm1 = 0;                   $numadm2 = 0;                   $totempadm = 0;
        $vsql12 = "";                   $vsql13 = "";                   $vsql14 = "";
        $numvts1 = 0;                   $vsql15 = "";                   $numvts2 = 0;
        $totempvts = 0;                 $vsql16 = "";                   $extlg1 = 0;
        $vsql17 = "";                   $extlg2 = 0;                    $totextralg = 0;

        // Pinto la ventana del informe
        $cont = $clase->Header("S","W");
        $cont.='<table width="100%">
                 <tr class="CabezoteTabla"> 
                  <td width="10"> &nbsp; </td>
                  <td width="37"> <img src="images/iconos/clientes.png" width="32" height="32" border="0"> </td>
                  <td width="720"> <b>Empleados a ser procesados en el periodo </b> <font color="BLUE">'.$descripcion.'</font> </td>
                  <td width="20">
                   <a href="?opcion=ventactterceros" title="actualizar datos de terceros" target="_blank">
                    <img src="images/iconos/variaciones.png" border="0" width="38" height="38">
                   </a>
                  </td>                  
                  <td width="10"> &nbsp; </td>
                  <td width="20"> 
                   <a href="terceros.php" title="acceder a la ficha terceros" target="_blank">
                    <img src="images/iconos/terceros.png" border="0" width="38" height="38">
                   </a> 
                  </td>
                  <td width="10"> &nbsp; </td>
                  <td>
                   <a href="?opcion=ventanacargosysecciones" title="actualizar cargos y secciones" target="_blank">
                    <img src="images/iconos/guardardoc.png" border="0" width="38" height="38">
                   </a>
                  </td>
                  <td width="10"> &nbsp; </td>
                  <td>
                   <a href="?opcion=ventanaactdatos" title="actualizar datos" target="_blank">
                    <img src="images/iconos/guardar.png" border="0" width="38" height="38">                      
                   </a>
                  </td>                  
                  <td width="10"> &nbsp; </td>
                  <td align="right"> 
                   <a href="?opcion=empperpdf" title="salida en pdf del informe de empleados en el periodo" target="_blank"> 
                    <img src="images/iconos/exportarpdf2.png" border="0"> 
                   </a> 
                  </td>
                  <td width="10"> &nbsp; </td>                  
                  <td width="10"> 
                   <a href="?opcion=empperxls" title="salida en Excel del informe de empleados en el periodo" target="_blank"> 
                    <img src="images/iconos/exportarexcel2.png" border="0"> 
                   </a> 
                  </td>
                  <td width="10"> &nbsp; </td>
                 </tr>
                </table>';                

        // ------------------------------------------------------------------------------------------------------------------------------------ //
        // Descripción de área de administración
        $vsql12 = "SELECT IFNULL(COUNT(*),0) numadm1
                     FROM terceros t
                          INNER JOIN seccion s ON (t.seccionid = s.seccionid)
                          INNER JOIN cargos c ON (t.cargoid = c.cargoid)
                    WHERE t.esempleadoactivo = 'CHECKED'
                          AND t.basico > 0                            
                          AND (t.esempleadoactivo = 'CHECKED' AND (t.extralegal = '' OR t.extralegal IS NULL))
                          AND t.areaid = 1                         
                          AND t.fecingreso <= '".$fechastaper."'";
        $numadm1 = $clase->SeleccionarUno($vsql12);

        $vsql13 = "SELECT IFNULL(COUNT(*),0) numadm2
                     FROM terceros t
                          INNER JOIN seccion s ON (t.seccionid = s.seccionid)
                          INNER JOIN cargos c ON (t.cargoid = c.cargoid)
                    WHERE t.fecharetiro BETWEEN '".$fecdesdeper."' AND '".$fechastaper."'
                          AND t.basico > 0
                          AND t.areaid = 1
                          AND t.extralegal = 'CHECKED'";
        $numadm2 = $clase->SeleccionarUno($vsql13);

        $totempadm = $numadm1 + $numadm2;

        // pinto en encabezado
        $cont.='<table width="100%">
                 <tr class="CabezoteTabla"> 
                  <td width="10"> &nbsp; </td>
                  <td width="37"> &nbsp; </td>
                  <td width="800"> &Aacute;rea de administraci&oacute;n <font color="blue">('.number_format($totempadm).' empleados)</font> </td>
                  <td> &nbsp; </td>
                  <td> &nbsp; </td>                  
                  <td width="10"> &nbsp; </td>
                  <td width="8"> &nbsp; </td>
                 </tr>
                </table>';

        // Consulta para los empleados del área de administración
        $vsql = "SELECT t.terid, t.codvende, t.dni AS documento, 
                        CONCAT(t.primernombre,' ',t.segundonombre,' ',t.primerapellido,' ',t.segundoapellido) AS nombreemp, 
                        s.descripcionsec AS seccion, c.descripcioncargo AS cargo, t.basico
                   FROM terceros t
                        INNER JOIN seccion s ON (t.seccionid = s.seccionid)
                        INNER JOIN cargos c ON (t.cargoid = c.cargoid)
                  WHERE t.esempleadoactivo = 'CHECKED'
                        AND t.basico > 0                            
                        AND (t.esempleadoactivo = 'CHECKED' AND (t.extralegal = '' OR t.extralegal IS NULL))
                        AND t.areaid = 1                         
                        AND t.fecingreso <= '".$fechastaper."'
                 UNION
                 SELECT t.terid, t.codvende, t.dni AS documento, 
                        CONCAT(t.primernombre,' ',t.segundonombre,' ',t.primerapellido,' ',t.segundoapellido) AS nombreemp, 
                        s.descripcionsec AS seccion, c.descripcioncargo AS cargo, t.basico
                   FROM terceros t
                        INNER JOIN seccion s ON (t.seccionid = s.seccionid)
                        INNER JOIN cargos c ON (t.cargoid = c.cargoid)
                  WHERE t.fecharetiro BETWEEN '".$fecdesdeper."' AND '".$fechastaper."'
                        AND t.basico > 0
                        AND t.areaid = 1
                        AND t.extralegal = 'CHECKED' 
               ORDER BY 2";

        // Encabezado del informe
        $cont.='<script type="text/javascript" src="lib/sorttable.js"></script>
                <table width="100%" class="sortable">
                 <thead> 
                  <tr class="TituloTabla" style="display:block;padding-top:5px;height:20px;"> 
                   <td width="12">&nbsp; </td>
                   <td width="52" align="left"> C&oacute;digo </td>				 
                   <td width="110" align="left"> Documento </td>
                   <td width="278" align="left"> Nombre </td>			
                   <td width="207" align="left"> Secci&oacute;n </td>		
                   <td width="191" align="left"> Cargo </td>	
                   <td width="100" align="right"> B&aacute;sico </td>
                   <td width="37"> &nbsp; </td>				 
                   <td width="43"> &nbsp; </td>               
                  </tr>
                 </thead>
                 <tbody style="display:block; width:1050; height:300px; overflow-Y:scroll">';

        // Detalle del informe
        $i = 0;
        $conex  = $clase->Conectar();
        $result = mysql_query($vsql,$conex);
        while($row = mysql_fetch_array($result))
        {
            $i++;
            if($i%2 == 0)
                $cont.='<tr class="TablaDocsPar">';
            else
                $cont.='<tr class="TablaDocsImPar">';

            $sueldo = $row['basico'];

            $cont.=' <td width="12"> &nbsp; </td>
                     <td width="52" align="left"> '.$row['codvende'].' </td>	
                     <td width="110" align="left"> '.$row['documento'].' </td>
                     <td width="278" align="left"> '.$row['nombreemp'].' </td>
                     <td width="207" align="left"> '.$row['seccion'].' </td>	
                     <td width="191" align="left"> '.$row['cargo'].' </td>
                     <td width="100" align="right"> '.number_format($sueldo).' </td>
                     <td width="70" align="right">
                      <a href="terceros.php?opcion=detalles2&id='.$row['terid'].'" target="_blank"> 
                       <img src="images/basicas/iconobuscar.png" border="0" width="20" height="20"> 
                      </a>
                     </td>
                     <td width="10"> &nbsp; </td>
                    </tr>';
            $numeroadm++;
        }

        $cont.=' </tbody> 
                </table><br>';

        $cont.='<table width="100%">
                 <tr class="TituloTabla"> 
                  <td width="1638"> &nbsp; </td>
                 </tr>
                </table>';

        // ------------------------------------------------------------------------------------------------------------------------------------ //
        // Descripción de área de ventas
        $vsql14 = "SELECT IFNULL(COUNT(*),0) numvts1 
                     FROM terceros t
                          INNER JOIN seccion s ON (t.seccionid = s.seccionid)
                          INNER JOIN cargos c ON (t.cargoid = c.cargoid)
                    WHERE t.esempleadoactivo = 'CHECKED'
                          AND t.basico > 0 
                          AND (t.esempleadoactivo = 'CHECKED' AND (t.extralegal = '' OR t.extralegal IS NULL))
                          AND t.areaid = 2                 
                          AND t.fecingreso <= '".$fechastaper."'";
        $numvts1 = $clase->SeleccionarUno($vsql14);

        $vsql15 = "SELECT IFNULL(COUNT(*),0) numvts2
                     FROM terceros t
                          INNER JOIN seccion s ON (t.seccionid = s.seccionid)
                          INNER JOIN cargos c ON (t.cargoid = c.cargoid)
                    WHERE t.fecharetiro BETWEEN '".$fecdesdeper."' AND '".$fechastaper."'
                          AND t.basico > 0 
                          AND t.areaid = 2
                          AND t.extralegal = 'CHECKED'";
        $numvts2 = $clase->SeleccionarUno($vsql15);

        $totempvts = $numvts1 + $numvts2;

        // pinto en encabezado
        $cont.='<table width="100%">
                 <tr class="CabezoteTabla"> 
                  <td width="10"> &nbsp; </td>
                  <td width="37"> &nbsp; </td>
                  <td width="800"> &Aacute;rea de ventas <font color="blue">('.number_format($totempvts).' empleados)</font> </td>
                  <td> &nbsp; </td>
                  <td> &nbsp; </td>                  
                  <td width="10"> &nbsp; </td>
                  <td width="8"> &nbsp; </td>
                 </tr>	
                </table>';
        
        // Consulta para el área de ventas
        $vsql2 = "SELECT t.terid, t.codvende, t.dni AS documento, 
                         CONCAT(t.primernombre,' ',t.segundonombre,' ',t.primerapellido,' ',t.segundoapellido) AS nombreemp, 
                         s.descripcionsec AS seccion, c.descripcioncargo AS cargo, t.basico
                    FROM terceros t
                         INNER JOIN seccion s ON (t.seccionid = s.seccionid)
                         INNER JOIN cargos c ON (t.cargoid = c.cargoid)
                   WHERE t.esempleadoactivo = 'CHECKED'
                         AND t.basico > 0 
                         AND (t.esempleadoactivo = 'CHECKED' AND (t.extralegal = '' OR t.extralegal IS NULL))
                         AND t.areaid = 2                 
                         AND t.fecingreso <= '".$fechastaper."'
                  UNION
                  SELECT t.terid, t.codvende, t.dni AS documento, 
                         CONCAT(t.primernombre,' ',t.segundonombre,' ',t.primerapellido,' ',t.segundoapellido) AS nombreemp, 
                         s.descripcionsec AS seccion, c.descripcioncargo AS cargo, t.basico
                    FROM terceros t
                         INNER JOIN seccion s ON (t.seccionid = s.seccionid)
                         INNER JOIN cargos c ON (t.cargoid = c.cargoid)
                   WHERE t.fecharetiro BETWEEN '".$fecdesdeper."' AND '".$fechastaper."'
                         AND t.basico > 0 
                         AND t.areaid = 2
                         AND t.extralegal = 'CHECKED'
                ORDER BY 2";

        // Encabezado del informe
        $cont.='<script type="text/javascript" src="lib/sorttable.js"></script>
                <table width="100%" class="sortable">
                 <thead> 
                  <tr class="TituloTabla" style="display:block;padding-top:5px;height:20px;"> 
                   <td width="12">&nbsp; </td>
                   <td width="52" align="left"> C&oacute;digo </td>				 
                   <td width="110" align="left"> Documento </td>
                   <td width="278" align="left"> Nombre </td>			
                   <td width="207" align="left"> Secci&oacute;n </td>		
                   <td width="191" align="left"> Cargo </td>	
                   <td width="100" align="right"> B&aacute;sico </td>
                   <td width="37">&nbsp; </td>				 
                   <td width="43">&nbsp; </td>               
                  </tr>
                 </thead>
                 <tbody style="display:block; width:1050; height:300px; overflow-Y:scroll">';

        // Detalle del informe
        $i = 0;
        $conex  = $clase->Conectar();
        $result2 = mysql_query($vsql2,$conex);
        while($row2 = mysql_fetch_array($result2))
        {
            $i++;
            if($i%2 == 0)
                $cont.='<tr class="TablaDocsPar">';
            else
                $cont.='<tr class="TablaDocsImPar">';

            $sueldo = $row2['basico'];
            
            $cont.=' <td width="12">&nbsp;</td>
                     <td width="52" align="left"> '.$row2['codvende'].' </td>
                     <td width="110" align="left"> '.$row2['documento'].' </td>
                     <td width="278" align="left"> '.$row2['nombreemp'].' </td>			
                     <td width="207" align="left"> '.$row2['seccion'].' </td>		
                     <td width="191" align="left"> '.$row2['cargo'].' </td>	
                     <td width="100" align="right"> '.number_format($sueldo).' </td>
                     <td width="70" align="right">
                      <a href="terceros.php?opcion=detalles2&id='.$row2['terid'].'" target="_blank"> 
                       <img src="images/basicas/iconobuscar.png" border="0" width="20" height="20"> 
                      </a>
                     </td>	
                     <td width="10">&nbsp;</td>
                    </tr>';
            
            $numerovts++;
        }

        $cont.=' </tbody> 
                </table><br>';

        $cont.='<table width="100%">
                 <tr class="TituloTabla"> 
                  <td width="1638"> &nbsp; </td>
                 </tr>
                </table>';

        // ------------------------------------------------------------------------------------------------------------------------------------ //
        // Descripción de extralegales
        $vsql16 = "SELECT IFNULL(COUNT(*),0) extlg1 
                     FROM terceros t
                          INNER JOIN seccion s ON (t.seccionid = s.seccionid)
                          INNER JOIN cargos c ON (t.cargoid = c.cargoid)
                    WHERE t.esempleadoactivo = 'CHECKED'
                          AND t.basico > 0                            
                          AND t.extralegal = 'CHECKED'                         
                          AND t.fecingreso <= '".$fechastaper."'";
        $extlg1 = $clase->SeleccionarUno($vsql16);

        $vsql17 = "SELECT IFNULL(COUNT(*),0) extlg2 
                     FROM terceros t
                          INNER JOIN seccion s ON (t.seccionid = s.seccionid)
                          INNER JOIN cargos c ON (t.cargoid = c.cargoid)
                    WHERE t.fecharetiro BETWEEN '".$fecdesdeper."' AND '".$fechastaper."'
                          AND t.basico > 0                            
                          AND t.extralegal = 'CHECKED'";
        $extlg2 = $clase->SeleccionarUno($vsql17);

        $totextralg = $extlg1 + $extlg2;

        // pinto en encabezado
        $cont.='<table width="100%">
                 <tr class="CabezoteTabla"> 
                  <td width="10"> &nbsp; </td>
                  <td width="37"> &nbsp; </td>
                  <td width="800"> Extralegales <font color="blue">('.number_format($totextralg).' empleados)</font> </td>
                  <td> &nbsp; </td>
                  <td> &nbsp; </td>
                  <td width="10"> &nbsp; </td>
                  <td width="8"> &nbsp; </td>
                 </tr>
                </table>';

        // Consulta para los extralegales
        $vsql3 = "SELECT t.terid, t.codvende, t.dni AS documento, 
                         CONCAT(t.primernombre,' ',t.segundonombre,' ',t.primerapellido,' ',t.segundoapellido) AS nombreemp, 
                         s.descripcionsec AS seccion, c.descripcioncargo AS cargo, t.basico
                    FROM terceros t
                         INNER JOIN seccion s ON (t.seccionid = s.seccionid)
                         INNER JOIN cargos c ON (t.cargoid = c.cargoid)
                   WHERE t.esempleadoactivo = 'CHECKED'
                         AND t.basico > 0                            
                         AND t.extralegal = 'CHECKED'                         
                         AND t.fecingreso <= '".$fechastaper."'
                  UNION
                  SELECT t.terid, t.codvende, t.dni AS documento, 
                         CONCAT(t.primernombre,' ',t.segundonombre,' ',t.primerapellido,' ',t.segundoapellido) AS nombreemp, 
                         s.descripcionsec AS seccion, c.descripcioncargo AS cargo, t.basico
                    FROM terceros t
                         INNER JOIN seccion s ON (t.seccionid = s.seccionid)
                         INNER JOIN cargos c ON (t.cargoid = c.cargoid)
                   WHERE t.fecharetiro BETWEEN '".$fecdesdeper."' AND '".$fechastaper."'
                         AND t.basico > 0                            
                         AND t.extralegal = 'CHECKED'
                ORDER BY 2";

        // Encabezado del informe
        $cont.='<script type="text/javascript" src="lib/sorttable.js"></script>
                <table width="100%" class="sortable">
                 <thead> 
                  <tr class="TituloTabla" style="display:block;padding-top:5px;height:20px;"> 
                   <td width="12"> &nbsp; </td>
                   <td width="52" align="left"> C&oacute;digo </td>				 
                   <td width="110" align="left"> Documento </td>
                   <td width="278" align="left"> Nombre </td>			
                   <td width="207" align="left"> Secci&oacute;n </td>		
                   <td width="191" align="left"> Cargo </td>	
                   <td width="100" align="right"> B&aacute;sico </td>
                   <td width="37"> &nbsp; </td>				 
                   <td width="43"> &nbsp; </td>               
                  </tr>
                 </thead>
                 <tbody style="display:block; width:1050; height:300px; overflow-Y:scroll">';

        // Detalle del informe
        $i = 0;
        $conex  = $clase->Conectar();
        $result3 = mysql_query($vsql3,$conex);
        while($row3 = mysql_fetch_array($result3)) 
        {
            $i++;
            if($i%2 == 0)
                $cont.='<tr class="TablaDocsPar">';
            else
                $cont.='<tr class="TablaDocsImPar">';

            $sueldo = $row3['basico'];
            
            $cont.=' <td width="12"> &nbsp; </td>
                     <td width="52" align="left"> '.$row3['codvende'].' </td>
                     <td width="110" align="left"> '.$row3['documento'].' </td>
                     <td width="278" align="left"> '.$row3['nombreemp'].' </td>			
                     <td width="207" align="left"> '.$row3['seccion'].' </td>		
                     <td width="191" align="left"> '.$row3['cargo'].' </td>	
                     <td width="100" align="right"> '.number_format($sueldo).' </td>
                     <td width="70" align="right">
                      <a href="terceros.php?opcion=detalles2&id='.$row3['terid'].'" target="_blank"> 
                       <img src="images/basicas/iconobuscar.png" border="0" width="20" height="20"> 
                      </a>
                     </td>				 
                     <td width="10">&nbsp;</td>
                    </tr>';

            $numextral++;
        }

        $cont.=' </tbody> 
                </table><br>';

        // Impresión de la cantidad de empleados
        $totalempleaodos = $numregadn + $numregvts + $numregext;

        $totalempl = $numeroadm + $numerovts + $numextral;

        // totales
        $cont.='<table width="100%">
                 <tr class="TituloTabla"> 
                  <td width="1638" align="center"> 
                   <b> Total de empleados: <font color="WHITE"> '.number_format($totalempl).' </font> </b>
                  </td>
                 </tr>
                </table>';        
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: empperpdf
    // Creación: 27/05/2021		última modificación: 03/09/2021
    // Creador: Luis Flórez		modificado por: Luis Flórez
    // Descripción: Opción que genera el informe con salida tipo pdf de los empleados que se 
    //              procesarán en el periodo actual    
    // Última modificación: Se incorporó el campo de empleado activo en la nómina 
    //                      (11/08/2021)
    //                      Se excluyeron de la consulta los empleados con fecha de ingreso 
    //                      superior a la fecha límite del periodo actual
    ////////////////////////////////////////////////////////////////////////////////////////    
    if($opcion=="empperpdf")
    {
        // Traducción al español del mes que devuelve la función date()
        $mesimp = date('F');
        if($mesimp=="January")       $mesimp = "Enero";
        if($mesimp=="February")      $mesimp = "Febrero";
        if($mesimp=="March")         $mesimp = "Marzo";
        if($mesimp=="April")         $mesimp = "Abril";
        if($mesimp=="May")           $mesimp = "Mayo";
        if($mesimp=="June")          $mesimp = "Junio";
        if($mesimp=="July")          $mesimp = "Julio";
        if($mesimp=="August")        $mesimp = "Agosto";
        if($mesimp=="September")     $mesimp = "Septiembre";
        if($mesimp=="October")       $mesimp = "Octubre";
        if($mesimp=="November")      $mesimp = "Noviembre";
        if($mesimp=="December")      $mesimp = "Diciembre";

        // Obtengo el nombre del periodo a procesar
        $vsql = "SELECT periodoid
                   FROM periodosnomina 
                  WHERE periodoid = (SELECT MIN(periodoid) FROM periodosnomina WHERE cerrado ='')";
        $periodoid = $clase->SeleccionarUno($vsql);

        $descripcion = $clase->BDLockup($periodoid,'periodosnomina','periodoid','descripcion');

        // Fechas del periodo actual
        $fecdesdeper = $clase->BDLockup($periodoid,'periodosnomina','periodoid','fecdesde');
        $fechastaper = $clase->BDLockup($periodoid,'periodosnomina','periodoid','fechasta');

        // Procedo a construir el encabezado del recibo
        ini_set("memory_limit","200M");
        require('lib/fpdf/fpdf.php');
        $pdf=new FPDF();

        // ------------------------------------------------------------------------------------------------------------------------------ //
        // área de administración

        // Página nueva
        $pdf->AddPage("");
        $pagina = 1;

        // Logo Dromedicas
        $pdf->Image('images/empresa/logo-dromedicas-en-azul.png',10,10,12,15,'PNG','');

        // Imprimo el encabezado del informe
        $x = 25;
        $y = 13;
        $pdf->SetFont('Arial','B',10);
        $enc= "DROMEDICAS DEL ORIENTE SAS - NIT: 900265730-0";
        $pdf->Text($x,$y,$enc);

        // Fecha y hora de impresión
        $fechoraimp = $mesimp." ".date('d')." de ".date('Y g:i a')."    Pagina: ".$pagina;

        $pdf->SetFont('Arial','',8);
        $pdf->Text($x+124,$y,$fechoraimp);

        $pdf->SetFont('Arial','B',10);
        $enc= "INFORME DE EMPLEADOS POR PERIODO";               $pdf->Text($x,$y+5,$enc);

        $enc= $descripcion;                                     $pdf->Text($x,$y+10,$enc);

        // Encabezado del informe
        $pdf->SetFillColor(220,220,220);
        $pdf->Rect(5,38,200,8,'F');
        $pdf->SetFont('Arial','B',9);

        $enc= "AREA DE ADMINISTRACION";                         $pdf->Text($x-17,$y+20,$enc);
        $enc= "NRO";                                            $pdf->Text($x-17,$y+30,$enc);
        $enc= "DOCUMENTO";                                      $pdf->Text($x-8,$y+30,$enc);
        $enc= "NOMBRE";                                         $pdf->Text($x+15,$y+30,$enc);
        $enc= "SECCION";                                        $pdf->Text($x+84,$y+30,$enc);
        $enc= "CARGO";                                          $pdf->Text($x+123,$y+30,$enc);
        $enc= "BASICO";                                         $pdf->Text($x+165,$y+30,$enc);

        // Consulta para los empleados del área de administración
        $vsql = "SELECT t.terid, t.codvende, t.dni AS documento, 
                        CONCAT(t.primernombre,' ',t.segundonombre,' ',t.primerapellido,' ',t.segundoapellido) AS nombreemp, 
                        s.descripcionsec AS seccion, c.descripcioncargo AS cargo, t.basico
                   FROM terceros t
                        INNER JOIN seccion s ON (t.seccionid = s.seccionid)
                        INNER JOIN cargos c ON (t.cargoid = c.cargoid)
                  WHERE t.esempleadoactivo = 'CHECKED'
                        AND t.basico > 0                            
                        AND (t.esempleadoactivo = 'CHECKED' AND (t.extralegal = '' OR t.extralegal IS NULL))
                        AND t.areaid = 1 
                        AND t.fecingreso <= '".$fechastaper."'
                 UNION
                 SELECT t.terid, t.codvende, t.dni AS documento, 
                        CONCAT(t.primernombre,' ',t.segundonombre,' ',t.primerapellido,' ',t.segundoapellido) AS nombreemp, 
                        s.descripcionsec AS seccion, c.descripcioncargo AS cargo, t.basico
                   FROM terceros t
                        INNER JOIN seccion s ON (t.seccionid = s.seccionid)
                        INNER JOIN cargos c ON (t.cargoid = c.cargoid)
                  WHERE t.fecharetiro BETWEEN '".$fecdesdeper."' AND '".$fechastaper."' 
                        AND t.basico > 0                            
                        AND (t.esempleadoactivo = 'CHECKED' AND (t.extralegal = '' OR t.extralegal IS NULL))
                        AND t.areaid = 1";
        
        // Impresión del detalle del informe
        $conex  = $clase->Conectar();
        $result = mysql_query($vsql,$conex);        
        $x = 8;
        $y = 51;
        $i = 0;
        $linea = 0;
        while($row = mysql_fetch_array($result))
        {
            $i++;
            if($i%38==0)
            {
                $pdf->AddPage("");
                $pagina++;

                // Logo Dromedicas
                $pdf->Image('images/empresa/logo-dromedicas-en-azul.png',10,10,12,15,'PNG','');

                // Imprimo el encabezado del informe
                $x = 25;
                $y = 13;
                
                $pdf->SetFont('Arial','B',10);
                $enc= "DROMEDICAS DEL ORIENTE SAS - NIT: 900265730-0";                      $pdf->Text($x,$y,$enc);

                // Fecha y hora de impresión
                $fechoraimp = $mesimp." ".date('d')." de ".date('Y g:i a')."    Pagina: ".$pagina;

                $pdf->SetFont('Arial','',8);
                $pdf->Text($x+124,$y,$fechoraimp);

                $pdf->SetFont('Arial','B',10);
                $enc= "INFORME DE EMPLEADOS POR PERIODO";                                   $pdf->Text($x,$y+5,$enc);
        
                $enc= $descripcion;                                                         $pdf->Text($x,$y+10,$enc);
        
                $pdf->SetFillColor(220,220,220);
                $pdf->Rect(5,38,200,8,'F');
                $pdf->SetFont('Arial','B',9);
        
                $enc= "AREA DE ADMINISTRACION";                                             $pdf->Text($x-17,$y+20,$enc);
                $enc= "NRO";                                                                $pdf->Text($x-17,$y+30,$enc);
                $enc= "DOCUMENTO";                                                          $pdf->Text($x-8,$y+30,$enc);
                $enc= "NOMBRE";                                                             $pdf->Text($x+15,$y+30,$enc);
                $enc= "SECCION";                                                            $pdf->Text($x+84,$y+30,$enc);
                $enc= "CARGO";                                                              $pdf->Text($x+123,$y+30,$enc);
                $enc= "BASICO";                                                             $pdf->Text($x+165,$y+30,$enc);

                $x = 8;
                $y = 51;
            } 
            $linea++;

            $pdf->SetFont('Arial','',8);
            $pdf->Text($x,$y,$linea);
            $pdf->Text($x+9,$y,$row['documento']);
            $pdf->Text($x+32,$y,$row['nombreemp']);
            $pdf->Text($x+101,$y,substr($row['seccion'],0,20));
            $pdf->Text($x+140,$y,substr($row['cargo'],0,22));

            $basico = $row['basico'];
            $longitud = strlen($basico);

            if($longitud==6)                $pdf->Text($x+184,$y,number_format($basico));
            if($longitud==7)                $pdf->Text($x+182,$y,number_format($basico));

            $y+=6;
        }

        // ------------------------------------------------------------------------------------------------------------------------------ //
        // área de ventas

        // Página nueva
        $pdf->AddPage("");
        $pagina = 1;

        // Logo Dromedicas
        $pdf->Image('images/empresa/logo-dromedicas-en-azul.png',10,10,12,15,'PNG','');

        // Imprimo el encabezado del informe
        $x = 25;
        $y = 13;
        $pdf->SetFont('Arial','B',10);
        $enc= "DROMEDICAS DEL ORIENTE SAS - NIT: 900265730-0";
        $pdf->Text($x,$y,$enc);

        // Fecha y hora de impresión
        $fechoraimp = $mesimp." ".date('d')." de ".date('Y g:i a')."    Pagina: ".$pagina;

        $pdf->SetFont('Arial','',8);
        $pdf->Text($x+124,$y,$fechoraimp);

        $pdf->SetFont('Arial','B',10);
        $enc= "INFORME DE EMPLEADOS POR PERIODO";           $pdf->Text($x,$y+5,$enc);

        $enc= $descripcion;                                 $pdf->Text($x,$y+10,$enc);

        // Encabezado del informe
        $pdf->SetFillColor(220,220,220);
        $pdf->Rect(5,38,200,8,'F');
        $pdf->SetFont('Arial','B',9);

        $enc= "AREA DE VENTAS";                             $pdf->Text($x-17,$y+20,$enc);
        $enc= "NRO";                                        $pdf->Text($x-17,$y+30,$enc);
        $enc= "DOCUMENTO";                                  $pdf->Text($x-8,$y+30,$enc);
        $enc= "NOMBRE";                                     $pdf->Text($x+15,$y+30,$enc);
        $enc= "SECCION";                                    $pdf->Text($x+84,$y+30,$enc);
        $enc= "CARGO";                                      $pdf->Text($x+123,$y+30,$enc);
        $enc= "BASICO";                                     $pdf->Text($x+165,$y+30,$enc);

        // Consulta para los empleados del área de ventas
        $vsql = "SELECT t.terid, t.codvende, t.dni AS documento, 
                        CONCAT(t.primernombre,' ',t.segundonombre,' ',t.primerapellido,' ',t.segundoapellido) AS nombreemp, 
                        s.descripcionsec AS seccion, c.descripcioncargo AS cargo, t.basico
                   FROM terceros t
                        INNER JOIN seccion s ON (t.seccionid = s.seccionid)
                        INNER JOIN cargos c ON (t.cargoid = c.cargoid)
                  WHERE t.esempleadoactivo = 'CHECKED'
                        AND t.basico > 0                            
                        AND (t.esempleadoactivo = 'CHECKED' AND (t.extralegal = '' OR t.extralegal IS NULL))
                        AND t.areaid = 2 
                        AND t.fecingreso <= '".$fechastaper."'
                 UNION
                 SELECT t.terid, t.codvende, t.dni AS documento, 
                        CONCAT(t.primernombre,' ',t.segundonombre,' ',t.primerapellido,' ',t.segundoapellido) AS nombreemp, 
                        s.descripcionsec AS seccion, c.descripcioncargo AS cargo, t.basico
                   FROM terceros t
                        INNER JOIN seccion s ON (t.seccionid = s.seccionid)
                        INNER JOIN cargos c ON (t.cargoid = c.cargoid)
                  WHERE t.fecharetiro BETWEEN '".$fecdesdeper."' AND '".$fechastaper."' 
                        AND t.basico > 0                            
                        AND (t.esempleadoactivo = 'CHECKED' AND (t.extralegal = '' OR t.extralegal IS NULL))
                        AND t.areaid = 2";
        
        // Impresión del detalle del informe
        $conex  = $clase->Conectar();
        $result = mysql_query($vsql,$conex);        
        $x = 8;
        $y = 51;
        $i = 0;
        $linea = 0;
        while($row = mysql_fetch_array($result))
        {
            $i++;
            if($i%38==0)
            {
                $pdf->AddPage("");
                $pagina++;

                // Logo Dromedicas
                $pdf->Image('images/empresa/logo-dromedicas-en-azul.png',10,10,12,15,'PNG','');

                // Imprimo el encabezado del informe
                $x = 25;
                $y = 13;
                
                $pdf->SetFont('Arial','B',10);
                $enc= "DROMEDICAS DEL ORIENTE SAS - NIT: 900265730-0";
                $pdf->Text($x,$y,$enc);

                // Fecha y hora de impresión
                $fechoraimp = $mesimp." ".date('d')." de ".date('Y g:i a')."    Pagina: ".$pagina;

                $pdf->SetFont('Arial','',8);
                $pdf->Text($x+124,$y,$fechoraimp);

                $pdf->SetFont('Arial','B',10);
                $enc= "INFORME DE EMPLEADOS POR PERIODO";           $pdf->Text($x,$y+5,$enc);
        
                $enc= $descripcion;                                 $pdf->Text($x,$y+10,$enc);
        
                $pdf->SetFillColor(220,220,220);
                $pdf->Rect(5,38,200,8,'F');
                $pdf->SetFont('Arial','B',9);
        
                $enc= "AREA DE VENTAS";                             $pdf->Text($x-17,$y+20,$enc);
                $enc= "NRO";                                        $pdf->Text($x-17,$y+30,$enc);
                $enc= "DOCUMENTO";                                  $pdf->Text($x-8,$y+30,$enc);
                $enc= "NOMBRE";                                     $pdf->Text($x+15,$y+30,$enc);
                $enc= "SECCION";                                    $pdf->Text($x+84,$y+30,$enc);
                $enc= "CARGO";                                      $pdf->Text($x+123,$y+30,$enc);
                $enc= "BASICO";                                     $pdf->Text($x+165,$y+30,$enc);

                $x = 8;
                $y = 51;
            } 
            $linea++;

            $pdf->SetFont('Arial','',8);
            $pdf->Text($x,$y,$linea);
            $pdf->Text($x+9,$y,$row['documento']);
            $pdf->Text($x+32,$y,$row['nombreemp']);
            $pdf->Text($x+101,$y,substr($row['seccion'],0,20));
            $pdf->Text($x+140,$y,substr($row['cargo'],0,22));

            $basico = $row['basico'];
            $longitud = strlen($basico);

            if($longitud==6)            $pdf->Text($x+184,$y,number_format($basico));
            if($longitud==7)            $pdf->Text($x+182,$y,number_format($basico));

            $y+=6;
        }

        // ------------------------------------------------------------------------------------------------------------------------------ //
        // Extralegales

        // Página nueva
        $pdf->AddPage("");
        $pagina = 1;

        // Logo Dromedicas
        $pdf->Image('images/empresa/logo-dromedicas-en-azul.png',10,10,12,15,'PNG','');

        // Imprimo el encabezado del informe
        $x = 25;
        $y = 13;
        $pdf->SetFont('Arial','B',10);
        $enc= "DROMEDICAS DEL ORIENTE SAS - NIT: 900265730-0";          $pdf->Text($x,$y,$enc);

        // Fecha y hora de impresión
        $fechoraimp = $mesimp." ".date('d')." de ".date('Y g:i a')."    Pagina: ".$pagina;

        $pdf->SetFont('Arial','',8);
        $pdf->Text($x+124,$y,$fechoraimp);

        $pdf->SetFont('Arial','B',10);
        $enc= "INFORME DE EMPLEADOS POR PERIODO";                       $pdf->Text($x,$y+5,$enc);

        $enc= $descripcion;                                             $pdf->Text($x,$y+10,$enc);

        // Encabezado del informe
        $pdf->SetFillColor(220,220,220);
        $pdf->Rect(5,38,200,8,'F');
        $pdf->SetFont('Arial','B',9);

        $enc= "EXTRALEGALES";                                           $pdf->Text($x-17,$y+20,$enc);
        $enc= "NRO";                                                    $pdf->Text($x-17,$y+30,$enc);
        $enc= "DOCUMENTO";                                              $pdf->Text($x-8,$y+30,$enc);
        $enc= "NOMBRE";                                                 $pdf->Text($x+15,$y+30,$enc);
        $enc= "SECCION";                                                $pdf->Text($x+84,$y+30,$enc);
        $enc= "CARGO";                                                  $pdf->Text($x+123,$y+30,$enc);
        $enc= "BASICO";                                                 $pdf->Text($x+165,$y+30,$enc);

        // Consulta para los empleados extralegales
        $vsql = "SELECT t.terid, t.codvende, t.dni AS documento, 
                        CONCAT(t.primernombre,' ',t.segundonombre,' ',t.primerapellido,' ',t.segundoapellido) AS nombreemp, 
                        s.descripcionsec AS seccion, c.descripcioncargo AS cargo, t.basico
                   FROM terceros t
                        INNER JOIN seccion s ON (t.seccionid = s.seccionid)
                        INNER JOIN cargos c ON (t.cargoid = c.cargoid)
                  WHERE t.esempleadoactivo = 'CHECKED'
                        AND t.basico > 0                            
                        AND t.extralegal = 'CHECKED' 
                        AND t.fecingreso <= '".$fechastaper."'
                 UNION
                 SELECT t.terid, t.codvende, t.dni AS documento, 
                        CONCAT(t.primernombre,' ',t.segundonombre,' ',t.primerapellido,' ',t.segundoapellido) AS nombreemp, 
                        s.descripcionsec AS seccion, c.descripcioncargo AS cargo, t.basico
                   FROM terceros t
                        INNER JOIN seccion s ON (t.seccionid = s.seccionid)
                        INNER JOIN cargos c ON (t.cargoid = c.cargoid)
                  WHERE t.fecharetiro BETWEEN '".$fecdesdeper."' AND '".$fechastaper."'
                        AND t.basico > 0                            
                        AND t.extralegal = 'CHECKED'";
        
        // Impresión del detalle del informe
        $conex  = $clase->Conectar();
        $result = mysql_query($vsql,$conex);
        $x = 8;
        $y = 51;
        $i = 0;
        $linea = 0;
        while($row = mysql_fetch_array($result))
        {
            $i++;
            if($i%38==0)
            {
                $pdf->AddPage("");
                $pagina++;

                // Logo Dromedicas
                $pdf->Image('images/empresa/logo-dromedicas-en-azul.png',10,10,12,15,'PNG','');

                // Imprimo el encabezado del informe
                $x = 25;
                $y = 13;
                
                $pdf->SetFont('Arial','B',10);
                $enc= "DROMEDICAS DEL ORIENTE SAS - NIT: 900265730-0";              $pdf->Text($x,$y,$enc);

                // Fecha y hora de impresión
                $fechoraimp = $mesimp." ".date('d')." de ".date('Y g:i a')."    Pagina: ".$pagina;

                $pdf->SetFont('Arial','',8);
                $pdf->Text($x+124,$y,$fechoraimp);

                $pdf->SetFont('Arial','B',10);
                $enc= "INFORME DE EMPLEADOS POR PERIODO";                           $pdf->Text($x,$y+5,$enc);
        
                $enc= $descripcion;
                $pdf->Text($x,$y+10,$enc);
        
                $pdf->SetFillColor(220,220,220);
                $pdf->Rect(5,38,200,8,'F');
                $pdf->SetFont('Arial','B',9);
        
                $enc= "EXTRALEGALES";                                               $pdf->Text($x-17,$y+20,$enc);
                $enc= "NRO";                                                        $pdf->Text($x-17,$y+30,$enc);
                $enc= "DOCUMENTO";                                                  $pdf->Text($x-8,$y+30,$enc);
                $enc= "NOMBRE";                                                     $pdf->Text($x+15,$y+30,$enc);
                $enc= "SECCION";                                                    $pdf->Text($x+84,$y+30,$enc);
                $enc= "CARGO";                                                      $pdf->Text($x+123,$y+30,$enc);
                $enc= "BASICO";                                                     $pdf->Text($x+165,$y+30,$enc);

                $x = 8;
                $y = 51;
            } 
            $linea++;

            $pdf->SetFont('Arial','',8);
            $pdf->Text($x,$y,$linea);
            $pdf->Text($x+9,$y,$row['documento']);
            $pdf->Text($x+32,$y,$row['nombreemp']);
            $pdf->Text($x+101,$y,substr($row['seccion'],0,20));
            $pdf->Text($x+140,$y,substr($row['cargo'],0,22));

            $basico = $row['basico'];
            $longitud = strlen($basico);

            if($longitud==6)                $pdf->Text($x+184,$y,number_format($basico));
            if($longitud==7)                $pdf->Text($x+182,$y,number_format($basico));

            $y+=6;
        }

        $pdf->Output();
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: empperxls
    // Creación: 26/07/2021		última modificación: 30/12/2021
    // Creador: Luis Flórez		modificado por: Luis Flórez
    // Descripción: Opción que genera el informe con salida a Excel de los empleados que se 
    //              procesarán en el periodo actual    
    // Última modificación: Se incorporó el campo de empleado activo en la nómina
    //                      Se excluyeron de la consulta los empleados con fecha de ingreso 
    //                      (11/08/2021)
    //                      Se excluyeron de la consulta los empleados con fecha de ingreso 
    //                      superior a la fecha límite del periodo actual (03/09/2021)
    //                      Inclusión de la columna con el número de cuenta bancaria
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion=="empperxls")
    {
        // Obtengo el nombre del periodo a procesar
        $vsql = "SELECT periodoid
                   FROM periodosnomina 
                  WHERE periodoid = (SELECT MIN(periodoid) FROM periodosnomina WHERE cerrado ='')";
        $periodoid = $clase->SeleccionarUno($vsql);

        $descripcion = $clase->BDLockup($periodoid,'periodosnomina','periodoid','descripcion');

        // Fechas del periodo actual
        $fecdesdeper = $clase->BDLockup($periodoid,'periodosnomina','periodoid','fecdesde');
        $fechastaper = $clase->BDLockup($periodoid,'periodosnomina','periodoid','fechasta');        
        
        require_once 'lib/PHPExcel.php';
        $clase = new Sistema();
        $clase->Conectar();
        ini_set("memory_limit","100M");

        // Consulta para los empleados del área de administración
        $vsql = "SELECT t.terid, t.codvende, t.dni AS documento, 
                        CONCAT(t.primernombre,' ',t.segundonombre,' ',t.primerapellido,' ',t.segundoapellido) AS nombreemp, 
                        s.descripcionsec AS seccion, c.descripcioncargo AS cargo, t.basico, t.numcuenta
                   FROM terceros t
                        INNER JOIN seccion s ON (t.seccionid = s.seccionid)
                        INNER JOIN cargos c ON (t.cargoid = c.cargoid)
                  WHERE t.esempleadoactivo = 'CHECKED'
                        AND t.basico > 0                            
                        AND (t.esempleadoactivo = 'CHECKED' AND (t.extralegal = '' OR t.extralegal IS NULL))
                        AND t.areaid = 1                        
                        AND t.fecingreso <= '".$fechastaper."'
                 UNION
                 SELECT t.terid, t.codvende, t.dni AS documento, 
                        CONCAT(t.primernombre,' ',t.segundonombre,' ',t.primerapellido,' ',t.segundoapellido) AS nombreemp, 
                        s.descripcionsec AS seccion, c.descripcioncargo AS cargo, t.basico, t.numcuenta
                   FROM terceros t
                        INNER JOIN seccion s ON (t.seccionid = s.seccionid)
                        INNER JOIN cargos c ON (t.cargoid = c.cargoid)
                  WHERE t.fecharetiro BETWEEN '".$fecdesdeper."' AND '".$fechastaper."'
                        AND t.basico > 0                            
                        AND (t.esempleadoactivo = 'CHECKED' AND (t.extralegal = '' OR t.extralegal IS NULL))
                        AND t.areaid = 1";

        // Preparación del entorno para la salida a Excel
        $clase = new Sistema();
        $clase->Nombredb = $_SESSION['DBNOMBRE'];
        error_reporting(E_ALL);
        ini_set('display_errors', TRUE);
        ini_set('display_startup_errors', TRUE);
        date_default_timezone_set('Europe/London');
    
        if (PHP_SAPI == 'cli')
            die('This example should only be run from a Web Browser');
    
        // Create new PHPExcel object
        $objPHPExcel = new PHPExcel();
    
        // Set document properties
        $objPHPExcel->getProperties()->setCreator("Sistemas y Soluciones Web de Colombia")
                                     ->setLastModifiedBy("Sistemas y Soluciones Web de Colombia")
                                     ->setTitle("Planilla de nomina - DROPOS")
                                     ->setSubject("Planilla de nomina - DROPOS")
                                     ->setDescription("Planilla de nomina - DROPOS")
                                     ->setKeywords("Planilla de nomina - DROPOS")
                                     ->setCategory("Categoria General");

        $objPHPExcel->setActiveSheetIndex(0)
                    ->setCellValue('A1', 'INFORME DE EMPLEADOS POR PERIODO')
                    ->setCellValue('A2', 'PERIODO: '.$descripcion)
                    ->setCellValue('A3', 'AREA ADMINISTRACION')
                    ->setCellValue('A4', 'NRO')
                    ->setCellValue('B4', 'DOCUMENTO')
                    ->setCellValue('C4', 'NOMBRE')
                    ->setCellValue('D4', 'SECCION')
                    ->setCellValue('E4', 'CARGO')
                    ->setCellValue('F4', 'BASICO')
                    ->setCellValue('G4', 'CUENTA');

        $objPHPExcel->getActiveSheet()->getColumnDimension('A')->setAutoSize(true);                 $objPHPExcel->getActiveSheet()->getColumnDimension('B')->setAutoSize(true);
        $objPHPExcel->getActiveSheet()->getColumnDimension('C')->setAutoSize(true);                 $objPHPExcel->getActiveSheet()->getColumnDimension('D')->setAutoSize(true);
        $objPHPExcel->getActiveSheet()->getColumnDimension('E')->setAutoSize(true);                 $objPHPExcel->getActiveSheet()->getColumnDimension('F')->setAutoSize(true);
        $objPHPExcel->getActiveSheet()->getColumnDimension('G')->setAutoSize(true);

        $conex  = $clase->Conectar();
        $result = mysql_query($vsql,$conex);
        $cant   = mysql_num_rows($result);
        $i=5;
        $nroadn=0;
        while($row = mysql_fetch_array($result))
        {
            $nroadn++;
            $objPHPExcel->setActiveSheetIndex(0)
                        ->setCellValue('A'.$i, number_format($nroadn))
                        ->setCellValue('B'.$i, $row['documento'])
                        ->setCellValue('C'.$i, $row['nombreemp'])
                        ->setCellValue('D'.$i, $row['seccion'])
                        ->setCellValue('E'.$i, $row['cargo'])
                        ->setCellValue('F'.$i, number_format($row['basico']))
                        ->setCellValue('G'.$i, $row['numcuenta']);
            $i++;
        }

        $rangoEncabezado = 'A4:G4';
        $rangoCeldas     = 'A4:G'.($i-1);
        
        // Consulta para los empleados del área de ventas
        $vsql = "SELECT t.terid, t.codvende, t.dni AS documento, 
                        CONCAT(t.primernombre,' ',t.segundonombre,' ',t.primerapellido,' ',t.segundoapellido) AS nombreemp, 
                        s.descripcionsec AS seccion, c.descripcioncargo AS cargo, t.basico, t.numcuenta
                   FROM terceros t
                        INNER JOIN seccion s ON (t.seccionid = s.seccionid)
                        INNER JOIN cargos c ON (t.cargoid = c.cargoid)
                  WHERE t.esempleadoactivo = 'CHECKED'
                        AND t.basico > 0                            
                        AND (t.esempleadoactivo = 'CHECKED' AND (t.extralegal = '' OR t.extralegal IS NULL))
                        AND t.areaid = 2                         
                        AND t.fecingreso <= '".$fechastaper."'
               UNION
               SELECT t.terid, t.codvende, t.dni AS documento, 
                        CONCAT(t.primernombre,' ',t.segundonombre,' ',t.primerapellido,' ',t.segundoapellido) AS nombreemp, 
                        s.descripcionsec AS seccion, c.descripcioncargo AS cargo, t.basico, t.numcuenta
                   FROM terceros t
                        INNER JOIN seccion s ON (t.seccionid = s.seccionid)
                        INNER JOIN cargos c ON (t.cargoid = c.cargoid)
                  WHERE t.fecharetiro BETWEEN '".$fecdesdeper."' AND '".$fechastaper."' 
                        AND t.basico > 0                            
                        AND (t.esempleadoactivo = 'CHECKED' AND (t.extralegal = '' OR t.extralegal IS NULL))
                        AND t.areaid = 2";

        $j = $i + 2;

        $celda1="A".strval($j);
        $celda2="B".strval($j);
        $celda3="C".strval($j);
        $celda4="D".strval($j);
        $celda5="E".strval($j);
        $celda6="F".strval($j);
        $celda7="G".strval($j);

        $celda8="A".strval($j-1);

        $objPHPExcel->setActiveSheetIndex(0)
                    ->setCellValue($celda8, 'AREA DE VENTAS');
                    
        $objPHPExcel->setActiveSheetIndex(0)
                    ->setCellValue($celda1, 'NRO')
                    ->setCellValue($celda2, 'DOCUMENTO')
                    ->setCellValue($celda3, 'NOMBRE')
                    ->setCellValue($celda4, 'SECCION')
                    ->setCellValue($celda5, 'CARGO')
                    ->setCellValue($celda6, 'BASICO')
                    ->setCellValue($celda7, 'CUENTA');

        $j++;
        $conex  = $clase->Conectar();
        $result = mysql_query($vsql,$conex);
        $cant   = mysql_num_rows($result);
        $nrovts=0;
        while($row = mysql_fetch_array($result))
        {
            $nrovts++;
            $objPHPExcel->setActiveSheetIndex(0)
                        ->setCellValue('A'.$j, number_format($nrovts))
                        ->setCellValue('B'.$j, $row['documento'])
                        ->setCellValue('C'.$j, $row['nombreemp'])
                        ->setCellValue('D'.$j, $row['seccion'])
                        ->setCellValue('E'.$j, $row['cargo'])
                        ->setCellValue('F'.$j, number_format($row['basico']))
                        ->setCellValue('G'.$j, $row['numcuenta']);
            $j++;
        }

        $rangoEncabezado = 'A4:G4';
        $rangoCeldas     = 'A4:G'.($j-1);

        // Consulta para los empleados extralegales
        $vsql = "SELECT t.terid, t.codvende, t.dni AS documento, 
                        CONCAT(t.primernombre,' ',t.segundonombre,' ',t.primerapellido,' ',t.segundoapellido) AS nombreemp, 
                        s.descripcionsec AS seccion, c.descripcioncargo AS cargo, t.basico, t.numcuenta
                   FROM terceros t
                        INNER JOIN seccion s ON (t.seccionid = s.seccionid)
                        INNER JOIN cargos c ON (t.cargoid = c.cargoid)
                  WHERE t.esempleadoactivo = 'CHECKED'
                        AND t.basico > 0                            
                        AND t.extralegal = 'CHECKED'                         
                        AND t.fecingreso <= '".$fechastaper."'
                 UNION
                 SELECT t.terid, t.codvende, t.dni AS documento, 
                        CONCAT(t.primernombre,' ',t.segundonombre,' ',t.primerapellido,' ',t.segundoapellido) AS nombreemp, 
                        s.descripcionsec AS seccion, c.descripcioncargo AS cargo, t.basico, t.numcuenta
                   FROM terceros t
                        INNER JOIN seccion s ON (t.seccionid = s.seccionid)
                        INNER JOIN cargos c ON (t.cargoid = c.cargoid)
                  WHERE t.fecharetiro BETWEEN '".$fecdesdeper."' AND '".$fechastaper."' 
                        AND t.basico > 0                            
                        AND t.extralegal = 'CHECKED'";

        $rangoEncabezado2 = $celda1.':'.$celda6;
        $rangoCeldas2     = $celda1.($j-1);

        $k = $j + 2;

        $celda1="A".strval($k);
        $celda2="B".strval($k);
        $celda3="C".strval($k);
        $celda4="D".strval($k);
        $celda5="E".strval($k);
        $celda6="F".strval($k);
        $celda7="G".strval($k);

        $celda8="A".strval($k-1);

        $objPHPExcel->setActiveSheetIndex(0)
                    ->setCellValue($celda8, 'EXTRALEGALES');

        $objPHPExcel->setActiveSheetIndex(0)
                    ->setCellValue($celda1, 'NRO')
                    ->setCellValue($celda2, 'DOCUMENTO')
                    ->setCellValue($celda3, 'NOMBRE')
                    ->setCellValue($celda4, 'SECCION')
                    ->setCellValue($celda5, 'CARGO')
                    ->setCellValue($celda6, 'BASICO')
                    ->setCellValue($celda7, 'CUENTA');

        $k++;
        $conex  = $clase->Conectar();
        $result = mysql_query($vsql,$conex);
        $cant   = mysql_num_rows($result);
        $nroext=0;
        while($row = mysql_fetch_array($result))
        {
            $nroext++;
            $objPHPExcel->setActiveSheetIndex(0)
                        ->setCellValue('A'.$k, number_format($nroext))
                        ->setCellValue('B'.$k, $row['documento'])
                        ->setCellValue('C'.$k, $row['nombreemp'])
                        ->setCellValue('D'.$k, $row['seccion'])
                        ->setCellValue('E'.$k, $row['cargo'])
                        ->setCellValue('F'.$k, number_format($row['basico']))
                        ->setCellValue('G'.$k, $row['numcuenta']);
            $k++;
        }

        $rangoEncabezado3 = $celda1.':'.$celda7;
        $rangoCeldas3     = $celda1.($k-1);        

        // ----------------------------------------------------------------------------------------------------------------------------------------------------------- //        
        // Formato de Encabezado y Celdas
        $objPHPExcel->getActiveSheet()->getRowDimension('1')->setRowHeight(15);
        
        $EstiloCeldas = array(
        'borders' => array(
            'allborders' => array(
                'style' => PHPExcel_Style_Border::BORDER_THIN,
                'color' => array('argb' => '00000000'),
            ),
            ),
        );        
        /// Formato de Encabezados 
        $EstiloEncabezado = array(
        'font' => array(
            'bold' => true,
        ),
        'alignment' => array(
            'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,
            'vertical' => PHPExcel_Style_Alignment::VERTICAL_CENTER,		
        ),
        'borders' => array(
            'allborders' => array(
                'style' => PHPExcel_Style_Border::BORDER_THIN,
                'color' => array('argb' => '00000000'),
            ),
        ),
        'fill' => array(
            'type' => PHPExcel_Style_Fill::FILL_SOLID,
            'rotation' => 90,
            'startcolor' => array(
                'argb' => '00FFFFCC',
            ),
            'endcolor' => array(
                'argb' => 'FFFFFF',
            ),
            ),
        );        
        // Rename worksheet
        $objPHPExcel->getActiveSheet()->setTitle('Empleados en el periodo');
        // Set active sheet index to the first sheet, so Excel opens this as the first sheet
        $objPHPExcel->setActiveSheetIndex(0);
        // Redirect output to a client’s web browser (Excel5)
        header('Content-Type: application/vnd.ms-excel');
        // --------------------------------------------------------------------- //
        // header('Content-Disposition: attachment;filename="planillanom.xls"');
        $nombrearcexcel = "empleados en el periodo ".strtolower($descripcion).".xls";
        header('Content-Disposition: attachment;filename='.$nombrearcexcel.'');
        // --------------------------------------------------------------------- //
        header('Cache-Control: max-age=0');
        /// Genero la Salida
        $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');
        $objWriter->save('php://output');
        exit;
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: importarexcelcedulas
    // Creación: 30/09/2022		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción para captar la hoja de Excel desde donde se actualizarán los 
    //              empleados activos
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "importarexcelcedulas")
    {
        $cont = '';
        $servidor = $_SERVER['SERVER_NAME'].":".$_SERVER['SERVER_PORT'];

        // Validación del servidor
        if(($servidor!="dromedicas.sytes.net:9996")&&($servidor!="192.168.14.248:9999"))
            $cont.='<table width="400">
                     <tr class="CabezoteTabla"> 
                      <td align="center"> <b>Servidor incorrecto </b> </td>
                     </tr> 
                     <tr class="CabezoteTabla"> 
                      <td align="center"> 
                       <font color=red> Este servidor est&aacute; inhabilitado para hacer este <br> 
                       proceso, por favor diríjase al servidor </font><br> 
                       <font color=blue> 192.168.14.248:9999 </font> <br>
                       <font color=red>o al servidor </font> <br> 
                       <font color=blue> dromedicas.sytes.net:9996 </font> <br>
                       <font color=red> para poder ejecutar este proceso </font> <br><br>
                      </td> 
                     </tr>
                     <tr class="TablaDocsPar">        
                      <td width="100%" align="center"> 
                       <form name="importa" method="post" action="empleadosperiodo.php?opcion=ventanaactdatos" id="theform" enctype="multipart/form-data">
                        <input type="submit" name="enviar" id="enviarr"  value="aceptar" class="button blue" /> 
                       </form> 
                      </td>    
                     </tr>
                    </table>';
        else
        {
            // Obtengo el periodo actual
            $vsql = "SELECT periodoid
                       FROM periodosnomina 
                      WHERE periodoid = (SELECT MIN(periodoid) FROM periodosnomina WHERE cerrado ='')";
            $periodoid = $clase->SeleccionarUno($vsql);
    
            $descripcion = $clase->BDLockup($periodoid,'periodosnomina','periodoid','descripcion');
    
            // pinto la ventana
            $cont.='<script type="text/javascript" src="lib/jquery-2.1.3.min.js"></script>
                    <script>
                     $(function()
                     {
                      $("#enviarr").on("click",function()
                      {
                        $(this).val("Espere por favor ...")
                        .attr("disabled","disabled");
                        $("#theform").submit();
                      });
                     });
                    </script>
                    <table width="400">
                     <tr class="CabezoteTabla"> 
                      <td align="center"> <b>Activar empleados masivamente <br> en el periodo <br> <font color="BLUE">'.strtolower($descripcion).'</font></b> <br><br></td> 
                     </tr> 
                    </table>
                    <table width="400">
                     <tr class="TablaDocsPar">        
                      <td width="100%" align="center"> 
                       <form name="importa" method="post" action="?opcion=importacionexcelesempleado" id="theform" enctype="multipart/form-data">
                       <input type="file" name="excel" /><br><br>                       
                       <input type="submit" name="enviar" id="enviarr"  value="Importar archivo" class="button blue" />
                       <input type="hidden" value="upload" name="action" />                  
                       </form> 
                      </td>    
                     </tr>
                    </table>';
    
            $cont.='<table width="400">
                     <tr class="TablaDocsPar"> <td align="left"> &nbsp; La hoja de Excel debe tener la siguiente estructura: </td> </tr>
                     <tr class="TablaDocsPar"> <td align="left"> &nbsp; Columna <b>A</b>: C&eacute;dula </td> </tr>
                    </table>';
    
            $cont.='<table width="400">
                     <tr class="TablaDocsPar"> 
                      <td align="center"> 
                       <img src="images/iconos/ejemplocedulas.png" width="240" height="180" border="0">
                      </td> 
                     </tr>
                     <tr class="TablaDocsPar"> 
                      <td width="100%" align="center"> 
                       <font color="BLUE"> Importante: Se debe utilizar un archivo de Excel con extensión .xlsx</font>
                      </td> 
                     </tr>
                    </table>';
        }

        echo $cont;
        exit();
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: importacionexcelesempleado
    // Creación: 30/09/2022		última modificación: 11/06/2024
    // Creador: Luis Flórez		modificado por: Luis Flórez
    // Descripción: Opción que actualiza masivamente a los empleados activos desde una hoja 
    //              de Excel
    // Última modificación: Activación del campo esempleado (20/05/2024)
    //                      Actualización del campo en liquidación
    ////////////////////////////////////////////////////////////////////////////////////////
	if($opcion == "importacionexcelesempleado")
	{
		set_time_limit(0);
		extract($_POST);
		$archivo = $_FILES['excel']['name'];
		$tipo = $_FILES['excel']['type'];
		$destino = "recursos/xls/bak_".$archivo;

        // Valido que la extensión del archivo sea xlsx
        $extension = pathinfo($destino, PATHINFO_EXTENSION);

        if($extension!="xlsx")
        {
            $clase->Aviso(3,"El archivo debe tener extensión .xlsx");
            header("Location: empleadosperiodo.php?opcion=ventanaactdatos");
        }
        else
        {
            /// Valido si se cargó el archivo o no
            if (!copy($_FILES['excel']['tmp_name'],$destino))
                echo "Error Al Cargar el Archivo";
        
            if (file_exists ("recursos/xls/bak_".$archivo))
            {
                require_once('lib/PHPExcel.php');
                require_once('lib/PHPExcel/Reader/Excel2007.php');
                
                $objReader = new PHPExcel_Reader_Excel2007();
                $objPHPExcel = $objReader->load("recursos/xls/bak_".$archivo);
                $objFecha = new PHPExcel_Shared_Date();
                $objPHPExcel->setActiveSheetIndex(0);
                $conex = $clase->Conectar();
                $recorrer = true;  $i = 1;
                while($recorrer)
                {
                    $_DATOS_EXCEL[$i]['dni'] = $objPHPExcel->getActiveSheet()->getCell('A'.$i)->getCalculatedValue();
                
                    if(strlen($_DATOS_EXCEL[$i]['dni']) == 0)
                        $recorrer = false;
                    
                    $i++;
                } /// Fin del While
            }
            else
            { echo "Necesitas primero importar el archivo";  }  /// Si NO Cargó el archivo

            // ------------------------------------------------------------------------------------------ //
            //Teniendo la Informacion en el Array la inserto en la Base de Datos
            $errores = 0;
            $grabados = 0;
            $esempleadoactivo = "CHECKED";
            $esempleado = "CHECKED";
            $enliquidacion = "";

            for($j=1; $j < $i; $j++)
            {
                $terid = $clase->BDLockup($_DATOS_EXCEL[$j]['dni'],"terceros","dni","terid");
                
                if($terid != "")
                {
                    $vsql4 = "UPDATE terceros SET 
                                     esempleado = '".$esempleado."', 
                                     esempleadoactivo = '".$esempleadoactivo."',
                                     enliquidacion =  '".$enliquidacion."'
                               WHERE terid = ".$terid;
                    $clase->EjecutarSQL($vsql4);

                    if(mysql_affected_rows() >= 1)
                        $grabados++;
                }
            }
      
            // Elimino el Archivo
            unlink($destino);
    
            // Emito el mensaje correspondiente
            if($grabados==0)
                $clase->Aviso(3,"No se activaron los empleados");
            else
                $clase->Aviso(1,"Se activaron $grabados empleados");            
    
            // Redirecciona el formulario
            header("Location: empleadosperiodo.php?opcion=ventanaactdatos");
        }
  	}

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: importarextraleal
    // Creación: 30/09/2022		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción para la hoja de Excel desde donde se marcarán como extralegales 
    //              a los empleados
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////    
    if($opcion == "importarextraleal")
    {
        $cont = '';
        $servidor = $_SERVER['SERVER_NAME'].":".$_SERVER['SERVER_PORT'];

        // Validación del servidor
        if(($servidor!="dromedicas.sytes.net:9996")&&($servidor!="192.168.14.248:9999"))
            $cont.='<table width="400">
                     <tr class="CabezoteTabla"> 
                      <td align="center"> <b>Servidor incorrecto </b></td>
                     </tr> 
                     <tr class="CabezoteTabla"> 
                      <td align="center"> 
                       <font color=red> Este servidor est&aacute; inhabilitado para hacer este <br> 
                       proceso, por favor diríjase al servidor </font><br> 
                       <font color=blue> 192.168.14.248:9999 </font> <br>
                       <font color=red>o al servidor </font> <br> 
                       <font color=blue> dromedicas.sytes.net:9996 </font> <br>
                       <font color=red> para poder ejecutar este proceso </font> <br><br>
                      </td> 
                     </tr>
                     <tr class="TablaDocsPar">        
                      <td width="100%" align="center"> 
                       <form name="importa" method="post" action="empleadosperiodo.php?opcion=ventanaactdatos" id="theform" enctype="multipart/form-data">
                       <input type="submit" name="enviar" id="enviarr"  value="aceptar" class="button blue" />                       
                       </form> 
                      </td>    
                     </tr>
                    </table>';
        else
        {
            // Obtengo el periodo actual
            $vsql = "SELECT periodoid
                       FROM periodosnomina 
                      WHERE periodoid = (SELECT MIN(periodoid) FROM periodosnomina WHERE cerrado ='')";
            $periodoid = $clase->SeleccionarUno($vsql);
        
            $descripcion = $clase->BDLockup($periodoid,'periodosnomina','periodoid','descripcion');
      
            // pinto la ventana
            $cont.='<script type="text/javascript" src="lib/jquery-2.1.3.min.js"></script>
                    <script>
                     $(function()
                     {
                      $("#enviarr").on("click",function()
                      {
                        $(this).val("Espere por favor ...")
                        .attr("disabled","disabled");
                        $("#theform").submit();
                      });
                     });
                    </script>
                    <table width="400">
                     <tr class="CabezoteTabla"> 
                      <td align="center"> <b>Marcar como extralegal <br> masivamente en el periodo <br> <font color="BLUE">'.strtolower($descripcion).'</font></b></td> 
                     </tr> 
                    </table>
                    <table width="400">
                     <tr class="TablaDocsPar">        
                      <td width="100%" align="center"> 
                       <form name="importa" method="post" action="?opcion=importacionextralegal" id="theform" enctype="multipart/form-data">
                       <input type="file" name="excel" /><br><br>                         
                       <input type="submit" name="enviar" id="enviarr"  value="Importar archivo" class="button blue" />
                       <input type="hidden" value="upload" name="action" />                  
                       </form> 
                      </td>    
                     </tr>
                    </table>';
      
            $cont.='<table width="400">
                     <tr class="TablaDocsPar"> <td align="left"> &nbsp; La hoja de Excel debe tener la siguiente estructura: </td> </tr>
                     <tr class="TablaDocsPar"> <td align="left"> &nbsp; Columna <b>A</b>: C&eacute;dula </td> </tr>
                    </table>';
      
            $cont.='<table width="400">
                     <tr class="TablaDocsPar"> 
                      <td align="center"> 
                       <img src="images/iconos/ejemplocedulas.png" width="240" height="180" border="0">
                      </td> 
                     </tr>
                     <tr class="TablaDocsPar"> 
                      <td width="100%" align="center"> 
                       <font color="BLUE"> Importante: Se debe utilizar un archivo de Excel con extensión .xlsx</font>
                      </td> 
                     </tr>
                    </table>';
        }  
        echo $cont;
        exit();
    }
      
    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: importacionextralegal
    // Creación: 30/09/2022		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que marca masivamente como extralegales a los empleados
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "importacionextralegal")
    {
        set_time_limit(0);
        extract($_POST);
        $archivo = $_FILES['excel']['name'];
        $tipo = $_FILES['excel']['type'];
        $destino = "recursos/xls/bak_".$archivo;
  
        // Valido que la extensión del archivo sea xlsx
        $extension = pathinfo($destino, PATHINFO_EXTENSION);
  
        if($extension!="xlsx")
        {
            $clase->Aviso(3,"El archivo debe tener extensión .xlsx");
            header("Location: empleadosperiodo.php?opcion=ventanaactdatos");
        }
        else
        {
            /// Valido si se cargó el archivo o no
            if (!copy($_FILES['excel']['tmp_name'],$destino))
                echo "Error Al Cargar el Archivo";
          
            if (file_exists ("recursos/xls/bak_".$archivo))
            {
                require_once('lib/PHPExcel.php');
                require_once('lib/PHPExcel/Reader/Excel2007.php');
                  
                $objReader = new PHPExcel_Reader_Excel2007();
                $objPHPExcel = $objReader->load("recursos/xls/bak_".$archivo);
                $objFecha = new PHPExcel_Shared_Date();
                $objPHPExcel->setActiveSheetIndex(0);
                $conex = $clase->Conectar();
                $recorrer = true;  $i = 1;
                while($recorrer)
                {
                    $_DATOS_EXCEL[$i]['dni'] = $objPHPExcel->getActiveSheet()->getCell('A'.$i)->getCalculatedValue();
                
                    if(strlen($_DATOS_EXCEL[$i]['dni']) == 0)
                        $recorrer = false;
                    
                    $i++;
                } /// Fin del While
            }
            else
            { echo "Necesitas primero importar el archivo";  }  /// Si NO Cargó el archivo
  
                // ------------------------------------------------------------------------------------------ //
                //Teniendo la Informacion en el Array la inserto en la Base de Datos
                $errores = 0;
                $grabados = 0;
                $extralegal = "CHECKED";
    
                for($j=1; $j < $i; $j++)
                {
                    $terid = $clase->BDLockup($_DATOS_EXCEL[$j]['dni'],"terceros","dni","terid");
                    
                    if($terid != "")
                    {
                        $vsql5 = "UPDATE terceros SET extralegal = '".$extralegal."' WHERE terid = ".$terid;
                        $clase->EjecutarSQL($vsql5);
    
                        if(mysql_affected_rows() >= 1)
                            $grabados++;
                    }
                }
            
                // Elimino el Archivo
                unlink($destino);
        
                // Emito el mensaje correspondiente
                if($grabados==0)
                    $clase->Aviso(3,"No se marcó ningún empleado como extralegal");
                else
                    $clase->Aviso(1,"$grabados empleados se marcaron como extralegal");
        
                // Redirecciona el formulario
                header("Location: empleadosperiodo.php?opcion=ventanaactdatos");
        }
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: ventanacargosysecciones
    // Creación: 16/11/2022		última modificación: 27/06/2023
    // Creador: Luis Flórez		modificado por: Luis Flórez
    // Descripción: Ventana para seleccionar las opciones de actualización de cargos y 
    //              secciones
    // Última modificación: Inclusión de los accesos a los informes de cargos y secciones 
    //                      en pdf y Excel (23/11/2022)
    //                      Documentos no actualizados en una nueva ventana
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "ventanacargosysecciones")
    {
        // Obtengo el nombre del periodo a procesar
        $vsql = "SELECT periodoid
                   FROM periodosnomina 
                  WHERE periodoid = (SELECT MIN(periodoid) FROM periodosnomina WHERE cerrado ='')";
        $periodoid = $clase->SeleccionarUno($vsql);

        $descripcion = $clase->BDLockup($periodoid,'periodosnomina','periodoid','descripcion');        

        // pinto la ventana        
        $cont = $clase->Header("S","W");
        $cont.='<table width="100%">
                 <tr class="CabezoteTabla"> 
                  <td width="10"> &nbsp; </td>
                  <td width="37"> <img src="images/iconos/clientes.png" width="32" height="32" border="0"> </td>
                  <td width="850"> <b>Actualizaci&oacute;n de cargos y secciones del periodo <font color="blue"> '.$descripcion.' </font> </b></td>
                  <td width="10"> &nbsp; </td>                  
                  <td width="24"> &nbsp; </td>
                  <td width="250" align="right"> 
                   <a href="empleadosperiodo.php"> 
                    <input type="button" class="button" value="<<"> 
                   </a>
                  </td>                  
                  <td width="10"> &nbsp; </td>
                 </tr>
                </table>';

        // Advertencia del servidor equivocado 
        $servidor = $_SERVER['SERVER_NAME'].":".$_SERVER['SERVER_PORT'];

        if(($servidor!="dromedicas.sytes.net:9996")&&($servidor!="192.168.14.248:9999"))
            $cont.='<table width="100%">
                     <tr class="CabezoteTabla"> 
                      <td width="10"> &nbsp; </td>
                      <td width="37"> <img src="images/iconos/alerta.png" width="32" height="32" border="0"> </td>
                      <td width="930" align="center"> 
                       Para poder ejecutar el proceso de subir actualizaci&oacute;n desde una hoja de Excel debe dirigirse al servidor <br> 192.168.14.248:9999 o al servidor dromedicas.sytes.net:9996 
                      </td>
                      <td width="24"> &nbsp; </td>
                     </tr>
                    </table>';

        $cont.='<center>
                <table width="900" border="0">
                 <tr height="120">
                  <td width="25%" align="center">  
                   <a href="?opcion=cargosyseccionesxls" target="_blank">
                    <img src="images/iconos/descargar.png" border="0" width="38" height="38"> 
                    <br>Descargar datos actuales
                   </a>                   
                  </td>
                  <td width="25%" align="center">
                   <a href="?opcion=importaractualizacion&periodoid='.$periodoid.'" rel="facebox">
                    <img src="images/iconos/cargar.png" border="0" width="38" height="38">
                    <br>Subir actualizaci&oacute;n
                   </a>
                  </td>
                  <td width="25%" align="center">                    
                   <a href="?opcion=vererrores1" rel="facebox">
                    <img src="images/iconos/notas.png" border="0" width="38" height="38">
                    <br> Documentos no actualizados <br> en el &uacute;ltimo proceso 
                   </a>
                  </td>
                  <td width="25%" align="center">  
                   <a href="terceros.php" target="_blank">
                    <img src="images/iconos/clientesgenerales.png" border="0" width="38" height="38">
                    <br> Ficha terceros
                   </a>
                  </td> 
                 </tr>
                 <tr height="120">
                  <td width="25%" align="center"> 
                   <a href="cargos.php?opcion=cargosxls" target="_blank">
                    <img src="images/iconos/exportarexcel.png" border="0" width="38" height="38">
                    <br> Informe de cargos <br>en Excel
                   </a>                  
                  </td>
                  <td width="25%" align="center">
                   <a href="seccion.php?opcion=seccionesxls" target="_blank">
                    <img src="images/iconos/exportarexcel.png" border="0" width="38" height="38">
                    <br> Informe de secciones <br>en Excel
                   </a>
                  </td>
                  <td width="25%" align="center">
                   <a href="cargos.php?opcion=cargospdf" target="_blank">
                    <img src="images/iconos/exportarpdf2.png" border="0" width="38" height="38">
                    <br> Informe de cargos <br>en pdf
                   </a>
                  </td>                  
                  <td width="25%" align="center">
                   <a href="seccion.php?opcion=seccionespdf" target="_blank">
                    <img src="images/iconos/exportarpdf2.png" border="0" width="38" height="38">
                    <br> Informes de secciones <br>en pdf
                   </a>
                  </td>
                 </tr>
                </table>';

        // echo $cont;
        echo $cont.$clase->PiePagina();
        exit();
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: cargosyseccionesxls
    // Creación: 16/11/2022		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que genera la hoja de Excel con los cargos y las secciones de 
    //              los empleados activos
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////    
    if($opcion == "cargosyseccionesxls")
    {
        // Obtengo el nombre del periodo a procesar
        $vsql = "SELECT periodoid
                   FROM periodosnomina 
                  WHERE periodoid = (SELECT MIN(periodoid) FROM periodosnomina WHERE cerrado ='')";
        $periodoid = $clase->SeleccionarUno($vsql);

        $descripcion = $clase->BDLockup($periodoid,'periodosnomina','periodoid','descripcion');

        // Fechas del periodo actual
        $fecdesdeper = $clase->BDLockup($periodoid,'periodosnomina','periodoid','fecdesde');
        $fechastaper = $clase->BDLockup($periodoid,'periodosnomina','periodoid','fechasta');        
        
        // Preparo el entorno
        require_once 'lib/PHPExcel.php';
        $clase = new Sistema();
        $clase->Conectar();
        ini_set("memory_limit","100M");

        // Consulta de cargos y secciones de los empleados activos
        $vsql = "SELECT t.terid, t.codvende, t.dni AS documento, 
                        CONCAT(t.primernombre,' ',t.segundonombre,' ',t.primerapellido,' ',t.segundoapellido) AS nombreemp, 
                        s.codseccion, c.codcargo
                   FROM terceros t 
                        INNER JOIN seccion s ON (t.seccionid = s.seccionid) 
                        INNER JOIN cargos c ON (t.cargoid = c.cargoid) 
                  WHERE t.esempleadoactivo = 'CHECKED' 
                        AND t.basico > 0 
                        AND t.esempleadoactivo = 'CHECKED'
                        AND t.fecharetiro BETWEEN '".$fecdesdeper."' AND '".$fechastaper."'
                        AND t.fecingreso <= '".$fechastaper."'
                 UNION
                 SELECT t.terid, t.codvende, t.dni AS documento, 
                        CONCAT(t.primernombre,' ',t.segundonombre,' ',t.primerapellido,' ',t.segundoapellido) AS nombreemp, 
                        s.codseccion, c.codcargo
                   FROM terceros t 
                        INNER JOIN seccion s ON (t.seccionid = s.seccionid) 
                        INNER JOIN cargos c ON (t.cargoid = c.cargoid) 
                  WHERE t.fecharetiro BETWEEN '".$fecdesdeper."' AND '".$fechastaper."' 
                        AND t.basico > 0 
                        AND t.esempleadoactivo = 'CHECKED'";
        
        // Preparación del entorno para la salida a Excel
        $clase = new Sistema();
        $clase->Nombredb = $_SESSION['DBNOMBRE'];
        error_reporting(E_ALL);
        ini_set('display_errors', TRUE);
        ini_set('display_startup_errors', TRUE);
        date_default_timezone_set('Europe/London');
    
        if (PHP_SAPI == 'cli')
            die('This example should only be run from a Web Browser');
    
        // Create new PHPExcel object
        $objPHPExcel = new PHPExcel();
    
        // Set document properties
        $objPHPExcel->getProperties()->setCreator("Sistemas y Soluciones Web de Colombia")
                                     ->setLastModifiedBy("Sistemas y Soluciones Web de Colombia")
                                     ->setTitle("Cargos y secciones de nomina - DROPOS")
                                     ->setSubject("Cargos y secciones de nomina - DROPOS")
                                     ->setDescription("Cargos y secciones de nomina - DROPOS")
                                     ->setKeywords("Cargos y secciones de nomina - DROPOS")
                                     ->setCategory("Categoria General");        

        $objPHPExcel->getActiveSheet()->getColumnDimension('A')->setAutoSize(true);                 $objPHPExcel->getActiveSheet()->getColumnDimension('B')->setAutoSize(true);
        $objPHPExcel->getActiveSheet()->getColumnDimension('C')->setAutoSize(true);                 $objPHPExcel->getActiveSheet()->getColumnDimension('D')->setAutoSize(true);
        $objPHPExcel->getActiveSheet()->getColumnDimension('E')->setAutoSize(true);                 $objPHPExcel->getActiveSheet()->getColumnDimension('F')->setAutoSize(true);

        $conex  = $clase->Conectar();
        $result = mysql_query($vsql,$conex);
        $cant   = mysql_num_rows($result);
        $i=1;
        while($row = mysql_fetch_array($result))
        {
            $codvende = $row['codvende'];
            $codseccion = $row['codseccion'];
            $codcargo = $row['codcargo'];
            
            // Adaptación para el tipo de dato texto en la celda de la hoja de Excel
            if(substr($codvende,0,1) == "0")            $codvende="'".$codvende;
            if(substr($codseccion,0,1) == "0")          $codseccion="'".$codseccion;
            if(substr($codcargo,0,1) == "0")            $codcargo="'".$codcargo;

            $objPHPExcel->setActiveSheetIndex(0)
                        ->setCellValue('A'.$i, $row['terid'])
                        ->setCellValue('B'.$i, $codvende)
                        ->setCellValue('C'.$i, $row['documento'])
                        ->setCellValue('D'.$i, $row['nombreemp'])
                        ->setCellValue('E'.$i, $codseccion)
                        ->setCellValue('F'.$i, $codcargo);
            $i++;
        }

        $rangoEncabezado = 'A4:F4';
        $rangoCeldas     = 'A4:F'.($i-1);

        // ----------------------------------------------------------------------------------------------------------------------------------------------------------- //        
        // Formato de Encabezado y Celdas
        $objPHPExcel->getActiveSheet()->getRowDimension('1')->setRowHeight(15);
        
        $EstiloCeldas = array(
        'borders' => array(
            'allborders' => array(
                'style' => PHPExcel_Style_Border::BORDER_THIN,
                'color' => array('argb' => '00000000'),
            ),
            ),
        );
        // $objPHPExcel->getActiveSheet()->getStyle($rangoCeldas)->applyFromArray($EstiloCeldas);
        /// Formato de Encabezados 
        $EstiloEncabezado = array(
        'font' => array(
            'bold' => true,
        ),
        'alignment' => array(
            'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,
            'vertical' => PHPExcel_Style_Alignment::VERTICAL_CENTER,		
        ),
        'borders' => array(
            'allborders' => array(
                'style' => PHPExcel_Style_Border::BORDER_THIN,
                'color' => array('argb' => '00000000'),
            ),
        ),
        'fill' => array(
            'type' => PHPExcel_Style_Fill::FILL_SOLID,
            'rotation' => 90,
            'startcolor' => array(
                'argb' => '00FFFFCC',
            ),
            'endcolor' => array(
                'argb' => 'FFFFFF',
            ),
            ),
        );
        // $objPHPExcel->getActiveSheet()->getStyle($rangoEncabezado)->applyFromArray($EstiloEncabezado);
        // Rename worksheet
        $objPHPExcel->getActiveSheet()->setTitle('cargos y secciones');
        // Set active sheet index to the first sheet, so Excel opens this as the first sheet
        $objPHPExcel->setActiveSheetIndex(0);
        // Redirect output to a client’s web browser (Excel5)
        header('Content-Type: application/vnd.ms-excel');
        // --------------------------------------------------------------------- //                
        $nombrearcexcel = "secciones y cargos del periodo ".strtolower($descripcion).".xls";
        header('Content-Disposition: attachment;filename='.$nombrearcexcel.'');
        // --------------------------------------------------------------------- //
        header('Cache-Control: max-age=0');
        /// Genero la Salida
        $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');
        $objWriter->save('php://output');
        exit;
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opciones: importaractualizacion
    // Creación: 17/11/2022		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que pinta la ventana en la cual se cargará la hoja de Excel con 
    //              las modificaciones de sección y cargo
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "importaractualizacion")
    {
        $cont = '';
        $servidor = $_SERVER['SERVER_NAME'].":".$_SERVER['SERVER_PORT'];

        // Validación del servidor
        if(($servidor!="dromedicas.sytes.net:9996")&&($servidor!="192.168.14.248:9999"))
            $cont.='<table width="400">
                     <tr class="CabezoteTabla"> 
                      <td align="center"> <b>Servidor incorrecto </b></td>
                     </tr> 
                     <tr class="CabezoteTabla"> 
                      <td align="center"> 
                       <font color=red> Este servidor est&aacute; inhabilitado para hacer este <br> 
                       proceso, por favor diríjase al servidor </font><br> 
                       <font color=blue> 192.168.14.248:9999 </font> <br>
                       <font color=red>o al servidor </font> <br> 
                       <font color=blue> dromedicas.sytes.net:9996 </font> <br>
                       <font color=red> para poder ejecutar este proceso </font> <br><br>
                      </td> 
                     </tr>
                     <tr class="TablaDocsPar">        
                      <td width="100%" align="center"> 
                       <form name="importa" method="post" action="empleadosperiodo.php?opcion=ventanacargosysecciones" id="theform" enctype="multipart/form-data">
                        <input type="submit" name="enviar" id="enviarr"  value="aceptar" class="button blue" />                       
                       </form> 
                      </td>    
                     </tr>
                    </table>';
        else
        {
            $periodoid = $_GET["periodoid"];
            
            // pinto la ventana
            $cont.='<script type="text/javascript" src="lib/jquery-2.1.3.min.js"></script>
                    <script>
                     $(function()
                      {
                        $("#enviarr").on("click",function()
                       {
                        $(this).val("Espere por favor ...")
                        .attr("disabled","disabled");
                        $("#theform").submit();
                       });    
                      });
                    </script>
                    <table width="400">
                     <tr class="CabezoteTabla"> 
                      <td align="center"> <b>Actualización de cargos <br> y secciones</font> </b></td> 
                     </tr> 
                    </table>
                    <table width="400">
                     <tr class="TablaDocsPar">        
                      <td width="100%" align="center"> 
                       <form name="importa" method="post" action="?opcion=actcargosysecciones" id="theform" enctype="multipart/form-data">
                       <input type="hidden" name="periodoid" value="'.$periodoid.'">
                       <input type="file" name="excel" /><br><br>                       
                       <input type="submit" name="enviar" id="enviarr"  value="Importar archivo" class="button blue" />
                       <input type="hidden" value="upload" name="action" />                  
                       </form> 
                      </td>    
                     </tr>
                    </table>';
    
            $cont.='<table width="400">
                     <tr class="TablaDocsPar"> <td align="left"> &nbsp; La hoja de Excel debe tener la siguiente estructura: </td> </tr>
                     <tr class="TablaDocsPar"> <td align="left"> &nbsp; Columna <b>A</b>: Terid del empleado (no editar) </td> </tr>
                     <tr class="TablaDocsPar"> <td align="left"> &nbsp; Columna <b>B</b>: C&oacute;digo de vendedor (no editar)</td> </tr>
                     <tr class="TablaDocsPar"> <td align="left"> &nbsp; Columna <b>C</b>: C&eacute;dula del empleado (no editar)</td> </tr>
                     <tr class="TablaDocsPar"> <td align="left"> &nbsp; Columna <b>D</b>: Nombre del empleado (no editar)</td> </tr> 
                     <tr class="TablaDocsPar"> <td align="left"> &nbsp; Columna <b>E</b>: C&oacute;digo de la secci&oacute;n </td> </tr>
                     <tr class="TablaDocsPar"> <td align="left"> &nbsp; Columna <b>F</b>: C&oacute;digo del cargo </td> </tr>                 
                    </table>';
    
            $cont.='<table width="400">
                     <tr class="TablaDocsPar"> 
                      <td align="center"> 
                       <img src="images/iconos/ejemplocargossecciones.png" width="340" height="200" border="0">
                      </td> 
                     </tr>
                     <tr class="TablaDocsPar"> 
                      <td width="100%" align="center"> 
                       <font color="BLUE"> Importante: Se debe utilizar un archivo de Excel con extensión .xlsx</font>
                      </td> 
                     </tr>
                    </table>';            
        }

        echo $cont; 
        exit();        
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opciones: actcargosysecciones
    // Creación: 17/11/2022		última modificación: 23/11/2022
    // Creador: Luis Flórez		modificado por: Luis Flórez
    // Descripción: Opción que almacena mediante una hoja de Excel las actualizaciones de 
    //              cargos y secciones
    // Última modificación: Validación de la existencia de los códigos de cargo y sección
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "actcargosysecciones")
    {
		set_time_limit(0);
		extract($_POST);
        $periodoid = $_POST["periodoid"];
		$archivo = $_FILES['excel']['name'];
		$tipo = $_FILES['excel']['type'];
		$destino = "recursos/xls/bak_".$archivo;

        // Valido que la extensión del archivo sea xlsx
        $extension = pathinfo($destino, PATHINFO_EXTENSION);

        if($extension!="xlsx")
        {
            $clase->Aviso(3,"El archivo debe tener extensión .xlsx");
            header("Location: empleadosperiodo.php?opcion=ventanacargosysecciones");
        }
        else
        {
            /// Valido si se cargó el archivo o no
            if (!copy($_FILES['excel']['tmp_name'],$destino))
                echo "Error Al Cargar el Archivo";
        
            if (file_exists ("recursos/xls/bak_".$archivo))
            {
                require_once('lib/PHPExcel.php');
                require_once('lib/PHPExcel/Reader/Excel2007.php');
                
                $objReader = new PHPExcel_Reader_Excel2007();
                $objPHPExcel = $objReader->load("recursos/xls/bak_".$archivo);
                $objFecha = new PHPExcel_Shared_Date();
                $objPHPExcel->setActiveSheetIndex(0);

                $conex = $clase->Conectar();
                $recorrer = true;  $i = 1;
                while($recorrer)
                {
                    $_DATOS_EXCEL[$i]['terid'] = $objPHPExcel->getActiveSheet()->getCell('A'.$i)->getCalculatedValue();
                    $_DATOS_EXCEL[$i]['dni'] = $objPHPExcel->getActiveSheet()->getCell('C'.$i)->getCalculatedValue();
                    $_DATOS_EXCEL[$i]['codseccion'] = $objPHPExcel->getActiveSheet()->getCell('E'.$i)->getCalculatedValue();
                    $_DATOS_EXCEL[$i]['codcargo'] = $objPHPExcel->getActiveSheet()->getCell('F'.$i)->getCalculatedValue();
                
                    if((strlen($_DATOS_EXCEL[$i]['terid']) == 0)&&(strlen($_DATOS_EXCEL[$i]['codseccion']) == 0)&&(strlen($_DATOS_EXCEL[$i]['codcargo']) == 0))
                        $recorrer = false;
                    
                    $i++;
                } /// Fin del While
            }
            else
            { echo "Necesitas primero importar el archivo";  }  /// Si NO Cargó el archivo

            // ------------------------------------------------------------------------------------------ //
            //Teniendo la Informacion en el Array la inserto en la Base de Datos
            $errores=0;
            $grabados = 0;
            
            $descripcion = $clase->BDLockup($periodoid,'periodosnomina','periodoid','descripcion');
            $carpetaactual = 'reportes/';

            // Construcción de la variable con los documentos no grabados
            $nocedulas = 'ACTUALIZACION DE CARGOS Y SECCIONES'.Chr(13).Chr(10);
            $nocedulas.= ''.str_pad($descripcion,1,"").''.Chr(13).Chr(10);
            $nocedulas.= 'DOCUMENTOS NO GRABADOS:'.Chr(13).Chr(10);
            $nocedulas.= ''.Chr(13).Chr(10);

            for($j=1; $j < $i; $j++)
            {
                // Obtengo los datos necesarios
                $terid = $_DATOS_EXCEL[$j]['terid'];
                $dni = $_DATOS_EXCEL[$j]['dni'];
                $codseccion = $_DATOS_EXCEL[$j]['codseccion'];
                $codcargo = $_DATOS_EXCEL[$j]['codcargo'];

                // Depuración de los códigos
                if(substr($codseccion,0,1) == "'")          $codseccion = substr($codseccion,1);
                if(substr($codcargo,0,1) == "'")            $codcargo = substr($codcargo,1);
                
                $seccionid = $clase->BDLockup($codseccion,'seccion','codseccion','seccionid');
                $cargoid = $clase->BDLockup($codcargo,'cargos','codcargo','cargoid');

                // Valido que el cargo y la sección existan
                if((strlen($seccionid) > 0)&&(strlen($cargoid) > 0))
                {
                    // Almaceno la información
                    $vsql = "UPDATE terceros SET 
                                    seccionid = ".$seccionid.", 
                                    cargoid = ".$cargoid."
                              WHERE terid = ".$terid;
                    $clase->EjecutarSQL($vsql);
    
                    if(mysql_affected_rows() >= 1)
                        $grabados++;
                    else
                    {
                        $nocedulas.= str_pad($dni,1,"").''.Chr(13).Chr(10);         // Actualizo la variable con el documento no almacenado
                        $archivo = "errores.txt";                                   // nombre del archivo
                        $fd = fopen ($carpetaactual."/".$archivo, "w");             // se abre el archivo para escribir
                        fwrite($fd, $nocedulas);                                    // Grabas
                        fclose($fd);                                                // Cierras el archivo
                    }
                }
                else
                {
                    $nocedulas.= str_pad($dni,1,"").''.Chr(13).Chr(10);         // Actualizo la variable con el documento no almacenado
                    $archivo = "errores.txt";                                   // nombre del archivo
                    $fd = fopen ($carpetaactual."/".$archivo, "w");             // se abre el archivo para escribir
                    fwrite($fd, $nocedulas);                                    // Grabas
                    fclose($fd);                                                // Cierras el archivo
                }
            }
      
            // Elimino el Archivo
            unlink($destino);
    
            // Emito el mensaje correspondiente
            if($grabados==0)
                $clase->Aviso(3,"No se cargaron las actualizaciones de cargos y secciones en el periodo $descripcion");
            else
                $clase->Aviso(1,"Se cargaron $grabados actualizaciones de cargos y secciones en el periodo $descripcion");

            header("Location: empleadosperiodo.php?opcion=ventanacargosysecciones");
        }

        // // Redirecciona el formulario
        // header("Location: empleadosperiodo.php?opcion=ventanacargosysecciones");
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opciones: importarcuentas
    // Creación: 26/11/2022		última modificación: 19/04/2024
    // Creador: Luis Flórez		modificado por: Luis Flórez
    // Descripción: Opción que pinta la ventana en la cual se cargará la hoja de Excel con 
    //              las modificaciones de cuentas bancarias
    // Última modificación: Inclusión del checkbox para la actualización de los terceros del 
    //                      periodo actual (30/12/2022)
    //                      Inclusión del ID para cuentas Daviplata (15/03/2024)
    //                      Casilla de verificación activa por defecto para actualizar 
    //                      terceros del periodo actual (17/04/2024)
    //                      Casilla de verificación activa por defecto para la ficha 
    //                      terceros    
    ////////////////////////////////////////////////////////////////////////////////////////    
    if($opcion == "importarcuentas")
    {
        $cont = '';
        $servidor = $_SERVER['SERVER_NAME'].":".$_SERVER['SERVER_PORT'];

        // Validación del servidor
        if(($servidor!="dromedicas.sytes.net:9996")&&($servidor!="192.168.14.248:9999"))
            $cont.='<table width="400">
                     <tr class="CabezoteTabla"> 
                      <td align="center"> <b>Servidor incorrecto </b> </td>
                     </tr> 
                     <tr class="CabezoteTabla"> 
                      <td align="center"> 
                       <font color=red> Este servidor est&aacute; inhabilitado para hacer este <br> 
                       proceso, por favor diríjase al servidor </font><br> 
                       <font color=blue> 192.168.14.248:9999 </font> <br>
                       <font color=red>o al servidor </font> <br> 
                       <font color=blue> dromedicas.sytes.net:9996 </font> <br>
                       <font color=red> para poder ejecutar este proceso </font> <br><br>
                      </td> 
                     </tr>
                     <tr class="TablaDocsPar">        
                      <td width="100%" align="center"> 
                       <form name="importa" method="post" action="empleadosperiodo.php?opcion=ventanaactdatos" id="theform" enctype="multipart/form-data">
                        <input type="submit" name="enviar" id="enviarr"  value="aceptar" class="button blue" /> 
                       </form> 
                      </td>    
                     </tr>
                    </table>';
        else
        {
            // Obtengo el periodo actual
            $vsql = "SELECT periodoid
                       FROM periodosnomina 
                      WHERE periodoid = (SELECT MIN(periodoid) FROM periodosnomina WHERE cerrado ='')";
            $periodoid = $clase->SeleccionarUno($vsql);
    
            $descripcion = $clase->BDLockup($periodoid,'periodosnomina','periodoid','descripcion');           

            // Inicializo la variable para actualizar la tabla tercerosactual
            $acttercerosactual = "CHECKED";

            // Validación de la tabla tercerosactual
            $vsql2 = "SELECT COUNT(*) AS regactual FROM tercerosactual";
            $regactual = $clase->SeleccionarUno($vsql2);            

            if($regactual > 0)            
                $disable = "";            
            else
            {
                $disable = "disabled";
                $acttercerosactual = "";
            }

            $actfichaterceros = "CHECKED";
    
            // pinto la ventana
            $cont.='<script type="text/javascript" src="lib/jquery-2.1.3.min.js"></script>
                    <script>
                     $(function()
                     {
                      $("#enviarr").on("click",function()
                      {
                        $(this).val("Espere por favor ...")
                        .attr("disabled","disabled");
                        $("#theform").submit();
                      });
                     });
                    </script>
                    <table width="400">
                     <tr class="CabezoteTabla"> 
                      <td align="center"> <b>Actualizar cuentas bancarias<br> masivamente en el periodo <br> <font color="blue">'.strtolower($descripcion).'</font></b> <br><br></td> 
                     </tr> 
                    </table>
                    <table width="400">
                     <tr class="TablaDocsPar">        
                      <td width="100%" align="center"> 
                       <form name="importa" method="post" action="?opcion=actualizarcuentas" id="theform" enctype="multipart/form-data">
                       <input type="hidden" name="periodoid" value="'.$periodoid.'">
                       <input type="file" name="excel" /><br><br>                       
                       <input type="submit" name="enviar" id="enviarr"  value="Importar archivo" class="button blue" />
                       <br><br><input type="checkbox" value="CHECKED" name="actfichaterceros" class="Texto11" '.$actfichaterceros.'> Actualizar ficha terceros
                       <br><br><input type="checkbox" value="CHECKED" name="acttercerosactual" class="Texto11" '.$acttercerosactual.' '.$disable.'> Actualizar terceros del periodo actual
                       <input type="hidden" value="upload" name="action" />                       
                       </form>                        
                      </td>    
                     </tr>
                    </table>';
    
            $cont.='<table width="400">
                     <tr class="TablaDocsPar"> <td align="left"> &nbsp; La hoja de Excel debe tener la siguiente estructura: </td> </tr>
                     <tr class="TablaDocsPar"> <td align="left"> &nbsp; Columna <b>A</b>: C&eacute;dula </td> </tr>
                     <tr class="TablaDocsPar"> <td align="left"> &nbsp; Columna <b>B</b>: Banco </td> </tr>
                     <tr class="TablaDocsPar"> <td align="left"> &nbsp; Columna <b>C</b>: N&uacute;mero de cuenta </td> </tr>
                     <tr class="TablaDocsPar"> 
                      <td align="left">
                       &nbsp; <font color="blue"><b>1</b></font> DAVIVIENDA <font color="blue"><b>2</b></font> BOGOTA <font color="blue"><b>3</b></font> BBVA
                       <font color="blue"><b>4</b></font> BANCOLOMBIA 
                      </td> 
                     </tr>
                     <tr class="TablaDocsPar"> 
                      <td align="left">
                       &nbsp; <font color="blue"><b>5</b></font> AGRARIO CHINACOTA <font color="blue"><b>6</b></font> CAJA SOCIAL 
                      </td> 
                     </tr>
                     <tr class="TablaDocsPar"> 
                      <td align="left">
                       &nbsp; <font color="blue"><b>7</b></font> CAJA GENERAL <font color="blue"> <b>8</b></font> DAVIPLATA 
                      </td> 
                     </tr>
                    </table>';
    
            $cont.='<table width="400">
                     <tr class="TablaDocsPar"> 
                      <td align="center"> 
                       <img src="images/iconos/ejemplocuentas.png" width="280" height="180" border="0">
                      </td> 
                     </tr>
                     <tr class="TablaDocsPar"> 
                      <td width="100%" align="center"> 
                       <font color="BLUE"> Importante: Se debe utilizar un archivo de Excel con extensión .xlsx</font>
                      </td> 
                     </tr>
                    </table>';
        }

        echo $cont;
        exit();
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opciones: actualizarcuentas
    // Creación: 26/11/2022		última modificación: 19/04/2024
    // Creador: Luis Flórez		modificado por: Luis Flórez
    // Descripción: Opción que almacena mediante una hoja de Excel las actualizaciones de 
    //              cuentas bancarias
    // Última modificación: Validación de las casillas de verificación de terceros y 
    //                      terceros en el periodo
    ////////////////////////////////////////////////////////////////////////////////////////    
    if($opcion == "actualizarcuentas")
    {
        $periodoid = $_POST["periodoid"];
        $actfichaterceros = $_POST["actfichaterceros"];
        $acttercerosactual = $_POST["acttercerosactual"];

        if(($actfichaterceros == "") && ($acttercerosactual == ""))
        {
            $clase->Aviso(3,"No se seleccionó ningún tercero");
            header("Location: empleadosperiodo.php?opcion=ventanaactdatos");
        }
        else
        {
            set_time_limit(0);
            extract($_POST);    
            $archivo = $_FILES['excel']['name'];
            $tipo = $_FILES['excel']['type'];
            $destino = "recursos/xls/bak_".$archivo;
    
            // Valido que la extensión del archivo sea xlsx
            $extension = pathinfo($destino, PATHINFO_EXTENSION);
    
            if($extension!="xlsx")
            {
                $clase->Aviso(3,"El archivo debe tener extensión .xlsx");
                header("Location: empleadosperiodo.php?opcion=ventanaactdatos");
            }
            else
            {
                /// Valido si se cargó el archivo o no
                if (!copy($_FILES['excel']['tmp_name'],$destino))
                    echo "Error Al Cargar el Archivo";
            
                if (file_exists ("recursos/xls/bak_".$archivo))
                {
                    require_once('lib/PHPExcel.php');
                    require_once('lib/PHPExcel/Reader/Excel2007.php');
                    
                    $objReader = new PHPExcel_Reader_Excel2007();
                    $objPHPExcel = $objReader->load("recursos/xls/bak_".$archivo);
                    $objFecha = new PHPExcel_Shared_Date();
                    $objPHPExcel->setActiveSheetIndex(0);
    
                    $conex = $clase->Conectar();
                    $recorrer = true;  $i = 1;
                    while($recorrer)
                    {
                        $_DATOS_EXCEL[$i]['dni'] = $objPHPExcel->getActiveSheet()->getCell('A'.$i)->getCalculatedValue();
                        $_DATOS_EXCEL[$i]['bancoid'] = $objPHPExcel->getActiveSheet()->getCell('B'.$i)->getCalculatedValue();
                        $_DATOS_EXCEL[$i]['numcuenta'] = $objPHPExcel->getActiveSheet()->getCell('C'.$i)->getCalculatedValue();                    
                    
                        if((strlen($_DATOS_EXCEL[$i]['dni']) == 0)||(strlen($_DATOS_EXCEL[$i]['bancoid']) == 0))
                            $recorrer = false;
                        
                        $i++;
                    } /// Fin del While
                }
                else
                { echo "Necesitas primero importar el archivo";  }  /// Si NO Cargó el archivo
    
                // ------------------------------------------------------------------------------------------ //
                //Teniendo la Informacion en el Array la inserto en la Base de Datos
                $errores=0;
                $grabados = 0;
                
                $descripcion = $clase->BDLockup($periodoid,'periodosnomina','periodoid','descripcion');
                $carpetaactual = 'reportes/';
    
                // Construcción de la variable con los documentos no grabados
                $nocedulas = 'ACTUALIZACION DE CUENTAS BANCARIAS'.Chr(13).Chr(10);
                $nocedulas.= ''.str_pad($descripcion,1,"").''.Chr(13).Chr(10);
                $nocedulas.= 'DOCUMENTOS NO GRABADOS:'.Chr(13).Chr(10);
                $nocedulas.= ''.Chr(13).Chr(10);
    
                for($j=1; $j < $i; $j++)
                {
                    // Obtengo los datos necesarios                
                    $dni = $_DATOS_EXCEL[$j]['dni'];
                    $bancoid = $_DATOS_EXCEL[$j]['bancoid'];
                    $numcuenta = $_DATOS_EXCEL[$j]['numcuenta'];                
    
                    // Valido que el empleado exista
                    $terid = $clase->BDLockup($dni,"terceros","dni","terid");
                    
                    if(strlen($terid) > 0)
                    {
                        // Valido que el banco exista
                        $vsql = "SELECT COUNT(*) AS numreg FROM bancos WHERE bancoid = ".$bancoid."";
                        $numreg = $clase->SeleccionarUno($vsql);
    
                        if($numreg >= 1)
                        {
                            if($actfichaterceros == "CHECKED")
                            {
                                // Almaceno la información
                                $vsql = "UPDATE terceros SET 
                                                bancoid = ".$bancoid.", 
                                                numcuenta = '".$numcuenta."'
                                          WHERE terid = ".$terid;
                                $clase->EjecutarSQL($vsql);

                                if(mysql_affected_rows() >= 1)
                                    $grabados++;
                                else
                                {
                                    $nocedulas.= str_pad($dni,1,"").''.Chr(13).Chr(10);         // Actualizo la variable con el documento no almacenado
                                    $archivo = "errores.txt";                                   // nombre del archivo
                                    $fd = fopen ($carpetaactual."/".$archivo, "w");             // se abre el archivo para escribir
                                    fwrite($fd, $nocedulas);                                    // Grabas
                                    fclose($fd);                                                // Cierras el archivo
                                }
                            }    
    
                            // Guardo en la tabla tercerosactual
                            if($acttercerosactual == "CHECKED")
                            {
                                $vsql2 = "UPDATE tercerosactual SET 
                                                 bancoid = ".$bancoid.", 
                                                 numcuenta = '".$numcuenta."'
                                           WHERE terid = ".$terid;
                                $clase->EjecutarSQL($vsql2);

                                if(mysql_affected_rows() >= 1)
                                    $grabados++;
                                else
                                {
                                    $nocedulas.= str_pad($dni,1,"").''.Chr(13).Chr(10);         // Actualizo la variable con el documento no almacenado
                                    $archivo = "errores.txt";                                   // nombre del archivo
                                    $fd = fopen ($carpetaactual."/".$archivo, "w");             // se abre el archivo para escribir
                                    fwrite($fd, $nocedulas);                                    // Grabas
                                    fclose($fd);                                                // Cierras el archivo
                                }
                            }
                        }
                        else
                        {
                            $nocedulas.= str_pad($dni,1,"").''.Chr(13).Chr(10);         // Actualizo la variable con el documento no almacenado
                            $archivo = "errores.txt";                                   // nombre del archivo
                            $fd = fopen ($carpetaactual."/".$archivo, "w");             // se abre el archivo para escribir
                            fwrite($fd, $nocedulas);                                    // Grabas
                            fclose($fd);                                                // Cierras el archivo                    
                        }
                    }
                    else
                    {
                        $nocedulas.= str_pad($dni,1,"").''.Chr(13).Chr(10);         // Actualizo la variable con el documento no almacenado
                        $archivo = "errores.txt";                                   // nombre del archivo
                        $fd = fopen ($carpetaactual."/".$archivo, "w");             // se abre el archivo para escribir
                        fwrite($fd, $nocedulas);                                    // Grabas
                        fclose($fd);                                                // Cierras el archivo                    
                    }
                }
          
                // Elimino el Archivo
                unlink($destino);
        
                // Emito el mensaje correspondiente
                if($grabados==0)
                    $clase->Aviso(3,"No se cargaron las actualizaciones de cuentas bancarias en el periodo $descripcion");
                else
                    $clase->Aviso(1,"Se cargaron $grabados actualizaciones de cuentas bancarias en el periodo $descripcion");
    
                // Redirecciono el formulario
                header("Location: empleadosperiodo.php?opcion=ventanaactdatos");
            }
        }
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opciones: importarbasicos
    // Creación: 21/12/2022		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que pinta la ventana en la cual se cargará la hoja de Excel con 
    //              las modificaciones de salarios básicos
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////        
    if($opcion == "importarbasicos")
    {
        $cont = '';
        $servidor = $_SERVER['SERVER_NAME'].":".$_SERVER['SERVER_PORT'];

        // Validación del servidor
        if(($servidor!="dromedicas.sytes.net:9996")&&($servidor!="192.168.14.248:9999"))
            $cont.='<table width="400">
                     <tr class="CabezoteTabla"> 
                      <td align="center"> <b>Servidor incorrecto </b> </td>
                     </tr> 
                     <tr class="CabezoteTabla"> 
                      <td align="center"> 
                       <font color=red> Este servidor est&aacute; inhabilitado para hacer este <br> 
                       proceso, por favor diríjase al servidor </font><br> 
                       <font color=blue> 192.168.14.248:9999 </font> <br>
                       <font color=red>o al servidor </font> <br> 
                       <font color=blue> dromedicas.sytes.net:9996 </font> <br>
                       <font color=red> para poder ejecutar este proceso </font> <br><br>
                      </td> 
                     </tr>
                     <tr class="TablaDocsPar">        
                      <td width="100%" align="center"> 
                       <form name="importa" method="post" action="empleadosperiodo.php?opcion=ventanaactdatos" id="theform" enctype="multipart/form-data">
                        <input type="submit" name="enviar" id="enviarr"  value="aceptar" class="button blue" /> 
                       </form> 
                      </td>    
                     </tr>
                    </table>';
        else
        {
            // Obtengo el periodo actual
            $vsql = "SELECT periodoid
                       FROM periodosnomina 
                      WHERE periodoid = (SELECT MIN(periodoid) FROM periodosnomina WHERE cerrado ='')";
            $periodoid = $clase->SeleccionarUno($vsql);
    
            $descripcion = $clase->BDLockup($periodoid,'periodosnomina','periodoid','descripcion');
    
            // pinto la ventana
            $cont.='<script type="text/javascript" src="lib/jquery-2.1.3.min.js"></script>
                    <script>
                     $(function()
                     {
                      $("#enviarr").on("click",function()
                      {
                        $(this).val("Espere por favor ...")
                        .attr("disabled","disabled");
                        $("#theform").submit();
                      });
                     });
                    </script>
                    <table width="400">
                     <tr class="CabezoteTabla"> 
                      <td align="center"> <b>Actualizar salarios b&aacute;sicos<br> masivamente en el periodo <br> <font color="BLUE">'.strtolower($descripcion).'</font></b> <br><br></td> 
                     </tr> 
                    </table>
                    <table width="400">
                     <tr class="TablaDocsPar">        
                      <td width="100%" align="center"> 
                       <form name="importa" method="post" action="?opcion=actualizarbasicos" id="theform" enctype="multipart/form-data">
                       <input type="hidden" name="periodoid" value="'.$periodoid.'">
                       <input type="file" name="excel" /><br><br>                       
                       <input type="submit" name="enviar" id="enviarr"  value="Importar archivo" class="button blue" />
                       <input type="hidden" value="upload" name="action" />                  
                       </form> 
                      </td>    
                     </tr>
                    </table>';
    
            $cont.='<table width="400">
                     <tr class="TablaDocsPar"> <td align="left"> &nbsp; La hoja de Excel debe tener la siguiente estructura: </td> </tr>
                     <tr class="TablaDocsPar"> <td align="left"> &nbsp; Columna <b>A</b>: C&eacute;dula </td> </tr>
                     <tr class="TablaDocsPar"> <td align="left"> &nbsp; Columna <b>B</b>: B&aacute;sico (n&uacute;meros enteros) </td> </tr>
                    </table>';
    
            $cont.='<table width="400">
                     <tr class="TablaDocsPar"> 
                      <td align="center"> 
                       <img src="images/iconos/ejemplobasicos.jpg" width="280" height="200" border="0">
                      </td> 
                     </tr>
                     <tr class="TablaDocsPar"> 
                      <td width="100%" align="center"> 
                       <font color="BLUE"> Importante: Se debe utilizar un archivo de Excel con extensión .xlsx</font>
                      </td> 
                     </tr>
                    </table>';
        }
        echo $cont;
        exit();
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opciones: actualizarbasicos
    // Creación: 21/12/2022		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que almacena mediante una hoja de Excel las actualizaciones de 
    //              salarios básicos
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////        
    if($opcion == "actualizarbasicos")
    {
		set_time_limit(0);
		extract($_POST);
        $periodoid = $_POST["periodoid"];
		$archivo = $_FILES['excel']['name'];
		$tipo = $_FILES['excel']['type'];
		$destino = "recursos/xls/bak_".$archivo;

        // Valido que la extensión del archivo sea xlsx
        $extension = pathinfo($destino, PATHINFO_EXTENSION);

        if($extension!="xlsx")
        {
            $clase->Aviso(3,"El archivo debe tener extensión .xlsx");
            header("Location: empleadosperiodo.php?opcion=ventanaactdatos");
        }
        else
        {
            /// Valido si se cargó el archivo o no
            if (!copy($_FILES['excel']['tmp_name'],$destino))
                echo "Error Al Cargar el Archivo";
        
            if (file_exists ("recursos/xls/bak_".$archivo))
            {
                require_once('lib/PHPExcel.php');
                require_once('lib/PHPExcel/Reader/Excel2007.php');
                
                $objReader = new PHPExcel_Reader_Excel2007();
                $objPHPExcel = $objReader->load("recursos/xls/bak_".$archivo);
                $objFecha = new PHPExcel_Shared_Date();
                $objPHPExcel->setActiveSheetIndex(0);

                $conex = $clase->Conectar();
                $recorrer = true;  $i = 1;
                while($recorrer)
                {
                    $_DATOS_EXCEL[$i]['dni'] = $objPHPExcel->getActiveSheet()->getCell('A'.$i)->getCalculatedValue();
                    $_DATOS_EXCEL[$i]['basico'] = $objPHPExcel->getActiveSheet()->getCell('B'.$i)->getCalculatedValue();                    
                
                    if((strlen($_DATOS_EXCEL[$i]['dni']) == 0)||(strlen($_DATOS_EXCEL[$i]['basico']) == 0))
                        $recorrer = false;
                    
                    $i++;
                } /// Fin del While
            }
            else
            { echo "Necesitas primero importar el archivo";  }  /// Si NO Cargó el archivo

            // ------------------------------------------------------------------------------------------ //
            //Teniendo la Informacion en el Array la inserto en la Base de Datos
            $errores=0;
            $grabados = 0;
            
            $descripcion = $clase->BDLockup($periodoid,'periodosnomina','periodoid','descripcion');
            $carpetaactual = 'reportes/';

            // Construcción de la variable con los documentos no grabados
            $nocedulas = 'ACTUALIZACION DE SALARIOS BASICOS'.Chr(13).Chr(10);
            $nocedulas.= ''.str_pad($descripcion,1,"").''.Chr(13).Chr(10);
            $nocedulas.= 'DOCUMENTOS NO GRABADOS:'.Chr(13).Chr(10);
            $nocedulas.= ''.Chr(13).Chr(10);           

            for($j=1; $j < $i; $j++)
            {
                // Obtengo los datos necesarios                
                $dni = $_DATOS_EXCEL[$j]['dni'];
                $basico = $_DATOS_EXCEL[$j]['basico'];                

                // Valido que el empleado exista
                $terid = $clase->BDLockup($dni,"terceros","dni","terid");               
                
                if(strlen($terid) > 0)
                {
                    // llamado al procedimiento para validar el monto
                    $lb_valido = false;
                    $lb_valido = $io_fecha->uf_solo_numeros($basico);

                    if($lb_valido)
                    {
                        // Almaceno la información
                        $vsql = "UPDATE terceros SET basico = '".$basico."' WHERE terid = ".$terid;
                        $clase->EjecutarSQL($vsql);

                        if(mysql_affected_rows() >= 1)
                            $grabados++;
                        else
                        {
                            $nocedulas.= str_pad($dni,1,"").''.Chr(13).Chr(10);         // Actualizo la variable con el documento no almacenado
                            $archivo = "errores.txt";                                   // nombre del archivo
                            $fd = fopen ($carpetaactual."/".$archivo, "w");             // se abre el archivo para escribir
                            fwrite($fd, $nocedulas);                                    // Grabas
                            fclose($fd);                                                // Cierras el archivo
                        }
                    }
                    else
                    {
                        $nocedulas.= str_pad($dni,1,"").''.Chr(13).Chr(10);         // Actualizo la variable con el documento no almacenado
                        $archivo = "errores.txt";                                   // nombre del archivo
                        $fd = fopen ($carpetaactual."/".$archivo, "w");             // se abre el archivo para escribir
                        fwrite($fd, $nocedulas);                                    // Grabas
                        fclose($fd);                                                // Cierras el archivo                        
                    }
                }
                else
                {
                    $nocedulas.= str_pad($dni,1,"").''.Chr(13).Chr(10);         // Actualizo la variable con el documento no almacenado
                    $archivo = "errores.txt";                                   // nombre del archivo
                    $fd = fopen ($carpetaactual."/".$archivo, "w");             // se abre el archivo para escribir
                    fwrite($fd, $nocedulas);                                    // Grabas
                    fclose($fd);                                                // Cierras el archivo                    
                }
            }
      
            // Elimino el Archivo
            unlink($destino);
    
            // Emito el mensaje correspondiente
            if($grabados==0)
                $clase->Aviso(3,"No se cargaron las actualizaciones de salarios básicos en el periodo $descripcion");
            else
                $clase->Aviso(1,"Se cargaron $grabados actualizaciones de salarios básicos en el periodo $descripcion");

            // Redirecciono el formulario
            header("Location: empleadosperiodo.php?opcion=ventanaactdatos");
        }
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: ventanaactdatos
    // Creación: 22/12/2022		última modificación: 27/06/2023
    // Creador: Luis Flórez		modificado por: Luis Flórez
    // Descripción: Ventana para seleccionar las opciones de actualización de datos básicos
    // Última modificación: Documentos no actualizados en una nueva ventana
    ////////////////////////////////////////////////////////////////////////////////////////    
    if($opcion == "ventanaactdatos")
    {
        // Obtengo el nombre del periodo a procesar
        $vsql = "SELECT periodoid
                   FROM periodosnomina 
                  WHERE periodoid = (SELECT MIN(periodoid) FROM periodosnomina WHERE cerrado ='')";
        $periodoid = $clase->SeleccionarUno($vsql);

        $descripcion = $clase->BDLockup($periodoid,'periodosnomina','periodoid','descripcion');

        // pinto la ventana        
        $cont = $clase->Header("S","W");
        $cont.='<table width="100%">
                 <tr class="CabezoteTabla"> 
                  <td width="10"> &nbsp; </td>
                  <td width="37"> <img src="images/iconos/clientes.png" width="32" height="32" border="0"> </td>
                  <td width="850"> <b> Actualizaci&oacute;n de datos del periodo <font color="blue"> '.$descripcion.' </font> </b> </td>
                  <td width="10"> &nbsp; </td>                  
                  <td width="24"> &nbsp; </td>
                  <td width="250" align="right"> 
                   <a href="empleadosperiodo.php"> 
                    <input type="button" class="button" value="<<"> 
                   </a>
                  </td>                  
                  <td width="10"> &nbsp; </td>
                 </tr>
                </table>';

        // Advertencia del servidor equivocado
        $servidor = $_SERVER['SERVER_NAME'].":".$_SERVER['SERVER_PORT'];

        if(($servidor!="dromedicas.sytes.net:9996")&&($servidor!="192.168.14.248:9999"))
            $cont.='<table width="100%">
                     <tr class="CabezoteTabla"> 
                      <td width="10"> &nbsp; </td>
                      <td width="37"> <img src="images/iconos/alerta.png" width="32" height="32" border="0"> </td>
                      <td width="930" align="center"> 
                       Para poder ejecutar el proceso de actualizar datos desde una hoja de Excel debe dirigirse al servidor <br> 192.168.14.248:9999 o al servidor dromedicas.sytes.net:9996 
                      </td>
                      <td width="24"> &nbsp; </td>
                     </tr>
                    </table>';

        $cont.='<center>
                <table width="900" border="0">
                 <tr height="120">
                  <td width="25%" align="center">  
                   <a href="?opcion=importarbasicos" rel="facebox">
                    <img src="images/iconos/importarexcel.png" border="0" width="38" height="38"> 
                    <br>Actualizar salarios <br> b&aacute;sicos
                   </a>                   
                  </td>
                  <td width="25%" align="center">
                   <a href="?opcion=importarcuentas" rel="facebox">
                    <img src="images/iconos/importarexcel.png" border="0" width="38" height="38">
                    <br>Actualizar cuentas <br> bancarias
                   </a>
                  </td>
                  <td width="25%" align="center"> 
                   <a href="?opcion=importarextraleal" rel="facebox">
                    <img src="images/iconos/importarexcel.png" border="0" width="38" height="38">
                    <br> Marcar como extralegal <br> masivamente
                   </a>
                  </td>
                  <td width="25%" align="center">  
                   <a href="?opcion=importarexcelcedulas" rel="facebox">
                    <img src="images/iconos/importarexcel.png" border="0" width="38" height="38">
                    <br> Activar empleados <br>masivamente
                   </a>
                  </td> 
                 </tr>
                 <tr height="120">
                  <td width="25%" align="center"> 
                   <a href="terceros.php" target="blank">
                    <img src="images/iconos/clientesgenerales.png" border="0" width="38" height="38">
                    <br> Ficha terceros
                   </a>
                  </td>
                  <td width="25%" align="center">
                   <a href="?opcion=vererrores2" rel="facebox">
                    <img src="images/iconos/notas.png" border="0" width="38" height="38">
                    <br> Documentos no actualizados <br> en el &uacute;ltimo proceso 
                   </a>
                  </td>
                  <td width="25%" align="center"> &nbsp; </td>
                  <td width="25%" align="center"> &nbsp; </td>
                 </tr>
                </table>';        
        echo $cont.$clase->PiePagina();
        exit();
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: vererrores1
    // Creación: 27/06/2023		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que pinta la ventana para emitir la información del archivo de 
    //              texto errores.txt
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "vererrores1")
    {
        // Inicialización de variables
        $archivoerror = "reportes/errores.txt";
        $btnaceptar = '<a href="?opcion=ventanacargosysecciones">';
        $txt = "";
        $plantilla = fopen($archivoerror,"r") or die("error al leer archivo");
        
        // Lleno la variable con los documentos no guardados
        while(!feof($plantilla))
        {
            $plantillaFinal = fgets($plantilla);
            $plantillaFinal = nl2br($plantillaFinal);
            $txt.= $plantillaFinal;
        }

        // Pinto la ventana con la información solicitada
        // echo $txt; exit();
        $txt = trim(str_replace("<br />","",$txt));
        $cont.='<table width="400">
                 <tr class="CabezoteTabla"> 
                  <td align="center"> <b> Documentos no grabados <br>en el &uacute;ltimo proceso</b> </td> 
                 </tr>
                 <tr class="CabezoteTabla"> 
                  <td align="center"> <textarea name="txt" cols="70" rows="38" disabled> '.$txt.' </textarea> </td> 
                 </tr> 
                 <tr class="CabezoteTabla"> 
                  <td align="center">
                   '.$btnaceptar.'<input type="button" value="aceptar" class="button blue"></a>
                  </td> 
                 </tr>
                </table>';
        echo $cont;
        exit();
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: vererrores2
    // Creación: 27/06/2023		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que pinta la ventana para emitir la información del archivo de 
    //              texto errores.txt
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "vererrores2")
    {
        // Inicialización de variables
        $archivoerror = "reportes/errores.txt";
        $btnaceptar = '<a href="?opcion=ventanaactdatos">';
        $txt = "";
        $plantilla = fopen($archivoerror,"r") or die("error al leer archivo");
        
        // Lleno la variable con los documentos no guardados
        while(!feof($plantilla))
        {
            $plantillaFinal = fgets($plantilla);
            $plantillaFinal = nl2br($plantillaFinal);
            $txt.= $plantillaFinal;
        }

        // Pinto la ventana con la información solicitada
        // echo $txt; exit();
        $txt = trim(str_replace("<br />","",$txt));
        $cont.='<table width="400">
                 <tr class="CabezoteTabla"> 
                  <td align="center"> <b> Documentos no grabados <br>en el &uacute;ltimo proceso</b> </td> 
                 </tr>
                 <tr class="CabezoteTabla"> 
                  <td align="center"> <textarea name="txt" cols="70" rows="38" disabled> '.$txt.' </textarea> </td> 
                 </tr> 
                 <tr class="CabezoteTabla"> 
                  <td align="center">
                   '.$btnaceptar.'<input type="button" value="aceptar" class="button blue"></a>
                  </td> 
                 </tr>
                </table>';
        echo $cont;
        exit();
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: vererrores3
    // Creación: 01/07/2023		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que pinta la ventana para emitir la información del archivo de 
    //              texto erroresactterceros.txt
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////    
    if($opcion == "vererrores3")
    {
        // Inicialización de variables
        $archivoerror = "reportes/erroresactterceros.txt";
        $btnaceptar = '<a href="?opcion=ventactterceros">';
        $txt = "";
        $plantilla = fopen($archivoerror,"r") or die("error al leer archivo");
        
        // Lleno la variable con los documentos no guardados
        while(!feof($plantilla))
        {
            $plantillaFinal = fgets($plantilla);
            $plantillaFinal = nl2br($plantillaFinal);
            $txt.= $plantillaFinal;
        }

        // Pinto la ventana con la información solicitada
        // echo $txt; exit();
        $txt = trim(str_replace("<br />","",$txt));
        $cont.='<table width="400">
                 <tr class="CabezoteTabla"> 
                  <td align="center"> <b> Documentos no grabados <br>en el &uacute;ltimo proceso</b> </td> 
                 </tr>
                 <tr class="CabezoteTabla"> 
                  <td align="center"> <textarea name="txt" cols="70" rows="38" disabled> '.$txt.' </textarea> </td> 
                 </tr> 
                 <tr class="CabezoteTabla"> 
                  <td align="center">
                   '.$btnaceptar.'<input type="button" value="aceptar" class="button blue"></a>
                  </td> 
                 </tr>
                </table>';
        echo $cont;
        exit();
    }

    // if($opcion == "vererrores4")
    // {
    //     // Inicialización de variables
    //     $archivoerror = "reportes/tercerosactualizados.txt";
    //     $btnaceptar = '<a href="?opcion=ventactterceros">';
    //     $txt = "";
    //     $plantilla = fopen($archivoerror,"r") or die("error al leer archivo");
        
    //     // Lleno la variable con los documentos no guardados
    //     while(!feof($plantilla))
    //     {
    //         $plantillaFinal = fgets($plantilla);
    //         $plantillaFinal = nl2br($plantillaFinal);
    //         $txt.= $plantillaFinal;
    //     }

    //     // Pinto la ventana con la información solicitada
    //     // echo $txt; exit();
    //     $txt = trim(str_replace("<br />","",$txt));
    //     $cont.='<table width="400">
    //              <tr class="CabezoteTabla"> 
    //               <td align="center"> <b> Documentos grabados <br>en el &uacute;ltimo proceso</b> </td> 
    //              </tr>
    //              <tr class="CabezoteTabla"> 
    //               <td align="center"> <textarea name="txt" cols="70" rows="38" disabled> '.$txt.' </textarea> </td> 
    //              </tr> 
    //              <tr class="CabezoteTabla"> 
    //               <td align="center">
    //                '.$btnaceptar.'<input type="button" value="aceptar" class="button blue"></a>
    //               </td> 
    //              </tr>
    //             </table>';
    //     echo $cont;
    //     exit();
    // }    

    // if($opcion == "veractualizaciones")
    // {
    //     // Inicialización de variables
    //     $archivoact = "reportes/tercerosactualizados.txt";
    //     $archivoerror = "reportes/erroresactterceros.txt";
    //     $btnaceptar = '<a href="?opcion=ventactterceros">';
    //     $txt = "";
    //     $txt2= "";
    //     $plantilla = fopen($archivoerror,"r") or die("error al leer archivo");
    //     $plantilla2 = fopen($archivoact,"r") or die("error al leer archivo");
        
    //     // Lleno la variable con los documentos no guardados
    //     while(!feof($plantilla))
    //     {
    //         $plantillaFinal = fgets($plantilla);
    //         $plantillaFinal = nl2br($plantillaFinal);
    //         $txt.= $plantillaFinal;
    //     }

    //     // Lleno la variable con los documentos no guardados
    //     while(!feof($plantilla2))
    //     {
    //         $plantillaFinal = fgets($plantilla2);
    //         $plantillaFinal = nl2br($plantillaFinal);
    //         $txt2.= $plantillaFinal;
    //     }

    //     // Pinto la ventana con la información solicitada
    //     // echo $txt; exit();
    //     $txt = trim(str_replace("<br />","",$txt));
    //     $txt2 = trim(str_replace("<br />","",$txt2));
    //     $cont.='<table width="400">
    //              <tr class="CabezoteTabla"> 
    //               <td align="center"> <b> Documentos actualizados en el &uacute;ltimo proceso</b> <br></td> 
    //              </tr>
    //              <tr class="CabezoteTabla"> 
    //               <td align="left"> 
    //                <b> Grabados </b> <br>                  
    //                <textarea name="txt" cols="70" rows="19" disabled> '.$txt2.' </textarea> 
    //               </td> 
    //              </tr>
    //              <tr class="CabezoteTabla"> <td align="center"> &nbsp;</td> </tr> 
    //              <tr class="CabezoteTabla"> 
    //               <td align="left"> 
    //                <b> NO grabados </b> <br>
    //                <textarea name="txt" cols="70" rows="19" disabled> '.$txt.' </textarea> </td> 
    //              </tr> 
    //              <tr class="CabezoteTabla"> 
    //               <td align="center">
    //                '.$btnaceptar.'<input type="button" value="aceptar" class="button blue"></a>
    //               </td> 
    //              </tr>
    //             </table>';
    //     echo $cont;
    //     exit();
    // }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: ventactterceros
    // Creación: 29/06/2023		última modificación: 01/08/2023
    // Creador: Luis Flórez		modificado por: Luis Flórez
    // Descripción: Opción que pinta la ventana para la actualización de datos de la tabla 
    //              terceros
    // Última modificación: Inclusión del acceso al formulario de histórico de contratos
    //                      (26/07/2023)
    //                      Validación del icono de empleados activos liquidados
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "ventactterceros")
    {
        // Obtengo el nombre del periodo a procesar
        $vsql = "SELECT periodoid
                   FROM periodosnomina 
                  WHERE periodoid = (SELECT MIN(periodoid) FROM periodosnomina WHERE cerrado ='')";
        $periodoid = $clase->SeleccionarUno($vsql);

        // Inicialización de variables
        $descripcion = $clase->BDLockup($periodoid,'periodosnomina','periodoid','descripcion');
        $numliq = 0;
        $servidor = "";
        $vsql8 = "";
        $iconoliq = '';

        // Pinto la ventana
        $cont = $clase->Header("S","W");
        $cont.='<table width="100%">
                 <tr class="CabezoteTabla"> 
                  <td width="10"> &nbsp; </td>
                  <td width="37"> <img src="images/iconos/variaciones.png" width="32" height="32" border="0"> </td>
                  <td width="850"> <b> Actualizaci&oacute;n de la ficha terceros para el periodo <font color="blue"> '.$descripcion.' </font> </b> </td>
                  <td width="10"> &nbsp; </td>                  
                  <td width="24"> &nbsp; </td>
                  <td width="250" align="right"> <a href="empleadosperiodo.php"> <input type="button" class="button blue" value="<<"> </a> </td>                  
                  <td width="10"> &nbsp; </td>
                 </tr>
                </table>';

        // Advertencia del servidor equivocado 
        $servidor = $_SERVER['SERVER_NAME'].":".$_SERVER['SERVER_PORT'];

        if(($servidor!="dromedicas.sytes.net:9996")&&($servidor!="192.168.14.248:9999"))
            $cont.='<table width="100%">
                     <tr class="CabezoteTabla"> 
                      <td width="10"> &nbsp; </td>
                      <td width="37"> <img src="images/iconos/alerta.png" width="32" height="32" border="0"> </td>
                      <td width="930" align="center"> 
                       Para poder ejecutar el proceso de subir actualizaci&oacute;n desde una hoja de Excel debe dirigirse al servidor <br> 192.168.14.248:9999 o al servidor dromedicas.sytes.net:9996 
                      </td>
                      <td width="24"> &nbsp; </td>
                     </tr>
                    </table>';

        // Procesos para actualizar datos
        $cont.='<center>
                <table width="900" border="0">
                 <tr height="120">
                  <td width="25%" align="center">  
                   <a href="?opcion=datostercerosxls" target="_blank">
                    <img src="images/iconos/descargar.png" border="0" width="38" height="38"> 
                    <br> Descargar datos actuales
                   </a>
                  </td>
                  <td width="25%" align="center">
                   <a href="?opcion=importarterceros" rel="facebox">
                    <img src="images/iconos/cargar.png" border="0" width="38" height="38">
                    <br> Subir actualizaci&oacute;n
                   </a>
                  </td>
                  <td width="25%" align="center">
                   <a href="?opcion=respadoterceros" target="_blank">
                    <img src="images/iconos/guardardoc.png" border="0" width="38" height="38">
                    <br> Respaldo de la tabla <br>terceros (respaldoterceros)
                   </a>
                  </td>
                  <td width="25%" align="center">  
                   <a href="?opcion=ventanarecuperar" target="_blank">
                    <img src="images/iconos/basedatos.png" border="0" width="38" height="38">
                    <br> Recuperar respaldo <br> de terceros 
                   </a>
                  </td> 
                 </tr>
                 <tr height="120">
                  <td width="25%" align="center"> 
                   <a href="?opcion=codigosxls" target="_blank">
                    <img src="images/iconos/exportarexcel.png" border="0" width="38" height="38">
                    <br> C&oacute;digos en Excel
                   </a>
                  </td>
                  <td width="25%" align="center">
                   <a href="?opcion=codigospdf" target="_blank">
                    <img src="images/iconos/exportarpdf2.png" border="0" width="38" height="38">
                    <br> C&oacute;digos en pdf
                   </a>
                  </td>
                  <td width="25%" align="center">
                   <a href="terceros.php" target="_blank">
                    <img src="images/iconos/clientesgenerales.png" border="0" width="38" height="38">
                    <br> Ficha terceros
                   </a>
                  </td>
                  <td width="25%" align="center">
                   <a href="infhistcont.php?opcion=ventanadatos" target="_blank">
                    <img src="images/iconos/infcomisiones.png" border="0" width="38" height="38">
                    <br> Hist&oacute;rico de contratos
                   </a>
                  </td>
                 </tr>                 
                </table>';

        // Datos de empleados liquidados
        $vsql8 = "SELECT COUNT(*) numliq FROM terceros WHERE esempleadoactivo = 'CHECKED' AND enliquidacion = 'CHECKED' ";
        $numliq = $clase->SeleccionarUno($vsql8);

        if($numliq == 0)
            $iconoliq = '<img src="images/iconos/proveedores.png" border="0" width="38" height="38"> <br> <font color="gray"> No existen empleados <br> liquidados activos </font>';
        else
            $iconoliq = '<a href="?opcion=ventemplactiliq" target="_blank">
                          <img src="images/iconos/proveedores.png" border="0" width="38" height="38"> 
                          <br>Liquidados activos
                         </a>';

        // Pinto la ventana
        $cont.='<center>
                <table width="900" border="0">
                 <tr height="120">
                  <td width="25%" align="center">  
                   <a href="?opcion=ventselper" rel="facebox">
                    <img src="images/iconos/descargar.png" border="0" width="38" height="38"> 
                    <br> Descargar empleados <br> liquidados
                   </a>
                  </td>
                  <td width="25%" align="center"> '.$iconoliq.' </td>
                  <td width="25%" align="center">
                   <a href="?opcion=ventanaactualizaractivos&periodoid='.$periodoid.'" rel="facebox">
                    <img src="images/iconos/importarexcel.png" border="0" width="38" height="38">
                    <br> Activar e inactivar <br> masivamente
                   </a>
                  </td>
                  <td width="25%" align="center">
                   <a href="empleadosperiodo.php?opcion=ventanasincronizacion" target="_blank">
                    <img src="images/iconos/inventario.png" border="0" width="38" height="38">
                    <br> empleados desincronizados
                   </a>                  
                  </td> 
                 </tr>
                </table>';

        echo $cont.$clase->PiePagina();
        exit();
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: datostercerosxls
    // Creación: 29/06/2023		última modificación: 
    // Creador: Luis Flórez		modificado por: Luis Flórez
    // Descripción: Opción que genera una hoja de Excel con los datos de la tabla terceros 
    //              que se actualizarán
    // Última modificación: Inclusión de la columna de fecha de ingreso (26/07/2023)
    //                      Inclusión de una nueva hoja con los id de las eps, fondos de 
    //                      pensión, cesantías, cajas de compensación, áreas, secciones, 
    //                      cargos y bancos (15/08/2023)
    //                      Inclusión del campo tipo de documento en ambas hojas 
    //                      (18/04/2024)
    //                      Inclusión de la fecha de ingreso a la empresa en la hoja con 
    //                      los datos de los empleados
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "datostercerosxls")
    {
        // Obtengo el nombre del periodo a procesar
        $vsql2 = "SELECT periodoid
                    FROM periodosnomina 
                   WHERE periodoid = (SELECT MIN(periodoid) FROM periodosnomina WHERE cerrado ='')";
        $periodoid = $clase->SeleccionarUno($vsql2);

        // Fechas del periodo actual
        $fecdesdeper = $clase->BDLockup($periodoid,'periodosnomina','periodoid','fecdesde');
        $fechastaper = $clase->BDLockup($periodoid,'periodosnomina','periodoid','fechasta');

        // Preparo el entorno
        require_once 'lib/PHPExcel.php';
        $clase = new Sistema();
        $clase->Conectar();
        ini_set("memory_limit","100M");

        // Consulta de empleados activos
        $vsql = "SELECT terid, dni, primernombre, segundonombre, primerapellido, segundoapellido, basico, fecingreso, epsid, pensionesid, 
                        cesantiasid, idcajacomp, areaid, seccionid, cargoid, bancoid, numcuenta, esempleadoactivo, extralegal, codvende,
                        tipodoc, ingresoemp 
                   FROM terceros 
                  WHERE esempleadoactivo = 'CHECKED' 
                        AND basico > 0 
                        AND fecingreso <= '".$fechastaper."'
                 UNION 
                 SELECT terid, dni, primernombre, segundonombre, primerapellido, segundoapellido, basico, fecingreso, epsid, pensionesid, 
                        cesantiasid, idcajacomp, areaid, seccionid, cargoid, bancoid, numcuenta, esempleadoactivo, extralegal, codvende,
                        tipodoc, ingresoemp   
                   FROM terceros 
                  WHERE fecharetiro BETWEEN '".$fecdesdeper."' AND '".$fechastaper."'
                        AND basico > 0";

        // Preparación del entorno para la salida a Excel
        $clase = new Sistema();
        $clase->Nombredb = $_SESSION['DBNOMBRE'];
        error_reporting(E_ALL);
        ini_set('display_errors', TRUE);
        ini_set('display_startup_errors', TRUE);
        date_default_timezone_set('Europe/London');
    
        if (PHP_SAPI == 'cli')
            die('This example should only be run from a Web Browser');
    
        // Create new PHPExcel object
        $objPHPExcel = new PHPExcel();
    
        // Set document properties
        $objPHPExcel->getProperties()->setCreator("Sistemas y Soluciones Web de Colombia")
                                     ->setLastModifiedBy("Sistemas y Soluciones Web de Colombia")
                                     ->setTitle("datos terceros - DROPOS")
                                     ->setSubject("datos terceros - DROPOS")
                                     ->setDescription("datos terceros - DROPOS")
                                     ->setKeywords("datos terceros - DROPOS")
                                     ->setCategory("Categoria General");

        $objPHPExcel->setActiveSheetIndex(0)
                    ->setCellValue('A1', 'TERID')
                    ->setCellValue('B1', 'CEDULA')
                    ->setCellValue('C1', 'PRIMER NOMBRE')
                    ->setCellValue('D1', 'SEGUNDO NOMBRE')
                    ->setCellValue('E1', 'PRIMER APELLIDO')
                    ->setCellValue('F1', 'SEGUNDO APELLIDO')
                    ->setCellValue('G1', 'BASICO')
                    ->setCellValue('H1', 'FECHA INGRESO')
                    ->setCellValue('I1', 'EPS')
                    ->setCellValue('J1', 'AFP')
                    ->setCellValue('K1', 'CESANTIAS')
                    ->setCellValue('L1', 'CAJA COMPENSACION')
                    ->setCellValue('M1', 'AREA')
                    ->setCellValue('N1', 'SECCION')
                    ->setCellValue('O1', 'CARGO')
                    ->setCellValue('P1', 'BANCO')
                    ->setCellValue('Q1', 'NUMERO CUENTA')
                    ->setCellValue('R1', 'EMPLEADO ACTIVO')
                    ->setCellValue('S1', 'EXTRALEGAL')
                    ->setCellValue('T1', 'CODVENDE')
                    ->setCellValue('U1', 'FECHA RETIRO')
                    ->setCellValue('V1', 'TIPO DOCUMENTO')                    
                    ->setCellValue('W1', 'INGRESO EMPRESA');

        $objPHPExcel->getActiveSheet()->getColumnDimension('A')->setAutoSize(true);                 $objPHPExcel->getActiveSheet()->getColumnDimension('B')->setAutoSize(true);
        $objPHPExcel->getActiveSheet()->getColumnDimension('C')->setAutoSize(true);                 $objPHPExcel->getActiveSheet()->getColumnDimension('D')->setAutoSize(true);
        $objPHPExcel->getActiveSheet()->getColumnDimension('E')->setAutoSize(true);                 $objPHPExcel->getActiveSheet()->getColumnDimension('F')->setAutoSize(true);
        $objPHPExcel->getActiveSheet()->getColumnDimension('G')->setAutoSize(true);                 $objPHPExcel->getActiveSheet()->getColumnDimension('H')->setAutoSize(true);
        $objPHPExcel->getActiveSheet()->getColumnDimension('I')->setAutoSize(true);                 $objPHPExcel->getActiveSheet()->getColumnDimension('J')->setAutoSize(true);
        $objPHPExcel->getActiveSheet()->getColumnDimension('K')->setAutoSize(true);                 $objPHPExcel->getActiveSheet()->getColumnDimension('L')->setAutoSize(true);
        $objPHPExcel->getActiveSheet()->getColumnDimension('M')->setAutoSize(true);                 $objPHPExcel->getActiveSheet()->getColumnDimension('N')->setAutoSize(true);
        $objPHPExcel->getActiveSheet()->getColumnDimension('O')->setAutoSize(true);                 $objPHPExcel->getActiveSheet()->getColumnDimension('P')->setAutoSize(true);
        $objPHPExcel->getActiveSheet()->getColumnDimension('Q')->setAutoSize(true);                 $objPHPExcel->getActiveSheet()->getColumnDimension('R')->setAutoSize(true);
        $objPHPExcel->getActiveSheet()->getColumnDimension('S')->setAutoSize(true);                 $objPHPExcel->getActiveSheet()->getColumnDimension('T')->setAutoSize(true);
        $objPHPExcel->getActiveSheet()->getColumnDimension('U')->setAutoSize(true);                 $objPHPExcel->getActiveSheet()->getColumnDimension('V')->setAutoSize(true);
        $objPHPExcel->getActiveSheet()->getColumnDimension('W')->setAutoSize(true);

        $i = 2;
        $conex  = $clase->Conectar();
        $result = mysql_query($vsql,$conex);
        $cant   = mysql_num_rows($result);
        while($row = mysql_fetch_array($result))
        {
            $codvende = $row['codvende'];
            if(substr($codvende,0,1) == "0")            $codvende="'".$codvende;

            $objPHPExcel->setActiveSheetIndex(0)
                        ->setCellValue('A'.$i, $row['terid'])
                        ->setCellValue('B'.$i, $row['dni'])
                        ->setCellValue('C'.$i, $row['primernombre'])
                        ->setCellValue('D'.$i, $row['segundonombre'])
                        ->setCellValue('E'.$i, $row['primerapellido'])
                        ->setCellValue('F'.$i, $row['segundoapellido'])
                        ->setCellValue('G'.$i, $row['basico'])
                        ->setCellValue('H'.$i, $row['fecingreso'])
                        ->setCellValue('I'.$i, $row['epsid'])
                        ->setCellValue('J'.$i, $row['pensionesid'])
                        ->setCellValue('K'.$i, $row['cesantiasid'])
                        ->setCellValue('L'.$i, $row['idcajacomp'])
                        ->setCellValue('M'.$i, $row['areaid'])
                        ->setCellValue('N'.$i, $row['seccionid'])
                        ->setCellValue('O'.$i, $row['cargoid'])
                        ->setCellValue('P'.$i, $row['bancoid'])
                        ->setCellValue('Q'.$i, $row['numcuenta'])
                        ->setCellValue('R'.$i, $row['esempleadoactivo'])
                        ->setCellValue('S'.$i, $row['extralegal'])
                        ->setCellValue('T'.$i, $codvende)
                        ->setCellValue('V'.$i, $row['tipodoc'])
                        ->setCellValue('W'.$i, $row['ingresoemp']);
            $i++;
        }

        $rangoEncabezado = 'A4:V4';
        $rangoCeldas     = 'A4:V'.($i-1);

        // ----------------------------------------------------------------------------------------------------------------------------------------------------------- //
        // Formato de Encabezado y Celdas
        $objPHPExcel->getActiveSheet()->getRowDimension('1')->setRowHeight(15);
        
        $EstiloCeldas = array(
        'borders' => array(
            'allborders' => array(
                'style' => PHPExcel_Style_Border::BORDER_THIN,
                'color' => array('argb' => '00000000'),
            ),
            ),
        );
        // $objPHPExcel->getActiveSheet()->getStyle($rangoCeldas)->applyFromArray($EstiloCeldas);
        /// Formato de Encabezados 
        $EstiloEncabezado = array(
        'font' => array(
            'bold' => true,
        ),
        'alignment' => array(
            'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,
            'vertical' => PHPExcel_Style_Alignment::VERTICAL_CENTER,		
        ),
        'borders' => array(
            'allborders' => array(
                'style' => PHPExcel_Style_Border::BORDER_THIN,
                'color' => array('argb' => '00000000'),
            ),
        ),
        'fill' => array(
            'type' => PHPExcel_Style_Fill::FILL_SOLID,
            'rotation' => 90,
            'startcolor' => array(
                'argb' => '00FFFFCC',
            ),
            'endcolor' => array(
                'argb' => 'FFFFFF',
            ),
            ),
        );
        // $objPHPExcel->getActiveSheet()->getStyle($rangoEncabezado)->applyFromArray($EstiloEncabezado);
        // Rename worksheet
        $objPHPExcel->getActiveSheet()->setTitle('datos de terceros');
        // Set active sheet index to the first sheet, so Excel opens this as the first sheet
        $objPHPExcel->setActiveSheetIndex(0);

        // --------------------------------------------------------------------------------------------------------------------------------------------------- //
        // Nueva hoja con los id de las eps, fondos de pensión, cesantías, cajas de compensación, áreas, secciones, cargos, bancos y tipos de documento.
        $objPHPExcel->createSheet();

        $objPHPExcel->setActiveSheetIndex(1); // marcar como activa la nueva hoja
        $objPHPExcel->getActiveSheet()->setTitle('codigos');        

        // consulta para las eps
        $vsql = "SELECT epsid, descripcioneps FROM eps";

        $objPHPExcel->setActiveSheetIndex(0)
                    ->setCellValue('codigos!A1', 'CODIGOS TERCEROS')
                    ->setCellValue('codigos!A3', 'EPS')
                    ->setCellValue('codigos!A4', 'CODIGO')
                    ->setCellValue('codigos!B4', 'NOMBRE');

        $objPHPExcel->getActiveSheet()->getColumnDimension('A')->setAutoSize(true);                 $objPHPExcel->getActiveSheet()->getColumnDimension('B')->setAutoSize(true);

        $i = 5;
        $conex  = $clase->Conectar();
        $result = mysql_query($vsql,$conex);
        $cant   = mysql_num_rows($result);
        while($row = mysql_fetch_array($result))
        {
            $objPHPExcel->setActiveSheetIndex(0)
                        ->setCellValue('codigos!A'.$i, $row['epsid'])
                        ->setCellValue('codigos!B'.$i, $row['descripcioneps']);
            $i++;
        }

        $rangoEncabezado = 'codigos!A4:codigos!B4';
        $rangoCeldas     = 'codigos!A4:codigos!B'.($i-1);

        // ----------------------------------------------------------------------------------------------------------------------------------------------------------- //
        // Fondo de pensiones
        $vsql = "SELECT pensionesid, descripcionafp FROM pensiones";
        $j = $i + 2;

        $celda1="codigos!A".strval($j);
        $celda2="codigos!B".strval($j);
        $celda3="codigos!A".strval($j-1);

        $objPHPExcel->setActiveSheetIndex(0)
                    ->setCellValue($celda3, 'FONDOS DE PENSIONES')
                    ->setCellValue($celda1, 'CODIGO')
                    ->setCellValue($celda2, 'NOMBRE');

        $j++;

        $conex  = $clase->Conectar();
        $result = mysql_query($vsql,$conex);
        while($row = mysql_fetch_array($result))
        {
            $objPHPExcel->setActiveSheetIndex(0)
                        ->setCellValue('codigos!A'.$j, $row['pensionesid'])
                        ->setCellValue('codigos!B'.$j, $row['descripcionafp']);
            $j++;
        }

        $rangoEncabezado = 'codigos!A4:codigos!B4';
        $rangoCeldas     = 'codigos!A4:B'.($j-1);

        // ----------------------------------------------------------------------------------------------------------------------------------------------------------- //
        // Cesantías
        $vsql = "SELECT cesantiasid, descripcion FROM cesantias";

        $k = $j + 2;

        $celda1="codigos!A".strval($k);
        $celda2="codigos!B".strval($k);
        $celda3="codigos!A".strval($k-1);

        $objPHPExcel->setActiveSheetIndex(0)
                    ->setCellValue($celda3, 'CESANTIAS')
                    ->setCellValue($celda1, 'CODIGO')
                    ->setCellValue($celda2, 'NOMBRE');
        
        $k++;
        $conex  = $clase->Conectar();
        $result = mysql_query($vsql,$conex);
        while($row = mysql_fetch_array($result))
        {
            $objPHPExcel->setActiveSheetIndex(0)
                        ->setCellValue('codigos!A'.$k, $row['cesantiasid'])
                        ->setCellValue('codigos!B'.$k, $row['descripcion']);
            $k++;
        }

        $rangoEncabezado3 = $celda1.':'.$celda2;
        $rangoCeldas3     = $celda1.($k-1);

        // ----------------------------------------------------------------------------------------------------------------------------------------------------------- //
        // cajas de compenzación
        $vsql = "SELECT idcajacomp, nombrecaja FROM cajascompensacion";

        $l = $k + 2;

        $celda1="codigos!A".strval($l);
        $celda2="codigos!B".strval($l);
        $celda3="codigos!A".strval($l-1);

        $objPHPExcel->setActiveSheetIndex(0)
                    ->setCellValue($celda3, 'CAJAS COMPENSACION')
                    ->setCellValue($celda1, 'CODIGO')
                    ->setCellValue($celda2, 'NOMBRE');

        $l++;
        $conex  = $clase->Conectar();
        $result = mysql_query($vsql,$conex);
        while($row = mysql_fetch_array($result))
        {
            $objPHPExcel->setActiveSheetIndex(0)
                        ->setCellValue('codigos!A'.$l, $row['idcajacomp'])
                        ->setCellValue('codigos!B'.$l, $row['nombrecaja']);
            $l++;
        }

        // ----------------------------------------------------------------------------------------------------------------------------------------------------------- //
        // áreas de nómina
        $vsql = "SELECT areaid, descripcionarea FROM areanomina";

        $m = $l + 2;

        $celda1="codigos!A".strval($m);
        $celda2="codigos!B".strval($m);
        $celda3="codigos!A".strval($m-1);

        $objPHPExcel->setActiveSheetIndex(0)
                    ->setCellValue($celda3, 'AREAS')
                    ->setCellValue($celda1, 'CODIGO')
                    ->setCellValue($celda2, 'NOMBRE');

        $m++;
        $conex  = $clase->Conectar();
        $result = mysql_query($vsql,$conex);
        while($row = mysql_fetch_array($result))
        {
            $objPHPExcel->setActiveSheetIndex(0)
                        ->setCellValue('codigos!A'.$m, $row['areaid'])
                        ->setCellValue('codigos!B'.$m, $row['descripcionarea']);
            $m++;
        }

        // ----------------------------------------------------------------------------------------------------------------------------------------------------------- //
        // secciones de nómina
        $vsql = "SELECT seccionid, descripcionsec FROM seccion";

        $n = $m + 2;

        $celda1="codigos!A".strval($n);
        $celda2="codigos!B".strval($n);
        $celda3="codigos!A".strval($n-1);

        $objPHPExcel->setActiveSheetIndex(0)
                    ->setCellValue($celda3, 'SECCIONES')
                    ->setCellValue($celda1, 'CODIGO')
                    ->setCellValue($celda2, 'NOMBRE');

        $n++;
        $conex  = $clase->Conectar();
        $result = mysql_query($vsql,$conex);
        while($row = mysql_fetch_array($result))
        {
            $objPHPExcel->setActiveSheetIndex(0)
                        ->setCellValue('codigos!A'.$n, $row['seccionid'])
                        ->setCellValue('codigos!B'.$n, $row['descripcionsec']);
            $n++;
        }

        $rangoEncabezado3 = $celda1.':'.$celda2;
        $rangoCeldas3     = $celda1.($n-1);

        // ----------------------------------------------------------------------------------------------------------------------------------------------------------- //
        // cargos
        $vsql = "SELECT cargoid, descripcioncargo FROM cargos";

        $o = $n + 2;

        $celda1="codigos!A".strval($o);
        $celda2="codigos!B".strval($o);
        $celda3="codigos!A".strval($o-1);        

        $objPHPExcel->setActiveSheetIndex(0)
                    ->setCellValue($celda3, 'CARGOS')
                    ->setCellValue($celda1, 'CODIGO')
                    ->setCellValue($celda2, 'NOMBRE');

        $o++;
        $conex  = $clase->Conectar();
        $result = mysql_query($vsql,$conex);
        while($row = mysql_fetch_array($result))
        {
            $objPHPExcel->setActiveSheetIndex(0)
                        ->setCellValue('codigos!A'.$o, $row['cargoid'])
                        ->setCellValue('codigos!B'.$o, $row['descripcioncargo']);
            $o++;
        }

        $rangoEncabezado3 = $celda1.':'.$celda2;
        $rangoCeldas3     = $celda1.($o-1);

        // ----------------------------------------------------------------------------------------------------------------------------------------------------------- //
        // Bancos
        $vsql = "SELECT bancoid, descripcion FROM bancos";

        $p = $o + 2;

        $celda1="codigos!A".strval($p);
        $celda2="codigos!B".strval($p);
        $celda3="codigos!A".strval($p-1);           

        $objPHPExcel->setActiveSheetIndex(0)
                    ->setCellValue($celda3, 'BANCOS')
                    ->setCellValue($celda1, 'CODIGO')
                    ->setCellValue($celda2, 'NOMBRE');

        $p++;
        $conex  = $clase->Conectar();
        $result = mysql_query($vsql,$conex);
        while($row = mysql_fetch_array($result))
        {
            $objPHPExcel->setActiveSheetIndex(0)
                        ->setCellValue('codigos!A'.$p, $row['bancoid'])
                        ->setCellValue('codigos!B'.$p, $row['descripcion']);
            $p++;
        }

        $rangoEncabezado3 = $celda1.':'.$celda2;
        $rangoCeldas3     = $celda1.($p-1);

        // ----------------------------------------------------------------------------------------------------------------------------------------------------------- //
        // Tipos de documentos
        $vsql = "SELECT codigo, descripcion FROM tipodocumento";

        $q = $p + 2;

        $celda1="codigos!A".strval($q);
        $celda2="codigos!B".strval($q);
        $celda3="codigos!A".strval($q-1);           

        $objPHPExcel->setActiveSheetIndex(0)
                    ->setCellValue($celda3, 'TIPOS DE DOCUMENTO')
                    ->setCellValue($celda1, 'CODIGO')
                    ->setCellValue($celda2, 'NOMBRE');

        $q++;
        $conex  = $clase->Conectar();
        $result = mysql_query($vsql,$conex);
        while($row = mysql_fetch_array($result))
        {
            $objPHPExcel->setActiveSheetIndex(0)
                        ->setCellValue('codigos!A'.$q, $row['codigo'])
                        ->setCellValue('codigos!B'.$q, $row['descripcion']);
            $q++;
        }

        $rangoEncabezado3 = $celda1.':'.$celda2;
        $rangoCeldas3     = $celda1.($q-1);

        // ----------------------------------------------------------------------------------------------------------------------------------------------------------- //        
        // Formato de Encabezado y Celdas
        $objPHPExcel->getActiveSheet()->getRowDimension('1')->setRowHeight(15);
        
        $EstiloCeldas = array(
        'borders' => array(
            'allborders' => array(
                'style' => PHPExcel_Style_Border::BORDER_THIN,
                'color' => array('argb' => '00000000'),
            ),
            ),
        );        
        /// Formato de Encabezados 
        $EstiloEncabezado = array(
        'font' => array(
            'bold' => true,
        ),
        'alignment' => array(
            'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,
            'vertical' => PHPExcel_Style_Alignment::VERTICAL_CENTER,		
        ),
        'borders' => array(
            'allborders' => array(
                'style' => PHPExcel_Style_Border::BORDER_THIN,
                'color' => array('argb' => '00000000'),
            ),
        ),
        'fill' => array(
            'type' => PHPExcel_Style_Fill::FILL_SOLID,
            'rotation' => 90,
            'startcolor' => array(
                'argb' => '00FFFFCC',
            ),
            'endcolor' => array(
                'argb' => 'FFFFFF',
            ),
            ),
        );
        // --------------------------------------------------------------------------------------------------------------------------------------------------- //
        // Redirect output to a client’s web browser (Excel5)
        header('Content-Type: application/vnd.ms-excel');
        // --------------------------------------------------------------------- //
        $nombrearcexcel = "ficha terceros.xls";
        header('Content-Disposition: attachment;filename='.$nombrearcexcel.'');
        // --------------------------------------------------------------------- //
        header('Cache-Control: max-age=0');
        /// Genero la Salida
        $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');
        $objWriter->save('php://output');
        exit;
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: codigosxls
    // Creación: 29/06/2023		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que genera la hoja de Excel con los códigos necesarios para la 
    //              actualización de los datos de la tabla terceros
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "codigosxls")
    {
        require_once 'lib/PHPExcel.php';
        $clase = new Sistema();
        $clase->Conectar();
        ini_set("memory_limit","100M");
        
        // consulta para las eps
        $vsql = "SELECT epsid, descripcioneps FROM eps";

        // Preparación del entorno para la salida a Excel
        $clase = new Sistema();
        $clase->Nombredb = $_SESSION['DBNOMBRE'];
        error_reporting(E_ALL);
        ini_set('display_errors', TRUE);
        ini_set('display_startup_errors', TRUE);
        date_default_timezone_set('Europe/London');
    
        if (PHP_SAPI == 'cli')
            die('This example should only be run from a Web Browser');
    
        // Create new PHPExcel object
        $objPHPExcel = new PHPExcel();
    
        // Set document properties
        $objPHPExcel->getProperties()->setCreator("Sistemas y Soluciones Web de Colombia")
                                     ->setLastModifiedBy("Sistemas y Soluciones Web de Colombia")
                                     ->setTitle("codigos terceros - DROPOS")
                                     ->setSubject("codigos terceros - DROPOS")
                                     ->setDescription("codigos terceros - DROPOS")
                                     ->setKeywords("codigos terceros - DROPOS")
                                     ->setCategory("Categoria General");

        $objPHPExcel->setActiveSheetIndex(0)
                    ->setCellValue('A1', 'CODIGOS TERCEROS')
                    ->setCellValue('A3', 'EPS')
                    ->setCellValue('A4', 'CODIGO')
                    ->setCellValue('B4', 'NOMBRE');

        $objPHPExcel->getActiveSheet()->getColumnDimension('A')->setAutoSize(true);                 $objPHPExcel->getActiveSheet()->getColumnDimension('B')->setAutoSize(true);

        $i = 5;
        $conex  = $clase->Conectar();
        $result = mysql_query($vsql,$conex);
        $cant   = mysql_num_rows($result);
        while($row = mysql_fetch_array($result))
        {
            $objPHPExcel->setActiveSheetIndex(0)
                        ->setCellValue('A'.$i, $row['epsid'])
                        ->setCellValue('B'.$i, $row['descripcioneps']);
            $i++;
        }

        $rangoEncabezado = 'A4:B4';
        $rangoCeldas     = 'A4:B'.($i-1);

        // ----------------------------------------------------------------------------------------------------------------------------------------------------------- //
        // Fondo de pensiones
        $vsql = "SELECT pensionesid, descripcionafp FROM pensiones";
        $j = $i + 2;

        $celda1="A".strval($j);
        $celda2="B".strval($j);
        $celda3="A".strval($j-1);

        $objPHPExcel->setActiveSheetIndex(0)
                    ->setCellValue($celda3, 'FONDOS DE PENSIONES')
                    ->setCellValue($celda1, 'CODIGO')
                    ->setCellValue($celda2, 'NOMBRE');

        $j++;

        $conex  = $clase->Conectar();
        $result = mysql_query($vsql,$conex);
        while($row = mysql_fetch_array($result))
        {
            $objPHPExcel->setActiveSheetIndex(0)
                        ->setCellValue('A'.$j, $row['pensionesid'])
                        ->setCellValue('B'.$j, $row['descripcionafp']);
            $j++;
        }

        $rangoEncabezado = 'A4:B4';
        $rangoCeldas     = 'A4:B'.($j-1);

        // ----------------------------------------------------------------------------------------------------------------------------------------------------------- //
        // Cesantías
        $vsql = "SELECT cesantiasid, descripcion FROM cesantias";

        $k = $j + 2;

        $celda1="A".strval($k);
        $celda2="B".strval($k);
        $celda3="A".strval($k-1);

        $objPHPExcel->setActiveSheetIndex(0)
                    ->setCellValue($celda3, 'CESANTIAS')
                    ->setCellValue($celda1, 'CODIGO')
                    ->setCellValue($celda2, 'NOMBRE');
        
        $k++;
        $conex  = $clase->Conectar();
        $result = mysql_query($vsql,$conex);
        while($row = mysql_fetch_array($result))
        {
            $objPHPExcel->setActiveSheetIndex(0)
                        ->setCellValue('A'.$k, $row['cesantiasid'])
                        ->setCellValue('B'.$k, $row['descripcion']);
            $k++;
        }

        $rangoEncabezado3 = $celda1.':'.$celda2;
        $rangoCeldas3     = $celda1.($k-1);

        // ----------------------------------------------------------------------------------------------------------------------------------------------------------- //
        // cajas de compenzación
        $vsql = "SELECT idcajacomp, nombrecaja FROM cajascompensacion";

        $l = $k + 2;

        $celda1="A".strval($l);
        $celda2="B".strval($l);
        $celda3="A".strval($l-1);

        $objPHPExcel->setActiveSheetIndex(0)
                    ->setCellValue($celda3, 'CAJAS COMPENSACION')
                    ->setCellValue($celda1, 'CODIGO')
                    ->setCellValue($celda2, 'NOMBRE');

        $l++;
        $conex  = $clase->Conectar();
        $result = mysql_query($vsql,$conex);
        while($row = mysql_fetch_array($result))
        {
            $objPHPExcel->setActiveSheetIndex(0)
                        ->setCellValue('A'.$l, $row['idcajacomp'])
                        ->setCellValue('B'.$l, $row['nombrecaja']);
            $l++;
        }

        // ----------------------------------------------------------------------------------------------------------------------------------------------------------- //
        // áreas de nómina
        $vsql = "SELECT areaid, descripcionarea FROM areanomina";

        $m = $l + 2;

        $celda1="A".strval($m);
        $celda2="B".strval($m);
        $celda3="A".strval($m-1);

        $objPHPExcel->setActiveSheetIndex(0)
                    ->setCellValue($celda3, 'AREAS')
                    ->setCellValue($celda1, 'CODIGO')
                    ->setCellValue($celda2, 'NOMBRE');

        $m++;
        $conex  = $clase->Conectar();
        $result = mysql_query($vsql,$conex);
        while($row = mysql_fetch_array($result))
        {
            $objPHPExcel->setActiveSheetIndex(0)
                        ->setCellValue('A'.$m, $row['areaid'])
                        ->setCellValue('B'.$m, $row['descripcionarea']);
            $m++;
        }

        // ----------------------------------------------------------------------------------------------------------------------------------------------------------- //
        // secciones de nómina
        $vsql = "SELECT seccionid, descripcionsec FROM seccion";

        $n = $m + 2;

        $celda1="A".strval($n);
        $celda2="B".strval($n);
        $celda3="A".strval($n-1);

        $objPHPExcel->setActiveSheetIndex(0)
                    ->setCellValue($celda3, 'SECCIONES')
                    ->setCellValue($celda1, 'CODIGO')
                    ->setCellValue($celda2, 'NOMBRE');

        $n++;
        $conex  = $clase->Conectar();
        $result = mysql_query($vsql,$conex);
        while($row = mysql_fetch_array($result))
        {
            $objPHPExcel->setActiveSheetIndex(0)
                        ->setCellValue('A'.$n, $row['seccionid'])
                        ->setCellValue('B'.$n, $row['descripcionsec']);
            $n++;
        }

        $rangoEncabezado3 = $celda1.':'.$celda2;
        $rangoCeldas3     = $celda1.($n-1);

        // ----------------------------------------------------------------------------------------------------------------------------------------------------------- //
        // cargos
        $vsql = "SELECT cargoid, descripcioncargo FROM cargos";

        $o = $n + 2;

        $celda1="A".strval($o);
        $celda2="B".strval($o);
        $celda3="A".strval($o-1);        

        $objPHPExcel->setActiveSheetIndex(0)
                    ->setCellValue($celda3, 'CARGOS')
                    ->setCellValue($celda1, 'CODIGO')
                    ->setCellValue($celda2, 'NOMBRE');

        $o++;
        $conex  = $clase->Conectar();
        $result = mysql_query($vsql,$conex);
        while($row = mysql_fetch_array($result))
        {
            $objPHPExcel->setActiveSheetIndex(0)
                        ->setCellValue('A'.$o, $row['cargoid'])
                        ->setCellValue('B'.$o, $row['descripcioncargo']);
            $o++;
        }

        $rangoEncabezado3 = $celda1.':'.$celda2;
        $rangoCeldas3     = $celda1.($o-1);

        // ----------------------------------------------------------------------------------------------------------------------------------------------------------- //
        // Bancos
        $vsql = "SELECT bancoid, descripcion FROM bancos";

        $p = $o + 2;

        $celda1="A".strval($p);
        $celda2="B".strval($p);
        $celda3="A".strval($p-1);           

        $objPHPExcel->setActiveSheetIndex(0)
                    ->setCellValue($celda3, 'BANCOS')
                    ->setCellValue($celda1, 'CODIGO')
                    ->setCellValue($celda2, 'NOMBRE');

        $p++;
        $conex  = $clase->Conectar();
        $result = mysql_query($vsql,$conex);
        while($row = mysql_fetch_array($result))
        {
            $objPHPExcel->setActiveSheetIndex(0)
                        ->setCellValue('A'.$p, $row['bancoid'])
                        ->setCellValue('B'.$p, $row['descripcion']);
            $p++;
        }

        $rangoEncabezado3 = $celda1.':'.$celda2;
        $rangoCeldas3     = $celda1.($p-1);

        // ----------------------------------------------------------------------------------------------------------------------------------------------------------- //        
        // Formato de Encabezado y Celdas
        $objPHPExcel->getActiveSheet()->getRowDimension('1')->setRowHeight(15);
        
        $EstiloCeldas = array(
        'borders' => array(
            'allborders' => array(
                'style' => PHPExcel_Style_Border::BORDER_THIN,
                'color' => array('argb' => '00000000'),
            ),
            ),
        );        
        /// Formato de Encabezados 
        $EstiloEncabezado = array(
        'font' => array(
            'bold' => true,
        ),
        'alignment' => array(
            'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,
            'vertical' => PHPExcel_Style_Alignment::VERTICAL_CENTER,		
        ),
        'borders' => array(
            'allborders' => array(
                'style' => PHPExcel_Style_Border::BORDER_THIN,
                'color' => array('argb' => '00000000'),
            ),
        ),
        'fill' => array(
            'type' => PHPExcel_Style_Fill::FILL_SOLID,
            'rotation' => 90,
            'startcolor' => array(
                'argb' => '00FFFFCC',
            ),
            'endcolor' => array(
                'argb' => 'FFFFFF',
            ),
            ),
        );        
        // Rename worksheet
        $objPHPExcel->getActiveSheet()->setTitle('codigos terceros');
        // Set active sheet index to the first sheet, so Excel opens this as the first sheet
        $objPHPExcel->setActiveSheetIndex(0);
        // Redirect output to a client’s web browser (Excel5)
        header('Content-Type: application/vnd.ms-excel');
        // --------------------------------------------------------------------- //
        // header('Content-Disposition: attachment;filename="planillanom.xls"');
        $nombrearcexcel = "codigos terceros.xls";
        header('Content-Disposition: attachment;filename='.$nombrearcexcel.'');
        // --------------------------------------------------------------------- //
        header('Cache-Control: max-age=0');
        /// Genero la Salida
        $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');
        $objWriter->save('php://output');
        exit;
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: codigospdf
    // Creación: 29/06/2023		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que genera un informe con los códigos necesarios para la 
    //              actualización de los datos de la tabla terceros en formato pdf
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "codigospdf")
    {
        // Traducción al español del mes que devuelve la función date()
        $mesimp = date('F');
        if($mesimp=="January")       $mesimp = "Enero";
        if($mesimp=="February")      $mesimp = "Febrero";
        if($mesimp=="March")         $mesimp = "Marzo";
        if($mesimp=="April")         $mesimp = "Abril";
        if($mesimp=="May")           $mesimp = "Mayo";
        if($mesimp=="June")          $mesimp = "Junio";
        if($mesimp=="July")          $mesimp = "Julio";
        if($mesimp=="August")        $mesimp = "Agosto";
        if($mesimp=="September")     $mesimp = "Septiembre";
        if($mesimp=="October")       $mesimp = "Octubre";
        if($mesimp=="November")      $mesimp = "Noviembre";
        if($mesimp=="December")      $mesimp = "Diciembre";
  
        // Procedo a construir el encabezado del recibo
        ini_set("memory_limit","200M");
        require('lib/fpdf/fpdf.php');
        $pdf=new FPDF();
        
        // Página nueva
        $pdf->AddPage("");
        $pagina = 1;

        // Logo Dromedicas
        $pdf->Image('images/empresa/logo-dromedicas-en-azul.png',10,10,12,15,'PNG','');

        // Imprimo el encabezado del informe
        $x = 25;
        $y = 13;
        $pdf->SetFont('Arial','B',10);
        $enc= "DROMEDICAS DEL ORIENTE SAS - NIT: 900265730-0";
        $pdf->Text($x,$y,$enc);

        // Fecha y hora de impresión
        $fechoraimp = $mesimp." ".date('d')." de ".date('Y g:i a')."    Pagina: ".$pagina;

        $pdf->SetFont('Arial','',8);
        $pdf->Text($x+124,$y,$fechoraimp);

        $pdf->SetFont('Arial','B',10);
        $enc= "CODIGOS TERCEROS";               $pdf->Text($x,$y+5,$enc);

        // ------------------------------------------------------------------------------------------------------------------------------------- //
        // eps
        $enc= "EPS";                         $pdf->Text($x-17,$y+20,$enc);
        $enc= "CODIGO";                      $pdf->Text($x-17,$y+26,$enc);
        $enc= "NOMBRE";                      $pdf->Text($x+5,$y+26,$enc);

        $vsql = "SELECT epsid, descripcioneps FROM eps";

        $conex  = $clase->Conectar();
        $result = mysql_query($vsql,$conex);
        $x = 8;
        $y = 41;
        $i = 0;
        $linea = 0;
        while($row = mysql_fetch_array($result))
        {
            $i++;
            if($i%56==0)
            {
                $pdf->AddPage("");
                $pagina++;

                // Logo Dromedicas
                $pdf->Image('images/empresa/logo-dromedicas-en-azul.png',10,10,12,15,'PNG','');

                // Imprimo el encabezado del informe
                $x = 25;
                $y = 13;
                $pdf->SetFont('Arial','B',10);
                $enc= "DROMEDICAS DEL ORIENTE SAS - NIT: 900265730-0";
                $pdf->Text($x,$y,$enc);

                // Fecha y hora de impresión
                $fechoraimp = $mesimp." ".date('d')." de ".date('Y g:i a')."    Pagina: ".$pagina;

                $pdf->SetFont('Arial','',8);
                $pdf->Text($x+124,$y,$fechoraimp);

                $pdf->SetFont('Arial','B',10);
                $enc= "CODIGOS TERCEROS";               $pdf->Text($x,$y+5,$enc);

                $enc= "EPS";                         $pdf->Text($x-17,$y+20,$enc);
                $enc= "CODIGO";                      $pdf->Text($x-17,$y+26,$enc);
                $enc= "NOMBRE";                      $pdf->Text($x+5,$y+26,$enc);

                $x = 8;
                $y = 41;
            }
            $linea++;

            $pdf->SetFont('Arial','',8);
            $pdf->Text($x,$y+3,$row['epsid']);
            $pdf->Text($x+22,$y+3,$row['descripcioneps']);

            $y+=4;
        }        

        // ----------------------------------------------------------------------------------------------------------------------------------------------------------- //        
        // Fondo de pensiones
        $y+=10;
        $x = 25;

        if($y > 270)
        {
            $pdf->AddPage("");
            $pagina++;

            // Logo Dromedicas
            $pdf->Image('images/empresa/logo-dromedicas-en-azul.png',10,10,12,15,'PNG','');

            // Imprimo el encabezado del informe
            $x = 25;
            $y = 13;
            $pdf->SetFont('Arial','B',10);
            $enc= "DROMEDICAS DEL ORIENTE SAS - NIT: 900265730-0";
            $pdf->Text($x,$y,$enc);

            // Fecha y hora de impresión
            $fechoraimp = $mesimp." ".date('d')." de ".date('Y g:i a')."    Pagina: ".$pagina;

            $pdf->SetFont('Arial','',8);
            $pdf->Text($x+124,$y,$fechoraimp);

            $pdf->SetFont('Arial','B',10);
            $enc= "CODIGOS TERCEROS";               $pdf->Text($x,$y+5,$enc);

            $x = 25;
            $y = 30;
            $i = 0;
        }        

        $pdf->SetFont('Arial','B',10);
        $enc= "FONDOS DE PENSIONES";         $pdf->Text($x-17,$y,$enc);
        $enc= "CODIGO";                      $pdf->Text($x-17,$y+5,$enc);
        $enc= "NOMBRE";                      $pdf->Text($x+5,$y+5,$enc);

        $linea = 0;
        $y+=6;
        $x = 8;

        $vsql = "SELECT pensionesid, descripcionafp FROM pensiones";
        $conex  = $clase->Conectar();
        $result = mysql_query($vsql,$conex);
        while($row = mysql_fetch_array($result))
        {
            $i++;
            if($i%56==0)
            {
                $pdf->AddPage("");
                $pagina++;

                // Logo Dromedicas
                $pdf->Image('images/empresa/logo-dromedicas-en-azul.png',10,10,12,15,'PNG','');

                // Imprimo el encabezado del informe
                $x = 25;
                $y = 13;
                $pdf->SetFont('Arial','B',10);
                $enc= "DROMEDICAS DEL ORIENTE SAS - NIT: 900265730-0";
                $pdf->Text($x,$y,$enc);

                // Fecha y hora de impresión
                $fechoraimp = $mesimp." ".date('d')." de ".date('Y g:i a')."    Pagina: ".$pagina;

                $pdf->SetFont('Arial','',8);
                $pdf->Text($x+124,$y,$fechoraimp);

                $pdf->SetFont('Arial','B',10);
                $enc= "CODIGOS TERCEROS";               $pdf->Text($x,$y+5,$enc);

                $pdf->SetFont('Arial','B',10);
                $enc= "FONDOS DE PENSIONES";         $pdf->Text($x-17,$y,$enc);
                $enc= "CODIGO";                      $pdf->Text($x-17,$y+5,$enc);
                $enc= "NOMBRE";                      $pdf->Text($x+5,$y+5,$enc);

                $x = 8;
                $y = 41;
            }
            $linea++;

            $pdf->SetFont('Arial','',8);
            $pdf->Text($x,$y+3,$row['pensionesid']);
            $pdf->Text($x+22,$y+3,$row['descripcionafp']);

            $y+=4;
        }

        // ----------------------------------------------------------------------------------------------------------------------------------------------------------- //
        // Cesantías
        $y+=10;
        $x = 25;

        if($y > 270)
        {
            $pdf->AddPage("");
            $pagina++;

            // Logo Dromedicas
            $pdf->Image('images/empresa/logo-dromedicas-en-azul.png',10,10,12,15,'PNG','');

            // Imprimo el encabezado del informe
            $x = 25;
            $y = 13;
            $pdf->SetFont('Arial','B',10);
            $enc= "DROMEDICAS DEL ORIENTE SAS - NIT: 900265730-0";
            $pdf->Text($x,$y,$enc);

            // Fecha y hora de impresión
            $fechoraimp = $mesimp." ".date('d')." de ".date('Y g:i a')."    Pagina: ".$pagina;

            $pdf->SetFont('Arial','',8);
            $pdf->Text($x+124,$y,$fechoraimp);

            $pdf->SetFont('Arial','B',10);
            $enc= "CODIGOS TERCEROS";               $pdf->Text($x,$y+5,$enc);

            $x = 25;
            $y = 30;
            $i = 0;
        }        

        $pdf->SetFont('Arial','B',10);
        $enc= "CESANTIAS";                   $pdf->Text($x-17,$y,$enc);
        $enc= "CODIGO";                      $pdf->Text($x-17,$y+5,$enc);
        $enc= "NOMBRE";                      $pdf->Text($x+5,$y+5,$enc);

        $linea = 0;
        $y+=6;
        $x = 8;

        $vsql = "SELECT cesantiasid, descripcion FROM cesantias";
        $conex  = $clase->Conectar();
        $result = mysql_query($vsql,$conex);
        while($row = mysql_fetch_array($result))
        {
            $i++;
            if($i%56==0)
            {
                $pdf->AddPage("");
                $pagina++;

                // Logo Dromedicas
                $pdf->Image('images/empresa/logo-dromedicas-en-azul.png',10,10,12,15,'PNG','');

                // Imprimo el encabezado del informe
                $x = 25;
                $y = 13;
                $pdf->SetFont('Arial','B',10);
                $enc= "DROMEDICAS DEL ORIENTE SAS - NIT: 900265730-0";
                $pdf->Text($x,$y,$enc);

                // Fecha y hora de impresión
                $fechoraimp = $mesimp." ".date('d')." de ".date('Y g:i a')."    Pagina: ".$pagina;

                $pdf->SetFont('Arial','',8);
                $pdf->Text($x+124,$y,$fechoraimp);

                $pdf->SetFont('Arial','B',10);
                $enc= "CODIGOS TERCEROS";               $pdf->Text($x,$y+5,$enc);

                $pdf->SetFont('Arial','B',10);
                $enc= "CESANTIAS";                      $pdf->Text($x-17,$y,$enc);
                $enc= "CODIGO";                         $pdf->Text($x-17,$y+5,$enc);
                $enc= "NOMBRE";                         $pdf->Text($x+5,$y+5,$enc);

                $x = 8;
                $y = 41;
            }
            $linea++;

            $pdf->SetFont('Arial','',8);
            $pdf->Text($x,$y+3,$row['cesantiasid']);
            $pdf->Text($x+22,$y+3,$row['descripcion']);

            $y+=4;            
        }

        // ----------------------------------------------------------------------------------------------------------------------------------------------------------- //
        // cajas de compenzación
        $y+=10;        
        $x = 25;

        if($y > 270)
        {
            $pdf->AddPage("");
            $pagina++;

            // Logo Dromedicas
            $pdf->Image('images/empresa/logo-dromedicas-en-azul.png',10,10,12,15,'PNG','');

            // Imprimo el encabezado del informe
            $x = 25;
            $y = 13;
            $pdf->SetFont('Arial','B',10);
            $enc= "DROMEDICAS DEL ORIENTE SAS - NIT: 900265730-0";
            $pdf->Text($x,$y,$enc);

            // Fecha y hora de impresión
            $fechoraimp = $mesimp." ".date('d')." de ".date('Y g:i a')."    Pagina: ".$pagina;

            $pdf->SetFont('Arial','',8);
            $pdf->Text($x+124,$y,$fechoraimp);

            $pdf->SetFont('Arial','B',10);
            $enc= "CODIGOS TERCEROS";               $pdf->Text($x,$y+5,$enc);

            $x = 25;
            $y = 30;
            $i = 0;
        }

        $pdf->SetFont('Arial','B',10);
        $enc= "CAJAS COMPENSACION";          $pdf->Text($x-17,$y,$enc);
        $enc= "CODIGO";                      $pdf->Text($x-17,$y+5,$enc);
        $enc= "NOMBRE";                      $pdf->Text($x+5,$y+5,$enc);        

        $linea = 0;
        $y+=6;
        $x = 8;

        $vsql = "SELECT idcajacomp, nombrecaja FROM cajascompensacion";
        $conex  = $clase->Conectar();
        $result = mysql_query($vsql,$conex);
        while($row = mysql_fetch_array($result))
        {
            $i++;
            if($i%56==0)
            {
                $pdf->AddPage("");
                $pagina++;

                // Logo Dromedicas
                $pdf->Image('images/empresa/logo-dromedicas-en-azul.png',10,10,12,15,'PNG','');

                // Imprimo el encabezado del informe
                $x = 25;
                $y = 13;
                $pdf->SetFont('Arial','B',10);
                $enc= "DROMEDICAS DEL ORIENTE SAS - NIT: 900265730-0";
                $pdf->Text($x,$y,$enc);

                // Fecha y hora de impresión
                $fechoraimp = $mesimp." ".date('d')." de ".date('Y g:i a')."    Pagina: ".$pagina;

                $pdf->SetFont('Arial','',8);
                $pdf->Text($x+124,$y,$fechoraimp);

                $pdf->SetFont('Arial','B',10);
                $enc= "CODIGOS TERCEROS";               $pdf->Text($x,$y+5,$enc);

                $x = 25;
                $y = 30;

                $pdf->SetFont('Arial','B',10);
                $enc= "CAJAS COMPENSACION";         $pdf->Text($x-17,$y,$enc);
                $enc= "CODIGO";                      $pdf->Text($x-17,$y+5,$enc);
                $enc= "NOMBRE";                      $pdf->Text($x+5,$y+5,$enc);

                $x = 8;
                $y = 13;
            }
            $linea++;

            $pdf->SetFont('Arial','',8);
            $pdf->Text($x,$y+3,$row['idcajacomp']);
            $pdf->Text($x+22,$y+3,$row['nombrecaja']);

            $y+=4;
        }

        // ----------------------------------------------------------------------------------------------------------------------------------------------------------- //
        // áreas de nómina
        $y+=10;
        $x = 25;

        if($y > 270)
        {
            $pdf->AddPage("");
            $pagina++;

            // Logo Dromedicas
            $pdf->Image('images/empresa/logo-dromedicas-en-azul.png',10,10,12,15,'PNG','');

            // Imprimo el encabezado del informe
            $x = 25;
            $y = 13;
            $pdf->SetFont('Arial','B',10);
            $enc= "DROMEDICAS DEL ORIENTE SAS - NIT: 900265730-0";
            $pdf->Text($x,$y,$enc);

            // Fecha y hora de impresión
            $fechoraimp = $mesimp." ".date('d')." de ".date('Y g:i a')."    Pagina: ".$pagina;

            $pdf->SetFont('Arial','',8);
            $pdf->Text($x+124,$y,$fechoraimp);

            $pdf->SetFont('Arial','B',10);
            $enc= "CODIGOS TERCEROS";               $pdf->Text($x,$y+5,$enc);

            $x = 25;
            $y = 30;
            $i = 0;
        }        

        $pdf->SetFont('Arial','B',10);
        $enc= "AREAS";                          $pdf->Text($x-17,$y,$enc);
        $enc= "CODIGO";                         $pdf->Text($x-17,$y+5,$enc);
        $enc= "NOMBRE";                         $pdf->Text($x+5,$y+5,$enc);

        $linea = 0;
        $y+=6;
        $x = 8;

        $vsql = "SELECT areaid, descripcionarea FROM areanomina";
        $conex  = $clase->Conectar();
        $result = mysql_query($vsql,$conex);
        while($row = mysql_fetch_array($result))
        {
            $i++;
            if($i%56==0)
            {
                $pdf->AddPage("");
                $pagina++;

                // Logo Dromedicas
                $pdf->Image('images/empresa/logo-dromedicas-en-azul.png',10,10,12,15,'PNG','');

                // Imprimo el encabezado del informe
                $x = 25;
                $y = 13;
                $pdf->SetFont('Arial','B',10);
                $enc= "DROMEDICAS DEL ORIENTE SAS - NIT: 900265730-0";
                $pdf->Text($x,$y,$enc);

                // Fecha y hora de impresión
                $fechoraimp = $mesimp." ".date('d')." de ".date('Y g:i a')."    Pagina: ".$pagina;

                $pdf->SetFont('Arial','',8);
                $pdf->Text($x+124,$y,$fechoraimp);

                $pdf->SetFont('Arial','B',10);
                $enc= "CODIGOS TERCEROS";               $pdf->Text($x,$y+5,$enc);

                $pdf->SetFont('Arial','B',10);
                $enc= "AREAS";                          $pdf->Text($x-17,$y,$enc);
                $enc= "CODIGO";                         $pdf->Text($x-17,$y+5,$enc);
                $enc= "NOMBRE";                         $pdf->Text($x+5,$y+5,$enc);

                $x = 8;
                $y = 41;
            }
            $linea++;

            $pdf->SetFont('Arial','',8);
            $pdf->Text($x,$y+3,$row['areaid']);
            $pdf->Text($x+22,$y+3,$row['descripcionarea']);

            $y+=4;
        }

        // ----------------------------------------------------------------------------------------------------------------------------------------------------------- //
        // secciones de nómina
        $y+=10;
        $x = 25;

        if($y > 270)
        {
            $pdf->AddPage("");
            $pagina++;

            // Logo Dromedicas
            $pdf->Image('images/empresa/logo-dromedicas-en-azul.png',10,10,12,15,'PNG','');

            // Imprimo el encabezado del informe
            $x = 25;
            $y = 13;
            $pdf->SetFont('Arial','B',10);
            $enc= "DROMEDICAS DEL ORIENTE SAS - NIT: 900265730-0";
            $pdf->Text($x,$y,$enc);

            // Fecha y hora de impresión
            $fechoraimp = $mesimp." ".date('d')." de ".date('Y g:i a')."    Pagina: ".$pagina;

            $pdf->SetFont('Arial','',8);
            $pdf->Text($x+124,$y,$fechoraimp);

            $pdf->SetFont('Arial','B',10);
            $enc= "CODIGOS TERCEROS";               $pdf->Text($x,$y+5,$enc);

            $x = 25;
            $y = 30;
            $i = 0;
        }        

        $pdf->SetFont('Arial','B',10);
        $enc= "SECCIONES";                      $pdf->Text($x-17,$y,$enc);
        $enc= "CODIGO";                         $pdf->Text($x-17,$y+5,$enc);
        $enc= "NOMBRE";                         $pdf->Text($x+5,$y+5,$enc);

        $linea = 0;
        $y+=6;
        $x = 8;

        $vsql = "SELECT seccionid, descripcionsec FROM seccion";
        $conex  = $clase->Conectar();
        $result = mysql_query($vsql,$conex);
        while($row = mysql_fetch_array($result))
        {
            $i++;
            if($i%56==0)
            {
                $pdf->AddPage("");
                $pagina++;

                // Logo Dromedicas
                $pdf->Image('images/empresa/logo-dromedicas-en-azul.png',10,10,12,15,'PNG','');

                // Imprimo el encabezado del informe
                $x = 25;
                $y = 13;
                $pdf->SetFont('Arial','B',10);
                $enc= "DROMEDICAS DEL ORIENTE SAS - NIT: 900265730-0";
                $pdf->Text($x,$y,$enc);

                // Fecha y hora de impresión
                $fechoraimp = $mesimp." ".date('d')." de ".date('Y g:i a')."    Pagina: ".$pagina;

                $pdf->SetFont('Arial','',8);
                $pdf->Text($x+124,$y,$fechoraimp);

                $pdf->SetFont('Arial','B',10);
                $enc= "CODIGOS TERCEROS";               $pdf->Text($x,$y+5,$enc);

                $x = 25;
                $y = 30;                

                $pdf->SetFont('Arial','B',10);
                $enc= "SECCIONES";                      $pdf->Text($x-17,$y,$enc);
                $enc= "CODIGO";                         $pdf->Text($x-17,$y+5,$enc);
                $enc= "NOMBRE";                         $pdf->Text($x+5,$y+5,$enc);

                $x = 8;
                $y = 36;
            }
            $linea++;

            $pdf->SetFont('Arial','',8);
            $pdf->Text($x,$y+3,$row['seccionid']);
            $pdf->Text($x+22,$y+3,$row['descripcionsec']);

            $y+=4;            
        }

        // ----------------------------------------------------------------------------------------------------------------------------------------------------------- //
        // cargos
        $y+=10;        
        $x = 25;

        if($y > 270)
        {
            $pdf->AddPage("");
            $pagina++;

            // Logo Dromedicas
            $pdf->Image('images/empresa/logo-dromedicas-en-azul.png',10,10,12,15,'PNG','');

            // Imprimo el encabezado del informe
            $x = 25;
            $y = 13;
            $pdf->SetFont('Arial','B',10);
            $enc= "DROMEDICAS DEL ORIENTE SAS - NIT: 900265730-0";
            $pdf->Text($x,$y,$enc);

            // Fecha y hora de impresión
            $fechoraimp = $mesimp." ".date('d')." de ".date('Y g:i a')."    Pagina: ".$pagina;

            $pdf->SetFont('Arial','',8);
            $pdf->Text($x+124,$y,$fechoraimp);

            $pdf->SetFont('Arial','B',10);
            $enc= "CODIGOS TERCEROS";               $pdf->Text($x,$y+5,$enc);

            $x = 25;
            $y = 30;
            $i = 0;
        }

        $pdf->SetFont('Arial','B',10);
        $enc= "CARGOS";                         $pdf->Text($x-17,$y,$enc);
        $enc= "CODIGO";                         $pdf->Text($x-17,$y+5,$enc);
        $enc= "NOMBRE";                         $pdf->Text($x+5,$y+5,$enc);

        $linea = 0;
        $y+=6;
        $x = 8;

        $vsql = "SELECT cargoid, descripcioncargo FROM cargos";
        $conex  = $clase->Conectar();
        $result = mysql_query($vsql,$conex);
        while($row = mysql_fetch_array($result))
        {
            $i++;
            if($i%56==0)
            {
                $pdf->AddPage("");
                $pagina++;

                // Logo Dromedicas
                $pdf->Image('images/empresa/logo-dromedicas-en-azul.png',10,10,12,15,'PNG','');

                // Imprimo el encabezado del informe
                $x = 25;
                $y = 13;
                $pdf->SetFont('Arial','B',10);
                $enc= "DROMEDICAS DEL ORIENTE SAS - NIT: 900265730-0";
                $pdf->Text($x,$y,$enc);

                // Fecha y hora de impresión
                $fechoraimp = $mesimp." ".date('d')." de ".date('Y g:i a')."    Pagina: ".$pagina;

                $pdf->SetFont('Arial','',8);
                $pdf->Text($x+124,$y,$fechoraimp);

                $pdf->SetFont('Arial','B',10);
                $enc= "CODIGOS TERCEROS";               $pdf->Text($x,$y+5,$enc);

                $x = 25;
                $y = 30;                

                $pdf->SetFont('Arial','B',10);
                $enc= "CARGOS";                             $pdf->Text($x-17,$y,$enc);
                $enc= "CODIGO";                             $pdf->Text($x-17,$y+5,$enc);
                $enc= "NOMBRE";                             $pdf->Text($x+5,$y+5,$enc);

                $x = 8;
                $y = 36;
            }
            $linea++;

            $pdf->SetFont('Arial','',8);
            $pdf->Text($x,$y+3,$row['cargoid']);
            $pdf->Text($x+22,$y+3,$row['descripcioncargo']);

            $y+=4;            
        }

        // ----------------------------------------------------------------------------------------------------------------------------------------------------------- //
        // Bancos
        $y+=10;
        $x = 25;

        if($y > 270)
        {
            $pdf->AddPage("");
            $pagina++;

            // Logo Dromedicas
            $pdf->Image('images/empresa/logo-dromedicas-en-azul.png',10,10,12,15,'PNG','');

            // Imprimo el encabezado del informe
            $x = 25;
            $y = 13;
            $pdf->SetFont('Arial','B',10);
            $enc= "DROMEDICAS DEL ORIENTE SAS - NIT: 900265730-0";
            $pdf->Text($x,$y,$enc);

            // Fecha y hora de impresión
            $fechoraimp = $mesimp." ".date('d')." de ".date('Y g:i a')."    Pagina: ".$pagina;

            $pdf->SetFont('Arial','',8);
            $pdf->Text($x+124,$y,$fechoraimp);

            $pdf->SetFont('Arial','B',10);
            $enc= "CODIGOS TERCEROS";               $pdf->Text($x,$y+5,$enc);

            $x = 25;
            $y = 30;
            $i = 0;
        }        

        $pdf->SetFont('Arial','B',10);
        $enc= "BANCOS";                         $pdf->Text($x-17,$y,$enc);
        $enc= "CODIGO";                         $pdf->Text($x-17,$y+5,$enc);
        $enc= "NOMBRE";                         $pdf->Text($x+5,$y+5,$enc);

        $linea = 0;
        $y+=6;
        $x = 8;

        $vsql = "SELECT bancoid, descripcion FROM bancos";
        $conex  = $clase->Conectar();
        $result = mysql_query($vsql,$conex);
        while($row = mysql_fetch_array($result))
        {
            $i++;
            if($i%56==0)
            {
                $pdf->AddPage("");
                $pagina++;

                // Logo Dromedicas
                $pdf->Image('images/empresa/logo-dromedicas-en-azul.png',10,10,12,15,'PNG','');

                // Imprimo el encabezado del informe
                $x = 25;
                $y = 13;
                $pdf->SetFont('Arial','B',10);
                $enc= "DROMEDICAS DEL ORIENTE SAS - NIT: 900265730-0";
                $pdf->Text($x,$y,$enc);

                // Fecha y hora de impresión
                $fechoraimp = $mesimp." ".date('d')." de ".date('Y g:i a')."    Pagina: ".$pagina;

                $pdf->SetFont('Arial','',8);
                $pdf->Text($x+124,$y,$fechoraimp);

                $pdf->SetFont('Arial','B',10);
                $enc= "CODIGOS TERCEROS";               $pdf->Text($x,$y+5,$enc);

                $x = 25;
                $y = 30;                

                $pdf->SetFont('Arial','B',10);
                $enc= "BANCOS";                         $pdf->Text($x-17,$y,$enc);
                $enc= "CODIGO";                         $pdf->Text($x-17,$y+5,$enc);
                $enc= "NOMBRE";                         $pdf->Text($x+5,$y+5,$enc);

                $x = 8;
                $y = 36;
            }
            $linea++;

            $pdf->SetFont('Arial','',8);
            $pdf->Text($x,$y+3,$row['bancoid']);
            $pdf->Text($x+22,$y+3,$row['descripcion']);

            $y+=4;            
        }

        $pdf->Output();
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: importarterceros
    // Creación: 30/06/2023		última modificación: 18/08/2024
    // Creador: Luis Flórez		modificado por: Luis Flórez
    // Descripción: Opción que pinta la ventana para captar la hoja de Excel con la cual se
    //              actualizarán los datos de los terceros
    // Última modificación: Inclusión del campo tipo de documento
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "importarterceros")
    {
        $cont = '';
        $servidor = $_SERVER['SERVER_NAME'].":".$_SERVER['SERVER_PORT'];

        // Validación del servidor
        if(($servidor!="dromedicas.sytes.net:9996")&&($servidor!="192.168.14.248:9999"))
            $cont.='<table width="400">
                     <tr class="CabezoteTabla"> 
                      <td align="center"> <b>Servidor incorrecto </b></td>
                     </tr> 
                     <tr class="CabezoteTabla"> 
                      <td align="center"> 
                       <font color=red> Este servidor est&aacute; inhabilitado para hacer este <br> 
                       proceso, por favor diríjase al servidor </font><br> 
                       <font color=blue> 192.168.14.248:9999 </font> <br>
                       <font color=red>o al servidor </font> <br> 
                       <font color=blue> dromedicas.sytes.net:9996 </font> <br>
                       <font color=red> para poder ejecutar este proceso </font> <br><br>
                      </td> 
                     </tr>
                     <tr class="TablaDocsPar">
                      <td width="100%" align="center"> 
                       <form name="importa" method="post" action="?opcion=ventactterceros" id="theform" enctype="multipart/form-data">
                        <input type="submit" name="enviar" id="enviarr"  value="aceptar" class="button blue" />
                       </form> 
                      </td>
                     </tr>
                    </table>';
        else
        {
            // pinto la ventana
            $cont.='<script type="text/javascript" src="lib/jquery-2.1.3.min.js"></script>
                    <script>
                     $(function()
                      {
                        $("#enviarr").on("click",function()
                       {
                        $(this).val("Espere por favor ...")
                        .attr("disabled","disabled");
                        $("#theform").submit();
                       });    
                      });
                    </script>';

            // encabezado
            $cont.='<table width="950">
                     <tr class="CabezoteTabla"> 
                      <td align="center"> <label class="Texto13"><strong> Actualizaci&oacute;n de terceros </strong></label></td> 
                     </tr> 
                    </table>
                    <table width="950">
                     <tr class="TablaDocsPar"> 
                      <td width="100%" align="center"> 
                       <form name="importa" method="post" action="?opcion=actualizacionterceros" id="theform" enctype="multipart/form-data">
                       <input type="file" name="excel" /><br><br>
                       <input type="submit" name="enviar" id="enviarr"  value="Importar archivo" class="button blue" />
                       <input type="hidden" value="upload" name="action" /> 
                       </form> 
                      </td> 
                     </tr>
                    </table>';
    
            // Título
            $cont.='<table width="950">
                     <tr class="TablaDocsPar"> 
                      <td width="100%" align="center"> 
                       <label class="Texto13"><strong>La hoja de Excel debe tener la siguiente estructura: </strong></label>
                      </td> 
                     </tr>
                    </table>';

            // estructura de la tabla
            $cont.='<table width="950">
                     <tr class="TablaDocsPar"> 
                      <td align="left"> &nbsp; Columna <b>A</b>: Terid del empleado <b>(no editar)</b> </td> 
                      <td align="left"> &nbsp; Columna <b>B</b>: C&eacute;dula del empleado </td> 
                      <td align="left"> &nbsp; Columna <b>C</b>: Primer nombre </td> 
                     </tr>
                     <tr class="TablaDocsPar"> 
                      <td align="left"> &nbsp; Columna <b>D</b>: Segundo nombre </td> 
                      <td align="left"> &nbsp; Columna <b>E</b>: Primer apellido </td> 
                      <td align="left"> &nbsp; Columna <b>F</b>: Segundo apellido </td> 
                     </tr>
                     <tr class="TablaDocsPar"> 
                      <td align="left"> &nbsp; Columna <b>G</b>: B&aacute;sico </td> 
                      <td align="left"> &nbsp; Columna <b>H</b>: Fecha ingreso </td> 
                      <td align="left"> &nbsp; Columna <b>I</b>: EPS </td> 
                     </tr>
                     <tr class="TablaDocsPar"> 
                      <td align="left"> &nbsp; Columna <b>J</b>: AFP </td> 
                      <td align="left"> &nbsp; Columna <b>K</b>: Cesant&iacute;as </td> 
                      <td align="left"> &nbsp; Columna <b>L</b>: Caja compensaci&oacute;n </td> 
                     </tr>
                     <tr class="TablaDocsPar"> 
                      <td align="left"> &nbsp; Columna <b>M</b>: &Aacute;rea </td> 
                      <td align="left"> &nbsp; Columna <b>N</b>: Secci&oacute;n </td> 
                      <td align="left"> &nbsp; Columna <b>O</b>: Cargo </td> 
                     </tr>
                     <tr class="TablaDocsPar"> 
                      <td align="left"> &nbsp; Columna <b>P</b>: Banco </td> 
                      <td align="left"> &nbsp; Columna <b>Q</b>: N&uacute;mero de cuenta </td> 
                      <td align="left"> &nbsp; Columna <b>R</b>: Empleado activo </td> 
                     </tr>
                     <tr class="TablaDocsPar"> 
                      <td align="left"> &nbsp; Columna <b>S</b>: Extralegal </td> 
                      <td align="left"> &nbsp; Columna <b>T</b>: C&oacute;digo de vendedor </td> 
                      <td align="left"> &nbsp; Columna <b>U</b>: Fecha de retiro (formato aaaa-mm-dd) </td> 
                     </tr>
                     <tr class="TablaDocsPar"> 
                      <td align="left"> &nbsp; Columna <b>V</b>: Tipo de documento </td> 
                      <td align="left"> &nbsp; Columna <b>W</b>: Fecha ingreso a la empresa (formato aaaa-mm-dd) </td> 
                      <td align="left"> &nbsp; &nbsp; </td> 
                     </tr>
                    </table>';
    
            // ejemplo de la hoja
            $cont.='<table width="950">
                     <tr class="TablaDocsPar"> 
                      <td width="100%" align="center"> 
                       <img src="images/iconos/ejemploterceros3.png" width="940" height="350" border="0">
                      </td> 
                     </tr>
                    </table> 
                    <table width="950">
                     <tr class="TablaDocsPar"> 
                      <td width="50" align="center"> 
                       <img src="images/iconos/alerta.png" width="32" height="32" border="0">
                      </td> 
                      <td width="900" align="center">  
                       <label class="Texto13"> 
                        <font color="BLUE"> <b> Importante: Se debe utilizar un archivo de Excel con extensión .xlsx <br> debe suprimir el encabezado con los títulos de la hoja 
                        <br> y hacer un respaldo de la tabla terceros antes de ejecutar este proceso </b> </font>
                       </label>                      
                      </td> 
                     </tr>
                    </table>';
        }

        echo $cont;
        exit();
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: actualizacionterceros
    // Creación: 30/06/2023		última modificación: 04/07/2024
    // Creador: Luis Flórez		modificado por: Luis Flórez
    // Descripción: Opción que actualiza los datos de los terceros mediante una hoja de 
    //              Excel
    // Última modificación: Inclusión de la columna de fecha de ingreso para su 
    //                      actualización (26/07/2023)
    //                      Inclusión de la fecha de ingreso a la empresa 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "actualizacionterceros")
    {
		set_time_limit(0);
		extract($_POST);
		$archivo = $_FILES['excel']['name'];
		$tipo = $_FILES['excel']['type'];
		$destino = "recursos/xls/bak_".$archivo;

        // Valido que la extensión del archivo sea xlsx
        $extension = pathinfo($destino, PATHINFO_EXTENSION);

        if($extension!="xlsx")
        {
            $clase->Aviso(3,"El archivo debe tener extensión .xlsx");
            header("Location: empleadosperiodo.php?opcion=ventactterceros");
        }
        else
        {
            /// Valido si se cargó el archivo o no
            if (!copy($_FILES['excel']['tmp_name'],$destino))
                echo "Error Al Cargar el Archivo";
        
            if (file_exists ("recursos/xls/bak_".$archivo))
            {
                require_once('lib/PHPExcel.php');
                require_once('lib/PHPExcel/Reader/Excel2007.php');
                
                $objReader = new PHPExcel_Reader_Excel2007();
                $objPHPExcel = $objReader->load("recursos/xls/bak_".$archivo);
                $objFecha = new PHPExcel_Shared_Date();
                $objPHPExcel->setActiveSheetIndex(0);

                $conex = $clase->Conectar();
                $recorrer = true;  $i = 1;
                while($recorrer)
                {
                    $_DATOS_EXCEL[$i]['terid'] = $objPHPExcel->getActiveSheet()->getCell('A'.$i)->getCalculatedValue();
                    $_DATOS_EXCEL[$i]['dni'] = $objPHPExcel->getActiveSheet()->getCell('B'.$i)->getCalculatedValue();
                    $_DATOS_EXCEL[$i]['primernombre'] = $objPHPExcel->getActiveSheet()->getCell('C'.$i)->getCalculatedValue();
                    $_DATOS_EXCEL[$i]['segundonombre'] = $objPHPExcel->getActiveSheet()->getCell('D'.$i)->getCalculatedValue();
                    $_DATOS_EXCEL[$i]['primerapellido'] = $objPHPExcel->getActiveSheet()->getCell('E'.$i)->getCalculatedValue();
                    $_DATOS_EXCEL[$i]['segundoapellido'] = $objPHPExcel->getActiveSheet()->getCell('F'.$i)->getCalculatedValue();
                    $_DATOS_EXCEL[$i]['basico'] = $objPHPExcel->getActiveSheet()->getCell('G'.$i)->getCalculatedValue();
                    $_DATOS_EXCEL[$i]['fecingreso'] = $objPHPExcel->getActiveSheet()->getCell('H'.$i)->getCalculatedValue();
                    $_DATOS_EXCEL[$i]['epsid'] = $objPHPExcel->getActiveSheet()->getCell('I'.$i)->getCalculatedValue();
                    $_DATOS_EXCEL[$i]['pensionesid'] = $objPHPExcel->getActiveSheet()->getCell('J'.$i)->getCalculatedValue();
                    $_DATOS_EXCEL[$i]['cesantiasid'] = $objPHPExcel->getActiveSheet()->getCell('K'.$i)->getCalculatedValue();
                    $_DATOS_EXCEL[$i]['idcajacomp'] = $objPHPExcel->getActiveSheet()->getCell('L'.$i)->getCalculatedValue();
                    $_DATOS_EXCEL[$i]['areaid'] = $objPHPExcel->getActiveSheet()->getCell('M'.$i)->getCalculatedValue();
                    $_DATOS_EXCEL[$i]['seccionid'] = $objPHPExcel->getActiveSheet()->getCell('N'.$i)->getCalculatedValue();
                    $_DATOS_EXCEL[$i]['cargoid'] = $objPHPExcel->getActiveSheet()->getCell('O'.$i)->getCalculatedValue();
                    $_DATOS_EXCEL[$i]['bancoid'] = $objPHPExcel->getActiveSheet()->getCell('P'.$i)->getCalculatedValue();
                    $_DATOS_EXCEL[$i]['numcuenta'] = $objPHPExcel->getActiveSheet()->getCell('Q'.$i)->getCalculatedValue();
                    $_DATOS_EXCEL[$i]['esempleadoactivo'] = $objPHPExcel->getActiveSheet()->getCell('R'.$i)->getCalculatedValue();
                    $_DATOS_EXCEL[$i]['extralegal'] = $objPHPExcel->getActiveSheet()->getCell('S'.$i)->getCalculatedValue();
                    $_DATOS_EXCEL[$i]['codvende'] = $objPHPExcel->getActiveSheet()->getCell('T'.$i)->getCalculatedValue();
                    $_DATOS_EXCEL[$i]['fecretiro'] = $objPHPExcel->getActiveSheet()->getCell('U'.$i)->getCalculatedValue();
                    $_DATOS_EXCEL[$i]['tipodoc'] = $objPHPExcel->getActiveSheet()->getCell('V'.$i)->getCalculatedValue();
                    $_DATOS_EXCEL[$i]['ingresoemp'] = $objPHPExcel->getActiveSheet()->getCell('W'.$i)->getCalculatedValue();
                
                    if(strlen($_DATOS_EXCEL[$i]['dni']) == 0)
                        $recorrer = false;
                    
                    $i++;
                } /// Fin del While
            }
            else
            { echo "Necesitas primero importar el archivo";  }  /// Si NO Cargó el archivo

            // ------------------------------------------------------------------------------------------ //
            // Teniendo la Informacion en el Array la inserto en la Base de Datos
            $errores = 0;
            $grabados = 0;
            $nograbados = 0;
            $carpetaactual = 'reportes/';

            // Obtengo el id del periodo a procesar
            $vsql2 = "SELECT periodoid
                        FROM periodosnomina 
                       WHERE periodoid = (SELECT MIN(periodoid) FROM periodosnomina WHERE cerrado ='')";
            $periodoid = $clase->SeleccionarUno($vsql2);

            // determino si el periodo está calculado
            $calculado = $clase->BDLockup($periodoid,'periodosnomina','periodoid','calculado');

            // Construcción de la variable con los documentos grabados
            $sicedulas = ''.Chr(13).Chr(10);

            // Construcción de la variable con los documentos no grabados
            $nocedulas = ''.Chr(13).Chr(10);
            
            for($j=1; $j < $i; $j++)
            {
                // Inicialización de variables
                $terid = 0;                     $dni = "";                      $primernombre = "";                 $segundonombre = "";                    $primerapellido = "";
                $segundoapellido = "";          $basico = 0;                    $fecingreso = "";                   $epsid = 0;                             $pensionesid = 0;
                $cesantiasid = 0;               $idcajacomp = 0;                $areaid = 0;                        $seccionid = 0;                         $cargoid = 0;
                $bancoid = 0;                   $numcuenta = "";                $esempleadoactivo = "";             $extralegal = "";                       $vsql = "";
                $tipodoc = "";                  $apellidos = "";                $nombres = "";                      $vsql69 = "";                           $numval = 0;
                $codvende = "";                 $registrosact = 0;              $cambios = "";                      $condicioninssert = "";                 $tablaupdate.= "UPDATE terceros SET ";
                $campos = "";                   $valores = "";                  $pasoretiro = false;                $enliquidacion = "";
                $esempleado = "";               $numtipos = 0;                  $vsql18 = "";                       $tablainsert = "INSERT INTO terceros ";                

                // Obtengo los datos necesarios
                $terid = $_DATOS_EXCEL[$j]['terid'];                                $dni = $_DATOS_EXCEL[$j]['dni'];                                $primernombre = $_DATOS_EXCEL[$j]['primernombre'];
                $segundonombre = $_DATOS_EXCEL[$j]['segundonombre'];                $primerapellido = $_DATOS_EXCEL[$j]['primerapellido'];          $segundoapellido = $_DATOS_EXCEL[$j]['segundoapellido'];
                $basico = $_DATOS_EXCEL[$j]['basico'];                              $fecingreso = $_DATOS_EXCEL[$j]['fecingreso'];                  $epsid = $_DATOS_EXCEL[$j]['epsid'];
                $pensionesid = $_DATOS_EXCEL[$j]['pensionesid'];                    $cesantiasid = $_DATOS_EXCEL[$j]['cesantiasid'];                $idcajacomp = $_DATOS_EXCEL[$j]['idcajacomp'];
                $areaid = $_DATOS_EXCEL[$j]['areaid'];                              $seccionid = $_DATOS_EXCEL[$j]['seccionid'];                    $cargoid = $_DATOS_EXCEL[$j]['cargoid'];
                $bancoid = $_DATOS_EXCEL[$j]['bancoid'];                            $numcuenta = $_DATOS_EXCEL[$j]['numcuenta'];                    $esempleadoactivo = $_DATOS_EXCEL[$j]['esempleadoactivo'];
                $extralegal = $_DATOS_EXCEL[$j]['extralegal'];                      $codvende = $_DATOS_EXCEL[$j]['codvende'];                      $fecretiro = $_DATOS_EXCEL[$j]['fecretiro'];
                $tipodoc = $_DATOS_EXCEL[$j]['tipodoc'];                            $ingresoemp = $_DATOS_EXCEL[$j]['ingresoemp'];

                if(strlen($terid) > 0)
                {
                    // ------------------------------------------------------------------------ //
                    // valido el documento
                    $lb_valido = false;
                    $lb_valido = $io_fecha->uf_solo_numeros($dni);

                    if($lb_valido)
                        $cambios.= " dni = '".$dni."',";

                    // ------------------------------------------------------------------------ //
                    // valido el tipo de documento
                    $vsql18 = "SELECT COUNT(*) numtipos FROM tipodocumento WHERE codigo = '".$tipodoc."'";
                    $numtipos = $clase->SeleccionarUno($vsql18);

                    if($numtipos > 0)
                        $cambios.= " tipodoc = '".$tipodoc."',";
                    
                    // ------------------------------------------------------------------------ //
                    // valido el primer nombre
                    $lb_valido = false;
                    $lb_valido = $io_fecha->uf_solo_letras($primernombre);

                    if($lb_valido)
                        $cambios.= " primernombre = '".$primernombre."',";

                    // ------------------------------------------------------------------------ //
                    // valido el segundo nombre
                    $lb_valido = false;
                    $lb_valido = $io_fecha->uf_solo_letras($segundonombre);

                    if($lb_valido)
                        $cambios.= " segundonombre = '".$segundonombre."',";

                    // ------------------------------------------------------------------------ //
                    // valido el primer apellido
                    $lb_valido = false;
                    $lb_valido = $io_fecha->uf_solo_letras($primerapellido);

                    if($lb_valido)
                        $cambios.= " primerapellido = '".$primerapellido."',";

                    // ------------------------------------------------------------------------ //
                    // valido el segundo apellido
                    $lb_valido = false;
                    $lb_valido = $io_fecha->uf_solo_letras($segundoapellido);

                    if($lb_valido)
                        $cambios.= " segundoapellido = '".$segundoapellido."',";

                    // ------------------------------------------------------------------------ //
                    // valido el sueldo básico
                    $lb_valido = false;
                    $lb_valido = $io_fecha->uf_solo_numeros($basico);

                    if($lb_valido)
                        $cambios.= " basico = ".$basico.",";

                    // ------------------------------------------------------------------------ //
                    // valido la fecha de ingreso
                    $lb_valido = false;
                    $lb_valido = validateDate($fecingreso);

                    if($lb_valido)
                        $cambios.= " fecingreso = '".$fecingreso."',";

                    // ------------------------------------------------------------------------ //
                    // valido la eps
                    $lb_valido = false;
                    $lb_valido = $io_fecha->uf_solo_numeros($epsid);

                    if($lb_valido)
                    {
                        // Validación de la consistencia del campo
                        $vsql69 = "SELECT COUNT(epsid) AS numval FROM eps WHERE epsid = ".$epsid;
                        $numval = $clase->SeleccionarUno($vsql69);

                        if($numval >= 1)
                            $cambios.= " epsid = ".$epsid.",";
                    }
                    $vsql69 = "";
                    $numval = 0;

                    // ------------------------------------------------------------------------ //
                    // valido el fondo de pensiones
                    $lb_valido = false;
                    $lb_valido = $io_fecha->uf_solo_numeros($pensionesid);

                    if($lb_valido)
                    {
                        // Validación de la consistencia del campo
                        $vsql69 = "SELECT COUNT(pensionesid) AS numval FROM pensiones WHERE pensionesid = ".$pensionesid;
                        $numval = $clase->SeleccionarUno($vsql69);

                        if($numval >= 1)
                            $cambios.= " pensionesid = ".$pensionesid.",";
                    }
                    $vsql69 = "";
                    $numval = 0;

                    // ------------------------------------------------------------------------ //
                    // valido las cesantías
                    $lb_valido = false;
                    $lb_valido = $io_fecha->uf_solo_numeros($cesantiasid);

                    if($lb_valido)
                    {
                        // Validación de la consistencia del campo
                        $vsql69 = "SELECT COUNT(cesantiasid) AS numval FROM cesantias WHERE cesantiasid = ".$cesantiasid;
                        $numval = $clase->SeleccionarUno($vsql69);

                        if($numval >= 1)
                            $cambios.= " cesantiasid = ".$cesantiasid.",";
                    }
                    $vsql69 = "";
                    $numval = 0;

                    // ------------------------------------------------------------------------ //
                    // valido la caja de compensación
                    $lb_valido = false;
                    $lb_valido = $io_fecha->uf_solo_numeros($idcajacomp);

                    if($lb_valido)
                    {
                        // Validación de la consistencia del campo
                        $vsql69 = "SELECT COUNT(idcajacomp) AS numval FROM cajascompensacion WHERE idcajacomp = ".$idcajacomp;
                        $numval = $clase->SeleccionarUno($vsql69);

                        if($numval >= 1)
                            $cambios.= " idcajacomp = ".$idcajacomp.",";
                    }
                    $vsql69 = "";
                    $numval = 0;

                    // ------------------------------------------------------------------------ //
                    // valido el área
                    $lb_valido = false;
                    $lb_valido = $io_fecha->uf_solo_numeros($areaid);

                    if($lb_valido)
                    {
                        // Validación de la consistencia del campo
                        $vsql69 = "SELECT COUNT(areaid) AS numval FROM areanomina WHERE areaid = ".$areaid;
                        $numval = $clase->SeleccionarUno($vsql69);

                        if($numval >= 1)
                            $cambios.= " areaid = ".$areaid.",";
                    }
                    $vsql69 = "";
                    $numval = 0;

                    // ------------------------------------------------------------------------ //
                    // valido la sección
                    $lb_valido = false;
                    $lb_valido = $io_fecha->uf_solo_numeros($seccionid);

                    if($lb_valido)
                    {
                        // Validación de la consistencia del campo
                        $vsql69 = "SELECT COUNT(seccionid) AS numval FROM seccion WHERE seccionid = ".$seccionid;
                        $numval = $clase->SeleccionarUno($vsql69);

                        if($numval >= 1)
                            $cambios.= " seccionid = ".$seccionid.",";
                    }
                    $vsql69 = "";
                    $numval = 0;

                    // ------------------------------------------------------------------------ //
                    // valido el cargo
                    $lb_valido = false;
                    $lb_valido = $io_fecha->uf_solo_numeros($cargoid);

                    if($lb_valido)
                    {
                        // Validación de la consistencia del campo
                        $vsql69 = "SELECT COUNT(cargoid) AS numval FROM cargos WHERE cargoid = ".$cargoid;
                        $numval = $clase->SeleccionarUno($vsql69);

                        if($numval >= 1)
                            $cambios.= " cargoid = ".$cargoid.",";
                    }
                    $vsql69 = "";
                    $numval = 0;

                    // ------------------------------------------------------------------------ //
                    // valido el banco
                    $lb_valido = false;
                    $lb_valido = $io_fecha->uf_solo_numeros($bancoid);

                    if($lb_valido)
                    {
                        // Validación de la consistencia del campo
                        $vsql69 = "SELECT COUNT(bancoid) AS numval FROM bancos WHERE bancoid = ".$bancoid;
                        $numval = $clase->SeleccionarUno($vsql69);

                        if($numval >= 1)
                            $cambios.= " bancoid = ".$bancoid.",";
                    }
                    $vsql69 = "";
                    $numval = 0;

                    // ------------------------------------------------------------------------ //
                    // valido la cuenta
                    $lb_valido = false;
                    $lb_valido = $io_fecha->uf_solo_numeros($numcuenta);

                    if($lb_valido)
                        $cambios.= " numcuenta = '".$numcuenta."',";

                    // ------------------------------------------------------------------------ //
                    // valido si el empleado es activo
                    if(($esempleadoactivo == "")||($esempleadoactivo == "CHECKED"))
                    {
                        if($esempleadoactivo == "CHECKED")
                        {
                            $enliquidacion = "";                            
                            $cambios.= " esempleado = '".$esempleadoactivo."', enliquidacion = '".$enliquidacion."',";
                        }
                        else
                            $pasoretiro = true;

                        $cambios.= " esempleadoactivo = '".$esempleadoactivo."',";
                    }

                    // ------------------------------------------------------------------------ //
                    // valido si el empleado es extralegal
                    if(($extralegal == "")||($extralegal == "CHECKED"))
                        $cambios.= " extralegal = '".$extralegal."',";

                    // ------------------------------------------------------------------------ //
                    // valido el código del vendedor
                    $lb_valido = false;
                    $lb_valido = $io_fecha->uf_solo_numeros($codvende);

                    if($lb_valido)
                    {
                        // Validación de la consistencia del campo
                        $vsql69 = "SELECT COUNT(codvende) AS numval FROM terceros WHERE codvende = '".$codvende."'";
                        $numval = $clase->SeleccionarUno($vsql69);

                        if($numval == 0)
                            $cambios.= " codvende = '".$codvende."',";
                    }
                    $vsql69 = "";
                    $numval = 0;

                    // ------------------------------------------------------------------------ //
                    // valido la fecha de retiro
                    if(($fecretiro != "") && ($fecretiro != "0000-00-00"))
                    {
                        $lb_valido = false;
                        $lb_valido = validateDate($fecretiro);
    
                        // if($lb_valido)
                        // {
                        //     if($fecingreso <= $fecretiro)
                        //     {
                        //         $cambios.= " fecharetiro = '".$fecretiro."',";
                        //         $pasoretiro = true;
                        //     }
                        //     else
                        //         $pasoretiro = false;
                        // }

                        if($lb_valido)
                        {
                            if($fecingreso <= $fecretiro)                            
                                $cambios.= " fecharetiro = '".$fecretiro."',";
                        }                        
                    }

                    // ------------------------------------------------------------------------ //
                    // valido la fecha de ingreso a la empresa
                    if(($ingresoemp != "") && ($ingresoemp != "0000-00-00"))
                    {
                        if(substr($ingresoemp,0,1) == "'")
                            $ingresoemp = substr($ingresoemp,1,strlen($ingresoemp));

                        $lb_valido = false;
                        $lb_valido = validateDate($ingresoemp);
    
                        if($lb_valido)
                            $cambios.= " ingresoemp = '".$ingresoemp."',";
                    }

                    // previsión para los cupos de crédito
                    $cupocredito = $clase->BDLockup($terid,'terceros','terid','cupocredito');
                    
                    if(($cupocredito == 0) || ($cupocredito == NULL))
                        $cupocredito = 200000;

                    $cambios.= " cupocredito = ".$cupocredito.",";

                    // ------------------------------------------------------------------------ //
                    // Valido que la instrucción esté bien construida
                    if($cambios != "")
                    {
                        // elimino la última coma en caso de ser necesario
                        if(substr($cambios,-1) == ",")
                            $cambios = substr($cambios, 0, -1);

                        // asigno la condición
                        $condicioninssert.= " WHERE terid = ".$terid;

                        // Construyo la instrucción definitiva
                        // $vsql = $tablaupdate.$cambios.$condicioninssert;
                        $vsql = "UPDATE terceros SET ".$cambios." WHERE terid = ".$terid;

                        // guardo los cambios
                        $clase->EjecutarSQL($vsql);

                        if($calculado == "CHECKED")
                        {
                            $vsql = str_replace('terceros','tercerosactual',$vsql);

                            // eliminación del campo cesantiasid
                            $posicionini = 0;
                            $posicionfin = 0;
                            $espacios = 0;
                            $datos2 = "";
                            $posicionini = strrpos($vsql, 'cesantiasid');
                            $posicionfin = strrpos($vsql, 'idcajacomp');
                            $posicionfin--;
                            $espacios = $posicionfin - $posicionini;
                            $datos2 = substr($vsql,$posicionini,$espacios);
                            $vsql = str_replace($datos2,'',$vsql);

                            // eliminación del campo enliquidacion
                            $posicionini = 0;
                            $posicionfin = 0;
                            $espacios = 0;
                            $datos2 = "";
                            $posicionini = strrpos($vsql, 'enliquidacion');
                            $posicionfin = strrpos($vsql, 'esempleadoactivo');
                            $posicionfin--;
                            $espacios = $posicionfin - $posicionini;
                            $datos2 = substr($vsql,$posicionini,$espacios);
                            $vsql = str_replace($datos2,'',$vsql);

                            // guardo en la tabla tercerosactual
                            $clase->EjecutarSQL($vsql);
                        }

                        // Actualizo la sección en la tabla seccionterceros
                        if((strlen($terid) > 0) && (strlen($seccionid) > 0))
                            actualizaseccion($terid,$seccionid);                        

                        // Llamado a la función que pasa a retiro al empleado
                        if($pasoretiro)
                            pasearetiro($terid,$fecingreso,$fecretiro);
                    }
                }
                else
                {
                    // ------------------------------------------------------------------------ //
                    // valido el documento
                    $lb_valido = false;
                    $lb_valido = $io_fecha->uf_solo_numeros($dni);

                    if($lb_valido)
                    {                        
                        $campos.= "codigo,dni,";
                        $valores.= "'".$dni."','".$dni."',";
                    }

                    // ------------------------------------------------------------------------ //
                    // valido el tipo de documento
                    $vsql18 = "SELECT COUNT(*) numtipos FROM tipodocumento WHERE codigo = '".$tipodoc."'";
                    $numtipos = $clase->SeleccionarUno($vsql18);                    

                    if($numtipos > 0)
                    {
                        $campos.= "tipodoc,";
                        $valores.= "'".$tipodoc."',";
                    }
                    else
                    {
                        $tipodocaux = "CEC";
                        $campos.= "tipodoc,";
                        $valores.= "'".$tipodocaux."',";
                    }

                    // ------------------------------------------------------------------------ //
                    // valido el primer nombre
                    $lb_valido = false;
                    $lb_valido = $io_fecha->uf_solo_letras($primernombre);

                    if($lb_valido)
                    {
                        $nombres.= $primernombre;
                        $campos.= "primernombre,";
                        $valores.= "'".$primernombre."',";
                    }

                    // ------------------------------------------------------------------------ //
                    // valido el segundo nombre
                    $lb_valido = false;
                    $lb_valido = $io_fecha->uf_solo_letras($segundonombre);

                    if($lb_valido)
                    {
                        $nombres.= " ".$segundonombre;
                        $campos.= "segundonombre,";
                        $valores.= "'".$segundonombre."',";
                    }

                    // ------------------------------------------------------------------------ //
                    // valido el primer apellido
                    $lb_valido = false;
                    $lb_valido = $io_fecha->uf_solo_letras($primerapellido);

                    if($lb_valido)
                    {
                        $apellidos.= $primerapellido;
                        $campos.= "primerapellido,";
                        $valores.= "'".$primerapellido."',";
                    }

                    // ------------------------------------------------------------------------ //
                    // valido el segundo apellido
                    $lb_valido = false;
                    $lb_valido = $io_fecha->uf_solo_letras($segundoapellido);

                    if($lb_valido)
                    {
                        $apellidos.= " ".$segundoapellido;
                        $campos.= "segundoapellido,";
                        $valores.= "'".$segundoapellido."',";
                    }

                    // ------------------------------------------------------------------------ //
                    // nombres, apellidos, teléfono fijo, movil y creador
                    $telfijo = "000000";
                    $campos.= "nombres,apellidos,telfijo,telmovil,creador,";
                    $valores.= "'".$nombres."','".$apellidos."','".$telfijo."','".$telfijo."','".$_SESSION['USERNAME']."',";

                    // ------------------------------------------------------------------------ //
                    // valido el sueldo básico
                    $lb_valido = false;
                    $lb_valido = $io_fecha->uf_solo_numeros($basico);

                    if($lb_valido)
                    {
                        $campos.= "basico,";
                        $valores.= "".$basico.",";
                    }

                    // ------------------------------------------------------------------------ //
                    // valido la fecha
                    $lb_valido = false;
                    $lb_valido = validateDate($fecingreso);

                    if($lb_valido)
                    {
                        $campos.= "fecingreso,";
                        $valores.= "'".$fecingreso."',";
                    }

                    // ------------------------------------------------------------------------ //
                    // valido la eps
                    $lb_valido = false;
                    $lb_valido = $io_fecha->uf_solo_numeros($epsid);

                    if($lb_valido)
                    {
                        // Validación de la consistencia del campo
                        $vsql69 = "SELECT COUNT(epsid) AS numval FROM eps WHERE epsid = ".$epsid;
                        $numval = $clase->SeleccionarUno($vsql69);
                        
                        if($numval >= 1)
                        {
                            $campos.= "epsid,";
                            $valores.= "".$epsid.",";
                        }
                    }
                    $vsql69 = "";
                    $numval = 0;

                    // ------------------------------------------------------------------------ //
                    // valido el fondo de pensiones
                    $lb_valido = false;
                    $lb_valido = $io_fecha->uf_solo_numeros($pensionesid);

                    if($lb_valido)
                    {
                        // Validación de la consistencia del campo
                        $vsql69 = "SELECT COUNT(pensionesid) AS numval FROM pensiones WHERE pensionesid = ".$pensionesid;
                        $numval = $clase->SeleccionarUno($vsql69);

                        if($numval >= 1)
                        {
                            $campos.= "pensionesid,";
                            $valores.= "".$pensionesid.",";
                        }
                    }
                    $vsql69 = "";
                    $numval = 0;

                    // ------------------------------------------------------------------------ //
                    // valido las cesantías
                    $lb_valido = false;
                    $lb_valido = $io_fecha->uf_solo_numeros($cesantiasid);

                    if($lb_valido)
                    {
                        // Validación de la consistencia del campo
                        $vsql69 = "SELECT COUNT(cesantiasid) AS numval FROM cesantias WHERE cesantiasid = ".$cesantiasid;
                        $numval = $clase->SeleccionarUno($vsql69);

                        if($numval >= 1)
                        {
                            $campos.= "cesantiasid,";
                            $valores.= "".$cesantiasid.",";
                        }
                    }
                    $vsql69 = "";
                    $numval = 0;

                    // ------------------------------------------------------------------------ //
                    // valido la caja de compensación
                    $lb_valido = false;
                    $lb_valido = $io_fecha->uf_solo_numeros($idcajacomp);

                    if($lb_valido)
                    {
                        // Validación de la consistencia del campo
                        $vsql69 = "SELECT COUNT(idcajacomp) AS numval FROM cajascompensacion WHERE idcajacomp = ".$idcajacomp;
                        $numval = $clase->SeleccionarUno($vsql69);

                        if($numval >= 1)
                        {
                            $campos.= "idcajacomp,";
                            $valores.= "".$idcajacomp.",";
                        }
                    }
                    $vsql69 = "";
                    $numval = 0;

                    // ------------------------------------------------------------------------ //
                    // valido el área
                    $lb_valido = false;
                    $lb_valido = $io_fecha->uf_solo_numeros($areaid);

                    if($lb_valido)
                    {
                        // Validación de la consistencia del campo
                        $vsql69 = "SELECT COUNT(areaid) AS numval FROM areanomina WHERE areaid = ".$areaid;
                        $numval = $clase->SeleccionarUno($vsql69);

                        if($numval >= 1)
                        {
                            $campos.= "areaid,";
                            $valores.= "".$areaid.",";
                        }
                    }
                    $vsql69 = "";
                    $numval = 0;

                    // ------------------------------------------------------------------------ //
                    // valido la sección
                    $lb_valido = false;
                    $lb_valido = $io_fecha->uf_solo_numeros($seccionid);

                    if($lb_valido)
                    {
                        // Validación de la consistencia del campo
                        $vsql69 = "SELECT COUNT(seccionid) AS numval FROM seccion WHERE seccionid = ".$seccionid;
                        $numval = $clase->SeleccionarUno($vsql69);

                        if($numval >= 1)
                        {
                            $campos.= "seccionid,";
                            $valores.= "".$seccionid.",";
                        }
                    }
                    $vsql69 = "";
                    $numval = 0;

                    // ------------------------------------------------------------------------ //
                    // valido el cargo
                    $lb_valido = false;
                    $lb_valido = $io_fecha->uf_solo_numeros($cargoid);

                    if($lb_valido)
                    {
                        // Validación de la consistencia del campo
                        $vsql69 = "SELECT COUNT(cargoid) AS numval FROM cargos WHERE cargoid = ".$cargoid;
                        $numval = $clase->SeleccionarUno($vsql69);

                        if($numval >= 1)
                        {
                            $campos.= "cargoid,";
                            $valores.= "".$cargoid.",";
                        }
                    }
                    $vsql69 = "";
                    $numval = 0;

                    // ------------------------------------------------------------------------ //
                    // valido el banco
                    $lb_valido = false;
                    $lb_valido = $io_fecha->uf_solo_numeros($bancoid);

                    if($lb_valido)
                    {
                        // Validación de la consistencia del campo
                        $vsql69 = "SELECT COUNT(bancoid) AS numval FROM bancos WHERE bancoid = ".$bancoid;
                        $numval = $clase->SeleccionarUno($vsql69);

                        if($numval >= 1)
                        {
                            $campos.= "bancoid,";
                            $valores.= "".$bancoid.",";
                        }
                    }
                    $vsql69 = "";
                    $numval = 0;

                    // ------------------------------------------------------------------------ //
                    // valido la cuenta
                    $lb_valido = false;
                    $lb_valido = $io_fecha->uf_solo_numeros($numcuenta);

                    if($lb_valido)
                    {
                        $campos.= "numcuenta,";
                        $valores.= "'".$numcuenta."',";
                    }

                    // ------------------------------------------------------------------------ //
                    // valido si el empleado es activo
                    if(($esempleadoactivo == "")||($esempleadoactivo == "CHECKED"))
                    {
                        if($esempleadoactivo == "CHECKED")
                        {
                            $campos.= "esempleado,";
                            $valores.= "'".$esempleadoactivo."',";
                        }

                        $campos.= "esempleadoactivo,";
                        $valores.= "'".$esempleadoactivo."',";
                    }

                    // ------------------------------------------------------------------------ //
                    // valido si el empleado es extralegal
                    if(($extralegal == "")||($extralegal == "CHECKED"))
                    {
                        $campos.= "extralegal,";
                        $valores.= "'".$extralegal."',";
                    }

                    // ------------------------------------------------------------------------ //
                    // valido el código del vendedor
                    $lb_valido = false;
                    $lb_valido = $io_fecha->uf_solo_numeros($codvende);

                    if($lb_valido)
                    {
                        // Validación de la consistencia del campo
                        $vsql69 = "SELECT COUNT(codvende) AS numval FROM terceros WHERE codvende = '".$codvende."'";
                        $numval = $clase->SeleccionarUno($vsql69);

                        if($numval == 0)
                        {
                            $campos.= "codvende,";
                            $valores.= "'".$codvende."',";
                        }
                    }
                    $vsql69 = "";
                    $numval = 0;

                    // ------------------------------------------------------------------------ //
                    // valido la fecha de retiro
                    if(($fecretiro != "") && ($fecretiro != "0000-00-00"))
                    {
                        $lb_valido = false;
                        $lb_valido = validateDate($fecretiro);
    
                        if(($fecingreso <= $fecretiro) && ($lb_valido))
                        {
                            $campos.= "fecharetiro,";
                            $valores.= "'".$fecretiro."',";
                            $pasoretiro = true;
                        }
                        else
                            $pasoretiro = false;
                    }

                    // ------------------------------------------------------------------------ //
                    // valido la fecha de ingreso a la empresa                   

                    if(($ingresoemp != "") && ($ingresoemp != "0000-00-00"))
                    {                      
                        if(substr($ingresoemp,0,1) == "'")
                            $ingresoemp = substr($ingresoemp,1,strlen($ingresoemp));
                        
                        $lb_valido = false;
                        $lb_valido = validateDate($ingresoemp);
    
                        if($lb_valido)
                        {
                            $campos.= "ingresoemp,";
                            $valores.= "'".$ingresoemp."',";
                        }
                    }

                    // previsión para los cupos de crédito
                    $cupocredito = 200000;
                    $campos.= "cupocredito,";
                    $valores.= "".$cupocredito.",";

                    // ------------------------------------------------------------------------ //
                    // Valido que la instrucción esté bien construida
                    if(($campos != "") && ($valores != ""))
                    {
                        // elimino la última coma
                        if(substr($campos,-1) == ",")
                            $campos = substr($campos, 0, -1);

                        if(substr($valores,-1) == ",")
                            $valores = substr($valores, 0, -1);

                        // Construyo la instrucción definitiva
                        // $vsql=$tablainsert."(".$campos.") VALUES (".$valores.")";

                        $vsql = "INSERT INTO terceros "."(".$campos.") VALUES (".$valores.")";
                        $noincluir = "INSERT INTO terceros (codigo,dni,tipodoc,primernombre,segundonombre,primerapellido,segundoapellido,nombres,apellidos,basico,epsid,pensionesid,cesantiasid,idcajacomp,areaid,seccionid,cargoid,bancoid,numcuenta,esempleadoactivo,extralegal) VALUES ('','','CEC','','','','',' ',' ',,,,,,,,,,'','','')";

                        // valido que se pueda grabar
                        if($vsql != $noincluir)
                        {
                            // Almaceno la información
                            $clase->EjecutarSQL($vsql);

                            if($calculado == "CHECKED")
                            {
                                $vsql = str_replace('terceros','tercerosactual',$vsql);
                                $clase->EjecutarSQL($vsql);
                            }                            

                            // Llamado a la función que pasa a retiro al empleado
                            if($pasoretiro)
                                pasearetironuevoingreso($dni,$fecingreso,$fecretiro);

                            // Actualizo la sección en la tabla seccionterceros
                            if((strlen($terid) > 0) && (strlen($seccionid) > 0))
                                actualizaseccion($terid,$seccionid);
                        }
                    }
                }

                // if($vsql != $noincluir)
                // {
                //     $clase->EjecutarSQL($vsql);
                //     $vsqlregistrosact = "SELECT ROW_COUNT()";
                //     $registrosact = $clase->SeleccionarUno($vsqlregistrosact);
                //     // echo $registrosact; exit();
                // }

                // $registrosact = $vsql->rowCount();
                // $vsqlregistrosact = "SELECT ROW_COUNT()";
                // $registrosact = $clase->SeleccionarUno($vsqlregistrosact);
    
                // // Determino si grabó el registro
                // if($registrosact > 0)
                
                // if(mysql_affected_rows() >= 1)
                // {
                //     $grabados++;
                //     $sicedulas.= str_pad($dni,1,"").''.Chr(13).Chr(10);         // Actualizo la variable con el documento almacenado
                //     $archivo = "tercerosactualizados.txt";                      // nombre del archivo
                //     $fd = fopen ($carpetaactual."/".$archivo, "w");             // se abre el archivo para escribir
                //     fwrite($fd, $sicedulas);                                    // Grabas
                //     fclose($fd);                                                // Cierras el archivo
                // }
                // else
                // {
                //     $nograbados++;
                //     $nocedulas.= str_pad($dni,1,"").''.Chr(13).Chr(10);         // Actualizo la variable con el documento no almacenado
                //     $archivo = "erroresactterceros.txt";                        // nombre del archivo
                //     $fd = fopen ($carpetaactual."/".$archivo, "w");             // se abre el archivo para escribir
                //     fwrite($fd, $nocedulas);                                    // Grabas
                //     fclose($fd);                                                // Cierras el archivo
                // }
            }

            // // Fecha y hora del último proceso
            // $fechoraimp = fechayhoraejecucion();

            // // ----------------------------------------------------------------------------------------------------------------------------------------------------- //
            // $nocedulas.= ''.Chr(13).Chr(10);
            // $nocedulas.= str_pad($nograbados,1,"").' registros no actualizados'.Chr(13).Chr(10);
            // $nocedulas.= str_pad(utf8_decode($fechoraimp),1,"").''.Chr(13).Chr(10);     // Actualizo la variable con la fecha y la hora de la ejecución del proceso
            // $archivo = "erroresactterceros.txt";                                        // nombre del archivo
            // $fd = fopen ($carpetaactual."/".$archivo, "w");                             // se abre el archivo para escribir
            // fwrite($fd, $nocedulas);                                                    // Grabas
            // fclose($fd);                                                                // Cierras el archivo
            // // ----------------------------------------------------------------------------------------------------------------------------------------------------- //
            // $sicedulas.= ''.Chr(13).Chr(10);
            // $sicedulas.= str_pad($grabados,1,"").' registros actualizados'.Chr(13).Chr(10);
            // $sicedulas.= str_pad(utf8_decode($fechoraimp),1,"").''.Chr(13).Chr(10);     // Actualizo la variable con la fecha y la hora de la ejecución del proceso
            // $archivo = "tercerosactualizados.txt";                                      // nombre del archivo
            // $fd = fopen ($carpetaactual."/".$archivo, "w");                             // se abre el archivo para escribir
            // fwrite($fd, $sicedulas);                                                    // Grabas
            // fclose($fd);                                                                // Cierras el archivo
            // // ----------------------------------------------------------------------------------------------------------------------------------------------------- //
      
            // Elimino el Archivo
            unlink($destino);
    
            // Emito el mensaje correspondiente
            // if($grabados==0)
            //     $clase->Aviso(3,"No se cargaron las actualizaciones de terceros");
            // else
            //     $clase->Aviso(1,"Se cargaron $grabados actualizaciones de terceros");

            $clase->Aviso(1,"Proceso culminado satisfactoriamente");

            // Redirecciono el formulario
            header("Location: empleadosperiodo.php?opcion=ventactterceros");
        }        
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: respadoterceros
    // Creación: 04/07/2023		última modificación: 18/04/2024
    // Creador: Luis Flórez		modificado por: Luis Flórez
    // Descripción: Opción que respalda la tabla terceros
    // Última modificación: Inclusión del campo tipo de documento
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "respadoterceros")
    {
        // Obtengo el nombre del periodo a procesar
        $vsql3 = "SELECT periodoid
                    FROM periodosnomina 
                   WHERE periodoid = (SELECT MIN(periodoid) FROM periodosnomina WHERE cerrado ='')";
        $periodoid = $clase->SeleccionarUno($vsql3);

        // Fechas del periodo actual
        $fecdesdeper = $clase->BDLockup($periodoid,'periodosnomina','periodoid','fecdesde');
        $fechastaper = $clase->BDLockup($periodoid,'periodosnomina','periodoid','fechasta');
        
        // Consulta de empleados activos
        // $vsql2 = "SELECT terid, dni, primernombre, segundonombre, primerapellido, segundoapellido, basico, fecingreso, epsid, pensionesid, 
        //                  cesantiasid, idcajacomp, areaid, seccionid, cargoid, bancoid, numcuenta, esempleadoactivo, extralegal, codvende
        //             FROM terceros 
        //            WHERE esempleadoactivo = 'CHECKED' 
        //                  AND basico > 0
        //                  AND terid NOT IN (SELECT terid
        //                                      FROM histcontrato
        //                                     WHERE fecretiro BETWEEN '".$fecdesdeper."' AND '".$fechastaper."')
        //                  AND fecingreso <= '".$fechastaper."'
        //         ORDER BY codvende";

        // todos los empleados
        $vsql2 = "SELECT terid, dni, tipodoc, primernombre, segundonombre, primerapellido, segundoapellido, basico, fecingreso, epsid, pensionesid, 
                         cesantiasid, idcajacomp, areaid, seccionid, cargoid, bancoid, numcuenta, esempleadoactivo, extralegal, codvende
                    FROM terceros";

        // Elimino el respaldo anterior
        $vsql = "DROP TABLE IF EXISTS respaldoterceros";
        $clase->EjecutarSQL($vsql);

        // Creo el nuevo respaldo
        $vsql = "CREATE TABLE respaldoterceros AS (".$vsql2.")";
        $clase->EjecutarSQL($vsql);

        // Emito el mensaje correspondiente
        // if(mysql_affected_rows() >= 1)
        //     $clase->Aviso(1,"Tabla terceros respaldada satisfactoriamente");
        // else
        //     $clase->Aviso(3,"No se respaldó la tabla terceros");

        $clase->Aviso(1,"Tabla terceros respaldada satisfactoriamente");

        // Redirecciono el formulario
        header("Location: empleadosperiodo.php?opcion=ventactterceros");
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: ventanarecuperar
    // Creación: 03/07/2023		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que pinta la ventana con la información del último respaldo de 
    //              la tabla terceros
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "ventanarecuperar")
    {
        // Encabezado
        $cont = $clase->HeaderBlanco("recuperar registros");
        $cont.='<table width="1900">
                 <tr class="CabezoteTabla"> 
                  <td width="10"> </td>
                  <td width="37"> <img src="images/iconos/basedatos.png" width="32" height="32" border="0"> </td>
                  <td width="850"><b>Recuperar respaldo de la tabla terceros</b> </td>
                  <td width="50"> &nbsp; <td>    				 				 				 				
                  <td width="30" align="center"> &nbsp; </td>
                  <td width="10" align="center"> &nbsp; </td>                                    
                  <td width="15"> &nbsp; </td>                  
                  <td width="10" align="center"> &nbsp;  </td>
                  <td width="15"> &nbsp; </td>
                  <td width="10" align="center">
                   <a href="?opcion=ventactterceros"> <input type="button" value="<<" class="button" title="ventana anterior"></a> 
                  </td>
                  <td width="10">&nbsp;</td>
                 </tr>
                </table>';
        
        $cont.='<script language="javascript">
                <!--
                    function seleccionar_todo()
                    { 
                        valor = document.f2.todos.checked;
                        if(valor)
                            marcartodo();
                        else
                            desmarcartodo();
                    } 

                    function marcartodo()
                    {
                        for (i=0;i<document.f2.elements.length;i++) 
                        if(document.f2.elements[i].type == "checkbox")  
                        document.f2.elements[i].checked = 1;
                    }

                    function desmarcartodo()
                    {
                        for (i=0;i<document.f2.elements.length;i++) 
                        if(document.f2.elements[i].type == "checkbox") 
                            document.f2.elements[i].checked = 0;
                    }  
                -->
                </script>
                <script type="text/javascript" src="lib/sorttable.js"></script>
                <form action="empleadosperiodo.php?opcion=restaurarregistros" method="POST" name="f2">
                <table width="1900" class="sortable">
                 <thead> 
                  <tr class="TituloTabla" style="display:block;padding-top:5px;height:20px;">
                   <th width="10"> &nbsp; </th>
                   <th width="260" align="left"> terid </th>
                   <th width="435" align="left"> dni </th>
                   <th width="150" align="left"> primernombre </th>
                   <th width="155" align="left"> segundonombre </th>
                   <th width="145" align="left"> primerapellido </th>
                   <th width="150" align="left"> segundoapellido </th>
                   <th width="220" align="left"> basico </th>
                   <th width="115" align="left"> fecingreso </th>
                   <th width="90" align="left"> epsid </th>
                   <th width="160" align="left"> pensionesid </th>
                   <th width="135" align="left"> cesantiasid </th>
                   <th width="135" align="left"> idcajacomp </th>
                   <th width="90" align="left"> areaid </th>
                   <th width="125" align="left"> seccionid </th>
                   <th width="110" align="left"> cargoid </th>
                   <th width="105" align="left"> bancoid </th>
                   <th width="180" align="left"> numcuenta </th>
                   <th width="170" align="left"> esempleadoactivo </th>
                   <th width="140" align="left"> extralegal </th>
                   <th width="125" align="left"> codvende </th>
                   <th width="45" align="left"> <input type="checkbox" name="todos" value="S" onClick="javascript:seleccionar_todo();"> </th>
                   <th width="50" align="left"> &nbsp; </th>
                  </tr>
                 </thead>
                 <tbody style="display:block; width:1900px; height:720px; overflow-Y:scroll">';

        // Consulta de la tabla de respaldo terceros
        $vsql = "SELECT * FROM respaldoterceros ORDER BY codvende";

        $i = 0;
        $conex  = $clase->Conectar();
        $result = mysql_query($vsql,$conex);
        while($row = mysql_fetch_array($result))
        {
            $i++;
            if($i%2 == 0)
                $cont.='<tr class="TablaDocsPar">';
            else
                $cont.='<tr class="TablaDocsImPar">';
            
            // impresión del registro
            $cont.= ' <td width="10"> &nbsp; </td>
                      <td width="120" align="left"> '.$row['terid'].' </td>
                      <td width="115" align="left"> '.$row['dni'].' </td>
                      <td width="160" align="left"> '.$row['primernombre'].' </td>
                      <td width="180" align="left"> '.$row['segundonombre'].' </td>
                      <td width="140" align="left"> '.$row['primerapellido'].' </td>
                      <td width="170" align="left"> '.$row['segundoapellido'].' </td>
                      <td width="115" align="left"> '.number_format($row['basico']).' </td>
                      <td width="150" align="left"> '.$row['fecingreso'].' </td>
                      <td width="90" align="left"> '.$row['epsid'].' </td>
                      <td width="210" align="left"> '.$row['pensionesid'].' </td>
                      <td width="205" align="left"> '.$row['cesantiasid'].' </td>
                      <td width="185" align="left"> '.$row['idcajacomp'].' </td>
                      <td width="120" align="left"> '.$row['areaid'].' </td>
                      <td width="145" align="left"> '.$row['seccionid'].' </td>
                      <td width="120" align="left"> '.$row['cargoid'].' </td>
                      <td width="145" align="left"> '.$row['bancoid'].' </td>
                      <td width="140" align="left"> '.$row['numcuenta'].' </td>
                      <td width="220" align="left"> '.$row['esempleadoactivo'].' </td>
                      <td width="130" align="left"> '.$row['extralegal'].' </td>
                      <td width="135" align="left"> '.$row['codvende'].' </td>
                      <td width="35" align="left"> <input type="checkbox" class="Texto11" name="LIN-'.$row['terid'].'" value="S"> </td>
                     </tr>';
        }

        // pie de página y botón para ejecutar el proceso de recuperación
        $cont.=' </tbody>
                </table>
                <table width="100%">
                 <tr class="TituloTabla"> 
                  <td width="261"> &nbsp; </td>
                  <td width="375" align="right"> &nbsp; </td>
                  <td width="375" align="right"> &nbsp; </td>
                  <td width="375" align="right"> &nbsp; </td>
                  <td width="222"> &nbsp; </td>
                 </tr>
                </table>                
                <br>
                <center>
                <a href="#" OnClick="f2.submit();"><input type="button" class="button blue" value="aceptar"></a>
                </form>';
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: restaurarregistros
    // Creación: 14/07/2023		última modificación: 18/04/2024
    // Creador: Luis Flórez		modificado por: Luis Flórez
    // Descripción: Opción que restaura los registros previamente seleccionados en la 
    //              opción anterior
    // Última modificación: Inclusión del campo tipo de documento
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "restaurarregistros")
    {
        $vsql = "SELECT * FROM respaldoterceros ORDER BY codvende";
        $conex  = $clase->Conectar();
        $result = mysql_query($vsql,$conex);
        while($row = mysql_fetch_array($result))
        {
            if($_POST['LIN-'.$row['terid']] == "S")
            {
                $dni = $row['dni'];                         $primernombre = $row['primernombre'];                           $segundonombre = $row['segundonombre'];
                $primerapellido = $row['primerapellido'];   $segundoapellido = $row['segundoapellido'];                     $basico = $row['basico'];
                $fecingreso = $row['fecingreso'];           $epsid = $row['epsid'];                                         $pensionesid = $row['pensionesid'];
                $cesantiasid = $row['cesantiasid'];         $idcajacomp = $row['idcajacomp'];                               $areaid = $row['areaid'];
                $seccionid = $row['seccionid'];             $cargoid = $row['cargoid'];                                     $bancoid = $row['bancoid'];
                $numcuenta = $row['numcuenta'];             $esempleadoactivo = $row['esempleadoactivo'];                   $extralegal = $row['extralegal'];
                $codvende = $row['codvende'];               $terid = $row['terid'];                                         $tipodoc = $row['tipodoc'];
                
                // $codigo = $row['codigo'];                                       
                // $apellidos = $row['apellidos'];             $nombres = $row['nombres'];                                     $telfijo = $row['telfijo'];
                // $telmovil = $row['telmovil'];               $creador = $row['creador'];                                     

                // $vsql2 = "REPLACE INTO terceros (terid,codigo,dni,tipodoc,apellidos,nombres,telfijo,telmovil,primernombre,segundonombre,primerapellido,segundoapellido,basico,fecingreso,epsid,pensionesid,cesantiasid,idcajacomp,areaid,seccionid,cargoid,bancoid,numcuenta,esempleadoactivo,extralegal,codvende,creador) 
                //                 VALUES (".$terid.",'".$codigo."','".$dni."','".$tipodoc."','".$apellidos."','".$nombres."','".$telfijo."','".$telmovil."','".$primernombre."','".$segundonombre."','".$primerapellido."','".$segundoapellido."',".$basico.",'".$fecingreso."',".$epsid.",".$pensionesid.",".$cesantiasid.",
                //                         ".$idcajacomp.",".$areaid.",".$seccionid.",".$cargoid.",".$bancoid.",'".$numcuenta."','".$esempleadoactivo."','".$extralegal."','".$codvende."','".$creador."')";

                $vsql2 = "UPDATE terceros SET 
                                 dni = '".$dni."',
                                 tipodoc = '".$tipodoc."',
                                 primernombre = '".$primernombre."',
                                 segundonombre = '".$segundonombre."',
                                 primerapellido = '".$primerapellido."',
                                 segundoapellido = '".$segundoapellido."',
                                 basico = ".$basico.",
                                 fecingreso = '".$fecingreso."',
                                 epsid = ".$epsid.",
                                 pensionesid = ".$pensionesid.",
                                 cesantiasid = ".$cesantiasid.",
                                 idcajacomp = ".$idcajacomp.",
                                 areaid = ".$areaid.",
                                 seccionid = ".$seccionid.",
                                 cargoid = ".$cargoid.",
                                 bancoid = ".$bancoid.",
                                 numcuenta = '".$numcuenta."',                                 
                                 esempleadoactivo = '".$esempleadoactivo."',
                                 extralegal = '".$extralegal."',
                                 codvende = '".$codvende."'
                           WHERE terid = ".$terid;                
                $clase->EjecutarSQL($vsql2);
            }
        }

        // Emito el mensaje correspondiente
        $clase->Aviso(1,"Proceso culminado satisfactoriamente");

        // Redirecciono el formulario
        header("Location: empleadosperiodo.php?opcion=ventactterceros");
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: ventselper
    // Creación: 31/07/2023		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que pinta la ventana para seleccionar un periodo 
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "ventselper")
    {
        // Preparo el combo de periodos
        $params = ' class="Texto12" ';
        $yeartoday = date("Y");
        $monthtoday = date("n");
        $vsqlcomboperiodo  = "SELECT codperiodo, desperiodo FROM periodos WHERE anoperiodo = ".$yeartoday."  AND mesperiodo <= ".$monthtoday." ORDER BY orden";
        $comboperiodos = $clase->CrearComboBuscar("codperiodo",$vsqlcomboperiodo,"desperiodo","codperiodo","","N",$params,300);

        // Pinto la ventana
        $cont.='<table width="400">
                 <tr class="CabezoteTabla">
                  <td align="left"> <img src="images/iconos/vistaprevia.png" width="32" height="32" border="0"> </td>
                  <td align="center"> <b>Seleccionar periodo</b> </td>
                 </tr> 
                </table>                
                <form action="?opcion=datosliquidadosxls" name="y" method="POST">                
                <table width="400">
                 <tr class="CabezoteTabla">
                  <td width="10"> &nbsp; </td>
                  <td align="left">
                   <label class="Texto12">Periodo:&nbsp;&nbsp;</label>
                   '.$comboperiodos.'
                  </td>
                 </tr>
                </table>                 
                <table width="400">
                 <tr class="CabezoteTabla">
                  <td align="center">                    
                   <input type="submit" value="aceptar" class="button blue">
                   <a href="empleadosperiodo.php?opcion=ventactterceros"><input type="button" value="CANCELAR" class="button red"></a>
                   </form>
                  </td>
                 </tr>
                </table>';
        echo $cont;
        exit();
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: datosliquidadosxls
    // Creación: 31/07/2023		última modificación: 15/08/2023
    // Creador: Luis Flórez		modificado por: Luis Flórez
    // Descripción: Opción que genera una hoja de Excel con los datos de los empleados 
    //              liquidados en un periodo
    // Última modificación: Inclusión de una nueva hoja con los id de las eps, fondos de 
    //                      pensión, cesantías, cajas de compensación, áreas, secciones, 
    //                      cargos y bancos.
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "datosliquidadosxls")
    {
        $codperiodo = $_POST["codperiodo"];
        $desperiodo = $clase->BDLockup($codperiodo,'periodos','codperiodo','desperiodo');
        
        // Consulta de los empleados del periodo
        $vsql = "SELECT t.terid, t.dni, t.primernombre, t.segundonombre, t.primerapellido, t.segundoapellido, t.basico, t.fecingreso, t.epsid, t.pensionesid,
                        t.cesantiasid, t.idcajacomp, t.areaid, t.seccionid, t.cargoid, t.bancoid, t.numcuenta, t.esempleadoactivo, t.extralegal, t.codvende, 
                        (SELECT COUNT(*) 
                           FROM liquidacion 
                          WHERE liquidacion.terid = l.terid 
                                AND liquidacion.periodonomina = '".$codperiodo."' LIMIT 0,1) AS numreg 
                   FROM terceros t
                        INNER JOIN liquidacion l ON (t.terid = l.terid)
                  WHERE l.periodonomina = '".$codperiodo."' 
                        AND t.esempleadoactivo = '' 
               GROUP BY t.terid
                 HAVING numreg >= 3";

        // Preparo el entorno
        require_once 'lib/PHPExcel.php';
        $clase = new Sistema();
        $clase->Conectar();
        ini_set("memory_limit","100M");
        
        // Preparación del entorno para la salida a Excel
        $clase = new Sistema();
        $clase->Nombredb = $_SESSION['DBNOMBRE'];
        error_reporting(E_ALL);
        ini_set('display_errors', TRUE);
        ini_set('display_startup_errors', TRUE);
        date_default_timezone_set('Europe/London');
    
        if (PHP_SAPI == 'cli')
            die('This example should only be run from a Web Browser');
    
        // Create new PHPExcel object
        $objPHPExcel = new PHPExcel();
    
        // Set document properties
        $objPHPExcel->getProperties()->setCreator("Sistemas y Soluciones Web de Colombia")
                                     ->setLastModifiedBy("Sistemas y Soluciones Web de Colombia")
                                     ->setTitle("datos liquidados - DROPOS")
                                     ->setSubject("datos liquidados - DROPOS")
                                     ->setDescription("datos liquidados - DROPOS")
                                     ->setKeywords("datos liquidados - DROPOS")
                                     ->setCategory("Categoria General");

        $objPHPExcel->setActiveSheetIndex(0)
                    ->setCellValue('A1', 'TERID')
                    ->setCellValue('B1', 'CEDULA')
                    ->setCellValue('C1', 'PRIMER NOMBRE')
                    ->setCellValue('D1', 'SEGUNDO NOMBRE')
                    ->setCellValue('E1', 'PRIMER APELLIDO')
                    ->setCellValue('F1', 'SEGUNDO APELLIDO')
                    ->setCellValue('G1', 'BASICO')
                    ->setCellValue('H1', 'FECHA INGRESO')
                    ->setCellValue('I1', 'EPS')
                    ->setCellValue('J1', 'AFP')
                    ->setCellValue('K1', 'CESANTIAS')
                    ->setCellValue('L1', 'CAJA COMPENSACION')
                    ->setCellValue('M1', 'AREA')
                    ->setCellValue('N1', 'SECCION')
                    ->setCellValue('O1', 'CARGO')
                    ->setCellValue('P1', 'BANCO')
                    ->setCellValue('Q1', 'NUMERO CUENTA')
                    ->setCellValue('R1', 'EMPLEADO ACTIVO')
                    ->setCellValue('S1', 'EXTRALEGAL')
                    ->setCellValue('T1', 'CODVENDE');
                 
        $objPHPExcel->getActiveSheet()->getColumnDimension('A')->setAutoSize(true);                 $objPHPExcel->getActiveSheet()->getColumnDimension('B')->setAutoSize(true);
        $objPHPExcel->getActiveSheet()->getColumnDimension('C')->setAutoSize(true);                 $objPHPExcel->getActiveSheet()->getColumnDimension('D')->setAutoSize(true);
        $objPHPExcel->getActiveSheet()->getColumnDimension('E')->setAutoSize(true);                 $objPHPExcel->getActiveSheet()->getColumnDimension('F')->setAutoSize(true);
        $objPHPExcel->getActiveSheet()->getColumnDimension('G')->setAutoSize(true);                 $objPHPExcel->getActiveSheet()->getColumnDimension('H')->setAutoSize(true);
        $objPHPExcel->getActiveSheet()->getColumnDimension('I')->setAutoSize(true);                 $objPHPExcel->getActiveSheet()->getColumnDimension('J')->setAutoSize(true);
        $objPHPExcel->getActiveSheet()->getColumnDimension('K')->setAutoSize(true);                 $objPHPExcel->getActiveSheet()->getColumnDimension('L')->setAutoSize(true);
        $objPHPExcel->getActiveSheet()->getColumnDimension('M')->setAutoSize(true);                 $objPHPExcel->getActiveSheet()->getColumnDimension('N')->setAutoSize(true);
        $objPHPExcel->getActiveSheet()->getColumnDimension('O')->setAutoSize(true);                 $objPHPExcel->getActiveSheet()->getColumnDimension('P')->setAutoSize(true);
        $objPHPExcel->getActiveSheet()->getColumnDimension('Q')->setAutoSize(true);                 $objPHPExcel->getActiveSheet()->getColumnDimension('R')->setAutoSize(true);
        $objPHPExcel->getActiveSheet()->getColumnDimension('S')->setAutoSize(true);                 $objPHPExcel->getActiveSheet()->getColumnDimension('T')->setAutoSize(true);

        $i = 2;
        $conex  = $clase->Conectar();
        $result = mysql_query($vsql,$conex);
        $cant   = mysql_num_rows($result);
        while($row = mysql_fetch_array($result))
        {
            $codvende = $row['codvende'];
            if(substr($codvende,0,1) == "0")            $codvende="'".$codvende;

            $objPHPExcel->setActiveSheetIndex(0)
                        ->setCellValue('A'.$i, $row['terid'])
                        ->setCellValue('B'.$i, $row['dni'])
                        ->setCellValue('C'.$i, $row['primernombre'])
                        ->setCellValue('D'.$i, $row['segundonombre'])
                        ->setCellValue('E'.$i, $row['primerapellido'])
                        ->setCellValue('F'.$i, $row['segundoapellido'])
                        ->setCellValue('G'.$i, $row['basico'])
                        ->setCellValue('H'.$i, $row['fecingreso'])
                        ->setCellValue('I'.$i, $row['epsid'])
                        ->setCellValue('J'.$i, $row['pensionesid'])
                        ->setCellValue('K'.$i, $row['cesantiasid'])
                        ->setCellValue('L'.$i, $row['idcajacomp'])
                        ->setCellValue('M'.$i, $row['areaid'])
                        ->setCellValue('N'.$i, $row['seccionid'])
                        ->setCellValue('O'.$i, $row['cargoid'])
                        ->setCellValue('P'.$i, $row['bancoid'])
                        ->setCellValue('Q'.$i, $row['numcuenta'])
                        ->setCellValue('R'.$i, $row['esempleadoactivo'])
                        ->setCellValue('S'.$i, $row['extralegal'])
                        ->setCellValue('T'.$i, $codvende);
            $i++;
        }

        $rangoEncabezado = 'A4:T4';
        $rangoCeldas     = 'A4:T'.($i-1);

        // ----------------------------------------------------------------------------------------------------------------------------------------------------------- //
        // Formato de Encabezado y Celdas
        $objPHPExcel->getActiveSheet()->getRowDimension('1')->setRowHeight(15);
        
        $EstiloCeldas = array(
        'borders' => array(
            'allborders' => array(
                'style' => PHPExcel_Style_Border::BORDER_THIN,
                'color' => array('argb' => '00000000'),
            ),
            ),
        );
        // $objPHPExcel->getActiveSheet()->getStyle($rangoCeldas)->applyFromArray($EstiloCeldas);
        /// Formato de Encabezados 
        $EstiloEncabezado = array(
        'font' => array(
            'bold' => true,
        ),
        'alignment' => array(
            'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,
            'vertical' => PHPExcel_Style_Alignment::VERTICAL_CENTER,		
        ),
        'borders' => array(
            'allborders' => array(
                'style' => PHPExcel_Style_Border::BORDER_THIN,
                'color' => array('argb' => '00000000'),
            ),
        ),
        'fill' => array(
            'type' => PHPExcel_Style_Fill::FILL_SOLID,
            'rotation' => 90,
            'startcolor' => array(
                'argb' => '00FFFFCC',
            ),
            'endcolor' => array(
                'argb' => 'FFFFFF',
            ),
            ),
        );
        // $objPHPExcel->getActiveSheet()->getStyle($rangoEncabezado)->applyFromArray($EstiloEncabezado);
        // Rename worksheet
        $objPHPExcel->getActiveSheet()->setTitle('datos liquidados');
        // Set active sheet index to the first sheet, so Excel opens this as the first sheet
        $objPHPExcel->setActiveSheetIndex(0);

        // --------------------------------------------------------------------------------------------------------------------------------------------------- //
        // Nueva hoja con los id de las eps, fondos de pensión, cesantías, cajas de compensación, áreas, secciones, cargos y bancos.
        $objPHPExcel->createSheet();

        $objPHPExcel->setActiveSheetIndex(1); // marcar como activa la nueva hoja
        $objPHPExcel->getActiveSheet()->setTitle('codigos');        

        // consulta para las eps
        $vsql = "SELECT epsid, descripcioneps FROM eps";

        $objPHPExcel->setActiveSheetIndex(0)
                    ->setCellValue('codigos!A1', 'CODIGOS TERCEROS')
                    ->setCellValue('codigos!A3', 'EPS')
                    ->setCellValue('codigos!A4', 'CODIGO')
                    ->setCellValue('codigos!B4', 'NOMBRE');

        $objPHPExcel->getActiveSheet()->getColumnDimension('A')->setAutoSize(true);                 $objPHPExcel->getActiveSheet()->getColumnDimension('B')->setAutoSize(true);

        $i = 5;
        $conex  = $clase->Conectar();
        $result = mysql_query($vsql,$conex);
        $cant   = mysql_num_rows($result);
        while($row = mysql_fetch_array($result))
        {
            $objPHPExcel->setActiveSheetIndex(0)
                        ->setCellValue('codigos!A'.$i, $row['epsid'])
                        ->setCellValue('codigos!B'.$i, $row['descripcioneps']);
            $i++;
        }

        $rangoEncabezado = 'codigos!A4:codigos!B4';
        $rangoCeldas     = 'codigos!A4:codigos!B'.($i-1);

        // ----------------------------------------------------------------------------------------------------------------------------------------------------------- //
        // Fondo de pensiones
        $vsql = "SELECT pensionesid, descripcionafp FROM pensiones";
        $j = $i + 2;

        $celda1="codigos!A".strval($j);
        $celda2="codigos!B".strval($j);
        $celda3="codigos!A".strval($j-1);

        $objPHPExcel->setActiveSheetIndex(0)
                    ->setCellValue($celda3, 'FONDOS DE PENSIONES')
                    ->setCellValue($celda1, 'CODIGO')
                    ->setCellValue($celda2, 'NOMBRE');

        $j++;

        $conex  = $clase->Conectar();
        $result = mysql_query($vsql,$conex);
        while($row = mysql_fetch_array($result))
        {
            $objPHPExcel->setActiveSheetIndex(0)
                        ->setCellValue('codigos!A'.$j, $row['pensionesid'])
                        ->setCellValue('codigos!B'.$j, $row['descripcionafp']);
            $j++;
        }

        $rangoEncabezado = 'codigos!A4:codigos!B4';
        $rangoCeldas     = 'codigos!A4:B'.($j-1);

        // ----------------------------------------------------------------------------------------------------------------------------------------------------------- //
        // Cesantías
        $vsql = "SELECT cesantiasid, descripcion FROM cesantias";

        $k = $j + 2;

        $celda1="codigos!A".strval($k);
        $celda2="codigos!B".strval($k);
        $celda3="codigos!A".strval($k-1);

        $objPHPExcel->setActiveSheetIndex(0)
                    ->setCellValue($celda3, 'CESANTIAS')
                    ->setCellValue($celda1, 'CODIGO')
                    ->setCellValue($celda2, 'NOMBRE');
        
        $k++;
        $conex  = $clase->Conectar();
        $result = mysql_query($vsql,$conex);
        while($row = mysql_fetch_array($result))
        {
            $objPHPExcel->setActiveSheetIndex(0)
                        ->setCellValue('codigos!A'.$k, $row['cesantiasid'])
                        ->setCellValue('codigos!B'.$k, $row['descripcion']);
            $k++;
        }

        $rangoEncabezado3 = $celda1.':'.$celda2;
        $rangoCeldas3     = $celda1.($k-1);

        // ----------------------------------------------------------------------------------------------------------------------------------------------------------- //
        // cajas de compenzación
        $vsql = "SELECT idcajacomp, nombrecaja FROM cajascompensacion";

        $l = $k + 2;

        $celda1="codigos!A".strval($l);
        $celda2="codigos!B".strval($l);
        $celda3="codigos!A".strval($l-1);

        $objPHPExcel->setActiveSheetIndex(0)
                    ->setCellValue($celda3, 'CAJAS COMPENSACION')
                    ->setCellValue($celda1, 'CODIGO')
                    ->setCellValue($celda2, 'NOMBRE');

        $l++;
        $conex  = $clase->Conectar();
        $result = mysql_query($vsql,$conex);
        while($row = mysql_fetch_array($result))
        {
            $objPHPExcel->setActiveSheetIndex(0)
                        ->setCellValue('codigos!A'.$l, $row['idcajacomp'])
                        ->setCellValue('codigos!B'.$l, $row['nombrecaja']);
            $l++;
        }

        // ----------------------------------------------------------------------------------------------------------------------------------------------------------- //
        // áreas de nómina
        $vsql = "SELECT areaid, descripcionarea FROM areanomina";

        $m = $l + 2;

        $celda1="codigos!A".strval($m);
        $celda2="codigos!B".strval($m);
        $celda3="codigos!A".strval($m-1);

        $objPHPExcel->setActiveSheetIndex(0)
                    ->setCellValue($celda3, 'AREAS')
                    ->setCellValue($celda1, 'CODIGO')
                    ->setCellValue($celda2, 'NOMBRE');

        $m++;
        $conex  = $clase->Conectar();
        $result = mysql_query($vsql,$conex);
        while($row = mysql_fetch_array($result))
        {
            $objPHPExcel->setActiveSheetIndex(0)
                        ->setCellValue('codigos!A'.$m, $row['areaid'])
                        ->setCellValue('codigos!B'.$m, $row['descripcionarea']);
            $m++;
        }

        // ----------------------------------------------------------------------------------------------------------------------------------------------------------- //
        // secciones de nómina
        $vsql = "SELECT seccionid, descripcionsec FROM seccion";

        $n = $m + 2;

        $celda1="codigos!A".strval($n);
        $celda2="codigos!B".strval($n);
        $celda3="codigos!A".strval($n-1);

        $objPHPExcel->setActiveSheetIndex(0)
                    ->setCellValue($celda3, 'SECCIONES')
                    ->setCellValue($celda1, 'CODIGO')
                    ->setCellValue($celda2, 'NOMBRE');

        $n++;
        $conex  = $clase->Conectar();
        $result = mysql_query($vsql,$conex);
        while($row = mysql_fetch_array($result))
        {
            $objPHPExcel->setActiveSheetIndex(0)
                        ->setCellValue('codigos!A'.$n, $row['seccionid'])
                        ->setCellValue('codigos!B'.$n, $row['descripcionsec']);
            $n++;
        }

        $rangoEncabezado3 = $celda1.':'.$celda2;
        $rangoCeldas3     = $celda1.($n-1);

        // ----------------------------------------------------------------------------------------------------------------------------------------------------------- //
        // cargos
        $vsql = "SELECT cargoid, descripcioncargo FROM cargos";

        $o = $n + 2;

        $celda1="codigos!A".strval($o);
        $celda2="codigos!B".strval($o);
        $celda3="codigos!A".strval($o-1);        

        $objPHPExcel->setActiveSheetIndex(0)
                    ->setCellValue($celda3, 'CARGOS')
                    ->setCellValue($celda1, 'CODIGO')
                    ->setCellValue($celda2, 'NOMBRE');

        $o++;
        $conex  = $clase->Conectar();
        $result = mysql_query($vsql,$conex);
        while($row = mysql_fetch_array($result))
        {
            $objPHPExcel->setActiveSheetIndex(0)
                        ->setCellValue('codigos!A'.$o, $row['cargoid'])
                        ->setCellValue('codigos!B'.$o, $row['descripcioncargo']);
            $o++;
        }

        $rangoEncabezado3 = $celda1.':'.$celda2;
        $rangoCeldas3     = $celda1.($o-1);

        // ----------------------------------------------------------------------------------------------------------------------------------------------------------- //
        // Bancos
        $vsql = "SELECT bancoid, descripcion FROM bancos";

        $p = $o + 2;

        $celda1="codigos!A".strval($p);
        $celda2="codigos!B".strval($p);
        $celda3="codigos!A".strval($p-1);           

        $objPHPExcel->setActiveSheetIndex(0)
                    ->setCellValue($celda3, 'BANCOS')
                    ->setCellValue($celda1, 'CODIGO')
                    ->setCellValue($celda2, 'NOMBRE');

        $p++;
        $conex  = $clase->Conectar();
        $result = mysql_query($vsql,$conex);
        while($row = mysql_fetch_array($result))
        {
            $objPHPExcel->setActiveSheetIndex(0)
                        ->setCellValue('codigos!A'.$p, $row['bancoid'])
                        ->setCellValue('codigos!B'.$p, $row['descripcion']);
            $p++;
        }

        $rangoEncabezado3 = $celda1.':'.$celda2;
        $rangoCeldas3     = $celda1.($p-1);

        // ----------------------------------------------------------------------------------------------------------------------------------------------------------- //        
        // Formato de Encabezado y Celdas
        $objPHPExcel->getActiveSheet()->getRowDimension('1')->setRowHeight(15);
        
        $EstiloCeldas = array(
        'borders' => array(
            'allborders' => array(
                'style' => PHPExcel_Style_Border::BORDER_THIN,
                'color' => array('argb' => '00000000'),
            ),
            ),
        );        
        /// Formato de Encabezados 
        $EstiloEncabezado = array(
        'font' => array(
            'bold' => true,
        ),
        'alignment' => array(
            'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,
            'vertical' => PHPExcel_Style_Alignment::VERTICAL_CENTER,		
        ),
        'borders' => array(
            'allborders' => array(
                'style' => PHPExcel_Style_Border::BORDER_THIN,
                'color' => array('argb' => '00000000'),
            ),
        ),
        'fill' => array(
            'type' => PHPExcel_Style_Fill::FILL_SOLID,
            'rotation' => 90,
            'startcolor' => array(
                'argb' => '00FFFFCC',
            ),
            'endcolor' => array(
                'argb' => 'FFFFFF',
            ),
            ),
        );
        // --------------------------------------------------------------------------------------------------------------------------------------------------- //
        // Redirect output to a client’s web browser (Excel5)
        header('Content-Type: application/vnd.ms-excel');
        // --------------------------------------------------------------------- //
        $nombrearcexcel = "liquidados ".strtolower($desperiodo).".xls";
        header('Content-Disposition: attachment;filename='.$nombrearcexcel.'');
        // --------------------------------------------------------------------- //
        header('Cache-Control: max-age=0');
        /// Genero la Salida
        $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');
        $objWriter->save('php://output');
        exit;
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: ventemplactiliq
    // Creación: 31/07/2023		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que pinta la ventana donde se muestran los empleados con el 
    //              estatus de empleados activo y en liquidación
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "ventemplactiliq")
    {
        // Valido que existan empleados para ser depurados
        $vsql8 = "SELECT COUNT(*) numliq FROM terceros WHERE esempleadoactivo = 'CHECKED' AND enliquidacion = 'CHECKED'";
        $numliq = $clase->SeleccionarUno($vsql8);

        if($numliq == 0)
        {
            // Emito el mensaje correspondiente
            $clase->Aviso(3,"No existen empleados en liquidación para depurar");

            // Redirecciono el formulario
            header("Location: empleadosperiodo.php?opcion=ventactterceros");
        }
        else
        {
            // Pinto la ventana
            $cont = $clase->Header("S","W");
            $cont.='<table width="100%">
                     <tr class="CabezoteTabla"> 
                      <td width="10"> &nbsp; </td>
                      <td width="37"> <img src="images/iconos/proveedores.png" width="32" height="32" border="0"> </td>
                      <td width="770"> <b> Liquidados activos </b> </td>
                      <td width="30" align="left"> 
                       <a href="?opcion=exportarexcelliq" target="_blank">
                        <img src="images/iconos/exportarexcel2.png" width="32" height="32" border="0" title="salida a Excel"> 
                       </a>
                      </td>
                      <td width="10"> &nbsp; </td>
                      <td width="30" align="left"> 
                       <a href="?opcion=confirmarlimpiar" rel="facebox">
                        <img src="images/iconos/anulardoc.png" width="32" height="32" border="0" title="depurar el campo en liquidaci&oacute;n"> 
                       </a>
                      </td>
                      <td width="50" align="center"> <input type="button" class="button" value="<<" OnClick="document.location=\'empleadosperiodo.php?opcion=ventactterceros\'"> </td>
                      <td width="10"> &nbsp; </td>
                     </tr> 
                    </table>';
    
            // Encabezado
            $cont.='<script type="text/javascript" src="lib/sorttable.js"></script>
                    <table width="100%" class="sortable">
                     <thead> 
                      <tr class="TituloTabla" style="display:block;padding-top:5px;height:35px;">
                       <th width="12"> &nbsp; </th>
                       <th width="120" align="left"> Documento </th>
                       <th width="100" align="left"> Cod. <br> Vende </th>
                       <th width="470" align="left"> Empleado </th>
                       <th width="100" align="center"> Empleado </th>
                       <th width="100" align="center"> Activo <br> n&oacute;mina </th>
                       <th width="100" align="center"> En liquidación </th>
                       <th width="60"> &nbsp; </th>
                      </tr>
                     </thead>
                     <tbody style="display:block; width:1050px; height:500px; overflow-Y:scroll">';
    
            // Consulta de empleados activos con el estado en liquidación
            $vsql = "SELECT terid, dni, codvende, CONCAT(primernombre,' ',segundonombre,' ',primerapellido,' ',segundoapellido) AS nombreemp, 
                            esempleado, esempleadoactivo, enliquidacion 
                       FROM terceros 
                      WHERE esempleadoactivo = 'CHECKED' AND enliquidacion = 'CHECKED' 
                   ORDER BY 3 ASC";
    
            // Conexión a la base de datos
            $i = 0;
            $conex  = $clase->Conectar();
            $result = mysql_query($vsql,$conex);
            while($row = mysql_fetch_array($result))
            {
                $i++;
                if($i%2 == 0)
                    $cont.='<tr class="TablaDocsPar">';
                else
                    $cont.='<tr class="TablaDocsImPar">';
    
                $esempleado = $row['esempleado'];
                $esempleadoactivo = $row['esempleadoactivo'];
                $enliquidacion = $row['enliquidacion'];
    
                $cont.=' <td width="12"> &nbsp; </td>
                         <td width="120" align="left"> '.$row['dni'].' </td>
                         <td width="100" align="left"> '.$row['codvende'].' </td>
                         <td width="460" align="left"> '.$row['nombreemp'].' </td>
                         <td width="100" align="center"> <input type="checkbox" name="esempleado" value="CHECKED" '.$esempleado.' disabled> </td>
                         <td width="100" align="center"> <input type="checkbox" name="esempleadoactivo" value="CHECKED" '.$esempleadoactivo.' disabled> </td>
                         <td width="100" align="center"> <input type="checkbox" name="enliquidacion" value="CHECKED" '.$enliquidacion.' disabled> </td>
                         <td width="40" align="center">
                          <a href="?opcion=venteditempleado&terid='.$row['terid'].'" rel="facebox">
                           <img src="images/basicas/iconobuscar.png" title="editar empleado" border="0">
                          </a>
                         </td>
                        </tr>';
            }
    
            $cont.=' </tbody>
                     </table>';
    
            // Impresión de los totales
            $cont.='<table width="100%">
                     <tr class="TituloTabla"> 
                      <td width="12"> &nbsp; </td>
                      <td width="636" align="left"> <b> '.number_format($numliq).' empleados liquidados activos en n&oacute;mina</b> </td>                      
                      <td width="375" align="right"> &nbsp; </td>
                      <td width="375" align="right"> &nbsp; </td>
                      <td width="210"> &nbsp; </td>
                     </tr>
                    </table>';
        }
    }
    
    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: venteditempleado
    // Creación: 31/07/2023		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que pinta la ventana para editar los campos de los empleados
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "venteditempleado")
    {
        $terid = $_GET['terid'];

        // nombre del empleado
        $vsql2 = "SELECT CONCAT(primernombre,' ',segundonombre,' ',primerapellido,' ',segundoapellido) AS nombreemp FROM terceros WHERE terid = ".$terid;
        $nombreemp = $clase->SeleccionarUno($vsql2);

        // estatus del empleado
        $esempleado = $clase->BDLockup($terid,'terceros','terid','esempleado');
        $esempleadoactivo = $clase->BDLockup($terid,'terceros','terid','esempleadoactivo');
        $enliquidacion = $clase->BDLockup($terid,'terceros','terid','enliquidacion');

        // pinto la ventana
        $cont ='<table width="400">
                 <tr class="CabezoteTabla">
                  <td width="50" align="left"> <img src="images/iconos/aspectos.png" width="32" height="32" border="0"> </td>
                  <td width="350" align="center"> <b>Editar empleado <br> <font color="blue">'.$nombreemp.' </font> </b> </td>
                 </tr> 
                </table>
                <form action="?opcion=guardareditempleado&terid='.$terid.'" method="POST" name="x">
                <input type="hidden" name="terid" value="'.$terid.'">
                <table width="400">
                 <center>
                 <tr class="TablaDocsImPar">                 
                  <td width="400" align="center">
                   &nbsp;&nbsp; Empleado <input type="checkbox" name="esempleado" value="CHECKED" '.$esempleado.'> 
                   &nbsp; Activo n&oacute;mina <input type="checkbox" name="esempleadoactivo" value="CHECKED" '.$esempleadoactivo.'>
                   &nbsp; En liquidaci&oacute;n <input type="checkbox" name="enliquidacion" value="CHECKED" '.$enliquidacion.'>
                  </td>
                 </tr>
                </table>
                <br>
                <center>
                <input type="submit" value="aceptar" class="button blue">
                <a href="empleadosperiodo.php?opcion=ventemplactiliq"><input type="button" value="CANCELAR" class="button red"></a>
                </form><br>';
        echo $cont;
        exit();
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: guardareditempleado
    // Creación: 31/07/2023		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que almacena los cambios editados de un empleado
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "guardareditempleado")
    {
        $terid = $_POST['terid'];
        $esempleado = $_POST['esempleado'];
        $esempleadoactivo = $_POST['esempleadoactivo'];
        $enliquidacion = $_POST['enliquidacion'];

        // Grabo los cambios
        $vsql = "UPDATE terceros SET 
                        esempleado = '".$esempleado."',
                        esempleadoactivo = '".$esempleadoactivo."',
                        enliquidacion = '".$enliquidacion."'
                  WHERE terid = ".$terid;
        $clase->EjecutarSQL($vsql);

        // emito el mensaje correspondiente
        $clase->Aviso(1,"Datos almacenados satisfactoriamente");

        // Redirecciono el formulario
        header("Location: empleadosperiodo.php?opcion=ventemplactiliq");
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: confirmarlimpiar
    // Creación: 31/07/2023		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que pinta la ventana para confirmar la depuración de todos los 
    //              empleados activos y en liquidación
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "confirmarlimpiar")
    {
        // Pinto la ventana
        $cont ='<table width="500">
                 <tr class="CabezoteTabla"> 
                  <td align="center"> <br> <label class="Texto12"> <b> Depurar datos de liquidados </b> </label> <br><br> </td> 
                 </tr> 
                </table>
                <table width="500">
                 <tr class="TablaDocsImPar"> 
                  <td width="400" align="center">
                   <br>
                   <label class="Texto12">¿Confirma que desea depurar el campo en liquidaci&oacute;n?</label> 
                  </td>
                 </tr>
                 <tr class="TablaDocsImPar">
                  <td width="400" align="center"><br><br> 
                   <form action="?opcion=depurarliquidados" method="POST">                   
                   <input type="submit" value="ACEPTAR" class="button blue">
                   <a href="empleadosperiodo.php?opcion=ventemplactiliq" ><input type="button" value="CANCELAR" class="button red"></a>
                   </form>                   
                  </td> 
                 </tr>
                </table>';
        echo $cont;
        exit();
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: depurarliquidados
    // Creación: 31/07/2023		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que depura los empleados activos y en liquidación
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "depurarliquidados")
    {
        // Depuro la información
        $vsql = "UPDATE terceros SET enliquidacion = '' WHERE esempleadoactivo = 'CHECKED' AND enliquidacion = 'CHECKED'";
        $clase->EjecutarSQL($vsql);
        
        // Emito el mensaje correspondiente
        $clase->Aviso(1,"Datos depurados satisfactoriamente");

        // Redirecciono el formulario
        header("Location: empleadosperiodo.php?opcion=ventactterceros");
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: exportarexcelliq
    // Creación: 01/08/2023		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que emita el informe de empleados activos que también están en 
    //              liquidación en una hoja de Excel
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "exportarexcelliq")
    {
        // Consulta del informe
        $vsql = "SELECT dni, codvende, CONCAT(primernombre,' ',segundonombre,' ',primerapellido,' ',segundoapellido) AS nombreemp, 
                        esempleado, esempleadoactivo, enliquidacion 
                   FROM terceros 
                  WHERE esempleadoactivo = 'CHECKED' AND enliquidacion = 'CHECKED' 
               ORDER BY 2 ASC";

        // Preparo el entorno
        require_once 'lib/PHPExcel.php';
        $clase = new Sistema();
        $clase->Conectar();
        ini_set("memory_limit","100M");
        
        // Preparación del entorno para la salida a Excel
        $clase = new Sistema();
        $clase->Nombredb = $_SESSION['DBNOMBRE'];
        error_reporting(E_ALL);
        ini_set('display_errors', TRUE);
        ini_set('display_startup_errors', TRUE);
        date_default_timezone_set('Europe/London');
    
        if (PHP_SAPI == 'cli')
            die('This example should only be run from a Web Browser');
    
        // Create new PHPExcel object
        $objPHPExcel = new PHPExcel();
    
        // Set document properties
        $objPHPExcel->getProperties()->setCreator("Sistemas y Soluciones Web de Colombia")
                                     ->setLastModifiedBy("Sistemas y Soluciones Web de Colombia")
                                     ->setTitle("liquidados activos - DROPOS")
                                     ->setSubject("liquidados activos - DROPOS")
                                     ->setDescription("liquidados activos - DROPOS")
                                     ->setKeywords("liquidados activos - DROPOS")
                                     ->setCategory("Categoria General");

        $objPHPExcel->setActiveSheetIndex(0)
                    ->setCellValue('A1', 'LIQUIDADOS ACTIVOS')                    
                    ->setCellValue('A3', 'DOCUMENTO')
                    ->setCellValue('B3', 'COD. VENDE')
                    ->setCellValue('C3', 'NOMBRE')
                    ->setCellValue('D3', 'EMPLEADO')
                    ->setCellValue('E3', 'ACTIVO NOMINA')
                    ->setCellValue('F3', 'EN LIQUIDACION');

        $objPHPExcel->getActiveSheet()->getColumnDimension('A')->setAutoSize(true);                 $objPHPExcel->getActiveSheet()->getColumnDimension('B')->setAutoSize(true);
        $objPHPExcel->getActiveSheet()->getColumnDimension('C')->setAutoSize(true);                 $objPHPExcel->getActiveSheet()->getColumnDimension('D')->setAutoSize(true);
        $objPHPExcel->getActiveSheet()->getColumnDimension('E')->setAutoSize(true);                 $objPHPExcel->getActiveSheet()->getColumnDimension('F')->setAutoSize(true);

        // Inmovilizar paneles
        $objPHPExcel->getActiveSheet(0)->freezePaneByColumnAndRow(0,4);
        
        $i = 4;
        $conex  = $clase->Conectar();
        $result = mysql_query($vsql,$conex);
        $cant   = mysql_num_rows($result);
        while($row = mysql_fetch_array($result))
        {
            $codvende = $row['codvende'];
            if(substr($codvende,0,1) == "0")
                $codvende="'".$codvende;

            if($row['esempleado'] == "CHECKED")
                $esempleado = "CHECKED";
            else
                $esempleado = "";

            if($row['esempleadoactivo'] == "CHECKED")
                $esempleadoactivo = "CHECKED";
            else
                $esempleadoactivo = "";

            if($row['enliquidacion'] == "CHECKED")
                $enliquidacion = "CHECKED";
            else
                $enliquidacion = "";

            $objPHPExcel->setActiveSheetIndex(0)
                        ->setCellValue('A'.$i, $row['dni'])
                        ->setCellValue('B'.$i, $codvende)
                        ->setCellValue('C'.$i, $row['nombreemp'])
                        ->setCellValue('D'.$i, $esempleado)
                        ->setCellValue('E'.$i, $esempleadoactivo)
                        ->setCellValue('F'.$i, $enliquidacion);

            $i++;
        }

        $rangoEncabezado = 'A3:F3';
        $rangoCeldas     = 'A3:F'.($i-1);

        // ----------------------------------------------------------------------------------------------------------------------------------------------------------- //
        // Formato de Encabezado y Celdas
        $objPHPExcel->getActiveSheet()->getRowDimension('1')->setRowHeight(15);
        
        $EstiloCeldas = array(
        'borders' => array(
            'allborders' => array(
                'style' => PHPExcel_Style_Border::BORDER_THIN,
                'color' => array('argb' => '00000000'),
            ),
            ),
        );
        $objPHPExcel->getActiveSheet()->getStyle($rangoCeldas)->applyFromArray($EstiloCeldas);
        /// Formato de Encabezados 
        $EstiloEncabezado = array(
        'font' => array(
            'bold' => true,
        ),
        'alignment' => array(
            'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,
            'vertical' => PHPExcel_Style_Alignment::VERTICAL_CENTER,		
        ),
        'borders' => array(
            'allborders' => array(
                'style' => PHPExcel_Style_Border::BORDER_THIN,
                'color' => array('argb' => '00000000'),
            ),
        ),
        'fill' => array(
            'type' => PHPExcel_Style_Fill::FILL_SOLID,
            'rotation' => 90,
            'startcolor' => array(
                'argb' => '00FFFFCC',
            ),
            'endcolor' => array(
                'argb' => 'FFFFFF',
            ),
            ),
        );
        $objPHPExcel->getActiveSheet()->getStyle($rangoEncabezado)->applyFromArray($EstiloEncabezado);
        // Rename worksheet
        $objPHPExcel->getActiveSheet()->setTitle('liquidados activos');
        // Set active sheet index to the first sheet, so Excel opens this as the first sheet
        $objPHPExcel->setActiveSheetIndex(0);
        // Redirect output to a client’s web browser (Excel5)
        header('Content-Type: application/vnd.ms-excel');
        // --------------------------------------------------------------------- //
        $nombrearcexcel = "liquidados activos.xls";
        header('Content-Disposition: attachment;filename='.$nombrearcexcel.'');
        // --------------------------------------------------------------------- //
        header('Cache-Control: max-age=0');
        /// Genero la Salida
        $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');
        $objWriter->save('php://output');
        exit;
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: ventanaactualizaractivos
    // Creación: 18/03/2024		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que pinta la ventana para captar la hoja de Excel con las 
    //              actualizaciones de empleados en la ficha terceros
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "ventanaactualizaractivos")
    {
        $cont = '';
        $servidor = $_SERVER['SERVER_NAME'].":".$_SERVER['SERVER_PORT'];

        // Validación del servidor
        if(($servidor!="dromedicas.sytes.net:9996")&&($servidor!="192.168.14.248:9999"))
            $cont.='<table width="400">
                     <tr class="CabezoteTabla"> 
                      <td align="center"> <b>Servidor incorrecto </b> </td>
                     </tr> 
                     <tr class="CabezoteTabla"> 
                      <td align="center"> 
                       <font color=red> Este servidor est&aacute; inhabilitado para hacer este <br> 
                       proceso, por favor diríjase al servidor </font><br> 
                       <font color=blue> 192.168.14.248:9999 </font> <br>
                       <font color=red>o al servidor </font> <br> 
                       <font color=blue> dromedicas.sytes.net:9996 </font> <br>
                       <font color=red> para poder ejecutar este proceso </font> <br><br>
                      </td> 
                     </tr>
                     <tr class="TablaDocsPar">        
                      <td width="100%" align="center"> 
                       <form name="importa" method="post" action="empleadosperiodo.php?opcion=ventactterceros" id="theform" enctype="multipart/form-data">
                        <input type="submit" name="enviar" id="enviarr"  value="aceptar" class="button blue" /> 
                       </form> 
                      </td>    
                     </tr>
                    </table>';
        else
        {    
            $periodoid = $_GET["periodoid"];

            $descripcion = $clase->BDLockup($periodoid,'periodosnomina','periodoid','descripcion');           

            // Inicializo la variable para actualizar la tabla tercerosactual
            $tercerosactual = "";

            // Validación de la tabla tercerosactual
            $vsql2 = "SELECT COUNT(*) AS regactual FROM tercerosactual";
            $regactual = $clase->SeleccionarUno($vsql2);

            if($regactual > 0)
                $disable = "";
            else
                $disable = "disabled";
    
            // pinto la ventana
            $cont.='<script type="text/javascript" src="lib/jquery-2.1.3.min.js"></script>
                    <script>
                     $(function()
                     {
                      $("#enviarr").on("click",function()
                      {
                        $(this).val("Espere por favor ...")
                        .attr("disabled","disabled");
                        $("#theform").submit();
                      });
                     });
                    </script>
                    <table width="400">
                     <tr class="CabezoteTabla"> 
                      <td align="center"> <b>Activar e inactivar<br> masivamente en el periodo <br> <font color="BLUE">'.strtolower($descripcion).'</font></b> <br><br></td> 
                     </tr> 
                    </table>
                    <table width="400">
                     <tr class="TablaDocsPar">        
                      <td width="100%" align="center"> 
                       <form name="importa" method="post" action="?opcion=actualizaractivosnom" id="theform" enctype="multipart/form-data">
                       <input type="hidden" name="periodoid" value="'.$periodoid.'">
                       <input type="file" name="excel" /><br><br>                       
                       <input type="submit" name="enviar" id="enviarr"  value="Importar archivo" class="button blue" />
                       <br><br><input type="checkbox" value="CHECKED" name="tercerosactual" class="Texto11" '.$tercerosactual.' '.$disable.'> Terceros periodos actual
                       <input type="hidden" value="upload" name="action" />                       
                       </form>                        
                      </td>    
                     </tr>
                    </table>';
    
            $cont.='<table width="400">
                     <tr class="TablaDocsPar"> <td align="left"> &nbsp; La hoja de Excel debe tener la siguiente estructura: </td> </tr>
                     <tr class="TablaDocsPar"> <td align="left"> &nbsp; Columna <b>A</b>: C&eacute;dula </td> </tr>
                     <tr class="TablaDocsPar"> <td align="left"> &nbsp; Columna <b>B</b>: Empleado </td> </tr>
                     <tr class="TablaDocsPar"> <td align="left"> &nbsp; Columna <b>C</b>: Activo n&oacute;mina </td> </tr>
                     <tr class="TablaDocsPar"> <td align="left"> &nbsp; Columna <b>C</b>: Extralegal </td> </tr>
                    </table>';
    
            $cont.='<table width="400">
                     <tr class="TablaDocsPar"> 
                      <td align="center"> 
                       <img src="images/iconos/ejemploactivarinactivar.png" width="320" height="200" border="0">
                      </td> 
                     </tr>
                     <tr class="TablaDocsPar"> 
                      <td width="100%" align="center"> 
                       <font color="BLUE"> Importante: Se debe utilizar un archivo de Excel con extensión .xlsx</font>
                      </td> 
                     </tr>
                    </table>';
        }

        echo $cont;
        exit();        
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: actualizaractivosnom
    // Creación: 18/03/2024		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que almacena los cambios realizados en la ficha terceros y 
    //              tercerosactual
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "actualizaractivosnom")
    {
        set_time_limit(0);
		extract($_POST);
        $periodoid = $_POST["periodoid"];
        $tercerosactual = $_POST["tercerosactual"];
		$archivo = $_FILES['excel']['name'];
		$tipo = $_FILES['excel']['type'];
		$destino = "recursos/xls/bak_".$archivo;

        // Valido que la extensión del archivo sea xlsx
        $extension = pathinfo($destino, PATHINFO_EXTENSION);

        if($extension!="xlsx")
        {
            $clase->Aviso(3,"El archivo debe tener extensión .xlsx");
            header("Location: empleadosperiodo.php?opcion=ventactterceros");
        }
        else
        {
            /// Valido si se cargó el archivo o no
            if (!copy($_FILES['excel']['tmp_name'],$destino))
                echo "Error Al Cargar el Archivo";
        
            if (file_exists ("recursos/xls/bak_".$archivo))
            {
                require_once('lib/PHPExcel.php');
                require_once('lib/PHPExcel/Reader/Excel2007.php');
                
                $objReader = new PHPExcel_Reader_Excel2007();
                $objPHPExcel = $objReader->load("recursos/xls/bak_".$archivo);
                $objFecha = new PHPExcel_Shared_Date();
                $objPHPExcel->setActiveSheetIndex(0);
                $conex = $clase->Conectar();
                $recorrer = true;  $i = 1;
                while($recorrer)
                {
                    $_DATOS_EXCEL[$i]['dni'] = $objPHPExcel->getActiveSheet()->getCell('A'.$i)->getCalculatedValue();
                    $_DATOS_EXCEL[$i]['esempleado'] = $objPHPExcel->getActiveSheet()->getCell('B'.$i)->getCalculatedValue();
                    $_DATOS_EXCEL[$i]['esempleadoactivo'] = $objPHPExcel->getActiveSheet()->getCell('C'.$i)->getCalculatedValue();
                    $_DATOS_EXCEL[$i]['extralegal'] = $objPHPExcel->getActiveSheet()->getCell('D'.$i)->getCalculatedValue();
                
                    if(strlen($_DATOS_EXCEL[$i]['dni']) == 0) 
                        $recorrer = false;
                    
                    $i++;
                } /// Fin del While
            }
            else
            { echo "Necesitas primero importar el archivo";  }  /// Si NO Cargó el archivo

            // Teniendo la Informacion en el Array la inserto en la Base de Datos
            $errores = 0;
            $grabados = 0;
            $descripcion = $clase->BDLockup($periodoid,'periodosnomina','periodoid','descripcion');

            $carpetaactual = 'reportes/';

            // Construcción de la variable con los documentos no grabados
            $nocedulas = 'ACTUALIZACIONES EN EL PERIODO'.Chr(13).Chr(10);
            $nocedulas.= ''.str_pad($descripcion,1,"").''.Chr(13).Chr(10);
            $nocedulas.= 'DOCUMENTOS NO GRABADOS:'.Chr(13).Chr(10);
            $nocedulas.= ''.Chr(13).Chr(10);

            for($j=1; $j < $i; $j++)
            {
                $lbgrabo = false;               $vsql = "";                 $vsql2 = "";
                $dni = "";                      $esempleado = "";           $esempleadoactivo = "";
                $extralegal = "";               $vsql3 = "";                $terid = 0;

                // Obtengo los datos necesarios
                $dni = $_DATOS_EXCEL[$j]['dni'];
                $esempleado = $_DATOS_EXCEL[$j]['esempleado'];
                $esempleadoactivo = $_DATOS_EXCEL[$j]['esempleadoactivo'];
                $extralegal = $_DATOS_EXCEL[$j]['extralegal'];

                // Valido que el empleado exista
                $vsql3 = "SELECT terid FROM terceros WHERE dni = '".$dni."'";
                $terid = $clase->SeleccionarUno($vsql3);

                if(strlen($terid) > 0)
                {
                    // Almaceno la información en terceros
                    $vsql = "UPDATE terceros SET esempleado = '".$esempleado."', esempleadoactivo = '".$esempleadoactivo."', extralegal = '".$extralegal."' WHERE terid = ".$terid;
                    $clase->EjecutarSQL($vsql);

                    if(mysql_affected_rows() >= 1)
                    {
                        $grabados++;
                        $lbgrabo = true;
                    }

                    // Almaceno la información en terceros actual
                    if($tercerosactual == "CHECKED")
                    {
                        $vsql2 = "UPDATE tercerosactual SET esempleado = '".$esempleado."', esempleadoactivo = '".$esempleadoactivo."', extralegal = '".$extralegal."' WHERE terid = ".$terid;
                        $clase->EjecutarSQL($vsql2);
                    }
                }

                // Almaceno en un archivo de texto las cédulas de los empleados que no fueron grabados en este proceso
                if(!$lbgrabo)
                {
                    $nocedulas.= str_pad($dni,1,"").''.Chr(13).Chr(10);                     // Actualizo la variable con el documento no almacenado
                    $archivo = "erroresactivos.txt";                                        // nombre del archivo
                    $fd = fopen ($carpetaactual."/".$archivo, "w");                         // se abre el archivo para escribir
                    fwrite($fd, $nocedulas);                                                // Grabas
                    fclose($fd);                                                            // Cierras el archivo
                }
            }

            $fechoraimp = fechayhoraejecucion();

            $nocedulas.= ''.Chr(13).Chr(10);
            $nocedulas.= str_pad(utf8_decode($fechoraimp),1,"").''.Chr(13).Chr(10);                 // Actualizo la variable con la fecha y la hora de la ejecución del proceso
            $archivo = "erroresactivos.txt";                                                        // nombre del archivo
            $fd = fopen ($carpetaactual."/".$archivo, "w");                                         // se abre el archivo para escribir
            fwrite($fd, $nocedulas);                                                                // Grabas
            fclose($fd);                                                                            // Cierras el archivo
      
            // Elimino el Archivo
            unlink($destino);
    
            // Emito el mensaje correspondiente
            if($grabados==0)
                $clase->Aviso(3,"No se cargaron las actualizaciones para el periodo $descripcion");
            else
                $clase->Aviso(1,"Se cargaron $grabados actualizaciones para el periodo $descripcion");
    
            // Redirecciona el formulario
            header("Location: empleadosperiodo.php?opcion=ventactterceros");
        }        
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: ventanasincronizacion
    // Creación: 03/03/2025		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que pinta la ventana para sincronizar los campos empleados y 
    //              activos nómina
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "ventanasincronizacion")
    {
        // consulta de la vista
        $vsql = "SELECT terid, dni, codvende, CONCAT(primernombre,' ',segundonombre,' ',primerapellido,' ',segundoapellido) nombres, esempleado, esempleadoactivo 
                   FROM terceros 
                  WHERE basico > 0 
                        AND esempleado = 'CHECKED' 
                        AND esempleadoactivo = ''";

        // impresión del detalle
        $i = 0;
        $conex  = $clase->Conectar();
        $result = mysql_query($vsql,$conex);
        $cant   = mysql_num_rows($result);

        if($cant > 0)
        {
            // Pintamos la ventana
            $cont = $clase->Header("S","W");
            $cont.='<table width="100%">
                     <tr class="CabezoteTabla"> 
                      <td width="10"> &nbsp; </td>
                      <td width="40"> <img src="images/iconos/inventario.png" width="32" height="32" border="0"> </td>
                      <td width="780"> <b>Sincronizaci&oacute;n entre los campos empleado y Activo n&oacute;mina</b> </td>
                      <td width="280"> &nbsp; </td>
                      <td width="160"> &nbsp; </td>
                      <td width="20"> 
                       <a href="?opcion=bajardesincronizados" title="bajar desincronizados"> 
                        <img src="images/iconos/descargar.png" border="0" width="32" height="32">  
                       </a>
                      </td>
                      <td width="10"> &nbsp; </td>
                      <td width="20"> 
                       <a href="?opcion=ventanasincronizacion" title="actualizar la ventana"> 
                        <img src="images/iconos/refrescar.png" border="0" width="32" height="32">  
                       </a>
                      </td>
                      <td width="10"> &nbsp; </td>
                      <td width="20"> <a href="empleadosperiodo.php"> <input type="button" class="button blue" value="<<"> </a> </td>
                      <td width="24"> &nbsp; </td>
                     </tr>
                    </table>';
    
            $cont.='<script language="javascript">
                        <!--
                            function seleccionar_todo()
                            { 
                                valor = document.f2.todos.checked;
                                if(valor)
                                    marcartodo();
                                else
                                    desmarcartodo();
                            } 
        
                            function marcartodo()
                            {
                                for (i=0;i<document.f2.elements.length;i++) 
                                if(document.f2.elements[i].type == "checkbox")  
                                document.f2.elements[i].checked = 1;
                            }
        
                            function desmarcartodo()
                            {
                                for (i=0;i<document.f2.elements.length;i++) 
                                if(document.f2.elements[i].type == "checkbox") 
                                document.f2.elements[i].checked = 0;
                            }
                        -->
                    </script>';
    
            // títulos
            $cont.='<script type="text/javascript" src="lib/sorttable.js"></script>
                    <form action="?opcion=sincronizarestados" method="POST" name="f2">                
                    <table id="fixTableV" class="sortable">
                     <tr class="TituloTabla">
                      <th width="30"> # </th>
                      <th width="120"> C&eacute;dula </th>
                      <th width="100"> C&oacute;digo </th>
                      <th width="560"> Nombre </th>
                      <th width="30"> Empleado</th>
                      <th width="30"> Activo N&oacute;mina</th>
                      <th width="30"> &nbsp; </th>
                      <th width="30"> <input type="checkbox" name="todos" value="S" style="width:18px;height:20px;" onClick="javascript:seleccionar_todo();"> </th>
                     </tr>';    
    
            // impresión del detalle
            while($row = mysql_fetch_array($result))
            {
                $i++;
                if($i%2 == 0)
                    $cont.='<tr class="TablaDocsPar">';
                else
                    $cont.='<tr class="TablaDocsImPar">';

                $esempleado = $row['esempleado'];
                $esempleadoactivo = $row['esempleadoactivo'];

                $cont.=' <td align="center"> '.$i.' </td>
                            <td align="center"> '.$row['dni'].' </td>
                            <td align="center"> '.$row['codvende'].' </td>
                            <td align="center"> '.$row['nombres'].' </td>
                            <td align="center"> <input type="checkbox" name="esempleado" value="CHECKED" style="width:18px;height:20px;" '.$esempleado.' disabled> </td>
                            <td align="center"> <input type="checkbox" name="esempleadoactivo" value="CHECKED" style="width:18px;height:20px;" '.$esempleadoactivo.' disabled> </td>
                            <td align="center">
                            <a href="terceros.php?opcion=detalles2&id='.$row['terid'].'" target="_blank"> 
                            <img src="images/basicas/auditoria.png" border="0" width="20" height="20"> 
                            </a>
                            </td>
                            <td align="center"> <input type="checkbox" class="Texto11" name="LIN-'.$row['terid'].'" style="width:18px;height:20px;" value="S"> </td>
                        </tr>';
            }

            // Impresión de los totales
            $cont.='<table width="100%">
                        <tr class="TituloTabla"> 
                        <td width="12"> &nbsp; </td>
                        <td width="1011" align="left"> <b> '.number_format($cant).' empleados desincronizados de los campos empleado y Activo n&oacute;mina</b> </td>                                            
                        <td width="375" align="right"> &nbsp; </td>
                        <td width="210"> &nbsp; </td>
                        </tr>
                    </table>
                    <br>
                    <br>
                    <center>
                    <a href="#" OnClick="f2.submit();"><input type="button" class="button blue" value="sincronizar"></a>
                    </form>';
        }
        else
        {
            // Pintamos la ventana
            $cont = $clase->Header("S","W");
            $cont.='<table width="100%">
                     <tr class="CabezoteTabla"> 
                      <td width="10"> &nbsp; </td>
                      <td width="40"> <img src="images/iconos/inventario.png" width="32" height="32" border="0"> </td>
                      <td width="780"> <b>Sincronizaci&oacute;n entre los campos empleado y Activo n&oacute;mina</b> </td>
                      <td width="280"> &nbsp; </td>
                      <td width="190"> &nbsp; </td>
                      <td width="20"> 
                       <a href="?opcion=ventanasincronizacion" title="actualizar la ventana"> 
                        <img src="images/iconos/refrescar.png" border="0" width="32" height="32">  
                       </a>
                      </td>
                      <td width="10"> &nbsp; </td>
                      <td width="20"> <a href="empleadosperiodo.php"> <input type="button" class="button blue" value="<<"> </a> </td>
                      <td width="24"> &nbsp; </td>
                     </tr>
                    </table>';

            // mensaje correspondiente
            $cont.='<table width="100%">
                     <tr class="BarraDocumentos" style="height:50px;Important!">
                      <td width="20"> &nbsp; </td>
                      <td width="750" align="center"> 
                       <h2> No existen empleados desincronizados </h2>
                     </tr>
                    </table>
                    <table width="100%"> 
                     <tr class="BarraDocumentos" style="height:50px;Important!"> <td align="center"> &nbsp; </td> </tr>
                     <tr class="BarraDocumentos" style="height:50px;Important!"> <td align="center"> &nbsp; </td> </tr>
                     <tr class="BarraDocumentos" style="height:50px;Important!"> <td align="center"> &nbsp; </td> </tr>
                     <tr class="BarraDocumentos" style="height:50px;Important!"> <td align="center"> &nbsp; </td> </tr>
                     <tr class="BarraDocumentos" style="height:50px;Important!"> <td align="center"> &nbsp; </td> </tr>
                     <tr class="BarraDocumentos" style="height:50px;Important!"> <td align="center"> &nbsp; </td> </tr>
                     <tr class="BarraDocumentos" style="height:50px;Important!"> <td align="center"> &nbsp; </td> </tr>
                     <tr class="BarraDocumentos" style="height:50px;Important!"> <td align="center"> &nbsp; </td> </tr>
                    </table>';
        }

    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: sincronizarestados
    // Creación: 04/03/2025		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que actualiza el campo esempleadoactivo con el campo esempleado 
    //              con los empleados previamente seleccionados
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "sincronizarestados")
    {
        // Construyo la lista de registros que actualizados
        $lista  = "";
        $numeli = 0;

        $vsql = "SELECT terid FROM terceros";
        $conex  = $clase->Conectar();
        $result = mysql_query($vsql,$conex);
        while($row = mysql_fetch_array($result)) 
        {
            if($_POST['LIN-'.$row['terid']] == "S")
            {
                $lista.= $row['terid'].",";
                $numeli++;
            }
        }
        $lista = substr($lista, 0, -1);

        // actualizo los registros
        $clase->EjecutarSQL("UPDATE terceros SET esempleadoactivo = 'CHECKED' WHERE terid IN (".$lista.")");

        // Emito el mensaje correspondiente
        if(mysql_affected_rows() >= 1)
            $clase->Aviso(1,"$numeli empleados sincronizados");
        else
            $clase->Aviso(3,"No se sincronizaron empleados");

        // Redirecciono el formulario
        header("Location: empleadosperiodo.php?opcion=ventanasincronizacion");
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: bajardesincronizados
    // Creación: 05/03/2025		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que emite la salida a Excel para los empleados desincronizados
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "bajardesincronizados")
    {
        // consulta de la vista
        $vsql = "SELECT terid, dni, codvende, CONCAT(primernombre,' ',segundonombre,' ',primerapellido,' ',segundoapellido) nombres, esempleado, esempleadoactivo 
                   FROM terceros 
                  WHERE basico > 0 
                        AND esempleado = 'CHECKED' 
                        AND esempleadoactivo = ''";
                        
        // Preparo el entorno
        require_once 'lib/PHPExcel.php';
        $clase = new Sistema();
        $clase->Conectar();
        ini_set("memory_limit","100M");
        
        // Preparación del entorno para la salida a Excel
        $clase = new Sistema();
        $clase->Nombredb = $_SESSION['DBNOMBRE'];
        error_reporting(E_ALL);
        ini_set('display_errors', TRUE);
        ini_set('display_startup_errors', TRUE);
        date_default_timezone_set('Europe/London');
    
        if (PHP_SAPI == 'cli')
            die('This example should only be run from a Web Browser');
    
        // Create new PHPExcel object
        $objPHPExcel = new PHPExcel();
    
        // Set document properties
        $objPHPExcel->getProperties()->setCreator("Sistemas y Soluciones Web de Colombia")
                                     ->setLastModifiedBy("Sistemas y Soluciones Web de Colombia")
                                     ->setTitle("empleados desincronizados - DROPOS")
                                     ->setSubject("empleados desincronizados - DROPOS")
                                     ->setDescription("empleados desincronizados - DROPOS")
                                     ->setKeywords("empleados desincronizados - DROPOS")
                                     ->setCategory("Categoria General");

        $objPHPExcel->setActiveSheetIndex(0)
                    ->setCellValue('A1', 'SINCRONIZACION DE EMPLEADOS')  
                    ->setCellValue('A3', 'CEDULA')
                    ->setCellValue('B3', 'CODIGO')
                    ->setCellValue('C3', 'NOMBRE')
                    ->setCellValue('D3', 'EMPLEADO')
                    ->setCellValue('E3', 'ACTIVO NOMINA');

        $objPHPExcel->getActiveSheet()->getColumnDimension('A')->setAutoSize(true);                 $objPHPExcel->getActiveSheet()->getColumnDimension('B')->setAutoSize(true);
        $objPHPExcel->getActiveSheet()->getColumnDimension('C')->setAutoSize(true);                 $objPHPExcel->getActiveSheet()->getColumnDimension('D')->setAutoSize(true);
        $objPHPExcel->getActiveSheet()->getColumnDimension('E')->setAutoSize(true);

        // Inmovilizar paneles
        $objPHPExcel->getActiveSheet(0)->freezePaneByColumnAndRow(0,4);

        $conex  = $clase->Conectar();
        $result = mysql_query($vsql,$conex);
        $cant   = mysql_num_rows($result);
        $i = 4;
        while($row = mysql_fetch_array($result))
        {
            $codvende = $row['codvende'];
            $esempleado = $row['esempleado'];
            $esempleadoactivo = $row['esempleadoactivo'];

            if(substr($codvende,0,1) == "0")
                $codvende = "'".$codvende;

            $objPHPExcel->setActiveSheetIndex(0)
                        ->setCellValue('A'.$i, $row['dni'])
                        ->setCellValue('B'.$i, $codvende)
                        ->setCellValue('C'.$i, $row['nombres'])
                        ->setCellValue('D'.$i, $esempleado)
                        ->setCellValue('E'.$i, $esempleadoactivo);
            $i++;
        }

        $rangoEncabezado = 'A4:E4';
        $rangoCeldas     = 'A4:E'.($i-1);

        // ----------------------------------------------------------------------------------------------------------------------------------------------------------- //        
        // Formato de Encabezado y Celdas
        $objPHPExcel->getActiveSheet()->getRowDimension('1')->setRowHeight(15);
        
        $EstiloCeldas = array(
        'borders' => array(
            'allborders' => array(
                'style' => PHPExcel_Style_Border::BORDER_THIN,
                'color' => array('argb' => '00000000'),
            ),
            ),
        );
        // $objPHPExcel->getActiveSheet()->getStyle($rangoCeldas)->applyFromArray($EstiloCeldas);
        /// Formato de Encabezados 
        $EstiloEncabezado = array(
        'font' => array(
            'bold' => true,
        ),
        'alignment' => array(
            'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,
            'vertical' => PHPExcel_Style_Alignment::VERTICAL_CENTER,
        ),
        'borders' => array(
            'allborders' => array(
                'style' => PHPExcel_Style_Border::BORDER_THIN,
                'color' => array('argb' => '00000000'),
            ),
        ),
        'fill' => array(
            'type' => PHPExcel_Style_Fill::FILL_SOLID,
            'rotation' => 90,
            'startcolor' => array(
                'argb' => '00FFFFCC',
            ),
            'endcolor' => array(
                'argb' => 'FFFFFF',
            ),
            ),
        );
        // $objPHPExcel->getActiveSheet()->getStyle($rangoEncabezado)->applyFromArray($EstiloEncabezado);
        // Rename worksheet
        $objPHPExcel->getActiveSheet()->setTitle('empleados desincronizados');
        // Set active sheet index to the first sheet, so Excel opens this as the first sheet
        $objPHPExcel->setActiveSheetIndex(0);
        // Redirect output to a client’s web browser (Excel5)
        header('Content-Type: application/vnd.ms-excel');
        // --------------------------------------------------------------------- //
        $nombrearcexcel = "empleados desincronizados.xls";
        header('Content-Disposition: attachment;filename='.$nombrearcexcel.'');
        // --------------------------------------------------------------------- //
        header('Cache-Control: max-age=0');
        /// Genero la Salida
        $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');
        $objWriter->save('php://output');
        exit;
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Función validateDate
    // Parámetro de entrada:    $d    --> Fecha    
    // Valor de retorno:        $date --> Verdadero o falso
    // Descripción: Función que valida el formato de la fecha
    ////////////////////////////////////////////////////////////////////////////////////////
    function validateDate($date, $format = 'Y-m-d')
    {
        $d = DateTime::createFromFormat($format, $date);
        return $d && $d->format($format) == $date;
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Función fechayhoraejecucion
    // Parámetro de entrada:    Ninguno
    // Valor de retorno:        $fechoraimp --> día, fecha y hora
    // Descripción: Función que devuelve la fecha con día, fecha y hora de ejecución del 
    //              último proceso
    ////////////////////////////////////////////////////////////////////////////////////////
    function fechayhoraejecucion()
    {
        $mesimp = date('F');
        if($mesimp == "January")       $mesimp = "enero";
        if($mesimp == "February")      $mesimp = "febrero";
        if($mesimp == "March")         $mesimp = "marzo";
        if($mesimp == "April")         $mesimp = "abril";
        if($mesimp == "May")           $mesimp = "mayo";
        if($mesimp == "June")          $mesimp = "junio";
        if($mesimp == "July")          $mesimp = "julio";
        if($mesimp == "August")        $mesimp = "agosto";
        if($mesimp == "September")     $mesimp = "septiembre";
        if($mesimp == "October")       $mesimp = "octubre";
        if($mesimp == "November")      $mesimp = "noviembre";
        if($mesimp == "December")      $mesimp = "diciembre";

        $dayweek = date("l");
        if($dayweek == "Monday")       $dayweek = "lunes";
        if($dayweek == "Tuesday")      $dayweek = "martes";
        if($dayweek == "Wednesday")    $dayweek = "miércoles";
        if($dayweek == "Thursday")     $dayweek = "jueves";
        if($dayweek == "Friday")       $dayweek = "viernes";
        if($dayweek == "Saturday")     $dayweek = "sábado";
        if($dayweek == "Sunday")       $dayweek = "domingo";

        $fechoraimp = "proceso ejecutado el ".$dayweek." ".date('d')." de ".$mesimp." de ".date('Y')." a las ".date('g:i a');
        return($fechoraimp);
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Función pasearetiro
    // Parámetro de entrada:    $terid --> Id del empleado
    //                          $fecingreso --> Fecha de ingreso
    // Valor de retorno:        Ninguno
    // Descripción: Función que pasa a retiro al empleado cuando tiene en blanco el campo 
    //              esempleadoactivo
    ////////////////////////////////////////////////////////////////////////////////////////
    function pasearetiro($terid,$fecingreso,$fecretiro)
    {
        $clase2 = new Sistema();
        // $fecretiro = date("Y-m-d");

        // Determino qué condición de empleado posee
        $cargoid = $clase2->BDLockup($terid,'terceros','terid','cargoid');
        $extralegal = $clase2->BDLockup($terid,'terceros','terid','extralegal');
        $esempleadoactivo = $clase2->BDLockup($terid,'terceros','terid','esempleadoactivo');
        $basico = $clase2->BDLockup($terid,'terceros','terid','basico');
        $idcondicionact = $clase2->BDLockup($terid,'terceros','terid','idcondicion');

        if($idcondicionact == 0)
        {
            $idcondicion = 0;
    
            if($cargoid==70)
                $idcondicion = 1;
            elseif($cargoid==71)
                $idcondicion = 2;
            elseif(($extralegal=="CHECKED")&&($esempleadoactivo=="CHECKED"))
                $idcondicion = 3;
            elseif(($extralegal!="CHECKED")&&($esempleadoactivo=="CHECKED"))
                $idcondicion = 4;
        }
        else
            $idcondicion = $idcondicionact; 

        $lb_valido = false;
        $lb_valido = compararfecha($fecingreso,$fecretiro);   // llamado al procedimiento de validación de la fecha

        if($lb_valido)
        {
            // Cambio el estatus de empleado en la tabla terceros
            $esempleado = "";
            $esempleadoactivo = "";
            $enliquidacion = "CHECKED";            

            $vsql = "UPDATE terceros SET 
                            esempleado = '".$esempleado."',
                            esempleadoactivo = '".$esempleadoactivo."',                            
                            enliquidacion = '".$enliquidacion."',
                            idcondicion = ".$idcondicion."
                      WHERE terid = ".$terid;
            $clase2->EjecutarSQL($vsql);

            // Calculo el nuevo ID del histórico de contrato
            $vsql = "SELECT MAX(id) FROM histcontrato";
            $numid = $clase2->SeleccionarUno($vsql);
            $numid++;

            $vsql = "INSERT INTO histcontrato (id,terid,fecingreso,fecretiro,ultsueldo,idcondicion) VALUES (".$numid.",".$terid.",'".$fecingreso."','".$fecretiro."',".$basico.",".$idcondicion.")";
            $clase2->EjecutarSQL($vsql);
            
            // Elimino el empleado de la tabla de enlace sección terceros
            $vsqld = "DELETE FROM seccionterceros WHERE terid = ".$terid;
            $clase2->EjecutarSQL($vsqld);

            $cal_libranza = $_SESSION['G_CAL_LIBRANZA'];
            $cal_permanente = $_SESSION['G_CAL_PERMANENTE'];
            
            // ---------------------------------------------------------------------------------------------------------------------------------------- //
            // Deshabilito las libranzas que este empleado pueda tener
            if($cal_libranza=="CHECKED")
            {
                $totalcuotas = 0;
                $libranzaid = 0;
                $cant = 0;
    
                $vsql2 = "SELECT libranzaid, totalcuotas 
                            FROM libranzas 
                           WHERE terid = ".$terid." AND cuotaspagadas < totalcuotas";

                $conex  = $clase2->Conectar();
                $result2 = mysql_query($vsql2,$conex);
                $cant   = mysql_num_rows($result2);
                if($cant>0)
                {
                    while($row2 = mysql_fetch_array($result2))
                    {
                        $totalcuotas = $row2['totalcuotas'];
                        $libranzaid = $row2['libranzaid'];
    
                        $vsql = "UPDATE libranzas SET 
                                        cuotaspagadas = ".$totalcuotas."
                                  WHERE libranzaid = ".$libranzaid;
                        $clase2->EjecutarSQL($vsql);
                    }
                }
            }

            // Deshabilito los descuentos permanentes que este empleado pueda tener
            if($cal_permanente=="CHECKED")
            {
                $cant = 0;
                $permanenteid = 0;
    
                $vsql3 = "SELECT permanenteid 
                            FROM descuentospermanente 
                           WHERE terid = ".$terid;
                $conex  = $clase2->Conectar();
                $result3 = mysql_query($vsql3,$conex);
                $cant   = mysql_num_rows($result3);
                if($cant>0)
                {
                    while($row3 = mysql_fetch_array($result3))
                    {
                        $permanenteid = $row3['permanenteid'];
                        $vsql4 = "DELETE FROM descuentospermanente WHERE permanenteid = ".$permanenteid;
                        $clase2->EjecutarSQL($vsql4);
                    }
                }
            }
        }
        return(true);
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Función pasearetironuevoingreso
    // Parámetro de entrada:    $dni        --> Documento del empleado
    //                          $fecingreso --> Fecha de ingreso
    // Valor de retorno:        Ninguno
    // Descripción: Función que pasa a retiro al empleado cuando tiene en blanco el campo 
    //              esempleadoactivo para un empleado que fue ingresado en el periodo
    ////////////////////////////////////////////////////////////////////////////////////////    
    function pasearetironuevoingreso($dni,$fecingreso,$fecretiro)
    {
        $clase2 = new Sistema();
        
        // determino el terid del empleado
        $terid = $clase2->BDLockup($dni,'terceros','dni','terid');

        // Determino qué condición de empleado posee
        $cargoid = $clase2->BDLockup($terid,'terceros','terid','cargoid');
        $extralegal = $clase2->BDLockup($terid,'terceros','terid','extralegal');
        $esempleadoactivo = $clase2->BDLockup($terid,'terceros','terid','esempleadoactivo');
        $basico = $clase2->BDLockup($terid,'terceros','terid','basico');
        $idcondicionact = $clase2->BDLockup($terid,'terceros','terid','idcondicion');

        if($idcondicionact == 0)
        {
            $idcondicion = 0;
    
            if($cargoid==70)
                $idcondicion = 1;
            elseif($cargoid==71)
                $idcondicion = 2;
            elseif(($extralegal=="CHECKED")&&($esempleadoactivo=="CHECKED"))
                $idcondicion = 3;
            elseif(($extralegal!="CHECKED")&&($esempleadoactivo=="CHECKED"))
                $idcondicion = 4;
        }
        else
            $idcondicion = $idcondicionact; 

        $lb_valido = false;
        $lb_valido = compararfecha($fecingreso,$fecretiro);   // llamado al procedimiento de validación de la fecha

        if($lb_valido)
        {
            // Cambio el estatus de empleado en la tabla terceros
            $esempleado = "";
            $esempleadoactivo = "";
            $enliquidacion = "CHECKED";            

            $vsql = "UPDATE terceros SET 
                            esempleado = '".$esempleado."',
                            esempleadoactivo = '".$esempleadoactivo."',                            
                            enliquidacion = '".$enliquidacion."',
                            idcondicion = ".$idcondicion."
                      WHERE terid = ".$terid;
            $clase2->EjecutarSQL($vsql);

            // Calculo el nuevo ID del histórico de contrato
            $vsql = "SELECT MAX(id) FROM histcontrato";
            $numid = $clase2->SeleccionarUno($vsql);
            $numid++;

            $vsql = "INSERT INTO histcontrato (id,terid,fecingreso,fecretiro,ultsueldo,idcondicion) VALUES (".$numid.",".$terid.",'".$fecingreso."','".$fecretiro."',".$basico.",".$idcondicion.")";
            $clase2->EjecutarSQL($vsql);
            
            // Elimino el empleado de la tabla de enlace sección terceros
            $vsqld = "DELETE FROM seccionterceros WHERE terid = ".$terid;
            $clase2->EjecutarSQL($vsqld);

            $cal_libranza = $_SESSION['G_CAL_LIBRANZA'];
            $cal_permanente = $_SESSION['G_CAL_PERMANENTE'];
            
            // ---------------------------------------------------------------------------------------------------------------------------------------- //
            // Deshabilito las libranzas que este empleado pueda tener
            if($cal_libranza=="CHECKED")
            {
                $totalcuotas = 0;
                $libranzaid = 0;
                $cant = 0;
    
                $vsql2 = "SELECT libranzaid, totalcuotas 
                            FROM libranzas 
                           WHERE terid = ".$terid." AND cuotaspagadas < totalcuotas";

                $conex  = $clase2->Conectar();
                $result2 = mysql_query($vsql2,$conex);
                $cant   = mysql_num_rows($result2);
                if($cant>0)
                {
                    while($row2 = mysql_fetch_array($result2))
                    {
                        $totalcuotas = $row2['totalcuotas'];
                        $libranzaid = $row2['libranzaid'];
    
                        $vsql = "UPDATE libranzas SET 
                                        cuotaspagadas = ".$totalcuotas."
                                  WHERE libranzaid = ".$libranzaid;
                        $clase2->EjecutarSQL($vsql);
                    }
                }
            }

            // Deshabilito los descuentos permanentes que este empleado pueda tener
            if($cal_permanente=="CHECKED")
            {
                $cant = 0;
                $permanenteid = 0;
    
                $vsql3 = "SELECT permanenteid 
                            FROM descuentospermanente 
                           WHERE terid = ".$terid;
                $conex  = $clase2->Conectar();
                $result3 = mysql_query($vsql3,$conex);
                $cant   = mysql_num_rows($result3);
                if($cant>0)
                {
                    while($row3 = mysql_fetch_array($result3))
                    {
                        $permanenteid = $row3['permanenteid'];
                        $vsql4 = "DELETE FROM descuentospermanente WHERE permanenteid = ".$permanenteid;
                        $clase2->EjecutarSQL($vsql4);
                    }
                }
            }
        }
        return(true);
    }    

    ////////////////////////////////////////////////////////////////////////////////////////
    // Función compararfecha
    // Parámetro de entrada:    $ad_desde --> fecah desde
    //                          $ad_hasta --> fecha hasta
    // Valor de retorno:        $lb_fechavalida --> fecha valida (true or false)
    // Descripción: Función que determina si la fecha de inicio es menor a la fecha final
    ////////////////////////////////////////////////////////////////////////////////////////
    function compararfecha($ad_desde,$ad_hasta)
    {
        $lb_fechavalida=false;
        $ld_desdeaux = convert_date($ad_desde);
        $ld_hastaaux = convert_date($ad_hasta);
          
        if(($ld_desdeaux=="")||($ld_hastaaux==""))
        {
            $lb_fechavalida=false;
        }
        else
        {
            $ld_anod= substr($ld_desdeaux,0,4);
            $ld_mesd= substr($ld_desdeaux,5,2);
            $ld_diad= substr($ld_desdeaux,8,2);
            $ld_anoh= substr($ld_hastaaux,0,4);
            $ld_mesh= substr($ld_hastaaux,5,2);
            $ld_diah= substr($ld_hastaaux,8,2);
              
            if($ld_anod<$ld_anoh)
                {$lb_fechavalida=true;}
            elseif($ld_anod==$ld_anoh)
            {
                if($ld_mesd<$ld_mesh)
                    {$lb_fechavalida=true;}
                elseif($ld_mesd==$ld_mesh)
                {
                    if($ld_diad<=$ld_diah)
                        {$lb_fechavalida=true;}
                }
            }
        }
        return $lb_fechavalida;
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Función compararfecha
    // Parámetro de entrada:    $as_cadena --> cadena de la fecha    
    // Valor de retorno:        $ls_fecreg --> fecha covertida
    // Descripción: Función que convierte un formato de fecha
    ////////////////////////////////////////////////////////////////////////////////////////
    function convert_date($as_cadena)
    {
        $ls_fecreg=""; 
        $li_pos=strpos($as_cadena,"/");
        $li_pos2=strpos($as_cadena,"-");
        
        if(($li_pos==2)||($li_pos2==2))
        {
            $ls_fecreg=(substr($as_cadena,6,4)."-".substr($as_cadena,3,2)."-".substr($as_cadena,0,2)); 
        }
        elseif(($li_pos==4)||($li_pos2==4))
        {
            $ls_fecreg=$as_cadena;
        }
        return $ls_fecreg;
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Función actualizaseccion
    // Parámetro de entrada:    $terid --> Id del empleado
    //                          $seccionid --> Id de la sección
    // Valor de retorno:        Ninguno
    // Descripción: Función que actualiza la tabla seccionterceros para el registro de 
    //              secciones y empleados
    ////////////////////////////////////////////////////////////////////////////////////////    
    function actualizaseccion($terid,$seccionid)
    {
        $clase2 = new Sistema();

        // Inicialización de variables
        $vsql2 = "";                        $repetido = 0;                      $vsql3 = "";
        $tieneseccion = 0;                  $vsql4 = "";                        $eslider = 0;
        $idlider = 0;                       $vsql5 = "";                        $vsql6 = "";
        $vsql = "";                         $secciontercerosid = 0;             $vsql7 = "";

        // Valido que el empleado ya existe como miembro de esta sección
        $vsql2 = "SELECT COUNT(*) AS repetido FROM seccionterceros WHERE terid = ".$terid." AND seccionid = ".$seccionid;
        $repetido = $clase2->SeleccionarUno($vsql2);

        if($repetido == 0)
        {
            // Valido que el empleado no sea líder de una sección
            $vsql4 = "SELECT COUNT(*) AS eslider FROM seccion WHERE idlider = ".$terid." AND seccionid <> ".$seccionid;
            $eslider = $clase2->SeleccionarUno($vsql4);

            if($eslider > 0)
            {
                // Proceso a removerlo como líder de otra sección
                $idlider = 0;

                // Almaceno la modificación
                $vsql5 = "UPDATE seccion SET 
                                 idlider = ".$idlider."
                           WHERE seccionid = ".$seccionid;
                $clase2->EjecutarSQL($vsql5);
            }

            // Valido que pertenezca a alguna sección
            $vsql6 = "SELECT COUNT(*) AS tieneseccion FROM seccionterceros WHERE terid = ".$terid;
            $tieneseccion = $clase2->SeleccionarUno($vsql6);

            if($tieneseccion == 0)
            {
                // Procedo a incluirlo

                // Obtengo el número de registros de la tabla seccionterceros
                $vsql7 = "SELECT MAX(secciontercerosid) FROM seccionterceros";
                $secciontercerosid = $clase2->SeleccionarUno($vsql7);

                // Incremento el ID
                $secciontercerosid++;

                $vsql = "INSERT INTO seccionterceros (secciontercerosid,seccionid,terid) VALUES ($secciontercerosid,".$seccionid.",".$terid.")";
                $clase2->EjecutarSQL($vsql);
            }
            else
            {
                // Procedo a cambiarlo de sección
                if($tieneseccion == 1)
                {
                    $vsql = "UPDATE seccionterceros SET 
                                    seccionid = ".$seccionid." 
                              WHERE terid = ".$terid;
                    $clase2->EjecutarSQL($vsql);
                }
            }
        }
        return(true);
    }

    // ------------------------------------ //
    echo $cont.$clase->PiePagina();
?>