<?PHP
    @session_start();
    include("lib/Sistema.php");
  
    $clase = new Sistema();
    $clase->Nombredb = $_SESSION['DBNOMBRE'];
    $avisos = ""; 
    $opcion = "";
    $opcion = $_GET["opcion"];

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: ventanadatos
    // Creación: 04/03/2022		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que pinta la ventana principal del informe
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "ventanadatos")
    {
        $params = ' class="Texto11" ';
        $vsqlcomboperiodo  = "SELECT codperiodo, desperiodo FROM periodos WHERE anoperiodo >= 2022 AND mesperiodo >=2 ORDER BY orden";
    
        $cont = $clase->Header("S","W");
        $cont.='<table width="100%">
                 <tr class="CabezoteTabla"> 
                  <td width="10"> &nbsp; </td>
                  <td width="37"> <img src="images/iconos/clientes.png" width="32" height="32" border="0"> </td>
                  <td width="840"> <b> Dotaciones por periodo </b></td>
                  <td> &nbsp; </td>
                  <td width="8"> &nbsp; </td>
                 </tr>           
                </table>';
        
        $cont.='<form action="?opcion=infdotaxper" method="POST" name="x" target="_blank">
                 <center>
                 <table width="100%">
                  <tr class="BarraDocumentos">
                   <td align="center"><br><br><b> Datos del informe <br><br></td>
                  </tr>
                 </table>  
                 <table width="100%">
                  <tr class="BarraDocumentos"> 
                   <td width="220"> &nbsp; </td>
                   <td width="20"> Periodo: </td>
                   <td width="120">';

        $cont.= $clase->CrearComboBuscar("codperiodo",$vsqlcomboperiodo,"desperiodo","codperiodo","","N",$params,400);
                    
        $cont.='   </td> 
                   <td width="220"> &nbsp; </td>
                  </tr>                  
                  <tr class="BarraDocumentos"> 
                   <td width="220"> &nbsp; </td>
                   <td width="20"> Tipo: </td>
                   <td width="120">
                    <SELECT name="tiponomina" id="tiponomina" style="width:120px;height:20px">
                     <option value="todos" SELECTED> Todos </option>               
                     <option value="empleados"> Empleados </option>               
                     <option value="extralegal"> Extralegal </option>
                    </SELECT>
                   </td> 
                   <td width="220"> &nbsp; </td>
                  </tr>
                 </table>                   
                 <table width="100%">                     
                  <tr class="BarraDocumentos"> 
                   <td width="371" height="50" align="center">&nbsp;  </td>      
                   <td width="164" height="50" align="center"> <input type="submit" value="vista" class="button blue" name="tiposalida"></td>
                   <td width="131" height="50" align="center"> <input type="submit" value="pdf" class="button red" name="tiposalida"></td>
                   <td width="185" height="50" align="center"> <input type="submit" value="excel" class="button blue" name="tiposalida"></td> 
                   <td width="380" height="50" align="center">&nbsp;  </td>
                  </tr>
                 </table> 
                </form>';

        $cont.='<table width="100%"> 
                 <tr class="BarraDocumentos"> <td align="center">&nbsp;</td> </tr>
                 <tr class="BarraDocumentos"> <td align="center">&nbsp;</td> </tr>
                 <tr class="BarraDocumentos"> <td align="center">&nbsp;</td> </tr>
                 <tr class="BarraDocumentos"> <td align="center">&nbsp;</td> </tr>
                 <tr class="BarraDocumentos"> <td align="center">&nbsp;</td> </tr>
                 <tr class="BarraDocumentos"> <td align="center">&nbsp;</td> </tr>
                 <tr class="BarraDocumentos"> <td align="center">&nbsp;</td> </tr>
                 <tr class="BarraDocumentos"> <td align="center">&nbsp;</td> </tr>
                </table>';
        echo $cont;
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: infdotaxper
    // Creación: 04/03/2022		última modificación: 01/09/2022
    // Creador: Luis Flórez		modificado por: Luis Flórez
    // Descripción: Opción que genera el informe de dotaciones por periodo de acuerdo al  
    //              tipo de salida seleccionado
    // Última modificación: salidas en html y pdf (08/03/2022)
    //                      Botones para eliminar y editar dotaciones
    ////////////////////////////////////////////////////////////////////////////////////////            
    if($opcion=="infdotaxper")
    {
        $codperiodo  = $_POST['codperiodo'];    // Variable para filtrar el periodo
        $tiposalida = $_POST["tiposalida"];     // Variable que indica qué tipo de informe se mostrará
        $tiponomina = $_POST["tiponomina"];     // Variable para el tipo de nómina

        // Variable para el nombre del periodo
        $desperiodo = $clase->BDLockup($codperiodo,'periodos','codperiodo','desperiodo');

        // Valido que el periodo tenga datos para emitir el reporte
        $vsqldatos = "SELECT COUNT(*) AS numreg 
                        FROM dotaciones 
                       WHERE periodonomina = '".$codperiodo."'";
        $numreg = $clase->SeleccionarUno($vsqldatos);

        if($numreg==0)
        {
            $clase->Aviso(3,"No existen dotaciones en el periodo $desperiodo");
            header("Location: dotacionesxperiodo.php?opcion=ventanadatos");
        }
        else
        {
            // Consulta del informe
            $vsql = "SELECT t.dni, CONCAT(t.primernombre,' ',t.segundonombre,' ',t.primerapellido,' ',t.segundoapellido) AS nombreemp, d.monto, d.iddotacion                            
                       FROM terceros t
                            INNER JOIN dotaciones d ON (t.terid = d.terid)
                      WHERE d.periodonomina = '".$codperiodo."'";

            // Tipo de empleados
            switch($tiponomina)
            {
                case 'empleados':
                    $vsql.= " AND (t.extralegal = '' OR t.extralegal IS NULL) ";
                    break;
                case 'extralegal':
                    $vsql.= " AND t.extralegal = 'CHECKED' ";
                    break;
                // case 'todos':
                //     $vsql.= " AND t.esempleadoactivo='CHECKED' ";
                //     break;
                default:
                    break;
            }

            // Salida en vista html
            if($tiposalida=="vista")
            {
                $cont = $clase->Header("S","W");
                $cont.='<table width="100%">
                         <tr class="CabezoteTabla"> 
                          <td width="10"> &nbsp; </td>
                          <td width="37"> <img src="images/iconos/clientes.png" width="32" height="32" border="0"> </td>
                          <td width="840"> <b> Dotaciones por periodo </b></td>
                          <td> &nbsp; </td>
                          <td width="8"> &nbsp; </td>
                         </tr>
                         <tr class="CabezoteTabla"> 
                          <td width="10"> &nbsp; </td>
                          <td width="37"> &nbsp; </td>
                          <td width="840"> <b> Periodo:</b> '.$desperiodo.' <b>Tipo:</b> '.strtoupper($tiponomina).' </td>
                          <td> &nbsp; </td>
                          <td width="8"> &nbsp; </td>
                         </tr>
                        </table>';

                $cont.='<script type="text/javascript" src="lib/sorttable.js"></script>
                        <table width="100%" class="sortable">
                         <thead> 
                          <tr class="TituloTabla" style="display:block;padding-top:5px;height:25px;">
                           <td width="23">&nbsp;</td>                           
                           <td width="143" align="left"><p>Documento</p></td>
                           <td width="794" align="left">Nombre </td>			
                           <td width="184" align="right">Monto </td>			
                           <td width="46">&nbsp;</td>
                           <td width="26">&nbsp;</td>
                          </tr>
                         </thead>
                         <tbody style="display:block; width:1050px; height:600px; overflow-Y:scroll">';

                $i = 0;
                $totalpagado = 0;
                $conex  = $clase->Conectar();
                $result = mysql_query($vsql,$conex);
                while($row = mysql_fetch_array($result))
                {
                    $i++;
                    if($i%2 == 0)
                        $cont.='<tr class="TablaDocsPar">';
                    else
                        $cont.='<tr class="TablaDocsImPar">';

                    $cont.=' <td width="23">&nbsp;</td>
                             <td width="133" align="left">'.$row['dni'].'</td>
                             <td width="784" align="left">'.$row['nombreemp'].' </td>';

                    // Validación de las rutinas de eliminación y edición de dotaciones
                    if(($_SESSION['USERNAME'] == "LFLOREZ")||($_SESSION['USERNAME'] == "SAIDRODRIGUEZ"))
                        $cont.=' <td width="20" align="center">
                                  <a href="?opcion=valborrardota&nombreemp='.$row['nombreemp'].'&monto='.$row['monto'].'&iddotacion='.$row['iddotacion'].'" rel="facebox" title="eliminar dotaci&oacute;n">
                                   <img src="images/basicas/iconoborrar.png" border="0">
                                  </a>
                                 </td>
                                 <td width="20" align="center">
                                  <a href="?opcion=editardota&nombreemp='.$row['nombreemp'].'&monto='.$row['monto'].'&iddotacion='.$row['iddotacion'].'" title="modificar dotaci&oacute;n" rel="facebox">
                                   <img src="images/basicas/iconobuscar.png" border="0">
                                  </a>
                                 </td>';
                    else
                        $cont.=' <td width="20" align="center"> &nbsp; </td>
                                 <td width="20" align="center"> &nbsp; </td>';

                    $cont.=' <td width="64" align="right">'.number_format($row['monto']).' </td>
                             <td width="46" align="center"> &nbsp; </td>
                            </tr>';

                    // incremento del total
                    $totalpagado += $row['monto'];
                }

                $cont.=' </tbody> 
                        </table>';

                // impresión del total
                $cont.='<table width="100%">
                         <tr class="TituloTabla"> 
                          <td width="391"> &nbsp; </td>
                          <td width="375" align="right"> &nbsp; </td>
                          <td width="375" align="right"> &nbsp; </td>
                          <td width="375" align="right"> <font color="WHITE"> <b> Total pagado: </b> '.number_format($totalpagado).' </font> </td>
                          <td width="92"> &nbsp; </td>
                         </tr>
                        </table>';

                echo $cont.$clase->PiePagina();
            }

            // vista en formato pdf
            if($tiposalida=="pdf")
            {
                // Traducción al español del mes que devuelve la función date()
                $mesimp = date('F');
                if($mesimp=="January")       $mesimp = "Enero";
                if($mesimp=="February")      $mesimp = "Febrero";
                if($mesimp=="March")         $mesimp = "Marzo";
                if($mesimp=="April")         $mesimp = "Abril";
                if($mesimp=="May")           $mesimp = "Mayo";
                if($mesimp=="June")          $mesimp = "Junio";
                if($mesimp=="July")          $mesimp = "Julio";
                if($mesimp=="August")        $mesimp = "Agosto";
                if($mesimp=="September")     $mesimp = "Septiembre";
                if($mesimp=="October")       $mesimp = "Octubre";
                if($mesimp=="November")      $mesimp = "Noviembre";
                if($mesimp=="December")      $mesimp = "Diciembre";

                $clase = new Sistema();
                ini_set("memory_limit","200M");
                require('lib/fpdf/fpdf.php');
                $pdf=new FPDF();

                $pdf->AddPage("");

                // Logo Dromedicas
                $pdf->Image('images/empresa/logo-dromedicas-en-azul.png',10,10,20,25,'PNG','');

                $x = 35;
                $y = 15;
                $pagina = 1;

                $pdf->SetFont('Arial','B',10);
                $enc= "DROMEDICAS DEL ORIENTE SAS - NIT: 900265730-0";
                $pdf->Text($x,$y,$enc);

                // Fecha y hora de impresión
                $fechoraimp = $mesimp." ".date('d')." de ".date('Y g:i a')."    Pagina: ".$pagina;

                $pdf->SetFont('Arial','',8);
                $pdf->Text($x+110,$y,$fechoraimp);

                $pdf->SetFont('Arial','B',10);
                $enc= "DOTACIONES EN EL PERIODO ".$desperiodo;
                $pdf->Text($x,$y+7,$enc);
                $enc= "TIPO: ".strtoupper($tiponomina);
                $pdf->Text($x,$y+14,$enc);

                $pdf->SetFillColor(220,220,220);
                $pdf->Rect(7,$y+28,195,8,'F');

                $enc= "DOCUMENTO";
                $pdf->Text(9,$y+33,$enc);

                $enc= "NOMBRE";
                $pdf->Text(38,$y+33,$enc);

                $enc= "MONTO";
                $pdf->Text(185,$y+33,$enc);

                $pdf->SetFont('Arial','',8);

                // inicialización de variables
                $x = 9;
                $y = 56;
                $i = 0;

                $conex  = $clase->Conectar();
                $result = mysql_query($vsql,$conex);
                while($row = mysql_fetch_array($result))
                {
                    $i++;

                    // Impresión de documento y nombre
                    $pdf->Text($x,$y,$row['dni']);
                    $pdf->Text($x+28,$y,$row['nombreemp']);

                    // impresión del monto
                    $longitud = strlen($row['monto']);
                    if($longitud==1)    $pdf->Text($x+189,$y,number_format($row['monto']));
                    if($longitud==2)    $pdf->Text($x+187,$y,number_format($row['monto']));
                    if($longitud==3)    $pdf->Text($x+185,$y,number_format($row['monto']));
                    if($longitud==4)    $pdf->Text($x+183,$y,number_format($row['monto']));
                    if($longitud==5)    $pdf->Text($x+181,$y,number_format($row['monto']));
                    if($longitud==6)    $pdf->Text($x+179,$y,number_format($row['monto']));
                    if($longitud==7)    $pdf->Text($x+177,$y,number_format($row['monto']));

                    // salto de línea
                    $y+=6;

                    // incremento del total
                    $totalpagado += $row['monto'];

                    if($i%35 == 0)
                    {
                        $pdf->AddPage("");

                        // Logo Dromedicas
                        $pdf->Image('images/empresa/logo-dromedicas-en-azul.png',10,10,20,25,'PNG','');

                        $x = 35;
                        $y = 15;
                        $pagina++;

                        $pdf->SetFont('Arial','B',10);
                        $enc= "DROMEDICAS DEL ORIENTE SAS - NIT: 900265730-0";
                        $pdf->Text($x,$y,$enc);
        
                        // Fecha y hora de impresión
                        $fechoraimp = $mesimp." ".date('d')." de ".date('Y g:i a')."    Pagina: ".$pagina;
        
                        $pdf->SetFont('Arial','',8);
                        $pdf->Text($x+110,$y,$fechoraimp);
        
                        $pdf->SetFont('Arial','B',10);
                        $enc= "DOTACIONES EN EL PERIODO ".$desperiodo;
                        $pdf->Text($x,$y+7,$enc);
                        $enc= "TIPO: ".strtoupper($tiponomina);
                        $pdf->Text($x,$y+14,$enc);                            
        
                        $pdf->SetFillColor(220,220,220);
                        $pdf->Rect(7,$y+28,195,8,'F');
        
                        $enc= "DOCUMENTO";
                        $pdf->Text(9,$y+33,$enc);
        
                        $enc= "NOMBRE";
                        $pdf->Text(38,$y+33,$enc);
        
                        $enc= "MONTO";
                        $pdf->Text(185,$y+33,$enc);
        
                        $pdf->SetFont('Arial','',8);
        
                        // inicialización de variables
                        $x = 9;
                        $y = 56;
                    }                    
                }
                
                // Impresión del total a pagar
                $y+=6;
                $pdf->SetFont('Arial','B',10);

                $pdf->SetFillColor(220,220,220);
                $pdf->Rect(7,$y-5,195,8,'F');
                
                $longitud = strlen($totalpagado);
                if($longitud==8)     $pdf->Text(150,$y,"TOTAL PAGADO: ".number_format($totalpagado,0));
                if($longitud==9)     $pdf->Text(148,$y,"TOTAL PAGADO: ".number_format($totalpagado,0));
                if($longitud==10)    $pdf->Text(146,$y,"TOTAL PAGADO: ".number_format($totalpagado,0));
                if($longitud==11)    $pdf->Text(144,$y,"TOTAL PAGADO: ".number_format($totalpagado,0));
                if($longitud==12)    $pdf->Text(142,$y,"TOTAL PAGADO: ".number_format($totalpagado,0));                
                if($longitud==13)    $pdf->Text(140,$y,"TOTAL PAGADO: ".number_format($totalpagado,0));

                $pdf->Output();
            }

            // salida a excel
            if($tiposalida=="excel")
            {
                require_once 'lib/PHPExcel.php';
                $clase = new Sistema();
                $clase->Conectar();
                ini_set("memory_limit","100M");

                // Preparación del entorno para la salida a Excel
                $clase = new Sistema();
                $clase->Nombredb = $_SESSION['DBNOMBRE'];
                error_reporting(E_ALL);
                ini_set('display_errors', TRUE);
                ini_set('display_startup_errors', TRUE);
                date_default_timezone_set('Europe/London');
            
                if (PHP_SAPI == 'cli')
                    die('This example should only be run from a Web Browser');
            
                // Create new PHPExcel object
                $objPHPExcel = new PHPExcel();
            
                // Set document properties
                $objPHPExcel->getProperties()->setCreator("Sistemas y Soluciones Web de Colombia")
                                             ->setLastModifiedBy("Sistemas y Soluciones Web de Colombia")
                                             ->setTitle("Dotaciones por periodo - DROPOS")
                                             ->setSubject("Dotaciones por periodo - DROPOS")
                                             ->setDescription("Dotaciones por periodo - DROPOS")
                                             ->setKeywords("Dotaciones por periodo - DROPOS")
                                             ->setCategory("Categoria General");

                // encabezado
                $objPHPExcel->setActiveSheetIndex(0)
                            ->setCellValue('A1', 'DOTACIONES POR PERIODO')
                            ->setCellValue('A2', $desperiodo)
                            ->setCellValue('A3', 'TIPO: '.strtoupper($tiponomina))
                            ->setCellValue('A4', 'DOCUMENTO')
                            ->setCellValue('B4', 'NOMBRE')
                            ->setCellValue('C4', 'MONTO');

                $objPHPExcel->getActiveSheet()->getColumnDimension('A')->setAutoSize(true);
                $objPHPExcel->getActiveSheet()->getColumnDimension('B')->setAutoSize(true);
                $objPHPExcel->getActiveSheet()->getColumnDimension('C')->setAutoSize(true);

                $conex  = $clase->Conectar();
                $result = mysql_query($vsql,$conex);
                $cant   = mysql_num_rows($result);
                $i=5;
                $totalpagado = 0;
                
                // Detalle del informe
                while($row = mysql_fetch_array($result))
                {
                    $objPHPExcel->setActiveSheetIndex(0)
                                ->setCellValue('A'.$i, $row['dni'])
                                ->setCellValue('B'.$i, $row['nombreemp'])
                                ->setCellValue('C'.$i, number_format($row['monto']));

                    $totalpagado += $row['monto'];
                    $i++;

                }

                // Impresión del último total
                $objPHPExcel->setActiveSheetIndex(0)
                            ->setCellValue('A'.$i, '')
                            ->setCellValue('B'.$i, 'TOTAL:')
                            ->setCellValue('C'.$i, number_format($totalpagado));

                $rangoEncabezado = 'A4:C4';
                $rangoCeldas     = 'A4:C'.($i-1);

                // ----------------------------------------------------------------------------------------------------------------------------------------------------------- //                
                // Formato de Encabezado y Celdas
                $objPHPExcel->getActiveSheet()->getRowDimension('1')->setRowHeight(15);
                
                $EstiloCeldas = array(
                'borders' => array(
                    'allborders' => array(
                        'style' => PHPExcel_Style_Border::BORDER_THIN,
                        'color' => array('argb' => '00000000'),
                    ),
                    ),
                );
                // $objPHPExcel->getActiveSheet()->getStyle($rangoCeldas)->applyFromArray($EstiloCeldas);
                /// Formato de Encabezados 
                $EstiloEncabezado = array(
                'font' => array(
                    'bold' => true,
                ),
                'alignment' => array(
                    'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,
                    'vertical' => PHPExcel_Style_Alignment::VERTICAL_CENTER,		
                ),
                'borders' => array(
                    'allborders' => array(
                        'style' => PHPExcel_Style_Border::BORDER_THIN,
                        'color' => array('argb' => '00000000'),
                    ),
                ),
                'fill' => array(
                    'type' => PHPExcel_Style_Fill::FILL_SOLID,
                    'rotation' => 90,
                    'startcolor' => array(
                        'argb' => '00FFFFCC',
                    ),
                    'endcolor' => array(
                        'argb' => 'FFFFFF',
                    ),
                    ),
                );
                // $objPHPExcel->getActiveSheet()->getStyle($rangoEncabezado)->applyFromArray($EstiloEncabezado);
                // Rename worksheet
                $objPHPExcel->getActiveSheet()->setTitle('Dotaciones por periodo');
                // Set active sheet index to the first sheet, so Excel opens this as the first sheet
                $objPHPExcel->setActiveSheetIndex(0);
                // Redirect output to a client’s web browser (Excel5)
                header('Content-Type: application/vnd.ms-excel');
                // --------------------------------------------------------------------- //
                // header('Content-Disposition: attachment;filename="planillanom.xls"');
                $nombrearcexcel = "dotaciones del periodo ".strtolower($desperiodo).".xls";
                header('Content-Disposition: attachment;filename='.$nombrearcexcel.'');
                // --------------------------------------------------------------------- //
                header('Cache-Control: max-age=0');
                /// Genero la Salida
                $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');
                $objWriter->save('php://output');
                exit;
            }
        }
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: valborrardota
    // Creación: 31/08/2022		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción para confirmar la eliminación de una dotación
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "valborrardota")
    {
        $nombreemp = $_GET['nombreemp'];
        $monto = $_GET['monto'];
        $iddotacion = $_GET['iddotacion'];

        $cont='<table width="500">
                <tr class="CabezoteTabla"> 
                 <td align="center"><br><b>Eliminar una dotaci&oacute;n</b><br><br></td> 
                </tr> 
               </table>
               <table width="500">
                <tr class="TablaDocsImPar">       
                 <td width="400" align="center">¿Confirma que desea eliminar la dotaci&oacute;n 
                  del empleado(a) <br><b>'.$nombreemp.'</b> <br> por <b>'.number_format($monto).'</b> pesos?
                 </td>
                </tr>
                <tr class="TablaDocsImPar">       
                 <td width="400" align="center"><br><br>                  
                  <form action="?opcion=elimdota&iddotacion='.$iddotacion.'" method="POST">
                  <input type="hidden" name="iddotacion" value="'.$iddotacion.'">
                  <input type="submit" value="ACEPTAR" class="button red">
                  </form>
                  <br>
                 </td>        
                </tr>
               </table><br>';
        echo $cont;
        exit();
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opciones: elimdota
    // Creación: 01/09/2022		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción para eliminar una dotación
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////    
    if($opcion == "elimdota")
    {
        $iddotacion = $_POST['iddotacion'];

        // Elimino el concepto en la tabla detallenomina
        $vsql = "DELETE FROM dotaciones WHERE iddotacion = ".$iddotacion;
        $clase->EjecutarSQL($vsql);

        // Emito el mensaje correspondiente
        if(mysql_affected_rows() >= 1)
            $clase->Aviso(1,"Dotación eliminada satisfactoriamente");
        else
            $clase->Aviso(3,"No se eliminó la dotación");

        // Redirecciono el formulario
        header("Location: dotacionesxperiodo.php?opcion=ventanadatos");
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opciones: editardota
    // Creación: 01/09/2022		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que edita el monto de la dotación
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "editardota")
    {
        $nombreemp = $_GET['nombreemp'];
        $monto = $_GET['monto'];
        $iddotacion = $_GET['iddotacion'];

        $cont='<table width="400">
                <tr class="CabezoteTabla"> 
                 <td align="center"> <b>Editar dotaci&oacute;n</b> </td>                  
                </tr>
                <tr class="CabezoteTabla"> 
                 <td align="center"> Empleado(a): '.$nombreemp.' </td>                  
                </tr>
               </table>
               <form action="?opcion=guardardata" method="POST" name="x">                
               <input type="hidden" name="iddotacion" value="'.$iddotacion.'">                
               <table width="400">
                <center>
                <br>
                <tr class="TablaDocsImPar">				
                 <td width="150" align="right"> Monto: &nbsp;</td> 			  
                 <td width="250"> <input type="number" name="monto" class="Texto12New" size="4" min="1" maxlength="7" autocomplete="off" value="'.$monto.'"></td>
                </tr>
               </table>
               <br><center>
               <input type="submit" value="aceptar" class="button blue">
               </form><br>';
        echo $cont;
        exit();
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opciones: guardardata
    // Creación: 01/09/2022		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que almacena la modificación de la dotación de un empleado
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////    
    if($opcion == "guardardata")
    {
        $monto = $_POST['monto'];
        $iddotacion = $_POST['iddotacion'];

        // Modifico el monto en la tabla detallenomina
        $vsql = "UPDATE dotaciones SET monto = ".$monto." WHERE iddotacion = ".$iddotacion;
        $clase->EjecutarSQL($vsql);

        // Emito el mensaje correspondiente
        if(mysql_affected_rows() >= 1)
            $clase->Aviso(1,"Dotación editada satisfactoriamente");
        else
            $clase->Aviso(3,"No se editó la dotación");

        // Redirecciono el formulario
        header("Location: dotacionesxperiodo.php?opcion=ventanadatos");
    }
?>