<?PHP
    @session_start(); 
    include("lib/Sistema.php");      
    
    $clase = new Sistema();
    $clase->Nombredb = $_SESSION['DBNOMBRE'];  
    $avisos = ""; 
    $opcion = "";
    $opcion = $_GET["opcion"];

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: ventanadatos
    // Creación: 20/01/2022		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que pinta la ventana principal del informe
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "ventanadatos")
    {
        $params = ' class="Texto11" ';
        $vsqlcomboperiodo  = "SELECT codperiodo, desperiodo 
                                FROM periodos 
                               WHERE anoperiodo >= 2022 
                            ORDER BY orden";
    
        $cont = $clase->Header("S","W");
        $cont.='<table width="100%">
                 <tr class="CabezoteTabla"> 
                  <td width="10"> &nbsp; </td>
                  <td width="37"> <img src="images/iconos/infventaspos.png" width="32" height="32" border="0"> </td>
                  <td width="840"> <b> Cesantías canceladas por periodo </b></td>
                  <td> &nbsp; </td>
                  <td width="8"> &nbsp; </td>
                 </tr>           
                </table>';
        
        $cont.='<form action="cesantiasxperiodo.php?opcion=infcesanxper" method="POST" name="x" target="_blank">
                 <center>
                 <table width="100%">
                  <tr class="BarraDocumentos">
                   <td align="center"><br><br><b> Datos del informe <br><br></td>
                  </tr>
                 </table>  
                 <table width="100%">
                  <tr class="BarraDocumentos"> 
                   <td width="220"> &nbsp; </td>
                   <td width="20"> Periodo: </td>
                   <td width="120">'.$clase->CrearComboBuscar("codperiodo",$vsqlcomboperiodo,"desperiodo","codperiodo","","N",$params,400).'</td> 
                   <td width="220"> &nbsp; </td>
                  </tr>                  
                  <tr class="BarraDocumentos"> 
                   <td width="220"> &nbsp; </td>
                   <td width="20"> Tipo: </td>
                   <td width="120">
                    <SELECT name="tiponomina" id="tiponomina" style="width:120px;height:25px">
                     <option value="todos" SELECTED> Todos </option>               
                     <option value="empleados"> Empleados </option>               
                     <option value="extralegal"> Extralegal </option>
                    </SELECT>
                   </td> 
                   <td width="220"> &nbsp; </td>
                  </tr>
                  <tr class="BarraDocumentos"> 
                   <td width="220"> &nbsp; </td>
                   <td width="20"> Reporte: </td>
                   <td width="120">
                    <SELECT name="tiporeporte" id="tiporeporte" style="width:120px;height:25px">
                     <option value="intereses" SELECTED> Intereses </option>               
                     <option value="pagos"> Pagos </option>                      
                    </SELECT>
                   </td> 
                   <td width="220"> &nbsp; </td>
                  </tr>
                 </table>                   
                 <table width="100%">                     
                  <tr class="BarraDocumentos"> 
                   <td width="371" height="50" align="center"> &nbsp; </td>      
                   <td width="164" height="50" align="center"> <input type="submit" value="vista" class="button blue" name="tiposalida"></td>
                   <td width="131" height="50" align="center"> <input type="submit" value="pdf" class="button red" name="tiposalida"></td>
                   <td width="185" height="50" align="center"> <input type="submit" value="excel" class="button blue" name="tiposalida"></td> 
                   <td width="380" height="50" align="center"> &nbsp; </td>
                  </tr>
                 </table> 
                </form>';

        $cont.='<table width="100%"> 
                 <tr class="BarraDocumentos"> <td align="center">&nbsp;</td> </tr>
                 <tr class="BarraDocumentos"> <td align="center">&nbsp;</td> </tr>
                 <tr class="BarraDocumentos"> <td align="center">&nbsp;</td> </tr>
                 <tr class="BarraDocumentos"> <td align="center">&nbsp;</td> </tr>
                 <tr class="BarraDocumentos"> <td align="center">&nbsp;</td> </tr>
                 <tr class="BarraDocumentos"> <td align="center">&nbsp;</td> </tr>
                 <tr class="BarraDocumentos"> <td align="center">&nbsp;</td> </tr>
                 <tr class="BarraDocumentos"> <td align="center">&nbsp;</td> </tr>
                </table>';
        echo $cont;
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: infcesanxper
    // Creación: 20/01/2022		última modificación: 04/02/2023
    // Creador: Luis Flórez		modificado por: Luis Flórez
    // Descripción: Opción que genera el informe de primas por periodo de acuerdo al tipo 
    //              de salida seleccionado
    // Última modificación: Inclusión de las opciones para imprimir según el tipo de reporte 
    //                      (intereses o pagos) (08/03/2022)
    //                      Inclusión d ellos botones para eliminar y editar registros
    //                      (22/09/2022)
    //                      Se modificó la consulta del tipo de informe por intereses 
    //                      añadiendo a los empleados con dos cesantías en el periodo pero 
    //                      que una de ellas es solamente pago de intereses
    ////////////////////////////////////////////////////////////////////////////////////////            
    if($opcion=="infcesanxper")
    {
        $codperiodo = $_POST['codperiodo'];         // Variable para filtrar el periodo        
        $tiposalida = $_POST["tiposalida"];         // Variable que indica qué tipo de informe se mostrará
        $tiponomina = $_POST["tiponomina"];         // Variable para el tipo de nómina
        $tiporeporte = $_POST["tiporeporte"];       // Variable para el tipo de reporte (intereses o pagos)

        // Variable para el nombre del periodo
        $desperiodo = $clase->BDLockup($codperiodo,'periodos','codperiodo','desperiodo');        

        // Valido que el periodo tenga datos para emitir el reporte
        if($tiporeporte=="intereses")
            $vsqldatos = "SELECT COUNT(*) AS numreg 
                            FROM liquidacion 
                           WHERE periodonomina = '".$codperiodo."' 
                                 AND (tipo = 'cesantias' AND pagointereses>0)";
        else
            $vsqldatos = "SELECT COUNT(*) AS numreg 
                            FROM pagocesantias 
                           WHERE periodonomina = '".$codperiodo."'";

        $numreg = $clase->SeleccionarUno($vsqldatos);        

        if($numreg==0)
        {
            $tiporep = strtoupper($tiporeporte);
            $clase->Aviso(3,"No existen cesantías canceladas en el periodo $desperiodo para el reporte $tiporep");
            header("Location: cesantiasxperiodo.php?opcion=ventanadatos");
        }
        else
        {
            // Consulta del informe
            if($tiporeporte=="intereses")
            {
                $vsql = "SELECT t.dni, CONCAT(t.primernombre,' ',t.segundonombre,' ',t.primerapellido,' ',t.segundoapellido) AS nombreemp, 
                                l.pagointereses, t.terid, l.cantidad, l.idliquidacion,   
                                (SELECT COUNT(*) 
                                   FROM liquidacion 
                                  WHERE liquidacion.terid = l.terid 
                                        AND liquidacion.periodonomina = '".$codperiodo."') AS numreg 
                           FROM terceros t
                                INNER JOIN liquidacion l ON (t.terid = l.terid)
                          WHERE l.periodonomina = '".$codperiodo."'
                                AND (l.tipo = 'cesantias' AND l.pagointereses>0)
                         HAVING numreg = 1
                         UNION
                         SELECT t.dni, CONCAT(t.primernombre,' ',t.segundonombre,' ',t.primerapellido,' ',t.segundoapellido) AS nombreemp, 
                                l.pagointereses, t.terid, l.cantidad, l.idliquidacion,   
                                (SELECT COUNT(*) 
                                   FROM liquidacion 
                                  WHERE liquidacion.terid = l.terid 
                                        AND liquidacion.periodonomina = '".$codperiodo."'
                                        AND liquidacion.tipo = 'cesantias') AS numreg 
                           FROM terceros t
                                INNER JOIN liquidacion l ON (t.terid = l.terid)
                          WHERE l.periodonomina = '".$codperiodo."'
                                AND (l.tipo = 'cesantias' AND l.pagointereses>0 AND l.pago = 0) ";

                if($tiponomina == "empleados")
                    $vsql.= " AND t.esempleadoactivo = 'CHECKED' AND t.extralegal = '' ";

                    // $vsql.= " AND (t.esempleadoactivo = 'CHECKED' AND t.extralegal = '' OR t.extralegal IS NULL)) ";

                if($tiponomina == "extralegal")
                    $vsql.= " AND t.extralegal = 'CHECKED' ";

                $vsql.= " HAVING numreg = 2";
            }
            else
            {
                $vsql = "SELECT t.dni, CONCAT(t.primernombre,' ',t.segundonombre,' ',t.primerapellido,' ',t.segundoapellido) AS nombreemp, 
                                p.dias, p.monto, p.idpagocesantia 
                           FROM terceros t
                                INNER JOIN pagocesantias p ON (t.terid = p.terid)
                          WHERE p.periodonomina = '".$codperiodo."'";            

                // Tipo de empleados
                switch($tiponomina)
                {
                    case 'empleados':
                        $vsql.= " AND (t.esempleadoactivo='CHECKED' AND (t.extralegal = '' OR t.extralegal IS NULL)) ";
                        break;
                    case 'extralegal':
                        $vsql.= " AND t.extralegal = 'CHECKED' ";
                        break;
                    default:
                        break;
                }
            }

            // Salida en vista html
            if($tiposalida=="vista")
            {
                $cont = $clase->Header("S","W");
                $cont.='<table width="100%">
                         <tr class="CabezoteTabla"> 
                          <td width="10"> &nbsp; </td>
                          <td width="37"> <img src="images/iconos/infventaspos.png" width="32" height="32" border="0"> </td>
                          <td width="840"> <b> Cesantías canceladas </b></td>
                          <td> &nbsp; </td>
                          <td width="8"> &nbsp; </td>
                         </tr>
                         <tr class="CabezoteTabla"> 
                          <td width="10"> &nbsp; </td>
                          <td width="37"> &nbsp; </td>
                          <td width="840"> <b> Periodo:</b> '.$desperiodo.' <b>Tipo:</b> '.strtoupper($tiponomina).' <b>Reporte:</b> '.strtoupper($tiporeporte).'</td>
                          <td> &nbsp; </td>
                          <td width="8"> &nbsp; </td>
                         </tr>
                        </table>';

                if($tiporeporte=="intereses")
                {
                    $cont.='<script type="text/javascript" src="lib/sorttable.js"></script>
                            <table width="100%" class="sortable">
                             <thead> 
                              <tr class="TituloTabla" style="display:block;padding-top:5px;height:25px;">
                               <td width="23"> &nbsp; </td>                           
                               <td width="143" align="left"> <p>Documento</p> </td>
                               <td width="794" align="left"> Nombre </td>			
                               <td width="184" align="right"> Monto </td>			
                               <td width="46"> &nbsp; </td>
                               <td width="26"> &nbsp; </td>
                              </tr>
                             </thead>
                             <tbody style="display:block; width:1050px; height:600px; overflow-Y:scroll">';
    
                    $i = 0;
                    $totalpagado = 0;
                    $monto = 0;
                    $conex  = $clase->Conectar();
                    $result = mysql_query($vsql,$conex);
                    while($row = mysql_fetch_array($result))
                    {
                        $i++;
                        if($i%2 == 0)
                            $cont.='<tr class="TablaDocsPar">';
                        else
                            $cont.='<tr class="TablaDocsImPar">';

                        $cantidad = $row['cantidad'];
                        $monto = $row['pagointereses'];

                        $cont.=' <td width="23">&nbsp;</td>
                                 <td width="143" align="left">'.$row['dni'].'</td>
                                 <td width="834" align="left">'.$row['nombreemp'].' </td>';

                        // echo "aaaaaa"; exit();

                        if(($_SESSION['USERNAME'] == "LFLOREZ")||($_SESSION['USERNAME'] == "SAIDRODRIGUEZ")||($_SESSION["SUPERUSUARIO"] == "CHECKED"))
                            $cont.=' <td width="20" align="center">
                                      <a href="?opcion=valborrarcesantia&tiporeporte='.$tiporeporte.'&id='.$row['idliquidacion'].'" rel="facebox" title="eliminar inter&eacute;s">
                                       <img src="images/basicas/iconoborrar.png" border="0">
                                      </a>
                                     </td>                        
                                     <td width="20" align="center">
                                      <a href="?opcion=editarcesantias&tiporeporte='.$tiporeporte.'&id='.$row['idliquidacion'].'" title="editar inter&eacute;s" rel="facebox">
                                       <img src="images/basicas/iconobuscar.png" border="0">
                                      </a>
                                     </td>';
                        else
                            $cont.=' <td width="20" align="center"> &nbsp; </td>                        
                                     <td width="20" align="center"> &nbsp; </td>';

                        $cont.=' <td width="104" align="right">'.number_format($monto).' </td>
                                 <td width="46" align="center">  
                                  <a href="cesantiasxperiodo.php?opcion=recibocesantias&terid='.$row['terid'].'&pagointereses='.$monto.'&cantidad='.$cantidad.'&codperiodo='.$codperiodo.'" target="_blank">
                                   <img src="images/basicas/pdf.png" title="Recibo" border="0">
                                  </a>
                                 </td>
                                </tr>';

                        // incremento del total
                        $totalpagado += $monto;
                    }
                }
                else
                {
                    $cont.='<script type="text/javascript" src="lib/sorttable.js"></script>
                            <table width="100%" class="sortable">
                             <thead> 
                              <tr class="TituloTabla" style="display:block;padding-top:5px;height:25px;">
                               <td width="23">&nbsp;</td>                           
                               <td width="143" align="left"><p>Documento</p></td>
                               <td width="884" align="left">Nombre </td>			
                               <td width="46">D&iacute;as</td>
                               <td width="94" align="right">Monto </td>
                               <td width="10">&nbsp;</td>
                               <td width="26">&nbsp;</td>
                              </tr>
                             </thead>
                             <tbody style="display:block; width:1050px; height:600px; overflow-Y:scroll">';                    

                    $i = 0;
                    $totalpagado = 0;
                    $monto = 0;
                    $conex  = $clase->Conectar();
                    $result = mysql_query($vsql,$conex);
                    while($row = mysql_fetch_array($result))
                    {
                        $i++;
                        if($i%2 == 0)
                            $cont.='<tr class="TablaDocsPar">';
                        else
                            $cont.='<tr class="TablaDocsImPar">';

                        $dias = $row['dias'];
                        $monto = $row['monto'];

                        $cont.=' <td width="23">&nbsp;</td>
                                 <td width="143" align="left">'.$row['dni'].'</td>
                                 <td width="834" align="left">'.$row['nombreemp'].' </td>';

                        if(($_SESSION['USERNAME'] == "LFLOREZ")||($_SESSION['USERNAME'] == "SAIDRODRIGUEZ")||($_SESSION["SUPERUSUARIO"] == "CHECKED"))
                                 $cont.=' <td width="20" align="center">
                                           <a href="?opcion=valborrarcesantia&tiporeporte='.$tiporeporte.'&id='.$row['idpagocesantia'].'" rel="facebox" title="eliminar inter&eacute;s">
                                            <img src="images/basicas/iconoborrar.png" border="0">
                                           </a>
                                          </td>                        
                                          <td width="20" align="center">
                                           <a href="?opcion=editarcesantias&tiporeporte='.$tiporeporte.'&id='.$row['idpagocesantia'].'" title="editar inter&eacute;s" rel="facebox">
                                            <img src="images/basicas/iconobuscar.png" border="0">
                                           </a>
                                          </td>';
                             else
                                 $cont.=' <td width="20" align="center"> &nbsp; </td>                        
                                          <td width="20" align="center"> &nbsp; </td>';

                        $cont.=' <td width="46" align="center"> '.number_format($dias).' </td>
                                 <td width="104" align="right">'.number_format($monto).' </td>
                                 <td width="10">&nbsp;</td>
                                </tr>';                        

                        // incremento del total
                        $totalpagado += $monto;
                    }
                }

                $cont.=' </tbody> 
                        </table>';

                // impresión del total
                $cont.='<table width="100%">
                         <tr class="TituloTabla"> 
                          <td width="391"> &nbsp; </td>
                          <td width="375" align="right"> &nbsp; </td>
                          <td width="375" align="right"> &nbsp; </td>
                          <td width="375" align="right"> <font color="WHITE"> <b> Total pagado: </b> '.number_format($totalpagado).' </font> </td>
                          <td width="92"> &nbsp; </td>
                         </tr>
                        </table>';                        

                echo $cont.$clase->PiePagina();
            }

            // vista en formato pdf
            if($tiposalida=="pdf")
            {
                // Traducción al español del mes que devuelve la función date()
                $mesimp = date('F');
                if($mesimp=="January")       $mesimp = "Enero";
                if($mesimp=="February")      $mesimp = "Febrero";
                if($mesimp=="March")         $mesimp = "Marzo";
                if($mesimp=="April")         $mesimp = "Abril";
                if($mesimp=="May")           $mesimp = "Mayo";
                if($mesimp=="June")          $mesimp = "Junio";
                if($mesimp=="July")          $mesimp = "Julio";
                if($mesimp=="August")        $mesimp = "Agosto";
                if($mesimp=="September")     $mesimp = "Septiembre";
                if($mesimp=="October")       $mesimp = "Octubre";
                if($mesimp=="November")      $mesimp = "Noviembre";
                if($mesimp=="December")      $mesimp = "Diciembre";

                $clase = new Sistema();
                ini_set("memory_limit","200M");
                require('lib/fpdf/fpdf.php');
                $pdf=new FPDF();

                $pdf->AddPage("");

                // Logo Dromedicas
                $pdf->Image('images/empresa/logo-dromedicas-en-azul.png',10,10,20,25,'PNG','');

                $x = 35;
                $y = 15;
                $pagina = 1;

                $pdf->SetFont('Arial','B',10);
                $enc= "DROMEDICAS DEL ORIENTE SAS - NIT: 900265730-0";
                $pdf->Text($x,$y,$enc);

                // Fecha y hora de impresión
                $fechoraimp = $mesimp." ".date('d')." de ".date('Y g:i a')."    Pagina: ".$pagina;

                $pdf->SetFont('Arial','',8);
                $pdf->Text($x+110,$y,$fechoraimp);

                if($tiporeporte=="intereses")
                {
                    $pdf->SetFont('Arial','B',10);
                    $enc= "CESANTIAS CANCELADAS EN EL PERIODO ".$desperiodo;
                    $pdf->Text($x,$y+7,$enc);
                    $enc= "TIPO: ".strtoupper($tiponomina);
                    $pdf->Text($x,$y+14,$enc);
                    $enc= "REPORTE: ".strtoupper($tiporeporte);
                    $pdf->Text($x,$y+21,$enc);
    
                    $pdf->SetFillColor(220,220,220);
                    $pdf->Rect(7,$y+28,195,8,'F');
    
                    $enc= "DOCUMENTO";                          $pdf->Text(9,$y+33,$enc);    
                    $enc= "NOMBRE";                             $pdf->Text(38,$y+33,$enc);    
                    $enc= "MONTO";                              $pdf->Text(185,$y+33,$enc);
    
                    $pdf->SetFont('Arial','',8);
    
                    // inicialización de variables
                    $x = 9;
                    $y = 56;
                    $i = 0;
    
                    $monto = 0;
                    $conex  = $clase->Conectar();
                    $result = mysql_query($vsql,$conex);
                    while($row = mysql_fetch_array($result))
                    {
                        $i++;

                        // Impresión de documento y nombre
                        $pdf->Text($x,$y,$row['dni']);
                        $pdf->Text($x+28,$y,$row['nombreemp']);
                        $monto = intval($row['pagointereses']);

                        // impresión del monto
                        $longitud = strlen($monto);
                        if($longitud==1)    $pdf->Text($x+189,$y,number_format($monto));
                        if($longitud==2)    $pdf->Text($x+187,$y,number_format($monto));
                        if($longitud==3)    $pdf->Text($x+185,$y,number_format($monto));
                        if($longitud==4)    $pdf->Text($x+183,$y,number_format($monto));
                        if($longitud==5)    $pdf->Text($x+181,$y,number_format($monto));
                        if($longitud==6)    $pdf->Text($x+179,$y,number_format($monto));
                        if($longitud==7)    $pdf->Text($x+177,$y,number_format($monto));
                        if($longitud==8)    $pdf->Text($x+175,$y,number_format($monto));

                        // salto de línea
                        $y+=6;

                        // incremento del total
                        $totalpagado += $monto;

                        if($i%35 == 0)
                        {
                            $pdf->AddPage("");

                            // Logo Dromedicas
                            $pdf->Image('images/empresa/logo-dromedicas-en-azul.png',10,10,20,25,'PNG','');

                            $x = 35;
                            $y = 15;
                            $pagina++;

                            $pdf->SetFont('Arial','B',10);
                            $enc= "DROMEDICAS DEL ORIENTE SAS - NIT: 900265730-0";
                            $pdf->Text($x,$y,$enc);
            
                            // Fecha y hora de impresión
                            $fechoraimp = $mesimp." ".date('d')." de ".date('Y g:i a')."    Pagina: ".$pagina;
            
                            $pdf->SetFont('Arial','',8);
                            $pdf->Text($x+110,$y,$fechoraimp);
            
                            $pdf->SetFont('Arial','B',10);
                            $enc= "CESANTIAS CANCELADAS EN EL PERIODO ".$desperiodo;                    $pdf->Text($x,$y+7,$enc);    
                            $enc= "TIPO: ".strtoupper($tiponomina);                                     $pdf->Text($x,$y+14,$enc);
                            $enc= "REPORTE: ".strtoupper($tiporeporte);                                 $pdf->Text($x,$y+21,$enc);                                
            
                            $pdf->SetFillColor(220,220,220);
                            $pdf->Rect(7,$y+28,195,8,'F');
            
                            $enc= "DOCUMENTO";                                                          $pdf->Text(9,$y+33,$enc);            
                            $enc= "NOMBRE";                                                             $pdf->Text(38,$y+33,$enc);            
                            $enc= "MONTO";                                                              $pdf->Text(185,$y+33,$enc);
            
                            $pdf->SetFont('Arial','',8);
            
                            // inicialización de variables
                            $x = 9;
                            $y = 56;
                        }
                    }
                }
                else
                {
                    $pdf->SetFont('Arial','B',10);
                    $enc= "CESANTIAS CANCELADAS EN EL PERIODO ".$desperiodo;
                    $pdf->Text($x,$y+7,$enc);
                    $enc= "TIPO: ".strtoupper($tiponomina);
                    $pdf->Text($x,$y+14,$enc);
                    $enc= "REPORTE: ".strtoupper($tiporeporte);
                    $pdf->Text($x,$y+21,$enc);

                    $pdf->SetFillColor(220,220,220);
                    $pdf->Rect(7,$y+28,195,8,'F');

                    $enc= "DOCUMENTO";                                      $pdf->Text(9,$y+33,$enc);    
                    $enc= "NOMBRE";                                         $pdf->Text(38,$y+33,$enc);
                    $enc= "DIAS";                                           $pdf->Text(155,$y+33,$enc);    
                    $enc= "MONTO";                                          $pdf->Text(185,$y+33,$enc);

                    $pdf->SetFont('Arial','',8);
    
                    // inicialización de variables
                    $x = 9;
                    $y = 56;
                    $i = 0;
    
                    $monto = 0;
                    $conex  = $clase->Conectar();
                    $result = mysql_query($vsql,$conex);
                    while($row = mysql_fetch_array($result))
                    {
                        $i++;
    
                        // Impresión de los datos
                        $pdf->Text($x,$y,$row['dni']);
                        $pdf->Text($x+28,$y,$row['nombreemp']);
                        
                        // impresion de los días
                        $dias = $row['dias'];
                        $longitud = strlen($dias);
                        if($longitud==1)    $pdf->Text($x+153,$y,number_format($dias));
                        if($longitud==2)    $pdf->Text($x+151,$y,number_format($dias));
                        if($longitud==3)    $pdf->Text($x+149,$y,number_format($dias));
                        
                        // impresión del monto
                        $monto = intval($row['monto']);
                        $longitud = strlen($monto);
                        if($longitud==1)    $pdf->Text($x+189,$y,number_format($monto));
                        if($longitud==2)    $pdf->Text($x+187,$y,number_format($monto));
                        if($longitud==3)    $pdf->Text($x+185,$y,number_format($monto));
                        if($longitud==4)    $pdf->Text($x+183,$y,number_format($monto));
                        if($longitud==5)    $pdf->Text($x+181,$y,number_format($monto));
                        if($longitud==6)    $pdf->Text($x+179,$y,number_format($monto));
                        if($longitud==7)    $pdf->Text($x+177,$y,number_format($monto));
                        if($longitud==8)    $pdf->Text($x+175,$y,number_format($monto));

                        // salto de línea
                        $y+=6;

                        // incremento del total
                        $totalpagado += $monto;

                        if($i%35 == 0)
                        {
                            $pdf->AddPage("");

                            // Logo Dromedicas
                            $pdf->Image('images/empresa/logo-dromedicas-en-azul.png',10,10,20,25,'PNG','');

                            $x = 35;
                            $y = 15;
                            $pagina++;

                            $pdf->SetFont('Arial','B',10);
                            $enc= "DROMEDICAS DEL ORIENTE SAS - NIT: 900265730-0";
                            $pdf->Text($x,$y,$enc);
            
                            // Fecha y hora de impresión
                            $fechoraimp = $mesimp." ".date('d')." de ".date('Y g:i a')."    Pagina: ".$pagina;

                            $pdf->SetFont('Arial','',8);
                            $pdf->Text($x+110,$y,$fechoraimp);                            

                            $pdf->SetFont('Arial','B',10);
                            $enc= "CESANTIAS CANCELADAS EN EL PERIODO ".$desperiodo;        $pdf->Text($x,$y+7,$enc);
                            $enc= "TIPO: ".strtoupper($tiponomina);                         $pdf->Text($x,$y+14,$enc);
                            $enc= "REPORTE: ".strtoupper($tiporeporte);                     $pdf->Text($x,$y+21,$enc);
        
                            $pdf->SetFillColor(220,220,220);
                            $pdf->Rect(7,$y+28,195,8,'F');
        
                            $enc= "DOCUMENTO";                                              $pdf->Text(9,$y+33,$enc);            
                            $enc= "NOMBRE";                                                 $pdf->Text(38,$y+33,$enc);        
                            $enc= "DIAS";                                                   $pdf->Text(155,$y+33,$enc);            
                            $enc= "MONTO";                                                  $pdf->Text(185,$y+33,$enc);
        
                            $pdf->SetFont('Arial','',8);

                            // inicialización de variables
                            $x = 9;
                            $y = 56;
                        }
                    }
                }
                
                // Impresión del total a pagar
                $y+=6;
                $pdf->SetFont('Arial','B',10);

                $pdf->SetFillColor(220,220,220);
                $pdf->Rect(7,$y-5,195,8,'F');
                
                $longitud = strlen($totalpagado);
                if($longitud==1)     $pdf->Text(164,$y,"TOTAL PAGADO: ".number_format($totalpagado,0));
                if($longitud==2)     $pdf->Text(162,$y,"TOTAL PAGADO: ".number_format($totalpagado,0));
                if($longitud==3)     $pdf->Text(160,$y,"TOTAL PAGADO: ".number_format($totalpagado,0));
                if($longitud==4)     $pdf->Text(158,$y,"TOTAL PAGADO: ".number_format($totalpagado,0));
                if($longitud==5)     $pdf->Text(156,$y,"TOTAL PAGADO: ".number_format($totalpagado,0));
                if($longitud==6)     $pdf->Text(154,$y,"TOTAL PAGADO: ".number_format($totalpagado,0));
                if($longitud==7)     $pdf->Text(152,$y,"TOTAL PAGADO: ".number_format($totalpagado,0));
                if($longitud==8)     $pdf->Text(150,$y,"TOTAL PAGADO: ".number_format($totalpagado,0));
                if($longitud==9)     $pdf->Text(148,$y,"TOTAL PAGADO: ".number_format($totalpagado,0));
                if($longitud==10)    $pdf->Text(146,$y,"TOTAL PAGADO: ".number_format($totalpagado,0));
                if($longitud==11)    $pdf->Text(144,$y,"TOTAL PAGADO: ".number_format($totalpagado,0));
                if($longitud==12)    $pdf->Text(142,$y,"TOTAL PAGADO: ".number_format($totalpagado,0));                
                if($longitud==13)    $pdf->Text(140,$y,"TOTAL PAGADO: ".number_format($totalpagado,0));

                $pdf->Output();
            }

            // salida a excel
            if($tiposalida=="excel")
            {
                require_once 'lib/PHPExcel.php';
                $clase = new Sistema();
                $clase->Conectar();
                ini_set("memory_limit","100M");

                // Preparación del entorno para la salida a Excel
                $clase = new Sistema();
                $clase->Nombredb = $_SESSION['DBNOMBRE'];
                error_reporting(E_ALL);
                ini_set('display_errors', TRUE);
                ini_set('display_startup_errors', TRUE);
                date_default_timezone_set('Europe/London');
            
                if (PHP_SAPI == 'cli')
                    die('This example should only be run from a Web Browser');
            
                // Create new PHPExcel object
                $objPHPExcel = new PHPExcel();
            
                // Set document properties
                $objPHPExcel->getProperties()->setCreator("Sistemas y Soluciones Web de Colombia")
                                             ->setLastModifiedBy("Sistemas y Soluciones Web de Colombia")
                                             ->setTitle("Cesantías por periodo - DROPOS")
                                             ->setSubject("Cesantías por periodo - DROPOS")
                                             ->setDescription("Cesantías por periodo - DROPOS")
                                             ->setKeywords("Cesantías por periodo - DROPOS")
                                             ->setCategory("Categoria General");                

                if($tiporeporte=="intereses")
                {
                    // encabezado
                    $objPHPExcel->setActiveSheetIndex(0)
                                ->setCellValue('A1', 'CESANTIAS CANCELADAS POR PERIODO')
                                ->setCellValue('A2', $desperiodo)
                                ->setCellValue('A3', 'TIPO: '.strtoupper($tiponomina))
                                ->setCellValue('A4', 'DOCUMENTO')
                                ->setCellValue('B4', 'NOMBRE')
                                ->setCellValue('C4', 'MONTO');
    
                    $objPHPExcel->getActiveSheet()->getColumnDimension('A')->setAutoSize(true);
                    $objPHPExcel->getActiveSheet()->getColumnDimension('B')->setAutoSize(true);
                    $objPHPExcel->getActiveSheet()->getColumnDimension('C')->setAutoSize(true);
    
                    $conex  = $clase->Conectar();
                    $result = mysql_query($vsql,$conex);
                    $cant   = mysql_num_rows($result);                
                    $i=5;
                    $totalpagado = 0;
                    $monto = 0;
                    
                    // Detalle del informe
                    while($row = mysql_fetch_array($result))
                    {
                        $monto = $row['pagointereses'];
                        
                        $objPHPExcel->setActiveSheetIndex(0)
                                    ->setCellValue('A'.$i, $row['dni'])
                                    ->setCellValue('B'.$i, $row['nombreemp'])
                                    ->setCellValue('C'.$i, number_format($monto));

                        $totalpagado += $monto;
                        $i++;
                    }
    
                    // Impresión del último total
                    $objPHPExcel->setActiveSheetIndex(0)
                                ->setCellValue('A'.$i, '')
                                ->setCellValue('B'.$i, 'TOTAL:')
                                ->setCellValue('C'.$i, number_format($totalpagado));
    
                    $rangoEncabezado = 'A4:C4';
                    $rangoCeldas     = 'A4:C'.($i-1);

                }
                else
                {
                    // encabezado
                    $objPHPExcel->setActiveSheetIndex(0)
                                ->setCellValue('A1', 'PAGOS DE CESANTIAS POR PERIODO')
                                ->setCellValue('A2', 'PERIODO: '.$desperiodo)
                                ->setCellValue('A3', 'TIPO: '.strtoupper($tiponomina))
                                ->setCellValue('A4', 'REPORTE'.strtoupper($tiporeporte))
                                ->setCellValue('A5', 'DOCUMENTO')
                                ->setCellValue('B5', 'NOMBRE')
                                ->setCellValue('C5', 'DIAS')
                                ->setCellValue('D5', 'MONTO');

                    $objPHPExcel->getActiveSheet()->getColumnDimension('A')->setAutoSize(true);        $objPHPExcel->getActiveSheet()->getColumnDimension('B')->setAutoSize(true);
                    $objPHPExcel->getActiveSheet()->getColumnDimension('C')->setAutoSize(true);        $objPHPExcel->getActiveSheet()->getColumnDimension('D')->setAutoSize(true);

                    $conex  = $clase->Conectar();
                    $result = mysql_query($vsql,$conex);
                    $cant   = mysql_num_rows($result);
                    $i=6;
                    $totalpagado = 0;
                    $monto = 0;                    

                    // Detalle del informe
                    while($row = mysql_fetch_array($result))
                    {
                        $monto = $row['monto'];
                            
                        $objPHPExcel->setActiveSheetIndex(0)
                                    ->setCellValue('A'.$i, $row['dni'])
                                    ->setCellValue('B'.$i, $row['nombreemp'])
                                    ->setCellValue('C'.$i, number_format($row['dias']))
                                    ->setCellValue('D'.$i, number_format($monto));

                        $totalpagado += $monto;
                        $i++;
                    }

                    $objPHPExcel->setActiveSheetIndex(0)
                                ->setCellValue('A'.$i, '')
                                ->setCellValue('B'.$i, 'TOTAL:')
                                ->setCellValue('D'.$i, number_format($totalpagado));

                    $rangoEncabezado = 'A4:C4';
                    $rangoCeldas     = 'A4:C'.($i-1);
                }

                // ----------------------------------------------------------------------------------------------------------------------------------------------------------- //                
                // Formato de Encabezado y Celdas
                $objPHPExcel->getActiveSheet()->getRowDimension('1')->setRowHeight(15);
                
                $EstiloCeldas = array(
                'borders' => array(
                    'allborders' => array(
                        'style' => PHPExcel_Style_Border::BORDER_THIN,
                        'color' => array('argb' => '00000000'),
                    ),
                    ),
                );
                // $objPHPExcel->getActiveSheet()->getStyle($rangoCeldas)->applyFromArray($EstiloCeldas);
                /// Formato de Encabezados 
                $EstiloEncabezado = array(
                'font' => array(
                    'bold' => true,
                ),
                'alignment' => array(
                    'horizontal' => PHPExcel_Style_Alignment::HORIZONTAL_CENTER,
                    'vertical' => PHPExcel_Style_Alignment::VERTICAL_CENTER,		
                ),
                'borders' => array(
                    'allborders' => array(
                        'style' => PHPExcel_Style_Border::BORDER_THIN,
                        'color' => array('argb' => '00000000'),
                    ),
                ),
                'fill' => array(
                    'type' => PHPExcel_Style_Fill::FILL_SOLID,
                    'rotation' => 90,
                    'startcolor' => array(
                        'argb' => '00FFFFCC',
                    ),
                    'endcolor' => array(
                        'argb' => 'FFFFFF',
                    ),
                    ),
                );
                // $objPHPExcel->getActiveSheet()->getStyle($rangoEncabezado)->applyFromArray($EstiloEncabezado);
                // Rename worksheet
                $objPHPExcel->getActiveSheet()->setTitle('Cesantias por periodo');
                // Set active sheet index to the first sheet, so Excel opens this as the first sheet
                $objPHPExcel->setActiveSheetIndex(0);
                // Redirect output to a client’s web browser (Excel5)
                header('Content-Type: application/vnd.ms-excel');
                // --------------------------------------------------------------------- //
                // header('Content-Disposition: attachment;filename="planillanom.xls"');
                $nombrearcexcel = "cesantias del periodo ".strtolower($desperiodo).".xls";
                header('Content-Disposition: attachment;filename='.$nombrearcexcel.'');
                // --------------------------------------------------------------------- //
                header('Cache-Control: max-age=0');
                /// Genero la Salida
                $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');
                $objWriter->save('php://output');
                exit;
            }
        }
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: recibocesantias
    // Creación: 20/01/2022		última modificación: 06/06/2024
    // Creador: Luis Flórez		modificado por: Luis Flórez
    // Descripción: Opción que genera el recibo de pago de la prima de un empleado
    // Última modificación: Exclusión de la sección y corrección de la impresión del año 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion=="recibocesantias")
    {
        $terid = $_GET['terid'];
        $pagointereses = $_GET['pagointereses'];
        $cantidad = $_GET['cantidad'];
        $codperiodo = $_GET['codperiodo'];        

        // El código del empleado
        $vsqldatos = "SELECT codvende FROM primasterceros WHERE terid = ".$terid." AND periodonomina = '".$codperiodo."' AND tipo = 'cesantias'";
        $codvende = $clase->SeleccionarUno($vsqldatos);
        $vsqldatos = "";

        // documento
        $vsqldatos = "SELECT dni FROM primasterceros WHERE terid = ".$terid." AND periodonomina = '".$codperiodo."' AND tipo = 'cesantias'";
        $dni = $clase->SeleccionarUno($vsqldatos);
        $vsqldatos = "";

        // sueldo básico
        $vsqldatos = "SELECT basico FROM primasterceros WHERE terid = ".$terid." AND periodonomina = '".$codperiodo."' AND tipo = 'cesantias'";
        $basico = $clase->SeleccionarUno($vsqldatos);
        $vsqldatos = "";        

        // Fecha de ingreso
        $vsqldatos = "SELECT fecingreso FROM primasterceros WHERE terid = ".$terid." AND periodonomina = '".$codperiodo."' AND tipo = 'cesantias'";
        $fecingreso = $clase->SeleccionarUno($vsqldatos);
        $fecingreso = substr($fecingreso,8,2)."/".substr($fecingreso,5,2)."/".substr($fecingreso,0,4);
        $vsqldatos = "";

        // El nombre del empleado
        $vsqldatos = "SELECT nombre
                        FROM primasterceros 
                       WHERE terid = ".$terid." 
                             AND periodonomina = '".$codperiodo."'
                             AND tipo = 'cesantias'";
        $nombreemp = $clase->SeleccionarUno($vsqldatos);
        $vsqldatos = "";

        // El cargo
        $vsqldatos = "SELECT c.descripcioncargo 
                        FROM primasterceros t
                             INNER JOIN cargos c ON (t.cargoid = c.cargoid) 
                       WHERE t.terid = ".$terid."
                             AND t.periodonomina = '".$codperiodo."'
                             AND t.tipo = 'cesantias'";
        $cargo = $clase->SeleccionarUno($vsqldatos);
        $vsqldatos = "";

        // La sección
        $vsqldatos = "SELECT s.descripcionsec 
                        FROM primasterceros t
                             INNER JOIN seccion s ON (t.seccionid = s.seccionid) 
                       WHERE t.terid = ".$terid."
                             AND t.periodonomina = '".$codperiodo."'
                             AND t.tipo = 'cesantias'";
        $seccion = $clase->SeleccionarUno($vsqldatos);
        $vsqldatos = "";

        // Determino si el empleado es de condición extralegal
        $vsqldatos = "SELECT extralegal FROM primasterceros WHERE terid = ".$terid." AND periodonomina = '".$codperiodo."' AND tipo = 'cesantias'";
        $extralegal = $clase->SeleccionarUno($vsqldatos);
        $vsqldatos = "";

        if($extralegal=="CHECKED")
            $area = "EXTRALEGALES";
        else
        {
            // El área
            $vsqldatos = "SELECT a.descripcionarea 
                            FROM primasterceros t
                                 INNER JOIN areanomina a ON (t.areaid = a.areaid) 
                           WHERE t.terid = ".$terid."
                                 AND t.periodonomina = '".$codperiodo."'
                                 AND t.tipo = 'cesantias'";
            $area = $clase->SeleccionarUno($vsqldatos);
            $vsqldatos = "";
        }

        // El banco
        $vsqldatos = "SELECT b.descripcion 
                        FROM primasterceros t
                             INNER JOIN bancos b ON (t.bancoid = b.bancoid) 
                       WHERE t.terid = ".$terid."
                             AND t.periodonomina = '".$codperiodo."'
                             AND t.tipo = 'cesantias'";
        $banco = $clase->SeleccionarUno($vsqldatos);
        $vsqldatos = "";

        // Número de cuenta bancaria
        $vsqldatos = "SELECT numcuenta FROM primasterceros WHERE terid = ".$terid." AND periodonomina = '".$codperiodo."' AND tipo = 'cesantias'";
        $numcuenta = $clase->SeleccionarUno($vsqldatos);
        $vsqldatos = "";

        // mes del periodo
        $mesper = substr($codperiodo,0,2);

        // año del periodo
        $yearperiodo = substr($codperiodo,-4);

        // Procedo a construir el encabezado del recibo
        $clase = new Sistema();
        ini_set("memory_limit","200M");
        require('lib/fpdf/fpdf.php');
        $pdf=new FPDF('L','mm','A6');       // Recibo a media página
    
        // Página nueva
        $pdf->AddPage("");
        $pagina = 1;

        // Traducción al español del mes que devuelve la función date()
        $mesimp = date('F');
        if($mesimp=="January")       $mesimp = "Enero";
        if($mesimp=="February")      $mesimp = "Febrero";
        if($mesimp=="March")         $mesimp = "Marzo";
        if($mesimp=="April")         $mesimp = "Abril";
        if($mesimp=="May")           $mesimp = "Mayo";
        if($mesimp=="June")          $mesimp = "Junio";
        if($mesimp=="July")          $mesimp = "Julio";
        if($mesimp=="August")        $mesimp = "Agosto";
        if($mesimp=="September")     $mesimp = "Septiembre";
        if($mesimp=="October")       $mesimp = "Octubre";
        if($mesimp=="November")      $mesimp = "Noviembre";
        if($mesimp=="December")      $mesimp = "Diciembre";

        // Fecha y hora de impresión
        $fechoraimp = $mesimp." ".date('d')." de ".date('Y g:i a')."    Pagina: ".$pagina;
        $pdf->SetFont('Arial','',8);
        $pdf->Text(147,14,$fechoraimp);

        // Logo Dromedicas
        $pdf->Image('images/empresa/logo-dromedicas-en-azul.png',10,10,20,25,'PNG','');

        $x = 35;
        $y = 15;
        $pdf->SetFont('Arial','B',10);                                      $enc= "COMPROBANTE DE PAGO";
        $pdf->Text($x,$y,$enc);
        $enc= "DROMEDICAS DEL ORIENTE SAS - NIT: 900265730-0";              $pdf->Text($x,$y+7,$enc);
        $enc= "NOMINA: ";                                                   $pdf->Text($x,$y+14,$enc);

        // Determino el nombre de la nómina
        $yeartoday = date("Y");
        $yeartoday--;
        $yearlast = intval(substr($yeartoday,-5));
        $nombnomina = "INTERESES DE CESANTIAS ";

        $pdf->SetFont('Arial','',10);
        // $enc=strtoupper($nombnomina).trim($yearlast);
        $enc=strtoupper($nombnomina).$yearperiodo;       

        $pdf->Text($x+18,$y+14,$enc);

        $x = 10;
        $y = 40;
        $pdf->SetFont('Arial','B',10);

        // Datos del empleado
        $enc= "CODIGO: ";                                   $pdf->Text($x,$y,$enc);

        $pdf->SetFont('Arial','',10);
        $enc=$codvende;                                     $pdf->Text($x+28,$y,$enc);

        $pdf->SetFont('Arial','B',10);
        $enc= "NOMBRE: ";                                   $pdf->Text($x+60,$y,$enc);

        $pdf->SetFont('Arial','',10);
        $enc=strtoupper($nombreemp);                        $pdf->Text($x+80,$y,$enc);

        $pdf->SetFont('Arial','B',10);
        $enc= "DOCUMENTO: ";                                $pdf->Text($x,$y+7,$enc);

        $pdf->SetFont('Arial','',10);
        $enc=$dni;                                          $pdf->Text($x+28,$y+7,$enc);

        $pdf->SetFont('Arial','B',10);
        $enc= "CARGO: ";                                    $pdf->Text($x+60,$y+7,$enc);

        $pdf->SetFont('Arial','',10);
        $enc=strtoupper($cargo);                            $pdf->Text($x+80,$y+7,$enc);

        $pdf->SetFont('Arial','B',10);
        $enc= "BASICO: ";                                   $pdf->Text($x,$y+14,$enc);

        $pdf->SetFont('Arial','',10);
        $enc=number_format($basico,2);                      $pdf->Text($x+28,$y+14,$enc);

        // $pdf->SetFont('Arial','B',10);
        // $enc= "SECCION: ";                                  $pdf->Text($x+60,$y+14,$enc);

        // $pdf->SetFont('Arial','',10);
        // $enc=strtoupper($seccion);                          $pdf->Text($x+80,$y+14,$enc);

        // $pdf->SetFont('Arial','B',10);
        // $enc= "FEC INGRESO: ";                              $pdf->Text($x,$y+21,$enc);

        // $pdf->SetFont('Arial','',10);
        // $enc=$fecingreso;                                   $pdf->Text($x+28,$y+21,$enc);

        $pdf->SetFont('Arial','B',10);
        $enc= "AREA: ";                                     $pdf->Text($x+60,$y+14,$enc);

        $pdf->SetFont('Arial','',10);
        $enc=strtoupper($area);                             $pdf->Text($x+80,$y+14,$enc);

        // Títulos del detalle
        $x = 10;
        $y = 68;
        $pdf->SetFillColor(220,220,220);
        $pdf->Rect(7,63,195,8,'F');
        $pdf->SetFont('Arial','B',9);
        $pdf->Text($x,$y,"CONCEPTO");
        $pdf->Text($x+20,$y,"");
        $pdf->Text($x+75,$y,"CANTIDAD");
        $pdf->Text($x+105,$y,"DEVENGADOS");
        $pdf->Text($x+135,$y,"DESCUENTOS");
        $pdf->Text($x+170,$y,"");

        // Detalle del recibo
        $x = 10;
        $y = 76;

        $pdf->SetFont('Arial','',8);
        $pdf->Text($x,$y,$nombnomina);

        // Alineación de los montos correspondientes a los días
        $longitud = strlen($cantidad);
        if($longitud==1)        $pdf->Text($x+90,$y,$cantidad);
        if($longitud==2)        $pdf->Text($x+88,$y,$cantidad);
        if($longitud==3)        $pdf->Text($x+86,$y,$cantidad);
        if($longitud==4)        $pdf->Text($x+84,$y,$cantidad);

        // Alineación de los montos correspondientes al pago de intereses
        $longitud = strlen($pagointereses);
        if($longitud==1)    $pdf->Text($x+126,$y,number_format($pagointereses,0));
        if($longitud==2)    $pdf->Text($x+124,$y,number_format($pagointereses,0));
        if($longitud==3)    $pdf->Text($x+122,$y,number_format($pagointereses,0));
        if($longitud==4)    $pdf->Text($x+120,$y,number_format($pagointereses,0));
        if($longitud==5)    $pdf->Text($x+118,$y,number_format($pagointereses,0));
        if($longitud==6)    $pdf->Text($x+117,$y,number_format($pagointereses,0));
        if($longitud==7)    $pdf->Text($x+115,$y,number_format($pagointereses,0));

        // salto de línea
        $y+=6;

        // Imprimo los totales
        $lineatotales = $y;
        $pdf->SetFillColor(220,220,220);
        $pdf->Rect(7,$lineatotales,195,8,'F');

        $pdf->SetFont('Arial','B',10);
        $pie= "TOTALES: ";
        $pdf->Text($x+70,$y+5,$pie);

        $pdf->SetFont('Arial','',8);
        
        // Alineación de los montos correspondientes
        if($longitud==1)    $pdf->Text($x+126,$y+5,number_format($pagointereses,0));
        if($longitud==2)    $pdf->Text($x+124,$y+5,number_format($pagointereses,0));
        if($longitud==3)    $pdf->Text($x+122,$y+5,number_format($pagointereses,0));
        if($longitud==4)    $pdf->Text($x+120,$y+5,number_format($pagointereses,0));
        if($longitud==5)    $pdf->Text($x+118,$y+5,number_format($pagointereses,0));
        if($longitud==6)    $pdf->Text($x+117,$y+5,number_format($pagointereses,0));
        if($longitud==7)    $pdf->Text($x+115,$y+5,number_format($pagointereses,0));        

        // Impresión del banco y cuenta a la cual se le consigna
        $pdf->SetFont('Arial','',8);
        $pie= "                                                                                                                                                                     __________________________";
        $pdf->Text($x,$y+35,$pie);
        $pie= "                                                                                                                                                                     RECIBI CONFORME";
        $pdf->Text($x,$y+40,$pie);

        if($extralegal=="CHECKED")
            $pie= "CONSIGNADO EN: EFECTIVO                                                                                                                  C.C.";
        else
        {
            if(($numcuenta=="")||($numcuenta==NULL))
                $pie= "CONSIGNADO EN: EFECTIVO                                                                                                                  C.C.";
            else
                $pie= "CONSIGNADO EN: ".strtoupper($banco)."                      CUENTA NO. ".$numcuenta."                            C.C.";
        }
        
        $pdf->Text($x,$y+45,$pie);
        $pdf->Output();
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: valborrarcesantia
    // Creación: 22/09/2022		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que pinta la confirmación de la eliminación de un pago o un 
    //              interés de cesantía
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////    
    if($opcion == "valborrarcesantia")
    {
        $tiporeporte = $_GET['tiporeporte'];        
        $id = $_GET['id'];

        if($tiporeporte=="intereses")
        {
            // Obtengo los datos
            $terid = $clase->BDLockup($id,'liquidacion','idliquidacion','terid');

            $vsql = "SELECT CONCAT(primernombre,' ',segundonombre,' ',primerapellido,' ',segundoapellido) AS nombreemp
                       FROM terceros
                      WHERE terid = ".$terid;
            $nombreemp = $clase->SeleccionarUno($vsql);

            $pagointereses = $clase->BDLockup($id,'liquidacion','idliquidacion','pagointereses');

            // Pinto la ventana
            $cont= '<table width="500">
                     <tr class="CabezoteTabla"> 
                      <td align="center"><br><b>Eliminar una cesant&iacute;a</b><br><br></td> 
                     </tr> 
                    </table>
                    <table width="500">
                     <tr class="TablaDocsImPar">       
                      <td width="400" align="center">¿Confirma que desea eliminar la cesant&iacute;a de <br> <b>'.$nombreemp.'</b> 
                       <br> por un monto de <b>'.number_format($pagointereses).'</b> pesos?
                      </td>
                     </tr>
                     <tr class="TablaDocsImPar">       
                      <td width="400" align="center"><br><br>                  
                       <form action="?opcion=elimcesantia&id='.$id.'&tiporeporte='.$tiporeporte.'" method="POST">
                       <input type="hidden" name="id" value="'.$id.'">
                       <input type="hidden" name="tiporeporte" value="'.$tiporeporte.'">
                       <input type="submit" value="ACEPTAR" class="button red">
                       </form>
                       <br>
                      </td>        
                     </tr>
                    </table><br>';
        }
        else
        {
            // Obtengo los datos
            $terid = $clase->BDLockup($id,'pagocesantias','idpagocesantia','terid');

            $vsql = "SELECT CONCAT(primernombre,' ',segundonombre,' ',primerapellido,' ',segundoapellido) AS nombreemp
                       FROM terceros
                      WHERE terid = ".$terid;
            $nombreemp = $clase->SeleccionarUno($vsql);

            $dias = $clase->BDLockup($id,'pagocesantias','idpagocesantia','dias');
            $monto = $clase->BDLockup($id,'pagocesantias','idpagocesantia','monto');

            // Pinto la ventana
            $cont=' <table width="500">
                     <tr class="CabezoteTabla"> 
                      <td align="center"><br><b>Eliminar una cesant&iacute;a</b><br><br></td> 
                     </tr> 
                    </table>
                    <table width="500">
                     <tr class="TablaDocsImPar">       
                      <td width="400" align="center">¿Confirma que desea eliminar la cesant&iacute;a de <br> <b>'.$nombreemp.'</b> 
                      <br> de <b>'.number_format($dias).'</b> d&iacute;as?
                      <br> por un monto de <b>'.number_format($monto).'</b> pesos?
                      </td>
                     </tr>
                     <tr class="TablaDocsImPar">       
                      <td width="400" align="center"><br><br>                  
                       <form action="?opcion=elimcesantia&id='.$id.'&tiporeporte='.$tiporeporte.'" method="POST">
                       <input type="hidden" name="id" value="'.$id.'">
                       <input type="hidden" name="tiporeporte" value="'.$tiporeporte.'">
                       <input type="submit" value="ACEPTAR" class="button red">
                       </form>
                       <br>
                      </td>        
                     </tr>
                    </table><br>';
        }

        echo $cont;
        exit();        
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opción: elimcesantia
    // Creación: 22/09/2022		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que elimina un pago o un interés de cesantía
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////        
    if($opcion == "elimcesantia")
    {
        $id = $_POST['id'];
        $tiporeporte = $_POST['tiporeporte'];

        if($tiporeporte=="intereses")
        {
            // Elimino la cesantía
            $vsql = "DELETE FROM liquidacion WHERE idliquidacion = ".$id;
            $clase->EjecutarSQL($vsql);
    
            // Emito el mensaje correspondiente
            if(mysql_affected_rows() >= 1)
                $clase->Aviso(1,"Cesantía eliminada satisfactoriamente");
            else
                $clase->Aviso(3,"No se eliminó la cesantía");
        }
        else
        {
            // Elimino el pago de cesantía
            $vsql = "DELETE FROM pagocesantias WHERE idpagocesantia = ".$id;
            $clase->EjecutarSQL($vsql);
    
            // Emito el mensaje correspondiente
            if(mysql_affected_rows() >= 1)
                $clase->Aviso(1,"Pago de cesantía eliminada satisfactoriamente");
            else
                $clase->Aviso(3,"No se eliminó el pago de cesantía");
        }

        // Redirecciono el formulario
        header("Location: cesantiasxperiodo.php?opcion=ventanadatos");
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opciones: editarcesantias
    // Creación: 22/09/2022		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción que pinta la ventana donde capto los datos que se modificarán
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////
    if($opcion == "editarcesantias")
    {
        $id = $_GET['id'];
        $tiporeporte = $_GET['tiporeporte'];

        if($tiporeporte=="intereses")
        {
            // Obtengo los datos
            $terid = $clase->BDLockup($id,'liquidacion','idliquidacion','terid');

            $vsql = "SELECT CONCAT(primernombre,' ',segundonombre,' ',primerapellido,' ',segundoapellido) AS nombreemp
                       FROM terceros
                      WHERE terid = ".$terid;
            $nombreemp = $clase->SeleccionarUno($vsql);

            $pagointereses = $clase->BDLockup($id,'liquidacion','idliquidacion','pagointereses');

            // Pinto la ventana
            $cont ='<table width="400">
                     <tr class="CabezoteTabla"> 
                      <td align="center"> <b>Editar cesant&iacute;a</b> </td>                  
                     </tr>
                     <tr class="CabezoteTabla"> 
                      <td align="center"> Empleado(a): '.$nombreemp.' </td>                  
                     </tr>
                    </table>
                    <form action="?opcion=almcesantia&id='.$id.'&tiporeporte='.$tiporeporte.'" method="POST" name="x">                
                    <input type="hidden" name="id" value="'.$id.'">
                    <input type="hidden" name="tiporeporte" value="'.$tiporeporte.'">                                  
                    <table width="400">
                     <center>
                     <br>
                     <tr class="TablaDocsImPar">				
                      <td width="150" align="right"> Monto: &nbsp;</td> 			  
                      <td width="250"> <input type="number" name="pagointereses" class="Texto12New" size="4" min="1" maxlength="4" autocomplete="off" value="'.$pagointereses.'"></td>
                     </tr>
                    </table>
                    <br>
                    <center>
                    <input type="submit" value="aceptar" class="button blue">
                    </form><br>';
        }
        else
        {
            // Obtengo los datos
            $terid = $clase->BDLockup($id,'pagocesantias','idpagocesantia','terid');

            $vsql = "SELECT CONCAT(primernombre,' ',segundonombre,' ',primerapellido,' ',segundoapellido) AS nombreemp
                       FROM terceros
                      WHERE terid = ".$terid;
            $nombreemp = $clase->SeleccionarUno($vsql);

            $dias = $clase->BDLockup($id,'pagocesantias','idpagocesantia','dias');
            $monto = $clase->BDLockup($id,'pagocesantias','idpagocesantia','monto');

            // Pinto la ventana
            $cont= '<table width="400">
                     <tr class="CabezoteTabla"> 
                      <td align="center"> <b>Editar cesant&iacute;a</b> </td>                  
                     </tr>
                     <tr class="CabezoteTabla"> 
                      <td align="center"> Empleado(a): '.$nombreemp.' </td>                  
                     </tr>
                    </table>
                    <form action="?opcion=almcesantia&id='.$id.'&tiporeporte='.$tiporeporte.'" method="POST" name="x">                
                    <input type="hidden" name="id" value="'.$id.'">
                    <input type="hidden" name="tiporeporte" value="'.$tiporeporte.'">                                  
                    <table width="400">
                     <center>
                     <br>
                     <tr class="TablaDocsImPar">				
                      <td width="150" align="right"> D&iacute;as &nbsp;</td> 			  
                      <td width="250"> <input type="number" name="dias" class="Texto12New" size="4" min="1" maxlength="4" autocomplete="off" value="'.$dias.'"></td>
                     </tr>
                     <tr class="TablaDocsImPar">				
                      <td width="150" align="right"> Monto: &nbsp;</td> 			  
                      <td width="250"> <input type="number" name="monto" class="Texto12New" size="4" min="1" maxlength="4" autocomplete="off" value="'.$monto.'"></td>
                     </tr>
                    </table>
                    <br>
                    <center>
                    <input type="submit" value="aceptar" class="button blue">
                    </form><br>';
        }
        echo $cont;
        exit();
    }

    ////////////////////////////////////////////////////////////////////////////////////////
    // Opciones: almcesantia
    // Creación: 22/09/2022		última modificación: 
    // Creador: Luis Flórez		modificado por: 
    // Descripción: Opción para almacenar la modificación realizada a un pago o un interés 
    //              de cesantía
    // Última modificación: 
    ////////////////////////////////////////////////////////////////////////////////////////    
    if($opcion == "almcesantia")
    {
        $id = $_POST['id'];
        $tiporeporte = $_POST['tiporeporte'];

        if($tiporeporte=="intereses")
        {
            $pagointereses = $_POST['pagointereses'];
            
            // Modifico el monto en la tabla
            $vsql = "UPDATE liquidacion SET pagointereses = ".$pagointereses." WHERE idliquidacion = ".$id;
            $clase->EjecutarSQL($vsql);

            // Emito el mensaje correspondiente
            if(mysql_affected_rows() >= 1)
                $clase->Aviso(1,"Interés de cesantía editado satisfactoriamente");
            else
                $clase->Aviso(3,"No se editó el interés de cesantía");
        }
        else
        {
            $dias = $_POST['dias'];
            $monto = $_POST['monto'];

            // Modifico el monto en la tabla
            $vsql = "UPDATE pagocesantias SET 
                            dias = ".$dias.", 
                            monto = ".$monto."
                      WHERE idpagocesantia = ".$id;
            $clase->EjecutarSQL($vsql);

            // Emito el mensaje correspondiente
            if(mysql_affected_rows() >= 1)
                $clase->Aviso(1,"Pago de cesantía editado satisfactoriamente");
            else
                $clase->Aviso(3,"No se editó el pago de cesantía");
        }

        // Redirecciono el formulario
        header("Location: cesantiasxperiodo.php?opcion=ventanadatos");
    }
?>