<!DOCTYPE html>
<html lang="es">
<head>
    <meta charset="UTF-8">
    <title>CRUD de Usuarios</title>
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <!-- Bootstrap CSS -->
    <link rel="stylesheet" href="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/css/bootstrap.min.css">
</head>
<body>
    <div class="container mt-4">
        
        <!-- Tabla para mostrar usuarios -->
        <div class="card">
            <div class="card-header"> 
                   <h4> Mis Productos con Existencias </h4>
            </div>
            <div class="card-body">
                <table class="table table-striped">
                    <thead>
                        <tr>
                            <th>Codigo</th>
                            <th>Nombre Producto</th>
                            <th align="right">Existencia</th>
                            <th> &nbsp; </th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php
                        // Incluir la biblioteca de funciones
                        include '../funciones_crud.php';
                        

                        // Leer todos los usuarios
                        $vsql = 'SELECT M.CODIGO , M.DESCRIP , MS.EXISTENC FROM MATERIAL M INNER JOIN MATERIALSUC MS ON (M.MATID = MS.MATID) WHERE MS.EXISTENC > 0 ORDER BY M.DESCRIP ASC';
                        $conn = conectarODBC("DSN-WEB-JE", "SYSDBA", "masterkey");
                        $usuarios = datosConsulta($conn, $vsql);

                        foreach ($usuarios as $usuario) {
                            echo "<tr>";
                            echo "<td>{$usuario['CODIGO']}</td>";
                            echo "<td>{$usuario['DESCRIP']}</td>";
                            echo "<td align='right'> <b>".number_format($usuario['EXISTENC'])." </b></td>";
                            echo "<td> &nbsp; </td>";
                            echo "</tr>";
                        }
                        odbc_close($conn);
                        ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>

    <!-- Bootstrap JS y dependencias opcionales -->
    <script src="https://code.jquery.com/jquery-3.5.1.slim.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@1.16.0/dist/umd/popper.min.js"></script>
    <script src="https://stackpath.bootstrapcdn.com/bootstrap/4.5.2/js/bootstrap.min.js"></script>
</body>
</html>
