<?php
require('../../config/functions.php');

$host     = '';
$dbname   = '';
$user     = '';
$password = '';
	
// Configuración de CORS
header('Access-Control-Allow-Origin: *'); // Permite conexiones desde cualquier origen
header('Access-Control-Allow-Methods: GET, POST, PUT, DELETE');
header('Access-Control-Allow-Headers: Content-Type, Authorization');

// Database credentials
loadconectionparams($host,$dbname,$user,$password);		
$pdo = new PDO("mysql:host=$host;dbname=$dbname;charset=utf8", $user, $password);
$pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);

if(!APIisactiva($pdo)) 
{ 
    http_response_code(401); // Unauthorized
    echo json_encode(['message' => 'API se encuentra Inactiva en este momento']);	
    exit;
} 

// API Endpoints
if (authenticate()) { // Check authentication before processing requests

    try {        

        // Get Request Method
        $method = $_SERVER['REQUEST_METHOD'];

        switch ($method) {
            case 'GET': // Read (all or single)
                if (isset($_GET['dni'])) {
                    // echo "++++++"; exit();
                    $id = $_GET['dni'];
                    $stmt = $pdo->prepare('SELECT direccion, recomendado, fecnaci, email, telmovil FROM seleccionvacantes WHERE dni = :id');
                    $stmt->execute(['id' => $id]);
                    $result = $stmt->fetchAll(PDO::FETCH_ASSOC);
                } 
                
                // else 
                // {
                //     if (isset($_GET['dni'])) {
                //         $id = $_GET['dni'];
                //         $stmt = $pdo->prepare('SELECT direccion, recomendado, fecnaci, email, telmovil FROM seleccionvacantes WHERE dni = :id');
                //         $stmt->execute(['id' => $id]);
                //         $result = $stmt->fetch(PDO::FETCH_ASSOC);
                //     } else {
                //         $stmt = $pdo->query("SELECT * FROM seleccionvacantes");
                //         $result = $stmt->fetchAll(PDO::FETCH_ASSOC);
                //     }
                // }

                // $stmt = $pdo->query("SELECT MAX(codvende) codvende FROM terceros WHERE CAST(codvende AS INT) > 4802");
                // $result = $stmt->fetchAll(PDO::FETCH_ASSOC);                

                header('Content-Type: application/json');
                echo json_encode($result);
                break;

            // case 'POST': // Create
            //     $data = json_decode(file_get_contents("php://input"), true);
            //     // echo $data[0]['idvacante']."+++++"; 
            //     $i=0;
            //     while($data[$i]['idvacante'])
            //     {
            //         // echo"***". $data[$i]['idvacante']; exit();

            //         $stmt = $pdo->prepare('INSERT INTO seleccionvacantes (idvacante,dni,nombre,hojadevida,documentoentregados,fechaentrevista,fechaaceptado,estado,observacion,codvende,terid) 
            //                                                        VALUES (:idvacante,:dni,:nombre,:hojadevida,:documentoentregados,:fechaentrevista,:fechaaceptado,:estado,:observacion,:codvende,:terid)');
                    
            //         $stmt->execute(['idvacante' =>  $data[$i]['idvacante'], 'dni' =>  $data[$i]['dni'], 'nombre' =>  $data[$i]['nombre'], 'hojadevida' =>  $data[$i]['hojadevida'], 'documentoentregados' =>  
            //                          $data[$i]['documentoentregados'], 'fechaentrevista' =>  $data[$i]['fechaentrevista'], 'fechaaceptado' =>  $data[$i]['fechaaceptado'], 'estado' =>  $data[$i]['estado'], 
            //                          'observacion' =>  $data[$i]['observacion'], 'codvende' =>  $data[$i]['codvende'], 'terid' =>  $data[$i]['terid']]);
            //         $i++;
            //     }        

            //     header('Content-Type: application/json');
            //     echo json_encode(['message' => 'Se han Creados '.$i.' Registros  con Exito']);
            //     break;

            // // case 'PUT': // Update
            // //     if (isset($_GET['id'])) {
            // //         $data = json_decode(file_get_contents("php://input"), true);
            // //         //// Validaciones
            // //         $stmt = $pdo->prepare('UPDATE seleccionvacantes SET idconceto = :idconceto , descripcion = :descripcion WHERE idmotivo = :idmotivo');
            // //         $stmt->execute(['idconceto' => $data['idconceto'], 'descripcion' => $data['descripcion'], 'idmotivo' => $data['idmotivo']]);
            // //         header('Content-Type: application/json');
            // //         echo json_encode(['message' => 'Record updated']);
            // //     } else {
            // //         http_response_code(400); // Bad Request
            // //         echo json_encode(['message' => 'idmotivo ID is required for update']);
            // //     }
            // //     break;

            // case 'DELETE': // Delete
            //     if (isset($_GET['id'])) {
            //         $stmt = $pdo->prepare('DELETE FROM seleccionvacantes WHERE idseleccion = :id');
            //         $stmt->execute(['id' => $_GET['id']]);
            //         header('Content-Type: application/json');
            //         echo json_encode(['message' => 'Record deleted']);
            //     } else {
            //         http_response_code(400); // Bad Request
            //         echo json_encode(['message' => 'idmotivo ID is required for delete']);
            //     }
            //     break;

            default:
                http_response_code(405); // Method Not Allowed
                echo json_encode(['message' => 'Method not allowed']);
                break;
        }

    } catch (PDOException $e) {
        http_response_code(500); // Internal Server Error
        echo json_encode(['message' => 'Database error: ' . $e->getMessage()]);
		exit;
    }
	
} else {
    http_response_code(401); // Unauthorized
    echo json_encode(['message' => 'Authentication failed']);
	exit;
}

?>