<?php
class Bodega {
    private $pdo;

    public function __construct($pdo) {
        $this->pdo = $pdo;
    }

    public function getAll() {
        $stmt = $this->pdo->query("SELECT * FROM bodegas");
        return $stmt->fetchAll(PDO::FETCH_ASSOC);
    }

    public function getById($id) {
        $stmt = $this->pdo->prepare("SELECT * FROM bodegas WHERE bodegaid = :id");
        $stmt->execute(['id' => $id]);
        return $stmt->fetch(PDO::FETCH_ASSOC);
    }

    public function create($data) {
        $stmt = $this->pdo->prepare("INSERT INTO bodegas (codbodega, nombodega, nomcorto, tipobodega, remidestino, sucursalid, activa, bodespecial, bodprincipal, visibletodos, tipoexistencia, orden) VALUES (:codbodega, :nombodega, :nomcorto, :tipobodega, :remidestino, :sucursalid, :activa, :bodespecial, :bodprincipal, :visibletodos, :tipoexistencia, :orden)");
        return $stmt->execute($data);
    }

    public function update($id, $data) {
        $data['id'] = $id;
        $stmt = $this->pdo->prepare("UPDATE bodegas SET codbodega = :codbodega, nombodega = :nombodega, nomcorto = :nomcorto, tipobodega = :tipobodega, remidestino = :remidestino, sucursalid = :sucursalid, activa = :activa, bodespecial = :bodespecial, bodprincipal = :bodprincipal, visibletodos = :visibletodos, tipoexistencia = :tipoexistencia, orden = :orden WHERE bodegaid = :id");
        return $stmt->execute($data);
    }

    public function delete($id) {
        $stmt = $this->pdo->prepare("DELETE FROM bodegas WHERE bodegaid = :id");
        return $stmt->execute(['id' => $id]);
    }
}
?>