<?php
header("Content-Type: application/json");
require 'config.php';
require 'Consecutivo.php';

$consecutivo = new Consecutivo($pdo);

$method = $_SERVER['REQUEST_METHOD'];
$request = explode('/', trim($_SERVER['PATH_INFO'], '/'));

switch ($method) {
    case 'GET':
        if (isset($request[0]) && is_numeric($request[0])) {
            echo json_encode($consecutivo->getById($request[0]));
        } else {
            echo json_encode($consecutivo->getAll());
        }
        break;
        
    case 'POST':
        $data = json_decode(file_get_contents('php://input'), true);
        $consecutivo->create($data);
        echo json_encode(['message' => 'Consecutivo creado']);
        break;
        
    case 'PUT':
        if (isset($request[0]) && is_numeric($request[0])) {
            $data = json_decode(file_get_contents('php://input'), true);
            $consecutivo->update($request[0], $data);
            echo json_encode(['message' => 'Consecutivo actualizado']);
        }
        break;
        
    case 'DELETE':
        if (isset($request[0]) && is_numeric($request[0])) {
            $consecutivo->delete($request[0]);
            echo json_encode(['message' => 'Consecutivo eliminado']);
        }
        break;
        
    default:
        http_response_code(405);
        echo json_encode(['error' => 'Método no permitido']);
        break;
}
?>